/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.JComponent;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.ease.Linear;
import org.pushingpixels.trident.ease.TimelineEase;

public class DisplayMulti
extends JComponent
implements ComponentListener {
    private LcdColor lcdColor = LcdColor.WHITE_LCD;
    private double value = 0.0;
    private double oldValue = 0.0;
    private static final String VALUE_PROPERTY = "value";
    private int lcdDecimals = 1;
    private String unitString = "unit";
    private boolean unitStringVisible = true;
    private boolean digitalFont = false;
    private Font lcdValueFont;
    private Font lcdFormerValueFont;
    private Font lcdUnitFont;
    private final Font LCD_STANDARD_FONT = new Font("Verdana", 1, 30);
    private final Font LCD_DIGITAL_FONT = Util.INSTANCE.getDigitalFont().deriveFont(24);
    private BufferedImage lcdImage;
    private final Timeline TIMELINE = new Timeline((Object)this);
    private final TimelineEase EASING = new Linear();

    public DisplayMulti() {
        this.addComponentListener(this);
        this.setMinimumSize(new Dimension(64, 32));
        this.setPreferredSize(new Dimension(128, 64));
        this.setSize(this.getPreferredSize());
        this.init(this.getWidth(), this.getHeight());
    }

    public final void init(int n, int n2) {
        this.lcdImage = this.create_LCD_Image(n, n2);
        if (this.isDigitalFont()) {
            this.lcdValueFont = this.LCD_DIGITAL_FONT.deriveFont(0.5f * (float)this.getHeight());
            this.lcdUnitFont = this.LCD_STANDARD_FONT.deriveFont(0.1875f * (float)this.getHeight());
            this.lcdFormerValueFont = this.LCD_DIGITAL_FONT.deriveFont(0.2f * (float)this.getHeight());
        } else {
            this.lcdValueFont = this.LCD_STANDARD_FONT.deriveFont(0.46875f * (float)this.getHeight());
            this.lcdUnitFont = this.LCD_STANDARD_FONT.deriveFont(0.1875f * (float)this.getHeight());
            this.lcdFormerValueFont = this.LCD_STANDARD_FONT.deriveFont(0.1875f * (float)this.getHeight());
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        double d;
        Rectangle2D rectangle2D;
        TextLayout textLayout;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.drawImage((Image)this.lcdImage, 0, 0, null);
        graphics2D.setColor(this.lcdColor.TEXT_COLOR);
        graphics2D.setFont(this.lcdUnitFont);
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        if (this.unitStringVisible) {
            textLayout = new TextLayout(this.unitString, graphics2D.getFont(), fontRenderContext);
            rectangle2D = textLayout.getBounds();
            graphics2D.drawString(this.unitString, (int)((double)this.lcdImage.getWidth() - rectangle2D.getWidth() - (double)((float)this.lcdImage.getWidth() * 0.03f)), (int)((float)this.lcdImage.getHeight() * 0.6f));
            d = rectangle2D.getWidth();
        } else {
            d = 0.0;
        }
        graphics2D.setFont(this.lcdValueFont);
        textLayout = new TextLayout(this.formatLcdValue(this.value), graphics2D.getFont(), fontRenderContext);
        rectangle2D = textLayout.getBounds();
        graphics2D.drawString(this.formatLcdValue(this.value), (int)((double)this.lcdImage.getWidth() - d - rectangle2D.getWidth() - (double)this.lcdImage.getWidth() * 0.09), (int)((float)this.lcdImage.getHeight() * 0.6f));
        graphics2D.setFont(this.lcdFormerValueFont);
        TextLayout textLayout2 = new TextLayout(this.formatLcdValue(this.oldValue), graphics2D.getFont(), fontRenderContext);
        Rectangle2D rectangle2D2 = textLayout2.getBounds();
        graphics2D.drawString(this.formatLcdValue(this.oldValue), (int)(((double)this.lcdImage.getWidth() - rectangle2D2.getWidth()) / 2.0), (int)((float)this.lcdImage.getHeight() * 0.9f));
        graphics2D.dispose();
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.oldValue = this.value;
        this.value = d;
        this.firePropertyChange(VALUE_PROPERTY, this.oldValue, d);
        this.repaint();
    }

    public void setValueAnimated(double d) {
        if (this.TIMELINE.getState() != Timeline.TimelineState.IDLE) {
            this.TIMELINE.abort();
        }
        this.TIMELINE.addPropertyToInterpolate(VALUE_PROPERTY, (Object)this.value, (Object)d);
        this.TIMELINE.setEase(this.EASING);
        this.TIMELINE.setDuration(2000L);
        this.TIMELINE.play();
    }

    public int getLcdDecimals() {
        return this.lcdDecimals;
    }

    public void setLcdDecimals(int n) {
        this.lcdDecimals = n;
        this.repaint();
    }

    public String getUnitString() {
        return this.unitString;
    }

    public void setUnitString(String string) {
        this.unitString = string;
        this.repaint();
    }

    public boolean isUnitStringVisible() {
        return this.unitStringVisible;
    }

    public void setUnitStringVisible(boolean bl) {
        this.unitStringVisible = bl;
        this.repaint();
    }

    public boolean isDigitalFont() {
        return this.digitalFont;
    }

    public void setDigitalFont(boolean bl) {
        this.digitalFont = bl;
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    public LcdColor getLcdColor() {
        return this.lcdColor;
    }

    public void setLcdColor(LcdColor lcdColor) {
        this.lcdColor = lcdColor;
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    public String formatLcdValue(double d) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("0");
        if (this.lcdDecimals > 0) {
            stringBuilder.append(".");
        }
        for (int i = 0; i < this.lcdDecimals; ++i) {
            stringBuilder.append("0");
        }
        DecimalFormat decimalFormat = new DecimalFormat(stringBuilder.toString(), new DecimalFormatSymbols(Locale.US));
        return decimalFormat.format(d);
    }

    private BufferedImage create_LCD_Image(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        Point2D.Double double_2 = new Point2D.Double(0.0, n4);
        float[] fArray = new float[]{0.0f, 0.08f, 0.92f, 1.0f};
        Color[] colorArray = new Color[]{new Color(0.4f, 0.4f, 0.4f, 1.0f), new Color(0.5f, 0.5f, 0.5f, 1.0f), new Color(0.5f, 0.5f, 0.5f, 1.0f), new Color(0.9f, 0.9f, 0.9f, 1.0f)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        double d = (float)n3 * 0.078125f;
        RoundRectangle2D.Double double_3 = new RoundRectangle2D.Double(0.0, 0.0, n3, n4, d, d);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_3);
        Point2D.Double double_4 = new Point2D.Double(0.0, 1.0);
        Point2D.Double double_5 = new Point2D.Double(0.0, n4 - 1);
        float[] fArray2 = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] colorArray2 = new Color[]{this.lcdColor.GRADIENT_START_COLOR, this.lcdColor.GRADIENT_FRACTION1_COLOR, this.lcdColor.GRADIENT_FRACTION2_COLOR, this.lcdColor.GRADIENT_FRACTION3_COLOR, this.lcdColor.GRADIENT_STOP_COLOR};
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_4, double_5, fArray2, colorArray2);
        double d2 = d - (((RectangularShape)double_3).getWidth() - (double)n3 - 2.0) / 2.0;
        RoundRectangle2D.Double double_6 = new RoundRectangle2D.Double(1.0, 1.0, n3 - 2, n4 - 2, d2, d2);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(double_6);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public Dimension getSize() {
        if (this.getWidth() < this.getMinimumSize().width || this.getHeight() < this.getMinimumSize().height) {
            return this.getMinimumSize();
        }
        return super.getSize();
    }

    @Override
    public Dimension getSize(Dimension dimension) {
        if (this.getWidth() < this.getMinimumSize().width || this.getHeight() < this.getMinimumSize().height) {
            return this.getMinimumSize();
        }
        return super.getSize(dimension);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.getWidth() < this.getMinimumSize().width || this.getHeight() < this.getMinimumSize().height) {
            this.setPreferredSize(this.getMinimumSize());
            this.setSize(this.getMinimumSize());
        }
        this.setSize(this.getWidth(), this.getHeight());
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public String toString() {
        return "DisplayMulti";
    }
}

