/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.tools.BackgroundColor;
import eu.hansolo.steelseries.tools.ConicalGradientPaint;
import eu.hansolo.steelseries.tools.FrameDesign;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.JComponent;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.ease.Linear;
import org.pushingpixels.trident.ease.TimelineEase;

public class DisplayCircular
extends JComponent
implements ComponentListener {
    private BackgroundColor backgroundColor = BackgroundColor.DARK_GRAY;
    private FrameDesign frameDesign = FrameDesign.METAL;
    private BufferedImage backgroundImage;
    private BufferedImage foregroundImage;
    private LcdColor lcdColor = LcdColor.WHITE_LCD;
    private double value = 0.0;
    private double oldValue = 0.0;
    private static final String VALUE_PROPERTY = "value";
    private int lcdDecimals = 1;
    private String unitString = "unit";
    private boolean unitStringVisible = true;
    private boolean digitalFont = false;
    private Font lcdValueFont;
    private Font lcdFormerValueFont;
    private Font lcdUnitFont;
    private final Font LCD_STANDARD_FONT = new Font("Verdana", 1, 30);
    private final Font LCD_DIGITAL_FONT = Util.INSTANCE.getDigitalFont().deriveFont(24);
    private BufferedImage lcdImage;
    private final Timeline TIMELINE = new Timeline((Object)this);
    private final TimelineEase EASING = new Linear();

    public DisplayCircular() {
        this.addComponentListener(this);
        this.setPreferredSize(new Dimension(140, 140));
        this.setSize(this.getPreferredSize());
        this.init(this.getWidth(), this.getWidth());
    }

    public final void init(int n, int n2) {
        this.backgroundImage = this.create_BACKGROUND_Image(n);
        this.lcdImage = this.create_LCD_Image((int)((float)n * 0.6542056f), (int)((float)n2 * 0.2990654f));
        if (this.isDigitalFont()) {
            this.lcdValueFont = this.LCD_DIGITAL_FONT.deriveFont(0.5f * (float)this.lcdImage.getHeight());
            this.lcdUnitFont = this.LCD_STANDARD_FONT.deriveFont(0.1875f * (float)this.lcdImage.getHeight());
            this.lcdFormerValueFont = this.LCD_DIGITAL_FONT.deriveFont(0.2f * (float)this.lcdImage.getHeight());
        } else {
            this.lcdValueFont = this.LCD_STANDARD_FONT.deriveFont(0.46875f * (float)this.lcdImage.getHeight());
            this.lcdUnitFont = this.LCD_STANDARD_FONT.deriveFont(0.1875f * (float)this.lcdImage.getHeight());
            this.lcdFormerValueFont = this.LCD_STANDARD_FONT.deriveFont(0.1875f * (float)this.lcdImage.getHeight());
        }
        this.foregroundImage = this.create_FOREGROUND_Image(n);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        double d;
        Rectangle2D rectangle2D;
        TextLayout textLayout;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.drawImage((Image)this.backgroundImage, 0, 0, null);
        graphics2D.drawImage((Image)this.lcdImage, (int)((float)this.backgroundImage.getWidth() * 0.17289719f), (int)((float)this.backgroundImage.getHeight() * 0.3504673f), null);
        graphics2D.setColor(this.lcdColor.TEXT_COLOR);
        graphics2D.setFont(this.lcdUnitFont);
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        if (this.unitStringVisible) {
            textLayout = new TextLayout(this.unitString, graphics2D.getFont(), fontRenderContext);
            rectangle2D = textLayout.getBounds();
            graphics2D.drawString(this.unitString, (int)((float)this.backgroundImage.getWidth() * 0.17289719f) + (int)((double)this.lcdImage.getWidth() - rectangle2D.getWidth() - (double)((float)this.lcdImage.getWidth() * 0.03f)), (int)((float)this.backgroundImage.getHeight() * 0.3504673f) + (int)((float)this.lcdImage.getHeight() * 0.6f));
            d = rectangle2D.getWidth();
        } else {
            d = 0.0;
        }
        graphics2D.setFont(this.lcdValueFont);
        textLayout = new TextLayout(this.formatLcdValue(this.value), graphics2D.getFont(), fontRenderContext);
        rectangle2D = textLayout.getBounds();
        graphics2D.drawString(this.formatLcdValue(this.value), (int)((float)this.backgroundImage.getWidth() * 0.17289719f) + (int)((double)this.lcdImage.getWidth() - d - rectangle2D.getWidth() - (double)this.lcdImage.getWidth() * 0.09), (int)((float)this.backgroundImage.getHeight() * 0.3504673f) + (int)((float)this.lcdImage.getHeight() * 0.6f));
        graphics2D.setFont(this.lcdFormerValueFont);
        TextLayout textLayout2 = new TextLayout(this.formatLcdValue(this.oldValue), graphics2D.getFont(), fontRenderContext);
        Rectangle2D rectangle2D2 = textLayout2.getBounds();
        graphics2D.drawString(this.formatLcdValue(this.oldValue), (int)((float)this.backgroundImage.getWidth() * 0.17289719f) + (int)(((double)this.lcdImage.getWidth() - rectangle2D2.getWidth()) / 2.0), (int)((float)this.backgroundImage.getHeight() * 0.3504673f) + (int)((float)this.lcdImage.getHeight() * 0.9f));
        graphics2D.drawImage((Image)this.foregroundImage, 0, 0, null);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.oldValue = this.value;
        this.value = d;
        this.firePropertyChange(VALUE_PROPERTY, this.oldValue, d);
        this.repaint();
    }

    public void setValueAnimated(double d) {
        if (this.TIMELINE.getState() != Timeline.TimelineState.IDLE) {
            this.TIMELINE.abort();
        }
        this.TIMELINE.addPropertyToInterpolate(VALUE_PROPERTY, (Object)this.value, (Object)d);
        this.TIMELINE.setEase(this.EASING);
        this.TIMELINE.setDuration(2000L);
        this.TIMELINE.play();
    }

    public int getLcdDecimals() {
        return this.lcdDecimals;
    }

    public void setLcdDecimals(int n) {
        this.lcdDecimals = n;
        this.repaint();
    }

    public String getUnitString() {
        return this.unitString;
    }

    public void setUnitString(String string) {
        this.unitString = string;
        this.repaint();
    }

    public boolean isUnitStringVisible() {
        return this.unitStringVisible;
    }

    public void setUnitStringVisible(boolean bl) {
        this.unitStringVisible = bl;
        this.repaint();
    }

    public boolean isDigitalFont() {
        return this.digitalFont;
    }

    public void setDigitalFont(boolean bl) {
        this.digitalFont = bl;
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    public LcdColor getLcdColor() {
        return this.lcdColor;
    }

    public void setLcdColor(LcdColor lcdColor) {
        this.lcdColor = lcdColor;
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    public String formatLcdValue(double d) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("0");
        if (this.lcdDecimals > 0) {
            stringBuilder.append(".");
        }
        for (int i = 0; i < this.lcdDecimals; ++i) {
            stringBuilder.append("0");
        }
        DecimalFormat decimalFormat = new DecimalFormat(stringBuilder.toString(), new DecimalFormatSymbols(Locale.US));
        return decimalFormat.format(d);
    }

    private BufferedImage create_LCD_Image(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        Point2D.Double double_2 = new Point2D.Double(0.0, n4);
        float[] fArray = new float[]{0.0f, 0.08f, 0.92f, 1.0f};
        Color[] colorArray = new Color[]{new Color(0.4f, 0.4f, 0.4f, 1.0f), new Color(0.5f, 0.5f, 0.5f, 1.0f), new Color(0.5f, 0.5f, 0.5f, 1.0f), new Color(0.9f, 0.9f, 0.9f, 1.0f)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        double d = (float)n3 * 0.078125f;
        RoundRectangle2D.Double double_3 = new RoundRectangle2D.Double(0.0, 0.0, n3, n4, d, d);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_3);
        Point2D.Double double_4 = new Point2D.Double(0.0, 1.0);
        Point2D.Double double_5 = new Point2D.Double(0.0, n4 - 1);
        float[] fArray2 = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] colorArray2 = new Color[]{this.lcdColor.GRADIENT_START_COLOR, this.lcdColor.GRADIENT_FRACTION1_COLOR, this.lcdColor.GRADIENT_FRACTION2_COLOR, this.lcdColor.GRADIENT_FRACTION3_COLOR, this.lcdColor.GRADIENT_STOP_COLOR};
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_4, double_5, fArray2, colorArray2);
        double d2 = d - (((RectangularShape)double_3).getWidth() - (double)n3 - 2.0) / 2.0;
        RoundRectangle2D.Double double_6 = new RoundRectangle2D.Double(1.0, 1.0, n3 - 2, n4 - 2, d2, d2);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(double_6);
        graphics2D.dispose();
        return bufferedImage;
    }

    public BackgroundColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(BackgroundColor backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    public FrameDesign getFrameDesign() {
        return this.frameDesign;
    }

    public void setFrameDesign(FrameDesign frameDesign) {
        this.frameDesign = frameDesign;
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    protected BufferedImage create_BACKGROUND_Image(int n) {
        Paint paint;
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double((double)n2 * 0.0, (double)n3 * 0.0, (double)n2 * 1.0, (double)n3 * 1.0);
        Color color = new Color(0x848484);
        graphics2D.setColor(color);
        graphics2D.fill(double_);
        Ellipse2D.Double double_2 = new Ellipse2D.Double((double)n2 * 0.004672897048294544, (double)n3 * 0.004672897048294544, (double)n2 * 0.9906542301177979, (double)n3 * 0.9906542301177979);
        Point2D.Double double_3 = new Point2D.Double(0.0, double_2.getBounds2D().getMinY());
        Point2D.Double double_4 = new Point2D.Double(0.0, double_2.getBounds2D().getMaxY());
        Point2D.Double double_5 = new Point2D.Double(double_2.getCenterX(), double_2.getCenterY());
        switch (this.frameDesign) {
            case BLACK_METAL: {
                float[] fArray = new float[]{0.0f, 45.0f, 125.0f, 180.0f, 245.0f, 315.0f, 360.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(254, 254, 254, 255)};
                paint = new ConicalGradientPaint(true, double_5, 0.0f, fArray, colorArray);
                break;
            }
            case METAL: {
                float[] fArray = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                paint = new LinearGradientPaint(double_3, double_4, fArray, colorArray);
                break;
            }
            case SHINY_METAL: {
                float[] fArray = new float[]{0.0f, 45.0f, 90.0f, 125.0f, 180.0f, 245.0f, 270.0f, 315.0f, 360.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(238, 238, 238, 255), new Color(160, 160, 160, 255), new Color(238, 238, 238, 255), new Color(179, 179, 179, 255), new Color(210, 210, 210, 255), new Color(254, 254, 254, 255)};
                paint = new ConicalGradientPaint(true, double_5, 0.0f, fArray, colorArray);
                break;
            }
            default: {
                float[] fArray = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                paint = new LinearGradientPaint(double_3, double_4, fArray, colorArray);
            }
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(double_2);
        Ellipse2D.Double double_6 = new Ellipse2D.Double((double)n2 * 0.07943925261497498, (double)n3 * 0.07943925261497498, (double)n2 * 0.8411215543746948, (double)n3 * 0.8411215543746948);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(double_6);
        Ellipse2D.Double double_7 = new Ellipse2D.Double((double)n2 * 0.08411215245723724, (double)n3 * 0.08411215245723724, (double)n2 * 0.8317756652832031, (double)n3 * 0.8317756652832031);
        Point2D.Double double_8 = new Point2D.Double(0.0, double_7.getBounds2D().getMinY());
        Point2D.Double double_9 = new Point2D.Double(0.0, double_7.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.4f, 1.0f};
        Color[] colorArray = new Color[]{this.backgroundColor.GRADIENT_START_COLOR, this.backgroundColor.GRADIENT_FRACTION_COLOR, this.backgroundColor.GRADIENT_STOP_COLOR};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_8, double_9, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_7);
        Ellipse2D.Double double_10 = new Ellipse2D.Double((double)n2 * 0.08411215245723724, (double)n3 * 0.08411215245723724, (double)n2 * 0.8317756652832031, (double)n3 * 0.8317756652832031);
        Point2D.Double double_11 = new Point2D.Double(0.5 * (double)n2, 0.5 * (double)n3);
        float[] fArray2 = new float[]{0.0f, 0.7f, 0.71f, 1.0f};
        Color[] colorArray2 = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 75)};
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_11, (float)(0.4158878504672897 * (double)n2), fArray2, colorArray2);
        graphics2D.setPaint(radialGradientPaint);
        graphics2D.fill(double_10);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_FOREGROUND_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.08411214953271028, (double)n3 * 0.49065420560747663);
        generalPath.curveTo((double)n2 * 0.08411214953271028, (double)n3 * 0.5, (double)n2 * 0.08411214953271028, (double)n3 * 0.5046728971962616, (double)n2 * 0.08411214953271028, (double)n3 * 0.5093457943925234);
        generalPath.curveTo((double)n2 * 0.20093457943925233, (double)n3 * 0.4532710280373832, (double)n2 * 0.32710280373831774, (double)n3 * 0.4158878504672897, (double)n2 * 0.49065420560747663, (double)n3 * 0.4158878504672897);
        generalPath.curveTo((double)n2 * 0.6588785046728972, (double)n3 * 0.4158878504672897, (double)n2 * 0.794392523364486, (double)n3 * 0.4439252336448598, (double)n2 * 0.9158878504672897, (double)n3 * 0.514018691588785);
        generalPath.curveTo((double)n2 * 0.9158878504672897, (double)n3 * 0.5046728971962616, (double)n2 * 0.9205607476635514, (double)n3 * 0.5, (double)n2 * 0.9158878504672897, (double)n3 * 0.49065420560747663);
        generalPath.curveTo((double)n2 * 0.9158878504672897, (double)n3 * 0.2757009345794392, (double)n2 * 0.7476635514018691, (double)n3 * 0.08411214953271028, (double)n2 * 0.5, (double)n3 * 0.08411214953271028);
        generalPath.curveTo((double)n2 * 0.2523364485981308, (double)n3 * 0.08411214953271028, (double)n2 * 0.08411214953271028, (double)n3 * 0.2803738317757009, (double)n2 * 0.08411214953271028, (double)n3 * 0.49065420560747663);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 1.0f};
        Color[] colorArray = new Color[]{new Color(255, 255, 255, 63), new Color(255, 255, 255, 12)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public String toString() {
        return "DisplayCircular";
    }
}

