/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.DigitalRadial;
import eu.hansolo.steelseries.gauges.DisplaySingle;
import eu.hansolo.steelseries.tools.LcdColor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jdesktop.layout.GroupLayout;

public class DigitalRadialLcd
extends JComponent
implements ComponentListener {
    private boolean valueCoupled = true;
    private final PropertyChangeListener VALUE_LISTENER = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("value")) {
                DigitalRadialLcd.this.lcd.setValue(Double.parseDouble(propertyChangeEvent.getNewValue().toString()));
            }
        }
    };
    private DigitalRadial gauge;
    private DisplaySingle lcd;

    public DigitalRadialLcd() {
        this.initComponents();
        this.lcd.setUnitStringVisible(false);
        if (this.getParent() != null) {
            this.gauge.init(this.getParent().getWidth(), this.getParent().getWidth());
            this.lcd.setSize((int)((double)this.gauge.getWidth() * 0.5), (int)((double)this.gauge.getWidth() * 0.15));
            this.lcd.setLocation((int)((double)(this.gauge.getWidth() - this.lcd.getWidth()) / 2.0), (int)((double)this.gauge.getWidth() * 0.45));
        }
        this.addComponentListener(this);
        this.gauge.addPropertyChangeListener(this.VALUE_LISTENER);
        this.repaint();
    }

    public boolean isValueCoupled() {
        return this.valueCoupled;
    }

    public void setValueCoupled(boolean bl) {
        this.valueCoupled = bl;
        if (bl) {
            this.addComponentListener(this);
            this.gauge.addPropertyChangeListener(this.VALUE_LISTENER);
            this.lcd.setUnitStringVisible(false);
        } else {
            this.gauge.removePropertyChangeListener(this.VALUE_LISTENER);
            this.lcd.setUnitStringVisible(true);
        }
        this.repaint();
    }

    public double getMinValue() {
        return this.gauge.getMinValue();
    }

    public void setMinValue(float f) {
        this.gauge.setMinValue(f);
    }

    public double getMaxValue() {
        return this.gauge.getMaxValue();
    }

    public void setMaxValue(float f) {
        this.gauge.setMaxValue(f);
    }

    public double getValue() {
        return this.gauge.getValue();
    }

    public void setValue(double d) {
        this.gauge.setValue(d);
    }

    public void setValueAnimated(double d) {
        this.gauge.setValueAnimated(d);
    }

    public double getLcdValue() {
        return this.lcd.getValue();
    }

    public void setLcdValue(double d) {
        this.lcd.setValue(d);
    }

    public void setLcdValueAnimated(double d) {
        this.lcd.setValueAnimated(d);
    }

    public LcdColor getLcdColor() {
        return this.lcd.getLcdColor();
    }

    public void setLcdColor(LcdColor lcdColor) {
        this.lcd.setLcdColor(lcdColor);
    }

    public String getTitle() {
        return this.gauge.getTitle();
    }

    public void setTitle(String string) {
        this.gauge.setTitle(string);
    }

    public String getUnitString() {
        return this.gauge.getUnitString();
    }

    public void setUnitString(String string) {
        this.gauge.setUnitString(string);
        if (this.valueCoupled) {
            this.setLcdUnitString(string);
        }
    }

    public String getLcdUnitString() {
        return this.lcd.getUnitString();
    }

    public void setLcdUnitString(String string) {
        this.lcd.setUnitString(string);
    }

    public boolean isLcdUnitStringVisible() {
        return this.lcd.isUnitStringVisible();
    }

    public void setLcdUnitStringVisible(boolean bl) {
        this.lcd.setUnitStringVisible(bl);
    }

    public boolean isDigitalFont() {
        return this.lcd.isDigitalFont();
    }

    public void setDigitalFont(boolean bl) {
        this.lcd.setDigitalFont(bl);
    }

    public int getLcdDecimals() {
        return this.lcd.getLcdDecimals();
    }

    public void setLcdDecimals(int n) {
        this.lcd.setLcdDecimals(n);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.gauge.setPreferredSize(new Dimension(this.getWidth(), this.getWidth()));
        this.gauge.setSize(this.getWidth(), this.getWidth());
        this.gauge.init(this.getWidth(), this.getWidth());
        this.lcd.setPreferredSize(new Dimension((int)((double)this.gauge.getWidth() * 0.5), (int)((double)this.gauge.getWidth() * 0.15)));
        this.lcd.setSize((int)((double)this.gauge.getWidth() * 0.5), (int)((double)this.gauge.getWidth() * 0.15));
        this.lcd.setLocation((int)((double)(this.gauge.getWidth() - this.lcd.getWidth()) / 2.0), (int)((double)this.gauge.getWidth() * 0.45));
        this.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public String toString() {
        return "DigitalRadialLcd";
    }

    private void initComponents() {
        this.gauge = new DigitalRadial();
        this.lcd = new DisplaySingle();
        this.gauge.setName("gauge");
        this.lcd.setName("lcd");
        GroupLayout groupLayout = new GroupLayout((Container)this.lcd);
        this.lcd.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 95, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 29, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.gauge);
        this.gauge.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap(52, Short.MAX_VALUE).add((Component)this.lcd, -2, 95, -2).add(53, 53, 53)));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(91, 91, 91).add((Component)this.lcd, -2, 29, -2).addContainerGap(80, Short.MAX_VALUE)));
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.gauge, -2, -1, -2));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.gauge, -2, -1, -2));
    }
}

