/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractRadial;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class DigitalRadial
extends AbstractRadial {
    private int noOfActiveLeds = 0;
    private BufferedImage backgroundImage;
    private BufferedImage foregroundImage;
    private BufferedImage ledGreenOff;
    private BufferedImage ledYellowOff;
    private BufferedImage ledRedOff;
    private BufferedImage ledGreenOn;
    private BufferedImage ledYellowOn;
    private BufferedImage ledRedOn;
    private Color valueColor = new Color(255, 0, 0, 255);
    private Point[] ledPosition;

    public DigitalRadial() {
        this.addComponentListener(this);
        this.setSize(this.getPreferredSize());
        this.init(this.getWidth(), this.getWidth());
    }

    @Override
    public final void init(int n, int n2) {
        this.backgroundImage = this.create_BACKGROUND_Image(n, this.getTitle(), this.getUnitString());
        this.foregroundImage = this.create_FOREGROUND_Image(n, false);
        this.ledPosition = new Point[]{new Point((int)((double)n * 0.186915887850467), (int)((double)n * 0.649532710280374)), new Point((int)((double)n * 0.116822429906542), (int)((double)n * 0.546728971962617)), new Point((int)((double)n * 0.088785046728972), (int)((double)n * 0.41588785046729)), new Point((int)((double)n * 0.116822429906542), (int)((double)n * 0.285046728971963)), new Point((int)((double)n * 0.177570093457944), (int)((double)n * 0.182242990654206)), new Point((int)((double)n * 0.280373831775701), (int)((double)n * 0.117222429906542)), new Point((int)((double)n * 0.411214953271028), (int)((double)n * 0.0794392523364486)), new Point((int)((double)n * 0.542056074766355), (int)((double)n * 0.117222429906542)), new Point((int)((double)n * 0.649532710280374), (int)((double)n * 0.182242990654206)), new Point((int)((double)n * 0.719626168224299), (int)((double)n * 0.285046728971963)), new Point((int)((double)n * 0.738317757009346), (int)((double)n * 0.41588785046729)), new Point((int)((double)n * 0.710280373831776), (int)((double)n * 0.546728971962617)), new Point((int)((double)n * 0.64018691588785), (int)((double)n * 0.649532710280374))};
        this.ledGreenOff = this.create_LED_OFF_Image(n, LedColor.GREEN);
        this.ledYellowOff = this.create_LED_OFF_Image(n, LedColor.YELLOW);
        this.ledRedOff = this.create_LED_OFF_Image(n, LedColor.RED);
        this.ledGreenOn = this.create_LED_ON_Image(n, LedColor.GREEN);
        this.ledYellowOn = this.create_LED_ON_Image(n, LedColor.YELLOW);
        this.ledRedOn = this.create_LED_ON_Image(n, LedColor.RED);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.drawImage((Image)this.backgroundImage, 0, 0, null);
        for (int i = 0; i < 13; ++i) {
            if (i < 7) {
                if (i < this.noOfActiveLeds) {
                    graphics2D.drawImage((Image)this.ledGreenOn, this.ledPosition[i].x, this.ledPosition[i].y, null);
                } else {
                    graphics2D.drawImage((Image)this.ledGreenOff, this.ledPosition[i].x, this.ledPosition[i].y, null);
                }
            }
            if (i >= 7 && i < 12) {
                if (i < this.noOfActiveLeds) {
                    graphics2D.drawImage((Image)this.ledYellowOn, this.ledPosition[i].x, this.ledPosition[i].y, null);
                } else {
                    graphics2D.drawImage((Image)this.ledYellowOff, this.ledPosition[i].x, this.ledPosition[i].y, null);
                }
            }
            if (i != 12) continue;
            if (i < this.noOfActiveLeds) {
                graphics2D.drawImage((Image)this.ledRedOn, this.ledPosition[i].x, this.ledPosition[i].y, null);
                continue;
            }
            graphics2D.drawImage((Image)this.ledRedOff, this.ledPosition[i].x, this.ledPosition[i].y, null);
        }
        graphics2D.drawImage((Image)this.foregroundImage, 0, 0, null);
    }

    @Override
    public void setValue(double d) {
        d = d > this.getMaxValue() ? this.getMaxValue() : d;
        d = d < this.getMinValue() ? this.getMinValue() : d;
        double d2 = this.getValue();
        super.setValue(d);
        this.calcNoOfActiveLed();
        this.firePropertyChange("value", d2, d);
        this.repaint();
    }

    @Override
    public void setMinValue(double d) {
        super.setMinValue(d);
        this.calcNoOfActiveLed();
        this.repaint();
    }

    @Override
    public void setMaxValue(double d) {
        super.setMaxValue(d);
        this.calcNoOfActiveLed();
        this.repaint();
    }

    private void calcNoOfActiveLed() {
        this.noOfActiveLeds = (int)(13.0 / (this.getMaxValue() - this.getMinValue()) * this.getValue());
    }

    public Color getValueColor() {
        return this.valueColor;
    }

    public void setValueColor(Color color) {
        this.valueColor = color;
        this.repaint();
    }

    @Override
    protected void calcAngleStep() {
    }

    private BufferedImage create_LED_OFF_Image(int n, LedColor ledColor) {
        Color[] colorArray;
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage((int)((double)n * 0.1775700935), (int)((double)n * 0.1775700935), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double((double)n2 * 0.21052631735801697, (double)n3 * 0.21052631735801697, (double)n2 * 0.5526316165924072, (double)n3 * 0.5526316165924072);
        Point2D.Double double_2 = new Point2D.Double(0.0, double_.getBounds2D().getMinY());
        Point2D.Double double_3 = new Point2D.Double(0.0, double_.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 1.0f};
        Color[] colorArray2 = new Color[]{new Color(0, 0, 0, 229), new Color(153, 153, 153, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray2);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_);
        Ellipse2D.Double double_4 = new Ellipse2D.Double((double)n2 * 0.2368421107530594, (double)n3 * 0.2368421107530594, (double)n2 * 0.5, (double)n3 * 0.5);
        Point2D.Double double_5 = new Point2D.Double(double_4.getCenterX(), double_4.getCenterY());
        float[] fArray2 = new float[]{0.0f, 0.14f, 0.15f, 1.0f};
        switch (ledColor) {
            case GREEN: {
                colorArray = new Color[]{new Color(28, 126, 0, 255), new Color(28, 126, 0, 255), new Color(28, 126, 0, 255), new Color(27, 100, 0, 255)};
                break;
            }
            case YELLOW: {
                colorArray = new Color[]{new Color(164, 128, 8, 255), new Color(158, 125, 10, 255), new Color(158, 125, 10, 255), new Color(130, 96, 25, 255)};
                break;
            }
            case RED: {
                colorArray = new Color[]{new Color(248, 0, 0, 255), new Color(248, 0, 0, 255), new Color(248, 0, 0, 255), new Color(63, 0, 0, 255)};
                break;
            }
            default: {
                colorArray = new Color[]{new Color(28, 126, 0, 255), new Color(28, 126, 0, 255), new Color(28, 126, 0, 255), new Color(27, 100, 0, 255)};
            }
        }
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_5, 0.25f * (float)n2, fArray2, colorArray);
        graphics2D.setPaint(radialGradientPaint);
        graphics2D.fill(double_4);
        Ellipse2D.Double double_6 = new Ellipse2D.Double((double)n2 * 0.2368421107530594, (double)n3 * 0.2368421107530594, (double)n2 * 0.5, (double)n3 * 0.5);
        Point2D.Double double_7 = new Point2D.Double(0.47368421052631576 * (double)n2, 0.47368421052631576 * (double)n3);
        float[] fArray3 = new float[]{0.0f, 0.86f, 1.0f};
        Color[] colorArray3 = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 88), new Color(0, 0, 0, 102)};
        RadialGradientPaint radialGradientPaint2 = new RadialGradientPaint(double_7, (float)(0.25 * (double)n2), fArray3, colorArray3);
        graphics2D.setPaint(radialGradientPaint2);
        graphics2D.fill(double_6);
        Ellipse2D.Double double_8 = new Ellipse2D.Double((double)n2 * 0.3947368562221527, (double)n3 * 0.31578946113586426, (double)n2 * 0.21052631735801697, (double)n3 * 0.1315789520740509);
        Point2D.Double double_9 = new Point2D.Double(0.0, double_8.getBounds2D().getMinY());
        Point2D.Double double_10 = new Point2D.Double(0.0, double_8.getBounds2D().getMaxY());
        float[] fArray4 = new float[]{0.0f, 1.0f};
        Color[] colorArray4 = new Color[]{new Color(255, 255, 255, 102), new Color(255, 255, 255, 0)};
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_9, double_10, fArray4, colorArray4);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(double_8);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_LED_ON_Image(int n, LedColor ledColor) {
        Color[] colorArray;
        Color[] colorArray2;
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage((int)((double)n * 0.1775700935), (int)((double)n * 0.1775700935), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double((double)n2 * 0.21052631735801697, (double)n3 * 0.21052631735801697, (double)n2 * 0.5526316165924072, (double)n3 * 0.5526316165924072);
        Point2D.Double double_2 = new Point2D.Double(0.0, double_.getBounds2D().getMinY());
        Point2D.Double double_3 = new Point2D.Double(0.0, double_.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 1.0f};
        Color[] colorArray3 = new Color[]{new Color(0, 0, 0, 229), new Color(153, 153, 153, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray3);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_);
        Ellipse2D.Double double_4 = new Ellipse2D.Double(0.0, 0.0, n2, n3);
        Point2D.Double double_5 = new Point2D.Double(double_4.getCenterX(), double_4.getCenterY());
        float[] fArray2 = new float[]{0.0f, 0.57f, 0.71f, 0.72f, 0.85f, 0.93f, 0.9301f, 0.99f};
        switch (ledColor) {
            case GREEN: {
                colorArray2 = new Color[]{new Color(165, 255, 0, 255), new Color(165, 255, 0, 101), new Color(165, 255, 0, 63), new Color(165, 255, 0, 62), new Color(165, 255, 0, 31), new Color(165, 255, 0, 13), new Color(165, 255, 0, 12), new Color(165, 255, 0, 0)};
                break;
            }
            case YELLOW: {
                colorArray2 = new Color[]{new Color(255, 102, 0, 255), new Color(255, 102, 0, 101), new Color(255, 102, 0, 63), new Color(255, 102, 0, 62), new Color(255, 102, 0, 31), new Color(255, 102, 0, 13), new Color(255, 102, 0, 12), new Color(255, 102, 0, 0)};
                break;
            }
            case RED: {
                colorArray2 = new Color[]{new Color(255, 0, 0, 255), new Color(255, 0, 0, 101), new Color(255, 0, 0, 63), new Color(255, 0, 0, 62), new Color(255, 0, 0, 31), new Color(255, 0, 0, 13), new Color(255, 0, 0, 12), new Color(255, 0, 0, 0)};
                break;
            }
            default: {
                colorArray2 = new Color[]{new Color(165, 255, 0, 255), new Color(165, 255, 0, 101), new Color(165, 255, 0, 63), new Color(165, 255, 0, 62), new Color(165, 255, 0, 31), new Color(165, 255, 0, 13), new Color(165, 255, 0, 12), new Color(165, 255, 0, 0)};
            }
        }
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_5, 0.5f * (float)n2, fArray2, colorArray2);
        graphics2D.setPaint(radialGradientPaint);
        graphics2D.fill(double_4);
        Ellipse2D.Double double_6 = new Ellipse2D.Double((double)n2 * 0.2368421107530594, (double)n3 * 0.2368421107530594, (double)n2 * 0.5, (double)n3 * 0.5);
        Point2D.Double double_7 = new Point2D.Double(double_6.getCenterX(), double_6.getCenterY());
        float[] fArray3 = new float[]{0.0f, 0.14f, 0.15f, 1.0f};
        switch (ledColor) {
            case GREEN: {
                colorArray = new Color[]{new Color(154, 255, 137, 255), new Color(154, 255, 137, 255), new Color(154, 255, 137, 255), new Color(89, 255, 42, 255)};
                break;
            }
            case YELLOW: {
                colorArray = new Color[]{new Color(251, 255, 140, 255), new Color(251, 255, 140, 255), new Color(251, 255, 140, 255), new Color(250, 249, 60, 255)};
                break;
            }
            case RED: {
                colorArray = new Color[]{new Color(252, 53, 55, 255), new Color(252, 53, 55, 255), new Color(252, 53, 55, 255), new Color(255, 0, 0, 255)};
                break;
            }
            default: {
                colorArray = new Color[]{new Color(154, 255, 137, 255), new Color(154, 255, 137, 255), new Color(154, 255, 137, 255), new Color(89, 255, 42, 255)};
            }
        }
        RadialGradientPaint radialGradientPaint2 = new RadialGradientPaint(double_7, 0.25f * (float)n2, fArray3, colorArray);
        graphics2D.setPaint(radialGradientPaint2);
        graphics2D.fill(double_6);
        Ellipse2D.Double double_8 = new Ellipse2D.Double((double)n2 * 0.2368421107530594, (double)n3 * 0.2368421107530594, (double)n2 * 0.5, (double)n3 * 0.5);
        Point2D.Double double_9 = new Point2D.Double(0.47368421052631576 * (double)n2, 0.47368421052631576 * (double)n3);
        float[] fArray4 = new float[]{0.0f, 0.86f, 1.0f};
        Color[] colorArray4 = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 88), new Color(0, 0, 0, 102)};
        RadialGradientPaint radialGradientPaint3 = new RadialGradientPaint(double_9, (float)(0.25 * (double)n2), fArray4, colorArray4);
        graphics2D.setPaint(radialGradientPaint3);
        graphics2D.fill(double_8);
        Ellipse2D.Double double_10 = new Ellipse2D.Double((double)n2 * 0.3947368562221527, (double)n3 * 0.31578946113586426, (double)n2 * 0.21052631735801697, (double)n3 * 0.1315789520740509);
        Point2D.Double double_11 = new Point2D.Double(0.0, double_10.getBounds2D().getMinY());
        Point2D.Double double_12 = new Point2D.Double(0.0, double_10.getBounds2D().getMaxY());
        float[] fArray5 = new float[]{0.0f, 1.0f};
        Color[] colorArray5 = new Color[]{new Color(255, 255, 255, 102), new Color(255, 255, 255, 0)};
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_11, double_12, fArray5, colorArray5);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(double_10);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public String toString() {
        return "DigitalRadial";
    }

    private static enum LedColor {
        GREEN,
        YELLOW,
        RED;

    }
}

