/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.tools.BackgroundColor;
import eu.hansolo.steelseries.tools.ConicalGradientPaint;
import eu.hansolo.steelseries.tools.FrameDesign;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Calendar;
import javax.swing.Timer;

public final class Clock
extends AbstractGauge
implements ActionListener {
    private static final double ANGLE_STEP = 6.0;
    private final Timer CLOCK_TIMER = new Timer(1000, this);
    private double minutePointerAngle = (double)Calendar.getInstance().get(12) * 6.0;
    private double hourPointerAngle = (double)Calendar.getInstance().get(10) * 6.0 * 5.0 + 0.5 * (double)Calendar.getInstance().get(12);
    private double secondPointerAngle = (double)Calendar.getInstance().get(13) * 6.0;
    private BackgroundColor backgroundColor = BackgroundColor.DARK_GRAY;
    private FrameDesign frameDesign = FrameDesign.METAL;
    private BufferedImage backgroundImage;
    private BufferedImage hourImage;
    private BufferedImage hourShadowImage;
    private BufferedImage minuteImage;
    private BufferedImage minuteShadowImage;
    private BufferedImage knobImage;
    private BufferedImage secondImage;
    private BufferedImage secondShadowImage;
    private BufferedImage foregroundImage;
    private int hour;
    private int minute;
    private int timeZoneOffsetHour = 0;
    private int timeZoneOffsetMinute = 0;
    private final Color SHADOW_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.65f);

    public Clock() {
        this.addComponentListener(this);
        this.setPreferredSize(new Dimension(200, 200));
        this.setSize(this.getPreferredSize());
        this.init(this.getWidth(), this.getWidth());
        this.CLOCK_TIMER.start();
    }

    @Override
    public void init(int n, int n2) {
        this.backgroundImage = this.create_BACKGROUND_Image(n);
        this.hourImage = this.create_HOUR_Image(n);
        this.hourShadowImage = this.create_HOUR_SHADOW_Image(n);
        this.minuteImage = this.create_MINUTE_Image(n);
        this.minuteShadowImage = this.create_MINUTE_SHADOW_Image(n);
        this.knobImage = this.create_KNOB_Image(n);
        this.secondImage = this.create_SECOND_Image(n);
        this.secondShadowImage = this.create_SECOND_SHADOW_Image(n);
        this.foregroundImage = this.create_FOREGROUND_Image(n);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Point2D.Double double_ = new Point2D.Double((double)this.backgroundImage.getWidth() / 2.0, (double)this.backgroundImage.getWidth() / 2.0);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.drawImage((Image)this.backgroundImage, 0, 0, null);
        graphics2D.rotate(Math.toRadians(this.hourPointerAngle + 2.0 * Math.sin(Math.toRadians(this.hourPointerAngle))), ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.drawImage((Image)this.hourShadowImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.rotate(Math.toRadians(this.hourPointerAngle), ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.drawImage((Image)this.hourImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.rotate(Math.toRadians(this.minutePointerAngle + 2.0 * Math.sin(Math.toRadians(this.minutePointerAngle))), ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.drawImage((Image)this.minuteShadowImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.rotate(Math.toRadians(this.minutePointerAngle), ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.drawImage((Image)this.minuteImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.drawImage((Image)this.knobImage, 0, 0, null);
        graphics2D.rotate(Math.toRadians(this.secondPointerAngle + 2.0 * Math.sin(Math.toRadians(this.secondPointerAngle))), ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.drawImage((Image)this.secondShadowImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.rotate(Math.toRadians(this.secondPointerAngle), ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.drawImage((Image)this.secondImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.drawImage((Image)this.foregroundImage, 0, 0, null);
    }

    public int getTimeZoneOffsetHour() {
        return this.timeZoneOffsetHour;
    }

    public void setTimeZoneOffsetHour(int n) {
        this.timeZoneOffsetHour = n;
    }

    public int getTimeZoneOffsetMinute() {
        return this.timeZoneOffsetMinute;
    }

    public void setTimeZoneOffsetMinute(int n) {
        this.timeZoneOffsetMinute = n;
    }

    public BackgroundColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(BackgroundColor backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    public FrameDesign getFrameDesign() {
        return this.frameDesign;
    }

    public void setFrameDesign(FrameDesign frameDesign) {
        this.frameDesign = frameDesign;
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    private BufferedImage create_BACKGROUND_Image(int n) {
        Paint paint;
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double((double)n2 * 0.0, (double)n3 * 0.0, (double)n2 * 1.0, (double)n3 * 1.0);
        Color color = new Color(0x848484);
        graphics2D.setColor(color);
        graphics2D.fill(double_);
        Ellipse2D.Double double_2 = new Ellipse2D.Double((double)n2 * 0.004672897048294544, (double)n3 * 0.004672897048294544, (double)n2 * 0.9906542301177979, (double)n3 * 0.9906542301177979);
        Point2D.Double double_3 = new Point2D.Double(0.0, double_2.getBounds2D().getMinY());
        Point2D.Double double_4 = new Point2D.Double(0.0, double_2.getBounds2D().getMaxY());
        Point2D.Double double_5 = new Point2D.Double(double_2.getCenterX(), double_2.getCenterY());
        switch (this.frameDesign) {
            case BLACK_METAL: {
                float[] fArray = new float[]{0.0f, 45.0f, 125.0f, 180.0f, 245.0f, 315.0f, 360.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(254, 254, 254, 255)};
                paint = new ConicalGradientPaint(true, double_5, 0.0f, fArray, colorArray);
                break;
            }
            case METAL: {
                float[] fArray = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                paint = new LinearGradientPaint(double_3, double_4, fArray, colorArray);
                break;
            }
            case SHINY_METAL: {
                float[] fArray = new float[]{0.0f, 45.0f, 90.0f, 125.0f, 180.0f, 245.0f, 270.0f, 315.0f, 360.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(238, 238, 238, 255), new Color(160, 160, 160, 255), new Color(238, 238, 238, 255), new Color(179, 179, 179, 255), new Color(210, 210, 210, 255), new Color(254, 254, 254, 255)};
                paint = new ConicalGradientPaint(true, double_5, 0.0f, fArray, colorArray);
                break;
            }
            default: {
                float[] fArray = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                paint = new LinearGradientPaint(double_3, double_4, fArray, colorArray);
            }
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(double_2);
        Ellipse2D.Double double_6 = new Ellipse2D.Double((double)n2 * 0.07943925261497498, (double)n3 * 0.07943925261497498, (double)n2 * 0.8411215543746948, (double)n3 * 0.8411215543746948);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(double_6);
        Ellipse2D.Double double_7 = new Ellipse2D.Double((double)n2 * 0.08411215245723724, (double)n3 * 0.08411215245723724, (double)n2 * 0.8317756652832031, (double)n3 * 0.8317756652832031);
        Point2D.Double double_8 = new Point2D.Double(0.0, double_7.getBounds2D().getMinY());
        Point2D.Double double_9 = new Point2D.Double(0.0, double_7.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.4f, 1.0f};
        Color[] colorArray = new Color[]{this.backgroundColor.GRADIENT_START_COLOR, this.backgroundColor.GRADIENT_FRACTION_COLOR, this.backgroundColor.GRADIENT_STOP_COLOR};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_8, double_9, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_7);
        Ellipse2D.Double double_10 = new Ellipse2D.Double((double)n2 * 0.08411215245723724, (double)n3 * 0.08411215245723724, (double)n2 * 0.8317756652832031, (double)n3 * 0.8317756652832031);
        Point2D.Double double_11 = new Point2D.Double(0.5 * (double)n2, 0.5 * (double)n3);
        float[] fArray2 = new float[]{0.0f, 0.7f, 0.71f, 1.0f};
        Color[] colorArray2 = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 76)};
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_11, (float)(0.4158878504672897 * (double)n2), fArray2, colorArray2);
        graphics2D.setPaint(radialGradientPaint);
        graphics2D.fill(double_10);
        Color color2 = this.backgroundColor.LABEL_COLOR;
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.3130841121495327, (double)n3 * 0.17757009345794392);
        generalPath.lineTo((double)n2 * 0.35046728971962615, (double)n3 * 0.2383177570093458);
        generalPath.lineTo((double)n2 * 0.34579439252336447, (double)n3 * 0.2383177570093458);
        generalPath.lineTo((double)n2 * 0.308411214953271, (double)n3 * 0.17757009345794392);
        generalPath.lineTo((double)n2 * 0.3130841121495327, (double)n3 * 0.17757009345794392);
        generalPath.closePath();
        Color color3 = new Color(0x353534);
        graphics2D.setColor(color3);
        graphics2D.fill(generalPath);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.setWindingRule(0);
        generalPath2.moveTo((double)n2 * 0.32242990654205606, (double)n3 * 0.17289719626168223);
        generalPath2.lineTo((double)n2 * 0.35514018691588783, (double)n3 * 0.2336448598130841);
        generalPath2.lineTo((double)n2 * 0.35046728971962615, (double)n3 * 0.2383177570093458);
        generalPath2.lineTo((double)n2 * 0.3130841121495327, (double)n3 * 0.17757009345794392);
        generalPath2.lineTo((double)n2 * 0.32242990654205606, (double)n3 * 0.17289719626168223);
        generalPath2.closePath();
        graphics2D.setColor(color2);
        graphics2D.fill(generalPath2);
        GeneralPath generalPath3 = new GeneralPath();
        generalPath3.setWindingRule(0);
        generalPath3.moveTo((double)n2 * 0.17757009345794392, (double)n3 * 0.3177570093457944);
        generalPath3.lineTo((double)n2 * 0.2383177570093458, (double)n3 * 0.35514018691588783);
        generalPath3.lineTo((double)n2 * 0.2383177570093458, (double)n3 * 0.3598130841121495);
        generalPath3.lineTo((double)n2 * 0.17757009345794392, (double)n3 * 0.32242990654205606);
        generalPath3.lineTo((double)n2 * 0.17757009345794392, (double)n3 * 0.3177570093457944);
        generalPath3.closePath();
        Color color4 = new Color(0x353534);
        graphics2D.setColor(color4);
        graphics2D.fill(generalPath3);
        GeneralPath generalPath4 = new GeneralPath();
        generalPath4.setWindingRule(0);
        generalPath4.moveTo((double)n2 * 0.1822429906542056, (double)n3 * 0.3130841121495327);
        generalPath4.lineTo((double)n2 * 0.24299065420560748, (double)n3 * 0.34579439252336447);
        generalPath4.lineTo((double)n2 * 0.2383177570093458, (double)n3 * 0.35514018691588783);
        generalPath4.lineTo((double)n2 * 0.17757009345794392, (double)n3 * 0.3177570093457944);
        generalPath4.lineTo((double)n2 * 0.1822429906542056, (double)n3 * 0.3130841121495327);
        generalPath4.closePath();
        graphics2D.setColor(color2);
        graphics2D.fill(generalPath4);
        GeneralPath generalPath5 = new GeneralPath();
        generalPath5.setWindingRule(0);
        generalPath5.moveTo((double)n2 * 0.10747663551401869, (double)n3 * 0.48130841121495327);
        generalPath5.lineTo((double)n2 * 0.205607476635514, (double)n3 * 0.48130841121495327);
        generalPath5.lineTo((double)n2 * 0.205607476635514, (double)n3 * 0.5233644859813084);
        generalPath5.lineTo((double)n2 * 0.10747663551401869, (double)n3 * 0.5233644859813084);
        generalPath5.lineTo((double)n2 * 0.10747663551401869, (double)n3 * 0.48130841121495327);
        generalPath5.closePath();
        Color color5 = new Color(0x353534);
        graphics2D.setColor(color5);
        graphics2D.fill(generalPath5);
        GeneralPath generalPath6 = new GeneralPath();
        generalPath6.setWindingRule(0);
        generalPath6.moveTo((double)n2 * 0.11682242990654206, (double)n3 * 0.48598130841121495);
        generalPath6.lineTo((double)n2 * 0.20093457943925233, (double)n3 * 0.48598130841121495);
        generalPath6.lineTo((double)n2 * 0.20093457943925233, (double)n3 * 0.5093457943925234);
        generalPath6.lineTo((double)n2 * 0.11682242990654206, (double)n3 * 0.5093457943925234);
        generalPath6.lineTo((double)n2 * 0.11682242990654206, (double)n3 * 0.48598130841121495);
        generalPath6.closePath();
        graphics2D.setColor(color2);
        graphics2D.fill(generalPath6);
        GeneralPath generalPath7 = new GeneralPath();
        generalPath7.setWindingRule(0);
        generalPath7.moveTo((double)n2 * 0.17757009345794392, (double)n3 * 0.6869158878504673);
        generalPath7.lineTo((double)n2 * 0.2383177570093458, (double)n3 * 0.6542056074766355);
        generalPath7.lineTo((double)n2 * 0.24299065420560748, (double)n3 * 0.6588785046728972);
        generalPath7.lineTo((double)n2 * 0.1822429906542056, (double)n3 * 0.6962616822429907);
        generalPath7.lineTo((double)n2 * 0.17757009345794392, (double)n3 * 0.6869158878504673);
        generalPath7.closePath();
        Color color6 = new Color(0x353534);
        graphics2D.setColor(color6);
        graphics2D.fill(generalPath7);
        GeneralPath generalPath8 = new GeneralPath();
        generalPath8.setWindingRule(0);
        generalPath8.moveTo((double)n2 * 0.17757009345794392, (double)n3 * 0.6822429906542056);
        generalPath8.lineTo((double)n2 * 0.2383177570093458, (double)n3 * 0.6495327102803738);
        generalPath8.lineTo((double)n2 * 0.2383177570093458, (double)n3 * 0.6542056074766355);
        generalPath8.lineTo((double)n2 * 0.17757009345794392, (double)n3 * 0.6869158878504673);
        generalPath8.lineTo((double)n2 * 0.17757009345794392, (double)n3 * 0.6822429906542056);
        generalPath8.closePath();
        graphics2D.setColor(color2);
        graphics2D.fill(generalPath8);
        GeneralPath generalPath9 = new GeneralPath();
        generalPath9.setWindingRule(0);
        generalPath9.moveTo((double)n2 * 0.3130841121495327, (double)n3 * 0.822429906542056);
        generalPath9.lineTo((double)n2 * 0.35046728971962615, (double)n3 * 0.7616822429906542);
        generalPath9.lineTo((double)n2 * 0.35514018691588783, (double)n3 * 0.7663551401869159);
        generalPath9.lineTo((double)n2 * 0.32242990654205606, (double)n3 * 0.8271028037383178);
        generalPath9.lineTo((double)n2 * 0.3130841121495327, (double)n3 * 0.822429906542056);
        generalPath9.closePath();
        Color color7 = new Color(0x353534);
        graphics2D.setColor(color7);
        graphics2D.fill(generalPath9);
        GeneralPath generalPath10 = new GeneralPath();
        generalPath10.setWindingRule(0);
        generalPath10.moveTo((double)n2 * 0.308411214953271, (double)n3 * 0.822429906542056);
        generalPath10.lineTo((double)n2 * 0.34579439252336447, (double)n3 * 0.7616822429906542);
        generalPath10.lineTo((double)n2 * 0.35046728971962615, (double)n3 * 0.7616822429906542);
        generalPath10.lineTo((double)n2 * 0.3130841121495327, (double)n3 * 0.822429906542056);
        generalPath10.lineTo((double)n2 * 0.308411214953271, (double)n3 * 0.822429906542056);
        generalPath10.closePath();
        graphics2D.setColor(color2);
        graphics2D.fill(generalPath10);
        GeneralPath generalPath11 = new GeneralPath();
        generalPath11.setWindingRule(0);
        generalPath11.moveTo((double)n2 * 0.48130841121495327, (double)n3 * 0.8084112149532711);
        generalPath11.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.8084112149532711);
        generalPath11.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.8925233644859814);
        generalPath11.lineTo((double)n2 * 0.48130841121495327, (double)n3 * 0.8925233644859814);
        generalPath11.lineTo((double)n2 * 0.48130841121495327, (double)n3 * 0.8084112149532711);
        generalPath11.closePath();
        Color color8 = new Color(0x2B2B2B);
        graphics2D.setColor(color8);
        graphics2D.fill(generalPath11);
        GeneralPath generalPath12 = new GeneralPath();
        generalPath12.setWindingRule(0);
        generalPath12.moveTo((double)n2 * 0.48130841121495327, (double)n3 * 0.794392523364486);
        generalPath12.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.794392523364486);
        generalPath12.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.8878504672897196);
        generalPath12.lineTo((double)n2 * 0.48130841121495327, (double)n3 * 0.8878504672897196);
        generalPath12.lineTo((double)n2 * 0.48130841121495327, (double)n3 * 0.794392523364486);
        generalPath12.closePath();
        graphics2D.setColor(color2);
        graphics2D.fill(generalPath12);
        GeneralPath generalPath13 = new GeneralPath();
        generalPath13.setWindingRule(0);
        generalPath13.moveTo((double)n2 * 0.6869158878504673, (double)n3 * 0.822429906542056);
        generalPath13.lineTo((double)n2 * 0.6495327102803738, (double)n3 * 0.7616822429906542);
        generalPath13.lineTo((double)n2 * 0.6542056074766355, (double)n3 * 0.7616822429906542);
        generalPath13.lineTo((double)n2 * 0.6915887850467289, (double)n3 * 0.822429906542056);
        generalPath13.lineTo((double)n2 * 0.6869158878504673, (double)n3 * 0.822429906542056);
        generalPath13.closePath();
        Color color9 = new Color(0x353534);
        graphics2D.setColor(color9);
        graphics2D.fill(generalPath13);
        GeneralPath generalPath14 = new GeneralPath();
        generalPath14.setWindingRule(0);
        generalPath14.moveTo((double)n2 * 0.677570093457944, (double)n3 * 0.8271028037383178);
        generalPath14.lineTo((double)n2 * 0.6448598130841121, (double)n3 * 0.7663551401869159);
        generalPath14.lineTo((double)n2 * 0.6495327102803738, (double)n3 * 0.7616822429906542);
        generalPath14.lineTo((double)n2 * 0.6869158878504673, (double)n3 * 0.822429906542056);
        generalPath14.lineTo((double)n2 * 0.677570093457944, (double)n3 * 0.8271028037383178);
        generalPath14.closePath();
        graphics2D.setColor(color2);
        graphics2D.fill(generalPath14);
        GeneralPath generalPath15 = new GeneralPath();
        generalPath15.setWindingRule(0);
        generalPath15.moveTo((double)n2 * 0.822429906542056, (double)n3 * 0.6869158878504673);
        generalPath15.lineTo((double)n2 * 0.7616822429906542, (double)n3 * 0.6542056074766355);
        generalPath15.lineTo((double)n2 * 0.7616822429906542, (double)n3 * 0.6495327102803738);
        generalPath15.lineTo((double)n2 * 0.822429906542056, (double)n3 * 0.6822429906542056);
        generalPath15.lineTo((double)n2 * 0.822429906542056, (double)n3 * 0.6869158878504673);
        generalPath15.closePath();
        Color color10 = new Color(0x353534);
        graphics2D.setColor(color10);
        graphics2D.fill(generalPath15);
        GeneralPath generalPath16 = new GeneralPath();
        generalPath16.setWindingRule(0);
        generalPath16.moveTo((double)n2 * 0.8177570093457944, (double)n3 * 0.6962616822429907);
        generalPath16.lineTo((double)n2 * 0.7570093457943925, (double)n3 * 0.6588785046728972);
        generalPath16.lineTo((double)n2 * 0.7616822429906542, (double)n3 * 0.6542056074766355);
        generalPath16.lineTo((double)n2 * 0.822429906542056, (double)n3 * 0.6869158878504673);
        generalPath16.lineTo((double)n2 * 0.8177570093457944, (double)n3 * 0.6962616822429907);
        generalPath16.closePath();
        graphics2D.setColor(color2);
        graphics2D.fill(generalPath16);
        GeneralPath generalPath17 = new GeneralPath();
        generalPath17.setWindingRule(0);
        generalPath17.moveTo((double)n2 * 0.7990654205607477, (double)n3 * 0.48130841121495327);
        generalPath17.lineTo((double)n2 * 0.897196261682243, (double)n3 * 0.48130841121495327);
        generalPath17.lineTo((double)n2 * 0.897196261682243, (double)n3 * 0.5233644859813084);
        generalPath17.lineTo((double)n2 * 0.7990654205607477, (double)n3 * 0.5233644859813084);
        generalPath17.lineTo((double)n2 * 0.7990654205607477, (double)n3 * 0.48130841121495327);
        generalPath17.closePath();
        Color color11 = new Color(0x353534);
        graphics2D.setColor(color11);
        graphics2D.fill(generalPath17);
        GeneralPath generalPath18 = new GeneralPath();
        generalPath18.setWindingRule(0);
        generalPath18.moveTo((double)n2 * 0.8084112149532711, (double)n3 * 0.48598130841121495);
        generalPath18.lineTo((double)n2 * 0.8925233644859814, (double)n3 * 0.48598130841121495);
        generalPath18.lineTo((double)n2 * 0.8925233644859814, (double)n3 * 0.5093457943925234);
        generalPath18.lineTo((double)n2 * 0.8084112149532711, (double)n3 * 0.5093457943925234);
        generalPath18.lineTo((double)n2 * 0.8084112149532711, (double)n3 * 0.48598130841121495);
        generalPath18.closePath();
        graphics2D.setColor(color2);
        graphics2D.fill(generalPath18);
        GeneralPath generalPath19 = new GeneralPath();
        generalPath19.setWindingRule(0);
        generalPath19.moveTo((double)n2 * 0.822429906542056, (double)n3 * 0.3177570093457944);
        generalPath19.lineTo((double)n2 * 0.7616822429906542, (double)n3 * 0.35514018691588783);
        generalPath19.lineTo((double)n2 * 0.7570093457943925, (double)n3 * 0.34579439252336447);
        generalPath19.lineTo((double)n2 * 0.8177570093457944, (double)n3 * 0.3130841121495327);
        generalPath19.lineTo((double)n2 * 0.822429906542056, (double)n3 * 0.3177570093457944);
        generalPath19.closePath();
        Color color12 = new Color(0x353534);
        graphics2D.setColor(color12);
        graphics2D.fill(generalPath19);
        GeneralPath generalPath20 = new GeneralPath();
        generalPath20.setWindingRule(0);
        generalPath20.moveTo((double)n2 * 0.822429906542056, (double)n3 * 0.32242990654205606);
        generalPath20.lineTo((double)n2 * 0.7616822429906542, (double)n3 * 0.3598130841121495);
        generalPath20.lineTo((double)n2 * 0.7616822429906542, (double)n3 * 0.35514018691588783);
        generalPath20.lineTo((double)n2 * 0.822429906542056, (double)n3 * 0.3177570093457944);
        generalPath20.lineTo((double)n2 * 0.822429906542056, (double)n3 * 0.32242990654205606);
        generalPath20.closePath();
        graphics2D.setColor(color2);
        graphics2D.fill(generalPath20);
        GeneralPath generalPath21 = new GeneralPath();
        generalPath21.setWindingRule(0);
        generalPath21.moveTo((double)n2 * 0.6915887850467289, (double)n3 * 0.17757009345794392);
        generalPath21.lineTo((double)n2 * 0.6542056074766355, (double)n3 * 0.2383177570093458);
        generalPath21.lineTo((double)n2 * 0.6495327102803738, (double)n3 * 0.2336448598130841);
        generalPath21.lineTo((double)n2 * 0.6869158878504673, (double)n3 * 0.17289719626168223);
        generalPath21.lineTo((double)n2 * 0.6915887850467289, (double)n3 * 0.17757009345794392);
        generalPath21.closePath();
        Color color13 = new Color(0x353534);
        graphics2D.setColor(color13);
        graphics2D.fill(generalPath21);
        GeneralPath generalPath22 = new GeneralPath();
        generalPath22.setWindingRule(0);
        generalPath22.moveTo((double)n2 * 0.6962616822429907, (double)n3 * 0.17757009345794392);
        generalPath22.lineTo((double)n2 * 0.6635514018691588, (double)n3 * 0.2383177570093458);
        generalPath22.lineTo((double)n2 * 0.6542056074766355, (double)n3 * 0.2383177570093458);
        generalPath22.lineTo((double)n2 * 0.6915887850467289, (double)n3 * 0.17757009345794392);
        generalPath22.lineTo((double)n2 * 0.6962616822429907, (double)n3 * 0.17757009345794392);
        generalPath22.closePath();
        graphics2D.setColor(color2);
        graphics2D.fill(generalPath22);
        GeneralPath generalPath23 = new GeneralPath();
        generalPath23.setWindingRule(0);
        generalPath23.moveTo((double)n2 * 0.48130841121495327, (double)n3 * 0.10747663551401869);
        generalPath23.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.10747663551401869);
        generalPath23.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.205607476635514);
        generalPath23.lineTo((double)n2 * 0.48130841121495327, (double)n3 * 0.205607476635514);
        generalPath23.lineTo((double)n2 * 0.48130841121495327, (double)n3 * 0.10747663551401869);
        generalPath23.closePath();
        Color color14 = new Color(0x2B2B2B);
        graphics2D.setColor(color14);
        graphics2D.fill(generalPath23);
        GeneralPath generalPath24 = new GeneralPath();
        generalPath24.setWindingRule(0);
        generalPath24.moveTo((double)n2 * 0.48130841121495327, (double)n3 * 0.10747663551401869);
        generalPath24.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.10747663551401869);
        generalPath24.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.20093457943925233);
        generalPath24.lineTo((double)n2 * 0.48130841121495327, (double)n3 * 0.20093457943925233);
        generalPath24.lineTo((double)n2 * 0.48130841121495327, (double)n3 * 0.10747663551401869);
        generalPath24.closePath();
        graphics2D.setColor(color2);
        graphics2D.fill(generalPath24);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_HOUR_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.5607476635514018);
        generalPath.lineTo((double)n2 * 0.4719626168224299, (double)n3 * 0.21495327102803738);
        generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.1822429906542056);
        generalPath.lineTo((double)n2 * 0.5280373831775701, (double)n3 * 0.21495327102803738);
        generalPath.lineTo((double)n2 * 0.5280373831775701, (double)n3 * 0.5607476635514018);
        generalPath.lineTo((double)n2 * 0.4719626168224299, (double)n3 * 0.5607476635514018);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
        Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        float[] fArray = new float[]{0.0f, 1.0f};
        Color[] colorArray = new Color[]{new Color(245, 246, 248, 255), new Color(176, 181, 188, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        Color color = new Color(14343649);
        graphics2D.setColor(color);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics2D.draw(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_HOUR_SHADOW_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.5607476635514018);
        generalPath.lineTo((double)n2 * 0.4719626168224299, (double)n3 * 0.21495327102803738);
        generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.1822429906542056);
        generalPath.lineTo((double)n2 * 0.5280373831775701, (double)n3 * 0.21495327102803738);
        generalPath.lineTo((double)n2 * 0.5280373831775701, (double)n3 * 0.5607476635514018);
        generalPath.lineTo((double)n2 * 0.4719626168224299, (double)n3 * 0.5607476635514018);
        generalPath.closePath();
        graphics2D.setColor(this.SHADOW_COLOR);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_MINUTE_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5747663551401869);
        generalPath.lineTo((double)n2 * 0.5233644859813084, (double)n3 * 0.13551401869158877);
        generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.10747663551401869);
        generalPath.lineTo((double)n2 * 0.4766355140186916, (double)n3 * 0.14018691588785046);
        generalPath.lineTo((double)n2 * 0.4766355140186916, (double)n3 * 0.5747663551401869);
        generalPath.lineTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5747663551401869);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 1.0f};
        Color[] colorArray = new Color[]{new Color(245, 246, 248, 255), new Color(176, 181, 188, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        Color color = new Color(14343649);
        graphics2D.setColor(color);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics2D.draw(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_MINUTE_SHADOW_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5747663551401869);
        generalPath.lineTo((double)n2 * 0.5233644859813084, (double)n3 * 0.13551401869158877);
        generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.10747663551401869);
        generalPath.lineTo((double)n2 * 0.4766355140186916, (double)n3 * 0.14018691588785046);
        generalPath.lineTo((double)n2 * 0.4766355140186916, (double)n3 * 0.5747663551401869);
        generalPath.lineTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5747663551401869);
        generalPath.closePath();
        graphics2D.setColor(this.SHADOW_COLOR);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_KNOB_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.4532710280373832, (double)n3 * 0.5046728971962616);
        generalPath.curveTo((double)n2 * 0.4532710280373832, (double)n3 * 0.48130841121495327, (double)n2 * 0.4719626168224299, (double)n3 * 0.45794392523364486, (double)n2 * 0.5, (double)n3 * 0.45794392523364486);
        generalPath.curveTo((double)n2 * 0.5280373831775701, (double)n3 * 0.45794392523364486, (double)n2 * 0.5467289719626168, (double)n3 * 0.48130841121495327, (double)n2 * 0.5467289719626168, (double)n3 * 0.5046728971962616);
        generalPath.curveTo((double)n2 * 0.5467289719626168, (double)n3 * 0.5327102803738317, (double)n2 * 0.5280373831775701, (double)n3 * 0.5560747663551402, (double)n2 * 0.5, (double)n3 * 0.5560747663551402);
        generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.5560747663551402, (double)n2 * 0.4532710280373832, (double)n3 * 0.5327102803738317, (double)n2 * 0.4532710280373832, (double)n3 * 0.5046728971962616);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 1.0f};
        Color[] colorArray = new Color[]{new Color(40, 40, 41, 255), new Color(13, 13, 13, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.setWindingRule(0);
        generalPath2.moveTo((double)n2 * 0.45794392523364486, (double)n3 * 0.5);
        generalPath2.curveTo((double)n2 * 0.45794392523364486, (double)n3 * 0.4766355140186916, (double)n2 * 0.4766355140186916, (double)n3 * 0.45794392523364486, (double)n2 * 0.5, (double)n3 * 0.45794392523364486);
        generalPath2.curveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.45794392523364486, (double)n2 * 0.5420560747663551, (double)n3 * 0.4766355140186916, (double)n2 * 0.5420560747663551, (double)n3 * 0.5);
        generalPath2.curveTo((double)n2 * 0.5420560747663551, (double)n3 * 0.5233644859813084, (double)n2 * 0.5233644859813084, (double)n3 * 0.5420560747663551, (double)n2 * 0.5, (double)n3 * 0.5420560747663551);
        generalPath2.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.5420560747663551, (double)n2 * 0.45794392523364486, (double)n3 * 0.5233644859813084, (double)n2 * 0.45794392523364486, (double)n3 * 0.5);
        generalPath2.closePath();
        Point2D.Double double_3 = new Point2D.Double(0.0, generalPath2.getBounds2D().getMinY());
        Point2D.Double double_4 = new Point2D.Double(0.0, generalPath2.getBounds2D().getMaxY());
        float[] fArray2 = new float[]{0.0f, 1.0f};
        Color[] colorArray2 = new Color[]{new Color(238, 240, 242, 255), new Color(101, 105, 109, 255)};
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_3, double_4, fArray2, colorArray2);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(generalPath2);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_SECOND_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5093457943925234, (double)n3 * 0.11682242990654206);
        generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.5747663551401869);
        generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.5747663551401869);
        generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.11682242990654206);
        generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.11682242990654206);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
        Point2D.Double double_2 = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
        float[] fArray = new float[]{0.0f, 0.47f, 1.0f};
        Color[] colorArray = new Color[]{new Color(236, 123, 125, 255), new Color(231, 27, 33, 255), new Color(166, 40, 46, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_SECOND_SHADOW_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5093457943925234, (double)n3 * 0.11682242990654206);
        generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.5747663551401869);
        generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.5747663551401869);
        generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.11682242990654206);
        generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.11682242990654206);
        generalPath.closePath();
        graphics2D.setPaint(this.SHADOW_COLOR);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_FOREGROUND_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.48598130841121495, (double)n2 * 0.48598130841121495, (double)n3 * 0.4719626168224299, (double)n2 * 0.5, (double)n3 * 0.4719626168224299);
        generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.4719626168224299, (double)n2 * 0.5280373831775701, (double)n3 * 0.48598130841121495, (double)n2 * 0.5280373831775701, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.5280373831775701, (double)n3 * 0.514018691588785, (double)n2 * 0.514018691588785, (double)n3 * 0.5280373831775701, (double)n2 * 0.5, (double)n3 * 0.5280373831775701);
        generalPath.curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.5280373831775701, (double)n2 * 0.4719626168224299, (double)n3 * 0.514018691588785, (double)n2 * 0.4719626168224299, (double)n3 * 0.5);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 1.0f};
        Color[] colorArray = new Color[]{new Color(221, 223, 223, 255), new Color(38, 40, 41, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.setWindingRule(0);
        generalPath2.moveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.5);
        generalPath2.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.48598130841121495, (double)n2 * 0.48598130841121495, (double)n3 * 0.4766355140186916, (double)n2 * 0.5, (double)n3 * 0.4766355140186916);
        generalPath2.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.4766355140186916, (double)n2 * 0.5233644859813084, (double)n3 * 0.48598130841121495, (double)n2 * 0.5233644859813084, (double)n3 * 0.5);
        generalPath2.curveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.514018691588785, (double)n2 * 0.514018691588785, (double)n3 * 0.5233644859813084, (double)n2 * 0.5, (double)n3 * 0.5233644859813084);
        generalPath2.curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.5233644859813084, (double)n2 * 0.4766355140186916, (double)n3 * 0.514018691588785, (double)n2 * 0.4766355140186916, (double)n3 * 0.5);
        generalPath2.closePath();
        Point2D.Double double_3 = new Point2D.Double(0.0, generalPath2.getBounds2D().getMinY());
        Point2D.Double double_4 = new Point2D.Double(0.0, generalPath2.getBounds2D().getMaxY());
        float[] fArray2 = new float[]{0.0f, 0.11f, 0.12f, 0.2f, 0.2001f, 1.0f};
        Color[] colorArray2 = new Color[]{new Color(234, 235, 238, 255), new Color(234, 236, 238, 255), new Color(232, 234, 236, 255), new Color(192, 197, 203, 255), new Color(190, 195, 201, 255), new Color(169, 174, 181, 255)};
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_3, double_4, fArray2, colorArray2);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(generalPath2);
        GeneralPath generalPath3 = new GeneralPath();
        generalPath3.setWindingRule(0);
        generalPath3.moveTo((double)n2 * 0.08411214953271028, (double)n3 * 0.49065420560747663);
        generalPath3.curveTo((double)n2 * 0.08411214953271028, (double)n3 * 0.5, (double)n2 * 0.08411214953271028, (double)n3 * 0.5046728971962616, (double)n2 * 0.08411214953271028, (double)n3 * 0.5093457943925234);
        generalPath3.curveTo((double)n2 * 0.20093457943925233, (double)n3 * 0.4532710280373832, (double)n2 * 0.32710280373831774, (double)n3 * 0.4158878504672897, (double)n2 * 0.49065420560747663, (double)n3 * 0.4158878504672897);
        generalPath3.curveTo((double)n2 * 0.6588785046728972, (double)n3 * 0.4158878504672897, (double)n2 * 0.794392523364486, (double)n3 * 0.4439252336448598, (double)n2 * 0.9158878504672897, (double)n3 * 0.514018691588785);
        generalPath3.curveTo((double)n2 * 0.9158878504672897, (double)n3 * 0.5046728971962616, (double)n2 * 0.9205607476635514, (double)n3 * 0.5, (double)n2 * 0.9158878504672897, (double)n3 * 0.49065420560747663);
        generalPath3.curveTo((double)n2 * 0.9158878504672897, (double)n3 * 0.2757009345794392, (double)n2 * 0.7476635514018691, (double)n3 * 0.08411214953271028, (double)n2 * 0.5, (double)n3 * 0.08411214953271028);
        generalPath3.curveTo((double)n2 * 0.2523364485981308, (double)n3 * 0.08411214953271028, (double)n2 * 0.08411214953271028, (double)n3 * 0.2803738317757009, (double)n2 * 0.08411214953271028, (double)n3 * 0.49065420560747663);
        generalPath3.closePath();
        Point2D.Double double_5 = new Point2D.Double(0.0, generalPath3.getBounds2D().getMinY());
        Point2D.Double double_6 = new Point2D.Double(0.0, generalPath3.getBounds2D().getMaxY());
        float[] fArray3 = new float[]{0.0f, 1.0f};
        Color[] colorArray3 = new Color[]{new Color(255, 255, 255, 63), new Color(255, 255, 255, 12)};
        LinearGradientPaint linearGradientPaint3 = new LinearGradientPaint(double_5, double_6, fArray3, colorArray3);
        graphics2D.setPaint(linearGradientPaint3);
        graphics2D.fill(generalPath3);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.CLOCK_TIMER)) {
            this.secondPointerAngle = (double)Calendar.getInstance().get(13) * 6.0 + (double)Calendar.getInstance().get(14) * 6.0 / 1000.0;
            this.hour = Calendar.getInstance().get(10) - this.timeZoneOffsetHour;
            if (this.hour > 12) {
                this.hour -= 12;
            }
            if (this.hour < 0) {
                this.hour += 12;
            }
            this.minute = Calendar.getInstance().get(12) + this.timeZoneOffsetMinute;
            if (this.minute > 60) {
                this.minute -= 60;
                ++this.hour;
            }
            if (this.minute < 0) {
                this.minute += 60;
                --this.hour;
            }
            this.hourPointerAngle = (double)this.hour * 6.0 * 5.0 + 0.5 * (double)this.minute;
            this.minutePointerAngle = (double)this.minute * 6.0;
            this.repaint(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public String toString() {
        return "Clock";
    }
}

