/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractRadial;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.ease.Spline;
import org.pushingpixels.trident.ease.TimelineEase;

public final class Altimeter
extends AbstractRadial {
    private double value100 = 0.0;
    private double oldValue = 0.0;
    private double value1000 = 0.0;
    private double value10000 = 0.0;
    private double angleStep100ft;
    private double angleStep1000ft;
    private double angleStep10000ft;
    private double TICKMARK_OFFSET = Math.PI;
    private float tickLabelPeriod = 1.0f;
    private BufferedImage backgroundImage;
    private BufferedImage tickmarksImage;
    private BufferedImage pointer10000FtImage;
    private BufferedImage pointer1000FtImage;
    private BufferedImage pointer100FtImage;
    private BufferedImage foregroundImage;
    private Timeline timeline = new Timeline((Object)this);
    private final TimelineCallback TIMELINE_CALLBACK = new TimelineCallback(){

        public void onTimelineStateChanged(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2, float f, float f2) {
        }

        public void onTimelinePulse(float f, float f2) {
        }
    };

    public Altimeter() {
        this.setMinValue(0.0);
        this.setMaxValue(10.0);
        this.calcAngleStep();
        this.setTitle("ALT");
        this.setUnitString("ft");
        this.addComponentListener(this);
        this.setSize(this.getPreferredSize());
        this.init(this.getWidth(), this.getWidth());
        this.timeline.addCallback(this.TIMELINE_CALLBACK);
    }

    @Override
    public void init(int n, int n2) {
        this.backgroundImage = this.create_BACKGROUND_Image(n, this.getTitle(), this.getUnitString());
        this.tickmarksImage = this.create_TICKMARKS_Image(n, 0.0, this.TICKMARK_OFFSET, 0.0, 10.0, this.angleStep100ft, (int)this.tickLabelPeriod);
        this.pointer100FtImage = this.create_100FT_POINTER_Image(n);
        this.pointer1000FtImage = this.create_1000FT_POINTER_Image(n);
        this.pointer10000FtImage = this.create_10000FT_POINTER_Image(n);
        this.foregroundImage = this.create_FOREGROUND_Image(n);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Point2D.Double double_ = new Point2D.Double((double)this.pointer100FtImage.getWidth() / 2.0, (double)this.pointer100FtImage.getWidth() / 2.0);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.drawImage((Image)this.backgroundImage, 0, 0, null);
        graphics2D.drawImage((Image)this.tickmarksImage, 0, 0, null);
        double d = (this.value10000 - this.getMinValue()) * this.angleStep10000ft;
        graphics2D.rotate(d, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.drawImage((Image)this.pointer10000FtImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        double d2 = (this.value1000 - this.getMinValue()) * this.angleStep1000ft;
        graphics2D.rotate(d2, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.drawImage((Image)this.pointer1000FtImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        double d3 = (this.value100 - this.getMinValue()) * this.angleStep100ft;
        graphics2D.rotate(d3, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.drawImage((Image)this.pointer100FtImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.drawImage((Image)this.foregroundImage, 0, 0, null);
    }

    @Override
    public void setValue(double d) {
        this.value100 = d % 1000.0 / 100.0;
        this.value1000 = d % 10000.0 / 100.0;
        this.value10000 = d % 100000.0 / 100.0;
        this.firePropertyChange("value", this.oldValue, d);
        this.oldValue = d;
        this.repaint();
    }

    @Override
    public void setValueAnimated(double d) {
        if (this.timeline.getState() == Timeline.TimelineState.PLAYING_FORWARD || this.timeline.getState() == Timeline.TimelineState.PLAYING_REVERSE) {
            this.timeline.abort();
        }
        this.timeline.addPropertyToInterpolate("value", (Object)this.oldValue, (Object)d);
        this.timeline.setEase((TimelineEase)new Spline(0.5f));
        double d2 = Math.abs(this.value100 - d);
        double d3 = d2 / 1000.0;
        this.timeline.setDuration((long)(1000.0 * d3));
        this.timeline.play();
    }

    @Override
    protected void calcAngleStep() {
        this.angleStep100ft = Math.PI * 2 / (this.getMaxValue() - this.getMinValue());
        this.angleStep1000ft = this.angleStep100ft / 10.0;
        this.angleStep10000ft = this.angleStep1000ft / 10.0;
    }

    @Override
    protected BufferedImage create_TICKMARKS_Image(int n, double d, double d2, double d3, double d4, double d5, int n2) {
        double d6;
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Font font = new Font("Verdana", 0, (int)(0.09 * (double)n));
        BasicStroke basicStroke = new BasicStroke(2.0f, 1, 2);
        BasicStroke basicStroke2 = new BasicStroke(1.5f, 1, 2);
        int n5 = (int)(0.17 * (double)n);
        int n6 = (int)(0.05 * (double)n);
        int n7 = (int)(0.07 * (double)n);
        Color color = super.getBackgroundColor().LABEL_COLOR;
        Color color2 = super.getBackgroundColor().LABEL_COLOR;
        float f = (float)n3 * 0.4f;
        Point2D.Double double_ = new Point2D.Double((float)n3 / 2.0f, (float)n4 / 2.0f);
        Point2D.Double double_2 = null;
        int n8 = 0;
        int n9 = 0;
        graphics2D.setFont(font);
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = d6 = -d2 - d / 2.0;
        float f2 = 0.0f;
        while (f2 <= 10.0f) {
            Line2D.Double double_3;
            Point2D.Double double_4;
            Point2D.Double double_5;
            graphics2D.setStroke(basicStroke2);
            d7 = Math.sin(d9);
            d8 = Math.cos(d9);
            if (n8 % 2 == 0) {
                graphics2D.setStroke(basicStroke2);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n6) * d7, ((Point2D)double_).getY() + (double)(f - (float)n6) * d8);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)f * d7, ((Point2D)double_).getY() + (double)f * d8);
                graphics2D.setColor(color2);
                double_3 = new Line2D.Double(((Point2D)double_5).getX(), ((Point2D)double_5).getY(), ((Point2D)double_4).getX(), ((Point2D)double_4).getY());
                graphics2D.draw(double_3);
            }
            if (n8 == 10 || n8 == 0) {
                graphics2D.setColor(color);
                graphics2D.setStroke(basicStroke);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n7) * d7, ((Point2D)double_).getY() + (double)(f - (float)n7) * d8);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)f * d7, ((Point2D)double_).getY() + (double)f * d8);
                double_2 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n5 + (float)font.getSize() / 2.0f) * d7, ((Point2D)double_).getY() + (double)(f - (float)n5 + (float)font.getSize() / 2.0f) * d8 + (double)((float)n5 / 2.5f));
                FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
                TextLayout textLayout = new TextLayout(String.valueOf(Math.round(f2)), graphics2D.getFont(), fontRenderContext);
                Rectangle2D rectangle2D = textLayout.getBounds();
                if (d == 0.0) {
                    if (Float.compare(f2, 10.0f) != 0) {
                        graphics2D.drawString(String.valueOf(Math.round(f2)), (int)(((Point2D)double_2).getX() - rectangle2D.getWidth() / 2.0), (int)(((Point2D)double_2).getY() - rectangle2D.getHeight() / 2.0));
                    }
                } else {
                    graphics2D.drawString(String.valueOf(Math.round(f2)), (int)(((Point2D)double_2).getX() - rectangle2D.getWidth() / 2.0), (int)(((Point2D)double_2).getY() - rectangle2D.getHeight() / 2.0));
                }
                n8 = 0;
                ++n9;
                graphics2D.setColor(color2);
                double_3 = new Line2D.Double(((Point2D)double_5).getX(), ((Point2D)double_5).getY(), ((Point2D)double_4).getX(), ((Point2D)double_4).getY());
                graphics2D.draw(double_3);
            }
            ++n8;
            d9 -= d5 * 0.1;
            f2 = (float)((double)f2 + 0.1);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_100FT_POINTER_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
        generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.4719626168224299, (double)n2 * 0.5093457943925234, (double)n3 * 0.4672897196261682, (double)n2 * 0.5093457943925234, (double)n3 * 0.4672897196261682);
        generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.20093457943925233);
        generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.16822429906542055);
        generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.20093457943925233);
        generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.4672897196261682);
        generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.4672897196261682, (double)n2 * 0.48130841121495327, (double)n3 * 0.4719626168224299, (double)n2 * 0.48130841121495327, (double)n3 * 0.4719626168224299);
        generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.48130841121495327, (double)n2 * 0.4672897196261682, (double)n3 * 0.49065420560747663, (double)n2 * 0.4672897196261682, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.514018691588785, (double)n2 * 0.4766355140186916, (double)n3 * 0.5280373831775701, (double)n2 * 0.49065420560747663, (double)n3 * 0.5327102803738317);
        generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.5327102803738317, (double)n2 * 0.49065420560747663, (double)n3 * 0.5794392523364486, (double)n2 * 0.49065420560747663, (double)n3 * 0.5887850467289719);
        generalPath.curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.5934579439252337, (double)n2 * 0.48130841121495327, (double)n3 * 0.5981308411214953, (double)n2 * 0.48130841121495327, (double)n3 * 0.6074766355140186);
        generalPath.curveTo((double)n2 * 0.48130841121495327, (double)n3 * 0.616822429906542, (double)n2 * 0.49065420560747663, (double)n3 * 0.6261682242990654, (double)n2 * 0.5, (double)n3 * 0.6261682242990654);
        generalPath.curveTo((double)n2 * 0.5093457943925234, (double)n3 * 0.6261682242990654, (double)n2 * 0.5186915887850467, (double)n3 * 0.616822429906542, (double)n2 * 0.5186915887850467, (double)n3 * 0.6074766355140186);
        generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5981308411214953, (double)n2 * 0.514018691588785, (double)n3 * 0.5934579439252337, (double)n2 * 0.5046728971962616, (double)n3 * 0.5887850467289719);
        generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.5794392523364486, (double)n2 * 0.5046728971962616, (double)n3 * 0.5327102803738317, (double)n2 * 0.5093457943925234, (double)n3 * 0.5327102803738317);
        generalPath.curveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.5280373831775701, (double)n2 * 0.5327102803738317, (double)n3 * 0.514018691588785, (double)n2 * 0.5327102803738317, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.49065420560747663, (double)n2 * 0.5280373831775701, (double)n3 * 0.48130841121495327, (double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.31f, 0.3101f, 0.32f, 1.0f};
        Color[] colorArray = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(32, 32, 32, 255), new Color(32, 32, 32, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_1000FT_POINTER_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
        generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.46261682242990654, (double)n2 * 0.5280373831775701, (double)n3 * 0.40186915887850466, (double)n2 * 0.5280373831775701, (double)n3 * 0.40186915887850466);
        generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.3317757009345794);
        generalPath.lineTo((double)n2 * 0.4719626168224299, (double)n3 * 0.40186915887850466);
        generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.40186915887850466, (double)n2 * 0.48598130841121495, (double)n3 * 0.46261682242990654, (double)n2 * 0.48130841121495327, (double)n3 * 0.4719626168224299);
        generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.48130841121495327, (double)n2 * 0.4672897196261682, (double)n3 * 0.49065420560747663, (double)n2 * 0.4672897196261682, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.514018691588785, (double)n2 * 0.4766355140186916, (double)n3 * 0.5280373831775701, (double)n2 * 0.49065420560747663, (double)n3 * 0.5327102803738317);
        generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.5327102803738317, (double)n2 * 0.46261682242990654, (double)n3 * 0.5747663551401869, (double)n2 * 0.46261682242990654, (double)n3 * 0.5934579439252337);
        generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.616822429906542, (double)n2 * 0.5, (double)n3 * 0.6121495327102804, (double)n2 * 0.5, (double)n3 * 0.6121495327102804);
        generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.6121495327102804, (double)n2 * 0.5327102803738317, (double)n3 * 0.616822429906542, (double)n2 * 0.5373831775700935, (double)n3 * 0.5934579439252337);
        generalPath.curveTo((double)n2 * 0.5373831775700935, (double)n3 * 0.5747663551401869, (double)n2 * 0.5093457943925234, (double)n3 * 0.5327102803738317, (double)n2 * 0.5093457943925234, (double)n3 * 0.5327102803738317);
        generalPath.curveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.5280373831775701, (double)n2 * 0.5327102803738317, (double)n3 * 0.514018691588785, (double)n2 * 0.5327102803738317, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.49065420560747663, (double)n2 * 0.5280373831775701, (double)n3 * 0.48130841121495327, (double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.51f, 0.52f, 0.5201f, 0.53f, 1.0f};
        Color[] colorArray = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(32, 32, 32, 255), new Color(32, 32, 32, 255), new Color(32, 32, 32, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_10000FT_POINTER_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
        generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.4719626168224299, (double)n2 * 0.514018691588785, (double)n3 * 0.4672897196261682, (double)n2 * 0.514018691588785, (double)n3 * 0.4672897196261682);
        generalPath.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.3177570093457944);
        generalPath.lineTo((double)n2 * 0.5046728971962616, (double)n3 * 0.3037383177570093);
        generalPath.lineTo((double)n2 * 0.5046728971962616, (double)n3 * 0.1822429906542056);
        generalPath.lineTo((double)n2 * 0.5327102803738317, (double)n3 * 0.11682242990654206);
        generalPath.lineTo((double)n2 * 0.46261682242990654, (double)n3 * 0.11682242990654206);
        generalPath.lineTo((double)n2 * 0.4953271028037383, (double)n3 * 0.1822429906542056);
        generalPath.lineTo((double)n2 * 0.4953271028037383, (double)n3 * 0.29906542056074764);
        generalPath.lineTo((double)n2 * 0.48598130841121495, (double)n3 * 0.3177570093457944);
        generalPath.lineTo((double)n2 * 0.48598130841121495, (double)n3 * 0.4672897196261682);
        generalPath.curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.4672897196261682, (double)n2 * 0.48598130841121495, (double)n3 * 0.4719626168224299, (double)n2 * 0.48130841121495327, (double)n3 * 0.4719626168224299);
        generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.48130841121495327, (double)n2 * 0.4672897196261682, (double)n3 * 0.49065420560747663, (double)n2 * 0.4672897196261682, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.5186915887850467, (double)n2 * 0.48130841121495327, (double)n3 * 0.5327102803738317, (double)n2 * 0.5, (double)n3 * 0.5327102803738317);
        generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5327102803738317, (double)n2 * 0.5327102803738317, (double)n3 * 0.5186915887850467, (double)n2 * 0.5327102803738317, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.49065420560747663, (double)n2 * 0.5280373831775701, (double)n3 * 0.48130841121495327, (double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
        generalPath.closePath();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public String toString() {
        return "Altimeter";
    }
}

