/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.tools.BackgroundColor;
import eu.hansolo.steelseries.tools.ConicalGradientPaint;
import eu.hansolo.steelseries.tools.FrameDesign;
import eu.hansolo.steelseries.tools.LedColor;
import eu.hansolo.steelseries.tools.PointerColor;
import eu.hansolo.steelseries.tools.Util;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Timer;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.ease.Sine;
import org.pushingpixels.trident.ease.Spline;
import org.pushingpixels.trident.ease.TimelineEase;

public abstract class AbstractRadial
extends AbstractGauge
implements ActionListener {
    protected static final Util UTIL = Util.INSTANCE;
    protected static final float ANGLE_CONST = 0.0027777778f;
    private String title = "Title";
    private String unitString = "unit";
    private double minValue = 0.0;
    private double maxValue = 100.0;
    private boolean autoResetToZero = false;
    private double threshold = this.maxValue;
    private boolean thresholdVisible = false;
    private double minMeasuredValue = this.maxValue;
    private boolean minMeasuredValueVisible = false;
    private double maxMeasuredValue = this.minValue;
    private boolean maxMeasuredValueVisible = false;
    private boolean trackVisible = false;
    private double trackStart = this.minValue;
    private double trackSection = 1.0;
    private double trackRange = 2.0;
    private Color trackStartColor = new Color(0.0f, 1.0f, 0.0f, 0.5f);
    private Color trackSectionColor = new Color(1.0f, 1.0f, 0.0f, 0.5f);
    private Color trackStopColor = new Color(1.0f, 0.0f, 0.0f, 0.5f);
    private BackgroundColor backgroundColor = BackgroundColor.DARK_GRAY;
    private FrameDesign frameDesign = FrameDesign.METAL;
    private PointerColor pointerColor = PointerColor.RED;
    private boolean ledVisible = true;
    private double ledPositionX = 0.6;
    private double ledPositionY = 0.4;
    private LedColor ledColor = LedColor.RED_LED;
    private BufferedImage ledImageOff = this.create_LED_Image(200, 0, this.ledColor);
    private BufferedImage ledImageOn = this.create_LED_Image(200, 1, this.ledColor);
    private BufferedImage currentLedImage;
    private final Timer LED_BLINKING_TIMER = new Timer(500, this);
    private boolean ledBlinking = false;
    private boolean ledOn;
    private final Timeline TIMELINE = new Timeline((Object)this);
    private final TimelineEase STANDARD_EASING = new Spline(0.5f);
    private final TimelineEase RETURN_TO_ZERO_EASING = new Sine();
    private final TimelineCallback TIMELINE_CALLBACK = new TimelineCallback(){

        public void onTimelineStateChanged(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2, float f, float f2) {
            if (AbstractRadial.this.autoResetToZero && timelineState == Timeline.TimelineState.PLAYING_FORWARD && timelineState2 == Timeline.TimelineState.DONE) {
                AbstractRadial.this.TIMELINE.end();
                AbstractRadial.this.TIMELINE.addPropertyToInterpolate("value", (Object)AbstractRadial.this.getValue(), (Object)0.0);
                AbstractRadial.this.TIMELINE.setEase(AbstractRadial.this.RETURN_TO_ZERO_EASING);
                AbstractRadial.this.TIMELINE.setDuration((long)(2000.0f * AbstractRadial.this.TIMELINE.getTimelinePosition()));
                AbstractRadial.this.TIMELINE.play();
            }
            if (timelineState2 == Timeline.TimelineState.DONE) {
                AbstractRadial.this.repaint(AbstractRadial.this.getBounds());
            }
        }

        public void onTimelinePulse(float f, float f2) {
            double d = AbstractRadial.this.getValue();
            if (!AbstractRadial.this.autoResetToZero) {
                if (d >= AbstractRadial.this.getThreshold()) {
                    if (!AbstractRadial.this.LED_BLINKING_TIMER.isRunning()) {
                        AbstractRadial.this.LED_BLINKING_TIMER.start();
                        AbstractRadial.this.firePropertyChange("threshold", false, true);
                    }
                } else {
                    AbstractRadial.this.LED_BLINKING_TIMER.stop();
                    AbstractRadial.this.setCurrentLedImage(AbstractRadial.this.getLedImageOff());
                    AbstractRadial.this.firePropertyChange("threshold", true, false);
                }
            }
            if (d > AbstractRadial.this.maxMeasuredValue) {
                AbstractRadial.this.maxMeasuredValue = d;
            }
            if (d < AbstractRadial.this.minMeasuredValue) {
                AbstractRadial.this.minMeasuredValue = d;
            }
            AbstractRadial.this.repaint(AbstractRadial.this.getBounds());
        }
    };

    public AbstractRadial() {
        this.addComponentListener(this);
        this.setMinimumSize(new Dimension(100, 100));
        this.setPreferredSize(new Dimension(200, 200));
        this.TIMELINE.addCallback(this.TIMELINE_CALLBACK);
    }

    @Override
    public void setValue(double d) {
        d = d > this.maxValue ? this.maxValue : d;
        double d2 = d = d < this.minValue ? this.minValue : d;
        if (!this.autoResetToZero) {
            this.repaint();
        }
        super.setValue(d);
    }

    public void setValueAnimated(double d) {
        if (this.TIMELINE.getState() != Timeline.TimelineState.IDLE) {
            this.TIMELINE.abort();
        }
        double d2 = this.getMaxValue() - this.getMinValue();
        double d3 = Math.abs(this.getValue() - d);
        double d4 = d3 / d2;
        this.TIMELINE.addPropertyToInterpolate("value", (Object)this.getValue(), (Object)d);
        if (this.autoResetToZero) {
            this.TIMELINE.setEase(this.RETURN_TO_ZERO_EASING);
            this.TIMELINE.setDuration((long)(800.0 * d4));
        } else {
            this.TIMELINE.setEase(this.STANDARD_EASING);
            this.TIMELINE.setDuration((long)(4500.0 * d4));
        }
        this.TIMELINE.play();
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double d) {
        this.minValue = d;
        if (d > 0.0) {
            this.setValue(d);
        }
        if (this.getThreshold() < d) {
            this.setThreshold(d);
        }
        this.resetMinMeasuredValue();
        this.resetMaxMeasuredValue();
        this.calcAngleStep();
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double d) {
        this.maxValue = d;
        if (this.getThreshold() > d) {
            this.setThreshold(d);
        }
        this.resetMinMeasuredValue();
        this.resetMaxMeasuredValue();
        this.calcAngleStep();
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    public boolean isAutoResetToZero() {
        return this.autoResetToZero;
    }

    public void setAutoResetToZero(boolean bl) {
        this.autoResetToZero = bl;
        if (bl) {
            this.setThresholdVisible(false);
            this.setLedVisible(false);
        }
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double d) {
        this.threshold = d;
        this.setValue(super.getValue());
    }

    public boolean isThresholdVisible() {
        return this.thresholdVisible;
    }

    public void setThresholdVisible(boolean bl) {
        this.thresholdVisible = bl;
        this.repaint();
    }

    public double getMinMeasuredValue() {
        return this.minMeasuredValue;
    }

    public boolean isMinMeasuredValueVisible() {
        return this.minMeasuredValueVisible;
    }

    public void setMinMeasuredValueVisible(boolean bl) {
        this.minMeasuredValueVisible = bl;
        this.repaint();
    }

    public void resetMinMeasuredValue() {
        this.minMeasuredValue = this.getMaxValue();
    }

    public double getMaxMeasuredValue() {
        return this.maxMeasuredValue;
    }

    public boolean isMaxMeasuredValueVisible() {
        return this.maxMeasuredValueVisible;
    }

    public void setMaxMeasuredValueVisible(boolean bl) {
        this.maxMeasuredValueVisible = bl;
        this.repaint();
    }

    public void resetMaxMeasuredValue() {
        this.maxMeasuredValue = this.getMinValue();
        this.repaint();
    }

    public boolean isTrackVisible() {
        return this.trackVisible;
    }

    public void setTrackVisible(boolean bl) {
        this.trackVisible = bl;
        this.repaint();
    }

    public double getTrackStart() {
        return this.trackStart;
    }

    public void setTrackStart(double d) {
        this.trackStart = d > this.getMaxValue() ? this.getMaxValue() - this.trackRange : d;
        this.trackStart = d < this.getMinValue() ? this.getMinValue() : d;
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    public double getTrackSection() {
        return this.trackSection;
    }

    public void setTrackSection(double d) {
        this.trackSection = d >= this.getMaxValue() ? (this.trackStart + this.trackRange) / 2.0 : d;
        this.trackSection = d <= this.getMinValue() ? (this.trackStart + this.trackRange) / 2.0 : d;
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    public double getTrackRange() {
        return this.trackRange;
    }

    public void setTrackRange(double d) {
        this.trackRange = d;
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    public Color getTrackStartColor() {
        return this.trackStartColor;
    }

    public void setTrackStartColor(Color color) {
        this.trackStartColor = color;
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    public Color getTrackSectionColor() {
        return this.trackSectionColor;
    }

    public void setTrackSectionColor(Color color) {
        this.trackSectionColor = color;
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    public Color getTrackStopColor() {
        return this.trackStopColor;
    }

    public void setTrackStopColor(Color color) {
        this.trackStopColor = color;
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    public BackgroundColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(BackgroundColor backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    public FrameDesign getFrameDesign() {
        return this.frameDesign;
    }

    public void setFrameDesign(FrameDesign frameDesign) {
        this.frameDesign = frameDesign;
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    public PointerColor getPointerColor() {
        return this.pointerColor;
    }

    public void setPointerColor(PointerColor pointerColor) {
        this.pointerColor = pointerColor;
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    public String getUnitString() {
        return this.unitString;
    }

    public void setUnitString(String string) {
        this.unitString = string;
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    public boolean isLedVisible() {
        return this.ledVisible;
    }

    public void setLedVisible(boolean bl) {
        this.ledVisible = bl;
        this.repaint();
    }

    protected double getLedPositionX() {
        return this.ledPositionX;
    }

    protected void setLedPositionX(double d) {
        this.ledPositionX = d;
    }

    protected double getLedPositionY() {
        return this.ledPositionY;
    }

    protected void setLedPositionY(double d) {
        this.ledPositionY = d;
    }

    public LedColor getLedColor() {
        return this.ledColor;
    }

    public void setLedColor(LedColor ledColor) {
        this.ledColor = ledColor;
        boolean bl = this.currentLedImage.equals(this.ledImageOn);
        this.ledImageOff = this.create_LED_Image(this.getWidth(), 0, ledColor);
        this.ledImageOn = this.create_LED_Image(this.getWidth(), 1, ledColor);
        this.currentLedImage = bl ? this.ledImageOn : this.ledImageOff;
        this.repaint();
    }

    public boolean isLedBlinking() {
        return this.ledBlinking;
    }

    public void setLedBlinking(boolean bl) {
        this.ledBlinking = bl;
        if (bl) {
            this.LED_BLINKING_TIMER.start();
        } else {
            this.setCurrentLedImage(this.getLedImageOff());
            this.LED_BLINKING_TIMER.stop();
        }
    }

    protected BufferedImage getLedImageOn() {
        return this.ledImageOn;
    }

    protected BufferedImage getLedImageOff() {
        return this.ledImageOff;
    }

    protected BufferedImage getCurrentLedImage() {
        return this.currentLedImage;
    }

    protected void setCurrentLedImage(BufferedImage bufferedImage) {
        this.currentLedImage = bufferedImage;
        this.repaint();
    }

    protected abstract void calcAngleStep();

    protected BufferedImage create_BACKGROUND_Image(int n) {
        return this.create_BACKGROUND_Image(n, "", "");
    }

    protected BufferedImage create_BACKGROUND_Image(int n, String string, String string2) {
        Rectangle2D rectangle2D;
        TextLayout textLayout;
        Paint paint;
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double((double)n2 * 0.0, (double)n3 * 0.0, (double)n2 * 1.0, (double)n3 * 1.0);
        Color color = new Color(0x848484);
        graphics2D.setColor(color);
        graphics2D.fill(double_);
        Ellipse2D.Double double_2 = new Ellipse2D.Double((double)n2 * 0.004672897048294544, (double)n3 * 0.004672897048294544, (double)n2 * 0.9906542301177979, (double)n3 * 0.9906542301177979);
        Point2D.Double double_3 = new Point2D.Double(0.0, double_2.getBounds2D().getMinY());
        Point2D.Double double_4 = new Point2D.Double(0.0, double_2.getBounds2D().getMaxY());
        Point2D.Double double_5 = new Point2D.Double(double_2.getCenterX(), double_2.getCenterY());
        switch (this.frameDesign) {
            case BLACK_METAL: {
                float[] fArray = new float[]{0.0f, 45.0f, 125.0f, 180.0f, 245.0f, 315.0f, 360.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(254, 254, 254, 255)};
                paint = new ConicalGradientPaint(true, double_5, 0.0f, fArray, colorArray);
                break;
            }
            case METAL: {
                float[] fArray = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                paint = new LinearGradientPaint(double_3, double_4, fArray, colorArray);
                break;
            }
            case SHINY_METAL: {
                float[] fArray = new float[]{0.0f, 45.0f, 90.0f, 125.0f, 180.0f, 245.0f, 270.0f, 315.0f, 360.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(238, 238, 238, 255), new Color(160, 160, 160, 255), new Color(238, 238, 238, 255), new Color(179, 179, 179, 255), new Color(210, 210, 210, 255), new Color(254, 254, 254, 255)};
                paint = new ConicalGradientPaint(true, double_5, 0.0f, fArray, colorArray);
                break;
            }
            default: {
                float[] fArray = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                paint = new LinearGradientPaint(double_3, double_4, fArray, colorArray);
            }
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(double_2);
        Ellipse2D.Double double_6 = new Ellipse2D.Double((double)n2 * 0.07943925261497498, (double)n3 * 0.07943925261497498, (double)n2 * 0.8411215543746948, (double)n3 * 0.8411215543746948);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(double_6);
        Ellipse2D.Double double_7 = new Ellipse2D.Double((double)n2 * 0.08411215245723724, (double)n3 * 0.08411215245723724, (double)n2 * 0.8317756652832031, (double)n3 * 0.8317756652832031);
        Point2D.Double double_8 = new Point2D.Double(0.0, double_7.getBounds2D().getMinY());
        Point2D.Double double_9 = new Point2D.Double(0.0, double_7.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.4f, 1.0f};
        Color[] colorArray = new Color[]{this.backgroundColor.GRADIENT_START_COLOR, this.backgroundColor.GRADIENT_FRACTION_COLOR, this.backgroundColor.GRADIENT_STOP_COLOR};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_8, double_9, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_7);
        Ellipse2D.Double double_10 = new Ellipse2D.Double((double)n2 * 0.08411215245723724, (double)n3 * 0.08411215245723724, (double)n2 * 0.8317756652832031, (double)n3 * 0.8317756652832031);
        Point2D.Double double_11 = new Point2D.Double(0.5 * (double)n2, 0.5 * (double)n3);
        float[] fArray2 = new float[]{0.0f, 0.7f, 0.71f, 1.0f};
        Color[] colorArray2 = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 75)};
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_11, (float)(0.4158878504672897 * (double)n2), fArray2, colorArray2);
        graphics2D.setPaint(radialGradientPaint);
        graphics2D.fill(double_10);
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        if (!string.isEmpty()) {
            graphics2D.setColor(this.backgroundColor.LABEL_COLOR);
            graphics2D.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)n2)));
            textLayout = new TextLayout(string, graphics2D.getFont(), fontRenderContext);
            rectangle2D = textLayout.getBounds();
            graphics2D.drawString(string, (float)(((double)n2 - rectangle2D.getWidth()) / 2.0), 0.3f * (float)n3 + textLayout.getAscent() - textLayout.getDescent());
        }
        if (!string2.isEmpty()) {
            graphics2D.setColor(this.backgroundColor.LABEL_COLOR);
            graphics2D.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)n2)));
            textLayout = new TextLayout(string2, graphics2D.getFont(), fontRenderContext);
            rectangle2D = textLayout.getBounds();
            graphics2D.drawString(string2, (float)(((double)n2 - rectangle2D.getWidth()) / 2.0), 0.38f * (float)n3 + textLayout.getAscent() - textLayout.getDescent());
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_TRACK_Image(boolean bl, int n, double d, double d2, double d3, double d4, double d5, double d6, Color color, Color color2, Color color3, double d7) {
        Color[] colorArray;
        float[] fArray;
        float f;
        if (n <= 0) {
            return null;
        }
        if (d4 + d6 > d2) {
            throw new IllegalArgumentException("Please adjust track start and/or track range values");
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Point2D.Double double_ = new Point2D.Double((double)n2 / 2.0, (double)n3 / 2.0);
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.11682242990654206);
        generalPath.curveTo((double)n2 * 0.7149532710280374, (double)n3 * 0.11682242990654206, (double)n2 * 0.8878504672897196, (double)n3 * 0.2897196261682243, (double)n2 * 0.8878504672897196, (double)n3 * 0.5046728971962616);
        generalPath.curveTo((double)n2 * 0.8878504672897196, (double)n3 * 0.7149532710280374, (double)n2 * 0.7149532710280374, (double)n3 * 0.8878504672897196, (double)n2 * 0.5046728971962616, (double)n3 * 0.8878504672897196);
        generalPath.curveTo((double)n2 * 0.2897196261682243, (double)n3 * 0.8878504672897196, (double)n2 * 0.11682242990654206, (double)n3 * 0.7149532710280374, (double)n2 * 0.11682242990654206, (double)n3 * 0.5046728971962616);
        generalPath.curveTo((double)n2 * 0.11682242990654206, (double)n3 * 0.2897196261682243, (double)n2 * 0.2897196261682243, (double)n3 * 0.11682242990654206, (double)n2 * 0.5046728971962616, (double)n3 * 0.11682242990654206);
        generalPath.closePath();
        generalPath.moveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.14953271028037382);
        generalPath.curveTo((double)n2 * 0.6962616822429907, (double)n3 * 0.14953271028037382, (double)n2 * 0.8551401869158879, (double)n3 * 0.308411214953271, (double)n2 * 0.8551401869158879, (double)n3 * 0.5046728971962616);
        generalPath.curveTo((double)n2 * 0.8551401869158879, (double)n3 * 0.6962616822429907, (double)n2 * 0.6962616822429907, (double)n3 * 0.8551401869158879, (double)n2 * 0.5046728971962616, (double)n3 * 0.8551401869158879);
        generalPath.curveTo((double)n2 * 0.308411214953271, (double)n3 * 0.8551401869158879, (double)n2 * 0.14953271028037382, (double)n3 * 0.6962616822429907, (double)n2 * 0.14953271028037382, (double)n3 * 0.5046728971962616);
        generalPath.curveTo((double)n2 * 0.14953271028037382, (double)n3 * 0.308411214953271, (double)n2 * 0.308411214953271, (double)n3 * 0.14953271028037382, (double)n2 * 0.5046728971962616, (double)n3 * 0.14953271028037382);
        generalPath.closePath();
        Color color4 = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        float f2 = (float)Math.toDegrees((d4 - d) * d3);
        float f3 = 0.0027777778f * (float)Math.toDegrees((d4 + d6 - d) * d3) - 0.0027777778f * f2 >= 0.999f ? 0.998f : 0.0027777778f * (float)Math.toDegrees((d4 + d6 - d) * d3) - 0.0027777778f * f2;
        if (bl) {
            f = (float)((d5 - d4) / d6) * f3;
            fArray = new float[]{0.0f, 1.0E-6f, f, f3, f3 + 0.001f, 1.0f};
            colorArray = new Color[]{color4, color, color2, color3, color4, color4};
        } else {
            fArray = new float[]{0.0f, 1.0E-6f, f3, f3 + 0.001f, 1.0f};
            colorArray = new Color[]{color4, color, color3, color4, color4};
        }
        f = -0.0027777778f * (360.0f - (float)Math.toDegrees(d7)) + 0.0027777778f * f2;
        ConicalGradientPaint conicalGradientPaint = new ConicalGradientPaint(false, double_, f, fArray, colorArray);
        graphics2D.setPaint(conicalGradientPaint);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_TICKMARKS_Image(int n, double d, double d2, double d3, double d4, double d5, int n2) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Font font = new Font("Verdana", 0, (int)(0.04 * (double)n));
        BasicStroke basicStroke = new BasicStroke(1.0f, 1, 2);
        BasicStroke basicStroke2 = new BasicStroke(0.5f, 1, 2);
        BasicStroke basicStroke3 = new BasicStroke(0.3f, 1, 2);
        BasicStroke basicStroke4 = new BasicStroke(0.1f, 1, 2);
        int n5 = (int)(0.09 * (double)n);
        int n6 = (int)(0.01 * (double)n);
        int n7 = (int)(0.0133333333 * (double)n);
        int n8 = (int)(0.02 * (double)n);
        int n9 = (int)(0.03 * (double)n);
        int n10 = (int)(0.04 * (double)n);
        float f = (float)n3 * 0.38f;
        Point2D.Double double_ = new Point2D.Double((float)n3 / 2.0f, (float)n4 / 2.0f);
        Point2D.Double double_2 = null;
        int n11 = 0;
        int n12 = 0;
        graphics2D.setFont(font);
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = -d2 - d / 2.0;
        double d9 = d4 - d3;
        float f2 = (float)((int)Math.toDegrees(d9 * d5 + d)) / 360.0f;
        int n13 = (int)(20.0f * f2);
        int n14 = (int)(300.0f * f2);
        int n15 = (int)(800.0f * f2);
        double d10 = d8;
        for (double d11 = d3; d11 <= d4; d11 += 1.0) {
            Line2D.Double double_3;
            graphics2D.setStroke(basicStroke2);
            d6 = Math.sin(d10);
            d7 = Math.cos(d10);
            double_2 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n5) * d6, ((Point2D)double_).getY() + (double)(f - (float)n5) * d7);
            Point2D.Double double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n7) * d6, ((Point2D)double_).getY() + (double)(f - (float)n7) * d7);
            Point2D.Double double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)f * d6, ((Point2D)double_).getY() + (double)f * d7);
            graphics2D.setColor(this.backgroundColor.LABEL_COLOR);
            if (d9 <= (double)n13 && Double.compare(d10, d8) != 0) {
                graphics2D.setStroke(basicStroke4);
                for (double d12 = d10 + d5; d12 > d10; d12 -= d5 / 10.0) {
                    double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n6) * Math.sin(d12), ((Point2D)double_).getY() + (double)(f - (float)n6) * Math.cos(d12));
                    double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)f * Math.sin(d12), ((Point2D)double_).getY() + (double)f * Math.cos(d12));
                    double_3 = new Line2D.Double(((Point2D)double_4).getX(), ((Point2D)double_4).getY(), ((Point2D)double_5).getX(), ((Point2D)double_5).getY());
                    graphics2D.draw(double_3);
                }
            }
            if (n11 % 5 != 0 && n11 % 10 != 0 && n11 % 100 != 0 && d9 < (double)n14) {
                graphics2D.setStroke(basicStroke3);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n7) * d6, ((Point2D)double_).getY() + (double)(f - (float)n7) * d7);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)f * d6, ((Point2D)double_).getY() + (double)f * d7);
                double_3 = new Line2D.Double(((Point2D)double_4).getX(), ((Point2D)double_4).getY(), ((Point2D)double_5).getX(), ((Point2D)double_5).getY());
                graphics2D.draw(double_3);
            }
            if (n11 % 5 == 0 && n11 % 10 != 0 && n11 % 100 != 0 && d9 < (double)n15) {
                graphics2D.setStroke(basicStroke2);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n8) * d6, ((Point2D)double_).getY() + (double)(f - (float)n8) * d7);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)f * d6, ((Point2D)double_).getY() + (double)f * d7);
                double_3 = new Line2D.Double(((Point2D)double_4).getX(), ((Point2D)double_4).getY(), ((Point2D)double_5).getX(), ((Point2D)double_5).getY());
                graphics2D.draw(double_3);
            }
            if (n11 % 10 == 0 && n11 % 100 != 0 || n11 == 0 && d9 < (double)n15) {
                graphics2D.setStroke(basicStroke);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n9) * d6, ((Point2D)double_).getY() + (double)(f - (float)n9) * d7);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)f * d6, ((Point2D)double_).getY() + (double)f * d7);
                double_3 = new Line2D.Double(((Point2D)double_4).getX(), ((Point2D)double_4).getY(), ((Point2D)double_5).getX(), ((Point2D)double_5).getY());
                graphics2D.draw(double_3);
            }
            if (n11 == 100) {
                graphics2D.setStroke(basicStroke);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n10) * d6, ((Point2D)double_).getY() + (double)(f - (float)n10) * d7);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)f * d6, ((Point2D)double_).getY() + (double)f * d7);
                double_3 = new Line2D.Double(((Point2D)double_4).getX(), ((Point2D)double_4).getY(), ((Point2D)double_5).getX(), ((Point2D)double_5).getY());
                graphics2D.draw(double_3);
                n11 = 0;
                ++n12;
            }
            if (d11 % (double)n2 == 0.0) {
                graphics2D.setColor(this.backgroundColor.LABEL_COLOR);
                graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, String.valueOf((int)d11), (int)((Point2D)double_2).getX(), (int)((Point2D)double_2).getY(), Math.toDegrees(Math.PI - d10)));
            }
            ++n11;
            d10 -= d5;
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_POSTS_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double((double)n2 * 0.336448609828949, (double)n3 * 0.8037382960319519, (double)n2 * 0.03738316893577576, (double)n3 * (double)0.0373832f);
        Point2D.Double double_2 = new Point2D.Double(0.0, double_.getBounds2D().getMinY());
        Point2D.Double double_3 = new Point2D.Double(0.0, double_.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.46f, 1.0f};
        Color[] colorArray = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_);
        Ellipse2D.Double double_4 = new Ellipse2D.Double((double)n2 * (double)0.3411215f, (double)n3 * 0.8084112405776978, (double)n2 * 0.02803736925125122, (double)n3 * 0.02803736925125122);
        Point2D.Double double_5 = new Point2D.Double(0.0, double_4.getBounds2D().getMinY());
        Point2D.Double double_6 = new Point2D.Double(0.0, double_4.getBounds2D().getMaxY());
        float[] fArray2 = new float[]{0.0f, 1.0f};
        Color[] colorArray2 = new Color[]{new Color(217, 217, 217, 255), new Color(191, 191, 191, 255)};
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_5, double_6, fArray2, colorArray2);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(double_4);
        Ellipse2D.Double double_7 = new Ellipse2D.Double((double)n2 * (double)0.3411215f, (double)n3 * 0.8084112405776978, (double)n2 * 0.02803736925125122, (double)n3 * 0.02803736925125122);
        Point2D.Double double_8 = new Point2D.Double(0.35514018691588783 * (double)n2, 0.8177570093457944 * (double)n3);
        float[] fArray3 = new float[]{0.0f, 0.75f, 0.76f, 1.0f};
        Color[] colorArray3 = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 1), new Color(0, 0, 0, 51)};
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_8, (float)(0.014018691588785047 * (double)n2), fArray3, colorArray3);
        graphics2D.setPaint(radialGradientPaint);
        graphics2D.fill(double_7);
        Ellipse2D.Double double_9 = new Ellipse2D.Double((double)n2 * 0.6261682510375977, (double)n3 * 0.8037382960319519, (double)n2 * 0.03738313913345337, (double)n3 * (double)0.0373832f);
        Point2D.Double double_10 = new Point2D.Double(0.0, double_9.getBounds2D().getMinY());
        Point2D.Double double_11 = new Point2D.Double(0.0, double_9.getBounds2D().getMaxY());
        float[] fArray4 = new float[]{0.0f, 0.46f, 1.0f};
        Color[] colorArray4 = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
        LinearGradientPaint linearGradientPaint3 = new LinearGradientPaint(double_10, double_11, fArray4, colorArray4);
        graphics2D.setPaint(linearGradientPaint3);
        graphics2D.fill(double_9);
        Ellipse2D.Double double_12 = new Ellipse2D.Double((double)n2 * 0.6308411359786987, (double)n3 * 0.8084112405776978, (double)n2 * 0.02803736925125122, (double)n3 * 0.02803736925125122);
        Point2D.Double double_13 = new Point2D.Double(0.0, double_12.getBounds2D().getMinY());
        Point2D.Double double_14 = new Point2D.Double(0.0, double_12.getBounds2D().getMaxY());
        float[] fArray5 = new float[]{0.0f, 1.0f};
        Color[] colorArray5 = new Color[]{new Color(217, 217, 217, 255), new Color(191, 191, 191, 255)};
        LinearGradientPaint linearGradientPaint4 = new LinearGradientPaint(double_13, double_14, fArray5, colorArray5);
        graphics2D.setPaint(linearGradientPaint4);
        graphics2D.fill(double_12);
        Ellipse2D.Double double_15 = new Ellipse2D.Double((double)n2 * 0.6308411359786987, (double)n3 * 0.8084112405776978, (double)n2 * 0.02803736925125122, (double)n3 * 0.02803736925125122);
        Point2D.Double double_16 = new Point2D.Double(0.6448598130841121 * (double)n2, 0.8177570093457944 * (double)n3);
        float[] fArray6 = new float[]{0.0f, 0.75f, 0.76f, 1.0f};
        Color[] colorArray6 = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 1), new Color(0, 0, 0, 51)};
        RadialGradientPaint radialGradientPaint2 = new RadialGradientPaint(double_16, (float)(0.014018691588785047 * (double)n2), fArray6, colorArray6);
        graphics2D.setPaint(radialGradientPaint2);
        graphics2D.fill(double_15);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_THRESHOLD_Image(int n) {
        if (n <= 0) {
            return null;
        }
        int n2 = (int)((double)n * 0.046728972);
        int n3 = (int)((double)n2 * 0.9);
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n3, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n3 * 0.5, 0.1);
        generalPath.lineTo((double)n3 * 0.9, (double)n2 * 0.9);
        generalPath.lineTo((double)n3 * 0.1, (double)n2 * 0.9);
        generalPath.lineTo((double)n3 * 0.5, 0.1);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
        Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        float[] fArray = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
        Color[] colorArray = new Color[]{new Color(82, 0, 0, 255), new Color(252, 29, 0, 255), new Color(252, 29, 0, 255), new Color(82, 0, 0, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        graphics2D.setColor(Color.WHITE);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics2D.draw(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_MEASURED_VALUE_Image(int n, Color color) {
        int n2;
        if (n <= 0) {
            return null;
        }
        int n3 = n2 = (int)((double)n * 0.0280373832);
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n3, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n3 * 0.5, (double)n2);
        generalPath.lineTo(0.0, 0.0);
        generalPath.lineTo((double)n3, 0.0);
        generalPath.closePath();
        graphics2D.setColor(color);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_FOREGROUND_Image(int n) {
        return this.create_FOREGROUND_Image(n, true);
    }

    protected BufferedImage create_FOREGROUND_Image(int n, boolean bl) {
        LinearGradientPaint linearGradientPaint;
        Color[] colorArray;
        float[] fArray;
        Point2D.Double double_;
        Point2D.Double double_2;
        Shape shape;
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        if (bl) {
            shape = new Ellipse2D.Double((double)n2 * 0.4579439163208008, (double)n3 * 0.4579439163208008, (double)n2 * 0.08411216735839844, (double)n3 * 0.08411216735839844);
            double_2 = new Point2D.Double(0.0, shape.getBounds2D().getMinY());
            double_ = new Point2D.Double(0.0, shape.getBounds2D().getMaxY());
            fArray = new float[]{0.0f, 0.46f, 1.0f};
            colorArray = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
            linearGradientPaint = new LinearGradientPaint(double_2, double_, fArray, colorArray);
            graphics2D.setPaint(linearGradientPaint);
            graphics2D.fill(shape);
            Ellipse2D.Double double_3 = new Ellipse2D.Double((double)n2 * 0.4672897160053253, (double)n3 * 0.4672897160053253, (double)n2 * 0.06542053818702698, (double)n3 * 0.06542053818702698);
            Point2D.Double double_4 = new Point2D.Double(0.0, double_3.getBounds2D().getMinY());
            Point2D.Double double_5 = new Point2D.Double(0.0, double_3.getBounds2D().getMaxY());
            float[] fArray2 = new float[]{0.0f, 1.0f};
            Color[] colorArray2 = new Color[]{new Color(217, 217, 217, 255), new Color(191, 191, 191, 255)};
            LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_4, double_5, fArray2, colorArray2);
            graphics2D.setPaint(linearGradientPaint2);
            graphics2D.fill(double_3);
            Ellipse2D.Double double_6 = new Ellipse2D.Double((double)n2 * 0.4672897160053253, (double)n3 * 0.4672897160053253, (double)n2 * 0.06542053818702698, (double)n3 * 0.06542053818702698);
            Point2D.Double double_7 = new Point2D.Double(0.4953271028037383 * (double)n2, 0.49065420560747663 * (double)n3);
            float[] fArray3 = new float[]{0.0f, 0.75f, 0.76f, 1.0f};
            Color[] colorArray3 = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 1), new Color(0, 0, 0, 51)};
            RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_7, (float)(0.03271028037383177 * (double)n2), fArray3, colorArray3);
            graphics2D.setPaint(radialGradientPaint);
            graphics2D.fill(double_6);
        }
        shape = new GeneralPath();
        ((Path2D)shape).setWindingRule(0);
        ((Path2D.Float)shape).moveTo((double)n2 * 0.08411214953271028, (double)n3 * 0.49065420560747663);
        ((Path2D.Float)shape).curveTo((double)n2 * 0.08411214953271028, (double)n3 * 0.5, (double)n2 * 0.08411214953271028, (double)n3 * 0.5046728971962616, (double)n2 * 0.08411214953271028, (double)n3 * 0.5093457943925234);
        ((Path2D.Float)shape).curveTo((double)n2 * 0.20093457943925233, (double)n3 * 0.4532710280373832, (double)n2 * 0.32710280373831774, (double)n3 * 0.4158878504672897, (double)n2 * 0.49065420560747663, (double)n3 * 0.4158878504672897);
        ((Path2D.Float)shape).curveTo((double)n2 * 0.6588785046728972, (double)n3 * 0.4158878504672897, (double)n2 * 0.794392523364486, (double)n3 * 0.4439252336448598, (double)n2 * 0.9158878504672897, (double)n3 * 0.514018691588785);
        ((Path2D.Float)shape).curveTo((double)n2 * 0.9158878504672897, (double)n3 * 0.5046728971962616, (double)n2 * 0.9205607476635514, (double)n3 * 0.5, (double)n2 * 0.9158878504672897, (double)n3 * 0.49065420560747663);
        ((Path2D.Float)shape).curveTo((double)n2 * 0.9158878504672897, (double)n3 * 0.2757009345794392, (double)n2 * 0.7476635514018691, (double)n3 * 0.08411214953271028, (double)n2 * 0.5, (double)n3 * 0.08411214953271028);
        ((Path2D.Float)shape).curveTo((double)n2 * 0.2523364485981308, (double)n3 * 0.08411214953271028, (double)n2 * 0.08411214953271028, (double)n3 * 0.2803738317757009, (double)n2 * 0.08411214953271028, (double)n3 * 0.49065420560747663);
        ((Path2D)shape).closePath();
        double_2 = new Point2D.Double(0.0, ((Path2D.Float)shape).getBounds2D().getMinY());
        double_ = new Point2D.Double(0.0, ((Path2D.Float)shape).getBounds2D().getMaxY());
        fArray = new float[]{0.0f, 1.0f};
        colorArray = new Color[]{new Color(255, 255, 255, 63), new Color(255, 255, 255, 12)};
        linearGradientPaint = new LinearGradientPaint(double_2, double_, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(shape);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_LED_Image(int n, int n2, LedColor ledColor) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage((int)((double)n * 0.0934579439), (int)((double)n * 0.0934579439), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double(0.25 * (double)n3, 0.25 * (double)n4, 0.5 * (double)n3, 0.5 * (double)n4);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(0.0, 0.0, n3, n4);
        Point2D.Double double_3 = new Point2D.Double(double_.getCenterX(), double_.getCenterY());
        float[] fArray = new float[]{0.0f, 0.2f, 1.0f};
        Color[] colorArray = new Color[]{ledColor.INNER_COLOR1_OFF, ledColor.INNER_COLOR2_OFF, ledColor.OUTER_COLOR_OFF};
        Color[] colorArray2 = new Color[]{ledColor.INNER_COLOR1_ON, ledColor.INNER_COLOR2_ON, ledColor.OUTER_COLOR_ON};
        float[] fArray2 = new float[]{0.0f, 0.8f, 1.0f};
        Color[] colorArray3 = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.4f)};
        float[] fArray3 = new float[]{0.0f, 0.6f, 0.7f, 0.8f, 0.85f, 1.0f};
        Color[] colorArray4 = new Color[]{UTIL.setAlpha(ledColor.CORONA_COLOR, 0.0f), UTIL.setAlpha(ledColor.CORONA_COLOR, 0.4f), UTIL.setAlpha(ledColor.CORONA_COLOR, 0.25f), UTIL.setAlpha(ledColor.CORONA_COLOR, 0.15f), UTIL.setAlpha(ledColor.CORONA_COLOR, 0.05f), UTIL.setAlpha(ledColor.CORONA_COLOR, 0.0f)};
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_3, 0.25f * (float)n3, fArray, colorArray);
        RadialGradientPaint radialGradientPaint2 = new RadialGradientPaint(double_3, 0.25f * (float)n3, fArray, colorArray2);
        RadialGradientPaint radialGradientPaint3 = new RadialGradientPaint(double_3, 0.25f * (float)n3, fArray2, colorArray3);
        RadialGradientPaint radialGradientPaint4 = new RadialGradientPaint(double_3, 0.5f * (float)n3, fArray3, colorArray4);
        Ellipse2D.Double double_4 = new Ellipse2D.Double(0.4 * (double)n3, 0.35 * (double)n3, 0.2 * (double)n3, 0.15 * (double)n3);
        Point2D.Double double_5 = new Point2D.Double(0.0, double_4.getMinY());
        Point2D.Double double_6 = new Point2D.Double(0.0, double_4.getMaxY());
        float[] fArray4 = new float[]{0.0f, 1.0f};
        Color[] colorArray5 = new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.4f), new Color(1.0f, 1.0f, 1.0f, 0.0f)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_5, double_6, fArray4, colorArray5);
        switch (n2) {
            case 0: {
                graphics2D.setPaint(radialGradientPaint);
                graphics2D.fill(double_);
                graphics2D.setPaint(radialGradientPaint3);
                graphics2D.fill(double_);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(double_4);
                break;
            }
            case 1: {
                graphics2D.setPaint(radialGradientPaint4);
                graphics2D.fill(double_2);
                graphics2D.setPaint(radialGradientPaint2);
                graphics2D.fill(double_);
                graphics2D.setPaint(radialGradientPaint3);
                graphics2D.fill(double_);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(double_4);
                break;
            }
            default: {
                graphics2D.setPaint(radialGradientPaint);
                graphics2D.fill(double_);
                graphics2D.setPaint(radialGradientPaint3);
                graphics2D.fill(double_);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(double_4);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public Dimension getSize() {
        if (this.getWidth() < this.getMinimumSize().width || this.getHeight() < this.getMinimumSize().height) {
            return this.getMinimumSize();
        }
        return new Dimension(this.getWidth(), this.getWidth());
    }

    @Override
    public Dimension getSize(Dimension dimension) {
        if (this.getWidth() < this.getMinimumSize().width || this.getHeight() < this.getMinimumSize().height) {
            return this.getMinimumSize();
        }
        return new Dimension(this.getWidth(), this.getWidth());
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.getWidth() < this.getMinimumSize().width || this.getHeight() < this.getMinimumSize().height) {
            this.setPreferredSize(this.getMinimumSize());
            this.setSize(this.getMinimumSize());
        }
        this.setSize(this.getWidth(), this.getWidth());
        this.ledImageOff = this.create_LED_Image(this.getWidth(), 0, this.ledColor);
        this.ledImageOn = this.create_LED_Image(this.getWidth(), 1, this.ledColor);
        if (this.ledOn) {
            this.setCurrentLedImage(this.ledImageOn);
        } else {
            this.setCurrentLedImage(this.ledImageOff);
        }
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.LED_BLINKING_TIMER)) {
            this.currentLedImage = this.ledOn ? this.getLedImageOn() : this.getLedImageOff();
            this.ledOn ^= true;
            this.repaint((int)((double)this.getWidth() * this.ledPositionX), (int)((double)this.getHeight() * this.ledPositionY), this.currentLedImage.getWidth(), this.currentLedImage.getHeight());
        }
    }

    @Override
    public String toString() {
        return "AbstractRadial";
    }
}

