/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.tools.BackgroundColor;
import eu.hansolo.steelseries.tools.ConicalGradientPaint;
import eu.hansolo.steelseries.tools.FrameDesign;
import eu.hansolo.steelseries.tools.LedColor;
import eu.hansolo.steelseries.tools.Shadow;
import eu.hansolo.steelseries.tools.Util;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Timer;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.ease.Sine;
import org.pushingpixels.trident.ease.Spline;
import org.pushingpixels.trident.ease.TimelineEase;

public abstract class AbstractLinear
extends AbstractGauge
implements ActionListener {
    protected static final Util UTIL = Util.INSTANCE;
    private String title = "Title";
    private String unitString = "unit";
    private double minValue = 0.0;
    private double maxValue = 100.0;
    private boolean autoResetToZero = false;
    private double threshold = this.maxValue;
    private boolean thresholdVisible = false;
    private boolean trackVisible = false;
    private double trackStart = this.minValue;
    private double trackSection = 1.0;
    private double trackRange = 2.0;
    private Color trackStartColor = new Color(0.0f, 1.0f, 0.0f, 0.5f);
    private Color trackSectionColor = new Color(1.0f, 1.0f, 0.0f, 0.5f);
    private Color trackStopColor = new Color(1.0f, 0.0f, 0.0f, 0.5f);
    private BackgroundColor backgroundColor = BackgroundColor.DARK_GRAY;
    private FrameDesign frameDesign = FrameDesign.METAL;
    private double minMeasuredValue = this.maxValue;
    private boolean minMeasuredValueVisible = false;
    private double maxMeasuredValue = this.minValue;
    private boolean maxMeasuredValueVisible = false;
    private boolean ledVisible = true;
    private double ledPositionX = 60.0;
    private double ledPositionY = 20.0;
    private LedColor ledColor = LedColor.RED_LED;
    private BufferedImage ledImageOff = this.create_LED_Image(140, 0, this.ledColor);
    private BufferedImage ledImageOn = this.create_LED_Image(140, 1, this.ledColor);
    private BufferedImage currentLedImage;
    private final Timer LED_BLINKING_TIMER = new Timer(500, this);
    private boolean ledBlinking = false;
    private boolean ledOn;
    private final Timeline TIMELINE = new Timeline((Object)this);
    private final TimelineEase STANDARD_EASING = new Spline(0.5f);
    private final TimelineEase RETURN_TO_ZERO_EASING = new Sine();
    private final TimelineCallback TIMELINE_CALLBACK = new TimelineCallback(){

        public void onTimelineStateChanged(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2, float f, float f2) {
            if (AbstractLinear.this.autoResetToZero && timelineState == Timeline.TimelineState.PLAYING_FORWARD && timelineState2 == Timeline.TimelineState.DONE) {
                AbstractLinear.this.TIMELINE.end();
                AbstractLinear.this.TIMELINE.addPropertyToInterpolate("value", (Object)AbstractLinear.this.getValue(), (Object)0.0);
                AbstractLinear.this.TIMELINE.setEase(AbstractLinear.this.RETURN_TO_ZERO_EASING);
                AbstractLinear.this.TIMELINE.setDuration((long)(2000.0f * AbstractLinear.this.TIMELINE.getTimelinePosition()));
                AbstractLinear.this.TIMELINE.play();
            }
            if (timelineState2 == Timeline.TimelineState.DONE) {
                AbstractLinear.this.repaint(AbstractLinear.this.getBounds());
            }
        }

        public void onTimelinePulse(float f, float f2) {
            double d = AbstractLinear.this.getValue();
            if (!AbstractLinear.this.autoResetToZero) {
                if (d >= AbstractLinear.this.getThreshold()) {
                    if (!AbstractLinear.this.LED_BLINKING_TIMER.isRunning()) {
                        AbstractLinear.this.LED_BLINKING_TIMER.start();
                        AbstractLinear.this.firePropertyChange("threshold", false, true);
                    }
                } else {
                    AbstractLinear.this.LED_BLINKING_TIMER.stop();
                    AbstractLinear.this.setCurrentLedImage(AbstractLinear.this.getLedImageOff());
                    AbstractLinear.this.firePropertyChange("threshold", true, false);
                }
            }
            if (d > AbstractLinear.this.maxMeasuredValue) {
                AbstractLinear.this.maxMeasuredValue = d;
            }
            if (d < AbstractLinear.this.minMeasuredValue) {
                AbstractLinear.this.minMeasuredValue = d;
            }
            AbstractLinear.this.repaint(AbstractLinear.this.getBounds());
        }
    };

    public AbstractLinear() {
        this.addComponentListener(this);
        this.setMinimumSize(new Dimension(100, 100));
        this.setPreferredSize(new Dimension(140, 140));
        this.init(this.getWidth(), this.getHeight());
        this.TIMELINE.addCallback(this.TIMELINE_CALLBACK);
    }

    @Override
    public void setValue(double d) {
        d = d > this.maxValue ? this.maxValue : d;
        double d2 = d = d < this.minValue ? this.minValue : d;
        if (!this.autoResetToZero) {
            this.repaint();
        }
        super.setValue(d);
    }

    public void setValueAnimated(double d) {
        if (this.TIMELINE.getState() != Timeline.TimelineState.IDLE) {
            this.TIMELINE.abort();
        }
        double d2 = this.getMaxValue() - this.getMinValue();
        double d3 = Math.abs(this.getValue() - d);
        double d4 = d3 / d2;
        this.TIMELINE.addPropertyToInterpolate("value", (Object)this.getValue(), (Object)d);
        if (this.autoResetToZero) {
            this.TIMELINE.setEase(this.RETURN_TO_ZERO_EASING);
            this.TIMELINE.setDuration((long)(800.0 * d4));
        } else {
            this.TIMELINE.setEase(this.STANDARD_EASING);
            this.TIMELINE.setDuration((long)(4500.0 * d4));
        }
        this.TIMELINE.play();
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double d) {
        this.minValue = d;
        if (d > 0.0) {
            this.setValue(d);
        }
        if (this.getThreshold() < d) {
            this.setThreshold(d);
        }
        this.resetMinMeasuredValue();
        this.resetMaxMeasuredValue();
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double d) {
        this.maxValue = d;
        if (this.getThreshold() > d) {
            this.setThreshold(d);
        }
        this.resetMinMeasuredValue();
        this.resetMaxMeasuredValue();
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    public boolean isAutoResetToZero() {
        return this.autoResetToZero;
    }

    public void setAutoResetToZero(boolean bl) {
        this.autoResetToZero = bl;
        if (bl) {
            this.setThresholdVisible(false);
            this.setLedVisible(false);
        }
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double d) {
        this.threshold = d;
        this.setValue(super.getValue());
    }

    public boolean isThresholdVisible() {
        return this.thresholdVisible;
    }

    public void setThresholdVisible(boolean bl) {
        this.thresholdVisible = bl;
        this.repaint();
    }

    public double getMinMeasuredValue() {
        return this.minMeasuredValue;
    }

    public boolean isMinMeasuredValueVisible() {
        return this.minMeasuredValueVisible;
    }

    public void setMinMeasuredValueVisible(boolean bl) {
        this.minMeasuredValueVisible = bl;
        this.repaint();
    }

    public void resetMinMeasuredValue() {
        this.minMeasuredValue = this.getMaxValue();
    }

    public double getMaxMeasuredValue() {
        return this.maxMeasuredValue;
    }

    public boolean isMaxMeasuredValueVisible() {
        return this.maxMeasuredValueVisible;
    }

    public void setMaxMeasuredValueVisible(boolean bl) {
        this.maxMeasuredValueVisible = bl;
        this.repaint();
    }

    public void resetMaxMeasuredValue() {
        this.maxMeasuredValue = this.getMinValue();
        this.repaint();
    }

    public boolean isTrackVisible() {
        return this.trackVisible;
    }

    public void setTrackVisible(boolean bl) {
        this.trackVisible = bl;
        this.repaint();
    }

    public double getTrackStart() {
        return this.trackStart;
    }

    public void setTrackStart(double d) {
        this.trackStart = d > this.getMaxValue() ? this.getMaxValue() - this.trackRange : d;
        this.trackStart = d < this.getMinValue() ? this.getMinValue() : d;
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    public double getTrackSection() {
        return this.trackSection;
    }

    public void setTrackSection(double d) {
        this.trackSection = d >= this.getMaxValue() ? (this.trackStart + this.trackRange) / 2.0 : d;
        this.trackSection = d <= this.getMinValue() ? (this.trackStart + this.trackRange) / 2.0 : d;
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    public double getTrackRange() {
        return this.trackRange;
    }

    public void setTrackRange(double d) {
        this.trackRange = d;
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    public Color getTrackStartColor() {
        return this.trackStartColor;
    }

    public void setTrackStartColor(Color color) {
        this.trackStartColor = color;
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    public Color getTrackSectionColor() {
        return this.trackSectionColor;
    }

    public void setTrackSectionColor(Color color) {
        this.trackSectionColor = color;
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    public Color getTrackStopColor() {
        return this.trackStopColor;
    }

    public void setTrackStopColor(Color color) {
        this.trackStopColor = color;
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    public BackgroundColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(BackgroundColor backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    public FrameDesign getFrameDesign() {
        return this.frameDesign;
    }

    public void setFrameDesign(FrameDesign frameDesign) {
        this.frameDesign = frameDesign;
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    public String getUnitString() {
        return this.unitString;
    }

    public void setUnitString(String string) {
        this.unitString = string;
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    public boolean isLedVisible() {
        return this.ledVisible;
    }

    public void setLedVisible(boolean bl) {
        this.ledVisible = bl;
        this.repaint();
    }

    protected double getLedPositionX() {
        return this.ledPositionX;
    }

    protected void setLedPositionX(double d) {
        this.ledPositionX = d;
    }

    protected double getLedPositionY() {
        return this.ledPositionY;
    }

    protected void setLedPositionY(double d) {
        this.ledPositionY = d;
    }

    public LedColor getLedColor() {
        return this.ledColor;
    }

    public void setLedColor(LedColor ledColor) {
        this.ledColor = ledColor;
        boolean bl = this.currentLedImage.equals(this.ledImageOn);
        this.ledImageOff = this.create_LED_Image(this.getWidth(), 0, ledColor);
        this.ledImageOn = this.create_LED_Image(this.getWidth(), 1, ledColor);
        this.currentLedImage = bl ? this.ledImageOn : this.ledImageOff;
        this.repaint();
    }

    public boolean isLedBlinking() {
        return this.ledBlinking;
    }

    public void setLedBlinking(boolean bl) {
        this.ledBlinking = bl;
        if (bl) {
            this.LED_BLINKING_TIMER.start();
        } else {
            this.setCurrentLedImage(this.getLedImageOff());
            this.LED_BLINKING_TIMER.stop();
        }
    }

    protected BufferedImage getLedImageOn() {
        return this.ledImageOn;
    }

    protected BufferedImage getLedImageOff() {
        return this.ledImageOff;
    }

    protected BufferedImage getCurrentLedImage() {
        return this.currentLedImage;
    }

    protected void setCurrentLedImage(BufferedImage bufferedImage) {
        this.currentLedImage = bufferedImage;
        this.repaint();
    }

    protected BufferedImage create_BACKGROUND_Image(int n, int n2) {
        Paint paint;
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        double d = n3 >= n4 ? (double)n4 * 0.05 : (double)n3 * 0.05;
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, n3, n4, d, d);
        Color color = new Color(0x848484);
        graphics2D.setColor(color);
        graphics2D.fill(double_);
        double d2 = n3 >= n4 ? d - (((RectangularShape)double_).getHeight() - (double)n4 - 2.0) / 2.0 : d - (((RectangularShape)double_).getWidth() - (double)n3 - 2.0) / 2.0;
        RoundRectangle2D.Double double_2 = new RoundRectangle2D.Double(1.0, 1.0, n3 - 2, n4 - 2, d2, d2);
        Point2D.Double double_3 = new Point2D.Double(0.0, double_2.getBounds2D().getMinY());
        Point2D.Double double_4 = new Point2D.Double(0.0, double_2.getBounds2D().getMaxY());
        Point2D.Double double_5 = new Point2D.Double(double_2.getCenterX(), double_2.getCenterY());
        float f = (float)Math.toDegrees(Math.atan((float)n4 / 8.0f / ((float)n3 / 2.0f)));
        switch (this.frameDesign) {
            case BLACK_METAL: {
                float[] fArray = new float[]{0.0f, 90.0f - 2.0f * f, 90.0f, 90.0f + 3.0f * f, 180.0f, 270.0f - 3.0f * f, 270.0f, 270.0f + 2.0f * f, 1.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(254, 254, 254, 255)};
                paint = new ConicalGradientPaint(true, double_5, 0.0f, fArray, colorArray);
                break;
            }
            case METAL: {
                float[] fArray = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                paint = new LinearGradientPaint(double_3, double_4, fArray, colorArray);
                break;
            }
            case SHINY_METAL: {
                float[] fArray = new float[]{0.0f, 90.0f - 2.0f * f, 90.0f, 90.0f + 3.0f * f, 180.0f, 270.0f - 3.0f * f, 270.0f, 270.0f + 2.0f * f, 1.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(179, 179, 179, 255), new Color(238, 238, 238, 255), new Color(179, 179, 179, 255), new Color(179, 179, 179, 255), new Color(179, 179, 179, 255), new Color(238, 238, 238, 255), new Color(179, 179, 179, 255), new Color(254, 254, 254, 255)};
                paint = new ConicalGradientPaint(true, double_5, 0.0f, fArray, colorArray);
                break;
            }
            default: {
                float[] fArray = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                paint = new LinearGradientPaint(double_3, double_4, fArray, colorArray);
            }
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(double_2);
        double d3 = n3 >= n4 ? (double)n4 * 0.02857143 : (double)n3 * 0.02857143;
        RoundRectangle2D.Double double_6 = new RoundRectangle2D.Double(((RectangularShape)double_2).getX() + 16.0, ((RectangularShape)double_2).getY() + 16.0, ((RectangularShape)double_2).getWidth() - 32.0, ((RectangularShape)double_2).getHeight() - 32.0, d3, d3);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(double_6);
        double d4 = d3 - 1.0;
        RoundRectangle2D.Double double_7 = new RoundRectangle2D.Double(((RectangularShape)double_6).getX() + 1.0, ((RectangularShape)double_6).getY() + 1.0, ((RectangularShape)double_6).getWidth() - 2.0, ((RectangularShape)double_6).getHeight() - 2.0, d4, d4);
        Point2D.Double double_8 = new Point2D.Double(0.0, double_7.getBounds2D().getMinY());
        Point2D.Double double_9 = new Point2D.Double(0.0, double_7.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.4f, 1.0f};
        Color[] colorArray = new Color[]{this.backgroundColor.GRADIENT_START_COLOR, this.backgroundColor.GRADIENT_FRACTION_COLOR, this.backgroundColor.GRADIENT_STOP_COLOR};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_8, double_9, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_7);
        BufferedImage bufferedImage2 = Shadow.INSTANCE.createInnerShadow(double_7, linearGradientPaint, 0, 0.65f, Color.BLACK, 20, 315);
        graphics2D.drawImage((Image)bufferedImage2, double_7.getBounds().x, double_7.getBounds().y, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_TRACK_Image(boolean bl, int n, int n2, double d, double d2, double d3, double d4, double d5, Color color, Color color2, Color color3) {
        Color[] colorArray;
        float[] fArray;
        Point2D.Double double_;
        Point2D.Double double_2;
        Rectangle2D.Double double_3;
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        if (d3 + d5 > d2) {
            throw new IllegalArgumentException("Please adjust track start and/or track range values");
        }
        boolean bl2 = n < n2;
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        if (bl2) {
            double_3 = new Rectangle2D.Double((double)n3 * 0.315, (double)n4 * 0.1276, (double)n3 * 0.05, (double)n4 * 0.728);
            double_2 = new Point2D.Double(0.0, double_3.getMaxY());
            double_ = new Point2D.Double(0.0, double_3.getMinY());
        } else {
            double_3 = new Rectangle2D.Double((double)n3 * 0.139, (double)n4 * 0.6285714285714286, (double)n3 * 0.735, (double)n4 * 0.05);
            double_2 = new Point2D.Double(double_3.getMinX(), 0.0);
            double_ = new Point2D.Double(double_3.getMaxX(), 0.0);
        }
        float f = (float)(this.getTrackStart() / (this.getMaxValue() - this.getMinValue()));
        float f2 = (float)((this.getTrackStart() + this.getTrackRange()) / (this.getMaxValue() - this.getMinValue()));
        Color color4 = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        if (bl) {
            float f3 = (float)((d4 - d3) / d5) * f2;
            fArray = new float[]{0.0f, f + 0.001f, f + 0.002f, f3, f2 - 0.002f, f2 - 0.001f, 1.0f};
            colorArray = new Color[]{color4, color4, color, color2, color3, color4, color4};
        } else {
            fArray = new float[]{0.0f, f + 0.001f, f + 0.002f, f2 - 0.002f, f2 - 0.001f, 1.0f};
            colorArray = new Color[]{color4, color4, color, color3, color4, color4};
        }
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_3);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_TITLE_Image(int n, int n2, boolean bl) {
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        boolean bl2 = n < n2;
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        if (bl2) {
            graphics2D.setColor(this.getBackgroundColor().LABEL_COLOR);
            graphics2D.setFont(new Font("Verdana", 0, (int)(0.1 * (double)n3)));
            TextLayout textLayout = new TextLayout(this.getTitle(), graphics2D.getFont(), fontRenderContext);
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(0.0, -0.05 * (double)n4);
            graphics2D.rotate(1.5707963267948966, 0.67142856f * (float)n3, 0.1375f * (float)n4 + textLayout.getAscent() - textLayout.getDescent());
            graphics2D.drawString(this.getTitle(), 0.67142856f * (float)n3, 0.1375f * (float)n4 + textLayout.getAscent() - textLayout.getDescent());
            graphics2D.setTransform(affineTransform);
            if (bl) {
                graphics2D.setFont(new Font("Verdana", 0, (int)(0.07142857142857142 * (double)n3)));
                TextLayout textLayout2 = new TextLayout(this.getUnitString(), graphics2D.getFont(), fontRenderContext);
                Rectangle2D rectangle2D = textLayout2.getBounds();
                graphics2D.drawString(this.getUnitString(), (float)((double)n3 - rectangle2D.getWidth()) / 2.0f, 0.8875f * (float)n4 + textLayout2.getAscent() - textLayout2.getDescent());
            }
        } else {
            graphics2D.setColor(this.getBackgroundColor().LABEL_COLOR);
            graphics2D.setFont(new Font("Verdana", 0, (int)(0.1 * (double)n4)));
            TextLayout textLayout = new TextLayout(this.getTitle(), graphics2D.getFont(), fontRenderContext);
            graphics2D.drawString(this.getTitle(), 0.15f * (float)n3, 0.25f * (float)n4 + textLayout.getAscent() - textLayout.getDescent());
            if (bl) {
                graphics2D.setFont(new Font("Verdana", 0, (int)(0.025 * (double)n3)));
                TextLayout textLayout3 = new TextLayout(this.getUnitString(), graphics2D.getFont(), fontRenderContext);
                graphics2D.drawString(this.getUnitString(), 0.0625f * (float)n3, 0.7f * (float)n4 + textLayout3.getAscent() - textLayout3.getDescent());
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_TICKMARKS_Image(int n, int n2, double d, double d2, int n3) {
        double d3;
        double d4;
        Font font;
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        boolean bl = n < n2;
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        BasicStroke basicStroke = new BasicStroke(1.0f, 1, 2);
        BasicStroke basicStroke2 = new BasicStroke(0.5f, 1, 2);
        BasicStroke basicStroke3 = new BasicStroke(0.3f, 1, 2);
        BasicStroke basicStroke4 = new BasicStroke(0.1f, 1, 2);
        if (bl) {
            font = new Font("Verdana", 0, (int)(0.062 * (double)n));
            d4 = (double)n2 * 0.8567961165048543;
            d3 = (double)n2 * 0.12864077669902912;
        } else {
            font = new Font("Verdana", 0, (int)(0.062 * (double)n2));
            d4 = (double)n * 0.14285714285714285;
            d3 = (double)n * 0.8710124827;
        }
        double d5 = this.maxValue - this.minValue;
        double d6 = (d3 - d4) / d5;
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        TextLayout textLayout = new TextLayout(String.valueOf(this.maxValue), graphics2D.getFont(), fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        float f = 0.0f;
        int n4 = 0;
        int n5 = 0;
        graphics2D.setColor(this.backgroundColor.LABEL_COLOR);
        for (double d7 = this.minValue; d7 < this.maxValue + 1.0; d7 += 1.0) {
            Line2D.Double double_;
            double d8 = this.minValue <= 0.0 ? d4 + d7 * d6 + Math.abs(this.minValue) * d6 : d4 + d7 * d6 - Math.abs(this.minValue) * d6;
            if (d5 <= 10.0 && n4 != 0) {
                double d9 = d6 / 10.0;
                graphics2D.setStroke(basicStroke4);
                for (double d10 = d8 - d9; d10 < d8 - d6; d10 -= d9) {
                    double_ = bl ? new Line2D.Double((double)n * 0.35, (int)d10, (double)n * 0.36, d10) : new Line2D.Double((int)d10, (double)n2 * 0.66, (int)d10, (double)n2 * 0.63);
                    graphics2D.draw(double_);
                }
            }
            if (n4 % 5 != 0 && n4 % 10 != 0 && n4 % 100 != 0 && d5 < 500.0) {
                graphics2D.setStroke(basicStroke3);
                double_ = bl ? new Line2D.Double((double)n * 0.34, d8, (double)n * 0.36, d8) : new Line2D.Double(d8, (double)n2 * 0.65, d8, (double)n2 * 0.63);
                graphics2D.draw(double_);
            }
            if (n4 % 5 == 0 && n4 % 10 != 0 && n4 % 100 != 0 && d5 < 1000.0) {
                graphics2D.setStroke(basicStroke2);
                double_ = bl ? new Line2D.Double((double)n * 0.33, d8, (double)n * 0.36, d8) : new Line2D.Double(d8, (double)n2 * 0.66, d8, (double)n2 * 0.63);
                graphics2D.draw(double_);
            }
            if (n4 % 10 == 0 && n4 % 100 != 0 || n4 == 0 && d5 < 1000.0) {
                graphics2D.setStroke(basicStroke);
                double_ = bl ? new Line2D.Double((double)n * 0.32, d8, (double)n * 0.36, d8) : new Line2D.Double(d8, (double)n2 * 0.67, d8, (double)n2 * 0.63);
                graphics2D.draw(double_);
            }
            if (n4 == 100) {
                graphics2D.setStroke(basicStroke);
                double_ = bl ? new Line2D.Double((double)n * 0.31, d8, (double)n * 0.36, d8) : new Line2D.Double(d8, (double)n2 * 0.68, d8, (double)n2 * 0.63);
                graphics2D.draw(double_);
                n4 = 0;
                ++n5;
            }
            if (d7 % (double)n3 == 0.0) {
                TextLayout textLayout2 = new TextLayout(String.valueOf(d7), graphics2D.getFont(), fontRenderContext);
                Rectangle2D rectangle2D2 = textLayout2.getBounds();
                if (bl) {
                    f = (float)(rectangle2D.getWidth() - rectangle2D2.getWidth());
                    graphics2D.drawString(String.valueOf((int)d7), 0.18f * (float)n + f, (float)(d8 - rectangle2D2.getHeight() / 2.0 + rectangle2D2.getHeight()));
                } else {
                    graphics2D.drawString(String.valueOf((int)d7), (float)(d8 - rectangle2D2.getWidth() / 3.0), (float)((double)n2 * 0.68 + 1.5 * rectangle2D2.getHeight()));
                }
            }
            ++n4;
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_THRESHOLD_Image(int n, int n2) {
        Point2D.Double double_;
        Point2D.Double double_2;
        int n3;
        int n4;
        boolean bl;
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        boolean bl2 = bl = n < n2;
        if (bl) {
            n4 = (int)((double)n * 0.0714285714);
            n3 = (int)((double)n4 * 0.8);
        } else {
            n3 = (int)((double)n2 * 0.0714285714);
            n4 = (int)((double)n3 * 0.8);
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n4, n3, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.translate(0.0, (double)n4 * 0.005);
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        if (bl) {
            generalPath.moveTo((double)n4 * 0.1, (double)n3 * 0.5);
            generalPath.lineTo((double)n4 * 0.9, (double)n3 * 0.1);
            generalPath.lineTo((double)n4 * 0.9, (double)n3 * 0.9);
            generalPath.lineTo((double)n4 * 0.1, (double)n3 * 0.5);
            generalPath.closePath();
            double_2 = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
            double_ = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
        } else {
            generalPath.moveTo((double)n4 * 0.5, (double)n3 * 0.9);
            generalPath.lineTo((double)n4 * 1.0, (double)n3 * 0.1);
            generalPath.lineTo((double)n4 * 0.1, (double)n3 * 0.1);
            generalPath.lineTo((double)n4 * 0.5, (double)n3 * 0.9);
            generalPath.closePath();
            double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
            double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        }
        float[] fArray = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
        Color[] colorArray = new Color[]{new Color(82, 0, 0, 255), new Color(252, 29, 0, 255), new Color(252, 29, 0, 255), new Color(82, 0, 0, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        graphics2D.setColor(Color.WHITE);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics2D.draw(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_MEASURED_VALUE_Image(int n, int n2, Color color) {
        int n3;
        int n4;
        boolean bl;
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        boolean bl2 = bl = n < n2;
        if (bl) {
            n3 = n4 = (int)((double)n * 0.05);
        } else {
            n4 = n3 = (int)((double)n2 * 0.05);
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n4, n3, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        if (bl) {
            generalPath.moveTo((double)n4, (double)n3 * 0.5);
            generalPath.lineTo(0.0, 0.0);
            generalPath.lineTo(0.0, (double)n3);
            generalPath.lineTo((double)n4, (double)n3 * 0.5);
            generalPath.closePath();
        } else {
            generalPath.moveTo((double)n4 * 0.5, 0.0);
            generalPath.lineTo(n4, n3);
            generalPath.lineTo(0.0, (double)n3);
            generalPath.lineTo((double)n4 * 0.5, 0.0);
            generalPath.closePath();
        }
        graphics2D.setColor(color);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_FOREGROUND_Image(int n, int n2) {
        Point2D.Double double_;
        Point2D.Double double_2;
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        if (n >= n2) {
            generalPath.moveTo(18.0f, n4 - 18);
            generalPath.lineTo(n3 - 18, n4 - 18);
            generalPath.curveTo((double)(n3 - 18), (double)(n4 - 18), (double)(n3 - 27), (double)n4 * 0.7, (double)(n3 - 27), (double)n4 * 0.5);
            generalPath.curveTo(n3 - 27, 27.0f, n3 - 18, 18.0f, n3 - 18, 18.0f);
            generalPath.lineTo(18.0f, 18.0f);
            generalPath.curveTo(18.0, 18.0, 27.0, (double)n4 * 0.2857142857142857, 27.0, (double)n4 * 0.5);
            generalPath.curveTo(27.0, (double)n4 * 0.7, 18.0, (double)(n4 - 18), 18.0, (double)(n4 - 18));
            generalPath.closePath();
            double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
            double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        } else {
            generalPath.setWindingRule(0);
            generalPath.moveTo(18.0f, 18.0f);
            generalPath.lineTo(18.0f, n4 - 18);
            generalPath.curveTo(18.0, (double)(n4 - 18), 27.0, (double)(n4 - 27), (double)n3 * 0.5, (double)(n4 - 27));
            generalPath.curveTo(n3 - 27, n4 - 27, n3 - 18, n4 - 18, n3 - 18, n4 - 18);
            generalPath.lineTo(n3 - 18, 18.0f);
            generalPath.curveTo((double)(n3 - 18), 18.0, (double)(n3 - 27), 27.0, (double)n3 * 0.5, 27.0);
            generalPath.curveTo(27.0f, 27.0f, 18.0f, 18.0f, 18.0f, 18.0f);
            generalPath.closePath();
            double_2 = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
            double_ = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
        }
        float[] fArray = new float[]{0.0f, 0.06f, 0.07f, 0.12f, 0.17f, 0.1701f, 0.79f, 0.8f, 0.84f, 0.93f, 0.94f, 0.96f, 0.97f, 1.0f};
        Color[] colorArray = new Color[]{new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 3), new Color(255, 255, 255, 5), new Color(255, 255, 255, 5), new Color(255, 255, 255, 5), new Color(255, 255, 255, 20), new Color(255, 255, 255, 73), new Color(255, 255, 255, 76), new Color(255, 255, 255, 30), new Color(255, 255, 255, 10), new Color(255, 255, 255, 5)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_LED_Image(int n, int n2, LedColor ledColor) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage((int)((double)n * 0.1428571429), (int)((double)n * 0.1428571429), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double(0.25 * (double)n3, 0.25 * (double)n4, 0.5 * (double)n3, 0.5 * (double)n4);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(0.0, 0.0, n3, n4);
        Point2D.Double double_3 = new Point2D.Double(double_.getCenterX(), double_.getCenterY());
        float[] fArray = new float[]{0.0f, 0.2f, 1.0f};
        Color[] colorArray = new Color[]{ledColor.INNER_COLOR1_OFF, ledColor.INNER_COLOR2_OFF, ledColor.OUTER_COLOR_OFF};
        Color[] colorArray2 = new Color[]{ledColor.INNER_COLOR1_ON, ledColor.INNER_COLOR2_ON, ledColor.OUTER_COLOR_ON};
        float[] fArray2 = new float[]{0.0f, 0.8f, 1.0f};
        Color[] colorArray3 = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.4f)};
        float[] fArray3 = new float[]{0.0f, 0.6f, 0.7f, 0.8f, 0.85f, 1.0f};
        Color[] colorArray4 = new Color[]{UTIL.setAlpha(ledColor.CORONA_COLOR, 0.0f), UTIL.setAlpha(ledColor.CORONA_COLOR, 0.4f), UTIL.setAlpha(ledColor.CORONA_COLOR, 0.25f), UTIL.setAlpha(ledColor.CORONA_COLOR, 0.15f), UTIL.setAlpha(ledColor.CORONA_COLOR, 0.05f), UTIL.setAlpha(ledColor.CORONA_COLOR, 0.0f)};
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_3, 0.25f * (float)n3, fArray, colorArray);
        RadialGradientPaint radialGradientPaint2 = new RadialGradientPaint(double_3, 0.25f * (float)n3, fArray, colorArray2);
        RadialGradientPaint radialGradientPaint3 = new RadialGradientPaint(double_3, 0.25f * (float)n3, fArray2, colorArray3);
        RadialGradientPaint radialGradientPaint4 = new RadialGradientPaint(double_3, 0.5f * (float)n3, fArray3, colorArray4);
        Ellipse2D.Double double_4 = new Ellipse2D.Double(0.4 * (double)n3, 0.35 * (double)n3, 0.2 * (double)n3, 0.15 * (double)n3);
        Point2D.Double double_5 = new Point2D.Double(0.0, double_4.getMinY());
        Point2D.Double double_6 = new Point2D.Double(0.0, double_4.getMaxY());
        float[] fArray4 = new float[]{0.0f, 1.0f};
        Color[] colorArray5 = new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.4f), new Color(1.0f, 1.0f, 1.0f, 0.0f)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_5, double_6, fArray4, colorArray5);
        switch (n2) {
            case 0: {
                graphics2D.setPaint(radialGradientPaint);
                graphics2D.fill(double_);
                graphics2D.setPaint(radialGradientPaint3);
                graphics2D.fill(double_);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(double_4);
                break;
            }
            case 1: {
                graphics2D.setPaint(radialGradientPaint4);
                graphics2D.fill(double_2);
                graphics2D.setPaint(radialGradientPaint2);
                graphics2D.fill(double_);
                graphics2D.setPaint(radialGradientPaint3);
                graphics2D.fill(double_);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(double_4);
                break;
            }
            default: {
                graphics2D.setPaint(radialGradientPaint);
                graphics2D.fill(double_);
                graphics2D.setPaint(radialGradientPaint3);
                graphics2D.fill(double_);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(double_4);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public Dimension getSize() {
        if (this.getWidth() < this.getMinimumSize().width || this.getHeight() < this.getMinimumSize().height) {
            return this.getMinimumSize();
        }
        return super.getSize();
    }

    @Override
    public Dimension getSize(Dimension dimension) {
        if (this.getWidth() < this.getMinimumSize().width || this.getHeight() < this.getMinimumSize().height) {
            return this.getMinimumSize();
        }
        return super.getSize(dimension);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.getWidth() >= this.getHeight()) {
            this.ledImageOff = this.create_LED_Image(this.getHeight(), 0, this.ledColor);
            this.ledImageOn = this.create_LED_Image(this.getHeight(), 1, this.ledColor);
            if (this.ledOn) {
                this.setCurrentLedImage(this.ledImageOn);
            } else {
                this.setCurrentLedImage(this.ledImageOff);
            }
            this.ledPositionX = (double)(this.getWidth() - 18) - (double)this.ledImageOn.getWidth() * 0.85;
            this.ledPositionY = (double)(this.getHeight() - this.ledImageOn.getHeight()) / 2.0;
        } else {
            this.ledImageOff = this.create_LED_Image(this.getWidth(), 0, this.ledColor);
            this.ledImageOn = this.create_LED_Image(this.getWidth(), 1, this.ledColor);
            if (this.ledOn) {
                this.setCurrentLedImage(this.ledImageOn);
            } else {
                this.setCurrentLedImage(this.ledImageOff);
            }
            this.ledPositionX = (double)(this.getWidth() - this.ledImageOn.getWidth()) / 2.0;
            this.ledPositionY = 18.0;
        }
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.LED_BLINKING_TIMER)) {
            this.currentLedImage = this.ledOn ? this.getLedImageOn() : this.getLedImageOff();
            this.ledOn ^= true;
            this.repaint((int)this.ledPositionX, (int)this.ledPositionY, this.currentLedImage.getWidth(), this.currentLedImage.getHeight());
        }
    }

    @Override
    public String toString() {
        return "AbstractLinear";
    }
}

