[한국어](./README.md) | [**English**](./README-EN.md)

# OpenType Features

This guide showcases features available in Wanted Sans.

## Preview

### `tnum`: Tabular Figures

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/tnum.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/tnum.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/tnum.svg">
	<img width="100%" alt="tnum" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/tnum.svg">
</picture>

Displays numbers with uniform width.

### `case`: Case-sensitive Forms

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/case.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/case.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/case.svg">
	<img width="100%" alt="case" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/case.svg">
</picture>

Displays forms optimized for use with capital letters.

### `calt` `clig`: Contextual Alternates

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/calt-clig.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/calt-clig.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/calt-clig.svg">
	<img width="100%" alt="calt, clig" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/calt-clig.svg">
</picture>

Intelligently recognizes and displays particular characters more naturally based on context.

### `locl`: Localized Forms

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/locl.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/locl.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/locl.svg">
	<img width="100%" alt="locl" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/locl.svg">
</picture>

Adjusts character shapes based on the language and region.

### `liga`: Ligatures

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/liga.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/liga.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/liga.svg">
	<img width="100%" alt="liga" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/liga.svg">
</picture>

Adjusts character forms in specific compositions.

### `rlig`: Required Ligatures

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/rlig.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/rlig.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/rlig.svg">
	<img width="100%" alt="rlig" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/rlig.svg">
</picture>

Activates common ligatures in Latin.

### `ccmp`: Composite Characters

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/ccmp.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/ccmp.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/ccmp.svg">
	<img width="100%" alt="ccmp" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/ccmp.svg">
</picture>

Combines shapes into a single form in specific combinations.

### `frac` `numr` `dnom` `sinf` `sups` `subs`: Fractions and Subscripts/Superscripts

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/frac-numr-dnom-sinf-sups-subs.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/frac-numr-dnom-sinf-sups-subs.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/frac-numr-dnom-sinf-sups-subs.svg">
	<img width="100%" alt="frac, numr, dnom, sinf, sups, subs" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/frac-numr-dnom-sinf-sups-subs.svg">
</picture>

Displays characters as fractions or as subscript/superscript.

### `ordn`: Ordinals

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/ordn.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/ordn.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/ordn.svg">
	<img width="100%" alt="ordn" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/ordn.svg">
</picture>

Displays certain characters as ordinals.

### `zero`: Slashed Zero

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/zero.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/zero.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/zero.svg">
	<img width="100%" alt="zero" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/zero.svg">
</picture>

Enhances readability of the number 0.

### `salt`: Stylistic Alternates

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/salt.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/salt.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/salt.svg">
	<img width="100%" alt="salt" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/salt.svg">
</picture>

Displays characters in alternates forms.

### `ss01`: Geometric forms

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/ss01.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/ss01.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/ss01.svg">
	<img width="100%" alt="ss01" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/ss01.svg">
</picture>

Displays characters in geometric forms.

### `ss02`: Common numerics

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/ss02.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/ss02.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/ss02.svg">
	<img width="100%" alt="ss02" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/ss02.svg">
</picture>

Displays numbers in their standard forms.

### `ss03`: Unique forms

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/ss03.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/ss03.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/ss03.svg">
	<img width="100%" alt="ss03" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/ss03.svg">
</picture>

Presents characters in a playful manner.

### `ss04`: Legible ascender

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/ss04.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/ss04.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/ss04.svg">
	<img width="100%" alt="ss04" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/ss04.svg">
</picture>

Improves the readability of ascenders.

### `ss05`: Korea localization

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/ss05.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/ss05.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/ss05.svg">
	<img width="100%" alt="ss05" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/ss05.svg">
</picture>

Adjusts characters to fit Korean aesthetics.

### `ss06`: High legibility

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/ss06.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/ss06.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/ss06.svg">
	<img width="100%" alt="ss06" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/ss06.svg">
</picture>

Enhances legibility by presenting characters in forms that provide clearer distinctions between them.

### `ss07`: Double storey a

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/ss07.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/ss07.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/ss07.svg">
	<img width="100%" alt="ss07" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/ss07.svg">
</picture>

Displays a in a two storey form for readability.

### `ss08`: Double storey three

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/ss08.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/ss08.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/ss08.svg">
	<img width="100%" alt="ss08" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/ss08.svg">
</picture>

Displays 3 in a two storey form for legibility.

### `ss09`: Geometric Q

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/ss09.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/ss09.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/ss09.svg">
	<img width="100%" alt="ss09" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/ss09.svg">
</picture>

Displays Q in geometric form.

### `ss11`: Outlined symbol

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/ss11.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/ss11.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/ss11.svg">
	<img width="100%" alt="ss11" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/ss11.svg">
</picture>

Displays filled symbols in outline form.

### `ss12`: Circle symbols

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/ss12.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/ss12.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/ss12.svg">
	<img width="100%" alt="ss12" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/ss12.svg">
</picture>

Displays square symbols as circular.

### `ss13`: Square symbols

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/ss13.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/ss13.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/ss13.svg">
	<img width="100%" alt="ss13" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/ss13.svg">
</picture>

Displays circular symbols as square.

### `ss14`: Filled symbols

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/ss14.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/ss14.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/ss14.svg">
	<img width="100%" alt="ss14" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/ss14.svg">
</picture>

Presents outlined symbols in filled form.

### `ss15`: Small symbols

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/ss15.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/ss15.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/ss15.svg">
	<img width="100%" alt="ss15" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/ss15.svg">
</picture>

Displays symbols in a smaller form.

### `ss16`: Large symbols

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/ss16.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/ss16.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/ss16.svg">
	<img width="100%" alt="ss16" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/ss16.svg">
</picture>

Displays symbols in a larger form.

### `cvxx`: Character Variants

<picture>
    <source media="(prefers-color-scheme: dark) and (max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/dark/cvxx.svg">
	<source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/dark/cvxx.svg">
    <source media="(max-width: 600px)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/mobile/light/cvxx.svg">
	<img width="100%" alt="cvxx" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/features/desktop/light/cvxx.svg">
</picture>

Changes the appearance of character shapes.

## Implementation

To apply OpenType features, use the following code:

#### CSS

```css
font-feature-settings: "ss01";
```
