[한국어](./README.md) | [**English**](./README-EN.md)

# Features

## Principles

<picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/concept/dark/structure.svg">
    <img width="100%" alt="Wanted Sans 구조" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/concept/light/structure.svg">
</picture>

To naturally convey the voice embodied by Wanted, Wanted Sans is primarily designed in a geometric sans-serif form, aligned with the geometrically shaped Wanted logo.

## Form

<picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/concept/dark/humanist.svg">
    <img width="100%" alt="Humanist shapes in Wanted Sans" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/concept/light/humanist.svg">
</picture>

However, typical geometric sans-serifs can sometimes convey a somewhat heavy and rigid atmosphere due to their strict adherence to form. In Wanted Sans, while the geometric structure remains foundational, the shapes are slightly opened up, aiming for a balance of readability and a fresh appearance. Thus, Wanted Sans manages to exude a sense of humanity from its refined structure, oscillating between solemnity and liveliness, sometimes even with a playful twist. This characteristic is especially pronounced in letters and numbers like s, t, 2, and 8.

## Hangeul

<picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/concept/dark/hangeul.svg">
    <img width="100%" alt="Hangeul shapes in Wanted Sans" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/concept/light/hangeul.svg">
</picture>

The Hangeul characters are a variant of the [Source Han Sans](https://github.com/adobe-fonts/source-han-sans), resembling [Pretendard](https://github.com/orioncactus/pretendard). However, in the ExtraBlack weight, a more experimental boldness is showcased.

## Metrics

<picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/concept/dark/metrics.svg">
    <img width="100%" alt="Metrics of Wanted Sans match those of San Francisco" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/concept/light/metrics.svg">
</picture>

Wanted Sans is designed with a font height consistent with Apple’s system font, San Francisco, as well as Pretendard. This ensures a quicker and smoother font integration in various development environments.

## Readability

<picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/concept/dark/readability.svg">
    <img width="100%" alt="Optimized for reading in Wanted Sans" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/concept/light/readability.svg">
</picture>

The character spacing of Wanted Sans is calibrated for a natural reading experience in typical body text settings, ensuring readability without the need for additional letter-spacing adjustments.

## Intelligent Context Recognition

<picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/concept/dark/contextual.svg">
    <img width="100%" alt="Intelligent context recognition in Wanted Sans" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/concept/light/contextual.svg">
</picture>

Wanted Sans intelligently discerns context. Thus, when it needs to display suitable characters with Hangeul, or when distinguishing character shapes within words, it automatically presents them in the most appropriate form.

## OpenType Features

<picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/concept/dark/features.svg">
    <img width="100%" alt="Wanted Sans Features" src="https://github.com/wanteddev/wanted-sans/blob/HEAD/documentation/images/concept/light/features.svg">
</picture>

With the OpenType feature support, Wanted Sans is adaptable in a variety of situations including standard scenarios, situations requiring enhanced readability, cases where uniform number width is needed, or moments demanding unique shapes.
