#include "edge-impulse-sdk/dsp/config.hpp"
#if EIDSP_LOAD_CMSIS_DSP_SOURCES
/* ----------------------------------------------------------------------
 * Project:      CMSIS DSP Library
 * Title:        arm_mve_tables.c
 * Description:  common tables like fft twiddle factors, Bitreverse, reciprocal etc
 *               used for MVE implementation only
 *
 * @version  V1.10.0
 * @date     04 October 2021
 *
 * Target Processor: Cortex-M and Cortex-A cores
 * -------------------------------------------------------------------- */
/*
 * Copyright (C) 2010-2021 ARM Limited or its affiliates. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

 #include "edge-impulse-sdk/CMSIS/DSP/Include/arm_math_types.h"

 


#if defined(ARM_MATH_MVEF) && !defined(ARM_MATH_AUTOVECTORIZE)

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_FFT_ALLOW_TABLES)

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F32_16) || defined(ARM_TABLE_TWIDDLECOEF_F32_32)

uint32_t rearranged_twiddle_tab_stride1_arr_16_f32[2]={
0,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_16_f32[2]={
0,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_16_f32[2]={
0,0,};

float32_t rearranged_twiddle_stride1_16_f32[8]={
1.00000000000000000000f,0.00000000000000000000f,0.92387950420379638672f,
0.38268342614173889160f,0.70710676908493041992f,0.70710676908493041992f,
0.38268342614173889160f,0.92387950420379638672f,};

float32_t rearranged_twiddle_stride2_16_f32[8]={
1.00000000000000000000f,0.00000000000000000000f,0.70710676908493041992f,
0.70710676908493041992f,0.00000000000000006123f,1.00000000000000000000f,
-0.70710676908493041992f,0.70710676908493041992f,};

float32_t rearranged_twiddle_stride3_16_f32[8]={
1.00000000000000000000f,0.00000000000000000000f,0.38268342614173889160f,
0.92387950420379638672f,-0.70710676908493041992f,0.70710676908493041992f,
-0.92387950420379638672f,-0.38268342614173889160f,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F32_64) || defined(ARM_TABLE_TWIDDLECOEF_F32_128)

uint32_t rearranged_twiddle_tab_stride1_arr_64_f32[3]={
0,32,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_64_f32[3]={
0,32,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_64_f32[3]={
0,32,0,};

float32_t rearranged_twiddle_stride1_64_f32[40]={
1.00000000000000000000f,0.00000000000000000000f,0.99518471956253051758f,
0.09801714122295379639f,0.98078525066375732422f,0.19509032368659973145f,
0.95694035291671752930f,0.29028466343879699707f,0.92387950420379638672f,
0.38268342614173889160f,0.88192129135131835938f,0.47139674425125122070f,
0.83146959543228149414f,0.55557024478912353516f,0.77301043272018432617f,
0.63439327478408813477f,0.70710676908493041992f,0.70710676908493041992f,
0.63439327478408813477f,0.77301043272018432617f,0.55557024478912353516f,
0.83146959543228149414f,0.47139674425125122070f,0.88192129135131835938f,
0.38268342614173889160f,0.92387950420379638672f,0.29028466343879699707f,
0.95694035291671752930f,0.19509032368659973145f,0.98078525066375732422f,
0.09801714122295379639f,0.99518471956253051758f,1.00000000000000000000f,
0.00000000000000000000f,0.92387950420379638672f,0.38268342614173889160f,
0.70710676908493041992f,0.70710676908493041992f,0.38268342614173889160f,
0.92387950420379638672f,};

float32_t rearranged_twiddle_stride2_64_f32[40]={
1.00000000000000000000f,0.00000000000000000000f,0.98078525066375732422f,
0.19509032368659973145f,0.92387950420379638672f,0.38268342614173889160f,
0.83146959543228149414f,0.55557024478912353516f,0.70710676908493041992f,
0.70710676908493041992f,0.55557024478912353516f,0.83146959543228149414f,
0.38268342614173889160f,0.92387950420379638672f,0.19509032368659973145f,
0.98078525066375732422f,0.00000000000000006123f,1.00000000000000000000f,
-0.19509032368659973145f,0.98078525066375732422f,-0.38268342614173889160f,
0.92387950420379638672f,-0.55557024478912353516f,0.83146959543228149414f,
-0.70710676908493041992f,0.70710676908493041992f,-0.83146959543228149414f,
0.55557024478912353516f,-0.92387950420379638672f,0.38268342614173889160f,
-0.98078525066375732422f,0.19509032368659973145f,1.00000000000000000000f,
0.00000000000000000000f,0.70710676908493041992f,0.70710676908493041992f,
0.00000000000000006123f,1.00000000000000000000f,-0.70710676908493041992f,
0.70710676908493041992f,};

float32_t rearranged_twiddle_stride3_64_f32[40]={
1.00000000000000000000f,0.00000000000000000000f,0.95694035291671752930f,
0.29028466343879699707f,0.83146959543228149414f,0.55557024478912353516f,
0.63439327478408813477f,0.77301043272018432617f,0.38268342614173889160f,
0.92387950420379638672f,0.09801714122295379639f,0.99518471956253051758f,
-0.19509032368659973145f,0.98078525066375732422f,-0.47139674425125122070f,
0.88192129135131835938f,-0.70710676908493041992f,0.70710676908493041992f,
-0.88192129135131835938f,0.47139674425125122070f,-0.98078525066375732422f,
0.19509032368659973145f,-0.99518471956253051758f,-0.09801714122295379639f,
-0.92387950420379638672f,-0.38268342614173889160f,-0.77301043272018432617f,
-0.63439327478408813477f,-0.55557024478912353516f,-0.83146959543228149414f,
-0.29028466343879699707f,-0.95694035291671752930f,1.00000000000000000000f,
0.00000000000000000000f,0.38268342614173889160f,0.92387950420379638672f,
-0.70710676908493041992f,0.70710676908493041992f,-0.92387950420379638672f,
-0.38268342614173889160f,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F32_256) || defined(ARM_TABLE_TWIDDLECOEF_F32_512)

uint32_t rearranged_twiddle_tab_stride1_arr_256_f32[4]={
0,128,160,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_256_f32[4]={
0,128,160,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_256_f32[4]={
0,128,160,0,};

float32_t rearranged_twiddle_stride1_256_f32[168]={
1.00000000000000000000f,0.00000000000000000000f,0.99969881772994995117f,
0.02454122900962829590f,0.99879544973373413086f,0.04906767606735229492f,
0.99729043245315551758f,0.07356456667184829712f,0.99518471956253051758f,
0.09801714122295379639f,0.99247956275939941406f,0.12241067737340927124f,
0.98917651176452636719f,0.14673046767711639404f,0.98527765274047851562f,
0.17096188664436340332f,0.98078525066375732422f,0.19509032368659973145f,
0.97570210695266723633f,0.21910123527050018311f,0.97003126144409179688f,
0.24298018217086791992f,0.96377605199813842773f,0.26671275496482849121f,
0.95694035291671752930f,0.29028466343879699707f,0.94952815771102905273f,
0.31368175148963928223f,0.94154405593872070312f,0.33688986301422119141f,
0.93299281597137451172f,0.35989505052566528320f,0.92387950420379638672f,
0.38268342614173889160f,0.91420978307723999023f,0.40524131059646606445f,
0.90398931503295898438f,0.42755508422851562500f,0.89322429895401000977f,
0.44961133599281311035f,0.88192129135131835938f,0.47139674425125122070f,
0.87008696794509887695f,0.49289819598197937012f,0.85772860050201416016f,
0.51410275697708129883f,0.84485357999801635742f,0.53499764204025268555f,
0.83146959543228149414f,0.55557024478912353516f,0.81758481264114379883f,
0.57580816745758056641f,0.80320751667022705078f,0.59569931030273437500f,
0.78834640979766845703f,0.61523157358169555664f,0.77301043272018432617f,
0.63439327478408813477f,0.75720882415771484375f,0.65317285060882568359f,
0.74095112085342407227f,0.67155897617340087891f,0.72424709796905517578f,
0.68954056501388549805f,0.70710676908493041992f,0.70710676908493041992f,
0.68954056501388549805f,0.72424709796905517578f,0.67155897617340087891f,
0.74095112085342407227f,0.65317285060882568359f,0.75720882415771484375f,
0.63439327478408813477f,0.77301043272018432617f,0.61523157358169555664f,
0.78834640979766845703f,0.59569931030273437500f,0.80320751667022705078f,
0.57580816745758056641f,0.81758481264114379883f,0.55557024478912353516f,
0.83146959543228149414f,0.53499764204025268555f,0.84485357999801635742f,
0.51410275697708129883f,0.85772860050201416016f,0.49289819598197937012f,
0.87008696794509887695f,0.47139674425125122070f,0.88192129135131835938f,
0.44961133599281311035f,0.89322429895401000977f,0.42755508422851562500f,
0.90398931503295898438f,0.40524131059646606445f,0.91420978307723999023f,
0.38268342614173889160f,0.92387950420379638672f,0.35989505052566528320f,
0.93299281597137451172f,0.33688986301422119141f,0.94154405593872070312f,
0.31368175148963928223f,0.94952815771102905273f,0.29028466343879699707f,
0.95694035291671752930f,0.26671275496482849121f,0.96377605199813842773f,
0.24298018217086791992f,0.97003126144409179688f,0.21910123527050018311f,
0.97570210695266723633f,0.19509032368659973145f,0.98078525066375732422f,
0.17096188664436340332f,0.98527765274047851562f,0.14673046767711639404f,
0.98917651176452636719f,0.12241067737340927124f,0.99247956275939941406f,
0.09801714122295379639f,0.99518471956253051758f,0.07356456667184829712f,
0.99729043245315551758f,0.04906767606735229492f,0.99879544973373413086f,
0.02454122900962829590f,0.99969881772994995117f,1.00000000000000000000f,
0.00000000000000000000f,0.99518471956253051758f,0.09801714122295379639f,
0.98078525066375732422f,0.19509032368659973145f,0.95694035291671752930f,
0.29028466343879699707f,0.92387950420379638672f,0.38268342614173889160f,
0.88192129135131835938f,0.47139674425125122070f,0.83146959543228149414f,
0.55557024478912353516f,0.77301043272018432617f,0.63439327478408813477f,
0.70710676908493041992f,0.70710676908493041992f,0.63439327478408813477f,
0.77301043272018432617f,0.55557024478912353516f,0.83146959543228149414f,
0.47139674425125122070f,0.88192129135131835938f,0.38268342614173889160f,
0.92387950420379638672f,0.29028466343879699707f,0.95694035291671752930f,
0.19509032368659973145f,0.98078525066375732422f,0.09801714122295379639f,
0.99518471956253051758f,1.00000000000000000000f,0.00000000000000000000f,
0.92387950420379638672f,0.38268342614173889160f,0.70710676908493041992f,
0.70710676908493041992f,0.38268342614173889160f,0.92387950420379638672f,};

float32_t rearranged_twiddle_stride2_256_f32[168]={
1.00000000000000000000f,0.00000000000000000000f,0.99879544973373413086f,
0.04906767606735229492f,0.99518471956253051758f,0.09801714122295379639f,
0.98917651176452636719f,0.14673046767711639404f,0.98078525066375732422f,
0.19509032368659973145f,0.97003126144409179688f,0.24298018217086791992f,
0.95694035291671752930f,0.29028466343879699707f,0.94154405593872070312f,
0.33688986301422119141f,0.92387950420379638672f,0.38268342614173889160f,
0.90398931503295898438f,0.42755508422851562500f,0.88192129135131835938f,
0.47139674425125122070f,0.85772860050201416016f,0.51410275697708129883f,
0.83146959543228149414f,0.55557024478912353516f,0.80320751667022705078f,
0.59569931030273437500f,0.77301043272018432617f,0.63439327478408813477f,
0.74095112085342407227f,0.67155897617340087891f,0.70710676908493041992f,
0.70710676908493041992f,0.67155897617340087891f,0.74095112085342407227f,
0.63439327478408813477f,0.77301043272018432617f,0.59569931030273437500f,
0.80320751667022705078f,0.55557024478912353516f,0.83146959543228149414f,
0.51410275697708129883f,0.85772860050201416016f,0.47139674425125122070f,
0.88192129135131835938f,0.42755508422851562500f,0.90398931503295898438f,
0.38268342614173889160f,0.92387950420379638672f,0.33688986301422119141f,
0.94154405593872070312f,0.29028466343879699707f,0.95694035291671752930f,
0.24298018217086791992f,0.97003126144409179688f,0.19509032368659973145f,
0.98078525066375732422f,0.14673046767711639404f,0.98917651176452636719f,
0.09801714122295379639f,0.99518471956253051758f,0.04906767606735229492f,
0.99879544973373413086f,0.00000000000000006123f,1.00000000000000000000f,
-0.04906767606735229492f,0.99879544973373413086f,-0.09801714122295379639f,
0.99518471956253051758f,-0.14673046767711639404f,0.98917651176452636719f,
-0.19509032368659973145f,0.98078525066375732422f,-0.24298018217086791992f,
0.97003126144409179688f,-0.29028466343879699707f,0.95694035291671752930f,
-0.33688986301422119141f,0.94154405593872070312f,-0.38268342614173889160f,
0.92387950420379638672f,-0.42755508422851562500f,0.90398931503295898438f,
-0.47139674425125122070f,0.88192129135131835938f,-0.51410275697708129883f,
0.85772860050201416016f,-0.55557024478912353516f,0.83146959543228149414f,
-0.59569931030273437500f,0.80320751667022705078f,-0.63439327478408813477f,
0.77301043272018432617f,-0.67155897617340087891f,0.74095112085342407227f,
-0.70710676908493041992f,0.70710676908493041992f,-0.74095112085342407227f,
0.67155897617340087891f,-0.77301043272018432617f,0.63439327478408813477f,
-0.80320751667022705078f,0.59569931030273437500f,-0.83146959543228149414f,
0.55557024478912353516f,-0.85772860050201416016f,0.51410275697708129883f,
-0.88192129135131835938f,0.47139674425125122070f,-0.90398931503295898438f,
0.42755508422851562500f,-0.92387950420379638672f,0.38268342614173889160f,
-0.94154405593872070312f,0.33688986301422119141f,-0.95694035291671752930f,
0.29028466343879699707f,-0.97003126144409179688f,0.24298018217086791992f,
-0.98078525066375732422f,0.19509032368659973145f,-0.98917651176452636719f,
0.14673046767711639404f,-0.99518471956253051758f,0.09801714122295379639f,
-0.99879544973373413086f,0.04906767606735229492f,1.00000000000000000000f,
0.00000000000000000000f,0.98078525066375732422f,0.19509032368659973145f,
0.92387950420379638672f,0.38268342614173889160f,0.83146959543228149414f,
0.55557024478912353516f,0.70710676908493041992f,0.70710676908493041992f,
0.55557024478912353516f,0.83146959543228149414f,0.38268342614173889160f,
0.92387950420379638672f,0.19509032368659973145f,0.98078525066375732422f,
0.00000000000000006123f,1.00000000000000000000f,-0.19509032368659973145f,
0.98078525066375732422f,-0.38268342614173889160f,0.92387950420379638672f,
-0.55557024478912353516f,0.83146959543228149414f,-0.70710676908493041992f,
0.70710676908493041992f,-0.83146959543228149414f,0.55557024478912353516f,
-0.92387950420379638672f,0.38268342614173889160f,-0.98078525066375732422f,
0.19509032368659973145f,1.00000000000000000000f,0.00000000000000000000f,
0.70710676908493041992f,0.70710676908493041992f,0.00000000000000006123f,
1.00000000000000000000f,-0.70710676908493041992f,0.70710676908493041992f,};

float32_t rearranged_twiddle_stride3_256_f32[168]={
1.00000000000000000000f,0.00000000000000000000f,0.99729043245315551758f,
0.07356456667184829712f,0.98917651176452636719f,0.14673046767711639404f,
0.97570210695266723633f,0.21910123527050018311f,0.95694035291671752930f,
0.29028466343879699707f,0.93299281597137451172f,0.35989505052566528320f,
0.90398931503295898438f,0.42755508422851562500f,0.87008696794509887695f,
0.49289819598197937012f,0.83146959543228149414f,0.55557024478912353516f,
0.78834640979766845703f,0.61523157358169555664f,0.74095112085342407227f,
0.67155897617340087891f,0.68954056501388549805f,0.72424709796905517578f,
0.63439327478408813477f,0.77301043272018432617f,0.57580816745758056641f,
0.81758481264114379883f,0.51410275697708129883f,0.85772860050201416016f,
0.44961133599281311035f,0.89322429895401000977f,0.38268342614173889160f,
0.92387950420379638672f,0.31368175148963928223f,0.94952815771102905273f,
0.24298018217086791992f,0.97003126144409179688f,0.17096188664436340332f,
0.98527765274047851562f,0.09801714122295379639f,0.99518471956253051758f,
0.02454122900962829590f,0.99969881772994995117f,-0.04906767606735229492f,
0.99879544973373413086f,-0.12241067737340927124f,0.99247956275939941406f,
-0.19509032368659973145f,0.98078525066375732422f,-0.26671275496482849121f,
0.96377605199813842773f,-0.33688986301422119141f,0.94154405593872070312f,
-0.40524131059646606445f,0.91420978307723999023f,-0.47139674425125122070f,
0.88192129135131835938f,-0.53499764204025268555f,0.84485357999801635742f,
-0.59569931030273437500f,0.80320751667022705078f,-0.65317285060882568359f,
0.75720882415771484375f,-0.70710676908493041992f,0.70710676908493041992f,
-0.75720882415771484375f,0.65317285060882568359f,-0.80320751667022705078f,
0.59569931030273437500f,-0.84485357999801635742f,0.53499764204025268555f,
-0.88192129135131835938f,0.47139674425125122070f,-0.91420978307723999023f,
0.40524131059646606445f,-0.94154405593872070312f,0.33688986301422119141f,
-0.96377605199813842773f,0.26671275496482849121f,-0.98078525066375732422f,
0.19509032368659973145f,-0.99247956275939941406f,0.12241067737340927124f,
-0.99879544973373413086f,0.04906767606735229492f,-0.99969881772994995117f,
-0.02454122900962829590f,-0.99518471956253051758f,-0.09801714122295379639f,
-0.98527765274047851562f,-0.17096188664436340332f,-0.97003126144409179688f,
-0.24298018217086791992f,-0.94952815771102905273f,-0.31368175148963928223f,
-0.92387950420379638672f,-0.38268342614173889160f,-0.89322429895401000977f,
-0.44961133599281311035f,-0.85772860050201416016f,-0.51410275697708129883f,
-0.81758481264114379883f,-0.57580816745758056641f,-0.77301043272018432617f,
-0.63439327478408813477f,-0.72424709796905517578f,-0.68954056501388549805f,
-0.67155897617340087891f,-0.74095112085342407227f,-0.61523157358169555664f,
-0.78834640979766845703f,-0.55557024478912353516f,-0.83146959543228149414f,
-0.49289819598197937012f,-0.87008696794509887695f,-0.42755508422851562500f,
-0.90398931503295898438f,-0.35989505052566528320f,-0.93299281597137451172f,
-0.29028466343879699707f,-0.95694035291671752930f,-0.21910123527050018311f,
-0.97570210695266723633f,-0.14673046767711639404f,-0.98917651176452636719f,
-0.07356456667184829712f,-0.99729043245315551758f,1.00000000000000000000f,
0.00000000000000000000f,0.95694035291671752930f,0.29028466343879699707f,
0.83146959543228149414f,0.55557024478912353516f,0.63439327478408813477f,
0.77301043272018432617f,0.38268342614173889160f,0.92387950420379638672f,
0.09801714122295379639f,0.99518471956253051758f,-0.19509032368659973145f,
0.98078525066375732422f,-0.47139674425125122070f,0.88192129135131835938f,
-0.70710676908493041992f,0.70710676908493041992f,-0.88192129135131835938f,
0.47139674425125122070f,-0.98078525066375732422f,0.19509032368659973145f,
-0.99518471956253051758f,-0.09801714122295379639f,-0.92387950420379638672f,
-0.38268342614173889160f,-0.77301043272018432617f,-0.63439327478408813477f,
-0.55557024478912353516f,-0.83146959543228149414f,-0.29028466343879699707f,
-0.95694035291671752930f,1.00000000000000000000f,0.00000000000000000000f,
0.38268342614173889160f,0.92387950420379638672f,-0.70710676908493041992f,
0.70710676908493041992f,-0.92387950420379638672f,-0.38268342614173889160f,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F32_1024) || defined(ARM_TABLE_TWIDDLECOEF_F32_2048)

uint32_t rearranged_twiddle_tab_stride1_arr_1024_f32[5]={
0,512,640,672,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_1024_f32[5]={
0,512,640,672,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_1024_f32[5]={
0,512,640,672,0,};

float32_t rearranged_twiddle_stride1_1024_f32[680]={
1.00000000000000000000f,0.00000000000000000000f,0.99998116493225097656f,
0.00613588467240333557f,0.99992471933364868164f,0.01227153837680816650f,
0.99983060359954833984f,0.01840673014521598816f,0.99969881772994995117f,
0.02454122900962829590f,0.99952942132949829102f,0.03067480400204658508f,
0.99932235479354858398f,0.03680722415447235107f,0.99907773733139038086f,
0.04293825849890708923f,0.99879544973373413086f,0.04906767606735229492f,
0.99847555160522460938f,0.05519524589180946350f,0.99811810255050659180f,
0.06132073700428009033f,0.99772304296493530273f,0.06744392216205596924f,
0.99729043245315551758f,0.07356456667184829712f,0.99682027101516723633f,
0.07968243956565856934f,0.99631261825561523438f,0.08579730987548828125f,
0.99576741456985473633f,0.09190895408391952515f,0.99518471956253051758f,
0.09801714122295379639f,0.99456459283828735352f,0.10412163287401199341f,
0.99390697479248046875f,0.11022220551967620850f,0.99321192502975463867f,
0.11631862819194793701f,0.99247956275939941406f,0.12241067737340927124f,
0.99170976877212524414f,0.12849810719490051270f,0.99090266227722167969f,
0.13458070158958435059f,0.99005818367004394531f,0.14065824449062347412f,
0.98917651176452636719f,0.14673046767711639404f,0.98825758695602416992f,
0.15279719233512878418f,0.98730140924453735352f,0.15885815024375915527f,
0.98630809783935546875f,0.16491311788558959961f,0.98527765274047851562f,
0.17096188664436340332f,0.98421007394790649414f,0.17700421810150146484f,
0.98310548067092895508f,0.18303988873958587646f,0.98196387290954589844f,
0.18906866014003753662f,0.98078525066375732422f,0.19509032368659973145f,
0.97956979274749755859f,0.20110464096069335938f,0.97831737995147705078f,
0.20711137354373931885f,0.97702813148498535156f,0.21311031281948089600f,
0.97570210695266723633f,0.21910123527050018311f,0.97433936595916748047f,
0.22508391737937927246f,0.97293996810913085938f,0.23105810582637786865f,
0.97150391340255737305f,0.23702360689640045166f,0.97003126144409179688f,
0.24298018217086791992f,0.96852207183837890625f,0.24892760813236236572f,
0.96697646379470825195f,0.25486564636230468750f,0.96539443731307983398f,
0.26079410314559936523f,0.96377605199813842773f,0.26671275496482849121f,
0.96212142705917358398f,0.27262136340141296387f,0.96043050289154052734f,
0.27851969003677368164f,0.95870345830917358398f,0.28440752625465393066f,
0.95694035291671752930f,0.29028466343879699707f,0.95514118671417236328f,
0.29615089297294616699f,0.95330601930618286133f,0.30200594663619995117f,
0.95143502950668334961f,0.30784964561462402344f,0.94952815771102905273f,
0.31368175148963928223f,0.94758558273315429688f,0.31950202584266662598f,
0.94560730457305908203f,0.32531028985977172852f,0.94359344244003295898f,
0.33110630512237548828f,0.94154405593872070312f,0.33688986301422119141f,
0.93945920467376708984f,0.34266072511672973633f,0.93733900785446166992f,
0.34841868281364440918f,0.93518352508544921875f,0.35416352748870849609f,
0.93299281597137451172f,0.35989505052566528320f,0.93076694011688232422f,
0.36561298370361328125f,0.92850607633590698242f,0.37131720781326293945f,
0.92621022462844848633f,0.37700742483139038086f,0.92387950420379638672f,
0.38268342614173889160f,0.92151403427124023438f,0.38834503293037414551f,
0.91911387443542480469f,0.39399203658103942871f,0.91667908430099487305f,
0.39962419867515563965f,0.91420978307723999023f,0.40524131059646606445f,
0.91170603036880493164f,0.41084316372871398926f,0.90916800498962402344f,
0.41642954945564270020f,0.90659570693969726562f,0.42200025916099548340f,
0.90398931503295898438f,0.42755508422851562500f,0.90134882926940917969f,
0.43309381604194641113f,0.89867448806762695312f,0.43861624598503112793f,
0.89596623182296752930f,0.44412213563919067383f,0.89322429895401000977f,
0.44961133599281311035f,0.89044874906539916992f,0.45508357882499694824f,
0.88763964176177978516f,0.46053871512413024902f,0.88479709625244140625f,
0.46597650647163391113f,0.88192129135131835938f,0.47139674425125122070f,
0.87901222705841064453f,0.47679921984672546387f,0.87607008218765258789f,
0.48218378424644470215f,0.87309497594833374023f,0.48755016922950744629f,
0.87008696794509887695f,0.49289819598197937012f,0.86704623699188232422f,
0.49822765588760375977f,0.86397284269332885742f,0.50353837013244628906f,
0.86086696386337280273f,0.50883013010025024414f,0.85772860050201416016f,
0.51410275697708129883f,0.85455799102783203125f,0.51935601234436035156f,
0.85135519504547119141f,0.52458965778350830078f,0.84812033176422119141f,
0.52980363368988037109f,0.84485357999801635742f,0.53499764204025268555f,
0.84155499935150146484f,0.54017144441604614258f,0.83822470903396606445f,
0.54532498121261596680f,0.83486288785934448242f,0.55045795440673828125f,
0.83146959543228149414f,0.55557024478912353516f,0.82804507017135620117f,
0.56066155433654785156f,0.82458931207656860352f,0.56573182344436645508f,
0.82110249996185302734f,0.57078075408935546875f,0.81758481264114379883f,
0.57580816745758056641f,0.81403630971908569336f,0.58081394433975219727f,
0.81045717000961303711f,0.58579784631729125977f,0.80684757232666015625f,
0.59075969457626342773f,0.80320751667022705078f,0.59569931030273437500f,
0.79953724145889282227f,0.60061645507812500000f,0.79583692550659179688f,
0.60551106929779052734f,0.79210656881332397461f,0.61038279533386230469f,
0.78834640979766845703f,0.61523157358169555664f,0.78455656766891479492f,
0.62005722522735595703f,0.78073722124099731445f,0.62485951185226440430f,
0.77688848972320556641f,0.62963825464248657227f,0.77301043272018432617f,
0.63439327478408813477f,0.76910334825515747070f,0.63912445306777954102f,
0.76516723632812500000f,0.64383155107498168945f,0.76120239496231079102f,
0.64851438999176025391f,0.75720882415771484375f,0.65317285060882568359f,
0.75318682193756103516f,0.65780669450759887695f,0.74913638830184936523f,
0.66241580247879028320f,0.74505776166915893555f,0.66699993610382080078f,
0.74095112085342407227f,0.67155897617340087891f,0.73681658506393432617f,
0.67609268426895141602f,0.73265427350997924805f,0.68060100078582763672f,
0.72846436500549316406f,0.68508368730545043945f,0.72424709796905517578f,
0.68954056501388549805f,0.72000253200531005859f,0.69397145509719848633f,
0.71573084592819213867f,0.69837623834609985352f,0.71143221855163574219f,
0.70275473594665527344f,0.70710676908493041992f,0.70710676908493041992f,
0.70275473594665527344f,0.71143221855163574219f,0.69837623834609985352f,
0.71573084592819213867f,0.69397145509719848633f,0.72000253200531005859f,
0.68954056501388549805f,0.72424709796905517578f,0.68508368730545043945f,
0.72846436500549316406f,0.68060100078582763672f,0.73265427350997924805f,
0.67609268426895141602f,0.73681658506393432617f,0.67155897617340087891f,
0.74095112085342407227f,0.66699993610382080078f,0.74505776166915893555f,
0.66241580247879028320f,0.74913638830184936523f,0.65780669450759887695f,
0.75318682193756103516f,0.65317285060882568359f,0.75720882415771484375f,
0.64851438999176025391f,0.76120239496231079102f,0.64383155107498168945f,
0.76516723632812500000f,0.63912445306777954102f,0.76910334825515747070f,
0.63439327478408813477f,0.77301043272018432617f,0.62963825464248657227f,
0.77688848972320556641f,0.62485951185226440430f,0.78073722124099731445f,
0.62005722522735595703f,0.78455656766891479492f,0.61523157358169555664f,
0.78834640979766845703f,0.61038279533386230469f,0.79210656881332397461f,
0.60551106929779052734f,0.79583692550659179688f,0.60061645507812500000f,
0.79953724145889282227f,0.59569931030273437500f,0.80320751667022705078f,
0.59075969457626342773f,0.80684757232666015625f,0.58579784631729125977f,
0.81045717000961303711f,0.58081394433975219727f,0.81403630971908569336f,
0.57580816745758056641f,0.81758481264114379883f,0.57078075408935546875f,
0.82110249996185302734f,0.56573182344436645508f,0.82458931207656860352f,
0.56066155433654785156f,0.82804507017135620117f,0.55557024478912353516f,
0.83146959543228149414f,0.55045795440673828125f,0.83486288785934448242f,
0.54532498121261596680f,0.83822470903396606445f,0.54017144441604614258f,
0.84155499935150146484f,0.53499764204025268555f,0.84485357999801635742f,
0.52980363368988037109f,0.84812033176422119141f,0.52458965778350830078f,
0.85135519504547119141f,0.51935601234436035156f,0.85455799102783203125f,
0.51410275697708129883f,0.85772860050201416016f,0.50883013010025024414f,
0.86086696386337280273f,0.50353837013244628906f,0.86397284269332885742f,
0.49822765588760375977f,0.86704623699188232422f,0.49289819598197937012f,
0.87008696794509887695f,0.48755016922950744629f,0.87309497594833374023f,
0.48218378424644470215f,0.87607008218765258789f,0.47679921984672546387f,
0.87901222705841064453f,0.47139674425125122070f,0.88192129135131835938f,
0.46597650647163391113f,0.88479709625244140625f,0.46053871512413024902f,
0.88763964176177978516f,0.45508357882499694824f,0.89044874906539916992f,
0.44961133599281311035f,0.89322429895401000977f,0.44412213563919067383f,
0.89596623182296752930f,0.43861624598503112793f,0.89867448806762695312f,
0.43309381604194641113f,0.90134882926940917969f,0.42755508422851562500f,
0.90398931503295898438f,0.42200025916099548340f,0.90659570693969726562f,
0.41642954945564270020f,0.90916800498962402344f,0.41084316372871398926f,
0.91170603036880493164f,0.40524131059646606445f,0.91420978307723999023f,
0.39962419867515563965f,0.91667908430099487305f,0.39399203658103942871f,
0.91911387443542480469f,0.38834503293037414551f,0.92151403427124023438f,
0.38268342614173889160f,0.92387950420379638672f,0.37700742483139038086f,
0.92621022462844848633f,0.37131720781326293945f,0.92850607633590698242f,
0.36561298370361328125f,0.93076694011688232422f,0.35989505052566528320f,
0.93299281597137451172f,0.35416352748870849609f,0.93518352508544921875f,
0.34841868281364440918f,0.93733900785446166992f,0.34266072511672973633f,
0.93945920467376708984f,0.33688986301422119141f,0.94154405593872070312f,
0.33110630512237548828f,0.94359344244003295898f,0.32531028985977172852f,
0.94560730457305908203f,0.31950202584266662598f,0.94758558273315429688f,
0.31368175148963928223f,0.94952815771102905273f,0.30784964561462402344f,
0.95143502950668334961f,0.30200594663619995117f,0.95330601930618286133f,
0.29615089297294616699f,0.95514118671417236328f,0.29028466343879699707f,
0.95694035291671752930f,0.28440752625465393066f,0.95870345830917358398f,
0.27851969003677368164f,0.96043050289154052734f,0.27262136340141296387f,
0.96212142705917358398f,0.26671275496482849121f,0.96377605199813842773f,
0.26079410314559936523f,0.96539443731307983398f,0.25486564636230468750f,
0.96697646379470825195f,0.24892760813236236572f,0.96852207183837890625f,
0.24298018217086791992f,0.97003126144409179688f,0.23702360689640045166f,
0.97150391340255737305f,0.23105810582637786865f,0.97293996810913085938f,
0.22508391737937927246f,0.97433936595916748047f,0.21910123527050018311f,
0.97570210695266723633f,0.21311031281948089600f,0.97702813148498535156f,
0.20711137354373931885f,0.97831737995147705078f,0.20110464096069335938f,
0.97956979274749755859f,0.19509032368659973145f,0.98078525066375732422f,
0.18906866014003753662f,0.98196387290954589844f,0.18303988873958587646f,
0.98310548067092895508f,0.17700421810150146484f,0.98421007394790649414f,
0.17096188664436340332f,0.98527765274047851562f,0.16491311788558959961f,
0.98630809783935546875f,0.15885815024375915527f,0.98730140924453735352f,
0.15279719233512878418f,0.98825758695602416992f,0.14673046767711639404f,
0.98917651176452636719f,0.14065824449062347412f,0.99005818367004394531f,
0.13458070158958435059f,0.99090266227722167969f,0.12849810719490051270f,
0.99170976877212524414f,0.12241067737340927124f,0.99247956275939941406f,
0.11631862819194793701f,0.99321192502975463867f,0.11022220551967620850f,
0.99390697479248046875f,0.10412163287401199341f,0.99456459283828735352f,
0.09801714122295379639f,0.99518471956253051758f,0.09190895408391952515f,
0.99576741456985473633f,0.08579730987548828125f,0.99631261825561523438f,
0.07968243956565856934f,0.99682027101516723633f,0.07356456667184829712f,
0.99729043245315551758f,0.06744392216205596924f,0.99772304296493530273f,
0.06132073700428009033f,0.99811810255050659180f,0.05519524589180946350f,
0.99847555160522460938f,0.04906767606735229492f,0.99879544973373413086f,
0.04293825849890708923f,0.99907773733139038086f,0.03680722415447235107f,
0.99932235479354858398f,0.03067480400204658508f,0.99952942132949829102f,
0.02454122900962829590f,0.99969881772994995117f,0.01840673014521598816f,
0.99983060359954833984f,0.01227153837680816650f,0.99992471933364868164f,
0.00613588467240333557f,0.99998116493225097656f,1.00000000000000000000f,
0.00000000000000000000f,0.99969881772994995117f,0.02454122900962829590f,
0.99879544973373413086f,0.04906767606735229492f,0.99729043245315551758f,
0.07356456667184829712f,0.99518471956253051758f,0.09801714122295379639f,
0.99247956275939941406f,0.12241067737340927124f,0.98917651176452636719f,
0.14673046767711639404f,0.98527765274047851562f,0.17096188664436340332f,
0.98078525066375732422f,0.19509032368659973145f,0.97570210695266723633f,
0.21910123527050018311f,0.97003126144409179688f,0.24298018217086791992f,
0.96377605199813842773f,0.26671275496482849121f,0.95694035291671752930f,
0.29028466343879699707f,0.94952815771102905273f,0.31368175148963928223f,
0.94154405593872070312f,0.33688986301422119141f,0.93299281597137451172f,
0.35989505052566528320f,0.92387950420379638672f,0.38268342614173889160f,
0.91420978307723999023f,0.40524131059646606445f,0.90398931503295898438f,
0.42755508422851562500f,0.89322429895401000977f,0.44961133599281311035f,
0.88192129135131835938f,0.47139674425125122070f,0.87008696794509887695f,
0.49289819598197937012f,0.85772860050201416016f,0.51410275697708129883f,
0.84485357999801635742f,0.53499764204025268555f,0.83146959543228149414f,
0.55557024478912353516f,0.81758481264114379883f,0.57580816745758056641f,
0.80320751667022705078f,0.59569931030273437500f,0.78834640979766845703f,
0.61523157358169555664f,0.77301043272018432617f,0.63439327478408813477f,
0.75720882415771484375f,0.65317285060882568359f,0.74095112085342407227f,
0.67155897617340087891f,0.72424709796905517578f,0.68954056501388549805f,
0.70710676908493041992f,0.70710676908493041992f,0.68954056501388549805f,
0.72424709796905517578f,0.67155897617340087891f,0.74095112085342407227f,
0.65317285060882568359f,0.75720882415771484375f,0.63439327478408813477f,
0.77301043272018432617f,0.61523157358169555664f,0.78834640979766845703f,
0.59569931030273437500f,0.80320751667022705078f,0.57580816745758056641f,
0.81758481264114379883f,0.55557024478912353516f,0.83146959543228149414f,
0.53499764204025268555f,0.84485357999801635742f,0.51410275697708129883f,
0.85772860050201416016f,0.49289819598197937012f,0.87008696794509887695f,
0.47139674425125122070f,0.88192129135131835938f,0.44961133599281311035f,
0.89322429895401000977f,0.42755508422851562500f,0.90398931503295898438f,
0.40524131059646606445f,0.91420978307723999023f,0.38268342614173889160f,
0.92387950420379638672f,0.35989505052566528320f,0.93299281597137451172f,
0.33688986301422119141f,0.94154405593872070312f,0.31368175148963928223f,
0.94952815771102905273f,0.29028466343879699707f,0.95694035291671752930f,
0.26671275496482849121f,0.96377605199813842773f,0.24298018217086791992f,
0.97003126144409179688f,0.21910123527050018311f,0.97570210695266723633f,
0.19509032368659973145f,0.98078525066375732422f,0.17096188664436340332f,
0.98527765274047851562f,0.14673046767711639404f,0.98917651176452636719f,
0.12241067737340927124f,0.99247956275939941406f,0.09801714122295379639f,
0.99518471956253051758f,0.07356456667184829712f,0.99729043245315551758f,
0.04906767606735229492f,0.99879544973373413086f,0.02454122900962829590f,
0.99969881772994995117f,1.00000000000000000000f,0.00000000000000000000f,
0.99518471956253051758f,0.09801714122295379639f,0.98078525066375732422f,
0.19509032368659973145f,0.95694035291671752930f,0.29028466343879699707f,
0.92387950420379638672f,0.38268342614173889160f,0.88192129135131835938f,
0.47139674425125122070f,0.83146959543228149414f,0.55557024478912353516f,
0.77301043272018432617f,0.63439327478408813477f,0.70710676908493041992f,
0.70710676908493041992f,0.63439327478408813477f,0.77301043272018432617f,
0.55557024478912353516f,0.83146959543228149414f,0.47139674425125122070f,
0.88192129135131835938f,0.38268342614173889160f,0.92387950420379638672f,
0.29028466343879699707f,0.95694035291671752930f,0.19509032368659973145f,
0.98078525066375732422f,0.09801714122295379639f,0.99518471956253051758f,
1.00000000000000000000f,0.00000000000000000000f,0.92387950420379638672f,
0.38268342614173889160f,0.70710676908493041992f,0.70710676908493041992f,
0.38268342614173889160f,0.92387950420379638672f,};

float32_t rearranged_twiddle_stride2_1024_f32[680]={
1.00000000000000000000f,0.00000000000000000000f,0.99992471933364868164f,
0.01227153837680816650f,0.99969881772994995117f,0.02454122900962829590f,
0.99932235479354858398f,0.03680722415447235107f,0.99879544973373413086f,
0.04906767606735229492f,0.99811810255050659180f,0.06132073700428009033f,
0.99729043245315551758f,0.07356456667184829712f,0.99631261825561523438f,
0.08579730987548828125f,0.99518471956253051758f,0.09801714122295379639f,
0.99390697479248046875f,0.11022220551967620850f,0.99247956275939941406f,
0.12241067737340927124f,0.99090266227722167969f,0.13458070158958435059f,
0.98917651176452636719f,0.14673046767711639404f,0.98730140924453735352f,
0.15885815024375915527f,0.98527765274047851562f,0.17096188664436340332f,
0.98310548067092895508f,0.18303988873958587646f,0.98078525066375732422f,
0.19509032368659973145f,0.97831737995147705078f,0.20711137354373931885f,
0.97570210695266723633f,0.21910123527050018311f,0.97293996810913085938f,
0.23105810582637786865f,0.97003126144409179688f,0.24298018217086791992f,
0.96697646379470825195f,0.25486564636230468750f,0.96377605199813842773f,
0.26671275496482849121f,0.96043050289154052734f,0.27851969003677368164f,
0.95694035291671752930f,0.29028466343879699707f,0.95330601930618286133f,
0.30200594663619995117f,0.94952815771102905273f,0.31368175148963928223f,
0.94560730457305908203f,0.32531028985977172852f,0.94154405593872070312f,
0.33688986301422119141f,0.93733900785446166992f,0.34841868281364440918f,
0.93299281597137451172f,0.35989505052566528320f,0.92850607633590698242f,
0.37131720781326293945f,0.92387950420379638672f,0.38268342614173889160f,
0.91911387443542480469f,0.39399203658103942871f,0.91420978307723999023f,
0.40524131059646606445f,0.90916800498962402344f,0.41642954945564270020f,
0.90398931503295898438f,0.42755508422851562500f,0.89867448806762695312f,
0.43861624598503112793f,0.89322429895401000977f,0.44961133599281311035f,
0.88763964176177978516f,0.46053871512413024902f,0.88192129135131835938f,
0.47139674425125122070f,0.87607008218765258789f,0.48218378424644470215f,
0.87008696794509887695f,0.49289819598197937012f,0.86397284269332885742f,
0.50353837013244628906f,0.85772860050201416016f,0.51410275697708129883f,
0.85135519504547119141f,0.52458965778350830078f,0.84485357999801635742f,
0.53499764204025268555f,0.83822470903396606445f,0.54532498121261596680f,
0.83146959543228149414f,0.55557024478912353516f,0.82458931207656860352f,
0.56573182344436645508f,0.81758481264114379883f,0.57580816745758056641f,
0.81045717000961303711f,0.58579784631729125977f,0.80320751667022705078f,
0.59569931030273437500f,0.79583692550659179688f,0.60551106929779052734f,
0.78834640979766845703f,0.61523157358169555664f,0.78073722124099731445f,
0.62485951185226440430f,0.77301043272018432617f,0.63439327478408813477f,
0.76516723632812500000f,0.64383155107498168945f,0.75720882415771484375f,
0.65317285060882568359f,0.74913638830184936523f,0.66241580247879028320f,
0.74095112085342407227f,0.67155897617340087891f,0.73265427350997924805f,
0.68060100078582763672f,0.72424709796905517578f,0.68954056501388549805f,
0.71573084592819213867f,0.69837623834609985352f,0.70710676908493041992f,
0.70710676908493041992f,0.69837623834609985352f,0.71573084592819213867f,
0.68954056501388549805f,0.72424709796905517578f,0.68060100078582763672f,
0.73265427350997924805f,0.67155897617340087891f,0.74095112085342407227f,
0.66241580247879028320f,0.74913638830184936523f,0.65317285060882568359f,
0.75720882415771484375f,0.64383155107498168945f,0.76516723632812500000f,
0.63439327478408813477f,0.77301043272018432617f,0.62485951185226440430f,
0.78073722124099731445f,0.61523157358169555664f,0.78834640979766845703f,
0.60551106929779052734f,0.79583692550659179688f,0.59569931030273437500f,
0.80320751667022705078f,0.58579784631729125977f,0.81045717000961303711f,
0.57580816745758056641f,0.81758481264114379883f,0.56573182344436645508f,
0.82458931207656860352f,0.55557024478912353516f,0.83146959543228149414f,
0.54532498121261596680f,0.83822470903396606445f,0.53499764204025268555f,
0.84485357999801635742f,0.52458965778350830078f,0.85135519504547119141f,
0.51410275697708129883f,0.85772860050201416016f,0.50353837013244628906f,
0.86397284269332885742f,0.49289819598197937012f,0.87008696794509887695f,
0.48218378424644470215f,0.87607008218765258789f,0.47139674425125122070f,
0.88192129135131835938f,0.46053871512413024902f,0.88763964176177978516f,
0.44961133599281311035f,0.89322429895401000977f,0.43861624598503112793f,
0.89867448806762695312f,0.42755508422851562500f,0.90398931503295898438f,
0.41642954945564270020f,0.90916800498962402344f,0.40524131059646606445f,
0.91420978307723999023f,0.39399203658103942871f,0.91911387443542480469f,
0.38268342614173889160f,0.92387950420379638672f,0.37131720781326293945f,
0.92850607633590698242f,0.35989505052566528320f,0.93299281597137451172f,
0.34841868281364440918f,0.93733900785446166992f,0.33688986301422119141f,
0.94154405593872070312f,0.32531028985977172852f,0.94560730457305908203f,
0.31368175148963928223f,0.94952815771102905273f,0.30200594663619995117f,
0.95330601930618286133f,0.29028466343879699707f,0.95694035291671752930f,
0.27851969003677368164f,0.96043050289154052734f,0.26671275496482849121f,
0.96377605199813842773f,0.25486564636230468750f,0.96697646379470825195f,
0.24298018217086791992f,0.97003126144409179688f,0.23105810582637786865f,
0.97293996810913085938f,0.21910123527050018311f,0.97570210695266723633f,
0.20711137354373931885f,0.97831737995147705078f,0.19509032368659973145f,
0.98078525066375732422f,0.18303988873958587646f,0.98310548067092895508f,
0.17096188664436340332f,0.98527765274047851562f,0.15885815024375915527f,
0.98730140924453735352f,0.14673046767711639404f,0.98917651176452636719f,
0.13458070158958435059f,0.99090266227722167969f,0.12241067737340927124f,
0.99247956275939941406f,0.11022220551967620850f,0.99390697479248046875f,
0.09801714122295379639f,0.99518471956253051758f,0.08579730987548828125f,
0.99631261825561523438f,0.07356456667184829712f,0.99729043245315551758f,
0.06132073700428009033f,0.99811810255050659180f,0.04906767606735229492f,
0.99879544973373413086f,0.03680722415447235107f,0.99932235479354858398f,
0.02454122900962829590f,0.99969881772994995117f,0.01227153837680816650f,
0.99992471933364868164f,0.00000000000000006123f,1.00000000000000000000f,
-0.01227153837680816650f,0.99992471933364868164f,-0.02454122900962829590f,
0.99969881772994995117f,-0.03680722415447235107f,0.99932235479354858398f,
-0.04906767606735229492f,0.99879544973373413086f,-0.06132073700428009033f,
0.99811810255050659180f,-0.07356456667184829712f,0.99729043245315551758f,
-0.08579730987548828125f,0.99631261825561523438f,-0.09801714122295379639f,
0.99518471956253051758f,-0.11022220551967620850f,0.99390697479248046875f,
-0.12241067737340927124f,0.99247956275939941406f,-0.13458070158958435059f,
0.99090266227722167969f,-0.14673046767711639404f,0.98917651176452636719f,
-0.15885815024375915527f,0.98730140924453735352f,-0.17096188664436340332f,
0.98527765274047851562f,-0.18303988873958587646f,0.98310548067092895508f,
-0.19509032368659973145f,0.98078525066375732422f,-0.20711137354373931885f,
0.97831737995147705078f,-0.21910123527050018311f,0.97570210695266723633f,
-0.23105810582637786865f,0.97293996810913085938f,-0.24298018217086791992f,
0.97003126144409179688f,-0.25486564636230468750f,0.96697646379470825195f,
-0.26671275496482849121f,0.96377605199813842773f,-0.27851969003677368164f,
0.96043050289154052734f,-0.29028466343879699707f,0.95694035291671752930f,
-0.30200594663619995117f,0.95330601930618286133f,-0.31368175148963928223f,
0.94952815771102905273f,-0.32531028985977172852f,0.94560730457305908203f,
-0.33688986301422119141f,0.94154405593872070312f,-0.34841868281364440918f,
0.93733900785446166992f,-0.35989505052566528320f,0.93299281597137451172f,
-0.37131720781326293945f,0.92850607633590698242f,-0.38268342614173889160f,
0.92387950420379638672f,-0.39399203658103942871f,0.91911387443542480469f,
-0.40524131059646606445f,0.91420978307723999023f,-0.41642954945564270020f,
0.90916800498962402344f,-0.42755508422851562500f,0.90398931503295898438f,
-0.43861624598503112793f,0.89867448806762695312f,-0.44961133599281311035f,
0.89322429895401000977f,-0.46053871512413024902f,0.88763964176177978516f,
-0.47139674425125122070f,0.88192129135131835938f,-0.48218378424644470215f,
0.87607008218765258789f,-0.49289819598197937012f,0.87008696794509887695f,
-0.50353837013244628906f,0.86397284269332885742f,-0.51410275697708129883f,
0.85772860050201416016f,-0.52458965778350830078f,0.85135519504547119141f,
-0.53499764204025268555f,0.84485357999801635742f,-0.54532498121261596680f,
0.83822470903396606445f,-0.55557024478912353516f,0.83146959543228149414f,
-0.56573182344436645508f,0.82458931207656860352f,-0.57580816745758056641f,
0.81758481264114379883f,-0.58579784631729125977f,0.81045717000961303711f,
-0.59569931030273437500f,0.80320751667022705078f,-0.60551106929779052734f,
0.79583692550659179688f,-0.61523157358169555664f,0.78834640979766845703f,
-0.62485951185226440430f,0.78073722124099731445f,-0.63439327478408813477f,
0.77301043272018432617f,-0.64383155107498168945f,0.76516723632812500000f,
-0.65317285060882568359f,0.75720882415771484375f,-0.66241580247879028320f,
0.74913638830184936523f,-0.67155897617340087891f,0.74095112085342407227f,
-0.68060100078582763672f,0.73265427350997924805f,-0.68954056501388549805f,
0.72424709796905517578f,-0.69837623834609985352f,0.71573084592819213867f,
-0.70710676908493041992f,0.70710676908493041992f,-0.71573084592819213867f,
0.69837623834609985352f,-0.72424709796905517578f,0.68954056501388549805f,
-0.73265427350997924805f,0.68060100078582763672f,-0.74095112085342407227f,
0.67155897617340087891f,-0.74913638830184936523f,0.66241580247879028320f,
-0.75720882415771484375f,0.65317285060882568359f,-0.76516723632812500000f,
0.64383155107498168945f,-0.77301043272018432617f,0.63439327478408813477f,
-0.78073722124099731445f,0.62485951185226440430f,-0.78834640979766845703f,
0.61523157358169555664f,-0.79583692550659179688f,0.60551106929779052734f,
-0.80320751667022705078f,0.59569931030273437500f,-0.81045717000961303711f,
0.58579784631729125977f,-0.81758481264114379883f,0.57580816745758056641f,
-0.82458931207656860352f,0.56573182344436645508f,-0.83146959543228149414f,
0.55557024478912353516f,-0.83822470903396606445f,0.54532498121261596680f,
-0.84485357999801635742f,0.53499764204025268555f,-0.85135519504547119141f,
0.52458965778350830078f,-0.85772860050201416016f,0.51410275697708129883f,
-0.86397284269332885742f,0.50353837013244628906f,-0.87008696794509887695f,
0.49289819598197937012f,-0.87607008218765258789f,0.48218378424644470215f,
-0.88192129135131835938f,0.47139674425125122070f,-0.88763964176177978516f,
0.46053871512413024902f,-0.89322429895401000977f,0.44961133599281311035f,
-0.89867448806762695312f,0.43861624598503112793f,-0.90398931503295898438f,
0.42755508422851562500f,-0.90916800498962402344f,0.41642954945564270020f,
-0.91420978307723999023f,0.40524131059646606445f,-0.91911387443542480469f,
0.39399203658103942871f,-0.92387950420379638672f,0.38268342614173889160f,
-0.92850607633590698242f,0.37131720781326293945f,-0.93299281597137451172f,
0.35989505052566528320f,-0.93733900785446166992f,0.34841868281364440918f,
-0.94154405593872070312f,0.33688986301422119141f,-0.94560730457305908203f,
0.32531028985977172852f,-0.94952815771102905273f,0.31368175148963928223f,
-0.95330601930618286133f,0.30200594663619995117f,-0.95694035291671752930f,
0.29028466343879699707f,-0.96043050289154052734f,0.27851969003677368164f,
-0.96377605199813842773f,0.26671275496482849121f,-0.96697646379470825195f,
0.25486564636230468750f,-0.97003126144409179688f,0.24298018217086791992f,
-0.97293996810913085938f,0.23105810582637786865f,-0.97570210695266723633f,
0.21910123527050018311f,-0.97831737995147705078f,0.20711137354373931885f,
-0.98078525066375732422f,0.19509032368659973145f,-0.98310548067092895508f,
0.18303988873958587646f,-0.98527765274047851562f,0.17096188664436340332f,
-0.98730140924453735352f,0.15885815024375915527f,-0.98917651176452636719f,
0.14673046767711639404f,-0.99090266227722167969f,0.13458070158958435059f,
-0.99247956275939941406f,0.12241067737340927124f,-0.99390697479248046875f,
0.11022220551967620850f,-0.99518471956253051758f,0.09801714122295379639f,
-0.99631261825561523438f,0.08579730987548828125f,-0.99729043245315551758f,
0.07356456667184829712f,-0.99811810255050659180f,0.06132073700428009033f,
-0.99879544973373413086f,0.04906767606735229492f,-0.99932235479354858398f,
0.03680722415447235107f,-0.99969881772994995117f,0.02454122900962829590f,
-0.99992471933364868164f,0.01227153837680816650f,1.00000000000000000000f,
0.00000000000000000000f,0.99879544973373413086f,0.04906767606735229492f,
0.99518471956253051758f,0.09801714122295379639f,0.98917651176452636719f,
0.14673046767711639404f,0.98078525066375732422f,0.19509032368659973145f,
0.97003126144409179688f,0.24298018217086791992f,0.95694035291671752930f,
0.29028466343879699707f,0.94154405593872070312f,0.33688986301422119141f,
0.92387950420379638672f,0.38268342614173889160f,0.90398931503295898438f,
0.42755508422851562500f,0.88192129135131835938f,0.47139674425125122070f,
0.85772860050201416016f,0.51410275697708129883f,0.83146959543228149414f,
0.55557024478912353516f,0.80320751667022705078f,0.59569931030273437500f,
0.77301043272018432617f,0.63439327478408813477f,0.74095112085342407227f,
0.67155897617340087891f,0.70710676908493041992f,0.70710676908493041992f,
0.67155897617340087891f,0.74095112085342407227f,0.63439327478408813477f,
0.77301043272018432617f,0.59569931030273437500f,0.80320751667022705078f,
0.55557024478912353516f,0.83146959543228149414f,0.51410275697708129883f,
0.85772860050201416016f,0.47139674425125122070f,0.88192129135131835938f,
0.42755508422851562500f,0.90398931503295898438f,0.38268342614173889160f,
0.92387950420379638672f,0.33688986301422119141f,0.94154405593872070312f,
0.29028466343879699707f,0.95694035291671752930f,0.24298018217086791992f,
0.97003126144409179688f,0.19509032368659973145f,0.98078525066375732422f,
0.14673046767711639404f,0.98917651176452636719f,0.09801714122295379639f,
0.99518471956253051758f,0.04906767606735229492f,0.99879544973373413086f,
0.00000000000000006123f,1.00000000000000000000f,-0.04906767606735229492f,
0.99879544973373413086f,-0.09801714122295379639f,0.99518471956253051758f,
-0.14673046767711639404f,0.98917651176452636719f,-0.19509032368659973145f,
0.98078525066375732422f,-0.24298018217086791992f,0.97003126144409179688f,
-0.29028466343879699707f,0.95694035291671752930f,-0.33688986301422119141f,
0.94154405593872070312f,-0.38268342614173889160f,0.92387950420379638672f,
-0.42755508422851562500f,0.90398931503295898438f,-0.47139674425125122070f,
0.88192129135131835938f,-0.51410275697708129883f,0.85772860050201416016f,
-0.55557024478912353516f,0.83146959543228149414f,-0.59569931030273437500f,
0.80320751667022705078f,-0.63439327478408813477f,0.77301043272018432617f,
-0.67155897617340087891f,0.74095112085342407227f,-0.70710676908493041992f,
0.70710676908493041992f,-0.74095112085342407227f,0.67155897617340087891f,
-0.77301043272018432617f,0.63439327478408813477f,-0.80320751667022705078f,
0.59569931030273437500f,-0.83146959543228149414f,0.55557024478912353516f,
-0.85772860050201416016f,0.51410275697708129883f,-0.88192129135131835938f,
0.47139674425125122070f,-0.90398931503295898438f,0.42755508422851562500f,
-0.92387950420379638672f,0.38268342614173889160f,-0.94154405593872070312f,
0.33688986301422119141f,-0.95694035291671752930f,0.29028466343879699707f,
-0.97003126144409179688f,0.24298018217086791992f,-0.98078525066375732422f,
0.19509032368659973145f,-0.98917651176452636719f,0.14673046767711639404f,
-0.99518471956253051758f,0.09801714122295379639f,-0.99879544973373413086f,
0.04906767606735229492f,1.00000000000000000000f,0.00000000000000000000f,
0.98078525066375732422f,0.19509032368659973145f,0.92387950420379638672f,
0.38268342614173889160f,0.83146959543228149414f,0.55557024478912353516f,
0.70710676908493041992f,0.70710676908493041992f,0.55557024478912353516f,
0.83146959543228149414f,0.38268342614173889160f,0.92387950420379638672f,
0.19509032368659973145f,0.98078525066375732422f,0.00000000000000006123f,
1.00000000000000000000f,-0.19509032368659973145f,0.98078525066375732422f,
-0.38268342614173889160f,0.92387950420379638672f,-0.55557024478912353516f,
0.83146959543228149414f,-0.70710676908493041992f,0.70710676908493041992f,
-0.83146959543228149414f,0.55557024478912353516f,-0.92387950420379638672f,
0.38268342614173889160f,-0.98078525066375732422f,0.19509032368659973145f,
1.00000000000000000000f,0.00000000000000000000f,0.70710676908493041992f,
0.70710676908493041992f,0.00000000000000006123f,1.00000000000000000000f,
-0.70710676908493041992f,0.70710676908493041992f,};

float32_t rearranged_twiddle_stride3_1024_f32[680]={
1.00000000000000000000f,0.00000000000000000000f,0.99983060359954833984f,
0.01840673014521598816f,0.99932235479354858398f,0.03680722415447235107f,
0.99847555160522460938f,0.05519524589180946350f,0.99729043245315551758f,
0.07356456667184829712f,0.99576741456985473633f,0.09190895408391952515f,
0.99390697479248046875f,0.11022220551967620850f,0.99170976877212524414f,
0.12849810719490051270f,0.98917651176452636719f,0.14673046767711639404f,
0.98630809783935546875f,0.16491311788558959961f,0.98310548067092895508f,
0.18303988873958587646f,0.97956979274749755859f,0.20110464096069335938f,
0.97570210695266723633f,0.21910123527050018311f,0.97150391340255737305f,
0.23702360689640045166f,0.96697646379470825195f,0.25486564636230468750f,
0.96212142705917358398f,0.27262136340141296387f,0.95694035291671752930f,
0.29028466343879699707f,0.95143502950668334961f,0.30784964561462402344f,
0.94560730457305908203f,0.32531028985977172852f,0.93945920467376708984f,
0.34266072511672973633f,0.93299281597137451172f,0.35989505052566528320f,
0.92621022462844848633f,0.37700742483139038086f,0.91911387443542480469f,
0.39399203658103942871f,0.91170603036880493164f,0.41084316372871398926f,
0.90398931503295898438f,0.42755508422851562500f,0.89596623182296752930f,
0.44412213563919067383f,0.88763964176177978516f,0.46053871512413024902f,
0.87901222705841064453f,0.47679921984672546387f,0.87008696794509887695f,
0.49289819598197937012f,0.86086696386337280273f,0.50883013010025024414f,
0.85135519504547119141f,0.52458965778350830078f,0.84155499935150146484f,
0.54017144441604614258f,0.83146959543228149414f,0.55557024478912353516f,
0.82110249996185302734f,0.57078075408935546875f,0.81045717000961303711f,
0.58579784631729125977f,0.79953724145889282227f,0.60061645507812500000f,
0.78834640979766845703f,0.61523157358169555664f,0.77688848972320556641f,
0.62963825464248657227f,0.76516723632812500000f,0.64383155107498168945f,
0.75318682193756103516f,0.65780669450759887695f,0.74095112085342407227f,
0.67155897617340087891f,0.72846436500549316406f,0.68508368730545043945f,
0.71573084592819213867f,0.69837623834609985352f,0.70275473594665527344f,
0.71143221855163574219f,0.68954056501388549805f,0.72424709796905517578f,
0.67609268426895141602f,0.73681658506393432617f,0.66241580247879028320f,
0.74913638830184936523f,0.64851438999176025391f,0.76120239496231079102f,
0.63439327478408813477f,0.77301043272018432617f,0.62005722522735595703f,
0.78455656766891479492f,0.60551106929779052734f,0.79583692550659179688f,
0.59075969457626342773f,0.80684757232666015625f,0.57580816745758056641f,
0.81758481264114379883f,0.56066155433654785156f,0.82804507017135620117f,
0.54532498121261596680f,0.83822470903396606445f,0.52980363368988037109f,
0.84812033176422119141f,0.51410275697708129883f,0.85772860050201416016f,
0.49822765588760375977f,0.86704623699188232422f,0.48218378424644470215f,
0.87607008218765258789f,0.46597650647163391113f,0.88479709625244140625f,
0.44961133599281311035f,0.89322429895401000977f,0.43309381604194641113f,
0.90134882926940917969f,0.41642954945564270020f,0.90916800498962402344f,
0.39962419867515563965f,0.91667908430099487305f,0.38268342614173889160f,
0.92387950420379638672f,0.36561298370361328125f,0.93076694011688232422f,
0.34841868281364440918f,0.93733900785446166992f,0.33110630512237548828f,
0.94359344244003295898f,0.31368175148963928223f,0.94952815771102905273f,
0.29615089297294616699f,0.95514118671417236328f,0.27851969003677368164f,
0.96043050289154052734f,0.26079410314559936523f,0.96539443731307983398f,
0.24298018217086791992f,0.97003126144409179688f,0.22508391737937927246f,
0.97433936595916748047f,0.20711137354373931885f,0.97831737995147705078f,
0.18906866014003753662f,0.98196387290954589844f,0.17096188664436340332f,
0.98527765274047851562f,0.15279719233512878418f,0.98825758695602416992f,
0.13458070158958435059f,0.99090266227722167969f,0.11631862819194793701f,
0.99321192502975463867f,0.09801714122295379639f,0.99518471956253051758f,
0.07968243956565856934f,0.99682027101516723633f,0.06132073700428009033f,
0.99811810255050659180f,0.04293825849890708923f,0.99907773733139038086f,
0.02454122900962829590f,0.99969881772994995117f,0.00613588467240333557f,
0.99998116493225097656f,-0.01227153837680816650f,0.99992471933364868164f,
-0.03067480400204658508f,0.99952942132949829102f,-0.04906767606735229492f,
0.99879544973373413086f,-0.06744392216205596924f,0.99772304296493530273f,
-0.08579730987548828125f,0.99631261825561523438f,-0.10412163287401199341f,
0.99456459283828735352f,-0.12241067737340927124f,0.99247956275939941406f,
-0.14065824449062347412f,0.99005818367004394531f,-0.15885815024375915527f,
0.98730140924453735352f,-0.17700421810150146484f,0.98421007394790649414f,
-0.19509032368659973145f,0.98078525066375732422f,-0.21311031281948089600f,
0.97702813148498535156f,-0.23105810582637786865f,0.97293996810913085938f,
-0.24892760813236236572f,0.96852207183837890625f,-0.26671275496482849121f,
0.96377605199813842773f,-0.28440752625465393066f,0.95870345830917358398f,
-0.30200594663619995117f,0.95330601930618286133f,-0.31950202584266662598f,
0.94758558273315429688f,-0.33688986301422119141f,0.94154405593872070312f,
-0.35416352748870849609f,0.93518352508544921875f,-0.37131720781326293945f,
0.92850607633590698242f,-0.38834503293037414551f,0.92151403427124023438f,
-0.40524131059646606445f,0.91420978307723999023f,-0.42200025916099548340f,
0.90659570693969726562f,-0.43861624598503112793f,0.89867448806762695312f,
-0.45508357882499694824f,0.89044874906539916992f,-0.47139674425125122070f,
0.88192129135131835938f,-0.48755016922950744629f,0.87309497594833374023f,
-0.50353837013244628906f,0.86397284269332885742f,-0.51935601234436035156f,
0.85455799102783203125f,-0.53499764204025268555f,0.84485357999801635742f,
-0.55045795440673828125f,0.83486288785934448242f,-0.56573182344436645508f,
0.82458931207656860352f,-0.58081394433975219727f,0.81403630971908569336f,
-0.59569931030273437500f,0.80320751667022705078f,-0.61038279533386230469f,
0.79210656881332397461f,-0.62485951185226440430f,0.78073722124099731445f,
-0.63912445306777954102f,0.76910334825515747070f,-0.65317285060882568359f,
0.75720882415771484375f,-0.66699993610382080078f,0.74505776166915893555f,
-0.68060100078582763672f,0.73265427350997924805f,-0.69397145509719848633f,
0.72000253200531005859f,-0.70710676908493041992f,0.70710676908493041992f,
-0.72000253200531005859f,0.69397145509719848633f,-0.73265427350997924805f,
0.68060100078582763672f,-0.74505776166915893555f,0.66699993610382080078f,
-0.75720882415771484375f,0.65317285060882568359f,-0.76910334825515747070f,
0.63912445306777954102f,-0.78073722124099731445f,0.62485951185226440430f,
-0.79210656881332397461f,0.61038279533386230469f,-0.80320751667022705078f,
0.59569931030273437500f,-0.81403630971908569336f,0.58081394433975219727f,
-0.82458931207656860352f,0.56573182344436645508f,-0.83486288785934448242f,
0.55045795440673828125f,-0.84485357999801635742f,0.53499764204025268555f,
-0.85455799102783203125f,0.51935601234436035156f,-0.86397284269332885742f,
0.50353837013244628906f,-0.87309497594833374023f,0.48755016922950744629f,
-0.88192129135131835938f,0.47139674425125122070f,-0.89044874906539916992f,
0.45508357882499694824f,-0.89867448806762695312f,0.43861624598503112793f,
-0.90659570693969726562f,0.42200025916099548340f,-0.91420978307723999023f,
0.40524131059646606445f,-0.92151403427124023438f,0.38834503293037414551f,
-0.92850607633590698242f,0.37131720781326293945f,-0.93518352508544921875f,
0.35416352748870849609f,-0.94154405593872070312f,0.33688986301422119141f,
-0.94758558273315429688f,0.31950202584266662598f,-0.95330601930618286133f,
0.30200594663619995117f,-0.95870345830917358398f,0.28440752625465393066f,
-0.96377605199813842773f,0.26671275496482849121f,-0.96852207183837890625f,
0.24892760813236236572f,-0.97293996810913085938f,0.23105810582637786865f,
-0.97702813148498535156f,0.21311031281948089600f,-0.98078525066375732422f,
0.19509032368659973145f,-0.98421007394790649414f,0.17700421810150146484f,
-0.98730140924453735352f,0.15885815024375915527f,-0.99005818367004394531f,
0.14065824449062347412f,-0.99247956275939941406f,0.12241067737340927124f,
-0.99456459283828735352f,0.10412163287401199341f,-0.99631261825561523438f,
0.08579730987548828125f,-0.99772304296493530273f,0.06744392216205596924f,
-0.99879544973373413086f,0.04906767606735229492f,-0.99952942132949829102f,
0.03067480400204658508f,-0.99992471933364868164f,0.01227153837680816650f,
-0.99998116493225097656f,-0.00613588467240333557f,-0.99969881772994995117f,
-0.02454122900962829590f,-0.99907773733139038086f,-0.04293825849890708923f,
-0.99811810255050659180f,-0.06132073700428009033f,-0.99682027101516723633f,
-0.07968243956565856934f,-0.99518471956253051758f,-0.09801714122295379639f,
-0.99321192502975463867f,-0.11631862819194793701f,-0.99090266227722167969f,
-0.13458070158958435059f,-0.98825758695602416992f,-0.15279719233512878418f,
-0.98527765274047851562f,-0.17096188664436340332f,-0.98196387290954589844f,
-0.18906866014003753662f,-0.97831737995147705078f,-0.20711137354373931885f,
-0.97433936595916748047f,-0.22508391737937927246f,-0.97003126144409179688f,
-0.24298018217086791992f,-0.96539443731307983398f,-0.26079410314559936523f,
-0.96043050289154052734f,-0.27851969003677368164f,-0.95514118671417236328f,
-0.29615089297294616699f,-0.94952815771102905273f,-0.31368175148963928223f,
-0.94359344244003295898f,-0.33110630512237548828f,-0.93733900785446166992f,
-0.34841868281364440918f,-0.93076694011688232422f,-0.36561298370361328125f,
-0.92387950420379638672f,-0.38268342614173889160f,-0.91667908430099487305f,
-0.39962419867515563965f,-0.90916800498962402344f,-0.41642954945564270020f,
-0.90134882926940917969f,-0.43309381604194641113f,-0.89322429895401000977f,
-0.44961133599281311035f,-0.88479709625244140625f,-0.46597650647163391113f,
-0.87607008218765258789f,-0.48218378424644470215f,-0.86704623699188232422f,
-0.49822765588760375977f,-0.85772860050201416016f,-0.51410275697708129883f,
-0.84812033176422119141f,-0.52980363368988037109f,-0.83822470903396606445f,
-0.54532498121261596680f,-0.82804507017135620117f,-0.56066155433654785156f,
-0.81758481264114379883f,-0.57580816745758056641f,-0.80684757232666015625f,
-0.59075969457626342773f,-0.79583692550659179688f,-0.60551106929779052734f,
-0.78455656766891479492f,-0.62005722522735595703f,-0.77301043272018432617f,
-0.63439327478408813477f,-0.76120239496231079102f,-0.64851438999176025391f,
-0.74913638830184936523f,-0.66241580247879028320f,-0.73681658506393432617f,
-0.67609268426895141602f,-0.72424709796905517578f,-0.68954056501388549805f,
-0.71143221855163574219f,-0.70275473594665527344f,-0.69837623834609985352f,
-0.71573084592819213867f,-0.68508368730545043945f,-0.72846436500549316406f,
-0.67155897617340087891f,-0.74095112085342407227f,-0.65780669450759887695f,
-0.75318682193756103516f,-0.64383155107498168945f,-0.76516723632812500000f,
-0.62963825464248657227f,-0.77688848972320556641f,-0.61523157358169555664f,
-0.78834640979766845703f,-0.60061645507812500000f,-0.79953724145889282227f,
-0.58579784631729125977f,-0.81045717000961303711f,-0.57078075408935546875f,
-0.82110249996185302734f,-0.55557024478912353516f,-0.83146959543228149414f,
-0.54017144441604614258f,-0.84155499935150146484f,-0.52458965778350830078f,
-0.85135519504547119141f,-0.50883013010025024414f,-0.86086696386337280273f,
-0.49289819598197937012f,-0.87008696794509887695f,-0.47679921984672546387f,
-0.87901222705841064453f,-0.46053871512413024902f,-0.88763964176177978516f,
-0.44412213563919067383f,-0.89596623182296752930f,-0.42755508422851562500f,
-0.90398931503295898438f,-0.41084316372871398926f,-0.91170603036880493164f,
-0.39399203658103942871f,-0.91911387443542480469f,-0.37700742483139038086f,
-0.92621022462844848633f,-0.35989505052566528320f,-0.93299281597137451172f,
-0.34266072511672973633f,-0.93945920467376708984f,-0.32531028985977172852f,
-0.94560730457305908203f,-0.30784964561462402344f,-0.95143502950668334961f,
-0.29028466343879699707f,-0.95694035291671752930f,-0.27262136340141296387f,
-0.96212142705917358398f,-0.25486564636230468750f,-0.96697646379470825195f,
-0.23702360689640045166f,-0.97150391340255737305f,-0.21910123527050018311f,
-0.97570210695266723633f,-0.20110464096069335938f,-0.97956979274749755859f,
-0.18303988873958587646f,-0.98310548067092895508f,-0.16491311788558959961f,
-0.98630809783935546875f,-0.14673046767711639404f,-0.98917651176452636719f,
-0.12849810719490051270f,-0.99170976877212524414f,-0.11022220551967620850f,
-0.99390697479248046875f,-0.09190895408391952515f,-0.99576741456985473633f,
-0.07356456667184829712f,-0.99729043245315551758f,-0.05519524589180946350f,
-0.99847555160522460938f,-0.03680722415447235107f,-0.99932235479354858398f,
-0.01840673014521598816f,-0.99983060359954833984f,1.00000000000000000000f,
0.00000000000000000000f,0.99729043245315551758f,0.07356456667184829712f,
0.98917651176452636719f,0.14673046767711639404f,0.97570210695266723633f,
0.21910123527050018311f,0.95694035291671752930f,0.29028466343879699707f,
0.93299281597137451172f,0.35989505052566528320f,0.90398931503295898438f,
0.42755508422851562500f,0.87008696794509887695f,0.49289819598197937012f,
0.83146959543228149414f,0.55557024478912353516f,0.78834640979766845703f,
0.61523157358169555664f,0.74095112085342407227f,0.67155897617340087891f,
0.68954056501388549805f,0.72424709796905517578f,0.63439327478408813477f,
0.77301043272018432617f,0.57580816745758056641f,0.81758481264114379883f,
0.51410275697708129883f,0.85772860050201416016f,0.44961133599281311035f,
0.89322429895401000977f,0.38268342614173889160f,0.92387950420379638672f,
0.31368175148963928223f,0.94952815771102905273f,0.24298018217086791992f,
0.97003126144409179688f,0.17096188664436340332f,0.98527765274047851562f,
0.09801714122295379639f,0.99518471956253051758f,0.02454122900962829590f,
0.99969881772994995117f,-0.04906767606735229492f,0.99879544973373413086f,
-0.12241067737340927124f,0.99247956275939941406f,-0.19509032368659973145f,
0.98078525066375732422f,-0.26671275496482849121f,0.96377605199813842773f,
-0.33688986301422119141f,0.94154405593872070312f,-0.40524131059646606445f,
0.91420978307723999023f,-0.47139674425125122070f,0.88192129135131835938f,
-0.53499764204025268555f,0.84485357999801635742f,-0.59569931030273437500f,
0.80320751667022705078f,-0.65317285060882568359f,0.75720882415771484375f,
-0.70710676908493041992f,0.70710676908493041992f,-0.75720882415771484375f,
0.65317285060882568359f,-0.80320751667022705078f,0.59569931030273437500f,
-0.84485357999801635742f,0.53499764204025268555f,-0.88192129135131835938f,
0.47139674425125122070f,-0.91420978307723999023f,0.40524131059646606445f,
-0.94154405593872070312f,0.33688986301422119141f,-0.96377605199813842773f,
0.26671275496482849121f,-0.98078525066375732422f,0.19509032368659973145f,
-0.99247956275939941406f,0.12241067737340927124f,-0.99879544973373413086f,
0.04906767606735229492f,-0.99969881772994995117f,-0.02454122900962829590f,
-0.99518471956253051758f,-0.09801714122295379639f,-0.98527765274047851562f,
-0.17096188664436340332f,-0.97003126144409179688f,-0.24298018217086791992f,
-0.94952815771102905273f,-0.31368175148963928223f,-0.92387950420379638672f,
-0.38268342614173889160f,-0.89322429895401000977f,-0.44961133599281311035f,
-0.85772860050201416016f,-0.51410275697708129883f,-0.81758481264114379883f,
-0.57580816745758056641f,-0.77301043272018432617f,-0.63439327478408813477f,
-0.72424709796905517578f,-0.68954056501388549805f,-0.67155897617340087891f,
-0.74095112085342407227f,-0.61523157358169555664f,-0.78834640979766845703f,
-0.55557024478912353516f,-0.83146959543228149414f,-0.49289819598197937012f,
-0.87008696794509887695f,-0.42755508422851562500f,-0.90398931503295898438f,
-0.35989505052566528320f,-0.93299281597137451172f,-0.29028466343879699707f,
-0.95694035291671752930f,-0.21910123527050018311f,-0.97570210695266723633f,
-0.14673046767711639404f,-0.98917651176452636719f,-0.07356456667184829712f,
-0.99729043245315551758f,1.00000000000000000000f,0.00000000000000000000f,
0.95694035291671752930f,0.29028466343879699707f,0.83146959543228149414f,
0.55557024478912353516f,0.63439327478408813477f,0.77301043272018432617f,
0.38268342614173889160f,0.92387950420379638672f,0.09801714122295379639f,
0.99518471956253051758f,-0.19509032368659973145f,0.98078525066375732422f,
-0.47139674425125122070f,0.88192129135131835938f,-0.70710676908493041992f,
0.70710676908493041992f,-0.88192129135131835938f,0.47139674425125122070f,
-0.98078525066375732422f,0.19509032368659973145f,-0.99518471956253051758f,
-0.09801714122295379639f,-0.92387950420379638672f,-0.38268342614173889160f,
-0.77301043272018432617f,-0.63439327478408813477f,-0.55557024478912353516f,
-0.83146959543228149414f,-0.29028466343879699707f,-0.95694035291671752930f,
1.00000000000000000000f,0.00000000000000000000f,0.38268342614173889160f,
0.92387950420379638672f,-0.70710676908493041992f,0.70710676908493041992f,
-0.92387950420379638672f,-0.38268342614173889160f,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F32_4096) || defined(ARM_TABLE_TWIDDLECOEF_F32_8192)

uint32_t rearranged_twiddle_tab_stride1_arr_4096_f32[6]={
0,2048,2560,2688,2720,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_4096_f32[6]={
0,2048,2560,2688,2720,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_4096_f32[6]={
0,2048,2560,2688,2720,0,};

float32_t rearranged_twiddle_stride1_4096_f32[2728]={
1.00000000000000000000f,0.00000000000000000000f,0.99999880790710449219f,
0.00153398013208061457f,0.99999529123306274414f,0.00306795677170157433f,
0.99998939037322998047f,0.00460192607715725899f,0.99998116493225097656f,
0.00613588467240333557f,0.99997061491012573242f,0.00766982883214950562f,
0.99995762109756469727f,0.00920375436544418335f,0.99994236230850219727f,
0.01073765940964221954f,0.99992471933364868164f,0.01227153837680816650f,
0.99990469217300415039f,0.01380538847297430038f,0.99988234043121337891f,
0.01533920597285032272f,0.99985766410827636719f,0.01687298715114593506f,
0.99983060359954833984f,0.01840673014521598816f,0.99980115890502929688f,
0.01994042843580245972f,0.99976938962936401367f,0.02147408016026020050f,
0.99973529577255249023f,0.02300768159329891205f,0.99969881772994995117f,
0.02454122900962829590f,0.99966001510620117188f,0.02607471868395805359f,
0.99961882829666137695f,0.02760814502835273743f,0.99957531690597534180f,
0.02914150804281234741f,0.99952942132949829102f,0.03067480400204658508f,
0.99948120117187500000f,0.03220802545547485352f,0.99943059682846069336f,
0.03374117240309715271f,0.99937766790390014648f,0.03527423739433288574f,
0.99932235479354858398f,0.03680722415447235107f,0.99926477670669555664f,
0.03834012150764465332f,0.99920475482940673828f,0.03987292572855949402f,
0.99914240837097167969f,0.04140564054250717163f,0.99907773733139038086f,
0.04293825849890708923f,0.99901068210601806641f,0.04447077214717864990f,
0.99894130229949951172f,0.04600318148732185364f,0.99886953830718994141f,
0.04753548279404640198f,0.99879544973373413086f,0.04906767606735229492f,
0.99871903657913208008f,0.05059975013136863708f,0.99864023923873901367f,
0.05213170498609542847f,0.99855905771255493164f,0.05366353690624237061f,
0.99847555160522460938f,0.05519524589180946350f,0.99838972091674804688f,
0.05672682076692581177f,0.99830156564712524414f,0.05825826525688171387f,
0.99821102619171142578f,0.05978957191109657288f,0.99811810255050659180f,
0.06132073700428009033f,0.99802285432815551758f,0.06285175681114196777f,
0.99792528152465820312f,0.06438262760639190674f,0.99782532453536987305f,
0.06591334939002990723f,0.99772304296493530273f,0.06744392216205596924f,
0.99761843681335449219f,0.06897433102130889893f,0.99751144647598266602f,
0.07050457596778869629f,0.99740213155746459961f,0.07203464955091476440f,
0.99729043245315551758f,0.07356456667184829712f,0.99717640876770019531f,
0.07509429752826690674f,0.99706006050109863281f,0.07662386447191238403f,
0.99694132804870605469f,0.07815324515104293823f,0.99682027101516723633f,
0.07968243956565856934f,0.99669688940048217773f,0.08121144771575927734f,
0.99657112360000610352f,0.08274026215076446533f,0.99644303321838378906f,
0.08426889032125473022f,0.99631261825561523438f,0.08579730987548828125f,
0.99617981910705566406f,0.08732553571462631226f,0.99604469537734985352f,
0.08885355293750762939f,0.99590724706649780273f,0.09038136154413223267f,
0.99576741456985473633f,0.09190895408391952515f,0.99562525749206542969f,
0.09343633800745010376f,0.99548077583312988281f,0.09496349841356277466f,
0.99533390998840332031f,0.09649042785167694092f,0.99518471956253051758f,
0.09801714122295379639f,0.99503320455551147461f,0.09954361617565155029f,
0.99487930536270141602f,0.10106986016035079956f,0.99472314119338989258f,
0.10259586572647094727f,0.99456459283828735352f,0.10412163287401199341f,
0.99440366029739379883f,0.10564715415239334106f,0.99424046277999877930f,
0.10717242211103439331f,0.99407488107681274414f,0.10869744420051574707f,
0.99390697479248046875f,0.11022220551967620850f,0.99373674392700195312f,
0.11174671351909637451f,0.99356412887573242188f,0.11327095329761505127f,
0.99338918924331665039f,0.11479492485523223877f,0.99321192502975463867f,
0.11631862819194793701f,0.99303233623504638672f,0.11784206330776214600f,
0.99285042285919189453f,0.11936521530151367188f,0.99266612529754638672f,
0.12088808417320251465f,0.99247956275939941406f,0.12241067737340927124f,
0.99229061603546142578f,0.12393297255039215088f,0.99209928512573242188f,
0.12545497715473175049f,0.99190568923950195312f,0.12697669863700866699f,
0.99170976877212524414f,0.12849810719490051270f,0.99151146411895751953f,
0.13001921772956848145f,0.99131083488464355469f,0.13154003024101257324f,
0.99110794067382812500f,0.13306052982807159424f,0.99090266227722167969f,
0.13458070158958435059f,0.99069499969482421875f,0.13610057532787322998f,
0.99048507213592529297f,0.13762012124061584473f,0.99027281999588012695f,
0.13913933932781219482f,0.99005818367004394531f,0.14065824449062347412f,
0.98984128236770629883f,0.14217680692672729492f,0.98962199687957763672f,
0.14369502663612365723f,0.98940044641494750977f,0.14521291851997375488f,
0.98917651176452636719f,0.14673046767711639404f,0.98895025253295898438f,
0.14824767410755157471f,0.98872166872024536133f,0.14976453781127929688f,
0.98849081993103027344f,0.15128104388713836670f,0.98825758695602416992f,
0.15279719233512878418f,0.98802202939987182617f,0.15431296825408935547f,
0.98778414726257324219f,0.15582840144634246826f,0.98754394054412841797f,
0.15734346210956573486f,0.98730140924453735352f,0.15885815024375915527f,
0.98705655336380004883f,0.16037245094776153564f,0.98680937290191650391f,
0.16188639402389526367f,0.98655992746353149414f,0.16339994966983795166f,
0.98630809783935546875f,0.16491311788558959961f,0.98605394363403320312f,
0.16642589867115020752f,0.98579752445220947266f,0.16793829202651977539f,
0.98553872108459472656f,0.16945029795169830322f,0.98527765274047851562f,
0.17096188664436340332f,0.98501425981521606445f,0.17247308790683746338f,
0.98474848270416259766f,0.17398387193679809570f,0.98448044061660766602f,
0.17549425363540649414f,0.98421007394790649414f,0.17700421810150146484f,
0.98393744230270385742f,0.17851376533508300781f,0.98366242647171020508f,
0.18002289533615112305f,0.98338508605957031250f,0.18153160810470581055f,
0.98310548067092895508f,0.18303988873958587646f,0.98282355070114135742f,
0.18454773724079132080f,0.98253929615020751953f,0.18605515360832214355f,
0.98225271701812744141f,0.18756212294101715088f,0.98196387290954589844f,
0.18906866014003753662f,0.98167270421981811523f,0.19057475030422210693f,
0.98137921094894409180f,0.19208039343357086182f,0.98108339309692382812f,
0.19358558952808380127f,0.98078525066375732422f,0.19509032368659973145f,
0.98048484325408935547f,0.19659459590911865234f,0.98018211126327514648f,
0.19809840619564056396f,0.97987711429595947266f,0.19960175454616546631f,
0.97956979274749755859f,0.20110464096069335938f,0.97926014661788940430f,
0.20260703563690185547f,0.97894817590713500977f,0.20410896837711334229f,
0.97863394021987915039f,0.20561040937900543213f,0.97831737995147705078f,
0.20711137354373931885f,0.97799849510192871094f,0.20861184597015380859f,
0.97767734527587890625f,0.21011184155941009521f,0.97735387086868286133f,
0.21161133050918579102f,0.97702813148498535156f,0.21311031281948089600f,
0.97670006752014160156f,0.21460881829261779785f,0.97636973857879638672f,
0.21610680222511291504f,0.97603708505630493164f,0.21760427951812744141f,
0.97570210695266723633f,0.21910123527050018311f,0.97536486387252807617f,
0.22059768438339233398f,0.97502535581588745117f,0.22209362685680389404f,
0.97468352317810058594f,0.22358903288841247559f,0.97433936595916748047f,
0.22508391737937927246f,0.97399294376373291016f,0.22657826542854309082f,
0.97364425659179687500f,0.22807207703590393066f,0.97329324483871459961f,
0.22956536710262298584f,0.97293996810913085938f,0.23105810582637786865f,
0.97258436679840087891f,0.23255030810832977295f,0.97222650051116943359f,
0.23404195904731750488f,0.97186630964279174805f,0.23553305864334106445f,
0.97150391340255737305f,0.23702360689640045166f,0.97113913297653198242f,
0.23851358890533447266f,0.97077214717864990234f,0.24000301957130432129f,
0.97040283679962158203f,0.24149188399314880371f,0.97003126144409179688f,
0.24298018217086791992f,0.96965736150741577148f,0.24446789920330047607f,
0.96928125619888305664f,0.24595504999160766602f,0.96890282630920410156f,
0.24744161963462829590f,0.96852207183837890625f,0.24892760813236236572f,
0.96813911199569702148f,0.25041300058364868164f,0.96775382757186889648f,
0.25189781188964843750f,0.96736627817153930664f,0.25338202714920043945f,
0.96697646379470825195f,0.25486564636230468750f,0.96658438444137573242f,
0.25634866952896118164f,0.96618998050689697266f,0.25783109664916992188f,
0.96579337120056152344f,0.25931292772293090820f,0.96539443731307983398f,
0.26079410314559936523f,0.96499323844909667969f,0.26227471232414245605f,
0.96458977460861206055f,0.26375466585159301758f,0.96418404579162597656f,
0.26523402333259582520f,0.96377605199813842773f,0.26671275496482849121f,
0.96336579322814941406f,0.26819086074829101562f,0.96295326948165893555f,
0.26966831088066101074f,0.96253848075866699219f,0.27114516496658325195f,
0.96212142705917358398f,0.27262136340141296387f,0.96170204877853393555f,
0.27409690618515014648f,0.96128046512603759766f,0.27557182312011718750f,
0.96085661649703979492f,0.27704608440399169922f,0.96043050289154052734f,
0.27851969003677368164f,0.96000212430953979492f,0.27999264001846313477f,
0.95957154035568237305f,0.28146493434906005859f,0.95913863182067871094f,
0.28293657302856445312f,0.95870345830917358398f,0.28440752625465393066f,
0.95826607942581176758f,0.28587782382965087891f,0.95782643556594848633f,
0.28734746575355529785f,0.95738452672958374023f,0.28881642222404479980f,
0.95694035291671752930f,0.29028466343879699707f,0.95649391412734985352f,
0.29175224900245666504f,0.95604526996612548828f,0.29321914911270141602f,
0.95559436082839965820f,0.29468536376953125000f,0.95514118671417236328f,
0.29615089297294616699f,0.95468574762344360352f,0.29761570692062377930f,
0.95422810316085815430f,0.29907983541488647461f,0.95376819372177124023f,
0.30054324865341186523f,0.95330601930618286133f,0.30200594663619995117f,
0.95284163951873779297f,0.30346795916557312012f,0.95237499475479125977f,
0.30492922663688659668f,0.95190614461898803711f,0.30638980865478515625f,
0.95143502950668334961f,0.30784964561462402344f,0.95096164941787719727f,
0.30930876731872558594f,0.95048606395721435547f,0.31076714396476745605f,
0.95000827312469482422f,0.31222480535507202148f,0.94952815771102905273f,
0.31368175148963928223f,0.94904589653015136719f,0.31513792276382446289f,
0.94856137037277221680f,0.31659337878227233887f,0.94807457923889160156f,
0.31804808974266052246f,0.94758558273315429688f,0.31950202584266662598f,
0.94709438085556030273f,0.32095524668693542480f,0.94660091400146484375f,
0.32240769267082214355f,0.94610524177551269531f,0.32385936379432678223f,
0.94560730457305908203f,0.32531028985977172852f,0.94510722160339355469f,
0.32676044106483459473f,0.94460481405258178711f,0.32820984721183776855f,
0.94410026073455810547f,0.32965844869613647461f,0.94359344244003295898f,
0.33110630512237548828f,0.94308441877365112305f,0.33255335688591003418f,
0.94257318973541259766f,0.33399966359138488770f,0.94205975532531738281f,
0.33544513583183288574f,0.94154405593872070312f,0.33688986301422119141f,
0.94102615118026733398f,0.33833375573158264160f,0.94050604104995727539f,
0.33977687358856201172f,0.93998372554779052734f,0.34121921658515930176f,
0.93945920467376708984f,0.34266072511672973633f,0.93893247842788696289f,
0.34410142898559570312f,0.93840354681015014648f,0.34554132819175720215f,
0.93787235021591186523f,0.34698042273521423340f,0.93733900785446166992f,
0.34841868281364440918f,0.93680346012115478516f,0.34985613822937011719f,
0.93626564741134643555f,0.35129275918006896973f,0.93572568893432617188f,
0.35272854566574096680f,0.93518352508544921875f,0.35416352748870849609f,
0.93463915586471557617f,0.35559767484664916992f,0.93409252166748046875f,
0.35703095793724060059f,0.93354380130767822266f,0.35846340656280517578f,
0.93299281597137451172f,0.35989505052566528320f,0.93243962526321411133f,
0.36132580041885375977f,0.93188428878784179688f,0.36275571584701538086f,
0.93132668733596801758f,0.36418479681015014648f,0.93076694011688232422f,
0.36561298370361328125f,0.93020504713058471680f,0.36704033613204956055f,
0.92964088916778564453f,0.36846682429313659668f,0.92907458543777465820f,
0.36989244818687438965f,0.92850607633590698242f,0.37131720781326293945f,
0.92793542146682739258f,0.37274107336997985840f,0.92736250162124633789f,
0.37416407465934753418f,0.92678749561309814453f,0.37558618187904357910f,
0.92621022462844848633f,0.37700742483139038086f,0.92563080787658691406f,
0.37842774391174316406f,0.92504924535751342773f,0.37984719872474670410f,
0.92446547746658325195f,0.38126575946807861328f,0.92387950420379638672f,
0.38268342614173889160f,0.92329144477844238281f,0.38410019874572753906f,
0.92270112037658691406f,0.38551604747772216797f,0.92210865020751953125f,
0.38693100214004516602f,0.92151403427124023438f,0.38834503293037414551f,
0.92091721296310424805f,0.38975816965103149414f,0.92031830549240112305f,
0.39117038249969482422f,0.91971713304519653320f,0.39258167147636413574f,
0.91911387443542480469f,0.39399203658103942871f,0.91850841045379638672f,
0.39540147781372070312f,0.91790080070495605469f,0.39680999517440795898f,
0.91729098558425903320f,0.39821755886077880859f,0.91667908430099487305f,
0.39962419867515563965f,0.91606497764587402344f,0.40102988481521606445f,
0.91544872522354125977f,0.40243464708328247070f,0.91483032703399658203f,
0.40383845567703247070f,0.91420978307723999023f,0.40524131059646606445f,
0.91358703374862670898f,0.40664321184158325195f,0.91296219825744628906f,
0.40804415941238403320f,0.91233515739440917969f,0.40944415330886840820f,
0.91170603036880493164f,0.41084316372871398926f,0.91107475757598876953f,
0.41224122047424316406f,0.91044127941131591797f,0.41363832354545593262f,
0.90980571508407592773f,0.41503441333770751953f,0.90916800498962402344f,
0.41642954945564270020f,0.90852808952331542969f,0.41782370209693908691f,
0.90788608789443969727f,0.41921690106391906738f,0.90724200010299682617f,
0.42060908675193786621f,0.90659570693969726562f,0.42200025916099548340f,
0.90594726800918579102f,0.42339047789573669434f,0.90529674291610717773f,
0.42477968335151672363f,0.90464407205581665039f,0.42616787552833557129f,
0.90398931503295898438f,0.42755508422851562500f,0.90333235263824462891f,
0.42894127964973449707f,0.90267330408096313477f,0.43032649159431457520f,
0.90201216936111450195f,0.43171066045761108398f,0.90134882926940917969f,
0.43309381604194641113f,0.90068340301513671875f,0.43447595834732055664f,
0.90001589059829711914f,0.43585708737373352051f,0.89934623241424560547f,
0.43723717331886291504f,0.89867448806762695312f,0.43861624598503112793f,
0.89800059795379638672f,0.43999427556991577148f,0.89732456207275390625f,
0.44137126207351684570f,0.89664649963378906250f,0.44274723529815673828f,
0.89596623182296752930f,0.44412213563919067383f,0.89528393745422363281f,
0.44549602270126342773f,0.89459949731826782227f,0.44686883687973022461f,
0.89391297101974487305f,0.44824060797691345215f,0.89322429895401000977f,
0.44961133599281311035f,0.89253354072570800781f,0.45098099112510681152f,
0.89184069633483886719f,0.45234957337379455566f,0.89114576578140258789f,
0.45371711254119873047f,0.89044874906539916992f,0.45508357882499694824f,
0.88974958658218383789f,0.45644897222518920898f,0.88904833793640136719f,
0.45781329274177551270f,0.88834506273269653320f,0.45917654037475585938f,
0.88763964176177978516f,0.46053871512413024902f,0.88693213462829589844f,
0.46189978718757629395f,0.88622254133224487305f,0.46325978636741638184f,
0.88551086187362670898f,0.46461868286132812500f,0.88479709625244140625f,
0.46597650647163391113f,0.88408124446868896484f,0.46733319759368896484f,
0.88336336612701416016f,0.46868881583213806152f,0.88264334201812744141f,
0.47004333138465881348f,0.88192129135131835938f,0.47139674425125122070f,
0.88119709491729736328f,0.47274902462959289551f,0.88047087192535400391f,
0.47410020232200622559f,0.87974262237548828125f,0.47545027732849121094f,
0.87901222705841064453f,0.47679921984672546387f,0.87827980518341064453f,
0.47814705967903137207f,0.87754529714584350586f,0.47949376702308654785f,
0.87680870294570922852f,0.48083934187889099121f,0.87607008218765258789f,
0.48218378424644470215f,0.87532937526702880859f,0.48352706432342529297f,
0.87458664178848266602f,0.48486924171447753906f,0.87384182214736938477f,
0.48621028661727905273f,0.87309497594833374023f,0.48755016922950744629f,
0.87234604358673095703f,0.48888888955116271973f,0.87159508466720581055f,
0.49022647738456726074f,0.87084203958511352539f,0.49156290292739868164f,
0.87008696794509887695f,0.49289819598197937012f,0.86932986974716186523f,
0.49423229694366455078f,0.86857068538665771484f,0.49556526541709899902f,
0.86780947446823120117f,0.49689704179763793945f,0.86704623699188232422f,
0.49822765588760375977f,0.86628097295761108398f,0.49955710768699645996f,
0.86551362276077270508f,0.50088536739349365234f,0.86474424600601196289f,
0.50221246480941772461f,0.86397284269332885742f,0.50353837013244628906f,
0.86319941282272338867f,0.50486308336257934570f,0.86242395639419555664f,
0.50618666410446166992f,0.86164647340774536133f,0.50750899314880371094f,
0.86086696386337280273f,0.50883013010025024414f,0.86008536815643310547f,
0.51015007495880126953f,0.85930180549621582031f,0.51146882772445678711f,
0.85851621627807617188f,0.51278638839721679688f,0.85772860050201416016f,
0.51410275697708129883f,0.85693895816802978516f,0.51541787385940551758f,
0.85614734888076782227f,0.51673179864883422852f,0.85535365343093872070f,
0.51804453134536743164f,0.85455799102783203125f,0.51935601234436035156f,
0.85376030206680297852f,0.52066624164581298828f,0.85296058654785156250f,
0.52197527885437011719f,0.85215890407562255859f,0.52328312397003173828f,
0.85135519504547119141f,0.52458965778350830078f,0.85054945945739746094f,
0.52589499950408935547f,0.84974175691604614258f,0.52719914913177490234f,
0.84893202781677246094f,0.52850198745727539062f,0.84812033176422119141f,
0.52980363368988037109f,0.84730660915374755859f,0.53110402822494506836f,
0.84649091958999633789f,0.53240311145782470703f,0.84567326307296752930f,
0.53370100259780883789f,0.84485357999801635742f,0.53499764204025268555f,
0.84403187036514282227f,0.53629297018051147461f,0.84320825338363647461f,
0.53758704662322998047f,0.84238260984420776367f,0.53887993097305297852f,
0.84155499935150146484f,0.54017144441604614258f,0.84072536230087280273f,
0.54146176576614379883f,0.83989381790161132812f,0.54275077581405639648f,
0.83906024694442749023f,0.54403853416442871094f,0.83822470903396606445f,
0.54532498121261596680f,0.83738720417022705078f,0.54661017656326293945f,
0.83654773235321044922f,0.54789406061172485352f,0.83570629358291625977f,
0.54917663335800170898f,0.83486288785934448242f,0.55045795440673828125f,
0.83401751518249511719f,0.55173796415328979492f,0.83317017555236816406f,
0.55301672220230102539f,0.83232086896896362305f,0.55429410934448242188f,
0.83146959543228149414f,0.55557024478912353516f,0.83061641454696655273f,
0.55684500932693481445f,0.82976120710372924805f,0.55811852216720581055f,
0.82890409231185913086f,0.55939072370529174805f,0.82804507017135620117f,
0.56066155433654785156f,0.82718402147293090820f,0.56193113327026367188f,
0.82632106542587280273f,0.56319934129714965820f,0.82545614242553710938f,
0.56446623802185058594f,0.82458931207656860352f,0.56573182344436645508f,
0.82372051477432250977f,0.56699603796005249023f,0.82284981012344360352f,
0.56825894117355346680f,0.82197713851928710938f,0.56952053308486938477f,
0.82110249996185302734f,0.57078075408935546875f,0.82022595405578613281f,
0.57203960418701171875f,0.81934750080108642578f,0.57329714298248291016f,
0.81846714019775390625f,0.57455337047576904297f,0.81758481264114379883f,
0.57580816745758056641f,0.81670057773590087891f,0.57706165313720703125f,
0.81581443548202514648f,0.57831376791000366211f,0.81492632627487182617f,
0.57956457138061523438f,0.81403630971908569336f,0.58081394433975219727f,
0.81314438581466674805f,0.58206200599670410156f,0.81225061416625976562f,
0.58330863714218139648f,0.81135487556457519531f,0.58455395698547363281f,
0.81045717000961303711f,0.58579784631729125977f,0.80955761671066284180f,
0.58704036474227905273f,0.80865615606307983398f,0.58828157186508178711f,
0.80775284767150878906f,0.58952128887176513672f,0.80684757232666015625f,
0.59075969457626342773f,0.80594038963317871094f,0.59199666976928710938f,
0.80503135919570922852f,0.59323227405548095703f,0.80412036180496215820f,
0.59446650743484497070f,0.80320751667022705078f,0.59569931030273437500f,
0.80229282379150390625f,0.59693068265914916992f,0.80137616395950317383f,
0.59816068410873413086f,0.80045765638351440430f,0.59938931465148925781f,
0.79953724145889282227f,0.60061645507812500000f,0.79861497879028320312f,
0.60184222459793090820f,0.79769086837768554688f,0.60306662321090698242f,
0.79676479101181030273f,0.60428953170776367188f,0.79583692550659179688f,
0.60551106929779052734f,0.79490715265274047852f,0.60673111677169799805f,
0.79397547245025634766f,0.60794979333877563477f,0.79304194450378417969f,
0.60916703939437866211f,0.79210656881332397461f,0.61038279533386230469f,
0.79116934537887573242f,0.61159718036651611328f,0.79023021459579467773f,
0.61281007528305053711f,0.78928923606872558594f,0.61402153968811035156f,
0.78834640979766845703f,0.61523157358169555664f,0.78740173578262329102f,
0.61644017696380615234f,0.78645521402359008789f,0.61764729022979736328f,
0.78550684452056884766f,0.61885297298431396484f,0.78455656766891479492f,
0.62005722522735595703f,0.78360450267791748047f,0.62125998735427856445f,
0.78265058994293212891f,0.62246125936508178711f,0.78169482946395874023f,
0.62366110086441040039f,0.78073722124099731445f,0.62485951185226440430f,
0.77977776527404785156f,0.62605637311935424805f,0.77881652116775512695f,
0.62725180387496948242f,0.77785342931747436523f,0.62844574451446533203f,
0.77688848972320556641f,0.62963825464248657227f,0.77592170238494873047f,
0.63082921504974365234f,0.77495312690734863281f,0.63201874494552612305f,
0.77398270368576049805f,0.63320678472518920898f,0.77301043272018432617f,
0.63439327478408813477f,0.77203637361526489258f,0.63557833433151245117f,
0.77106052637100219727f,0.63676184415817260742f,0.77008283138275146484f,
0.63794392347335815430f,0.76910334825515747070f,0.63912445306777954102f,
0.76812201738357543945f,0.64030349254608154297f,0.76713889837265014648f,
0.64148104190826416016f,0.76615399122238159180f,0.64265704154968261719f,
0.76516723632812500000f,0.64383155107498168945f,0.76417875289916992188f,
0.64500451087951660156f,0.76318842172622680664f,0.64617604017257690430f,
0.76219630241394042969f,0.64734596014022827148f,0.76120239496231079102f,
0.64851438999176025391f,0.76020669937133789062f,0.64968132972717285156f,
0.75920921564102172852f,0.65084666013717651367f,0.75820988416671752930f,
0.65201056003570556641f,0.75720882415771484375f,0.65317285060882568359f,
0.75620597600936889648f,0.65433359146118164062f,0.75520139932632446289f,
0.65549284219741821289f,0.75419497489929199219f,0.65665054321289062500f,
0.75318682193756103516f,0.65780669450759887695f,0.75217682123184204102f,
0.65896129608154296875f,0.75116515159606933594f,0.66011434793472290039f,
0.75015163421630859375f,0.66126585006713867188f,0.74913638830184936523f,
0.66241580247879028320f,0.74811935424804687500f,0.66356414556503295898f,
0.74710059165954589844f,0.66471099853515625000f,0.74608010053634643555f,
0.66585624217987060547f,0.74505776166915893555f,0.66699993610382080078f,
0.74403375387191772461f,0.66814202070236206055f,0.74300795793533325195f,
0.66928261518478393555f,0.74198043346405029297f,0.67042154073715209961f,
0.74095112085342407227f,0.67155897617340087891f,0.73992007970809936523f,
0.67269474267959594727f,0.73888731002807617188f,0.67382901906967163086f,
0.73785281181335449219f,0.67496162652969360352f,0.73681658506393432617f,
0.67609268426895141602f,0.73577857017517089844f,0.67722219228744506836f,
0.73473888635635375977f,0.67835003137588500977f,0.73369741439819335938f,
0.67947632074356079102f,0.73265427350997924805f,0.68060100078582763672f,
0.73160940408706665039f,0.68172407150268554688f,0.73056274652481079102f,
0.68284553289413452148f,0.72951442003250122070f,0.68396538496017456055f,
0.72846436500549316406f,0.68508368730545043945f,0.72741264104843139648f,
0.68620032072067260742f,0.72635912895202636719f,0.68731534481048583984f,
0.72530394792556762695f,0.68842875957489013672f,0.72424709796905517578f,
0.68954056501388549805f,0.72318845987319946289f,0.69065070152282714844f,
0.72212821245193481445f,0.69175922870635986328f,0.72106617689132690430f,
0.69286614656448364258f,0.72000253200531005859f,0.69397145509719848633f,
0.71893709897994995117f,0.69507509469985961914f,0.71787005662918090820f,
0.69617712497711181641f,0.71680128574371337891f,0.69727748632431030273f,
0.71573084592819213867f,0.69837623834609985352f,0.71465867757797241211f,
0.69947332143783569336f,0.71358484029769897461f,0.70056879520416259766f,
0.71250939369201660156f,0.70166260004043579102f,0.71143221855163574219f,
0.70275473594665527344f,0.71035337448120117188f,0.70384526252746582031f,
0.70927280187606811523f,0.70493406057357788086f,0.70819061994552612305f,
0.70602124929428100586f,0.70710676908493041992f,0.70710676908493041992f,
0.70602124929428100586f,0.70819061994552612305f,0.70493406057357788086f,
0.70927280187606811523f,0.70384526252746582031f,0.71035337448120117188f,
0.70275473594665527344f,0.71143221855163574219f,0.70166260004043579102f,
0.71250939369201660156f,0.70056879520416259766f,0.71358484029769897461f,
0.69947332143783569336f,0.71465867757797241211f,0.69837623834609985352f,
0.71573084592819213867f,0.69727748632431030273f,0.71680128574371337891f,
0.69617712497711181641f,0.71787005662918090820f,0.69507509469985961914f,
0.71893709897994995117f,0.69397145509719848633f,0.72000253200531005859f,
0.69286614656448364258f,0.72106617689132690430f,0.69175922870635986328f,
0.72212821245193481445f,0.69065070152282714844f,0.72318845987319946289f,
0.68954056501388549805f,0.72424709796905517578f,0.68842875957489013672f,
0.72530394792556762695f,0.68731534481048583984f,0.72635912895202636719f,
0.68620032072067260742f,0.72741264104843139648f,0.68508368730545043945f,
0.72846436500549316406f,0.68396538496017456055f,0.72951442003250122070f,
0.68284553289413452148f,0.73056274652481079102f,0.68172407150268554688f,
0.73160940408706665039f,0.68060100078582763672f,0.73265427350997924805f,
0.67947632074356079102f,0.73369741439819335938f,0.67835003137588500977f,
0.73473888635635375977f,0.67722219228744506836f,0.73577857017517089844f,
0.67609268426895141602f,0.73681658506393432617f,0.67496162652969360352f,
0.73785281181335449219f,0.67382901906967163086f,0.73888731002807617188f,
0.67269474267959594727f,0.73992007970809936523f,0.67155897617340087891f,
0.74095112085342407227f,0.67042154073715209961f,0.74198043346405029297f,
0.66928261518478393555f,0.74300795793533325195f,0.66814202070236206055f,
0.74403375387191772461f,0.66699993610382080078f,0.74505776166915893555f,
0.66585624217987060547f,0.74608010053634643555f,0.66471099853515625000f,
0.74710059165954589844f,0.66356414556503295898f,0.74811935424804687500f,
0.66241580247879028320f,0.74913638830184936523f,0.66126585006713867188f,
0.75015163421630859375f,0.66011434793472290039f,0.75116515159606933594f,
0.65896129608154296875f,0.75217682123184204102f,0.65780669450759887695f,
0.75318682193756103516f,0.65665054321289062500f,0.75419497489929199219f,
0.65549284219741821289f,0.75520139932632446289f,0.65433359146118164062f,
0.75620597600936889648f,0.65317285060882568359f,0.75720882415771484375f,
0.65201056003570556641f,0.75820988416671752930f,0.65084666013717651367f,
0.75920921564102172852f,0.64968132972717285156f,0.76020669937133789062f,
0.64851438999176025391f,0.76120239496231079102f,0.64734596014022827148f,
0.76219630241394042969f,0.64617604017257690430f,0.76318842172622680664f,
0.64500451087951660156f,0.76417875289916992188f,0.64383155107498168945f,
0.76516723632812500000f,0.64265704154968261719f,0.76615399122238159180f,
0.64148104190826416016f,0.76713889837265014648f,0.64030349254608154297f,
0.76812201738357543945f,0.63912445306777954102f,0.76910334825515747070f,
0.63794392347335815430f,0.77008283138275146484f,0.63676184415817260742f,
0.77106052637100219727f,0.63557833433151245117f,0.77203637361526489258f,
0.63439327478408813477f,0.77301043272018432617f,0.63320678472518920898f,
0.77398270368576049805f,0.63201874494552612305f,0.77495312690734863281f,
0.63082921504974365234f,0.77592170238494873047f,0.62963825464248657227f,
0.77688848972320556641f,0.62844574451446533203f,0.77785342931747436523f,
0.62725180387496948242f,0.77881652116775512695f,0.62605637311935424805f,
0.77977776527404785156f,0.62485951185226440430f,0.78073722124099731445f,
0.62366110086441040039f,0.78169482946395874023f,0.62246125936508178711f,
0.78265058994293212891f,0.62125998735427856445f,0.78360450267791748047f,
0.62005722522735595703f,0.78455656766891479492f,0.61885297298431396484f,
0.78550684452056884766f,0.61764729022979736328f,0.78645521402359008789f,
0.61644017696380615234f,0.78740173578262329102f,0.61523157358169555664f,
0.78834640979766845703f,0.61402153968811035156f,0.78928923606872558594f,
0.61281007528305053711f,0.79023021459579467773f,0.61159718036651611328f,
0.79116934537887573242f,0.61038279533386230469f,0.79210656881332397461f,
0.60916703939437866211f,0.79304194450378417969f,0.60794979333877563477f,
0.79397547245025634766f,0.60673111677169799805f,0.79490715265274047852f,
0.60551106929779052734f,0.79583692550659179688f,0.60428953170776367188f,
0.79676479101181030273f,0.60306662321090698242f,0.79769086837768554688f,
0.60184222459793090820f,0.79861497879028320312f,0.60061645507812500000f,
0.79953724145889282227f,0.59938931465148925781f,0.80045765638351440430f,
0.59816068410873413086f,0.80137616395950317383f,0.59693068265914916992f,
0.80229282379150390625f,0.59569931030273437500f,0.80320751667022705078f,
0.59446650743484497070f,0.80412036180496215820f,0.59323227405548095703f,
0.80503135919570922852f,0.59199666976928710938f,0.80594038963317871094f,
0.59075969457626342773f,0.80684757232666015625f,0.58952128887176513672f,
0.80775284767150878906f,0.58828157186508178711f,0.80865615606307983398f,
0.58704036474227905273f,0.80955761671066284180f,0.58579784631729125977f,
0.81045717000961303711f,0.58455395698547363281f,0.81135487556457519531f,
0.58330863714218139648f,0.81225061416625976562f,0.58206200599670410156f,
0.81314438581466674805f,0.58081394433975219727f,0.81403630971908569336f,
0.57956457138061523438f,0.81492632627487182617f,0.57831376791000366211f,
0.81581443548202514648f,0.57706165313720703125f,0.81670057773590087891f,
0.57580816745758056641f,0.81758481264114379883f,0.57455337047576904297f,
0.81846714019775390625f,0.57329714298248291016f,0.81934750080108642578f,
0.57203960418701171875f,0.82022595405578613281f,0.57078075408935546875f,
0.82110249996185302734f,0.56952053308486938477f,0.82197713851928710938f,
0.56825894117355346680f,0.82284981012344360352f,0.56699603796005249023f,
0.82372051477432250977f,0.56573182344436645508f,0.82458931207656860352f,
0.56446623802185058594f,0.82545614242553710938f,0.56319934129714965820f,
0.82632106542587280273f,0.56193113327026367188f,0.82718402147293090820f,
0.56066155433654785156f,0.82804507017135620117f,0.55939072370529174805f,
0.82890409231185913086f,0.55811852216720581055f,0.82976120710372924805f,
0.55684500932693481445f,0.83061641454696655273f,0.55557024478912353516f,
0.83146959543228149414f,0.55429410934448242188f,0.83232086896896362305f,
0.55301672220230102539f,0.83317017555236816406f,0.55173796415328979492f,
0.83401751518249511719f,0.55045795440673828125f,0.83486288785934448242f,
0.54917663335800170898f,0.83570629358291625977f,0.54789406061172485352f,
0.83654773235321044922f,0.54661017656326293945f,0.83738720417022705078f,
0.54532498121261596680f,0.83822470903396606445f,0.54403853416442871094f,
0.83906024694442749023f,0.54275077581405639648f,0.83989381790161132812f,
0.54146176576614379883f,0.84072536230087280273f,0.54017144441604614258f,
0.84155499935150146484f,0.53887993097305297852f,0.84238260984420776367f,
0.53758704662322998047f,0.84320825338363647461f,0.53629297018051147461f,
0.84403187036514282227f,0.53499764204025268555f,0.84485357999801635742f,
0.53370100259780883789f,0.84567326307296752930f,0.53240311145782470703f,
0.84649091958999633789f,0.53110402822494506836f,0.84730660915374755859f,
0.52980363368988037109f,0.84812033176422119141f,0.52850198745727539062f,
0.84893202781677246094f,0.52719914913177490234f,0.84974175691604614258f,
0.52589499950408935547f,0.85054945945739746094f,0.52458965778350830078f,
0.85135519504547119141f,0.52328312397003173828f,0.85215890407562255859f,
0.52197527885437011719f,0.85296058654785156250f,0.52066624164581298828f,
0.85376030206680297852f,0.51935601234436035156f,0.85455799102783203125f,
0.51804453134536743164f,0.85535365343093872070f,0.51673179864883422852f,
0.85614734888076782227f,0.51541787385940551758f,0.85693895816802978516f,
0.51410275697708129883f,0.85772860050201416016f,0.51278638839721679688f,
0.85851621627807617188f,0.51146882772445678711f,0.85930180549621582031f,
0.51015007495880126953f,0.86008536815643310547f,0.50883013010025024414f,
0.86086696386337280273f,0.50750899314880371094f,0.86164647340774536133f,
0.50618666410446166992f,0.86242395639419555664f,0.50486308336257934570f,
0.86319941282272338867f,0.50353837013244628906f,0.86397284269332885742f,
0.50221246480941772461f,0.86474424600601196289f,0.50088536739349365234f,
0.86551362276077270508f,0.49955710768699645996f,0.86628097295761108398f,
0.49822765588760375977f,0.86704623699188232422f,0.49689704179763793945f,
0.86780947446823120117f,0.49556526541709899902f,0.86857068538665771484f,
0.49423229694366455078f,0.86932986974716186523f,0.49289819598197937012f,
0.87008696794509887695f,0.49156290292739868164f,0.87084203958511352539f,
0.49022647738456726074f,0.87159508466720581055f,0.48888888955116271973f,
0.87234604358673095703f,0.48755016922950744629f,0.87309497594833374023f,
0.48621028661727905273f,0.87384182214736938477f,0.48486924171447753906f,
0.87458664178848266602f,0.48352706432342529297f,0.87532937526702880859f,
0.48218378424644470215f,0.87607008218765258789f,0.48083934187889099121f,
0.87680870294570922852f,0.47949376702308654785f,0.87754529714584350586f,
0.47814705967903137207f,0.87827980518341064453f,0.47679921984672546387f,
0.87901222705841064453f,0.47545027732849121094f,0.87974262237548828125f,
0.47410020232200622559f,0.88047087192535400391f,0.47274902462959289551f,
0.88119709491729736328f,0.47139674425125122070f,0.88192129135131835938f,
0.47004333138465881348f,0.88264334201812744141f,0.46868881583213806152f,
0.88336336612701416016f,0.46733319759368896484f,0.88408124446868896484f,
0.46597650647163391113f,0.88479709625244140625f,0.46461868286132812500f,
0.88551086187362670898f,0.46325978636741638184f,0.88622254133224487305f,
0.46189978718757629395f,0.88693213462829589844f,0.46053871512413024902f,
0.88763964176177978516f,0.45917654037475585938f,0.88834506273269653320f,
0.45781329274177551270f,0.88904833793640136719f,0.45644897222518920898f,
0.88974958658218383789f,0.45508357882499694824f,0.89044874906539916992f,
0.45371711254119873047f,0.89114576578140258789f,0.45234957337379455566f,
0.89184069633483886719f,0.45098099112510681152f,0.89253354072570800781f,
0.44961133599281311035f,0.89322429895401000977f,0.44824060797691345215f,
0.89391297101974487305f,0.44686883687973022461f,0.89459949731826782227f,
0.44549602270126342773f,0.89528393745422363281f,0.44412213563919067383f,
0.89596623182296752930f,0.44274723529815673828f,0.89664649963378906250f,
0.44137126207351684570f,0.89732456207275390625f,0.43999427556991577148f,
0.89800059795379638672f,0.43861624598503112793f,0.89867448806762695312f,
0.43723717331886291504f,0.89934623241424560547f,0.43585708737373352051f,
0.90001589059829711914f,0.43447595834732055664f,0.90068340301513671875f,
0.43309381604194641113f,0.90134882926940917969f,0.43171066045761108398f,
0.90201216936111450195f,0.43032649159431457520f,0.90267330408096313477f,
0.42894127964973449707f,0.90333235263824462891f,0.42755508422851562500f,
0.90398931503295898438f,0.42616787552833557129f,0.90464407205581665039f,
0.42477968335151672363f,0.90529674291610717773f,0.42339047789573669434f,
0.90594726800918579102f,0.42200025916099548340f,0.90659570693969726562f,
0.42060908675193786621f,0.90724200010299682617f,0.41921690106391906738f,
0.90788608789443969727f,0.41782370209693908691f,0.90852808952331542969f,
0.41642954945564270020f,0.90916800498962402344f,0.41503441333770751953f,
0.90980571508407592773f,0.41363832354545593262f,0.91044127941131591797f,
0.41224122047424316406f,0.91107475757598876953f,0.41084316372871398926f,
0.91170603036880493164f,0.40944415330886840820f,0.91233515739440917969f,
0.40804415941238403320f,0.91296219825744628906f,0.40664321184158325195f,
0.91358703374862670898f,0.40524131059646606445f,0.91420978307723999023f,
0.40383845567703247070f,0.91483032703399658203f,0.40243464708328247070f,
0.91544872522354125977f,0.40102988481521606445f,0.91606497764587402344f,
0.39962419867515563965f,0.91667908430099487305f,0.39821755886077880859f,
0.91729098558425903320f,0.39680999517440795898f,0.91790080070495605469f,
0.39540147781372070312f,0.91850841045379638672f,0.39399203658103942871f,
0.91911387443542480469f,0.39258167147636413574f,0.91971713304519653320f,
0.39117038249969482422f,0.92031830549240112305f,0.38975816965103149414f,
0.92091721296310424805f,0.38834503293037414551f,0.92151403427124023438f,
0.38693100214004516602f,0.92210865020751953125f,0.38551604747772216797f,
0.92270112037658691406f,0.38410019874572753906f,0.92329144477844238281f,
0.38268342614173889160f,0.92387950420379638672f,0.38126575946807861328f,
0.92446547746658325195f,0.37984719872474670410f,0.92504924535751342773f,
0.37842774391174316406f,0.92563080787658691406f,0.37700742483139038086f,
0.92621022462844848633f,0.37558618187904357910f,0.92678749561309814453f,
0.37416407465934753418f,0.92736250162124633789f,0.37274107336997985840f,
0.92793542146682739258f,0.37131720781326293945f,0.92850607633590698242f,
0.36989244818687438965f,0.92907458543777465820f,0.36846682429313659668f,
0.92964088916778564453f,0.36704033613204956055f,0.93020504713058471680f,
0.36561298370361328125f,0.93076694011688232422f,0.36418479681015014648f,
0.93132668733596801758f,0.36275571584701538086f,0.93188428878784179688f,
0.36132580041885375977f,0.93243962526321411133f,0.35989505052566528320f,
0.93299281597137451172f,0.35846340656280517578f,0.93354380130767822266f,
0.35703095793724060059f,0.93409252166748046875f,0.35559767484664916992f,
0.93463915586471557617f,0.35416352748870849609f,0.93518352508544921875f,
0.35272854566574096680f,0.93572568893432617188f,0.35129275918006896973f,
0.93626564741134643555f,0.34985613822937011719f,0.93680346012115478516f,
0.34841868281364440918f,0.93733900785446166992f,0.34698042273521423340f,
0.93787235021591186523f,0.34554132819175720215f,0.93840354681015014648f,
0.34410142898559570312f,0.93893247842788696289f,0.34266072511672973633f,
0.93945920467376708984f,0.34121921658515930176f,0.93998372554779052734f,
0.33977687358856201172f,0.94050604104995727539f,0.33833375573158264160f,
0.94102615118026733398f,0.33688986301422119141f,0.94154405593872070312f,
0.33544513583183288574f,0.94205975532531738281f,0.33399966359138488770f,
0.94257318973541259766f,0.33255335688591003418f,0.94308441877365112305f,
0.33110630512237548828f,0.94359344244003295898f,0.32965844869613647461f,
0.94410026073455810547f,0.32820984721183776855f,0.94460481405258178711f,
0.32676044106483459473f,0.94510722160339355469f,0.32531028985977172852f,
0.94560730457305908203f,0.32385936379432678223f,0.94610524177551269531f,
0.32240769267082214355f,0.94660091400146484375f,0.32095524668693542480f,
0.94709438085556030273f,0.31950202584266662598f,0.94758558273315429688f,
0.31804808974266052246f,0.94807457923889160156f,0.31659337878227233887f,
0.94856137037277221680f,0.31513792276382446289f,0.94904589653015136719f,
0.31368175148963928223f,0.94952815771102905273f,0.31222480535507202148f,
0.95000827312469482422f,0.31076714396476745605f,0.95048606395721435547f,
0.30930876731872558594f,0.95096164941787719727f,0.30784964561462402344f,
0.95143502950668334961f,0.30638980865478515625f,0.95190614461898803711f,
0.30492922663688659668f,0.95237499475479125977f,0.30346795916557312012f,
0.95284163951873779297f,0.30200594663619995117f,0.95330601930618286133f,
0.30054324865341186523f,0.95376819372177124023f,0.29907983541488647461f,
0.95422810316085815430f,0.29761570692062377930f,0.95468574762344360352f,
0.29615089297294616699f,0.95514118671417236328f,0.29468536376953125000f,
0.95559436082839965820f,0.29321914911270141602f,0.95604526996612548828f,
0.29175224900245666504f,0.95649391412734985352f,0.29028466343879699707f,
0.95694035291671752930f,0.28881642222404479980f,0.95738452672958374023f,
0.28734746575355529785f,0.95782643556594848633f,0.28587782382965087891f,
0.95826607942581176758f,0.28440752625465393066f,0.95870345830917358398f,
0.28293657302856445312f,0.95913863182067871094f,0.28146493434906005859f,
0.95957154035568237305f,0.27999264001846313477f,0.96000212430953979492f,
0.27851969003677368164f,0.96043050289154052734f,0.27704608440399169922f,
0.96085661649703979492f,0.27557182312011718750f,0.96128046512603759766f,
0.27409690618515014648f,0.96170204877853393555f,0.27262136340141296387f,
0.96212142705917358398f,0.27114516496658325195f,0.96253848075866699219f,
0.26966831088066101074f,0.96295326948165893555f,0.26819086074829101562f,
0.96336579322814941406f,0.26671275496482849121f,0.96377605199813842773f,
0.26523402333259582520f,0.96418404579162597656f,0.26375466585159301758f,
0.96458977460861206055f,0.26227471232414245605f,0.96499323844909667969f,
0.26079410314559936523f,0.96539443731307983398f,0.25931292772293090820f,
0.96579337120056152344f,0.25783109664916992188f,0.96618998050689697266f,
0.25634866952896118164f,0.96658438444137573242f,0.25486564636230468750f,
0.96697646379470825195f,0.25338202714920043945f,0.96736627817153930664f,
0.25189781188964843750f,0.96775382757186889648f,0.25041300058364868164f,
0.96813911199569702148f,0.24892760813236236572f,0.96852207183837890625f,
0.24744161963462829590f,0.96890282630920410156f,0.24595504999160766602f,
0.96928125619888305664f,0.24446789920330047607f,0.96965736150741577148f,
0.24298018217086791992f,0.97003126144409179688f,0.24149188399314880371f,
0.97040283679962158203f,0.24000301957130432129f,0.97077214717864990234f,
0.23851358890533447266f,0.97113913297653198242f,0.23702360689640045166f,
0.97150391340255737305f,0.23553305864334106445f,0.97186630964279174805f,
0.23404195904731750488f,0.97222650051116943359f,0.23255030810832977295f,
0.97258436679840087891f,0.23105810582637786865f,0.97293996810913085938f,
0.22956536710262298584f,0.97329324483871459961f,0.22807207703590393066f,
0.97364425659179687500f,0.22657826542854309082f,0.97399294376373291016f,
0.22508391737937927246f,0.97433936595916748047f,0.22358903288841247559f,
0.97468352317810058594f,0.22209362685680389404f,0.97502535581588745117f,
0.22059768438339233398f,0.97536486387252807617f,0.21910123527050018311f,
0.97570210695266723633f,0.21760427951812744141f,0.97603708505630493164f,
0.21610680222511291504f,0.97636973857879638672f,0.21460881829261779785f,
0.97670006752014160156f,0.21311031281948089600f,0.97702813148498535156f,
0.21161133050918579102f,0.97735387086868286133f,0.21011184155941009521f,
0.97767734527587890625f,0.20861184597015380859f,0.97799849510192871094f,
0.20711137354373931885f,0.97831737995147705078f,0.20561040937900543213f,
0.97863394021987915039f,0.20410896837711334229f,0.97894817590713500977f,
0.20260703563690185547f,0.97926014661788940430f,0.20110464096069335938f,
0.97956979274749755859f,0.19960175454616546631f,0.97987711429595947266f,
0.19809840619564056396f,0.98018211126327514648f,0.19659459590911865234f,
0.98048484325408935547f,0.19509032368659973145f,0.98078525066375732422f,
0.19358558952808380127f,0.98108339309692382812f,0.19208039343357086182f,
0.98137921094894409180f,0.19057475030422210693f,0.98167270421981811523f,
0.18906866014003753662f,0.98196387290954589844f,0.18756212294101715088f,
0.98225271701812744141f,0.18605515360832214355f,0.98253929615020751953f,
0.18454773724079132080f,0.98282355070114135742f,0.18303988873958587646f,
0.98310548067092895508f,0.18153160810470581055f,0.98338508605957031250f,
0.18002289533615112305f,0.98366242647171020508f,0.17851376533508300781f,
0.98393744230270385742f,0.17700421810150146484f,0.98421007394790649414f,
0.17549425363540649414f,0.98448044061660766602f,0.17398387193679809570f,
0.98474848270416259766f,0.17247308790683746338f,0.98501425981521606445f,
0.17096188664436340332f,0.98527765274047851562f,0.16945029795169830322f,
0.98553872108459472656f,0.16793829202651977539f,0.98579752445220947266f,
0.16642589867115020752f,0.98605394363403320312f,0.16491311788558959961f,
0.98630809783935546875f,0.16339994966983795166f,0.98655992746353149414f,
0.16188639402389526367f,0.98680937290191650391f,0.16037245094776153564f,
0.98705655336380004883f,0.15885815024375915527f,0.98730140924453735352f,
0.15734346210956573486f,0.98754394054412841797f,0.15582840144634246826f,
0.98778414726257324219f,0.15431296825408935547f,0.98802202939987182617f,
0.15279719233512878418f,0.98825758695602416992f,0.15128104388713836670f,
0.98849081993103027344f,0.14976453781127929688f,0.98872166872024536133f,
0.14824767410755157471f,0.98895025253295898438f,0.14673046767711639404f,
0.98917651176452636719f,0.14521291851997375488f,0.98940044641494750977f,
0.14369502663612365723f,0.98962199687957763672f,0.14217680692672729492f,
0.98984128236770629883f,0.14065824449062347412f,0.99005818367004394531f,
0.13913933932781219482f,0.99027281999588012695f,0.13762012124061584473f,
0.99048507213592529297f,0.13610057532787322998f,0.99069499969482421875f,
0.13458070158958435059f,0.99090266227722167969f,0.13306052982807159424f,
0.99110794067382812500f,0.13154003024101257324f,0.99131083488464355469f,
0.13001921772956848145f,0.99151146411895751953f,0.12849810719490051270f,
0.99170976877212524414f,0.12697669863700866699f,0.99190568923950195312f,
0.12545497715473175049f,0.99209928512573242188f,0.12393297255039215088f,
0.99229061603546142578f,0.12241067737340927124f,0.99247956275939941406f,
0.12088808417320251465f,0.99266612529754638672f,0.11936521530151367188f,
0.99285042285919189453f,0.11784206330776214600f,0.99303233623504638672f,
0.11631862819194793701f,0.99321192502975463867f,0.11479492485523223877f,
0.99338918924331665039f,0.11327095329761505127f,0.99356412887573242188f,
0.11174671351909637451f,0.99373674392700195312f,0.11022220551967620850f,
0.99390697479248046875f,0.10869744420051574707f,0.99407488107681274414f,
0.10717242211103439331f,0.99424046277999877930f,0.10564715415239334106f,
0.99440366029739379883f,0.10412163287401199341f,0.99456459283828735352f,
0.10259586572647094727f,0.99472314119338989258f,0.10106986016035079956f,
0.99487930536270141602f,0.09954361617565155029f,0.99503320455551147461f,
0.09801714122295379639f,0.99518471956253051758f,0.09649042785167694092f,
0.99533390998840332031f,0.09496349841356277466f,0.99548077583312988281f,
0.09343633800745010376f,0.99562525749206542969f,0.09190895408391952515f,
0.99576741456985473633f,0.09038136154413223267f,0.99590724706649780273f,
0.08885355293750762939f,0.99604469537734985352f,0.08732553571462631226f,
0.99617981910705566406f,0.08579730987548828125f,0.99631261825561523438f,
0.08426889032125473022f,0.99644303321838378906f,0.08274026215076446533f,
0.99657112360000610352f,0.08121144771575927734f,0.99669688940048217773f,
0.07968243956565856934f,0.99682027101516723633f,0.07815324515104293823f,
0.99694132804870605469f,0.07662386447191238403f,0.99706006050109863281f,
0.07509429752826690674f,0.99717640876770019531f,0.07356456667184829712f,
0.99729043245315551758f,0.07203464955091476440f,0.99740213155746459961f,
0.07050457596778869629f,0.99751144647598266602f,0.06897433102130889893f,
0.99761843681335449219f,0.06744392216205596924f,0.99772304296493530273f,
0.06591334939002990723f,0.99782532453536987305f,0.06438262760639190674f,
0.99792528152465820312f,0.06285175681114196777f,0.99802285432815551758f,
0.06132073700428009033f,0.99811810255050659180f,0.05978957191109657288f,
0.99821102619171142578f,0.05825826525688171387f,0.99830156564712524414f,
0.05672682076692581177f,0.99838972091674804688f,0.05519524589180946350f,
0.99847555160522460938f,0.05366353690624237061f,0.99855905771255493164f,
0.05213170498609542847f,0.99864023923873901367f,0.05059975013136863708f,
0.99871903657913208008f,0.04906767606735229492f,0.99879544973373413086f,
0.04753548279404640198f,0.99886953830718994141f,0.04600318148732185364f,
0.99894130229949951172f,0.04447077214717864990f,0.99901068210601806641f,
0.04293825849890708923f,0.99907773733139038086f,0.04140564054250717163f,
0.99914240837097167969f,0.03987292572855949402f,0.99920475482940673828f,
0.03834012150764465332f,0.99926477670669555664f,0.03680722415447235107f,
0.99932235479354858398f,0.03527423739433288574f,0.99937766790390014648f,
0.03374117240309715271f,0.99943059682846069336f,0.03220802545547485352f,
0.99948120117187500000f,0.03067480400204658508f,0.99952942132949829102f,
0.02914150804281234741f,0.99957531690597534180f,0.02760814502835273743f,
0.99961882829666137695f,0.02607471868395805359f,0.99966001510620117188f,
0.02454122900962829590f,0.99969881772994995117f,0.02300768159329891205f,
0.99973529577255249023f,0.02147408016026020050f,0.99976938962936401367f,
0.01994042843580245972f,0.99980115890502929688f,0.01840673014521598816f,
0.99983060359954833984f,0.01687298715114593506f,0.99985766410827636719f,
0.01533920597285032272f,0.99988234043121337891f,0.01380538847297430038f,
0.99990469217300415039f,0.01227153837680816650f,0.99992471933364868164f,
0.01073765940964221954f,0.99994236230850219727f,0.00920375436544418335f,
0.99995762109756469727f,0.00766982883214950562f,0.99997061491012573242f,
0.00613588467240333557f,0.99998116493225097656f,0.00460192607715725899f,
0.99998939037322998047f,0.00306795677170157433f,0.99999529123306274414f,
0.00153398013208061457f,0.99999880790710449219f,1.00000000000000000000f,
0.00000000000000000000f,0.99998116493225097656f,0.00613588467240333557f,
0.99992471933364868164f,0.01227153837680816650f,0.99983060359954833984f,
0.01840673014521598816f,0.99969881772994995117f,0.02454122900962829590f,
0.99952942132949829102f,0.03067480400204658508f,0.99932235479354858398f,
0.03680722415447235107f,0.99907773733139038086f,0.04293825849890708923f,
0.99879544973373413086f,0.04906767606735229492f,0.99847555160522460938f,
0.05519524589180946350f,0.99811810255050659180f,0.06132073700428009033f,
0.99772304296493530273f,0.06744392216205596924f,0.99729043245315551758f,
0.07356456667184829712f,0.99682027101516723633f,0.07968243956565856934f,
0.99631261825561523438f,0.08579730987548828125f,0.99576741456985473633f,
0.09190895408391952515f,0.99518471956253051758f,0.09801714122295379639f,
0.99456459283828735352f,0.10412163287401199341f,0.99390697479248046875f,
0.11022220551967620850f,0.99321192502975463867f,0.11631862819194793701f,
0.99247956275939941406f,0.12241067737340927124f,0.99170976877212524414f,
0.12849810719490051270f,0.99090266227722167969f,0.13458070158958435059f,
0.99005818367004394531f,0.14065824449062347412f,0.98917651176452636719f,
0.14673046767711639404f,0.98825758695602416992f,0.15279719233512878418f,
0.98730140924453735352f,0.15885815024375915527f,0.98630809783935546875f,
0.16491311788558959961f,0.98527765274047851562f,0.17096188664436340332f,
0.98421007394790649414f,0.17700421810150146484f,0.98310548067092895508f,
0.18303988873958587646f,0.98196387290954589844f,0.18906866014003753662f,
0.98078525066375732422f,0.19509032368659973145f,0.97956979274749755859f,
0.20110464096069335938f,0.97831737995147705078f,0.20711137354373931885f,
0.97702813148498535156f,0.21311031281948089600f,0.97570210695266723633f,
0.21910123527050018311f,0.97433936595916748047f,0.22508391737937927246f,
0.97293996810913085938f,0.23105810582637786865f,0.97150391340255737305f,
0.23702360689640045166f,0.97003126144409179688f,0.24298018217086791992f,
0.96852207183837890625f,0.24892760813236236572f,0.96697646379470825195f,
0.25486564636230468750f,0.96539443731307983398f,0.26079410314559936523f,
0.96377605199813842773f,0.26671275496482849121f,0.96212142705917358398f,
0.27262136340141296387f,0.96043050289154052734f,0.27851969003677368164f,
0.95870345830917358398f,0.28440752625465393066f,0.95694035291671752930f,
0.29028466343879699707f,0.95514118671417236328f,0.29615089297294616699f,
0.95330601930618286133f,0.30200594663619995117f,0.95143502950668334961f,
0.30784964561462402344f,0.94952815771102905273f,0.31368175148963928223f,
0.94758558273315429688f,0.31950202584266662598f,0.94560730457305908203f,
0.32531028985977172852f,0.94359344244003295898f,0.33110630512237548828f,
0.94154405593872070312f,0.33688986301422119141f,0.93945920467376708984f,
0.34266072511672973633f,0.93733900785446166992f,0.34841868281364440918f,
0.93518352508544921875f,0.35416352748870849609f,0.93299281597137451172f,
0.35989505052566528320f,0.93076694011688232422f,0.36561298370361328125f,
0.92850607633590698242f,0.37131720781326293945f,0.92621022462844848633f,
0.37700742483139038086f,0.92387950420379638672f,0.38268342614173889160f,
0.92151403427124023438f,0.38834503293037414551f,0.91911387443542480469f,
0.39399203658103942871f,0.91667908430099487305f,0.39962419867515563965f,
0.91420978307723999023f,0.40524131059646606445f,0.91170603036880493164f,
0.41084316372871398926f,0.90916800498962402344f,0.41642954945564270020f,
0.90659570693969726562f,0.42200025916099548340f,0.90398931503295898438f,
0.42755508422851562500f,0.90134882926940917969f,0.43309381604194641113f,
0.89867448806762695312f,0.43861624598503112793f,0.89596623182296752930f,
0.44412213563919067383f,0.89322429895401000977f,0.44961133599281311035f,
0.89044874906539916992f,0.45508357882499694824f,0.88763964176177978516f,
0.46053871512413024902f,0.88479709625244140625f,0.46597650647163391113f,
0.88192129135131835938f,0.47139674425125122070f,0.87901222705841064453f,
0.47679921984672546387f,0.87607008218765258789f,0.48218378424644470215f,
0.87309497594833374023f,0.48755016922950744629f,0.87008696794509887695f,
0.49289819598197937012f,0.86704623699188232422f,0.49822765588760375977f,
0.86397284269332885742f,0.50353837013244628906f,0.86086696386337280273f,
0.50883013010025024414f,0.85772860050201416016f,0.51410275697708129883f,
0.85455799102783203125f,0.51935601234436035156f,0.85135519504547119141f,
0.52458965778350830078f,0.84812033176422119141f,0.52980363368988037109f,
0.84485357999801635742f,0.53499764204025268555f,0.84155499935150146484f,
0.54017144441604614258f,0.83822470903396606445f,0.54532498121261596680f,
0.83486288785934448242f,0.55045795440673828125f,0.83146959543228149414f,
0.55557024478912353516f,0.82804507017135620117f,0.56066155433654785156f,
0.82458931207656860352f,0.56573182344436645508f,0.82110249996185302734f,
0.57078075408935546875f,0.81758481264114379883f,0.57580816745758056641f,
0.81403630971908569336f,0.58081394433975219727f,0.81045717000961303711f,
0.58579784631729125977f,0.80684757232666015625f,0.59075969457626342773f,
0.80320751667022705078f,0.59569931030273437500f,0.79953724145889282227f,
0.60061645507812500000f,0.79583692550659179688f,0.60551106929779052734f,
0.79210656881332397461f,0.61038279533386230469f,0.78834640979766845703f,
0.61523157358169555664f,0.78455656766891479492f,0.62005722522735595703f,
0.78073722124099731445f,0.62485951185226440430f,0.77688848972320556641f,
0.62963825464248657227f,0.77301043272018432617f,0.63439327478408813477f,
0.76910334825515747070f,0.63912445306777954102f,0.76516723632812500000f,
0.64383155107498168945f,0.76120239496231079102f,0.64851438999176025391f,
0.75720882415771484375f,0.65317285060882568359f,0.75318682193756103516f,
0.65780669450759887695f,0.74913638830184936523f,0.66241580247879028320f,
0.74505776166915893555f,0.66699993610382080078f,0.74095112085342407227f,
0.67155897617340087891f,0.73681658506393432617f,0.67609268426895141602f,
0.73265427350997924805f,0.68060100078582763672f,0.72846436500549316406f,
0.68508368730545043945f,0.72424709796905517578f,0.68954056501388549805f,
0.72000253200531005859f,0.69397145509719848633f,0.71573084592819213867f,
0.69837623834609985352f,0.71143221855163574219f,0.70275473594665527344f,
0.70710676908493041992f,0.70710676908493041992f,0.70275473594665527344f,
0.71143221855163574219f,0.69837623834609985352f,0.71573084592819213867f,
0.69397145509719848633f,0.72000253200531005859f,0.68954056501388549805f,
0.72424709796905517578f,0.68508368730545043945f,0.72846436500549316406f,
0.68060100078582763672f,0.73265427350997924805f,0.67609268426895141602f,
0.73681658506393432617f,0.67155897617340087891f,0.74095112085342407227f,
0.66699993610382080078f,0.74505776166915893555f,0.66241580247879028320f,
0.74913638830184936523f,0.65780669450759887695f,0.75318682193756103516f,
0.65317285060882568359f,0.75720882415771484375f,0.64851438999176025391f,
0.76120239496231079102f,0.64383155107498168945f,0.76516723632812500000f,
0.63912445306777954102f,0.76910334825515747070f,0.63439327478408813477f,
0.77301043272018432617f,0.62963825464248657227f,0.77688848972320556641f,
0.62485951185226440430f,0.78073722124099731445f,0.62005722522735595703f,
0.78455656766891479492f,0.61523157358169555664f,0.78834640979766845703f,
0.61038279533386230469f,0.79210656881332397461f,0.60551106929779052734f,
0.79583692550659179688f,0.60061645507812500000f,0.79953724145889282227f,
0.59569931030273437500f,0.80320751667022705078f,0.59075969457626342773f,
0.80684757232666015625f,0.58579784631729125977f,0.81045717000961303711f,
0.58081394433975219727f,0.81403630971908569336f,0.57580816745758056641f,
0.81758481264114379883f,0.57078075408935546875f,0.82110249996185302734f,
0.56573182344436645508f,0.82458931207656860352f,0.56066155433654785156f,
0.82804507017135620117f,0.55557024478912353516f,0.83146959543228149414f,
0.55045795440673828125f,0.83486288785934448242f,0.54532498121261596680f,
0.83822470903396606445f,0.54017144441604614258f,0.84155499935150146484f,
0.53499764204025268555f,0.84485357999801635742f,0.52980363368988037109f,
0.84812033176422119141f,0.52458965778350830078f,0.85135519504547119141f,
0.51935601234436035156f,0.85455799102783203125f,0.51410275697708129883f,
0.85772860050201416016f,0.50883013010025024414f,0.86086696386337280273f,
0.50353837013244628906f,0.86397284269332885742f,0.49822765588760375977f,
0.86704623699188232422f,0.49289819598197937012f,0.87008696794509887695f,
0.48755016922950744629f,0.87309497594833374023f,0.48218378424644470215f,
0.87607008218765258789f,0.47679921984672546387f,0.87901222705841064453f,
0.47139674425125122070f,0.88192129135131835938f,0.46597650647163391113f,
0.88479709625244140625f,0.46053871512413024902f,0.88763964176177978516f,
0.45508357882499694824f,0.89044874906539916992f,0.44961133599281311035f,
0.89322429895401000977f,0.44412213563919067383f,0.89596623182296752930f,
0.43861624598503112793f,0.89867448806762695312f,0.43309381604194641113f,
0.90134882926940917969f,0.42755508422851562500f,0.90398931503295898438f,
0.42200025916099548340f,0.90659570693969726562f,0.41642954945564270020f,
0.90916800498962402344f,0.41084316372871398926f,0.91170603036880493164f,
0.40524131059646606445f,0.91420978307723999023f,0.39962419867515563965f,
0.91667908430099487305f,0.39399203658103942871f,0.91911387443542480469f,
0.38834503293037414551f,0.92151403427124023438f,0.38268342614173889160f,
0.92387950420379638672f,0.37700742483139038086f,0.92621022462844848633f,
0.37131720781326293945f,0.92850607633590698242f,0.36561298370361328125f,
0.93076694011688232422f,0.35989505052566528320f,0.93299281597137451172f,
0.35416352748870849609f,0.93518352508544921875f,0.34841868281364440918f,
0.93733900785446166992f,0.34266072511672973633f,0.93945920467376708984f,
0.33688986301422119141f,0.94154405593872070312f,0.33110630512237548828f,
0.94359344244003295898f,0.32531028985977172852f,0.94560730457305908203f,
0.31950202584266662598f,0.94758558273315429688f,0.31368175148963928223f,
0.94952815771102905273f,0.30784964561462402344f,0.95143502950668334961f,
0.30200594663619995117f,0.95330601930618286133f,0.29615089297294616699f,
0.95514118671417236328f,0.29028466343879699707f,0.95694035291671752930f,
0.28440752625465393066f,0.95870345830917358398f,0.27851969003677368164f,
0.96043050289154052734f,0.27262136340141296387f,0.96212142705917358398f,
0.26671275496482849121f,0.96377605199813842773f,0.26079410314559936523f,
0.96539443731307983398f,0.25486564636230468750f,0.96697646379470825195f,
0.24892760813236236572f,0.96852207183837890625f,0.24298018217086791992f,
0.97003126144409179688f,0.23702360689640045166f,0.97150391340255737305f,
0.23105810582637786865f,0.97293996810913085938f,0.22508391737937927246f,
0.97433936595916748047f,0.21910123527050018311f,0.97570210695266723633f,
0.21311031281948089600f,0.97702813148498535156f,0.20711137354373931885f,
0.97831737995147705078f,0.20110464096069335938f,0.97956979274749755859f,
0.19509032368659973145f,0.98078525066375732422f,0.18906866014003753662f,
0.98196387290954589844f,0.18303988873958587646f,0.98310548067092895508f,
0.17700421810150146484f,0.98421007394790649414f,0.17096188664436340332f,
0.98527765274047851562f,0.16491311788558959961f,0.98630809783935546875f,
0.15885815024375915527f,0.98730140924453735352f,0.15279719233512878418f,
0.98825758695602416992f,0.14673046767711639404f,0.98917651176452636719f,
0.14065824449062347412f,0.99005818367004394531f,0.13458070158958435059f,
0.99090266227722167969f,0.12849810719490051270f,0.99170976877212524414f,
0.12241067737340927124f,0.99247956275939941406f,0.11631862819194793701f,
0.99321192502975463867f,0.11022220551967620850f,0.99390697479248046875f,
0.10412163287401199341f,0.99456459283828735352f,0.09801714122295379639f,
0.99518471956253051758f,0.09190895408391952515f,0.99576741456985473633f,
0.08579730987548828125f,0.99631261825561523438f,0.07968243956565856934f,
0.99682027101516723633f,0.07356456667184829712f,0.99729043245315551758f,
0.06744392216205596924f,0.99772304296493530273f,0.06132073700428009033f,
0.99811810255050659180f,0.05519524589180946350f,0.99847555160522460938f,
0.04906767606735229492f,0.99879544973373413086f,0.04293825849890708923f,
0.99907773733139038086f,0.03680722415447235107f,0.99932235479354858398f,
0.03067480400204658508f,0.99952942132949829102f,0.02454122900962829590f,
0.99969881772994995117f,0.01840673014521598816f,0.99983060359954833984f,
0.01227153837680816650f,0.99992471933364868164f,0.00613588467240333557f,
0.99998116493225097656f,1.00000000000000000000f,0.00000000000000000000f,
0.99969881772994995117f,0.02454122900962829590f,0.99879544973373413086f,
0.04906767606735229492f,0.99729043245315551758f,0.07356456667184829712f,
0.99518471956253051758f,0.09801714122295379639f,0.99247956275939941406f,
0.12241067737340927124f,0.98917651176452636719f,0.14673046767711639404f,
0.98527765274047851562f,0.17096188664436340332f,0.98078525066375732422f,
0.19509032368659973145f,0.97570210695266723633f,0.21910123527050018311f,
0.97003126144409179688f,0.24298018217086791992f,0.96377605199813842773f,
0.26671275496482849121f,0.95694035291671752930f,0.29028466343879699707f,
0.94952815771102905273f,0.31368175148963928223f,0.94154405593872070312f,
0.33688986301422119141f,0.93299281597137451172f,0.35989505052566528320f,
0.92387950420379638672f,0.38268342614173889160f,0.91420978307723999023f,
0.40524131059646606445f,0.90398931503295898438f,0.42755508422851562500f,
0.89322429895401000977f,0.44961133599281311035f,0.88192129135131835938f,
0.47139674425125122070f,0.87008696794509887695f,0.49289819598197937012f,
0.85772860050201416016f,0.51410275697708129883f,0.84485357999801635742f,
0.53499764204025268555f,0.83146959543228149414f,0.55557024478912353516f,
0.81758481264114379883f,0.57580816745758056641f,0.80320751667022705078f,
0.59569931030273437500f,0.78834640979766845703f,0.61523157358169555664f,
0.77301043272018432617f,0.63439327478408813477f,0.75720882415771484375f,
0.65317285060882568359f,0.74095112085342407227f,0.67155897617340087891f,
0.72424709796905517578f,0.68954056501388549805f,0.70710676908493041992f,
0.70710676908493041992f,0.68954056501388549805f,0.72424709796905517578f,
0.67155897617340087891f,0.74095112085342407227f,0.65317285060882568359f,
0.75720882415771484375f,0.63439327478408813477f,0.77301043272018432617f,
0.61523157358169555664f,0.78834640979766845703f,0.59569931030273437500f,
0.80320751667022705078f,0.57580816745758056641f,0.81758481264114379883f,
0.55557024478912353516f,0.83146959543228149414f,0.53499764204025268555f,
0.84485357999801635742f,0.51410275697708129883f,0.85772860050201416016f,
0.49289819598197937012f,0.87008696794509887695f,0.47139674425125122070f,
0.88192129135131835938f,0.44961133599281311035f,0.89322429895401000977f,
0.42755508422851562500f,0.90398931503295898438f,0.40524131059646606445f,
0.91420978307723999023f,0.38268342614173889160f,0.92387950420379638672f,
0.35989505052566528320f,0.93299281597137451172f,0.33688986301422119141f,
0.94154405593872070312f,0.31368175148963928223f,0.94952815771102905273f,
0.29028466343879699707f,0.95694035291671752930f,0.26671275496482849121f,
0.96377605199813842773f,0.24298018217086791992f,0.97003126144409179688f,
0.21910123527050018311f,0.97570210695266723633f,0.19509032368659973145f,
0.98078525066375732422f,0.17096188664436340332f,0.98527765274047851562f,
0.14673046767711639404f,0.98917651176452636719f,0.12241067737340927124f,
0.99247956275939941406f,0.09801714122295379639f,0.99518471956253051758f,
0.07356456667184829712f,0.99729043245315551758f,0.04906767606735229492f,
0.99879544973373413086f,0.02454122900962829590f,0.99969881772994995117f,
1.00000000000000000000f,0.00000000000000000000f,0.99518471956253051758f,
0.09801714122295379639f,0.98078525066375732422f,0.19509032368659973145f,
0.95694035291671752930f,0.29028466343879699707f,0.92387950420379638672f,
0.38268342614173889160f,0.88192129135131835938f,0.47139674425125122070f,
0.83146959543228149414f,0.55557024478912353516f,0.77301043272018432617f,
0.63439327478408813477f,0.70710676908493041992f,0.70710676908493041992f,
0.63439327478408813477f,0.77301043272018432617f,0.55557024478912353516f,
0.83146959543228149414f,0.47139674425125122070f,0.88192129135131835938f,
0.38268342614173889160f,0.92387950420379638672f,0.29028466343879699707f,
0.95694035291671752930f,0.19509032368659973145f,0.98078525066375732422f,
0.09801714122295379639f,0.99518471956253051758f,1.00000000000000000000f,
0.00000000000000000000f,0.92387950420379638672f,0.38268342614173889160f,
0.70710676908493041992f,0.70710676908493041992f,0.38268342614173889160f,
0.92387950420379638672f,};

float32_t rearranged_twiddle_stride2_4096_f32[2728]={
1.00000000000000000000f,0.00000000000000000000f,0.99999529123306274414f,
0.00306795677170157433f,0.99998116493225097656f,0.00613588467240333557f,
0.99995762109756469727f,0.00920375436544418335f,0.99992471933364868164f,
0.01227153837680816650f,0.99988234043121337891f,0.01533920597285032272f,
0.99983060359954833984f,0.01840673014521598816f,0.99976938962936401367f,
0.02147408016026020050f,0.99969881772994995117f,0.02454122900962829590f,
0.99961882829666137695f,0.02760814502835273743f,0.99952942132949829102f,
0.03067480400204658508f,0.99943059682846069336f,0.03374117240309715271f,
0.99932235479354858398f,0.03680722415447235107f,0.99920475482940673828f,
0.03987292572855949402f,0.99907773733139038086f,0.04293825849890708923f,
0.99894130229949951172f,0.04600318148732185364f,0.99879544973373413086f,
0.04906767606735229492f,0.99864023923873901367f,0.05213170498609542847f,
0.99847555160522460938f,0.05519524589180946350f,0.99830156564712524414f,
0.05825826525688171387f,0.99811810255050659180f,0.06132073700428009033f,
0.99792528152465820312f,0.06438262760639190674f,0.99772304296493530273f,
0.06744392216205596924f,0.99751144647598266602f,0.07050457596778869629f,
0.99729043245315551758f,0.07356456667184829712f,0.99706006050109863281f,
0.07662386447191238403f,0.99682027101516723633f,0.07968243956565856934f,
0.99657112360000610352f,0.08274026215076446533f,0.99631261825561523438f,
0.08579730987548828125f,0.99604469537734985352f,0.08885355293750762939f,
0.99576741456985473633f,0.09190895408391952515f,0.99548077583312988281f,
0.09496349841356277466f,0.99518471956253051758f,0.09801714122295379639f,
0.99487930536270141602f,0.10106986016035079956f,0.99456459283828735352f,
0.10412163287401199341f,0.99424046277999877930f,0.10717242211103439331f,
0.99390697479248046875f,0.11022220551967620850f,0.99356412887573242188f,
0.11327095329761505127f,0.99321192502975463867f,0.11631862819194793701f,
0.99285042285919189453f,0.11936521530151367188f,0.99247956275939941406f,
0.12241067737340927124f,0.99209928512573242188f,0.12545497715473175049f,
0.99170976877212524414f,0.12849810719490051270f,0.99131083488464355469f,
0.13154003024101257324f,0.99090266227722167969f,0.13458070158958435059f,
0.99048507213592529297f,0.13762012124061584473f,0.99005818367004394531f,
0.14065824449062347412f,0.98962199687957763672f,0.14369502663612365723f,
0.98917651176452636719f,0.14673046767711639404f,0.98872166872024536133f,
0.14976453781127929688f,0.98825758695602416992f,0.15279719233512878418f,
0.98778414726257324219f,0.15582840144634246826f,0.98730140924453735352f,
0.15885815024375915527f,0.98680937290191650391f,0.16188639402389526367f,
0.98630809783935546875f,0.16491311788558959961f,0.98579752445220947266f,
0.16793829202651977539f,0.98527765274047851562f,0.17096188664436340332f,
0.98474848270416259766f,0.17398387193679809570f,0.98421007394790649414f,
0.17700421810150146484f,0.98366242647171020508f,0.18002289533615112305f,
0.98310548067092895508f,0.18303988873958587646f,0.98253929615020751953f,
0.18605515360832214355f,0.98196387290954589844f,0.18906866014003753662f,
0.98137921094894409180f,0.19208039343357086182f,0.98078525066375732422f,
0.19509032368659973145f,0.98018211126327514648f,0.19809840619564056396f,
0.97956979274749755859f,0.20110464096069335938f,0.97894817590713500977f,
0.20410896837711334229f,0.97831737995147705078f,0.20711137354373931885f,
0.97767734527587890625f,0.21011184155941009521f,0.97702813148498535156f,
0.21311031281948089600f,0.97636973857879638672f,0.21610680222511291504f,
0.97570210695266723633f,0.21910123527050018311f,0.97502535581588745117f,
0.22209362685680389404f,0.97433936595916748047f,0.22508391737937927246f,
0.97364425659179687500f,0.22807207703590393066f,0.97293996810913085938f,
0.23105810582637786865f,0.97222650051116943359f,0.23404195904731750488f,
0.97150391340255737305f,0.23702360689640045166f,0.97077214717864990234f,
0.24000301957130432129f,0.97003126144409179688f,0.24298018217086791992f,
0.96928125619888305664f,0.24595504999160766602f,0.96852207183837890625f,
0.24892760813236236572f,0.96775382757186889648f,0.25189781188964843750f,
0.96697646379470825195f,0.25486564636230468750f,0.96618998050689697266f,
0.25783109664916992188f,0.96539443731307983398f,0.26079410314559936523f,
0.96458977460861206055f,0.26375466585159301758f,0.96377605199813842773f,
0.26671275496482849121f,0.96295326948165893555f,0.26966831088066101074f,
0.96212142705917358398f,0.27262136340141296387f,0.96128046512603759766f,
0.27557182312011718750f,0.96043050289154052734f,0.27851969003677368164f,
0.95957154035568237305f,0.28146493434906005859f,0.95870345830917358398f,
0.28440752625465393066f,0.95782643556594848633f,0.28734746575355529785f,
0.95694035291671752930f,0.29028466343879699707f,0.95604526996612548828f,
0.29321914911270141602f,0.95514118671417236328f,0.29615089297294616699f,
0.95422810316085815430f,0.29907983541488647461f,0.95330601930618286133f,
0.30200594663619995117f,0.95237499475479125977f,0.30492922663688659668f,
0.95143502950668334961f,0.30784964561462402344f,0.95048606395721435547f,
0.31076714396476745605f,0.94952815771102905273f,0.31368175148963928223f,
0.94856137037277221680f,0.31659337878227233887f,0.94758558273315429688f,
0.31950202584266662598f,0.94660091400146484375f,0.32240769267082214355f,
0.94560730457305908203f,0.32531028985977172852f,0.94460481405258178711f,
0.32820984721183776855f,0.94359344244003295898f,0.33110630512237548828f,
0.94257318973541259766f,0.33399966359138488770f,0.94154405593872070312f,
0.33688986301422119141f,0.94050604104995727539f,0.33977687358856201172f,
0.93945920467376708984f,0.34266072511672973633f,0.93840354681015014648f,
0.34554132819175720215f,0.93733900785446166992f,0.34841868281364440918f,
0.93626564741134643555f,0.35129275918006896973f,0.93518352508544921875f,
0.35416352748870849609f,0.93409252166748046875f,0.35703095793724060059f,
0.93299281597137451172f,0.35989505052566528320f,0.93188428878784179688f,
0.36275571584701538086f,0.93076694011688232422f,0.36561298370361328125f,
0.92964088916778564453f,0.36846682429313659668f,0.92850607633590698242f,
0.37131720781326293945f,0.92736250162124633789f,0.37416407465934753418f,
0.92621022462844848633f,0.37700742483139038086f,0.92504924535751342773f,
0.37984719872474670410f,0.92387950420379638672f,0.38268342614173889160f,
0.92270112037658691406f,0.38551604747772216797f,0.92151403427124023438f,
0.38834503293037414551f,0.92031830549240112305f,0.39117038249969482422f,
0.91911387443542480469f,0.39399203658103942871f,0.91790080070495605469f,
0.39680999517440795898f,0.91667908430099487305f,0.39962419867515563965f,
0.91544872522354125977f,0.40243464708328247070f,0.91420978307723999023f,
0.40524131059646606445f,0.91296219825744628906f,0.40804415941238403320f,
0.91170603036880493164f,0.41084316372871398926f,0.91044127941131591797f,
0.41363832354545593262f,0.90916800498962402344f,0.41642954945564270020f,
0.90788608789443969727f,0.41921690106391906738f,0.90659570693969726562f,
0.42200025916099548340f,0.90529674291610717773f,0.42477968335151672363f,
0.90398931503295898438f,0.42755508422851562500f,0.90267330408096313477f,
0.43032649159431457520f,0.90134882926940917969f,0.43309381604194641113f,
0.90001589059829711914f,0.43585708737373352051f,0.89867448806762695312f,
0.43861624598503112793f,0.89732456207275390625f,0.44137126207351684570f,
0.89596623182296752930f,0.44412213563919067383f,0.89459949731826782227f,
0.44686883687973022461f,0.89322429895401000977f,0.44961133599281311035f,
0.89184069633483886719f,0.45234957337379455566f,0.89044874906539916992f,
0.45508357882499694824f,0.88904833793640136719f,0.45781329274177551270f,
0.88763964176177978516f,0.46053871512413024902f,0.88622254133224487305f,
0.46325978636741638184f,0.88479709625244140625f,0.46597650647163391113f,
0.88336336612701416016f,0.46868881583213806152f,0.88192129135131835938f,
0.47139674425125122070f,0.88047087192535400391f,0.47410020232200622559f,
0.87901222705841064453f,0.47679921984672546387f,0.87754529714584350586f,
0.47949376702308654785f,0.87607008218765258789f,0.48218378424644470215f,
0.87458664178848266602f,0.48486924171447753906f,0.87309497594833374023f,
0.48755016922950744629f,0.87159508466720581055f,0.49022647738456726074f,
0.87008696794509887695f,0.49289819598197937012f,0.86857068538665771484f,
0.49556526541709899902f,0.86704623699188232422f,0.49822765588760375977f,
0.86551362276077270508f,0.50088536739349365234f,0.86397284269332885742f,
0.50353837013244628906f,0.86242395639419555664f,0.50618666410446166992f,
0.86086696386337280273f,0.50883013010025024414f,0.85930180549621582031f,
0.51146882772445678711f,0.85772860050201416016f,0.51410275697708129883f,
0.85614734888076782227f,0.51673179864883422852f,0.85455799102783203125f,
0.51935601234436035156f,0.85296058654785156250f,0.52197527885437011719f,
0.85135519504547119141f,0.52458965778350830078f,0.84974175691604614258f,
0.52719914913177490234f,0.84812033176422119141f,0.52980363368988037109f,
0.84649091958999633789f,0.53240311145782470703f,0.84485357999801635742f,
0.53499764204025268555f,0.84320825338363647461f,0.53758704662322998047f,
0.84155499935150146484f,0.54017144441604614258f,0.83989381790161132812f,
0.54275077581405639648f,0.83822470903396606445f,0.54532498121261596680f,
0.83654773235321044922f,0.54789406061172485352f,0.83486288785934448242f,
0.55045795440673828125f,0.83317017555236816406f,0.55301672220230102539f,
0.83146959543228149414f,0.55557024478912353516f,0.82976120710372924805f,
0.55811852216720581055f,0.82804507017135620117f,0.56066155433654785156f,
0.82632106542587280273f,0.56319934129714965820f,0.82458931207656860352f,
0.56573182344436645508f,0.82284981012344360352f,0.56825894117355346680f,
0.82110249996185302734f,0.57078075408935546875f,0.81934750080108642578f,
0.57329714298248291016f,0.81758481264114379883f,0.57580816745758056641f,
0.81581443548202514648f,0.57831376791000366211f,0.81403630971908569336f,
0.58081394433975219727f,0.81225061416625976562f,0.58330863714218139648f,
0.81045717000961303711f,0.58579784631729125977f,0.80865615606307983398f,
0.58828157186508178711f,0.80684757232666015625f,0.59075969457626342773f,
0.80503135919570922852f,0.59323227405548095703f,0.80320751667022705078f,
0.59569931030273437500f,0.80137616395950317383f,0.59816068410873413086f,
0.79953724145889282227f,0.60061645507812500000f,0.79769086837768554688f,
0.60306662321090698242f,0.79583692550659179688f,0.60551106929779052734f,
0.79397547245025634766f,0.60794979333877563477f,0.79210656881332397461f,
0.61038279533386230469f,0.79023021459579467773f,0.61281007528305053711f,
0.78834640979766845703f,0.61523157358169555664f,0.78645521402359008789f,
0.61764729022979736328f,0.78455656766891479492f,0.62005722522735595703f,
0.78265058994293212891f,0.62246125936508178711f,0.78073722124099731445f,
0.62485951185226440430f,0.77881652116775512695f,0.62725180387496948242f,
0.77688848972320556641f,0.62963825464248657227f,0.77495312690734863281f,
0.63201874494552612305f,0.77301043272018432617f,0.63439327478408813477f,
0.77106052637100219727f,0.63676184415817260742f,0.76910334825515747070f,
0.63912445306777954102f,0.76713889837265014648f,0.64148104190826416016f,
0.76516723632812500000f,0.64383155107498168945f,0.76318842172622680664f,
0.64617604017257690430f,0.76120239496231079102f,0.64851438999176025391f,
0.75920921564102172852f,0.65084666013717651367f,0.75720882415771484375f,
0.65317285060882568359f,0.75520139932632446289f,0.65549284219741821289f,
0.75318682193756103516f,0.65780669450759887695f,0.75116515159606933594f,
0.66011434793472290039f,0.74913638830184936523f,0.66241580247879028320f,
0.74710059165954589844f,0.66471099853515625000f,0.74505776166915893555f,
0.66699993610382080078f,0.74300795793533325195f,0.66928261518478393555f,
0.74095112085342407227f,0.67155897617340087891f,0.73888731002807617188f,
0.67382901906967163086f,0.73681658506393432617f,0.67609268426895141602f,
0.73473888635635375977f,0.67835003137588500977f,0.73265427350997924805f,
0.68060100078582763672f,0.73056274652481079102f,0.68284553289413452148f,
0.72846436500549316406f,0.68508368730545043945f,0.72635912895202636719f,
0.68731534481048583984f,0.72424709796905517578f,0.68954056501388549805f,
0.72212821245193481445f,0.69175922870635986328f,0.72000253200531005859f,
0.69397145509719848633f,0.71787005662918090820f,0.69617712497711181641f,
0.71573084592819213867f,0.69837623834609985352f,0.71358484029769897461f,
0.70056879520416259766f,0.71143221855163574219f,0.70275473594665527344f,
0.70927280187606811523f,0.70493406057357788086f,0.70710676908493041992f,
0.70710676908493041992f,0.70493406057357788086f,0.70927280187606811523f,
0.70275473594665527344f,0.71143221855163574219f,0.70056879520416259766f,
0.71358484029769897461f,0.69837623834609985352f,0.71573084592819213867f,
0.69617712497711181641f,0.71787005662918090820f,0.69397145509719848633f,
0.72000253200531005859f,0.69175922870635986328f,0.72212821245193481445f,
0.68954056501388549805f,0.72424709796905517578f,0.68731534481048583984f,
0.72635912895202636719f,0.68508368730545043945f,0.72846436500549316406f,
0.68284553289413452148f,0.73056274652481079102f,0.68060100078582763672f,
0.73265427350997924805f,0.67835003137588500977f,0.73473888635635375977f,
0.67609268426895141602f,0.73681658506393432617f,0.67382901906967163086f,
0.73888731002807617188f,0.67155897617340087891f,0.74095112085342407227f,
0.66928261518478393555f,0.74300795793533325195f,0.66699993610382080078f,
0.74505776166915893555f,0.66471099853515625000f,0.74710059165954589844f,
0.66241580247879028320f,0.74913638830184936523f,0.66011434793472290039f,
0.75116515159606933594f,0.65780669450759887695f,0.75318682193756103516f,
0.65549284219741821289f,0.75520139932632446289f,0.65317285060882568359f,
0.75720882415771484375f,0.65084666013717651367f,0.75920921564102172852f,
0.64851438999176025391f,0.76120239496231079102f,0.64617604017257690430f,
0.76318842172622680664f,0.64383155107498168945f,0.76516723632812500000f,
0.64148104190826416016f,0.76713889837265014648f,0.63912445306777954102f,
0.76910334825515747070f,0.63676184415817260742f,0.77106052637100219727f,
0.63439327478408813477f,0.77301043272018432617f,0.63201874494552612305f,
0.77495312690734863281f,0.62963825464248657227f,0.77688848972320556641f,
0.62725180387496948242f,0.77881652116775512695f,0.62485951185226440430f,
0.78073722124099731445f,0.62246125936508178711f,0.78265058994293212891f,
0.62005722522735595703f,0.78455656766891479492f,0.61764729022979736328f,
0.78645521402359008789f,0.61523157358169555664f,0.78834640979766845703f,
0.61281007528305053711f,0.79023021459579467773f,0.61038279533386230469f,
0.79210656881332397461f,0.60794979333877563477f,0.79397547245025634766f,
0.60551106929779052734f,0.79583692550659179688f,0.60306662321090698242f,
0.79769086837768554688f,0.60061645507812500000f,0.79953724145889282227f,
0.59816068410873413086f,0.80137616395950317383f,0.59569931030273437500f,
0.80320751667022705078f,0.59323227405548095703f,0.80503135919570922852f,
0.59075969457626342773f,0.80684757232666015625f,0.58828157186508178711f,
0.80865615606307983398f,0.58579784631729125977f,0.81045717000961303711f,
0.58330863714218139648f,0.81225061416625976562f,0.58081394433975219727f,
0.81403630971908569336f,0.57831376791000366211f,0.81581443548202514648f,
0.57580816745758056641f,0.81758481264114379883f,0.57329714298248291016f,
0.81934750080108642578f,0.57078075408935546875f,0.82110249996185302734f,
0.56825894117355346680f,0.82284981012344360352f,0.56573182344436645508f,
0.82458931207656860352f,0.56319934129714965820f,0.82632106542587280273f,
0.56066155433654785156f,0.82804507017135620117f,0.55811852216720581055f,
0.82976120710372924805f,0.55557024478912353516f,0.83146959543228149414f,
0.55301672220230102539f,0.83317017555236816406f,0.55045795440673828125f,
0.83486288785934448242f,0.54789406061172485352f,0.83654773235321044922f,
0.54532498121261596680f,0.83822470903396606445f,0.54275077581405639648f,
0.83989381790161132812f,0.54017144441604614258f,0.84155499935150146484f,
0.53758704662322998047f,0.84320825338363647461f,0.53499764204025268555f,
0.84485357999801635742f,0.53240311145782470703f,0.84649091958999633789f,
0.52980363368988037109f,0.84812033176422119141f,0.52719914913177490234f,
0.84974175691604614258f,0.52458965778350830078f,0.85135519504547119141f,
0.52197527885437011719f,0.85296058654785156250f,0.51935601234436035156f,
0.85455799102783203125f,0.51673179864883422852f,0.85614734888076782227f,
0.51410275697708129883f,0.85772860050201416016f,0.51146882772445678711f,
0.85930180549621582031f,0.50883013010025024414f,0.86086696386337280273f,
0.50618666410446166992f,0.86242395639419555664f,0.50353837013244628906f,
0.86397284269332885742f,0.50088536739349365234f,0.86551362276077270508f,
0.49822765588760375977f,0.86704623699188232422f,0.49556526541709899902f,
0.86857068538665771484f,0.49289819598197937012f,0.87008696794509887695f,
0.49022647738456726074f,0.87159508466720581055f,0.48755016922950744629f,
0.87309497594833374023f,0.48486924171447753906f,0.87458664178848266602f,
0.48218378424644470215f,0.87607008218765258789f,0.47949376702308654785f,
0.87754529714584350586f,0.47679921984672546387f,0.87901222705841064453f,
0.47410020232200622559f,0.88047087192535400391f,0.47139674425125122070f,
0.88192129135131835938f,0.46868881583213806152f,0.88336336612701416016f,
0.46597650647163391113f,0.88479709625244140625f,0.46325978636741638184f,
0.88622254133224487305f,0.46053871512413024902f,0.88763964176177978516f,
0.45781329274177551270f,0.88904833793640136719f,0.45508357882499694824f,
0.89044874906539916992f,0.45234957337379455566f,0.89184069633483886719f,
0.44961133599281311035f,0.89322429895401000977f,0.44686883687973022461f,
0.89459949731826782227f,0.44412213563919067383f,0.89596623182296752930f,
0.44137126207351684570f,0.89732456207275390625f,0.43861624598503112793f,
0.89867448806762695312f,0.43585708737373352051f,0.90001589059829711914f,
0.43309381604194641113f,0.90134882926940917969f,0.43032649159431457520f,
0.90267330408096313477f,0.42755508422851562500f,0.90398931503295898438f,
0.42477968335151672363f,0.90529674291610717773f,0.42200025916099548340f,
0.90659570693969726562f,0.41921690106391906738f,0.90788608789443969727f,
0.41642954945564270020f,0.90916800498962402344f,0.41363832354545593262f,
0.91044127941131591797f,0.41084316372871398926f,0.91170603036880493164f,
0.40804415941238403320f,0.91296219825744628906f,0.40524131059646606445f,
0.91420978307723999023f,0.40243464708328247070f,0.91544872522354125977f,
0.39962419867515563965f,0.91667908430099487305f,0.39680999517440795898f,
0.91790080070495605469f,0.39399203658103942871f,0.91911387443542480469f,
0.39117038249969482422f,0.92031830549240112305f,0.38834503293037414551f,
0.92151403427124023438f,0.38551604747772216797f,0.92270112037658691406f,
0.38268342614173889160f,0.92387950420379638672f,0.37984719872474670410f,
0.92504924535751342773f,0.37700742483139038086f,0.92621022462844848633f,
0.37416407465934753418f,0.92736250162124633789f,0.37131720781326293945f,
0.92850607633590698242f,0.36846682429313659668f,0.92964088916778564453f,
0.36561298370361328125f,0.93076694011688232422f,0.36275571584701538086f,
0.93188428878784179688f,0.35989505052566528320f,0.93299281597137451172f,
0.35703095793724060059f,0.93409252166748046875f,0.35416352748870849609f,
0.93518352508544921875f,0.35129275918006896973f,0.93626564741134643555f,
0.34841868281364440918f,0.93733900785446166992f,0.34554132819175720215f,
0.93840354681015014648f,0.34266072511672973633f,0.93945920467376708984f,
0.33977687358856201172f,0.94050604104995727539f,0.33688986301422119141f,
0.94154405593872070312f,0.33399966359138488770f,0.94257318973541259766f,
0.33110630512237548828f,0.94359344244003295898f,0.32820984721183776855f,
0.94460481405258178711f,0.32531028985977172852f,0.94560730457305908203f,
0.32240769267082214355f,0.94660091400146484375f,0.31950202584266662598f,
0.94758558273315429688f,0.31659337878227233887f,0.94856137037277221680f,
0.31368175148963928223f,0.94952815771102905273f,0.31076714396476745605f,
0.95048606395721435547f,0.30784964561462402344f,0.95143502950668334961f,
0.30492922663688659668f,0.95237499475479125977f,0.30200594663619995117f,
0.95330601930618286133f,0.29907983541488647461f,0.95422810316085815430f,
0.29615089297294616699f,0.95514118671417236328f,0.29321914911270141602f,
0.95604526996612548828f,0.29028466343879699707f,0.95694035291671752930f,
0.28734746575355529785f,0.95782643556594848633f,0.28440752625465393066f,
0.95870345830917358398f,0.28146493434906005859f,0.95957154035568237305f,
0.27851969003677368164f,0.96043050289154052734f,0.27557182312011718750f,
0.96128046512603759766f,0.27262136340141296387f,0.96212142705917358398f,
0.26966831088066101074f,0.96295326948165893555f,0.26671275496482849121f,
0.96377605199813842773f,0.26375466585159301758f,0.96458977460861206055f,
0.26079410314559936523f,0.96539443731307983398f,0.25783109664916992188f,
0.96618998050689697266f,0.25486564636230468750f,0.96697646379470825195f,
0.25189781188964843750f,0.96775382757186889648f,0.24892760813236236572f,
0.96852207183837890625f,0.24595504999160766602f,0.96928125619888305664f,
0.24298018217086791992f,0.97003126144409179688f,0.24000301957130432129f,
0.97077214717864990234f,0.23702360689640045166f,0.97150391340255737305f,
0.23404195904731750488f,0.97222650051116943359f,0.23105810582637786865f,
0.97293996810913085938f,0.22807207703590393066f,0.97364425659179687500f,
0.22508391737937927246f,0.97433936595916748047f,0.22209362685680389404f,
0.97502535581588745117f,0.21910123527050018311f,0.97570210695266723633f,
0.21610680222511291504f,0.97636973857879638672f,0.21311031281948089600f,
0.97702813148498535156f,0.21011184155941009521f,0.97767734527587890625f,
0.20711137354373931885f,0.97831737995147705078f,0.20410896837711334229f,
0.97894817590713500977f,0.20110464096069335938f,0.97956979274749755859f,
0.19809840619564056396f,0.98018211126327514648f,0.19509032368659973145f,
0.98078525066375732422f,0.19208039343357086182f,0.98137921094894409180f,
0.18906866014003753662f,0.98196387290954589844f,0.18605515360832214355f,
0.98253929615020751953f,0.18303988873958587646f,0.98310548067092895508f,
0.18002289533615112305f,0.98366242647171020508f,0.17700421810150146484f,
0.98421007394790649414f,0.17398387193679809570f,0.98474848270416259766f,
0.17096188664436340332f,0.98527765274047851562f,0.16793829202651977539f,
0.98579752445220947266f,0.16491311788558959961f,0.98630809783935546875f,
0.16188639402389526367f,0.98680937290191650391f,0.15885815024375915527f,
0.98730140924453735352f,0.15582840144634246826f,0.98778414726257324219f,
0.15279719233512878418f,0.98825758695602416992f,0.14976453781127929688f,
0.98872166872024536133f,0.14673046767711639404f,0.98917651176452636719f,
0.14369502663612365723f,0.98962199687957763672f,0.14065824449062347412f,
0.99005818367004394531f,0.13762012124061584473f,0.99048507213592529297f,
0.13458070158958435059f,0.99090266227722167969f,0.13154003024101257324f,
0.99131083488464355469f,0.12849810719490051270f,0.99170976877212524414f,
0.12545497715473175049f,0.99209928512573242188f,0.12241067737340927124f,
0.99247956275939941406f,0.11936521530151367188f,0.99285042285919189453f,
0.11631862819194793701f,0.99321192502975463867f,0.11327095329761505127f,
0.99356412887573242188f,0.11022220551967620850f,0.99390697479248046875f,
0.10717242211103439331f,0.99424046277999877930f,0.10412163287401199341f,
0.99456459283828735352f,0.10106986016035079956f,0.99487930536270141602f,
0.09801714122295379639f,0.99518471956253051758f,0.09496349841356277466f,
0.99548077583312988281f,0.09190895408391952515f,0.99576741456985473633f,
0.08885355293750762939f,0.99604469537734985352f,0.08579730987548828125f,
0.99631261825561523438f,0.08274026215076446533f,0.99657112360000610352f,
0.07968243956565856934f,0.99682027101516723633f,0.07662386447191238403f,
0.99706006050109863281f,0.07356456667184829712f,0.99729043245315551758f,
0.07050457596778869629f,0.99751144647598266602f,0.06744392216205596924f,
0.99772304296493530273f,0.06438262760639190674f,0.99792528152465820312f,
0.06132073700428009033f,0.99811810255050659180f,0.05825826525688171387f,
0.99830156564712524414f,0.05519524589180946350f,0.99847555160522460938f,
0.05213170498609542847f,0.99864023923873901367f,0.04906767606735229492f,
0.99879544973373413086f,0.04600318148732185364f,0.99894130229949951172f,
0.04293825849890708923f,0.99907773733139038086f,0.03987292572855949402f,
0.99920475482940673828f,0.03680722415447235107f,0.99932235479354858398f,
0.03374117240309715271f,0.99943059682846069336f,0.03067480400204658508f,
0.99952942132949829102f,0.02760814502835273743f,0.99961882829666137695f,
0.02454122900962829590f,0.99969881772994995117f,0.02147408016026020050f,
0.99976938962936401367f,0.01840673014521598816f,0.99983060359954833984f,
0.01533920597285032272f,0.99988234043121337891f,0.01227153837680816650f,
0.99992471933364868164f,0.00920375436544418335f,0.99995762109756469727f,
0.00613588467240333557f,0.99998116493225097656f,0.00306795677170157433f,
0.99999529123306274414f,0.00000000000000006123f,1.00000000000000000000f,
-0.00306795677170157433f,0.99999529123306274414f,-0.00613588467240333557f,
0.99998116493225097656f,-0.00920375436544418335f,0.99995762109756469727f,
-0.01227153837680816650f,0.99992471933364868164f,-0.01533920597285032272f,
0.99988234043121337891f,-0.01840673014521598816f,0.99983060359954833984f,
-0.02147408016026020050f,0.99976938962936401367f,-0.02454122900962829590f,
0.99969881772994995117f,-0.02760814502835273743f,0.99961882829666137695f,
-0.03067480400204658508f,0.99952942132949829102f,-0.03374117240309715271f,
0.99943059682846069336f,-0.03680722415447235107f,0.99932235479354858398f,
-0.03987292572855949402f,0.99920475482940673828f,-0.04293825849890708923f,
0.99907773733139038086f,-0.04600318148732185364f,0.99894130229949951172f,
-0.04906767606735229492f,0.99879544973373413086f,-0.05213170498609542847f,
0.99864023923873901367f,-0.05519524589180946350f,0.99847555160522460938f,
-0.05825826525688171387f,0.99830156564712524414f,-0.06132073700428009033f,
0.99811810255050659180f,-0.06438262760639190674f,0.99792528152465820312f,
-0.06744392216205596924f,0.99772304296493530273f,-0.07050457596778869629f,
0.99751144647598266602f,-0.07356456667184829712f,0.99729043245315551758f,
-0.07662386447191238403f,0.99706006050109863281f,-0.07968243956565856934f,
0.99682027101516723633f,-0.08274026215076446533f,0.99657112360000610352f,
-0.08579730987548828125f,0.99631261825561523438f,-0.08885355293750762939f,
0.99604469537734985352f,-0.09190895408391952515f,0.99576741456985473633f,
-0.09496349841356277466f,0.99548077583312988281f,-0.09801714122295379639f,
0.99518471956253051758f,-0.10106986016035079956f,0.99487930536270141602f,
-0.10412163287401199341f,0.99456459283828735352f,-0.10717242211103439331f,
0.99424046277999877930f,-0.11022220551967620850f,0.99390697479248046875f,
-0.11327095329761505127f,0.99356412887573242188f,-0.11631862819194793701f,
0.99321192502975463867f,-0.11936521530151367188f,0.99285042285919189453f,
-0.12241067737340927124f,0.99247956275939941406f,-0.12545497715473175049f,
0.99209928512573242188f,-0.12849810719490051270f,0.99170976877212524414f,
-0.13154003024101257324f,0.99131083488464355469f,-0.13458070158958435059f,
0.99090266227722167969f,-0.13762012124061584473f,0.99048507213592529297f,
-0.14065824449062347412f,0.99005818367004394531f,-0.14369502663612365723f,
0.98962199687957763672f,-0.14673046767711639404f,0.98917651176452636719f,
-0.14976453781127929688f,0.98872166872024536133f,-0.15279719233512878418f,
0.98825758695602416992f,-0.15582840144634246826f,0.98778414726257324219f,
-0.15885815024375915527f,0.98730140924453735352f,-0.16188639402389526367f,
0.98680937290191650391f,-0.16491311788558959961f,0.98630809783935546875f,
-0.16793829202651977539f,0.98579752445220947266f,-0.17096188664436340332f,
0.98527765274047851562f,-0.17398387193679809570f,0.98474848270416259766f,
-0.17700421810150146484f,0.98421007394790649414f,-0.18002289533615112305f,
0.98366242647171020508f,-0.18303988873958587646f,0.98310548067092895508f,
-0.18605515360832214355f,0.98253929615020751953f,-0.18906866014003753662f,
0.98196387290954589844f,-0.19208039343357086182f,0.98137921094894409180f,
-0.19509032368659973145f,0.98078525066375732422f,-0.19809840619564056396f,
0.98018211126327514648f,-0.20110464096069335938f,0.97956979274749755859f,
-0.20410896837711334229f,0.97894817590713500977f,-0.20711137354373931885f,
0.97831737995147705078f,-0.21011184155941009521f,0.97767734527587890625f,
-0.21311031281948089600f,0.97702813148498535156f,-0.21610680222511291504f,
0.97636973857879638672f,-0.21910123527050018311f,0.97570210695266723633f,
-0.22209362685680389404f,0.97502535581588745117f,-0.22508391737937927246f,
0.97433936595916748047f,-0.22807207703590393066f,0.97364425659179687500f,
-0.23105810582637786865f,0.97293996810913085938f,-0.23404195904731750488f,
0.97222650051116943359f,-0.23702360689640045166f,0.97150391340255737305f,
-0.24000301957130432129f,0.97077214717864990234f,-0.24298018217086791992f,
0.97003126144409179688f,-0.24595504999160766602f,0.96928125619888305664f,
-0.24892760813236236572f,0.96852207183837890625f,-0.25189781188964843750f,
0.96775382757186889648f,-0.25486564636230468750f,0.96697646379470825195f,
-0.25783109664916992188f,0.96618998050689697266f,-0.26079410314559936523f,
0.96539443731307983398f,-0.26375466585159301758f,0.96458977460861206055f,
-0.26671275496482849121f,0.96377605199813842773f,-0.26966831088066101074f,
0.96295326948165893555f,-0.27262136340141296387f,0.96212142705917358398f,
-0.27557182312011718750f,0.96128046512603759766f,-0.27851969003677368164f,
0.96043050289154052734f,-0.28146493434906005859f,0.95957154035568237305f,
-0.28440752625465393066f,0.95870345830917358398f,-0.28734746575355529785f,
0.95782643556594848633f,-0.29028466343879699707f,0.95694035291671752930f,
-0.29321914911270141602f,0.95604526996612548828f,-0.29615089297294616699f,
0.95514118671417236328f,-0.29907983541488647461f,0.95422810316085815430f,
-0.30200594663619995117f,0.95330601930618286133f,-0.30492922663688659668f,
0.95237499475479125977f,-0.30784964561462402344f,0.95143502950668334961f,
-0.31076714396476745605f,0.95048606395721435547f,-0.31368175148963928223f,
0.94952815771102905273f,-0.31659337878227233887f,0.94856137037277221680f,
-0.31950202584266662598f,0.94758558273315429688f,-0.32240769267082214355f,
0.94660091400146484375f,-0.32531028985977172852f,0.94560730457305908203f,
-0.32820984721183776855f,0.94460481405258178711f,-0.33110630512237548828f,
0.94359344244003295898f,-0.33399966359138488770f,0.94257318973541259766f,
-0.33688986301422119141f,0.94154405593872070312f,-0.33977687358856201172f,
0.94050604104995727539f,-0.34266072511672973633f,0.93945920467376708984f,
-0.34554132819175720215f,0.93840354681015014648f,-0.34841868281364440918f,
0.93733900785446166992f,-0.35129275918006896973f,0.93626564741134643555f,
-0.35416352748870849609f,0.93518352508544921875f,-0.35703095793724060059f,
0.93409252166748046875f,-0.35989505052566528320f,0.93299281597137451172f,
-0.36275571584701538086f,0.93188428878784179688f,-0.36561298370361328125f,
0.93076694011688232422f,-0.36846682429313659668f,0.92964088916778564453f,
-0.37131720781326293945f,0.92850607633590698242f,-0.37416407465934753418f,
0.92736250162124633789f,-0.37700742483139038086f,0.92621022462844848633f,
-0.37984719872474670410f,0.92504924535751342773f,-0.38268342614173889160f,
0.92387950420379638672f,-0.38551604747772216797f,0.92270112037658691406f,
-0.38834503293037414551f,0.92151403427124023438f,-0.39117038249969482422f,
0.92031830549240112305f,-0.39399203658103942871f,0.91911387443542480469f,
-0.39680999517440795898f,0.91790080070495605469f,-0.39962419867515563965f,
0.91667908430099487305f,-0.40243464708328247070f,0.91544872522354125977f,
-0.40524131059646606445f,0.91420978307723999023f,-0.40804415941238403320f,
0.91296219825744628906f,-0.41084316372871398926f,0.91170603036880493164f,
-0.41363832354545593262f,0.91044127941131591797f,-0.41642954945564270020f,
0.90916800498962402344f,-0.41921690106391906738f,0.90788608789443969727f,
-0.42200025916099548340f,0.90659570693969726562f,-0.42477968335151672363f,
0.90529674291610717773f,-0.42755508422851562500f,0.90398931503295898438f,
-0.43032649159431457520f,0.90267330408096313477f,-0.43309381604194641113f,
0.90134882926940917969f,-0.43585708737373352051f,0.90001589059829711914f,
-0.43861624598503112793f,0.89867448806762695312f,-0.44137126207351684570f,
0.89732456207275390625f,-0.44412213563919067383f,0.89596623182296752930f,
-0.44686883687973022461f,0.89459949731826782227f,-0.44961133599281311035f,
0.89322429895401000977f,-0.45234957337379455566f,0.89184069633483886719f,
-0.45508357882499694824f,0.89044874906539916992f,-0.45781329274177551270f,
0.88904833793640136719f,-0.46053871512413024902f,0.88763964176177978516f,
-0.46325978636741638184f,0.88622254133224487305f,-0.46597650647163391113f,
0.88479709625244140625f,-0.46868881583213806152f,0.88336336612701416016f,
-0.47139674425125122070f,0.88192129135131835938f,-0.47410020232200622559f,
0.88047087192535400391f,-0.47679921984672546387f,0.87901222705841064453f,
-0.47949376702308654785f,0.87754529714584350586f,-0.48218378424644470215f,
0.87607008218765258789f,-0.48486924171447753906f,0.87458664178848266602f,
-0.48755016922950744629f,0.87309497594833374023f,-0.49022647738456726074f,
0.87159508466720581055f,-0.49289819598197937012f,0.87008696794509887695f,
-0.49556526541709899902f,0.86857068538665771484f,-0.49822765588760375977f,
0.86704623699188232422f,-0.50088536739349365234f,0.86551362276077270508f,
-0.50353837013244628906f,0.86397284269332885742f,-0.50618666410446166992f,
0.86242395639419555664f,-0.50883013010025024414f,0.86086696386337280273f,
-0.51146882772445678711f,0.85930180549621582031f,-0.51410275697708129883f,
0.85772860050201416016f,-0.51673179864883422852f,0.85614734888076782227f,
-0.51935601234436035156f,0.85455799102783203125f,-0.52197527885437011719f,
0.85296058654785156250f,-0.52458965778350830078f,0.85135519504547119141f,
-0.52719914913177490234f,0.84974175691604614258f,-0.52980363368988037109f,
0.84812033176422119141f,-0.53240311145782470703f,0.84649091958999633789f,
-0.53499764204025268555f,0.84485357999801635742f,-0.53758704662322998047f,
0.84320825338363647461f,-0.54017144441604614258f,0.84155499935150146484f,
-0.54275077581405639648f,0.83989381790161132812f,-0.54532498121261596680f,
0.83822470903396606445f,-0.54789406061172485352f,0.83654773235321044922f,
-0.55045795440673828125f,0.83486288785934448242f,-0.55301672220230102539f,
0.83317017555236816406f,-0.55557024478912353516f,0.83146959543228149414f,
-0.55811852216720581055f,0.82976120710372924805f,-0.56066155433654785156f,
0.82804507017135620117f,-0.56319934129714965820f,0.82632106542587280273f,
-0.56573182344436645508f,0.82458931207656860352f,-0.56825894117355346680f,
0.82284981012344360352f,-0.57078075408935546875f,0.82110249996185302734f,
-0.57329714298248291016f,0.81934750080108642578f,-0.57580816745758056641f,
0.81758481264114379883f,-0.57831376791000366211f,0.81581443548202514648f,
-0.58081394433975219727f,0.81403630971908569336f,-0.58330863714218139648f,
0.81225061416625976562f,-0.58579784631729125977f,0.81045717000961303711f,
-0.58828157186508178711f,0.80865615606307983398f,-0.59075969457626342773f,
0.80684757232666015625f,-0.59323227405548095703f,0.80503135919570922852f,
-0.59569931030273437500f,0.80320751667022705078f,-0.59816068410873413086f,
0.80137616395950317383f,-0.60061645507812500000f,0.79953724145889282227f,
-0.60306662321090698242f,0.79769086837768554688f,-0.60551106929779052734f,
0.79583692550659179688f,-0.60794979333877563477f,0.79397547245025634766f,
-0.61038279533386230469f,0.79210656881332397461f,-0.61281007528305053711f,
0.79023021459579467773f,-0.61523157358169555664f,0.78834640979766845703f,
-0.61764729022979736328f,0.78645521402359008789f,-0.62005722522735595703f,
0.78455656766891479492f,-0.62246125936508178711f,0.78265058994293212891f,
-0.62485951185226440430f,0.78073722124099731445f,-0.62725180387496948242f,
0.77881652116775512695f,-0.62963825464248657227f,0.77688848972320556641f,
-0.63201874494552612305f,0.77495312690734863281f,-0.63439327478408813477f,
0.77301043272018432617f,-0.63676184415817260742f,0.77106052637100219727f,
-0.63912445306777954102f,0.76910334825515747070f,-0.64148104190826416016f,
0.76713889837265014648f,-0.64383155107498168945f,0.76516723632812500000f,
-0.64617604017257690430f,0.76318842172622680664f,-0.64851438999176025391f,
0.76120239496231079102f,-0.65084666013717651367f,0.75920921564102172852f,
-0.65317285060882568359f,0.75720882415771484375f,-0.65549284219741821289f,
0.75520139932632446289f,-0.65780669450759887695f,0.75318682193756103516f,
-0.66011434793472290039f,0.75116515159606933594f,-0.66241580247879028320f,
0.74913638830184936523f,-0.66471099853515625000f,0.74710059165954589844f,
-0.66699993610382080078f,0.74505776166915893555f,-0.66928261518478393555f,
0.74300795793533325195f,-0.67155897617340087891f,0.74095112085342407227f,
-0.67382901906967163086f,0.73888731002807617188f,-0.67609268426895141602f,
0.73681658506393432617f,-0.67835003137588500977f,0.73473888635635375977f,
-0.68060100078582763672f,0.73265427350997924805f,-0.68284553289413452148f,
0.73056274652481079102f,-0.68508368730545043945f,0.72846436500549316406f,
-0.68731534481048583984f,0.72635912895202636719f,-0.68954056501388549805f,
0.72424709796905517578f,-0.69175922870635986328f,0.72212821245193481445f,
-0.69397145509719848633f,0.72000253200531005859f,-0.69617712497711181641f,
0.71787005662918090820f,-0.69837623834609985352f,0.71573084592819213867f,
-0.70056879520416259766f,0.71358484029769897461f,-0.70275473594665527344f,
0.71143221855163574219f,-0.70493406057357788086f,0.70927280187606811523f,
-0.70710676908493041992f,0.70710676908493041992f,-0.70927280187606811523f,
0.70493406057357788086f,-0.71143221855163574219f,0.70275473594665527344f,
-0.71358484029769897461f,0.70056879520416259766f,-0.71573084592819213867f,
0.69837623834609985352f,-0.71787005662918090820f,0.69617712497711181641f,
-0.72000253200531005859f,0.69397145509719848633f,-0.72212821245193481445f,
0.69175922870635986328f,-0.72424709796905517578f,0.68954056501388549805f,
-0.72635912895202636719f,0.68731534481048583984f,-0.72846436500549316406f,
0.68508368730545043945f,-0.73056274652481079102f,0.68284553289413452148f,
-0.73265427350997924805f,0.68060100078582763672f,-0.73473888635635375977f,
0.67835003137588500977f,-0.73681658506393432617f,0.67609268426895141602f,
-0.73888731002807617188f,0.67382901906967163086f,-0.74095112085342407227f,
0.67155897617340087891f,-0.74300795793533325195f,0.66928261518478393555f,
-0.74505776166915893555f,0.66699993610382080078f,-0.74710059165954589844f,
0.66471099853515625000f,-0.74913638830184936523f,0.66241580247879028320f,
-0.75116515159606933594f,0.66011434793472290039f,-0.75318682193756103516f,
0.65780669450759887695f,-0.75520139932632446289f,0.65549284219741821289f,
-0.75720882415771484375f,0.65317285060882568359f,-0.75920921564102172852f,
0.65084666013717651367f,-0.76120239496231079102f,0.64851438999176025391f,
-0.76318842172622680664f,0.64617604017257690430f,-0.76516723632812500000f,
0.64383155107498168945f,-0.76713889837265014648f,0.64148104190826416016f,
-0.76910334825515747070f,0.63912445306777954102f,-0.77106052637100219727f,
0.63676184415817260742f,-0.77301043272018432617f,0.63439327478408813477f,
-0.77495312690734863281f,0.63201874494552612305f,-0.77688848972320556641f,
0.62963825464248657227f,-0.77881652116775512695f,0.62725180387496948242f,
-0.78073722124099731445f,0.62485951185226440430f,-0.78265058994293212891f,
0.62246125936508178711f,-0.78455656766891479492f,0.62005722522735595703f,
-0.78645521402359008789f,0.61764729022979736328f,-0.78834640979766845703f,
0.61523157358169555664f,-0.79023021459579467773f,0.61281007528305053711f,
-0.79210656881332397461f,0.61038279533386230469f,-0.79397547245025634766f,
0.60794979333877563477f,-0.79583692550659179688f,0.60551106929779052734f,
-0.79769086837768554688f,0.60306662321090698242f,-0.79953724145889282227f,
0.60061645507812500000f,-0.80137616395950317383f,0.59816068410873413086f,
-0.80320751667022705078f,0.59569931030273437500f,-0.80503135919570922852f,
0.59323227405548095703f,-0.80684757232666015625f,0.59075969457626342773f,
-0.80865615606307983398f,0.58828157186508178711f,-0.81045717000961303711f,
0.58579784631729125977f,-0.81225061416625976562f,0.58330863714218139648f,
-0.81403630971908569336f,0.58081394433975219727f,-0.81581443548202514648f,
0.57831376791000366211f,-0.81758481264114379883f,0.57580816745758056641f,
-0.81934750080108642578f,0.57329714298248291016f,-0.82110249996185302734f,
0.57078075408935546875f,-0.82284981012344360352f,0.56825894117355346680f,
-0.82458931207656860352f,0.56573182344436645508f,-0.82632106542587280273f,
0.56319934129714965820f,-0.82804507017135620117f,0.56066155433654785156f,
-0.82976120710372924805f,0.55811852216720581055f,-0.83146959543228149414f,
0.55557024478912353516f,-0.83317017555236816406f,0.55301672220230102539f,
-0.83486288785934448242f,0.55045795440673828125f,-0.83654773235321044922f,
0.54789406061172485352f,-0.83822470903396606445f,0.54532498121261596680f,
-0.83989381790161132812f,0.54275077581405639648f,-0.84155499935150146484f,
0.54017144441604614258f,-0.84320825338363647461f,0.53758704662322998047f,
-0.84485357999801635742f,0.53499764204025268555f,-0.84649091958999633789f,
0.53240311145782470703f,-0.84812033176422119141f,0.52980363368988037109f,
-0.84974175691604614258f,0.52719914913177490234f,-0.85135519504547119141f,
0.52458965778350830078f,-0.85296058654785156250f,0.52197527885437011719f,
-0.85455799102783203125f,0.51935601234436035156f,-0.85614734888076782227f,
0.51673179864883422852f,-0.85772860050201416016f,0.51410275697708129883f,
-0.85930180549621582031f,0.51146882772445678711f,-0.86086696386337280273f,
0.50883013010025024414f,-0.86242395639419555664f,0.50618666410446166992f,
-0.86397284269332885742f,0.50353837013244628906f,-0.86551362276077270508f,
0.50088536739349365234f,-0.86704623699188232422f,0.49822765588760375977f,
-0.86857068538665771484f,0.49556526541709899902f,-0.87008696794509887695f,
0.49289819598197937012f,-0.87159508466720581055f,0.49022647738456726074f,
-0.87309497594833374023f,0.48755016922950744629f,-0.87458664178848266602f,
0.48486924171447753906f,-0.87607008218765258789f,0.48218378424644470215f,
-0.87754529714584350586f,0.47949376702308654785f,-0.87901222705841064453f,
0.47679921984672546387f,-0.88047087192535400391f,0.47410020232200622559f,
-0.88192129135131835938f,0.47139674425125122070f,-0.88336336612701416016f,
0.46868881583213806152f,-0.88479709625244140625f,0.46597650647163391113f,
-0.88622254133224487305f,0.46325978636741638184f,-0.88763964176177978516f,
0.46053871512413024902f,-0.88904833793640136719f,0.45781329274177551270f,
-0.89044874906539916992f,0.45508357882499694824f,-0.89184069633483886719f,
0.45234957337379455566f,-0.89322429895401000977f,0.44961133599281311035f,
-0.89459949731826782227f,0.44686883687973022461f,-0.89596623182296752930f,
0.44412213563919067383f,-0.89732456207275390625f,0.44137126207351684570f,
-0.89867448806762695312f,0.43861624598503112793f,-0.90001589059829711914f,
0.43585708737373352051f,-0.90134882926940917969f,0.43309381604194641113f,
-0.90267330408096313477f,0.43032649159431457520f,-0.90398931503295898438f,
0.42755508422851562500f,-0.90529674291610717773f,0.42477968335151672363f,
-0.90659570693969726562f,0.42200025916099548340f,-0.90788608789443969727f,
0.41921690106391906738f,-0.90916800498962402344f,0.41642954945564270020f,
-0.91044127941131591797f,0.41363832354545593262f,-0.91170603036880493164f,
0.41084316372871398926f,-0.91296219825744628906f,0.40804415941238403320f,
-0.91420978307723999023f,0.40524131059646606445f,-0.91544872522354125977f,
0.40243464708328247070f,-0.91667908430099487305f,0.39962419867515563965f,
-0.91790080070495605469f,0.39680999517440795898f,-0.91911387443542480469f,
0.39399203658103942871f,-0.92031830549240112305f,0.39117038249969482422f,
-0.92151403427124023438f,0.38834503293037414551f,-0.92270112037658691406f,
0.38551604747772216797f,-0.92387950420379638672f,0.38268342614173889160f,
-0.92504924535751342773f,0.37984719872474670410f,-0.92621022462844848633f,
0.37700742483139038086f,-0.92736250162124633789f,0.37416407465934753418f,
-0.92850607633590698242f,0.37131720781326293945f,-0.92964088916778564453f,
0.36846682429313659668f,-0.93076694011688232422f,0.36561298370361328125f,
-0.93188428878784179688f,0.36275571584701538086f,-0.93299281597137451172f,
0.35989505052566528320f,-0.93409252166748046875f,0.35703095793724060059f,
-0.93518352508544921875f,0.35416352748870849609f,-0.93626564741134643555f,
0.35129275918006896973f,-0.93733900785446166992f,0.34841868281364440918f,
-0.93840354681015014648f,0.34554132819175720215f,-0.93945920467376708984f,
0.34266072511672973633f,-0.94050604104995727539f,0.33977687358856201172f,
-0.94154405593872070312f,0.33688986301422119141f,-0.94257318973541259766f,
0.33399966359138488770f,-0.94359344244003295898f,0.33110630512237548828f,
-0.94460481405258178711f,0.32820984721183776855f,-0.94560730457305908203f,
0.32531028985977172852f,-0.94660091400146484375f,0.32240769267082214355f,
-0.94758558273315429688f,0.31950202584266662598f,-0.94856137037277221680f,
0.31659337878227233887f,-0.94952815771102905273f,0.31368175148963928223f,
-0.95048606395721435547f,0.31076714396476745605f,-0.95143502950668334961f,
0.30784964561462402344f,-0.95237499475479125977f,0.30492922663688659668f,
-0.95330601930618286133f,0.30200594663619995117f,-0.95422810316085815430f,
0.29907983541488647461f,-0.95514118671417236328f,0.29615089297294616699f,
-0.95604526996612548828f,0.29321914911270141602f,-0.95694035291671752930f,
0.29028466343879699707f,-0.95782643556594848633f,0.28734746575355529785f,
-0.95870345830917358398f,0.28440752625465393066f,-0.95957154035568237305f,
0.28146493434906005859f,-0.96043050289154052734f,0.27851969003677368164f,
-0.96128046512603759766f,0.27557182312011718750f,-0.96212142705917358398f,
0.27262136340141296387f,-0.96295326948165893555f,0.26966831088066101074f,
-0.96377605199813842773f,0.26671275496482849121f,-0.96458977460861206055f,
0.26375466585159301758f,-0.96539443731307983398f,0.26079410314559936523f,
-0.96618998050689697266f,0.25783109664916992188f,-0.96697646379470825195f,
0.25486564636230468750f,-0.96775382757186889648f,0.25189781188964843750f,
-0.96852207183837890625f,0.24892760813236236572f,-0.96928125619888305664f,
0.24595504999160766602f,-0.97003126144409179688f,0.24298018217086791992f,
-0.97077214717864990234f,0.24000301957130432129f,-0.97150391340255737305f,
0.23702360689640045166f,-0.97222650051116943359f,0.23404195904731750488f,
-0.97293996810913085938f,0.23105810582637786865f,-0.97364425659179687500f,
0.22807207703590393066f,-0.97433936595916748047f,0.22508391737937927246f,
-0.97502535581588745117f,0.22209362685680389404f,-0.97570210695266723633f,
0.21910123527050018311f,-0.97636973857879638672f,0.21610680222511291504f,
-0.97702813148498535156f,0.21311031281948089600f,-0.97767734527587890625f,
0.21011184155941009521f,-0.97831737995147705078f,0.20711137354373931885f,
-0.97894817590713500977f,0.20410896837711334229f,-0.97956979274749755859f,
0.20110464096069335938f,-0.98018211126327514648f,0.19809840619564056396f,
-0.98078525066375732422f,0.19509032368659973145f,-0.98137921094894409180f,
0.19208039343357086182f,-0.98196387290954589844f,0.18906866014003753662f,
-0.98253929615020751953f,0.18605515360832214355f,-0.98310548067092895508f,
0.18303988873958587646f,-0.98366242647171020508f,0.18002289533615112305f,
-0.98421007394790649414f,0.17700421810150146484f,-0.98474848270416259766f,
0.17398387193679809570f,-0.98527765274047851562f,0.17096188664436340332f,
-0.98579752445220947266f,0.16793829202651977539f,-0.98630809783935546875f,
0.16491311788558959961f,-0.98680937290191650391f,0.16188639402389526367f,
-0.98730140924453735352f,0.15885815024375915527f,-0.98778414726257324219f,
0.15582840144634246826f,-0.98825758695602416992f,0.15279719233512878418f,
-0.98872166872024536133f,0.14976453781127929688f,-0.98917651176452636719f,
0.14673046767711639404f,-0.98962199687957763672f,0.14369502663612365723f,
-0.99005818367004394531f,0.14065824449062347412f,-0.99048507213592529297f,
0.13762012124061584473f,-0.99090266227722167969f,0.13458070158958435059f,
-0.99131083488464355469f,0.13154003024101257324f,-0.99170976877212524414f,
0.12849810719490051270f,-0.99209928512573242188f,0.12545497715473175049f,
-0.99247956275939941406f,0.12241067737340927124f,-0.99285042285919189453f,
0.11936521530151367188f,-0.99321192502975463867f,0.11631862819194793701f,
-0.99356412887573242188f,0.11327095329761505127f,-0.99390697479248046875f,
0.11022220551967620850f,-0.99424046277999877930f,0.10717242211103439331f,
-0.99456459283828735352f,0.10412163287401199341f,-0.99487930536270141602f,
0.10106986016035079956f,-0.99518471956253051758f,0.09801714122295379639f,
-0.99548077583312988281f,0.09496349841356277466f,-0.99576741456985473633f,
0.09190895408391952515f,-0.99604469537734985352f,0.08885355293750762939f,
-0.99631261825561523438f,0.08579730987548828125f,-0.99657112360000610352f,
0.08274026215076446533f,-0.99682027101516723633f,0.07968243956565856934f,
-0.99706006050109863281f,0.07662386447191238403f,-0.99729043245315551758f,
0.07356456667184829712f,-0.99751144647598266602f,0.07050457596778869629f,
-0.99772304296493530273f,0.06744392216205596924f,-0.99792528152465820312f,
0.06438262760639190674f,-0.99811810255050659180f,0.06132073700428009033f,
-0.99830156564712524414f,0.05825826525688171387f,-0.99847555160522460938f,
0.05519524589180946350f,-0.99864023923873901367f,0.05213170498609542847f,
-0.99879544973373413086f,0.04906767606735229492f,-0.99894130229949951172f,
0.04600318148732185364f,-0.99907773733139038086f,0.04293825849890708923f,
-0.99920475482940673828f,0.03987292572855949402f,-0.99932235479354858398f,
0.03680722415447235107f,-0.99943059682846069336f,0.03374117240309715271f,
-0.99952942132949829102f,0.03067480400204658508f,-0.99961882829666137695f,
0.02760814502835273743f,-0.99969881772994995117f,0.02454122900962829590f,
-0.99976938962936401367f,0.02147408016026020050f,-0.99983060359954833984f,
0.01840673014521598816f,-0.99988234043121337891f,0.01533920597285032272f,
-0.99992471933364868164f,0.01227153837680816650f,-0.99995762109756469727f,
0.00920375436544418335f,-0.99998116493225097656f,0.00613588467240333557f,
-0.99999529123306274414f,0.00306795677170157433f,1.00000000000000000000f,
0.00000000000000000000f,0.99992471933364868164f,0.01227153837680816650f,
0.99969881772994995117f,0.02454122900962829590f,0.99932235479354858398f,
0.03680722415447235107f,0.99879544973373413086f,0.04906767606735229492f,
0.99811810255050659180f,0.06132073700428009033f,0.99729043245315551758f,
0.07356456667184829712f,0.99631261825561523438f,0.08579730987548828125f,
0.99518471956253051758f,0.09801714122295379639f,0.99390697479248046875f,
0.11022220551967620850f,0.99247956275939941406f,0.12241067737340927124f,
0.99090266227722167969f,0.13458070158958435059f,0.98917651176452636719f,
0.14673046767711639404f,0.98730140924453735352f,0.15885815024375915527f,
0.98527765274047851562f,0.17096188664436340332f,0.98310548067092895508f,
0.18303988873958587646f,0.98078525066375732422f,0.19509032368659973145f,
0.97831737995147705078f,0.20711137354373931885f,0.97570210695266723633f,
0.21910123527050018311f,0.97293996810913085938f,0.23105810582637786865f,
0.97003126144409179688f,0.24298018217086791992f,0.96697646379470825195f,
0.25486564636230468750f,0.96377605199813842773f,0.26671275496482849121f,
0.96043050289154052734f,0.27851969003677368164f,0.95694035291671752930f,
0.29028466343879699707f,0.95330601930618286133f,0.30200594663619995117f,
0.94952815771102905273f,0.31368175148963928223f,0.94560730457305908203f,
0.32531028985977172852f,0.94154405593872070312f,0.33688986301422119141f,
0.93733900785446166992f,0.34841868281364440918f,0.93299281597137451172f,
0.35989505052566528320f,0.92850607633590698242f,0.37131720781326293945f,
0.92387950420379638672f,0.38268342614173889160f,0.91911387443542480469f,
0.39399203658103942871f,0.91420978307723999023f,0.40524131059646606445f,
0.90916800498962402344f,0.41642954945564270020f,0.90398931503295898438f,
0.42755508422851562500f,0.89867448806762695312f,0.43861624598503112793f,
0.89322429895401000977f,0.44961133599281311035f,0.88763964176177978516f,
0.46053871512413024902f,0.88192129135131835938f,0.47139674425125122070f,
0.87607008218765258789f,0.48218378424644470215f,0.87008696794509887695f,
0.49289819598197937012f,0.86397284269332885742f,0.50353837013244628906f,
0.85772860050201416016f,0.51410275697708129883f,0.85135519504547119141f,
0.52458965778350830078f,0.84485357999801635742f,0.53499764204025268555f,
0.83822470903396606445f,0.54532498121261596680f,0.83146959543228149414f,
0.55557024478912353516f,0.82458931207656860352f,0.56573182344436645508f,
0.81758481264114379883f,0.57580816745758056641f,0.81045717000961303711f,
0.58579784631729125977f,0.80320751667022705078f,0.59569931030273437500f,
0.79583692550659179688f,0.60551106929779052734f,0.78834640979766845703f,
0.61523157358169555664f,0.78073722124099731445f,0.62485951185226440430f,
0.77301043272018432617f,0.63439327478408813477f,0.76516723632812500000f,
0.64383155107498168945f,0.75720882415771484375f,0.65317285060882568359f,
0.74913638830184936523f,0.66241580247879028320f,0.74095112085342407227f,
0.67155897617340087891f,0.73265427350997924805f,0.68060100078582763672f,
0.72424709796905517578f,0.68954056501388549805f,0.71573084592819213867f,
0.69837623834609985352f,0.70710676908493041992f,0.70710676908493041992f,
0.69837623834609985352f,0.71573084592819213867f,0.68954056501388549805f,
0.72424709796905517578f,0.68060100078582763672f,0.73265427350997924805f,
0.67155897617340087891f,0.74095112085342407227f,0.66241580247879028320f,
0.74913638830184936523f,0.65317285060882568359f,0.75720882415771484375f,
0.64383155107498168945f,0.76516723632812500000f,0.63439327478408813477f,
0.77301043272018432617f,0.62485951185226440430f,0.78073722124099731445f,
0.61523157358169555664f,0.78834640979766845703f,0.60551106929779052734f,
0.79583692550659179688f,0.59569931030273437500f,0.80320751667022705078f,
0.58579784631729125977f,0.81045717000961303711f,0.57580816745758056641f,
0.81758481264114379883f,0.56573182344436645508f,0.82458931207656860352f,
0.55557024478912353516f,0.83146959543228149414f,0.54532498121261596680f,
0.83822470903396606445f,0.53499764204025268555f,0.84485357999801635742f,
0.52458965778350830078f,0.85135519504547119141f,0.51410275697708129883f,
0.85772860050201416016f,0.50353837013244628906f,0.86397284269332885742f,
0.49289819598197937012f,0.87008696794509887695f,0.48218378424644470215f,
0.87607008218765258789f,0.47139674425125122070f,0.88192129135131835938f,
0.46053871512413024902f,0.88763964176177978516f,0.44961133599281311035f,
0.89322429895401000977f,0.43861624598503112793f,0.89867448806762695312f,
0.42755508422851562500f,0.90398931503295898438f,0.41642954945564270020f,
0.90916800498962402344f,0.40524131059646606445f,0.91420978307723999023f,
0.39399203658103942871f,0.91911387443542480469f,0.38268342614173889160f,
0.92387950420379638672f,0.37131720781326293945f,0.92850607633590698242f,
0.35989505052566528320f,0.93299281597137451172f,0.34841868281364440918f,
0.93733900785446166992f,0.33688986301422119141f,0.94154405593872070312f,
0.32531028985977172852f,0.94560730457305908203f,0.31368175148963928223f,
0.94952815771102905273f,0.30200594663619995117f,0.95330601930618286133f,
0.29028466343879699707f,0.95694035291671752930f,0.27851969003677368164f,
0.96043050289154052734f,0.26671275496482849121f,0.96377605199813842773f,
0.25486564636230468750f,0.96697646379470825195f,0.24298018217086791992f,
0.97003126144409179688f,0.23105810582637786865f,0.97293996810913085938f,
0.21910123527050018311f,0.97570210695266723633f,0.20711137354373931885f,
0.97831737995147705078f,0.19509032368659973145f,0.98078525066375732422f,
0.18303988873958587646f,0.98310548067092895508f,0.17096188664436340332f,
0.98527765274047851562f,0.15885815024375915527f,0.98730140924453735352f,
0.14673046767711639404f,0.98917651176452636719f,0.13458070158958435059f,
0.99090266227722167969f,0.12241067737340927124f,0.99247956275939941406f,
0.11022220551967620850f,0.99390697479248046875f,0.09801714122295379639f,
0.99518471956253051758f,0.08579730987548828125f,0.99631261825561523438f,
0.07356456667184829712f,0.99729043245315551758f,0.06132073700428009033f,
0.99811810255050659180f,0.04906767606735229492f,0.99879544973373413086f,
0.03680722415447235107f,0.99932235479354858398f,0.02454122900962829590f,
0.99969881772994995117f,0.01227153837680816650f,0.99992471933364868164f,
0.00000000000000006123f,1.00000000000000000000f,-0.01227153837680816650f,
0.99992471933364868164f,-0.02454122900962829590f,0.99969881772994995117f,
-0.03680722415447235107f,0.99932235479354858398f,-0.04906767606735229492f,
0.99879544973373413086f,-0.06132073700428009033f,0.99811810255050659180f,
-0.07356456667184829712f,0.99729043245315551758f,-0.08579730987548828125f,
0.99631261825561523438f,-0.09801714122295379639f,0.99518471956253051758f,
-0.11022220551967620850f,0.99390697479248046875f,-0.12241067737340927124f,
0.99247956275939941406f,-0.13458070158958435059f,0.99090266227722167969f,
-0.14673046767711639404f,0.98917651176452636719f,-0.15885815024375915527f,
0.98730140924453735352f,-0.17096188664436340332f,0.98527765274047851562f,
-0.18303988873958587646f,0.98310548067092895508f,-0.19509032368659973145f,
0.98078525066375732422f,-0.20711137354373931885f,0.97831737995147705078f,
-0.21910123527050018311f,0.97570210695266723633f,-0.23105810582637786865f,
0.97293996810913085938f,-0.24298018217086791992f,0.97003126144409179688f,
-0.25486564636230468750f,0.96697646379470825195f,-0.26671275496482849121f,
0.96377605199813842773f,-0.27851969003677368164f,0.96043050289154052734f,
-0.29028466343879699707f,0.95694035291671752930f,-0.30200594663619995117f,
0.95330601930618286133f,-0.31368175148963928223f,0.94952815771102905273f,
-0.32531028985977172852f,0.94560730457305908203f,-0.33688986301422119141f,
0.94154405593872070312f,-0.34841868281364440918f,0.93733900785446166992f,
-0.35989505052566528320f,0.93299281597137451172f,-0.37131720781326293945f,
0.92850607633590698242f,-0.38268342614173889160f,0.92387950420379638672f,
-0.39399203658103942871f,0.91911387443542480469f,-0.40524131059646606445f,
0.91420978307723999023f,-0.41642954945564270020f,0.90916800498962402344f,
-0.42755508422851562500f,0.90398931503295898438f,-0.43861624598503112793f,
0.89867448806762695312f,-0.44961133599281311035f,0.89322429895401000977f,
-0.46053871512413024902f,0.88763964176177978516f,-0.47139674425125122070f,
0.88192129135131835938f,-0.48218378424644470215f,0.87607008218765258789f,
-0.49289819598197937012f,0.87008696794509887695f,-0.50353837013244628906f,
0.86397284269332885742f,-0.51410275697708129883f,0.85772860050201416016f,
-0.52458965778350830078f,0.85135519504547119141f,-0.53499764204025268555f,
0.84485357999801635742f,-0.54532498121261596680f,0.83822470903396606445f,
-0.55557024478912353516f,0.83146959543228149414f,-0.56573182344436645508f,
0.82458931207656860352f,-0.57580816745758056641f,0.81758481264114379883f,
-0.58579784631729125977f,0.81045717000961303711f,-0.59569931030273437500f,
0.80320751667022705078f,-0.60551106929779052734f,0.79583692550659179688f,
-0.61523157358169555664f,0.78834640979766845703f,-0.62485951185226440430f,
0.78073722124099731445f,-0.63439327478408813477f,0.77301043272018432617f,
-0.64383155107498168945f,0.76516723632812500000f,-0.65317285060882568359f,
0.75720882415771484375f,-0.66241580247879028320f,0.74913638830184936523f,
-0.67155897617340087891f,0.74095112085342407227f,-0.68060100078582763672f,
0.73265427350997924805f,-0.68954056501388549805f,0.72424709796905517578f,
-0.69837623834609985352f,0.71573084592819213867f,-0.70710676908493041992f,
0.70710676908493041992f,-0.71573084592819213867f,0.69837623834609985352f,
-0.72424709796905517578f,0.68954056501388549805f,-0.73265427350997924805f,
0.68060100078582763672f,-0.74095112085342407227f,0.67155897617340087891f,
-0.74913638830184936523f,0.66241580247879028320f,-0.75720882415771484375f,
0.65317285060882568359f,-0.76516723632812500000f,0.64383155107498168945f,
-0.77301043272018432617f,0.63439327478408813477f,-0.78073722124099731445f,
0.62485951185226440430f,-0.78834640979766845703f,0.61523157358169555664f,
-0.79583692550659179688f,0.60551106929779052734f,-0.80320751667022705078f,
0.59569931030273437500f,-0.81045717000961303711f,0.58579784631729125977f,
-0.81758481264114379883f,0.57580816745758056641f,-0.82458931207656860352f,
0.56573182344436645508f,-0.83146959543228149414f,0.55557024478912353516f,
-0.83822470903396606445f,0.54532498121261596680f,-0.84485357999801635742f,
0.53499764204025268555f,-0.85135519504547119141f,0.52458965778350830078f,
-0.85772860050201416016f,0.51410275697708129883f,-0.86397284269332885742f,
0.50353837013244628906f,-0.87008696794509887695f,0.49289819598197937012f,
-0.87607008218765258789f,0.48218378424644470215f,-0.88192129135131835938f,
0.47139674425125122070f,-0.88763964176177978516f,0.46053871512413024902f,
-0.89322429895401000977f,0.44961133599281311035f,-0.89867448806762695312f,
0.43861624598503112793f,-0.90398931503295898438f,0.42755508422851562500f,
-0.90916800498962402344f,0.41642954945564270020f,-0.91420978307723999023f,
0.40524131059646606445f,-0.91911387443542480469f,0.39399203658103942871f,
-0.92387950420379638672f,0.38268342614173889160f,-0.92850607633590698242f,
0.37131720781326293945f,-0.93299281597137451172f,0.35989505052566528320f,
-0.93733900785446166992f,0.34841868281364440918f,-0.94154405593872070312f,
0.33688986301422119141f,-0.94560730457305908203f,0.32531028985977172852f,
-0.94952815771102905273f,0.31368175148963928223f,-0.95330601930618286133f,
0.30200594663619995117f,-0.95694035291671752930f,0.29028466343879699707f,
-0.96043050289154052734f,0.27851969003677368164f,-0.96377605199813842773f,
0.26671275496482849121f,-0.96697646379470825195f,0.25486564636230468750f,
-0.97003126144409179688f,0.24298018217086791992f,-0.97293996810913085938f,
0.23105810582637786865f,-0.97570210695266723633f,0.21910123527050018311f,
-0.97831737995147705078f,0.20711137354373931885f,-0.98078525066375732422f,
0.19509032368659973145f,-0.98310548067092895508f,0.18303988873958587646f,
-0.98527765274047851562f,0.17096188664436340332f,-0.98730140924453735352f,
0.15885815024375915527f,-0.98917651176452636719f,0.14673046767711639404f,
-0.99090266227722167969f,0.13458070158958435059f,-0.99247956275939941406f,
0.12241067737340927124f,-0.99390697479248046875f,0.11022220551967620850f,
-0.99518471956253051758f,0.09801714122295379639f,-0.99631261825561523438f,
0.08579730987548828125f,-0.99729043245315551758f,0.07356456667184829712f,
-0.99811810255050659180f,0.06132073700428009033f,-0.99879544973373413086f,
0.04906767606735229492f,-0.99932235479354858398f,0.03680722415447235107f,
-0.99969881772994995117f,0.02454122900962829590f,-0.99992471933364868164f,
0.01227153837680816650f,1.00000000000000000000f,0.00000000000000000000f,
0.99879544973373413086f,0.04906767606735229492f,0.99518471956253051758f,
0.09801714122295379639f,0.98917651176452636719f,0.14673046767711639404f,
0.98078525066375732422f,0.19509032368659973145f,0.97003126144409179688f,
0.24298018217086791992f,0.95694035291671752930f,0.29028466343879699707f,
0.94154405593872070312f,0.33688986301422119141f,0.92387950420379638672f,
0.38268342614173889160f,0.90398931503295898438f,0.42755508422851562500f,
0.88192129135131835938f,0.47139674425125122070f,0.85772860050201416016f,
0.51410275697708129883f,0.83146959543228149414f,0.55557024478912353516f,
0.80320751667022705078f,0.59569931030273437500f,0.77301043272018432617f,
0.63439327478408813477f,0.74095112085342407227f,0.67155897617340087891f,
0.70710676908493041992f,0.70710676908493041992f,0.67155897617340087891f,
0.74095112085342407227f,0.63439327478408813477f,0.77301043272018432617f,
0.59569931030273437500f,0.80320751667022705078f,0.55557024478912353516f,
0.83146959543228149414f,0.51410275697708129883f,0.85772860050201416016f,
0.47139674425125122070f,0.88192129135131835938f,0.42755508422851562500f,
0.90398931503295898438f,0.38268342614173889160f,0.92387950420379638672f,
0.33688986301422119141f,0.94154405593872070312f,0.29028466343879699707f,
0.95694035291671752930f,0.24298018217086791992f,0.97003126144409179688f,
0.19509032368659973145f,0.98078525066375732422f,0.14673046767711639404f,
0.98917651176452636719f,0.09801714122295379639f,0.99518471956253051758f,
0.04906767606735229492f,0.99879544973373413086f,0.00000000000000006123f,
1.00000000000000000000f,-0.04906767606735229492f,0.99879544973373413086f,
-0.09801714122295379639f,0.99518471956253051758f,-0.14673046767711639404f,
0.98917651176452636719f,-0.19509032368659973145f,0.98078525066375732422f,
-0.24298018217086791992f,0.97003126144409179688f,-0.29028466343879699707f,
0.95694035291671752930f,-0.33688986301422119141f,0.94154405593872070312f,
-0.38268342614173889160f,0.92387950420379638672f,-0.42755508422851562500f,
0.90398931503295898438f,-0.47139674425125122070f,0.88192129135131835938f,
-0.51410275697708129883f,0.85772860050201416016f,-0.55557024478912353516f,
0.83146959543228149414f,-0.59569931030273437500f,0.80320751667022705078f,
-0.63439327478408813477f,0.77301043272018432617f,-0.67155897617340087891f,
0.74095112085342407227f,-0.70710676908493041992f,0.70710676908493041992f,
-0.74095112085342407227f,0.67155897617340087891f,-0.77301043272018432617f,
0.63439327478408813477f,-0.80320751667022705078f,0.59569931030273437500f,
-0.83146959543228149414f,0.55557024478912353516f,-0.85772860050201416016f,
0.51410275697708129883f,-0.88192129135131835938f,0.47139674425125122070f,
-0.90398931503295898438f,0.42755508422851562500f,-0.92387950420379638672f,
0.38268342614173889160f,-0.94154405593872070312f,0.33688986301422119141f,
-0.95694035291671752930f,0.29028466343879699707f,-0.97003126144409179688f,
0.24298018217086791992f,-0.98078525066375732422f,0.19509032368659973145f,
-0.98917651176452636719f,0.14673046767711639404f,-0.99518471956253051758f,
0.09801714122295379639f,-0.99879544973373413086f,0.04906767606735229492f,
1.00000000000000000000f,0.00000000000000000000f,0.98078525066375732422f,
0.19509032368659973145f,0.92387950420379638672f,0.38268342614173889160f,
0.83146959543228149414f,0.55557024478912353516f,0.70710676908493041992f,
0.70710676908493041992f,0.55557024478912353516f,0.83146959543228149414f,
0.38268342614173889160f,0.92387950420379638672f,0.19509032368659973145f,
0.98078525066375732422f,0.00000000000000006123f,1.00000000000000000000f,
-0.19509032368659973145f,0.98078525066375732422f,-0.38268342614173889160f,
0.92387950420379638672f,-0.55557024478912353516f,0.83146959543228149414f,
-0.70710676908493041992f,0.70710676908493041992f,-0.83146959543228149414f,
0.55557024478912353516f,-0.92387950420379638672f,0.38268342614173889160f,
-0.98078525066375732422f,0.19509032368659973145f,1.00000000000000000000f,
0.00000000000000000000f,0.70710676908493041992f,0.70710676908493041992f,
0.00000000000000006123f,1.00000000000000000000f,-0.70710676908493041992f,
0.70710676908493041992f,};

float32_t rearranged_twiddle_stride3_4096_f32[2728]={
1.00000000000000000000f,0.00000000000000000000f,0.99998939037322998047f,
0.00460192607715725899f,0.99995762109756469727f,0.00920375436544418335f,
0.99990469217300415039f,0.01380538847297430038f,0.99983060359954833984f,
0.01840673014521598816f,0.99973529577255249023f,0.02300768159329891205f,
0.99961882829666137695f,0.02760814502835273743f,0.99948120117187500000f,
0.03220802545547485352f,0.99932235479354858398f,0.03680722415447235107f,
0.99914240837097167969f,0.04140564054250717163f,0.99894130229949951172f,
0.04600318148732185364f,0.99871903657913208008f,0.05059975013136863708f,
0.99847555160522460938f,0.05519524589180946350f,0.99821102619171142578f,
0.05978957191109657288f,0.99792528152465820312f,0.06438262760639190674f,
0.99761843681335449219f,0.06897433102130889893f,0.99729043245315551758f,
0.07356456667184829712f,0.99694132804870605469f,0.07815324515104293823f,
0.99657112360000610352f,0.08274026215076446533f,0.99617981910705566406f,
0.08732553571462631226f,0.99576741456985473633f,0.09190895408391952515f,
0.99533390998840332031f,0.09649042785167694092f,0.99487930536270141602f,
0.10106986016035079956f,0.99440366029739379883f,0.10564715415239334106f,
0.99390697479248046875f,0.11022220551967620850f,0.99338918924331665039f,
0.11479492485523223877f,0.99285042285919189453f,0.11936521530151367188f,
0.99229061603546142578f,0.12393297255039215088f,0.99170976877212524414f,
0.12849810719490051270f,0.99110794067382812500f,0.13306052982807159424f,
0.99048507213592529297f,0.13762012124061584473f,0.98984128236770629883f,
0.14217680692672729492f,0.98917651176452636719f,0.14673046767711639404f,
0.98849081993103027344f,0.15128104388713836670f,0.98778414726257324219f,
0.15582840144634246826f,0.98705655336380004883f,0.16037245094776153564f,
0.98630809783935546875f,0.16491311788558959961f,0.98553872108459472656f,
0.16945029795169830322f,0.98474848270416259766f,0.17398387193679809570f,
0.98393744230270385742f,0.17851376533508300781f,0.98310548067092895508f,
0.18303988873958587646f,0.98225271701812744141f,0.18756212294101715088f,
0.98137921094894409180f,0.19208039343357086182f,0.98048484325408935547f,
0.19659459590911865234f,0.97956979274749755859f,0.20110464096069335938f,
0.97863394021987915039f,0.20561040937900543213f,0.97767734527587890625f,
0.21011184155941009521f,0.97670006752014160156f,0.21460881829261779785f,
0.97570210695266723633f,0.21910123527050018311f,0.97468352317810058594f,
0.22358903288841247559f,0.97364425659179687500f,0.22807207703590393066f,
0.97258436679840087891f,0.23255030810832977295f,0.97150391340255737305f,
0.23702360689640045166f,0.97040283679962158203f,0.24149188399314880371f,
0.96928125619888305664f,0.24595504999160766602f,0.96813911199569702148f,
0.25041300058364868164f,0.96697646379470825195f,0.25486564636230468750f,
0.96579337120056152344f,0.25931292772293090820f,0.96458977460861206055f,
0.26375466585159301758f,0.96336579322814941406f,0.26819086074829101562f,
0.96212142705917358398f,0.27262136340141296387f,0.96085661649703979492f,
0.27704608440399169922f,0.95957154035568237305f,0.28146493434906005859f,
0.95826607942581176758f,0.28587782382965087891f,0.95694035291671752930f,
0.29028466343879699707f,0.95559436082839965820f,0.29468536376953125000f,
0.95422810316085815430f,0.29907983541488647461f,0.95284163951873779297f,
0.30346795916557312012f,0.95143502950668334961f,0.30784964561462402344f,
0.95000827312469482422f,0.31222480535507202148f,0.94856137037277221680f,
0.31659337878227233887f,0.94709438085556030273f,0.32095524668693542480f,
0.94560730457305908203f,0.32531028985977172852f,0.94410026073455810547f,
0.32965844869613647461f,0.94257318973541259766f,0.33399966359138488770f,
0.94102615118026733398f,0.33833375573158264160f,0.93945920467376708984f,
0.34266072511672973633f,0.93787235021591186523f,0.34698042273521423340f,
0.93626564741134643555f,0.35129275918006896973f,0.93463915586471557617f,
0.35559767484664916992f,0.93299281597137451172f,0.35989505052566528320f,
0.93132668733596801758f,0.36418479681015014648f,0.92964088916778564453f,
0.36846682429313659668f,0.92793542146682739258f,0.37274107336997985840f,
0.92621022462844848633f,0.37700742483139038086f,0.92446547746658325195f,
0.38126575946807861328f,0.92270112037658691406f,0.38551604747772216797f,
0.92091721296310424805f,0.38975816965103149414f,0.91911387443542480469f,
0.39399203658103942871f,0.91729098558425903320f,0.39821755886077880859f,
0.91544872522354125977f,0.40243464708328247070f,0.91358703374862670898f,
0.40664321184158325195f,0.91170603036880493164f,0.41084316372871398926f,
0.90980571508407592773f,0.41503441333770751953f,0.90788608789443969727f,
0.41921690106391906738f,0.90594726800918579102f,0.42339047789573669434f,
0.90398931503295898438f,0.42755508422851562500f,0.90201216936111450195f,
0.43171066045761108398f,0.90001589059829711914f,0.43585708737373352051f,
0.89800059795379638672f,0.43999427556991577148f,0.89596623182296752930f,
0.44412213563919067383f,0.89391297101974487305f,0.44824060797691345215f,
0.89184069633483886719f,0.45234957337379455566f,0.88974958658218383789f,
0.45644897222518920898f,0.88763964176177978516f,0.46053871512413024902f,
0.88551086187362670898f,0.46461868286132812500f,0.88336336612701416016f,
0.46868881583213806152f,0.88119709491729736328f,0.47274902462959289551f,
0.87901222705841064453f,0.47679921984672546387f,0.87680870294570922852f,
0.48083934187889099121f,0.87458664178848266602f,0.48486924171447753906f,
0.87234604358673095703f,0.48888888955116271973f,0.87008696794509887695f,
0.49289819598197937012f,0.86780947446823120117f,0.49689704179763793945f,
0.86551362276077270508f,0.50088536739349365234f,0.86319941282272338867f,
0.50486308336257934570f,0.86086696386337280273f,0.50883013010025024414f,
0.85851621627807617188f,0.51278638839721679688f,0.85614734888076782227f,
0.51673179864883422852f,0.85376030206680297852f,0.52066624164581298828f,
0.85135519504547119141f,0.52458965778350830078f,0.84893202781677246094f,
0.52850198745727539062f,0.84649091958999633789f,0.53240311145782470703f,
0.84403187036514282227f,0.53629297018051147461f,0.84155499935150146484f,
0.54017144441604614258f,0.83906024694442749023f,0.54403853416442871094f,
0.83654773235321044922f,0.54789406061172485352f,0.83401751518249511719f,
0.55173796415328979492f,0.83146959543228149414f,0.55557024478912353516f,
0.82890409231185913086f,0.55939072370529174805f,0.82632106542587280273f,
0.56319934129714965820f,0.82372051477432250977f,0.56699603796005249023f,
0.82110249996185302734f,0.57078075408935546875f,0.81846714019775390625f,
0.57455337047576904297f,0.81581443548202514648f,0.57831376791000366211f,
0.81314438581466674805f,0.58206200599670410156f,0.81045717000961303711f,
0.58579784631729125977f,0.80775284767150878906f,0.58952128887176513672f,
0.80503135919570922852f,0.59323227405548095703f,0.80229282379150390625f,
0.59693068265914916992f,0.79953724145889282227f,0.60061645507812500000f,
0.79676479101181030273f,0.60428953170776367188f,0.79397547245025634766f,
0.60794979333877563477f,0.79116934537887573242f,0.61159718036651611328f,
0.78834640979766845703f,0.61523157358169555664f,0.78550684452056884766f,
0.61885297298431396484f,0.78265058994293212891f,0.62246125936508178711f,
0.77977776527404785156f,0.62605637311935424805f,0.77688848972320556641f,
0.62963825464248657227f,0.77398270368576049805f,0.63320678472518920898f,
0.77106052637100219727f,0.63676184415817260742f,0.76812201738357543945f,
0.64030349254608154297f,0.76516723632812500000f,0.64383155107498168945f,
0.76219630241394042969f,0.64734596014022827148f,0.75920921564102172852f,
0.65084666013717651367f,0.75620597600936889648f,0.65433359146118164062f,
0.75318682193756103516f,0.65780669450759887695f,0.75015163421630859375f,
0.66126585006713867188f,0.74710059165954589844f,0.66471099853515625000f,
0.74403375387191772461f,0.66814202070236206055f,0.74095112085342407227f,
0.67155897617340087891f,0.73785281181335449219f,0.67496162652969360352f,
0.73473888635635375977f,0.67835003137588500977f,0.73160940408706665039f,
0.68172407150268554688f,0.72846436500549316406f,0.68508368730545043945f,
0.72530394792556762695f,0.68842875957489013672f,0.72212821245193481445f,
0.69175922870635986328f,0.71893709897994995117f,0.69507509469985961914f,
0.71573084592819213867f,0.69837623834609985352f,0.71250939369201660156f,
0.70166260004043579102f,0.70927280187606811523f,0.70493406057357788086f,
0.70602124929428100586f,0.70819061994552612305f,0.70275473594665527344f,
0.71143221855163574219f,0.69947332143783569336f,0.71465867757797241211f,
0.69617712497711181641f,0.71787005662918090820f,0.69286614656448364258f,
0.72106617689132690430f,0.68954056501388549805f,0.72424709796905517578f,
0.68620032072067260742f,0.72741264104843139648f,0.68284553289413452148f,
0.73056274652481079102f,0.67947632074356079102f,0.73369741439819335938f,
0.67609268426895141602f,0.73681658506393432617f,0.67269474267959594727f,
0.73992007970809936523f,0.66928261518478393555f,0.74300795793533325195f,
0.66585624217987060547f,0.74608010053634643555f,0.66241580247879028320f,
0.74913638830184936523f,0.65896129608154296875f,0.75217682123184204102f,
0.65549284219741821289f,0.75520139932632446289f,0.65201056003570556641f,
0.75820988416671752930f,0.64851438999176025391f,0.76120239496231079102f,
0.64500451087951660156f,0.76417875289916992188f,0.64148104190826416016f,
0.76713889837265014648f,0.63794392347335815430f,0.77008283138275146484f,
0.63439327478408813477f,0.77301043272018432617f,0.63082921504974365234f,
0.77592170238494873047f,0.62725180387496948242f,0.77881652116775512695f,
0.62366110086441040039f,0.78169482946395874023f,0.62005722522735595703f,
0.78455656766891479492f,0.61644017696380615234f,0.78740173578262329102f,
0.61281007528305053711f,0.79023021459579467773f,0.60916703939437866211f,
0.79304194450378417969f,0.60551106929779052734f,0.79583692550659179688f,
0.60184222459793090820f,0.79861497879028320312f,0.59816068410873413086f,
0.80137616395950317383f,0.59446650743484497070f,0.80412036180496215820f,
0.59075969457626342773f,0.80684757232666015625f,0.58704036474227905273f,
0.80955761671066284180f,0.58330863714218139648f,0.81225061416625976562f,
0.57956457138061523438f,0.81492632627487182617f,0.57580816745758056641f,
0.81758481264114379883f,0.57203960418701171875f,0.82022595405578613281f,
0.56825894117355346680f,0.82284981012344360352f,0.56446623802185058594f,
0.82545614242553710938f,0.56066155433654785156f,0.82804507017135620117f,
0.55684500932693481445f,0.83061641454696655273f,0.55301672220230102539f,
0.83317017555236816406f,0.54917663335800170898f,0.83570629358291625977f,
0.54532498121261596680f,0.83822470903396606445f,0.54146176576614379883f,
0.84072536230087280273f,0.53758704662322998047f,0.84320825338363647461f,
0.53370100259780883789f,0.84567326307296752930f,0.52980363368988037109f,
0.84812033176422119141f,0.52589499950408935547f,0.85054945945739746094f,
0.52197527885437011719f,0.85296058654785156250f,0.51804453134536743164f,
0.85535365343093872070f,0.51410275697708129883f,0.85772860050201416016f,
0.51015007495880126953f,0.86008536815643310547f,0.50618666410446166992f,
0.86242395639419555664f,0.50221246480941772461f,0.86474424600601196289f,
0.49822765588760375977f,0.86704623699188232422f,0.49423229694366455078f,
0.86932986974716186523f,0.49022647738456726074f,0.87159508466720581055f,
0.48621028661727905273f,0.87384182214736938477f,0.48218378424644470215f,
0.87607008218765258789f,0.47814705967903137207f,0.87827980518341064453f,
0.47410020232200622559f,0.88047087192535400391f,0.47004333138465881348f,
0.88264334201812744141f,0.46597650647163391113f,0.88479709625244140625f,
0.46189978718757629395f,0.88693213462829589844f,0.45781329274177551270f,
0.88904833793640136719f,0.45371711254119873047f,0.89114576578140258789f,
0.44961133599281311035f,0.89322429895401000977f,0.44549602270126342773f,
0.89528393745422363281f,0.44137126207351684570f,0.89732456207275390625f,
0.43723717331886291504f,0.89934623241424560547f,0.43309381604194641113f,
0.90134882926940917969f,0.42894127964973449707f,0.90333235263824462891f,
0.42477968335151672363f,0.90529674291610717773f,0.42060908675193786621f,
0.90724200010299682617f,0.41642954945564270020f,0.90916800498962402344f,
0.41224122047424316406f,0.91107475757598876953f,0.40804415941238403320f,
0.91296219825744628906f,0.40383845567703247070f,0.91483032703399658203f,
0.39962419867515563965f,0.91667908430099487305f,0.39540147781372070312f,
0.91850841045379638672f,0.39117038249969482422f,0.92031830549240112305f,
0.38693100214004516602f,0.92210865020751953125f,0.38268342614173889160f,
0.92387950420379638672f,0.37842774391174316406f,0.92563080787658691406f,
0.37416407465934753418f,0.92736250162124633789f,0.36989244818687438965f,
0.92907458543777465820f,0.36561298370361328125f,0.93076694011688232422f,
0.36132580041885375977f,0.93243962526321411133f,0.35703095793724060059f,
0.93409252166748046875f,0.35272854566574096680f,0.93572568893432617188f,
0.34841868281364440918f,0.93733900785446166992f,0.34410142898559570312f,
0.93893247842788696289f,0.33977687358856201172f,0.94050604104995727539f,
0.33544513583183288574f,0.94205975532531738281f,0.33110630512237548828f,
0.94359344244003295898f,0.32676044106483459473f,0.94510722160339355469f,
0.32240769267082214355f,0.94660091400146484375f,0.31804808974266052246f,
0.94807457923889160156f,0.31368175148963928223f,0.94952815771102905273f,
0.30930876731872558594f,0.95096164941787719727f,0.30492922663688659668f,
0.95237499475479125977f,0.30054324865341186523f,0.95376819372177124023f,
0.29615089297294616699f,0.95514118671417236328f,0.29175224900245666504f,
0.95649391412734985352f,0.28734746575355529785f,0.95782643556594848633f,
0.28293657302856445312f,0.95913863182067871094f,0.27851969003677368164f,
0.96043050289154052734f,0.27409690618515014648f,0.96170204877853393555f,
0.26966831088066101074f,0.96295326948165893555f,0.26523402333259582520f,
0.96418404579162597656f,0.26079410314559936523f,0.96539443731307983398f,
0.25634866952896118164f,0.96658438444137573242f,0.25189781188964843750f,
0.96775382757186889648f,0.24744161963462829590f,0.96890282630920410156f,
0.24298018217086791992f,0.97003126144409179688f,0.23851358890533447266f,
0.97113913297653198242f,0.23404195904731750488f,0.97222650051116943359f,
0.22956536710262298584f,0.97329324483871459961f,0.22508391737937927246f,
0.97433936595916748047f,0.22059768438339233398f,0.97536486387252807617f,
0.21610680222511291504f,0.97636973857879638672f,0.21161133050918579102f,
0.97735387086868286133f,0.20711137354373931885f,0.97831737995147705078f,
0.20260703563690185547f,0.97926014661788940430f,0.19809840619564056396f,
0.98018211126327514648f,0.19358558952808380127f,0.98108339309692382812f,
0.18906866014003753662f,0.98196387290954589844f,0.18454773724079132080f,
0.98282355070114135742f,0.18002289533615112305f,0.98366242647171020508f,
0.17549425363540649414f,0.98448044061660766602f,0.17096188664436340332f,
0.98527765274047851562f,0.16642589867115020752f,0.98605394363403320312f,
0.16188639402389526367f,0.98680937290191650391f,0.15734346210956573486f,
0.98754394054412841797f,0.15279719233512878418f,0.98825758695602416992f,
0.14824767410755157471f,0.98895025253295898438f,0.14369502663612365723f,
0.98962199687957763672f,0.13913933932781219482f,0.99027281999588012695f,
0.13458070158958435059f,0.99090266227722167969f,0.13001921772956848145f,
0.99151146411895751953f,0.12545497715473175049f,0.99209928512573242188f,
0.12088808417320251465f,0.99266612529754638672f,0.11631862819194793701f,
0.99321192502975463867f,0.11174671351909637451f,0.99373674392700195312f,
0.10717242211103439331f,0.99424046277999877930f,0.10259586572647094727f,
0.99472314119338989258f,0.09801714122295379639f,0.99518471956253051758f,
0.09343633800745010376f,0.99562525749206542969f,0.08885355293750762939f,
0.99604469537734985352f,0.08426889032125473022f,0.99644303321838378906f,
0.07968243956565856934f,0.99682027101516723633f,0.07509429752826690674f,
0.99717640876770019531f,0.07050457596778869629f,0.99751144647598266602f,
0.06591334939002990723f,0.99782532453536987305f,0.06132073700428009033f,
0.99811810255050659180f,0.05672682076692581177f,0.99838972091674804688f,
0.05213170498609542847f,0.99864023923873901367f,0.04753548279404640198f,
0.99886953830718994141f,0.04293825849890708923f,0.99907773733139038086f,
0.03834012150764465332f,0.99926477670669555664f,0.03374117240309715271f,
0.99943059682846069336f,0.02914150804281234741f,0.99957531690597534180f,
0.02454122900962829590f,0.99969881772994995117f,0.01994042843580245972f,
0.99980115890502929688f,0.01533920597285032272f,0.99988234043121337891f,
0.01073765940964221954f,0.99994236230850219727f,0.00613588467240333557f,
0.99998116493225097656f,0.00153398013208061457f,0.99999880790710449219f,
-0.00306795677170157433f,0.99999529123306274414f,-0.00766982883214950562f,
0.99997061491012573242f,-0.01227153837680816650f,0.99992471933364868164f,
-0.01687298715114593506f,0.99985766410827636719f,-0.02147408016026020050f,
0.99976938962936401367f,-0.02607471868395805359f,0.99966001510620117188f,
-0.03067480400204658508f,0.99952942132949829102f,-0.03527423739433288574f,
0.99937766790390014648f,-0.03987292572855949402f,0.99920475482940673828f,
-0.04447077214717864990f,0.99901068210601806641f,-0.04906767606735229492f,
0.99879544973373413086f,-0.05366353690624237061f,0.99855905771255493164f,
-0.05825826525688171387f,0.99830156564712524414f,-0.06285175681114196777f,
0.99802285432815551758f,-0.06744392216205596924f,0.99772304296493530273f,
-0.07203464955091476440f,0.99740213155746459961f,-0.07662386447191238403f,
0.99706006050109863281f,-0.08121144771575927734f,0.99669688940048217773f,
-0.08579730987548828125f,0.99631261825561523438f,-0.09038136154413223267f,
0.99590724706649780273f,-0.09496349841356277466f,0.99548077583312988281f,
-0.09954361617565155029f,0.99503320455551147461f,-0.10412163287401199341f,
0.99456459283828735352f,-0.10869744420051574707f,0.99407488107681274414f,
-0.11327095329761505127f,0.99356412887573242188f,-0.11784206330776214600f,
0.99303233623504638672f,-0.12241067737340927124f,0.99247956275939941406f,
-0.12697669863700866699f,0.99190568923950195312f,-0.13154003024101257324f,
0.99131083488464355469f,-0.13610057532787322998f,0.99069499969482421875f,
-0.14065824449062347412f,0.99005818367004394531f,-0.14521291851997375488f,
0.98940044641494750977f,-0.14976453781127929688f,0.98872166872024536133f,
-0.15431296825408935547f,0.98802202939987182617f,-0.15885815024375915527f,
0.98730140924453735352f,-0.16339994966983795166f,0.98655992746353149414f,
-0.16793829202651977539f,0.98579752445220947266f,-0.17247308790683746338f,
0.98501425981521606445f,-0.17700421810150146484f,0.98421007394790649414f,
-0.18153160810470581055f,0.98338508605957031250f,-0.18605515360832214355f,
0.98253929615020751953f,-0.19057475030422210693f,0.98167270421981811523f,
-0.19509032368659973145f,0.98078525066375732422f,-0.19960175454616546631f,
0.97987711429595947266f,-0.20410896837711334229f,0.97894817590713500977f,
-0.20861184597015380859f,0.97799849510192871094f,-0.21311031281948089600f,
0.97702813148498535156f,-0.21760427951812744141f,0.97603708505630493164f,
-0.22209362685680389404f,0.97502535581588745117f,-0.22657826542854309082f,
0.97399294376373291016f,-0.23105810582637786865f,0.97293996810913085938f,
-0.23553305864334106445f,0.97186630964279174805f,-0.24000301957130432129f,
0.97077214717864990234f,-0.24446789920330047607f,0.96965736150741577148f,
-0.24892760813236236572f,0.96852207183837890625f,-0.25338202714920043945f,
0.96736627817153930664f,-0.25783109664916992188f,0.96618998050689697266f,
-0.26227471232414245605f,0.96499323844909667969f,-0.26671275496482849121f,
0.96377605199813842773f,-0.27114516496658325195f,0.96253848075866699219f,
-0.27557182312011718750f,0.96128046512603759766f,-0.27999264001846313477f,
0.96000212430953979492f,-0.28440752625465393066f,0.95870345830917358398f,
-0.28881642222404479980f,0.95738452672958374023f,-0.29321914911270141602f,
0.95604526996612548828f,-0.29761570692062377930f,0.95468574762344360352f,
-0.30200594663619995117f,0.95330601930618286133f,-0.30638980865478515625f,
0.95190614461898803711f,-0.31076714396476745605f,0.95048606395721435547f,
-0.31513792276382446289f,0.94904589653015136719f,-0.31950202584266662598f,
0.94758558273315429688f,-0.32385936379432678223f,0.94610524177551269531f,
-0.32820984721183776855f,0.94460481405258178711f,-0.33255335688591003418f,
0.94308441877365112305f,-0.33688986301422119141f,0.94154405593872070312f,
-0.34121921658515930176f,0.93998372554779052734f,-0.34554132819175720215f,
0.93840354681015014648f,-0.34985613822937011719f,0.93680346012115478516f,
-0.35416352748870849609f,0.93518352508544921875f,-0.35846340656280517578f,
0.93354380130767822266f,-0.36275571584701538086f,0.93188428878784179688f,
-0.36704033613204956055f,0.93020504713058471680f,-0.37131720781326293945f,
0.92850607633590698242f,-0.37558618187904357910f,0.92678749561309814453f,
-0.37984719872474670410f,0.92504924535751342773f,-0.38410019874572753906f,
0.92329144477844238281f,-0.38834503293037414551f,0.92151403427124023438f,
-0.39258167147636413574f,0.91971713304519653320f,-0.39680999517440795898f,
0.91790080070495605469f,-0.40102988481521606445f,0.91606497764587402344f,
-0.40524131059646606445f,0.91420978307723999023f,-0.40944415330886840820f,
0.91233515739440917969f,-0.41363832354545593262f,0.91044127941131591797f,
-0.41782370209693908691f,0.90852808952331542969f,-0.42200025916099548340f,
0.90659570693969726562f,-0.42616787552833557129f,0.90464407205581665039f,
-0.43032649159431457520f,0.90267330408096313477f,-0.43447595834732055664f,
0.90068340301513671875f,-0.43861624598503112793f,0.89867448806762695312f,
-0.44274723529815673828f,0.89664649963378906250f,-0.44686883687973022461f,
0.89459949731826782227f,-0.45098099112510681152f,0.89253354072570800781f,
-0.45508357882499694824f,0.89044874906539916992f,-0.45917654037475585938f,
0.88834506273269653320f,-0.46325978636741638184f,0.88622254133224487305f,
-0.46733319759368896484f,0.88408124446868896484f,-0.47139674425125122070f,
0.88192129135131835938f,-0.47545027732849121094f,0.87974262237548828125f,
-0.47949376702308654785f,0.87754529714584350586f,-0.48352706432342529297f,
0.87532937526702880859f,-0.48755016922950744629f,0.87309497594833374023f,
-0.49156290292739868164f,0.87084203958511352539f,-0.49556526541709899902f,
0.86857068538665771484f,-0.49955710768699645996f,0.86628097295761108398f,
-0.50353837013244628906f,0.86397284269332885742f,-0.50750899314880371094f,
0.86164647340774536133f,-0.51146882772445678711f,0.85930180549621582031f,
-0.51541787385940551758f,0.85693895816802978516f,-0.51935601234436035156f,
0.85455799102783203125f,-0.52328312397003173828f,0.85215890407562255859f,
-0.52719914913177490234f,0.84974175691604614258f,-0.53110402822494506836f,
0.84730660915374755859f,-0.53499764204025268555f,0.84485357999801635742f,
-0.53887993097305297852f,0.84238260984420776367f,-0.54275077581405639648f,
0.83989381790161132812f,-0.54661017656326293945f,0.83738720417022705078f,
-0.55045795440673828125f,0.83486288785934448242f,-0.55429410934448242188f,
0.83232086896896362305f,-0.55811852216720581055f,0.82976120710372924805f,
-0.56193113327026367188f,0.82718402147293090820f,-0.56573182344436645508f,
0.82458931207656860352f,-0.56952053308486938477f,0.82197713851928710938f,
-0.57329714298248291016f,0.81934750080108642578f,-0.57706165313720703125f,
0.81670057773590087891f,-0.58081394433975219727f,0.81403630971908569336f,
-0.58455395698547363281f,0.81135487556457519531f,-0.58828157186508178711f,
0.80865615606307983398f,-0.59199666976928710938f,0.80594038963317871094f,
-0.59569931030273437500f,0.80320751667022705078f,-0.59938931465148925781f,
0.80045765638351440430f,-0.60306662321090698242f,0.79769086837768554688f,
-0.60673111677169799805f,0.79490715265274047852f,-0.61038279533386230469f,
0.79210656881332397461f,-0.61402153968811035156f,0.78928923606872558594f,
-0.61764729022979736328f,0.78645521402359008789f,-0.62125998735427856445f,
0.78360450267791748047f,-0.62485951185226440430f,0.78073722124099731445f,
-0.62844574451446533203f,0.77785342931747436523f,-0.63201874494552612305f,
0.77495312690734863281f,-0.63557833433151245117f,0.77203637361526489258f,
-0.63912445306777954102f,0.76910334825515747070f,-0.64265704154968261719f,
0.76615399122238159180f,-0.64617604017257690430f,0.76318842172622680664f,
-0.64968132972717285156f,0.76020669937133789062f,-0.65317285060882568359f,
0.75720882415771484375f,-0.65665054321289062500f,0.75419497489929199219f,
-0.66011434793472290039f,0.75116515159606933594f,-0.66356414556503295898f,
0.74811935424804687500f,-0.66699993610382080078f,0.74505776166915893555f,
-0.67042154073715209961f,0.74198043346405029297f,-0.67382901906967163086f,
0.73888731002807617188f,-0.67722219228744506836f,0.73577857017517089844f,
-0.68060100078582763672f,0.73265427350997924805f,-0.68396538496017456055f,
0.72951442003250122070f,-0.68731534481048583984f,0.72635912895202636719f,
-0.69065070152282714844f,0.72318845987319946289f,-0.69397145509719848633f,
0.72000253200531005859f,-0.69727748632431030273f,0.71680128574371337891f,
-0.70056879520416259766f,0.71358484029769897461f,-0.70384526252746582031f,
0.71035337448120117188f,-0.70710676908493041992f,0.70710676908493041992f,
-0.71035337448120117188f,0.70384526252746582031f,-0.71358484029769897461f,
0.70056879520416259766f,-0.71680128574371337891f,0.69727748632431030273f,
-0.72000253200531005859f,0.69397145509719848633f,-0.72318845987319946289f,
0.69065070152282714844f,-0.72635912895202636719f,0.68731534481048583984f,
-0.72951442003250122070f,0.68396538496017456055f,-0.73265427350997924805f,
0.68060100078582763672f,-0.73577857017517089844f,0.67722219228744506836f,
-0.73888731002807617188f,0.67382901906967163086f,-0.74198043346405029297f,
0.67042154073715209961f,-0.74505776166915893555f,0.66699993610382080078f,
-0.74811935424804687500f,0.66356414556503295898f,-0.75116515159606933594f,
0.66011434793472290039f,-0.75419497489929199219f,0.65665054321289062500f,
-0.75720882415771484375f,0.65317285060882568359f,-0.76020669937133789062f,
0.64968132972717285156f,-0.76318842172622680664f,0.64617604017257690430f,
-0.76615399122238159180f,0.64265704154968261719f,-0.76910334825515747070f,
0.63912445306777954102f,-0.77203637361526489258f,0.63557833433151245117f,
-0.77495312690734863281f,0.63201874494552612305f,-0.77785342931747436523f,
0.62844574451446533203f,-0.78073722124099731445f,0.62485951185226440430f,
-0.78360450267791748047f,0.62125998735427856445f,-0.78645521402359008789f,
0.61764729022979736328f,-0.78928923606872558594f,0.61402153968811035156f,
-0.79210656881332397461f,0.61038279533386230469f,-0.79490715265274047852f,
0.60673111677169799805f,-0.79769086837768554688f,0.60306662321090698242f,
-0.80045765638351440430f,0.59938931465148925781f,-0.80320751667022705078f,
0.59569931030273437500f,-0.80594038963317871094f,0.59199666976928710938f,
-0.80865615606307983398f,0.58828157186508178711f,-0.81135487556457519531f,
0.58455395698547363281f,-0.81403630971908569336f,0.58081394433975219727f,
-0.81670057773590087891f,0.57706165313720703125f,-0.81934750080108642578f,
0.57329714298248291016f,-0.82197713851928710938f,0.56952053308486938477f,
-0.82458931207656860352f,0.56573182344436645508f,-0.82718402147293090820f,
0.56193113327026367188f,-0.82976120710372924805f,0.55811852216720581055f,
-0.83232086896896362305f,0.55429410934448242188f,-0.83486288785934448242f,
0.55045795440673828125f,-0.83738720417022705078f,0.54661017656326293945f,
-0.83989381790161132812f,0.54275077581405639648f,-0.84238260984420776367f,
0.53887993097305297852f,-0.84485357999801635742f,0.53499764204025268555f,
-0.84730660915374755859f,0.53110402822494506836f,-0.84974175691604614258f,
0.52719914913177490234f,-0.85215890407562255859f,0.52328312397003173828f,
-0.85455799102783203125f,0.51935601234436035156f,-0.85693895816802978516f,
0.51541787385940551758f,-0.85930180549621582031f,0.51146882772445678711f,
-0.86164647340774536133f,0.50750899314880371094f,-0.86397284269332885742f,
0.50353837013244628906f,-0.86628097295761108398f,0.49955710768699645996f,
-0.86857068538665771484f,0.49556526541709899902f,-0.87084203958511352539f,
0.49156290292739868164f,-0.87309497594833374023f,0.48755016922950744629f,
-0.87532937526702880859f,0.48352706432342529297f,-0.87754529714584350586f,
0.47949376702308654785f,-0.87974262237548828125f,0.47545027732849121094f,
-0.88192129135131835938f,0.47139674425125122070f,-0.88408124446868896484f,
0.46733319759368896484f,-0.88622254133224487305f,0.46325978636741638184f,
-0.88834506273269653320f,0.45917654037475585938f,-0.89044874906539916992f,
0.45508357882499694824f,-0.89253354072570800781f,0.45098099112510681152f,
-0.89459949731826782227f,0.44686883687973022461f,-0.89664649963378906250f,
0.44274723529815673828f,-0.89867448806762695312f,0.43861624598503112793f,
-0.90068340301513671875f,0.43447595834732055664f,-0.90267330408096313477f,
0.43032649159431457520f,-0.90464407205581665039f,0.42616787552833557129f,
-0.90659570693969726562f,0.42200025916099548340f,-0.90852808952331542969f,
0.41782370209693908691f,-0.91044127941131591797f,0.41363832354545593262f,
-0.91233515739440917969f,0.40944415330886840820f,-0.91420978307723999023f,
0.40524131059646606445f,-0.91606497764587402344f,0.40102988481521606445f,
-0.91790080070495605469f,0.39680999517440795898f,-0.91971713304519653320f,
0.39258167147636413574f,-0.92151403427124023438f,0.38834503293037414551f,
-0.92329144477844238281f,0.38410019874572753906f,-0.92504924535751342773f,
0.37984719872474670410f,-0.92678749561309814453f,0.37558618187904357910f,
-0.92850607633590698242f,0.37131720781326293945f,-0.93020504713058471680f,
0.36704033613204956055f,-0.93188428878784179688f,0.36275571584701538086f,
-0.93354380130767822266f,0.35846340656280517578f,-0.93518352508544921875f,
0.35416352748870849609f,-0.93680346012115478516f,0.34985613822937011719f,
-0.93840354681015014648f,0.34554132819175720215f,-0.93998372554779052734f,
0.34121921658515930176f,-0.94154405593872070312f,0.33688986301422119141f,
-0.94308441877365112305f,0.33255335688591003418f,-0.94460481405258178711f,
0.32820984721183776855f,-0.94610524177551269531f,0.32385936379432678223f,
-0.94758558273315429688f,0.31950202584266662598f,-0.94904589653015136719f,
0.31513792276382446289f,-0.95048606395721435547f,0.31076714396476745605f,
-0.95190614461898803711f,0.30638980865478515625f,-0.95330601930618286133f,
0.30200594663619995117f,-0.95468574762344360352f,0.29761570692062377930f,
-0.95604526996612548828f,0.29321914911270141602f,-0.95738452672958374023f,
0.28881642222404479980f,-0.95870345830917358398f,0.28440752625465393066f,
-0.96000212430953979492f,0.27999264001846313477f,-0.96128046512603759766f,
0.27557182312011718750f,-0.96253848075866699219f,0.27114516496658325195f,
-0.96377605199813842773f,0.26671275496482849121f,-0.96499323844909667969f,
0.26227471232414245605f,-0.96618998050689697266f,0.25783109664916992188f,
-0.96736627817153930664f,0.25338202714920043945f,-0.96852207183837890625f,
0.24892760813236236572f,-0.96965736150741577148f,0.24446789920330047607f,
-0.97077214717864990234f,0.24000301957130432129f,-0.97186630964279174805f,
0.23553305864334106445f,-0.97293996810913085938f,0.23105810582637786865f,
-0.97399294376373291016f,0.22657826542854309082f,-0.97502535581588745117f,
0.22209362685680389404f,-0.97603708505630493164f,0.21760427951812744141f,
-0.97702813148498535156f,0.21311031281948089600f,-0.97799849510192871094f,
0.20861184597015380859f,-0.97894817590713500977f,0.20410896837711334229f,
-0.97987711429595947266f,0.19960175454616546631f,-0.98078525066375732422f,
0.19509032368659973145f,-0.98167270421981811523f,0.19057475030422210693f,
-0.98253929615020751953f,0.18605515360832214355f,-0.98338508605957031250f,
0.18153160810470581055f,-0.98421007394790649414f,0.17700421810150146484f,
-0.98501425981521606445f,0.17247308790683746338f,-0.98579752445220947266f,
0.16793829202651977539f,-0.98655992746353149414f,0.16339994966983795166f,
-0.98730140924453735352f,0.15885815024375915527f,-0.98802202939987182617f,
0.15431296825408935547f,-0.98872166872024536133f,0.14976453781127929688f,
-0.98940044641494750977f,0.14521291851997375488f,-0.99005818367004394531f,
0.14065824449062347412f,-0.99069499969482421875f,0.13610057532787322998f,
-0.99131083488464355469f,0.13154003024101257324f,-0.99190568923950195312f,
0.12697669863700866699f,-0.99247956275939941406f,0.12241067737340927124f,
-0.99303233623504638672f,0.11784206330776214600f,-0.99356412887573242188f,
0.11327095329761505127f,-0.99407488107681274414f,0.10869744420051574707f,
-0.99456459283828735352f,0.10412163287401199341f,-0.99503320455551147461f,
0.09954361617565155029f,-0.99548077583312988281f,0.09496349841356277466f,
-0.99590724706649780273f,0.09038136154413223267f,-0.99631261825561523438f,
0.08579730987548828125f,-0.99669688940048217773f,0.08121144771575927734f,
-0.99706006050109863281f,0.07662386447191238403f,-0.99740213155746459961f,
0.07203464955091476440f,-0.99772304296493530273f,0.06744392216205596924f,
-0.99802285432815551758f,0.06285175681114196777f,-0.99830156564712524414f,
0.05825826525688171387f,-0.99855905771255493164f,0.05366353690624237061f,
-0.99879544973373413086f,0.04906767606735229492f,-0.99901068210601806641f,
0.04447077214717864990f,-0.99920475482940673828f,0.03987292572855949402f,
-0.99937766790390014648f,0.03527423739433288574f,-0.99952942132949829102f,
0.03067480400204658508f,-0.99966001510620117188f,0.02607471868395805359f,
-0.99976938962936401367f,0.02147408016026020050f,-0.99985766410827636719f,
0.01687298715114593506f,-0.99992471933364868164f,0.01227153837680816650f,
-0.99997061491012573242f,0.00766982883214950562f,-0.99999529123306274414f,
0.00306795677170157433f,-0.99999880790710449219f,-0.00153398013208061457f,
-0.99998116493225097656f,-0.00613588467240333557f,-0.99994236230850219727f,
-0.01073765940964221954f,-0.99988234043121337891f,-0.01533920597285032272f,
-0.99980115890502929688f,-0.01994042843580245972f,-0.99969881772994995117f,
-0.02454122900962829590f,-0.99957531690597534180f,-0.02914150804281234741f,
-0.99943059682846069336f,-0.03374117240309715271f,-0.99926477670669555664f,
-0.03834012150764465332f,-0.99907773733139038086f,-0.04293825849890708923f,
-0.99886953830718994141f,-0.04753548279404640198f,-0.99864023923873901367f,
-0.05213170498609542847f,-0.99838972091674804688f,-0.05672682076692581177f,
-0.99811810255050659180f,-0.06132073700428009033f,-0.99782532453536987305f,
-0.06591334939002990723f,-0.99751144647598266602f,-0.07050457596778869629f,
-0.99717640876770019531f,-0.07509429752826690674f,-0.99682027101516723633f,
-0.07968243956565856934f,-0.99644303321838378906f,-0.08426889032125473022f,
-0.99604469537734985352f,-0.08885355293750762939f,-0.99562525749206542969f,
-0.09343633800745010376f,-0.99518471956253051758f,-0.09801714122295379639f,
-0.99472314119338989258f,-0.10259586572647094727f,-0.99424046277999877930f,
-0.10717242211103439331f,-0.99373674392700195312f,-0.11174671351909637451f,
-0.99321192502975463867f,-0.11631862819194793701f,-0.99266612529754638672f,
-0.12088808417320251465f,-0.99209928512573242188f,-0.12545497715473175049f,
-0.99151146411895751953f,-0.13001921772956848145f,-0.99090266227722167969f,
-0.13458070158958435059f,-0.99027281999588012695f,-0.13913933932781219482f,
-0.98962199687957763672f,-0.14369502663612365723f,-0.98895025253295898438f,
-0.14824767410755157471f,-0.98825758695602416992f,-0.15279719233512878418f,
-0.98754394054412841797f,-0.15734346210956573486f,-0.98680937290191650391f,
-0.16188639402389526367f,-0.98605394363403320312f,-0.16642589867115020752f,
-0.98527765274047851562f,-0.17096188664436340332f,-0.98448044061660766602f,
-0.17549425363540649414f,-0.98366242647171020508f,-0.18002289533615112305f,
-0.98282355070114135742f,-0.18454773724079132080f,-0.98196387290954589844f,
-0.18906866014003753662f,-0.98108339309692382812f,-0.19358558952808380127f,
-0.98018211126327514648f,-0.19809840619564056396f,-0.97926014661788940430f,
-0.20260703563690185547f,-0.97831737995147705078f,-0.20711137354373931885f,
-0.97735387086868286133f,-0.21161133050918579102f,-0.97636973857879638672f,
-0.21610680222511291504f,-0.97536486387252807617f,-0.22059768438339233398f,
-0.97433936595916748047f,-0.22508391737937927246f,-0.97329324483871459961f,
-0.22956536710262298584f,-0.97222650051116943359f,-0.23404195904731750488f,
-0.97113913297653198242f,-0.23851358890533447266f,-0.97003126144409179688f,
-0.24298018217086791992f,-0.96890282630920410156f,-0.24744161963462829590f,
-0.96775382757186889648f,-0.25189781188964843750f,-0.96658438444137573242f,
-0.25634866952896118164f,-0.96539443731307983398f,-0.26079410314559936523f,
-0.96418404579162597656f,-0.26523402333259582520f,-0.96295326948165893555f,
-0.26966831088066101074f,-0.96170204877853393555f,-0.27409690618515014648f,
-0.96043050289154052734f,-0.27851969003677368164f,-0.95913863182067871094f,
-0.28293657302856445312f,-0.95782643556594848633f,-0.28734746575355529785f,
-0.95649391412734985352f,-0.29175224900245666504f,-0.95514118671417236328f,
-0.29615089297294616699f,-0.95376819372177124023f,-0.30054324865341186523f,
-0.95237499475479125977f,-0.30492922663688659668f,-0.95096164941787719727f,
-0.30930876731872558594f,-0.94952815771102905273f,-0.31368175148963928223f,
-0.94807457923889160156f,-0.31804808974266052246f,-0.94660091400146484375f,
-0.32240769267082214355f,-0.94510722160339355469f,-0.32676044106483459473f,
-0.94359344244003295898f,-0.33110630512237548828f,-0.94205975532531738281f,
-0.33544513583183288574f,-0.94050604104995727539f,-0.33977687358856201172f,
-0.93893247842788696289f,-0.34410142898559570312f,-0.93733900785446166992f,
-0.34841868281364440918f,-0.93572568893432617188f,-0.35272854566574096680f,
-0.93409252166748046875f,-0.35703095793724060059f,-0.93243962526321411133f,
-0.36132580041885375977f,-0.93076694011688232422f,-0.36561298370361328125f,
-0.92907458543777465820f,-0.36989244818687438965f,-0.92736250162124633789f,
-0.37416407465934753418f,-0.92563080787658691406f,-0.37842774391174316406f,
-0.92387950420379638672f,-0.38268342614173889160f,-0.92210865020751953125f,
-0.38693100214004516602f,-0.92031830549240112305f,-0.39117038249969482422f,
-0.91850841045379638672f,-0.39540147781372070312f,-0.91667908430099487305f,
-0.39962419867515563965f,-0.91483032703399658203f,-0.40383845567703247070f,
-0.91296219825744628906f,-0.40804415941238403320f,-0.91107475757598876953f,
-0.41224122047424316406f,-0.90916800498962402344f,-0.41642954945564270020f,
-0.90724200010299682617f,-0.42060908675193786621f,-0.90529674291610717773f,
-0.42477968335151672363f,-0.90333235263824462891f,-0.42894127964973449707f,
-0.90134882926940917969f,-0.43309381604194641113f,-0.89934623241424560547f,
-0.43723717331886291504f,-0.89732456207275390625f,-0.44137126207351684570f,
-0.89528393745422363281f,-0.44549602270126342773f,-0.89322429895401000977f,
-0.44961133599281311035f,-0.89114576578140258789f,-0.45371711254119873047f,
-0.88904833793640136719f,-0.45781329274177551270f,-0.88693213462829589844f,
-0.46189978718757629395f,-0.88479709625244140625f,-0.46597650647163391113f,
-0.88264334201812744141f,-0.47004333138465881348f,-0.88047087192535400391f,
-0.47410020232200622559f,-0.87827980518341064453f,-0.47814705967903137207f,
-0.87607008218765258789f,-0.48218378424644470215f,-0.87384182214736938477f,
-0.48621028661727905273f,-0.87159508466720581055f,-0.49022647738456726074f,
-0.86932986974716186523f,-0.49423229694366455078f,-0.86704623699188232422f,
-0.49822765588760375977f,-0.86474424600601196289f,-0.50221246480941772461f,
-0.86242395639419555664f,-0.50618666410446166992f,-0.86008536815643310547f,
-0.51015007495880126953f,-0.85772860050201416016f,-0.51410275697708129883f,
-0.85535365343093872070f,-0.51804453134536743164f,-0.85296058654785156250f,
-0.52197527885437011719f,-0.85054945945739746094f,-0.52589499950408935547f,
-0.84812033176422119141f,-0.52980363368988037109f,-0.84567326307296752930f,
-0.53370100259780883789f,-0.84320825338363647461f,-0.53758704662322998047f,
-0.84072536230087280273f,-0.54146176576614379883f,-0.83822470903396606445f,
-0.54532498121261596680f,-0.83570629358291625977f,-0.54917663335800170898f,
-0.83317017555236816406f,-0.55301672220230102539f,-0.83061641454696655273f,
-0.55684500932693481445f,-0.82804507017135620117f,-0.56066155433654785156f,
-0.82545614242553710938f,-0.56446623802185058594f,-0.82284981012344360352f,
-0.56825894117355346680f,-0.82022595405578613281f,-0.57203960418701171875f,
-0.81758481264114379883f,-0.57580816745758056641f,-0.81492632627487182617f,
-0.57956457138061523438f,-0.81225061416625976562f,-0.58330863714218139648f,
-0.80955761671066284180f,-0.58704036474227905273f,-0.80684757232666015625f,
-0.59075969457626342773f,-0.80412036180496215820f,-0.59446650743484497070f,
-0.80137616395950317383f,-0.59816068410873413086f,-0.79861497879028320312f,
-0.60184222459793090820f,-0.79583692550659179688f,-0.60551106929779052734f,
-0.79304194450378417969f,-0.60916703939437866211f,-0.79023021459579467773f,
-0.61281007528305053711f,-0.78740173578262329102f,-0.61644017696380615234f,
-0.78455656766891479492f,-0.62005722522735595703f,-0.78169482946395874023f,
-0.62366110086441040039f,-0.77881652116775512695f,-0.62725180387496948242f,
-0.77592170238494873047f,-0.63082921504974365234f,-0.77301043272018432617f,
-0.63439327478408813477f,-0.77008283138275146484f,-0.63794392347335815430f,
-0.76713889837265014648f,-0.64148104190826416016f,-0.76417875289916992188f,
-0.64500451087951660156f,-0.76120239496231079102f,-0.64851438999176025391f,
-0.75820988416671752930f,-0.65201056003570556641f,-0.75520139932632446289f,
-0.65549284219741821289f,-0.75217682123184204102f,-0.65896129608154296875f,
-0.74913638830184936523f,-0.66241580247879028320f,-0.74608010053634643555f,
-0.66585624217987060547f,-0.74300795793533325195f,-0.66928261518478393555f,
-0.73992007970809936523f,-0.67269474267959594727f,-0.73681658506393432617f,
-0.67609268426895141602f,-0.73369741439819335938f,-0.67947632074356079102f,
-0.73056274652481079102f,-0.68284553289413452148f,-0.72741264104843139648f,
-0.68620032072067260742f,-0.72424709796905517578f,-0.68954056501388549805f,
-0.72106617689132690430f,-0.69286614656448364258f,-0.71787005662918090820f,
-0.69617712497711181641f,-0.71465867757797241211f,-0.69947332143783569336f,
-0.71143221855163574219f,-0.70275473594665527344f,-0.70819061994552612305f,
-0.70602124929428100586f,-0.70493406057357788086f,-0.70927280187606811523f,
-0.70166260004043579102f,-0.71250939369201660156f,-0.69837623834609985352f,
-0.71573084592819213867f,-0.69507509469985961914f,-0.71893709897994995117f,
-0.69175922870635986328f,-0.72212821245193481445f,-0.68842875957489013672f,
-0.72530394792556762695f,-0.68508368730545043945f,-0.72846436500549316406f,
-0.68172407150268554688f,-0.73160940408706665039f,-0.67835003137588500977f,
-0.73473888635635375977f,-0.67496162652969360352f,-0.73785281181335449219f,
-0.67155897617340087891f,-0.74095112085342407227f,-0.66814202070236206055f,
-0.74403375387191772461f,-0.66471099853515625000f,-0.74710059165954589844f,
-0.66126585006713867188f,-0.75015163421630859375f,-0.65780669450759887695f,
-0.75318682193756103516f,-0.65433359146118164062f,-0.75620597600936889648f,
-0.65084666013717651367f,-0.75920921564102172852f,-0.64734596014022827148f,
-0.76219630241394042969f,-0.64383155107498168945f,-0.76516723632812500000f,
-0.64030349254608154297f,-0.76812201738357543945f,-0.63676184415817260742f,
-0.77106052637100219727f,-0.63320678472518920898f,-0.77398270368576049805f,
-0.62963825464248657227f,-0.77688848972320556641f,-0.62605637311935424805f,
-0.77977776527404785156f,-0.62246125936508178711f,-0.78265058994293212891f,
-0.61885297298431396484f,-0.78550684452056884766f,-0.61523157358169555664f,
-0.78834640979766845703f,-0.61159718036651611328f,-0.79116934537887573242f,
-0.60794979333877563477f,-0.79397547245025634766f,-0.60428953170776367188f,
-0.79676479101181030273f,-0.60061645507812500000f,-0.79953724145889282227f,
-0.59693068265914916992f,-0.80229282379150390625f,-0.59323227405548095703f,
-0.80503135919570922852f,-0.58952128887176513672f,-0.80775284767150878906f,
-0.58579784631729125977f,-0.81045717000961303711f,-0.58206200599670410156f,
-0.81314438581466674805f,-0.57831376791000366211f,-0.81581443548202514648f,
-0.57455337047576904297f,-0.81846714019775390625f,-0.57078075408935546875f,
-0.82110249996185302734f,-0.56699603796005249023f,-0.82372051477432250977f,
-0.56319934129714965820f,-0.82632106542587280273f,-0.55939072370529174805f,
-0.82890409231185913086f,-0.55557024478912353516f,-0.83146959543228149414f,
-0.55173796415328979492f,-0.83401751518249511719f,-0.54789406061172485352f,
-0.83654773235321044922f,-0.54403853416442871094f,-0.83906024694442749023f,
-0.54017144441604614258f,-0.84155499935150146484f,-0.53629297018051147461f,
-0.84403187036514282227f,-0.53240311145782470703f,-0.84649091958999633789f,
-0.52850198745727539062f,-0.84893202781677246094f,-0.52458965778350830078f,
-0.85135519504547119141f,-0.52066624164581298828f,-0.85376030206680297852f,
-0.51673179864883422852f,-0.85614734888076782227f,-0.51278638839721679688f,
-0.85851621627807617188f,-0.50883013010025024414f,-0.86086696386337280273f,
-0.50486308336257934570f,-0.86319941282272338867f,-0.50088536739349365234f,
-0.86551362276077270508f,-0.49689704179763793945f,-0.86780947446823120117f,
-0.49289819598197937012f,-0.87008696794509887695f,-0.48888888955116271973f,
-0.87234604358673095703f,-0.48486924171447753906f,-0.87458664178848266602f,
-0.48083934187889099121f,-0.87680870294570922852f,-0.47679921984672546387f,
-0.87901222705841064453f,-0.47274902462959289551f,-0.88119709491729736328f,
-0.46868881583213806152f,-0.88336336612701416016f,-0.46461868286132812500f,
-0.88551086187362670898f,-0.46053871512413024902f,-0.88763964176177978516f,
-0.45644897222518920898f,-0.88974958658218383789f,-0.45234957337379455566f,
-0.89184069633483886719f,-0.44824060797691345215f,-0.89391297101974487305f,
-0.44412213563919067383f,-0.89596623182296752930f,-0.43999427556991577148f,
-0.89800059795379638672f,-0.43585708737373352051f,-0.90001589059829711914f,
-0.43171066045761108398f,-0.90201216936111450195f,-0.42755508422851562500f,
-0.90398931503295898438f,-0.42339047789573669434f,-0.90594726800918579102f,
-0.41921690106391906738f,-0.90788608789443969727f,-0.41503441333770751953f,
-0.90980571508407592773f,-0.41084316372871398926f,-0.91170603036880493164f,
-0.40664321184158325195f,-0.91358703374862670898f,-0.40243464708328247070f,
-0.91544872522354125977f,-0.39821755886077880859f,-0.91729098558425903320f,
-0.39399203658103942871f,-0.91911387443542480469f,-0.38975816965103149414f,
-0.92091721296310424805f,-0.38551604747772216797f,-0.92270112037658691406f,
-0.38126575946807861328f,-0.92446547746658325195f,-0.37700742483139038086f,
-0.92621022462844848633f,-0.37274107336997985840f,-0.92793542146682739258f,
-0.36846682429313659668f,-0.92964088916778564453f,-0.36418479681015014648f,
-0.93132668733596801758f,-0.35989505052566528320f,-0.93299281597137451172f,
-0.35559767484664916992f,-0.93463915586471557617f,-0.35129275918006896973f,
-0.93626564741134643555f,-0.34698042273521423340f,-0.93787235021591186523f,
-0.34266072511672973633f,-0.93945920467376708984f,-0.33833375573158264160f,
-0.94102615118026733398f,-0.33399966359138488770f,-0.94257318973541259766f,
-0.32965844869613647461f,-0.94410026073455810547f,-0.32531028985977172852f,
-0.94560730457305908203f,-0.32095524668693542480f,-0.94709438085556030273f,
-0.31659337878227233887f,-0.94856137037277221680f,-0.31222480535507202148f,
-0.95000827312469482422f,-0.30784964561462402344f,-0.95143502950668334961f,
-0.30346795916557312012f,-0.95284163951873779297f,-0.29907983541488647461f,
-0.95422810316085815430f,-0.29468536376953125000f,-0.95559436082839965820f,
-0.29028466343879699707f,-0.95694035291671752930f,-0.28587782382965087891f,
-0.95826607942581176758f,-0.28146493434906005859f,-0.95957154035568237305f,
-0.27704608440399169922f,-0.96085661649703979492f,-0.27262136340141296387f,
-0.96212142705917358398f,-0.26819086074829101562f,-0.96336579322814941406f,
-0.26375466585159301758f,-0.96458977460861206055f,-0.25931292772293090820f,
-0.96579337120056152344f,-0.25486564636230468750f,-0.96697646379470825195f,
-0.25041300058364868164f,-0.96813911199569702148f,-0.24595504999160766602f,
-0.96928125619888305664f,-0.24149188399314880371f,-0.97040283679962158203f,
-0.23702360689640045166f,-0.97150391340255737305f,-0.23255030810832977295f,
-0.97258436679840087891f,-0.22807207703590393066f,-0.97364425659179687500f,
-0.22358903288841247559f,-0.97468352317810058594f,-0.21910123527050018311f,
-0.97570210695266723633f,-0.21460881829261779785f,-0.97670006752014160156f,
-0.21011184155941009521f,-0.97767734527587890625f,-0.20561040937900543213f,
-0.97863394021987915039f,-0.20110464096069335938f,-0.97956979274749755859f,
-0.19659459590911865234f,-0.98048484325408935547f,-0.19208039343357086182f,
-0.98137921094894409180f,-0.18756212294101715088f,-0.98225271701812744141f,
-0.18303988873958587646f,-0.98310548067092895508f,-0.17851376533508300781f,
-0.98393744230270385742f,-0.17398387193679809570f,-0.98474848270416259766f,
-0.16945029795169830322f,-0.98553872108459472656f,-0.16491311788558959961f,
-0.98630809783935546875f,-0.16037245094776153564f,-0.98705655336380004883f,
-0.15582840144634246826f,-0.98778414726257324219f,-0.15128104388713836670f,
-0.98849081993103027344f,-0.14673046767711639404f,-0.98917651176452636719f,
-0.14217680692672729492f,-0.98984128236770629883f,-0.13762012124061584473f,
-0.99048507213592529297f,-0.13306052982807159424f,-0.99110794067382812500f,
-0.12849810719490051270f,-0.99170976877212524414f,-0.12393297255039215088f,
-0.99229061603546142578f,-0.11936521530151367188f,-0.99285042285919189453f,
-0.11479492485523223877f,-0.99338918924331665039f,-0.11022220551967620850f,
-0.99390697479248046875f,-0.10564715415239334106f,-0.99440366029739379883f,
-0.10106986016035079956f,-0.99487930536270141602f,-0.09649042785167694092f,
-0.99533390998840332031f,-0.09190895408391952515f,-0.99576741456985473633f,
-0.08732553571462631226f,-0.99617981910705566406f,-0.08274026215076446533f,
-0.99657112360000610352f,-0.07815324515104293823f,-0.99694132804870605469f,
-0.07356456667184829712f,-0.99729043245315551758f,-0.06897433102130889893f,
-0.99761843681335449219f,-0.06438262760639190674f,-0.99792528152465820312f,
-0.05978957191109657288f,-0.99821102619171142578f,-0.05519524589180946350f,
-0.99847555160522460938f,-0.05059975013136863708f,-0.99871903657913208008f,
-0.04600318148732185364f,-0.99894130229949951172f,-0.04140564054250717163f,
-0.99914240837097167969f,-0.03680722415447235107f,-0.99932235479354858398f,
-0.03220802545547485352f,-0.99948120117187500000f,-0.02760814502835273743f,
-0.99961882829666137695f,-0.02300768159329891205f,-0.99973529577255249023f,
-0.01840673014521598816f,-0.99983060359954833984f,-0.01380538847297430038f,
-0.99990469217300415039f,-0.00920375436544418335f,-0.99995762109756469727f,
-0.00460192607715725899f,-0.99998939037322998047f,1.00000000000000000000f,
0.00000000000000000000f,0.99983060359954833984f,0.01840673014521598816f,
0.99932235479354858398f,0.03680722415447235107f,0.99847555160522460938f,
0.05519524589180946350f,0.99729043245315551758f,0.07356456667184829712f,
0.99576741456985473633f,0.09190895408391952515f,0.99390697479248046875f,
0.11022220551967620850f,0.99170976877212524414f,0.12849810719490051270f,
0.98917651176452636719f,0.14673046767711639404f,0.98630809783935546875f,
0.16491311788558959961f,0.98310548067092895508f,0.18303988873958587646f,
0.97956979274749755859f,0.20110464096069335938f,0.97570210695266723633f,
0.21910123527050018311f,0.97150391340255737305f,0.23702360689640045166f,
0.96697646379470825195f,0.25486564636230468750f,0.96212142705917358398f,
0.27262136340141296387f,0.95694035291671752930f,0.29028466343879699707f,
0.95143502950668334961f,0.30784964561462402344f,0.94560730457305908203f,
0.32531028985977172852f,0.93945920467376708984f,0.34266072511672973633f,
0.93299281597137451172f,0.35989505052566528320f,0.92621022462844848633f,
0.37700742483139038086f,0.91911387443542480469f,0.39399203658103942871f,
0.91170603036880493164f,0.41084316372871398926f,0.90398931503295898438f,
0.42755508422851562500f,0.89596623182296752930f,0.44412213563919067383f,
0.88763964176177978516f,0.46053871512413024902f,0.87901222705841064453f,
0.47679921984672546387f,0.87008696794509887695f,0.49289819598197937012f,
0.86086696386337280273f,0.50883013010025024414f,0.85135519504547119141f,
0.52458965778350830078f,0.84155499935150146484f,0.54017144441604614258f,
0.83146959543228149414f,0.55557024478912353516f,0.82110249996185302734f,
0.57078075408935546875f,0.81045717000961303711f,0.58579784631729125977f,
0.79953724145889282227f,0.60061645507812500000f,0.78834640979766845703f,
0.61523157358169555664f,0.77688848972320556641f,0.62963825464248657227f,
0.76516723632812500000f,0.64383155107498168945f,0.75318682193756103516f,
0.65780669450759887695f,0.74095112085342407227f,0.67155897617340087891f,
0.72846436500549316406f,0.68508368730545043945f,0.71573084592819213867f,
0.69837623834609985352f,0.70275473594665527344f,0.71143221855163574219f,
0.68954056501388549805f,0.72424709796905517578f,0.67609268426895141602f,
0.73681658506393432617f,0.66241580247879028320f,0.74913638830184936523f,
0.64851438999176025391f,0.76120239496231079102f,0.63439327478408813477f,
0.77301043272018432617f,0.62005722522735595703f,0.78455656766891479492f,
0.60551106929779052734f,0.79583692550659179688f,0.59075969457626342773f,
0.80684757232666015625f,0.57580816745758056641f,0.81758481264114379883f,
0.56066155433654785156f,0.82804507017135620117f,0.54532498121261596680f,
0.83822470903396606445f,0.52980363368988037109f,0.84812033176422119141f,
0.51410275697708129883f,0.85772860050201416016f,0.49822765588760375977f,
0.86704623699188232422f,0.48218378424644470215f,0.87607008218765258789f,
0.46597650647163391113f,0.88479709625244140625f,0.44961133599281311035f,
0.89322429895401000977f,0.43309381604194641113f,0.90134882926940917969f,
0.41642954945564270020f,0.90916800498962402344f,0.39962419867515563965f,
0.91667908430099487305f,0.38268342614173889160f,0.92387950420379638672f,
0.36561298370361328125f,0.93076694011688232422f,0.34841868281364440918f,
0.93733900785446166992f,0.33110630512237548828f,0.94359344244003295898f,
0.31368175148963928223f,0.94952815771102905273f,0.29615089297294616699f,
0.95514118671417236328f,0.27851969003677368164f,0.96043050289154052734f,
0.26079410314559936523f,0.96539443731307983398f,0.24298018217086791992f,
0.97003126144409179688f,0.22508391737937927246f,0.97433936595916748047f,
0.20711137354373931885f,0.97831737995147705078f,0.18906866014003753662f,
0.98196387290954589844f,0.17096188664436340332f,0.98527765274047851562f,
0.15279719233512878418f,0.98825758695602416992f,0.13458070158958435059f,
0.99090266227722167969f,0.11631862819194793701f,0.99321192502975463867f,
0.09801714122295379639f,0.99518471956253051758f,0.07968243956565856934f,
0.99682027101516723633f,0.06132073700428009033f,0.99811810255050659180f,
0.04293825849890708923f,0.99907773733139038086f,0.02454122900962829590f,
0.99969881772994995117f,0.00613588467240333557f,0.99998116493225097656f,
-0.01227153837680816650f,0.99992471933364868164f,-0.03067480400204658508f,
0.99952942132949829102f,-0.04906767606735229492f,0.99879544973373413086f,
-0.06744392216205596924f,0.99772304296493530273f,-0.08579730987548828125f,
0.99631261825561523438f,-0.10412163287401199341f,0.99456459283828735352f,
-0.12241067737340927124f,0.99247956275939941406f,-0.14065824449062347412f,
0.99005818367004394531f,-0.15885815024375915527f,0.98730140924453735352f,
-0.17700421810150146484f,0.98421007394790649414f,-0.19509032368659973145f,
0.98078525066375732422f,-0.21311031281948089600f,0.97702813148498535156f,
-0.23105810582637786865f,0.97293996810913085938f,-0.24892760813236236572f,
0.96852207183837890625f,-0.26671275496482849121f,0.96377605199813842773f,
-0.28440752625465393066f,0.95870345830917358398f,-0.30200594663619995117f,
0.95330601930618286133f,-0.31950202584266662598f,0.94758558273315429688f,
-0.33688986301422119141f,0.94154405593872070312f,-0.35416352748870849609f,
0.93518352508544921875f,-0.37131720781326293945f,0.92850607633590698242f,
-0.38834503293037414551f,0.92151403427124023438f,-0.40524131059646606445f,
0.91420978307723999023f,-0.42200025916099548340f,0.90659570693969726562f,
-0.43861624598503112793f,0.89867448806762695312f,-0.45508357882499694824f,
0.89044874906539916992f,-0.47139674425125122070f,0.88192129135131835938f,
-0.48755016922950744629f,0.87309497594833374023f,-0.50353837013244628906f,
0.86397284269332885742f,-0.51935601234436035156f,0.85455799102783203125f,
-0.53499764204025268555f,0.84485357999801635742f,-0.55045795440673828125f,
0.83486288785934448242f,-0.56573182344436645508f,0.82458931207656860352f,
-0.58081394433975219727f,0.81403630971908569336f,-0.59569931030273437500f,
0.80320751667022705078f,-0.61038279533386230469f,0.79210656881332397461f,
-0.62485951185226440430f,0.78073722124099731445f,-0.63912445306777954102f,
0.76910334825515747070f,-0.65317285060882568359f,0.75720882415771484375f,
-0.66699993610382080078f,0.74505776166915893555f,-0.68060100078582763672f,
0.73265427350997924805f,-0.69397145509719848633f,0.72000253200531005859f,
-0.70710676908493041992f,0.70710676908493041992f,-0.72000253200531005859f,
0.69397145509719848633f,-0.73265427350997924805f,0.68060100078582763672f,
-0.74505776166915893555f,0.66699993610382080078f,-0.75720882415771484375f,
0.65317285060882568359f,-0.76910334825515747070f,0.63912445306777954102f,
-0.78073722124099731445f,0.62485951185226440430f,-0.79210656881332397461f,
0.61038279533386230469f,-0.80320751667022705078f,0.59569931030273437500f,
-0.81403630971908569336f,0.58081394433975219727f,-0.82458931207656860352f,
0.56573182344436645508f,-0.83486288785934448242f,0.55045795440673828125f,
-0.84485357999801635742f,0.53499764204025268555f,-0.85455799102783203125f,
0.51935601234436035156f,-0.86397284269332885742f,0.50353837013244628906f,
-0.87309497594833374023f,0.48755016922950744629f,-0.88192129135131835938f,
0.47139674425125122070f,-0.89044874906539916992f,0.45508357882499694824f,
-0.89867448806762695312f,0.43861624598503112793f,-0.90659570693969726562f,
0.42200025916099548340f,-0.91420978307723999023f,0.40524131059646606445f,
-0.92151403427124023438f,0.38834503293037414551f,-0.92850607633590698242f,
0.37131720781326293945f,-0.93518352508544921875f,0.35416352748870849609f,
-0.94154405593872070312f,0.33688986301422119141f,-0.94758558273315429688f,
0.31950202584266662598f,-0.95330601930618286133f,0.30200594663619995117f,
-0.95870345830917358398f,0.28440752625465393066f,-0.96377605199813842773f,
0.26671275496482849121f,-0.96852207183837890625f,0.24892760813236236572f,
-0.97293996810913085938f,0.23105810582637786865f,-0.97702813148498535156f,
0.21311031281948089600f,-0.98078525066375732422f,0.19509032368659973145f,
-0.98421007394790649414f,0.17700421810150146484f,-0.98730140924453735352f,
0.15885815024375915527f,-0.99005818367004394531f,0.14065824449062347412f,
-0.99247956275939941406f,0.12241067737340927124f,-0.99456459283828735352f,
0.10412163287401199341f,-0.99631261825561523438f,0.08579730987548828125f,
-0.99772304296493530273f,0.06744392216205596924f,-0.99879544973373413086f,
0.04906767606735229492f,-0.99952942132949829102f,0.03067480400204658508f,
-0.99992471933364868164f,0.01227153837680816650f,-0.99998116493225097656f,
-0.00613588467240333557f,-0.99969881772994995117f,-0.02454122900962829590f,
-0.99907773733139038086f,-0.04293825849890708923f,-0.99811810255050659180f,
-0.06132073700428009033f,-0.99682027101516723633f,-0.07968243956565856934f,
-0.99518471956253051758f,-0.09801714122295379639f,-0.99321192502975463867f,
-0.11631862819194793701f,-0.99090266227722167969f,-0.13458070158958435059f,
-0.98825758695602416992f,-0.15279719233512878418f,-0.98527765274047851562f,
-0.17096188664436340332f,-0.98196387290954589844f,-0.18906866014003753662f,
-0.97831737995147705078f,-0.20711137354373931885f,-0.97433936595916748047f,
-0.22508391737937927246f,-0.97003126144409179688f,-0.24298018217086791992f,
-0.96539443731307983398f,-0.26079410314559936523f,-0.96043050289154052734f,
-0.27851969003677368164f,-0.95514118671417236328f,-0.29615089297294616699f,
-0.94952815771102905273f,-0.31368175148963928223f,-0.94359344244003295898f,
-0.33110630512237548828f,-0.93733900785446166992f,-0.34841868281364440918f,
-0.93076694011688232422f,-0.36561298370361328125f,-0.92387950420379638672f,
-0.38268342614173889160f,-0.91667908430099487305f,-0.39962419867515563965f,
-0.90916800498962402344f,-0.41642954945564270020f,-0.90134882926940917969f,
-0.43309381604194641113f,-0.89322429895401000977f,-0.44961133599281311035f,
-0.88479709625244140625f,-0.46597650647163391113f,-0.87607008218765258789f,
-0.48218378424644470215f,-0.86704623699188232422f,-0.49822765588760375977f,
-0.85772860050201416016f,-0.51410275697708129883f,-0.84812033176422119141f,
-0.52980363368988037109f,-0.83822470903396606445f,-0.54532498121261596680f,
-0.82804507017135620117f,-0.56066155433654785156f,-0.81758481264114379883f,
-0.57580816745758056641f,-0.80684757232666015625f,-0.59075969457626342773f,
-0.79583692550659179688f,-0.60551106929779052734f,-0.78455656766891479492f,
-0.62005722522735595703f,-0.77301043272018432617f,-0.63439327478408813477f,
-0.76120239496231079102f,-0.64851438999176025391f,-0.74913638830184936523f,
-0.66241580247879028320f,-0.73681658506393432617f,-0.67609268426895141602f,
-0.72424709796905517578f,-0.68954056501388549805f,-0.71143221855163574219f,
-0.70275473594665527344f,-0.69837623834609985352f,-0.71573084592819213867f,
-0.68508368730545043945f,-0.72846436500549316406f,-0.67155897617340087891f,
-0.74095112085342407227f,-0.65780669450759887695f,-0.75318682193756103516f,
-0.64383155107498168945f,-0.76516723632812500000f,-0.62963825464248657227f,
-0.77688848972320556641f,-0.61523157358169555664f,-0.78834640979766845703f,
-0.60061645507812500000f,-0.79953724145889282227f,-0.58579784631729125977f,
-0.81045717000961303711f,-0.57078075408935546875f,-0.82110249996185302734f,
-0.55557024478912353516f,-0.83146959543228149414f,-0.54017144441604614258f,
-0.84155499935150146484f,-0.52458965778350830078f,-0.85135519504547119141f,
-0.50883013010025024414f,-0.86086696386337280273f,-0.49289819598197937012f,
-0.87008696794509887695f,-0.47679921984672546387f,-0.87901222705841064453f,
-0.46053871512413024902f,-0.88763964176177978516f,-0.44412213563919067383f,
-0.89596623182296752930f,-0.42755508422851562500f,-0.90398931503295898438f,
-0.41084316372871398926f,-0.91170603036880493164f,-0.39399203658103942871f,
-0.91911387443542480469f,-0.37700742483139038086f,-0.92621022462844848633f,
-0.35989505052566528320f,-0.93299281597137451172f,-0.34266072511672973633f,
-0.93945920467376708984f,-0.32531028985977172852f,-0.94560730457305908203f,
-0.30784964561462402344f,-0.95143502950668334961f,-0.29028466343879699707f,
-0.95694035291671752930f,-0.27262136340141296387f,-0.96212142705917358398f,
-0.25486564636230468750f,-0.96697646379470825195f,-0.23702360689640045166f,
-0.97150391340255737305f,-0.21910123527050018311f,-0.97570210695266723633f,
-0.20110464096069335938f,-0.97956979274749755859f,-0.18303988873958587646f,
-0.98310548067092895508f,-0.16491311788558959961f,-0.98630809783935546875f,
-0.14673046767711639404f,-0.98917651176452636719f,-0.12849810719490051270f,
-0.99170976877212524414f,-0.11022220551967620850f,-0.99390697479248046875f,
-0.09190895408391952515f,-0.99576741456985473633f,-0.07356456667184829712f,
-0.99729043245315551758f,-0.05519524589180946350f,-0.99847555160522460938f,
-0.03680722415447235107f,-0.99932235479354858398f,-0.01840673014521598816f,
-0.99983060359954833984f,1.00000000000000000000f,0.00000000000000000000f,
0.99729043245315551758f,0.07356456667184829712f,0.98917651176452636719f,
0.14673046767711639404f,0.97570210695266723633f,0.21910123527050018311f,
0.95694035291671752930f,0.29028466343879699707f,0.93299281597137451172f,
0.35989505052566528320f,0.90398931503295898438f,0.42755508422851562500f,
0.87008696794509887695f,0.49289819598197937012f,0.83146959543228149414f,
0.55557024478912353516f,0.78834640979766845703f,0.61523157358169555664f,
0.74095112085342407227f,0.67155897617340087891f,0.68954056501388549805f,
0.72424709796905517578f,0.63439327478408813477f,0.77301043272018432617f,
0.57580816745758056641f,0.81758481264114379883f,0.51410275697708129883f,
0.85772860050201416016f,0.44961133599281311035f,0.89322429895401000977f,
0.38268342614173889160f,0.92387950420379638672f,0.31368175148963928223f,
0.94952815771102905273f,0.24298018217086791992f,0.97003126144409179688f,
0.17096188664436340332f,0.98527765274047851562f,0.09801714122295379639f,
0.99518471956253051758f,0.02454122900962829590f,0.99969881772994995117f,
-0.04906767606735229492f,0.99879544973373413086f,-0.12241067737340927124f,
0.99247956275939941406f,-0.19509032368659973145f,0.98078525066375732422f,
-0.26671275496482849121f,0.96377605199813842773f,-0.33688986301422119141f,
0.94154405593872070312f,-0.40524131059646606445f,0.91420978307723999023f,
-0.47139674425125122070f,0.88192129135131835938f,-0.53499764204025268555f,
0.84485357999801635742f,-0.59569931030273437500f,0.80320751667022705078f,
-0.65317285060882568359f,0.75720882415771484375f,-0.70710676908493041992f,
0.70710676908493041992f,-0.75720882415771484375f,0.65317285060882568359f,
-0.80320751667022705078f,0.59569931030273437500f,-0.84485357999801635742f,
0.53499764204025268555f,-0.88192129135131835938f,0.47139674425125122070f,
-0.91420978307723999023f,0.40524131059646606445f,-0.94154405593872070312f,
0.33688986301422119141f,-0.96377605199813842773f,0.26671275496482849121f,
-0.98078525066375732422f,0.19509032368659973145f,-0.99247956275939941406f,
0.12241067737340927124f,-0.99879544973373413086f,0.04906767606735229492f,
-0.99969881772994995117f,-0.02454122900962829590f,-0.99518471956253051758f,
-0.09801714122295379639f,-0.98527765274047851562f,-0.17096188664436340332f,
-0.97003126144409179688f,-0.24298018217086791992f,-0.94952815771102905273f,
-0.31368175148963928223f,-0.92387950420379638672f,-0.38268342614173889160f,
-0.89322429895401000977f,-0.44961133599281311035f,-0.85772860050201416016f,
-0.51410275697708129883f,-0.81758481264114379883f,-0.57580816745758056641f,
-0.77301043272018432617f,-0.63439327478408813477f,-0.72424709796905517578f,
-0.68954056501388549805f,-0.67155897617340087891f,-0.74095112085342407227f,
-0.61523157358169555664f,-0.78834640979766845703f,-0.55557024478912353516f,
-0.83146959543228149414f,-0.49289819598197937012f,-0.87008696794509887695f,
-0.42755508422851562500f,-0.90398931503295898438f,-0.35989505052566528320f,
-0.93299281597137451172f,-0.29028466343879699707f,-0.95694035291671752930f,
-0.21910123527050018311f,-0.97570210695266723633f,-0.14673046767711639404f,
-0.98917651176452636719f,-0.07356456667184829712f,-0.99729043245315551758f,
1.00000000000000000000f,0.00000000000000000000f,0.95694035291671752930f,
0.29028466343879699707f,0.83146959543228149414f,0.55557024478912353516f,
0.63439327478408813477f,0.77301043272018432617f,0.38268342614173889160f,
0.92387950420379638672f,0.09801714122295379639f,0.99518471956253051758f,
-0.19509032368659973145f,0.98078525066375732422f,-0.47139674425125122070f,
0.88192129135131835938f,-0.70710676908493041992f,0.70710676908493041992f,
-0.88192129135131835938f,0.47139674425125122070f,-0.98078525066375732422f,
0.19509032368659973145f,-0.99518471956253051758f,-0.09801714122295379639f,
-0.92387950420379638672f,-0.38268342614173889160f,-0.77301043272018432617f,
-0.63439327478408813477f,-0.55557024478912353516f,-0.83146959543228149414f,
-0.29028466343879699707f,-0.95694035291671752930f,1.00000000000000000000f,
0.00000000000000000000f,0.38268342614173889160f,0.92387950420379638672f,
-0.70710676908493041992f,0.70710676908493041992f,-0.92387950420379638672f,
-0.38268342614173889160f,};

#endif



#endif /* !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_FFT_ALLOW_TABLES) */
#endif /* defined(ARM_MATH_MVEF) && !defined(ARM_MATH_AUTOVECTORIZE) */



#if defined(ARM_MATH_MVEI) && !defined(ARM_MATH_AUTOVECTORIZE)

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_FFT_ALLOW_TABLES)

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_Q31_16) || defined(ARM_TABLE_TWIDDLECOEF_Q31_32)

uint32_t rearranged_twiddle_tab_stride1_arr_16_q31[2]={
0,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_16_q31[2]={
0,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_16_q31[2]={
0,0,};

q31_t rearranged_twiddle_stride1_16_q31[8]={
0x7FFFFFFF,0x00000000,0x7641AF3D,0xCF043AB3,0x5A82799A,0xA57D8666,0x30FBC54D,
0x89BE50C3,};

q31_t rearranged_twiddle_stride2_16_q31[8]={
0x7FFFFFFF,0x00000000,0x5A82799A,0xA57D8666,0x00000000,0x80000000,0xA57D8666,
0xA57D8666,};

q31_t rearranged_twiddle_stride3_16_q31[8]={
0x7FFFFFFF,0x00000000,0x30FBC54D,0x89BE50C3,0xA57D8666,0xA57D8666,0x89BE50C3,
0x30FBC54D,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_Q31_64) || defined(ARM_TABLE_TWIDDLECOEF_Q31_128)

uint32_t rearranged_twiddle_tab_stride1_arr_64_q31[3]={
0,32,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_64_q31[3]={
0,32,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_64_q31[3]={
0,32,0,};

q31_t rearranged_twiddle_stride1_64_q31[40]={
0x7FFFFFFF,0x00000000,0x7F62368F,0xF3742CA2,0x7D8A5F40,0xE70747C4,0x7A7D055B,
0xDAD7F3A2,0x7641AF3D,0xCF043AB3,0x70E2CBC6,0xC3A94590,0x6A6D98A4,0xB8E31319,
0x62F201AC,0xAECC336C,0x5A82799A,0xA57D8666,0x5133CC94,0x9D0DFE54,0x471CECE7,
0x9592675C,0x3C56BA70,0x8F1D343A,0x30FBC54D,0x89BE50C3,0x25280C5E,0x8582FAA5,
0x18F8B83C,0x8275A0C0,0x0C8BD35E,0x809DC971,0x7FFFFFFF,0x00000000,0x7641AF3D,
0xCF043AB3,0x5A82799A,0xA57D8666,0x30FBC54D,0x89BE50C3,};

q31_t rearranged_twiddle_stride2_64_q31[40]={
0x7FFFFFFF,0x00000000,0x7D8A5F40,0xE70747C4,0x7641AF3D,0xCF043AB3,0x6A6D98A4,
0xB8E31319,0x5A82799A,0xA57D8666,0x471CECE7,0x9592675C,0x30FBC54D,0x89BE50C3,
0x18F8B83C,0x8275A0C0,0x00000000,0x80000000,0xE70747C4,0x8275A0C0,0xCF043AB3,
0x89BE50C3,0xB8E31319,0x9592675C,0xA57D8666,0xA57D8666,0x9592675C,0xB8E31319,
0x89BE50C3,0xCF043AB3,0x8275A0C0,0xE70747C4,0x7FFFFFFF,0x00000000,0x5A82799A,
0xA57D8666,0x00000000,0x80000000,0xA57D8666,0xA57D8666,};

q31_t rearranged_twiddle_stride3_64_q31[40]={
0x7FFFFFFF,0x00000000,0x7A7D055B,0xDAD7F3A2,0x6A6D98A4,0xB8E31319,0x5133CC94,
0x9D0DFE54,0x30FBC54D,0x89BE50C3,0x0C8BD35E,0x809DC971,0xE70747C4,0x8275A0C0,
0xC3A94590,0x8F1D343A,0xA57D8666,0xA57D8666,0x8F1D343A,0xC3A94590,0x8275A0C0,
0xE70747C4,0x809DC971,0x0C8BD35E,0x89BE50C3,0x30FBC54D,0x9D0DFE54,0x5133CC94,
0xB8E31319,0x6A6D98A4,0xDAD7F3A2,0x7A7D055B,0x7FFFFFFF,0x00000000,0x30FBC54D,
0x89BE50C3,0xA57D8666,0xA57D8666,0x89BE50C3,0x30FBC54D,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_Q31_256) || defined(ARM_TABLE_TWIDDLECOEF_Q31_512)

uint32_t rearranged_twiddle_tab_stride1_arr_256_q31[4]={
0,128,160,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_256_q31[4]={
0,128,160,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_256_q31[4]={
0,128,160,0,};

q31_t rearranged_twiddle_stride1_256_q31[168]={
0x7FFFFFFF,0x00000000,0x7FF62182,0xFCDBD541,0x7FD8878E,0xF9B82684,0x7FA736B4,
0xF6956FB7,0x7F62368F,0xF3742CA2,0x7F0991C4,0xF054D8D5,0x7E9D55FC,0xED37EF91,
0x7E1D93EA,0xEA1DEBBB,0x7D8A5F40,0xE70747C4,0x7CE3CEB2,0xE3F47D96,0x7C29FBEE,
0xE0E60685,0x7B5D039E,0xDDDC5B3B,0x7A7D055B,0xDAD7F3A2,0x798A23B1,0xD7D946D8,
0x78848414,0xD4E0CB15,0x776C4EDB,0xD1EEF59E,0x7641AF3D,0xCF043AB3,0x7504D345,
0xCC210D79,0x73B5EBD1,0xC945DFEC,0x72552C85,0xC67322CE,0x70E2CBC6,0xC3A94590,
0x6F5F02B2,0xC0E8B648,0x6DCA0D14,0xBE31E19B,0x6C242960,0xBB8532B0,0x6A6D98A4,
0xB8E31319,0x68A69E81,0xB64BEACD,0x66CF8120,0xB3C0200C,0x64E88926,0xB140175B,
0x62F201AC,0xAECC336C,0x60EC3830,0xAC64D510,0x5ED77C8A,0xAA0A5B2E,0x5CB420E0,
0xA7BD22AC,0x5A82799A,0xA57D8666,0x5842DD54,0xA34BDF20,0x55F5A4D2,0xA1288376,
0x539B2AF0,0x9F13C7D0,0x5133CC94,0x9D0DFE54,0x4EBFE8A5,0x9B1776DA,0x4C3FDFF4,
0x99307EE0,0x49B41533,0x9759617F,0x471CECE7,0x9592675C,0x447ACD50,0x93DBD6A0,
0x41CE1E65,0x9235F2EC,0x3F1749B8,0x90A0FD4E,0x3C56BA70,0x8F1D343A,0x398CDD32,
0x8DAAD37B,0x36BA2014,0x8C4A142F,0x33DEF287,0x8AFB2CBB,0x30FBC54D,0x89BE50C3,
0x2E110A62,0x8893B125,0x2B1F34EB,0x877B7BEC,0x2826B928,0x8675DC4F,0x25280C5E,
0x8582FAA5,0x2223A4C5,0x84A2FC62,0x1F19F97B,0x83D60412,0x1C0B826A,0x831C314E,
0x18F8B83C,0x8275A0C0,0x15E21445,0x81E26C16,0x12C8106F,0x8162AA04,0x0FAB272B,
0x80F66E3C,0x0C8BD35E,0x809DC971,0x096A9049,0x8058C94C,0x0647D97C,0x80277872,
0x03242ABF,0x8009DE7E,0x7FFFFFFF,0x00000000,0x7F62368F,0xF3742CA2,0x7D8A5F40,
0xE70747C4,0x7A7D055B,0xDAD7F3A2,0x7641AF3D,0xCF043AB3,0x70E2CBC6,0xC3A94590,
0x6A6D98A4,0xB8E31319,0x62F201AC,0xAECC336C,0x5A82799A,0xA57D8666,0x5133CC94,
0x9D0DFE54,0x471CECE7,0x9592675C,0x3C56BA70,0x8F1D343A,0x30FBC54D,0x89BE50C3,
0x25280C5E,0x8582FAA5,0x18F8B83C,0x8275A0C0,0x0C8BD35E,0x809DC971,0x7FFFFFFF,
0x00000000,0x7641AF3D,0xCF043AB3,0x5A82799A,0xA57D8666,0x30FBC54D,0x89BE50C3,};

q31_t rearranged_twiddle_stride2_256_q31[168]={
0x7FFFFFFF,0x00000000,0x7FD8878E,0xF9B82684,0x7F62368F,0xF3742CA2,0x7E9D55FC,
0xED37EF91,0x7D8A5F40,0xE70747C4,0x7C29FBEE,0xE0E60685,0x7A7D055B,0xDAD7F3A2,
0x78848414,0xD4E0CB15,0x7641AF3D,0xCF043AB3,0x73B5EBD1,0xC945DFEC,0x70E2CBC6,
0xC3A94590,0x6DCA0D14,0xBE31E19B,0x6A6D98A4,0xB8E31319,0x66CF8120,0xB3C0200C,
0x62F201AC,0xAECC336C,0x5ED77C8A,0xAA0A5B2E,0x5A82799A,0xA57D8666,0x55F5A4D2,
0xA1288376,0x5133CC94,0x9D0DFE54,0x4C3FDFF4,0x99307EE0,0x471CECE7,0x9592675C,
0x41CE1E65,0x9235F2EC,0x3C56BA70,0x8F1D343A,0x36BA2014,0x8C4A142F,0x30FBC54D,
0x89BE50C3,0x2B1F34EB,0x877B7BEC,0x25280C5E,0x8582FAA5,0x1F19F97B,0x83D60412,
0x18F8B83C,0x8275A0C0,0x12C8106F,0x8162AA04,0x0C8BD35E,0x809DC971,0x0647D97C,
0x80277872,0x00000000,0x80000000,0xF9B82684,0x80277872,0xF3742CA2,0x809DC971,
0xED37EF91,0x8162AA04,0xE70747C4,0x8275A0C0,0xE0E60685,0x83D60412,0xDAD7F3A2,
0x8582FAA5,0xD4E0CB15,0x877B7BEC,0xCF043AB3,0x89BE50C3,0xC945DFEC,0x8C4A142F,
0xC3A94590,0x8F1D343A,0xBE31E19B,0x9235F2EC,0xB8E31319,0x9592675C,0xB3C0200C,
0x99307EE0,0xAECC336C,0x9D0DFE54,0xAA0A5B2E,0xA1288376,0xA57D8666,0xA57D8666,
0xA1288376,0xAA0A5B2E,0x9D0DFE54,0xAECC336C,0x99307EE0,0xB3C0200C,0x9592675C,
0xB8E31319,0x9235F2EC,0xBE31E19B,0x8F1D343A,0xC3A94590,0x8C4A142F,0xC945DFEC,
0x89BE50C3,0xCF043AB3,0x877B7BEC,0xD4E0CB15,0x8582FAA5,0xDAD7F3A2,0x83D60412,
0xE0E60685,0x8275A0C0,0xE70747C4,0x8162AA04,0xED37EF91,0x809DC971,0xF3742CA2,
0x80277872,0xF9B82684,0x7FFFFFFF,0x00000000,0x7D8A5F40,0xE70747C4,0x7641AF3D,
0xCF043AB3,0x6A6D98A4,0xB8E31319,0x5A82799A,0xA57D8666,0x471CECE7,0x9592675C,
0x30FBC54D,0x89BE50C3,0x18F8B83C,0x8275A0C0,0x00000000,0x80000000,0xE70747C4,
0x8275A0C0,0xCF043AB3,0x89BE50C3,0xB8E31319,0x9592675C,0xA57D8666,0xA57D8666,
0x9592675C,0xB8E31319,0x89BE50C3,0xCF043AB3,0x8275A0C0,0xE70747C4,0x7FFFFFFF,
0x00000000,0x5A82799A,0xA57D8666,0x00000000,0x80000000,0xA57D8666,0xA57D8666,};

q31_t rearranged_twiddle_stride3_256_q31[168]={
0x7FFFFFFF,0x00000000,0x7FA736B4,0xF6956FB7,0x7E9D55FC,0xED37EF91,0x7CE3CEB2,
0xE3F47D96,0x7A7D055B,0xDAD7F3A2,0x776C4EDB,0xD1EEF59E,0x73B5EBD1,0xC945DFEC,
0x6F5F02B2,0xC0E8B648,0x6A6D98A4,0xB8E31319,0x64E88926,0xB140175B,0x5ED77C8A,
0xAA0A5B2E,0x5842DD54,0xA34BDF20,0x5133CC94,0x9D0DFE54,0x49B41533,0x9759617F,
0x41CE1E65,0x9235F2EC,0x398CDD32,0x8DAAD37B,0x30FBC54D,0x89BE50C3,0x2826B928,
0x8675DC4F,0x1F19F97B,0x83D60412,0x15E21445,0x81E26C16,0x0C8BD35E,0x809DC971,
0x03242ABF,0x8009DE7E,0xF9B82684,0x80277872,0xF054D8D5,0x80F66E3C,0xE70747C4,
0x8275A0C0,0xDDDC5B3B,0x84A2FC62,0xD4E0CB15,0x877B7BEC,0xCC210D79,0x8AFB2CBB,
0xC3A94590,0x8F1D343A,0xBB8532B0,0x93DBD6A0,0xB3C0200C,0x99307EE0,0xAC64D510,
0x9F13C7D0,0xA57D8666,0xA57D8666,0x9F13C7D0,0xAC64D510,0x99307EE0,0xB3C0200C,
0x93DBD6A0,0xBB8532B0,0x8F1D343A,0xC3A94590,0x8AFB2CBB,0xCC210D79,0x877B7BEC,
0xD4E0CB15,0x84A2FC62,0xDDDC5B3B,0x8275A0C0,0xE70747C4,0x80F66E3C,0xF054D8D5,
0x80277872,0xF9B82684,0x8009DE7E,0x03242ABF,0x809DC971,0x0C8BD35E,0x81E26C16,
0x15E21445,0x83D60412,0x1F19F97B,0x8675DC4F,0x2826B928,0x89BE50C3,0x30FBC54D,
0x8DAAD37B,0x398CDD32,0x9235F2EC,0x41CE1E65,0x9759617F,0x49B41533,0x9D0DFE54,
0x5133CC94,0xA34BDF20,0x5842DD54,0xAA0A5B2E,0x5ED77C8A,0xB140175B,0x64E88926,
0xB8E31319,0x6A6D98A4,0xC0E8B648,0x6F5F02B2,0xC945DFEC,0x73B5EBD1,0xD1EEF59E,
0x776C4EDB,0xDAD7F3A2,0x7A7D055B,0xE3F47D96,0x7CE3CEB2,0xED37EF91,0x7E9D55FC,
0xF6956FB7,0x7FA736B4,0x7FFFFFFF,0x00000000,0x7A7D055B,0xDAD7F3A2,0x6A6D98A4,
0xB8E31319,0x5133CC94,0x9D0DFE54,0x30FBC54D,0x89BE50C3,0x0C8BD35E,0x809DC971,
0xE70747C4,0x8275A0C0,0xC3A94590,0x8F1D343A,0xA57D8666,0xA57D8666,0x8F1D343A,
0xC3A94590,0x8275A0C0,0xE70747C4,0x809DC971,0x0C8BD35E,0x89BE50C3,0x30FBC54D,
0x9D0DFE54,0x5133CC94,0xB8E31319,0x6A6D98A4,0xDAD7F3A2,0x7A7D055B,0x7FFFFFFF,
0x00000000,0x30FBC54D,0x89BE50C3,0xA57D8666,0xA57D8666,0x89BE50C3,0x30FBC54D,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_Q31_1024) || defined(ARM_TABLE_TWIDDLECOEF_Q31_2048)

uint32_t rearranged_twiddle_tab_stride1_arr_1024_q31[5]={
0,512,640,672,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_1024_q31[5]={
0,512,640,672,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_1024_q31[5]={
0,512,640,672,0,};

q31_t rearranged_twiddle_stride1_1024_q31[680]={
0x7FFFFFFF,0x00000000,0x7FFF6216,0xFF36F078,0x7FFD885A,0xFE6DE2E0,0x7FFA72D1,
0xFDA4D929,0x7FF62182,0xFCDBD541,0x7FF09478,0xFC12D91A,0x7FE9CBC0,0xFB49E6A3,
0x7FE1C76B,0xFA80FFCB,0x7FD8878E,0xF9B82684,0x7FCE0C3E,0xF8EF5CBB,0x7FC25596,
0xF826A462,0x7FB563B3,0xF75DFF66,0x7FA736B4,0xF6956FB7,0x7F97CEBD,0xF5CCF743,
0x7F872BF3,0xF50497FB,0x7F754E80,0xF43C53CB,0x7F62368F,0xF3742CA2,0x7F4DE451,
0xF2AC246E,0x7F3857F6,0xF1E43D1C,0x7F2191B4,0xF11C789A,0x7F0991C4,0xF054D8D5,
0x7EF05860,0xEF8D5FB8,0x7ED5E5C6,0xEEC60F31,0x7EBA3A39,0xEDFEE92B,0x7E9D55FC,
0xED37EF91,0x7E7F3957,0xEC71244F,0x7E5FE493,0xEBAA894F,0x7E3F57FF,0xEAE4207A,
0x7E1D93EA,0xEA1DEBBB,0x7DFA98A8,0xE957ECFB,0x7DD6668F,0xE8922622,0x7DB0FDF8,
0xE7CC9917,0x7D8A5F40,0xE70747C4,0x7D628AC6,0xE642340D,0x7D3980EC,0xE57D5FDA,
0x7D0F4218,0xE4B8CD11,0x7CE3CEB2,0xE3F47D96,0x7CB72724,0xE330734D,0x7C894BDE,
0xE26CB01B,0x7C5A3D50,0xE1A935E2,0x7C29FBEE,0xE0E60685,0x7BF88830,0xE02323E5,
0x7BC5E290,0xDF608FE4,0x7B920B89,0xDE9E4C60,0x7B5D039E,0xDDDC5B3B,0x7B26CB4F,
0xDD1ABE51,0x7AEF6323,0xDC597781,0x7AB6CBA4,0xDB9888A8,0x7A7D055B,0xDAD7F3A2,
0x7A4210D8,0xDA17BA4A,0x7A05EEAD,0xD957DE7A,0x79C89F6E,0xD898620C,0x798A23B1,
0xD7D946D8,0x794A7C12,0xD71A8EB5,0x7909A92D,0xD65C3B7B,0x78C7ABA2,0xD59E4EFF,
0x78848414,0xD4E0CB15,0x78403329,0xD423B191,0x77FAB989,0xD3670446,0x77B417DF,
0xD2AAC504,0x776C4EDB,0xD1EEF59E,0x77235F2D,0xD13397E2,0x76D94989,0xD078AD9E,
0x768E0EA6,0xCFBE389F,0x7641AF3D,0xCF043AB3,0x75F42C0B,0xCE4AB5A2,0x75A585CF,
0xCD91AB39,0x7555BD4C,0xCCD91D3D,0x7504D345,0xCC210D79,0x74B2C884,0xCB697DB0,
0x745F9DD1,0xCAB26FA9,0x740B53FB,0xC9FBE527,0x73B5EBD1,0xC945DFEC,0x735F6626,
0xC89061BA,0x7307C3D0,0xC7DB6C50,0x72AF05A7,0xC727016D,0x72552C85,0xC67322CE,
0x71FA3949,0xC5BFD22E,0x719E2CD2,0xC50D1149,0x71410805,0xC45AE1D7,0x70E2CBC6,
0xC3A94590,0x708378FF,0xC2F83E2A,0x7023109A,0xC247CD5A,0x6FC19385,0xC197F4D4,
0x6F5F02B2,0xC0E8B648,0x6EFB5F12,0xC03A1368,0x6E96A99D,0xBF8C0DE3,0x6E30E34A,
0xBEDEA765,0x6DCA0D14,0xBE31E19B,0x6D6227FA,0xBD85BE30,0x6CF934FC,0xBCDA3ECB,
0x6C8F351C,0xBC2F6513,0x6C242960,0xBB8532B0,0x6BB812D1,0xBADBA943,0x6B4AF279,
0xBA32CA71,0x6ADCC964,0xB98A97D8,0x6A6D98A4,0xB8E31319,0x69FD614A,0xB83C3DD1,
0x698C246C,0xB796199B,0x6919E320,0xB6F0A812,0x68A69E81,0xB64BEACD,0x683257AB,
0xB5A7E362,0x67BD0FBD,0xB5049368,0x6746C7D8,0xB461FC70,0x66CF8120,0xB3C0200C,
0x66573CBB,0xB31EFFCC,0x65DDFBD3,0xB27E9D3C,0x6563BF92,0xB1DEF9E9,0x64E88926,
0xB140175B,0x646C59BF,0xB0A1F71D,0x63EF3290,0xB0049AB3,0x637114CC,0xAF6803A2,
0x62F201AC,0xAECC336C,0x6271FA69,0xAE312B92,0x61F1003F,0xAD96ED92,0x616F146C,
0xACFD7AE8,0x60EC3830,0xAC64D510,0x60686CCF,0xABCCFD83,0x5FE3B38D,0xAB35F5B5,
0x5F5E0DB3,0xAA9FBF1E,0x5ED77C8A,0xAA0A5B2E,0x5E50015D,0xA975CB57,0x5DC79D7C,
0xA8E21106,0x5D3E5237,0xA84F2DAA,0x5CB420E0,0xA7BD22AC,0x5C290ACC,0xA72BF174,
0x5B9D1154,0xA69B9B68,0x5B1035CF,0xA60C21EE,0x5A82799A,0xA57D8666,0x59F3DE12,
0xA4EFCA31,0x59646498,0xA462EEAC,0x58D40E8C,0xA3D6F534,0x5842DD54,0xA34BDF20,
0x57B0D256,0xA2C1ADC9,0x571DEEFA,0xA2386284,0x568A34A9,0xA1AFFEA3,0x55F5A4D2,
0xA1288376,0x556040E2,0xA0A1F24D,0x54CA0A4B,0xA01C4C73,0x5433027D,0x9F979331,
0x539B2AF0,0x9F13C7D0,0x53028518,0x9E90EB94,0x5269126E,0x9E0EFFC1,0x51CED46E,
0x9D8E0597,0x5133CC94,0x9D0DFE54,0x5097FC5E,0x9C8EEB34,0x4FFB654D,0x9C10CD70,
0x4F5E08E3,0x9B93A641,0x4EBFE8A5,0x9B1776DA,0x4E210617,0x9A9C406E,0x4D8162C4,
0x9A22042D,0x4CE10034,0x99A8C345,0x4C3FDFF4,0x99307EE0,0x4B9E0390,0x98B93828,
0x4AFB6C98,0x9842F043,0x4A581C9E,0x97CDA855,0x49B41533,0x9759617F,0x490F57EE,
0x96E61CE0,0x4869E665,0x9673DB94,0x47C3C22F,0x96029EB6,0x471CECE7,0x9592675C,
0x46756828,0x9523369C,0x45CD358F,0x94B50D87,0x452456BD,0x9447ED2F,0x447ACD50,
0x93DBD6A0,0x43D09AED,0x9370CAE4,0x4325C135,0x9306CB04,0x427A41D0,0x929DD806,
0x41CE1E65,0x9235F2EC,0x4121589B,0x91CF1CB6,0x4073F21D,0x91695663,0x3FC5EC98,
0x9104A0EE,0x3F1749B8,0x90A0FD4E,0x3E680B2C,0x903E6C7B,0x3DB832A6,0x8FDCEF66,
0x3D07C1D6,0x8F7C8701,0x3C56BA70,0x8F1D343A,0x3BA51E29,0x8EBEF7FB,0x3AF2EEB7,
0x8E61D32E,0x3A402DD2,0x8E05C6B7,0x398CDD32,0x8DAAD37B,0x38D8FE93,0x8D50FA59,
0x382493B0,0x8CF83C30,0x376F9E46,0x8CA099DA,0x36BA2014,0x8C4A142F,0x36041AD9,
0x8BF4AC05,0x354D9057,0x8BA0622F,0x34968250,0x8B4D377C,0x33DEF287,0x8AFB2CBB,
0x3326E2C3,0x8AAA42B4,0x326E54C7,0x8A5A7A31,0x31B54A5E,0x8A0BD3F5,0x30FBC54D,
0x89BE50C3,0x3041C761,0x8971F15A,0x2F875262,0x8926B677,0x2ECC681E,0x88DCA0D3,
0x2E110A62,0x8893B125,0x2D553AFC,0x884BE821,0x2C98FBBA,0x88054677,0x2BDC4E6F,
0x87BFCCD7,0x2B1F34EB,0x877B7BEC,0x2A61B101,0x8738545E,0x29A3C485,0x86F656D3,
0x28E5714B,0x86B583EE,0x2826B928,0x8675DC4F,0x27679DF4,0x86376092,0x26A82186,
0x85FA1153,0x25E845B6,0x85BDEF28,0x25280C5E,0x8582FAA5,0x24677758,0x8549345C,
0x23A6887F,0x85109CDD,0x22E541AF,0x84D934B1,0x2223A4C5,0x84A2FC62,0x2161B3A0,
0x846DF477,0x209F701C,0x843A1D70,0x1FDCDC1B,0x840777D0,0x1F19F97B,0x83D60412,
0x1E56CA1E,0x83A5C2B0,0x1D934FE5,0x8376B422,0x1CCF8CB3,0x8348D8DC,0x1C0B826A,
0x831C314E,0x1B4732EF,0x82F0BDE8,0x1A82A026,0x82C67F14,0x19BDCBF3,0x829D753A,
0x18F8B83C,0x8275A0C0,0x183366E9,0x824F0208,0x176DD9DE,0x82299971,0x16A81305,
0x82056758,0x15E21445,0x81E26C16,0x151BDF86,0x81C0A801,0x145576B1,0x81A01B6D,
0x138EDBB1,0x8180C6A9,0x12C8106F,0x8162AA04,0x120116D5,0x8145C5C7,0x1139F0CF,
0x812A1A3A,0x1072A048,0x810FA7A0,0x0FAB272B,0x80F66E3C,0x0EE38766,0x80DE6E4C,
0x0E1BC2E4,0x80C7A80A,0x0D53DB92,0x80B21BAF,0x0C8BD35E,0x809DC971,0x0BC3AC35,
0x808AB180,0x0AFB6805,0x8078D40D,0x0A3308BD,0x80683143,0x096A9049,0x8058C94C,
0x08A2009A,0x804A9C4D,0x07D95B9E,0x803DAA6A,0x0710A345,0x8031F3C2,0x0647D97C,
0x80277872,0x057F0035,0x801E3895,0x04B6195D,0x80163440,0x03ED26E6,0x800F6B88,
0x03242ABF,0x8009DE7E,0x025B26D7,0x80058D2F,0x01921D20,0x800277A6,0x00C90F88,
0x80009DEA,0x7FFFFFFF,0x00000000,0x7FF62182,0xFCDBD541,0x7FD8878E,0xF9B82684,
0x7FA736B4,0xF6956FB7,0x7F62368F,0xF3742CA2,0x7F0991C4,0xF054D8D5,0x7E9D55FC,
0xED37EF91,0x7E1D93EA,0xEA1DEBBB,0x7D8A5F40,0xE70747C4,0x7CE3CEB2,0xE3F47D96,
0x7C29FBEE,0xE0E60685,0x7B5D039E,0xDDDC5B3B,0x7A7D055B,0xDAD7F3A2,0x798A23B1,
0xD7D946D8,0x78848414,0xD4E0CB15,0x776C4EDB,0xD1EEF59E,0x7641AF3D,0xCF043AB3,
0x7504D345,0xCC210D79,0x73B5EBD1,0xC945DFEC,0x72552C85,0xC67322CE,0x70E2CBC6,
0xC3A94590,0x6F5F02B2,0xC0E8B648,0x6DCA0D14,0xBE31E19B,0x6C242960,0xBB8532B0,
0x6A6D98A4,0xB8E31319,0x68A69E81,0xB64BEACD,0x66CF8120,0xB3C0200C,0x64E88926,
0xB140175B,0x62F201AC,0xAECC336C,0x60EC3830,0xAC64D510,0x5ED77C8A,0xAA0A5B2E,
0x5CB420E0,0xA7BD22AC,0x5A82799A,0xA57D8666,0x5842DD54,0xA34BDF20,0x55F5A4D2,
0xA1288376,0x539B2AF0,0x9F13C7D0,0x5133CC94,0x9D0DFE54,0x4EBFE8A5,0x9B1776DA,
0x4C3FDFF4,0x99307EE0,0x49B41533,0x9759617F,0x471CECE7,0x9592675C,0x447ACD50,
0x93DBD6A0,0x41CE1E65,0x9235F2EC,0x3F1749B8,0x90A0FD4E,0x3C56BA70,0x8F1D343A,
0x398CDD32,0x8DAAD37B,0x36BA2014,0x8C4A142F,0x33DEF287,0x8AFB2CBB,0x30FBC54D,
0x89BE50C3,0x2E110A62,0x8893B125,0x2B1F34EB,0x877B7BEC,0x2826B928,0x8675DC4F,
0x25280C5E,0x8582FAA5,0x2223A4C5,0x84A2FC62,0x1F19F97B,0x83D60412,0x1C0B826A,
0x831C314E,0x18F8B83C,0x8275A0C0,0x15E21445,0x81E26C16,0x12C8106F,0x8162AA04,
0x0FAB272B,0x80F66E3C,0x0C8BD35E,0x809DC971,0x096A9049,0x8058C94C,0x0647D97C,
0x80277872,0x03242ABF,0x8009DE7E,0x7FFFFFFF,0x00000000,0x7F62368F,0xF3742CA2,
0x7D8A5F40,0xE70747C4,0x7A7D055B,0xDAD7F3A2,0x7641AF3D,0xCF043AB3,0x70E2CBC6,
0xC3A94590,0x6A6D98A4,0xB8E31319,0x62F201AC,0xAECC336C,0x5A82799A,0xA57D8666,
0x5133CC94,0x9D0DFE54,0x471CECE7,0x9592675C,0x3C56BA70,0x8F1D343A,0x30FBC54D,
0x89BE50C3,0x25280C5E,0x8582FAA5,0x18F8B83C,0x8275A0C0,0x0C8BD35E,0x809DC971,
0x7FFFFFFF,0x00000000,0x7641AF3D,0xCF043AB3,0x5A82799A,0xA57D8666,0x30FBC54D,
0x89BE50C3,};

q31_t rearranged_twiddle_stride2_1024_q31[680]={
0x7FFFFFFF,0x00000000,0x7FFD885A,0xFE6DE2E0,0x7FF62182,0xFCDBD541,0x7FE9CBC0,
0xFB49E6A3,0x7FD8878E,0xF9B82684,0x7FC25596,0xF826A462,0x7FA736B4,0xF6956FB7,
0x7F872BF3,0xF50497FB,0x7F62368F,0xF3742CA2,0x7F3857F6,0xF1E43D1C,0x7F0991C4,
0xF054D8D5,0x7ED5E5C6,0xEEC60F31,0x7E9D55FC,0xED37EF91,0x7E5FE493,0xEBAA894F,
0x7E1D93EA,0xEA1DEBBB,0x7DD6668F,0xE8922622,0x7D8A5F40,0xE70747C4,0x7D3980EC,
0xE57D5FDA,0x7CE3CEB2,0xE3F47D96,0x7C894BDE,0xE26CB01B,0x7C29FBEE,0xE0E60685,
0x7BC5E290,0xDF608FE4,0x7B5D039E,0xDDDC5B3B,0x7AEF6323,0xDC597781,0x7A7D055B,
0xDAD7F3A2,0x7A05EEAD,0xD957DE7A,0x798A23B1,0xD7D946D8,0x7909A92D,0xD65C3B7B,
0x78848414,0xD4E0CB15,0x77FAB989,0xD3670446,0x776C4EDB,0xD1EEF59E,0x76D94989,
0xD078AD9E,0x7641AF3D,0xCF043AB3,0x75A585CF,0xCD91AB39,0x7504D345,0xCC210D79,
0x745F9DD1,0xCAB26FA9,0x73B5EBD1,0xC945DFEC,0x7307C3D0,0xC7DB6C50,0x72552C85,
0xC67322CE,0x719E2CD2,0xC50D1149,0x70E2CBC6,0xC3A94590,0x7023109A,0xC247CD5A,
0x6F5F02B2,0xC0E8B648,0x6E96A99D,0xBF8C0DE3,0x6DCA0D14,0xBE31E19B,0x6CF934FC,
0xBCDA3ECB,0x6C242960,0xBB8532B0,0x6B4AF279,0xBA32CA71,0x6A6D98A4,0xB8E31319,
0x698C246C,0xB796199B,0x68A69E81,0xB64BEACD,0x67BD0FBD,0xB5049368,0x66CF8120,
0xB3C0200C,0x65DDFBD3,0xB27E9D3C,0x64E88926,0xB140175B,0x63EF3290,0xB0049AB3,
0x62F201AC,0xAECC336C,0x61F1003F,0xAD96ED92,0x60EC3830,0xAC64D510,0x5FE3B38D,
0xAB35F5B5,0x5ED77C8A,0xAA0A5B2E,0x5DC79D7C,0xA8E21106,0x5CB420E0,0xA7BD22AC,
0x5B9D1154,0xA69B9B68,0x5A82799A,0xA57D8666,0x59646498,0xA462EEAC,0x5842DD54,
0xA34BDF20,0x571DEEFA,0xA2386284,0x55F5A4D2,0xA1288376,0x54CA0A4B,0xA01C4C73,
0x539B2AF0,0x9F13C7D0,0x5269126E,0x9E0EFFC1,0x5133CC94,0x9D0DFE54,0x4FFB654D,
0x9C10CD70,0x4EBFE8A5,0x9B1776DA,0x4D8162C4,0x9A22042D,0x4C3FDFF4,0x99307EE0,
0x4AFB6C98,0x9842F043,0x49B41533,0x9759617F,0x4869E665,0x9673DB94,0x471CECE7,
0x9592675C,0x45CD358F,0x94B50D87,0x447ACD50,0x93DBD6A0,0x4325C135,0x9306CB04,
0x41CE1E65,0x9235F2EC,0x4073F21D,0x91695663,0x3F1749B8,0x90A0FD4E,0x3DB832A6,
0x8FDCEF66,0x3C56BA70,0x8F1D343A,0x3AF2EEB7,0x8E61D32E,0x398CDD32,0x8DAAD37B,
0x382493B0,0x8CF83C30,0x36BA2014,0x8C4A142F,0x354D9057,0x8BA0622F,0x33DEF287,
0x8AFB2CBB,0x326E54C7,0x8A5A7A31,0x30FBC54D,0x89BE50C3,0x2F875262,0x8926B677,
0x2E110A62,0x8893B125,0x2C98FBBA,0x88054677,0x2B1F34EB,0x877B7BEC,0x29A3C485,
0x86F656D3,0x2826B928,0x8675DC4F,0x26A82186,0x85FA1153,0x25280C5E,0x8582FAA5,
0x23A6887F,0x85109CDD,0x2223A4C5,0x84A2FC62,0x209F701C,0x843A1D70,0x1F19F97B,
0x83D60412,0x1D934FE5,0x8376B422,0x1C0B826A,0x831C314E,0x1A82A026,0x82C67F14,
0x18F8B83C,0x8275A0C0,0x176DD9DE,0x82299971,0x15E21445,0x81E26C16,0x145576B1,
0x81A01B6D,0x12C8106F,0x8162AA04,0x1139F0CF,0x812A1A3A,0x0FAB272B,0x80F66E3C,
0x0E1BC2E4,0x80C7A80A,0x0C8BD35E,0x809DC971,0x0AFB6805,0x8078D40D,0x096A9049,
0x8058C94C,0x07D95B9E,0x803DAA6A,0x0647D97C,0x80277872,0x04B6195D,0x80163440,
0x03242ABF,0x8009DE7E,0x01921D20,0x800277A6,0x00000000,0x80000000,0xFE6DE2E0,
0x800277A6,0xFCDBD541,0x8009DE7E,0xFB49E6A3,0x80163440,0xF9B82684,0x80277872,
0xF826A462,0x803DAA6A,0xF6956FB7,0x8058C94C,0xF50497FB,0x8078D40D,0xF3742CA2,
0x809DC971,0xF1E43D1C,0x80C7A80A,0xF054D8D5,0x80F66E3C,0xEEC60F31,0x812A1A3A,
0xED37EF91,0x8162AA04,0xEBAA894F,0x81A01B6D,0xEA1DEBBB,0x81E26C16,0xE8922622,
0x82299971,0xE70747C4,0x8275A0C0,0xE57D5FDA,0x82C67F14,0xE3F47D96,0x831C314E,
0xE26CB01B,0x8376B422,0xE0E60685,0x83D60412,0xDF608FE4,0x843A1D70,0xDDDC5B3B,
0x84A2FC62,0xDC597781,0x85109CDD,0xDAD7F3A2,0x8582FAA5,0xD957DE7A,0x85FA1153,
0xD7D946D8,0x8675DC4F,0xD65C3B7B,0x86F656D3,0xD4E0CB15,0x877B7BEC,0xD3670446,
0x88054677,0xD1EEF59E,0x8893B125,0xD078AD9E,0x8926B677,0xCF043AB3,0x89BE50C3,
0xCD91AB39,0x8A5A7A31,0xCC210D79,0x8AFB2CBB,0xCAB26FA9,0x8BA0622F,0xC945DFEC,
0x8C4A142F,0xC7DB6C50,0x8CF83C30,0xC67322CE,0x8DAAD37B,0xC50D1149,0x8E61D32E,
0xC3A94590,0x8F1D343A,0xC247CD5A,0x8FDCEF66,0xC0E8B648,0x90A0FD4E,0xBF8C0DE3,
0x91695663,0xBE31E19B,0x9235F2EC,0xBCDA3ECB,0x9306CB04,0xBB8532B0,0x93DBD6A0,
0xBA32CA71,0x94B50D87,0xB8E31319,0x9592675C,0xB796199B,0x9673DB94,0xB64BEACD,
0x9759617F,0xB5049368,0x9842F043,0xB3C0200C,0x99307EE0,0xB27E9D3C,0x9A22042D,
0xB140175B,0x9B1776DA,0xB0049AB3,0x9C10CD70,0xAECC336C,0x9D0DFE54,0xAD96ED92,
0x9E0EFFC1,0xAC64D510,0x9F13C7D0,0xAB35F5B5,0xA01C4C73,0xAA0A5B2E,0xA1288376,
0xA8E21106,0xA2386284,0xA7BD22AC,0xA34BDF20,0xA69B9B68,0xA462EEAC,0xA57D8666,
0xA57D8666,0xA462EEAC,0xA69B9B68,0xA34BDF20,0xA7BD22AC,0xA2386284,0xA8E21106,
0xA1288376,0xAA0A5B2E,0xA01C4C73,0xAB35F5B5,0x9F13C7D0,0xAC64D510,0x9E0EFFC1,
0xAD96ED92,0x9D0DFE54,0xAECC336C,0x9C10CD70,0xB0049AB3,0x9B1776DA,0xB140175B,
0x9A22042D,0xB27E9D3C,0x99307EE0,0xB3C0200C,0x9842F043,0xB5049368,0x9759617F,
0xB64BEACD,0x9673DB94,0xB796199B,0x9592675C,0xB8E31319,0x94B50D87,0xBA32CA71,
0x93DBD6A0,0xBB8532B0,0x9306CB04,0xBCDA3ECB,0x9235F2EC,0xBE31E19B,0x91695663,
0xBF8C0DE3,0x90A0FD4E,0xC0E8B648,0x8FDCEF66,0xC247CD5A,0x8F1D343A,0xC3A94590,
0x8E61D32E,0xC50D1149,0x8DAAD37B,0xC67322CE,0x8CF83C30,0xC7DB6C50,0x8C4A142F,
0xC945DFEC,0x8BA0622F,0xCAB26FA9,0x8AFB2CBB,0xCC210D79,0x8A5A7A31,0xCD91AB39,
0x89BE50C3,0xCF043AB3,0x8926B677,0xD078AD9E,0x8893B125,0xD1EEF59E,0x88054677,
0xD3670446,0x877B7BEC,0xD4E0CB15,0x86F656D3,0xD65C3B7B,0x8675DC4F,0xD7D946D8,
0x85FA1153,0xD957DE7A,0x8582FAA5,0xDAD7F3A2,0x85109CDD,0xDC597781,0x84A2FC62,
0xDDDC5B3B,0x843A1D70,0xDF608FE4,0x83D60412,0xE0E60685,0x8376B422,0xE26CB01B,
0x831C314E,0xE3F47D96,0x82C67F14,0xE57D5FDA,0x8275A0C0,0xE70747C4,0x82299971,
0xE8922622,0x81E26C16,0xEA1DEBBB,0x81A01B6D,0xEBAA894F,0x8162AA04,0xED37EF91,
0x812A1A3A,0xEEC60F31,0x80F66E3C,0xF054D8D5,0x80C7A80A,0xF1E43D1C,0x809DC971,
0xF3742CA2,0x8078D40D,0xF50497FB,0x8058C94C,0xF6956FB7,0x803DAA6A,0xF826A462,
0x80277872,0xF9B82684,0x80163440,0xFB49E6A3,0x8009DE7E,0xFCDBD541,0x800277A6,
0xFE6DE2E0,0x7FFFFFFF,0x00000000,0x7FD8878E,0xF9B82684,0x7F62368F,0xF3742CA2,
0x7E9D55FC,0xED37EF91,0x7D8A5F40,0xE70747C4,0x7C29FBEE,0xE0E60685,0x7A7D055B,
0xDAD7F3A2,0x78848414,0xD4E0CB15,0x7641AF3D,0xCF043AB3,0x73B5EBD1,0xC945DFEC,
0x70E2CBC6,0xC3A94590,0x6DCA0D14,0xBE31E19B,0x6A6D98A4,0xB8E31319,0x66CF8120,
0xB3C0200C,0x62F201AC,0xAECC336C,0x5ED77C8A,0xAA0A5B2E,0x5A82799A,0xA57D8666,
0x55F5A4D2,0xA1288376,0x5133CC94,0x9D0DFE54,0x4C3FDFF4,0x99307EE0,0x471CECE7,
0x9592675C,0x41CE1E65,0x9235F2EC,0x3C56BA70,0x8F1D343A,0x36BA2014,0x8C4A142F,
0x30FBC54D,0x89BE50C3,0x2B1F34EB,0x877B7BEC,0x25280C5E,0x8582FAA5,0x1F19F97B,
0x83D60412,0x18F8B83C,0x8275A0C0,0x12C8106F,0x8162AA04,0x0C8BD35E,0x809DC971,
0x0647D97C,0x80277872,0x00000000,0x80000000,0xF9B82684,0x80277872,0xF3742CA2,
0x809DC971,0xED37EF91,0x8162AA04,0xE70747C4,0x8275A0C0,0xE0E60685,0x83D60412,
0xDAD7F3A2,0x8582FAA5,0xD4E0CB15,0x877B7BEC,0xCF043AB3,0x89BE50C3,0xC945DFEC,
0x8C4A142F,0xC3A94590,0x8F1D343A,0xBE31E19B,0x9235F2EC,0xB8E31319,0x9592675C,
0xB3C0200C,0x99307EE0,0xAECC336C,0x9D0DFE54,0xAA0A5B2E,0xA1288376,0xA57D8666,
0xA57D8666,0xA1288376,0xAA0A5B2E,0x9D0DFE54,0xAECC336C,0x99307EE0,0xB3C0200C,
0x9592675C,0xB8E31319,0x9235F2EC,0xBE31E19B,0x8F1D343A,0xC3A94590,0x8C4A142F,
0xC945DFEC,0x89BE50C3,0xCF043AB3,0x877B7BEC,0xD4E0CB15,0x8582FAA5,0xDAD7F3A2,
0x83D60412,0xE0E60685,0x8275A0C0,0xE70747C4,0x8162AA04,0xED37EF91,0x809DC971,
0xF3742CA2,0x80277872,0xF9B82684,0x7FFFFFFF,0x00000000,0x7D8A5F40,0xE70747C4,
0x7641AF3D,0xCF043AB3,0x6A6D98A4,0xB8E31319,0x5A82799A,0xA57D8666,0x471CECE7,
0x9592675C,0x30FBC54D,0x89BE50C3,0x18F8B83C,0x8275A0C0,0x00000000,0x80000000,
0xE70747C4,0x8275A0C0,0xCF043AB3,0x89BE50C3,0xB8E31319,0x9592675C,0xA57D8666,
0xA57D8666,0x9592675C,0xB8E31319,0x89BE50C3,0xCF043AB3,0x8275A0C0,0xE70747C4,
0x7FFFFFFF,0x00000000,0x5A82799A,0xA57D8666,0x00000000,0x80000000,0xA57D8666,
0xA57D8666,};

q31_t rearranged_twiddle_stride3_1024_q31[680]={
0x7FFFFFFF,0x00000000,0x7FFA72D1,0xFDA4D929,0x7FE9CBC0,0xFB49E6A3,0x7FCE0C3E,
0xF8EF5CBB,0x7FA736B4,0xF6956FB7,0x7F754E80,0xF43C53CB,0x7F3857F6,0xF1E43D1C,
0x7EF05860,0xEF8D5FB8,0x7E9D55FC,0xED37EF91,0x7E3F57FF,0xEAE4207A,0x7DD6668F,
0xE8922622,0x7D628AC6,0xE642340D,0x7CE3CEB2,0xE3F47D96,0x7C5A3D50,0xE1A935E2,
0x7BC5E290,0xDF608FE4,0x7B26CB4F,0xDD1ABE51,0x7A7D055B,0xDAD7F3A2,0x79C89F6E,
0xD898620C,0x7909A92D,0xD65C3B7B,0x78403329,0xD423B191,0x776C4EDB,0xD1EEF59E,
0x768E0EA6,0xCFBE389F,0x75A585CF,0xCD91AB39,0x74B2C884,0xCB697DB0,0x73B5EBD1,
0xC945DFEC,0x72AF05A7,0xC727016D,0x719E2CD2,0xC50D1149,0x708378FF,0xC2F83E2A,
0x6F5F02B2,0xC0E8B648,0x6E30E34A,0xBEDEA765,0x6CF934FC,0xBCDA3ECB,0x6BB812D1,
0xBADBA943,0x6A6D98A4,0xB8E31319,0x6919E320,0xB6F0A812,0x67BD0FBD,0xB5049368,
0x66573CBB,0xB31EFFCC,0x64E88926,0xB140175B,0x637114CC,0xAF6803A2,0x61F1003F,
0xAD96ED92,0x60686CCF,0xABCCFD83,0x5ED77C8A,0xAA0A5B2E,0x5D3E5237,0xA84F2DAA,
0x5B9D1154,0xA69B9B68,0x59F3DE12,0xA4EFCA31,0x5842DD54,0xA34BDF20,0x568A34A9,
0xA1AFFEA3,0x54CA0A4B,0xA01C4C73,0x53028518,0x9E90EB94,0x5133CC94,0x9D0DFE54,
0x4F5E08E3,0x9B93A641,0x4D8162C4,0x9A22042D,0x4B9E0390,0x98B93828,0x49B41533,
0x9759617F,0x47C3C22F,0x96029EB6,0x45CD358F,0x94B50D87,0x43D09AED,0x9370CAE4,
0x41CE1E65,0x9235F2EC,0x3FC5EC98,0x9104A0EE,0x3DB832A6,0x8FDCEF66,0x3BA51E29,
0x8EBEF7FB,0x398CDD32,0x8DAAD37B,0x376F9E46,0x8CA099DA,0x354D9057,0x8BA0622F,
0x3326E2C3,0x8AAA42B4,0x30FBC54D,0x89BE50C3,0x2ECC681E,0x88DCA0D3,0x2C98FBBA,
0x88054677,0x2A61B101,0x8738545E,0x2826B928,0x8675DC4F,0x25E845B6,0x85BDEF28,
0x23A6887F,0x85109CDD,0x2161B3A0,0x846DF477,0x1F19F97B,0x83D60412,0x1CCF8CB3,
0x8348D8DC,0x1A82A026,0x82C67F14,0x183366E9,0x824F0208,0x15E21445,0x81E26C16,
0x138EDBB1,0x8180C6A9,0x1139F0CF,0x812A1A3A,0x0EE38766,0x80DE6E4C,0x0C8BD35E,
0x809DC971,0x0A3308BD,0x80683143,0x07D95B9E,0x803DAA6A,0x057F0035,0x801E3895,
0x03242ABF,0x8009DE7E,0x00C90F88,0x80009DEA,0xFE6DE2E0,0x800277A6,0xFC12D91A,
0x800F6B88,0xF9B82684,0x80277872,0xF75DFF66,0x804A9C4D,0xF50497FB,0x8078D40D,
0xF2AC246E,0x80B21BAF,0xF054D8D5,0x80F66E3C,0xEDFEE92B,0x8145C5C7,0xEBAA894F,
0x81A01B6D,0xE957ECFB,0x82056758,0xE70747C4,0x8275A0C0,0xE4B8CD11,0x82F0BDE8,
0xE26CB01B,0x8376B422,0xE02323E5,0x840777D0,0xDDDC5B3B,0x84A2FC62,0xDB9888A8,
0x8549345C,0xD957DE7A,0x85FA1153,0xD71A8EB5,0x86B583EE,0xD4E0CB15,0x877B7BEC,
0xD2AAC504,0x884BE821,0xD078AD9E,0x8926B677,0xCE4AB5A2,0x8A0BD3F5,0xCC210D79,
0x8AFB2CBB,0xC9FBE527,0x8BF4AC05,0xC7DB6C50,0x8CF83C30,0xC5BFD22E,0x8E05C6B7,
0xC3A94590,0x8F1D343A,0xC197F4D4,0x903E6C7B,0xBF8C0DE3,0x91695663,0xBD85BE30,
0x929DD806,0xBB8532B0,0x93DBD6A0,0xB98A97D8,0x9523369C,0xB796199B,0x9673DB94,
0xB5A7E362,0x97CDA855,0xB3C0200C,0x99307EE0,0xB1DEF9E9,0x9A9C406E,0xB0049AB3,
0x9C10CD70,0xAE312B92,0x9D8E0597,0xAC64D510,0x9F13C7D0,0xAA9FBF1E,0xA0A1F24D,
0xA8E21106,0xA2386284,0xA72BF174,0xA3D6F534,0xA57D8666,0xA57D8666,0xA3D6F534,
0xA72BF174,0xA2386284,0xA8E21106,0xA0A1F24D,0xAA9FBF1E,0x9F13C7D0,0xAC64D510,
0x9D8E0597,0xAE312B92,0x9C10CD70,0xB0049AB3,0x9A9C406E,0xB1DEF9E9,0x99307EE0,
0xB3C0200C,0x97CDA855,0xB5A7E362,0x9673DB94,0xB796199B,0x9523369C,0xB98A97D8,
0x93DBD6A0,0xBB8532B0,0x929DD806,0xBD85BE30,0x91695663,0xBF8C0DE3,0x903E6C7B,
0xC197F4D4,0x8F1D343A,0xC3A94590,0x8E05C6B7,0xC5BFD22E,0x8CF83C30,0xC7DB6C50,
0x8BF4AC05,0xC9FBE527,0x8AFB2CBB,0xCC210D79,0x8A0BD3F5,0xCE4AB5A2,0x8926B677,
0xD078AD9E,0x884BE821,0xD2AAC504,0x877B7BEC,0xD4E0CB15,0x86B583EE,0xD71A8EB5,
0x85FA1153,0xD957DE7A,0x8549345C,0xDB9888A8,0x84A2FC62,0xDDDC5B3B,0x840777D0,
0xE02323E5,0x8376B422,0xE26CB01B,0x82F0BDE8,0xE4B8CD11,0x8275A0C0,0xE70747C4,
0x82056758,0xE957ECFB,0x81A01B6D,0xEBAA894F,0x8145C5C7,0xEDFEE92B,0x80F66E3C,
0xF054D8D5,0x80B21BAF,0xF2AC246E,0x8078D40D,0xF50497FB,0x804A9C4D,0xF75DFF66,
0x80277872,0xF9B82684,0x800F6B88,0xFC12D91A,0x800277A6,0xFE6DE2E0,0x80009DEA,
0x00C90F88,0x8009DE7E,0x03242ABF,0x801E3895,0x057F0035,0x803DAA6A,0x07D95B9E,
0x80683143,0x0A3308BD,0x809DC971,0x0C8BD35E,0x80DE6E4C,0x0EE38766,0x812A1A3A,
0x1139F0CF,0x8180C6A9,0x138EDBB1,0x81E26C16,0x15E21445,0x824F0208,0x183366E9,
0x82C67F14,0x1A82A026,0x8348D8DC,0x1CCF8CB3,0x83D60412,0x1F19F97B,0x846DF477,
0x2161B3A0,0x85109CDD,0x23A6887F,0x85BDEF28,0x25E845B6,0x8675DC4F,0x2826B928,
0x8738545E,0x2A61B101,0x88054677,0x2C98FBBA,0x88DCA0D3,0x2ECC681E,0x89BE50C3,
0x30FBC54D,0x8AAA42B4,0x3326E2C3,0x8BA0622F,0x354D9057,0x8CA099DA,0x376F9E46,
0x8DAAD37B,0x398CDD32,0x8EBEF7FB,0x3BA51E29,0x8FDCEF66,0x3DB832A6,0x9104A0EE,
0x3FC5EC98,0x9235F2EC,0x41CE1E65,0x9370CAE4,0x43D09AED,0x94B50D87,0x45CD358F,
0x96029EB6,0x47C3C22F,0x9759617F,0x49B41533,0x98B93828,0x4B9E0390,0x9A22042D,
0x4D8162C4,0x9B93A641,0x4F5E08E3,0x9D0DFE54,0x5133CC94,0x9E90EB94,0x53028518,
0xA01C4C73,0x54CA0A4B,0xA1AFFEA3,0x568A34A9,0xA34BDF20,0x5842DD54,0xA4EFCA31,
0x59F3DE12,0xA69B9B68,0x5B9D1154,0xA84F2DAA,0x5D3E5237,0xAA0A5B2E,0x5ED77C8A,
0xABCCFD83,0x60686CCF,0xAD96ED92,0x61F1003F,0xAF6803A2,0x637114CC,0xB140175B,
0x64E88926,0xB31EFFCC,0x66573CBB,0xB5049368,0x67BD0FBD,0xB6F0A812,0x6919E320,
0xB8E31319,0x6A6D98A4,0xBADBA943,0x6BB812D1,0xBCDA3ECB,0x6CF934FC,0xBEDEA765,
0x6E30E34A,0xC0E8B648,0x6F5F02B2,0xC2F83E2A,0x708378FF,0xC50D1149,0x719E2CD2,
0xC727016D,0x72AF05A7,0xC945DFEC,0x73B5EBD1,0xCB697DB0,0x74B2C884,0xCD91AB39,
0x75A585CF,0xCFBE389F,0x768E0EA6,0xD1EEF59E,0x776C4EDB,0xD423B191,0x78403329,
0xD65C3B7B,0x7909A92D,0xD898620C,0x79C89F6E,0xDAD7F3A2,0x7A7D055B,0xDD1ABE51,
0x7B26CB4F,0xDF608FE4,0x7BC5E290,0xE1A935E2,0x7C5A3D50,0xE3F47D96,0x7CE3CEB2,
0xE642340D,0x7D628AC6,0xE8922622,0x7DD6668F,0xEAE4207A,0x7E3F57FF,0xED37EF91,
0x7E9D55FC,0xEF8D5FB8,0x7EF05860,0xF1E43D1C,0x7F3857F6,0xF43C53CB,0x7F754E80,
0xF6956FB7,0x7FA736B4,0xF8EF5CBB,0x7FCE0C3E,0xFB49E6A3,0x7FE9CBC0,0xFDA4D929,
0x7FFA72D1,0x7FFFFFFF,0x00000000,0x7FA736B4,0xF6956FB7,0x7E9D55FC,0xED37EF91,
0x7CE3CEB2,0xE3F47D96,0x7A7D055B,0xDAD7F3A2,0x776C4EDB,0xD1EEF59E,0x73B5EBD1,
0xC945DFEC,0x6F5F02B2,0xC0E8B648,0x6A6D98A4,0xB8E31319,0x64E88926,0xB140175B,
0x5ED77C8A,0xAA0A5B2E,0x5842DD54,0xA34BDF20,0x5133CC94,0x9D0DFE54,0x49B41533,
0x9759617F,0x41CE1E65,0x9235F2EC,0x398CDD32,0x8DAAD37B,0x30FBC54D,0x89BE50C3,
0x2826B928,0x8675DC4F,0x1F19F97B,0x83D60412,0x15E21445,0x81E26C16,0x0C8BD35E,
0x809DC971,0x03242ABF,0x8009DE7E,0xF9B82684,0x80277872,0xF054D8D5,0x80F66E3C,
0xE70747C4,0x8275A0C0,0xDDDC5B3B,0x84A2FC62,0xD4E0CB15,0x877B7BEC,0xCC210D79,
0x8AFB2CBB,0xC3A94590,0x8F1D343A,0xBB8532B0,0x93DBD6A0,0xB3C0200C,0x99307EE0,
0xAC64D510,0x9F13C7D0,0xA57D8666,0xA57D8666,0x9F13C7D0,0xAC64D510,0x99307EE0,
0xB3C0200C,0x93DBD6A0,0xBB8532B0,0x8F1D343A,0xC3A94590,0x8AFB2CBB,0xCC210D79,
0x877B7BEC,0xD4E0CB15,0x84A2FC62,0xDDDC5B3B,0x8275A0C0,0xE70747C4,0x80F66E3C,
0xF054D8D5,0x80277872,0xF9B82684,0x8009DE7E,0x03242ABF,0x809DC971,0x0C8BD35E,
0x81E26C16,0x15E21445,0x83D60412,0x1F19F97B,0x8675DC4F,0x2826B928,0x89BE50C3,
0x30FBC54D,0x8DAAD37B,0x398CDD32,0x9235F2EC,0x41CE1E65,0x9759617F,0x49B41533,
0x9D0DFE54,0x5133CC94,0xA34BDF20,0x5842DD54,0xAA0A5B2E,0x5ED77C8A,0xB140175B,
0x64E88926,0xB8E31319,0x6A6D98A4,0xC0E8B648,0x6F5F02B2,0xC945DFEC,0x73B5EBD1,
0xD1EEF59E,0x776C4EDB,0xDAD7F3A2,0x7A7D055B,0xE3F47D96,0x7CE3CEB2,0xED37EF91,
0x7E9D55FC,0xF6956FB7,0x7FA736B4,0x7FFFFFFF,0x00000000,0x7A7D055B,0xDAD7F3A2,
0x6A6D98A4,0xB8E31319,0x5133CC94,0x9D0DFE54,0x30FBC54D,0x89BE50C3,0x0C8BD35E,
0x809DC971,0xE70747C4,0x8275A0C0,0xC3A94590,0x8F1D343A,0xA57D8666,0xA57D8666,
0x8F1D343A,0xC3A94590,0x8275A0C0,0xE70747C4,0x809DC971,0x0C8BD35E,0x89BE50C3,
0x30FBC54D,0x9D0DFE54,0x5133CC94,0xB8E31319,0x6A6D98A4,0xDAD7F3A2,0x7A7D055B,
0x7FFFFFFF,0x00000000,0x30FBC54D,0x89BE50C3,0xA57D8666,0xA57D8666,0x89BE50C3,
0x30FBC54D,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_Q31_4096) || defined(ARM_TABLE_TWIDDLECOEF_Q31_8192)

uint32_t rearranged_twiddle_tab_stride1_arr_4096_q31[6]={
0,2048,2560,2688,2720,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_4096_q31[6]={
0,2048,2560,2688,2720,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_4096_q31[6]={
0,2048,2560,2688,2720,0,};

q31_t rearranged_twiddle_stride1_4096_q31[2728]={
0x7FFFFFFF,0x00000000,0x7FFFF621,0xFFCDBC0B,0x7FFFD886,0xFF9B781D,0x7FFFA72C,
0xFF69343F,0x7FFF6216,0xFF36F078,0x7FFF0943,0xFF04ACD0,0x7FFE9CB2,0xFED2694F,
0x7FFE1C65,0xFEA025FD,0x7FFD885A,0xFE6DE2E0,0x7FFCE093,0xFE3BA002,0x7FFC250F,
0xFE095D69,0x7FFB55CE,0xFDD71B1E,0x7FFA72D1,0xFDA4D929,0x7FF97C18,0xFD729790,
0x7FF871A2,0xFD40565C,0x7FF75370,0xFD0E1594,0x7FF62182,0xFCDBD541,0x7FF4DBD9,
0xFCA9956A,0x7FF38274,0xFC775616,0x7FF21553,0xFC45174E,0x7FF09478,0xFC12D91A,
0x7FEEFFE1,0xFBE09B80,0x7FED5791,0xFBAE5E89,0x7FEB9B85,0xFB7C223D,0x7FE9CBC0,
0xFB49E6A3,0x7FE7E841,0xFB17ABC2,0x7FE5F108,0xFAE571A4,0x7FE3E616,0xFAB3384F,
0x7FE1C76B,0xFA80FFCB,0x7FDF9508,0xFA4EC821,0x7FDD4EEC,0xFA1C9157,0x7FDAF519,
0xF9EA5B75,0x7FD8878E,0xF9B82684,0x7FD6064C,0xF985F28A,0x7FD37153,0xF953BF91,
0x7FD0C8A3,0xF9218D9E,0x7FCE0C3E,0xF8EF5CBB,0x7FCB3C23,0xF8BD2CEF,0x7FC85854,
0xF88AFE42,0x7FC560CF,0xF858D0BB,0x7FC25596,0xF826A462,0x7FBF36AA,0xF7F4793E,
0x7FBC040A,0xF7C24F59,0x7FB8BDB8,0xF79026B9,0x7FB563B3,0xF75DFF66,0x7FB1F5FC,
0xF72BD967,0x7FAE7495,0xF6F9B4C6,0x7FAADF7C,0xF6C79188,0x7FA736B4,0xF6956FB7,
0x7FA37A3C,0xF6634F59,0x7F9FAA15,0xF6313077,0x7F9BC640,0xF5FF1318,0x7F97CEBD,
0xF5CCF743,0x7F93C38C,0xF59ADD02,0x7F8FA4B0,0xF568C45B,0x7F8B7227,0xF536AD56,
0x7F872BF3,0xF50497FB,0x7F82D214,0xF4D28451,0x7F7E648C,0xF4A07261,0x7F79E35A,
0xF46E6231,0x7F754E80,0xF43C53CB,0x7F70A5FE,0xF40A4735,0x7F6BE9D4,0xF3D83C77,
0x7F671A05,0xF3A63398,0x7F62368F,0xF3742CA2,0x7F5D3F75,0xF342279B,0x7F5834B7,
0xF310248A,0x7F531655,0xF2DE2379,0x7F4DE451,0xF2AC246E,0x7F489EAA,0xF27A2771,
0x7F434563,0xF2482C8A,0x7F3DD87C,0xF21633C0,0x7F3857F6,0xF1E43D1C,0x7F32C3D1,
0xF1B248A5,0x7F2D1C0E,0xF1805662,0x7F2760AF,0xF14E665C,0x7F2191B4,0xF11C789A,
0x7F1BAF1E,0xF0EA8D24,0x7F15B8EE,0xF0B8A401,0x7F0FAF25,0xF086BD39,0x7F0991C4,
0xF054D8D5,0x7F0360CB,0xF022F6DA,0x7EFD1C3C,0xEFF11753,0x7EF6C418,0xEFBF3A45,
0x7EF05860,0xEF8D5FB8,0x7EE9D914,0xEF5B87B5,0x7EE34636,0xEF29B243,0x7EDC9FC6,
0xEEF7DF6A,0x7ED5E5C6,0xEEC60F31,0x7ECF1837,0xEE9441A0,0x7EC8371A,0xEE6276BF,
0x7EC14270,0xEE30AE96,0x7EBA3A39,0xEDFEE92B,0x7EB31E78,0xEDCD2687,0x7EABEF2C,
0xED9B66B2,0x7EA4AC58,0xED69A9B3,0x7E9D55FC,0xED37EF91,0x7E95EC1A,0xED063856,
0x7E8E6EB2,0xECD48407,0x7E86DDC6,0xECA2D2AD,0x7E7F3957,0xEC71244F,0x7E778166,
0xEC3F78F6,0x7E6FB5F4,0xEC0DD0A8,0x7E67D703,0xEBDC2B6E,0x7E5FE493,0xEBAA894F,
0x7E57DEA7,0xEB78EA52,0x7E4FC53E,0xEB474E81,0x7E47985B,0xEB15B5E1,0x7E3F57FF,
0xEAE4207A,0x7E37042A,0xEAB28E56,0x7E2E9CDF,0xEA80FF7A,0x7E26221F,0xEA4F73EE,
0x7E1D93EA,0xEA1DEBBB,0x7E14F242,0xE9EC66E8,0x7E0C3D29,0xE9BAE57D,0x7E0374A0,
0xE9896781,0x7DFA98A8,0xE957ECFB,0x7DF1A942,0xE92675F4,0x7DE8A670,0xE8F50273,
0x7DDF9034,0xE8C39280,0x7DD6668F,0xE8922622,0x7DCD2981,0xE860BD61,0x7DC3D90D,
0xE82F5844,0x7DBA7534,0xE7FDF6D4,0x7DB0FDF8,0xE7CC9917,0x7DA77359,0xE79B3F16,
0x7D9DD55A,0xE769E8D8,0x7D9423FC,0xE7389665,0x7D8A5F40,0xE70747C4,0x7D808728,
0xE6D5FCFC,0x7D769BB5,0xE6A4B616,0x7D6C9CE9,0xE6737319,0x7D628AC6,0xE642340D,
0x7D58654D,0xE610F8F9,0x7D4E2C7F,0xE5DFC1E5,0x7D43E05E,0xE5AE8ED8,0x7D3980EC,
0xE57D5FDA,0x7D2F0E2B,0xE54C34F3,0x7D24881B,0xE51B0E2A,0x7D19EEBF,0xE4E9EB87,
0x7D0F4218,0xE4B8CD11,0x7D048228,0xE487B2D0,0x7CF9AEF0,0xE4569CCB,0x7CEEC873,
0xE4258B0A,0x7CE3CEB2,0xE3F47D96,0x7CD8C1AE,0xE3C37474,0x7CCDA169,0xE3926FAD,
0x7CC26DE5,0xE3616F48,0x7CB72724,0xE330734D,0x7CABCD28,0xE2FF7BC3,0x7CA05FF1,
0xE2CE88B3,0x7C94DF83,0xE29D9A23,0x7C894BDE,0xE26CB01B,0x7C7DA505,0xE23BCAA2,
0x7C71EAF9,0xE20AE9C1,0x7C661DBC,0xE1DA0D7E,0x7C5A3D50,0xE1A935E2,0x7C4E49B7,
0xE17862F3,0x7C4242F2,0xE14794BA,0x7C362904,0xE116CB3D,0x7C29FBEE,0xE0E60685,
0x7C1DBBB3,0xE0B54698,0x7C116853,0xE0848B7F,0x7C0501D2,0xE053D541,0x7BF88830,
0xE02323E5,0x7BEBFB70,0xDFF27773,0x7BDF5B94,0xDFC1CFF3,0x7BD2A89E,0xDF912D6B,
0x7BC5E290,0xDF608FE4,0x7BB9096B,0xDF2FF764,0x7BAC1D31,0xDEFF63F4,0x7B9F1DE6,
0xDECED59B,0x7B920B89,0xDE9E4C60,0x7B84E61F,0xDE6DC84B,0x7B77ADA8,0xDE3D4964,
0x7B6A6227,0xDE0CCFB1,0x7B5D039E,0xDDDC5B3B,0x7B4F920E,0xDDABEC08,0x7B420D7A,
0xDD7B8220,0x7B3475E5,0xDD4B1D8C,0x7B26CB4F,0xDD1ABE51,0x7B190DBC,0xDCEA6478,
0x7B0B3D2C,0xDCBA1008,0x7AFD59A4,0xDC89C109,0x7AEF6323,0xDC597781,0x7AE159AE,
0xDC293379,0x7AD33D45,0xDBF8F4F8,0x7AC50DEC,0xDBC8BC06,0x7AB6CBA4,0xDB9888A8,
0x7AA8766F,0xDB685AE9,0x7A9A0E50,0xDB3832CD,0x7A8B9348,0xDB08105E,0x7A7D055B,
0xDAD7F3A2,0x7A6E648A,0xDAA7DCA1,0x7A5FB0D8,0xDA77CB63,0x7A50EA47,0xDA47BFEE,
0x7A4210D8,0xDA17BA4A,0x7A332490,0xD9E7BA7F,0x7A24256F,0xD9B7C094,0x7A151378,
0xD987CC90,0x7A05EEAD,0xD957DE7A,0x79F6B711,0xD927F65B,0x79E76CA7,0xD8F81439,
0x79D80F6F,0xD8C8381D,0x79C89F6E,0xD898620C,0x79B91CA4,0xD868920F,0x79A98715,
0xD838C82D,0x7999DEC4,0xD809046E,0x798A23B1,0xD7D946D8,0x797A55E0,0xD7A98F73,
0x796A7554,0xD779DE47,0x795A820E,0xD74A335B,0x794A7C12,0xD71A8EB5,0x793A6361,
0xD6EAF05F,0x792A37FE,0xD6BB585E,0x7919F9EC,0xD68BC6BA,0x7909A92D,0xD65C3B7B,
0x78F945C3,0xD62CB6A8,0x78E8CFB2,0xD5FD3848,0x78D846FB,0xD5CDC062,0x78C7ABA2,
0xD59E4EFF,0x78B6FDA8,0xD56EE424,0x78A63D11,0xD53F7FDA,0x789569DF,0xD5102228,
0x78848414,0xD4E0CB15,0x78738BB3,0xD4B17AA8,0x786280BF,0xD48230E9,0x7851633B,
0xD452EDDF,0x78403329,0xD423B191,0x782EF08B,0xD3F47C06,0x781D9B65,0xD3C54D47,
0x780C33B8,0xD396255A,0x77FAB989,0xD3670446,0x77E92CD9,0xD337EA12,0x77D78DAA,
0xD308D6C7,0x77C5DC01,0xD2D9CA6A,0x77B417DF,0xD2AAC504,0x77A24148,0xD27BC69C,
0x7790583E,0xD24CCF39,0x777E5CC3,0xD21DDEE2,0x776C4EDB,0xD1EEF59E,0x775A2E89,
0xD1C01375,0x7747FBCE,0xD191386E,0x7735B6AF,0xD1626490,0x77235F2D,0xD13397E2,
0x7710F54C,0xD104D26B,0x76FE790E,0xD0D61434,0x76EBEA77,0xD0A75D42,0x76D94989,
0xD078AD9E,0x76C69647,0xD04A054E,0x76B3D0B4,0xD01B6459,0x76A0F8D2,0xCFECCAC7,
0x768E0EA6,0xCFBE389F,0x767B1231,0xCF8FADE9,0x76680376,0xCF612AAA,0x7654E279,
0xCF32AEEB,0x7641AF3D,0xCF043AB3,0x762E69C4,0xCED5CE08,0x761B1211,0xCEA768F2,
0x7607A828,0xCE790B79,0x75F42C0B,0xCE4AB5A2,0x75E09DBD,0xCE1C6777,0x75CCFD42,
0xCDEE20FC,0x75B94A9C,0xCDBFE23A,0x75A585CF,0xCD91AB39,0x7591AEDD,0xCD637BFE,
0x757DC5CA,0xCD355491,0x7569CA99,0xCD0734F9,0x7555BD4C,0xCCD91D3D,0x75419DE7,
0xCCAB0D65,0x752D6C6C,0xCC7D0578,0x751928E0,0xCC4F057C,0x7504D345,0xCC210D79,
0x74F06B9E,0xCBF31D75,0x74DBF1EF,0xCBC53579,0x74C7663A,0xCB97558A,0x74B2C884,
0xCB697DB0,0x749E18CD,0xCB3BADF3,0x7489571C,0xCB0DE658,0x74748371,0xCAE026E8,
0x745F9DD1,0xCAB26FA9,0x744AA63F,0xCA84C0A3,0x74359CBD,0xCA5719DB,0x74208150,
0xCA297B5A,0x740B53FB,0xC9FBE527,0x73F614C0,0xC9CE5748,0x73E0C3A3,0xC9A0D1C5,
0x73CB60A8,0xC97354A4,0x73B5EBD1,0xC945DFEC,0x73A06522,0xC91873A5,0x738ACC9E,
0xC8EB0FD6,0x73752249,0xC8BDB485,0x735F6626,0xC89061BA,0x73499838,0xC863177B,
0x7333B883,0xC835D5D0,0x731DC70A,0xC8089CBF,0x7307C3D0,0xC7DB6C50,0x72F1AED9,
0xC7AE4489,0x72DB8828,0xC7812572,0x72C54FC1,0xC7540F11,0x72AF05A7,0xC727016D,
0x7298A9DD,0xC6F9FC8D,0x72823C67,0xC6CD0079,0x726BBD48,0xC6A00D37,0x72552C85,
0xC67322CE,0x723E8A20,0xC6464144,0x7227D61C,0xC61968A2,0x7211107E,0xC5EC98EE,
0x71FA3949,0xC5BFD22E,0x71E35080,0xC593146A,0x71CC5626,0xC5665FA9,0x71B54A41,
0xC539B3F1,0x719E2CD2,0xC50D1149,0x7186FDDE,0xC4E077B8,0x716FBD68,0xC4B3E746,
0x71586B74,0xC4875FF9,0x71410805,0xC45AE1D7,0x7129931F,0xC42E6CE8,0x71120CC5,
0xC4020133,0x70FA74FC,0xC3D59EBE,0x70E2CBC6,0xC3A94590,0x70CB1128,0xC37CF5B0,
0x70B34525,0xC350AF26,0x709B67C0,0xC32471F7,0x708378FF,0xC2F83E2A,0x706B78E3,
0xC2CC13C7,0x70536771,0xC29FF2D4,0x703B44AD,0xC273DB58,0x7023109A,0xC247CD5A,
0x700ACB3C,0xC21BC8E1,0x6FF27497,0xC1EFCDF3,0x6FDA0CAE,0xC1C3DC97,0x6FC19385,
0xC197F4D4,0x6FA90921,0xC16C16B0,0x6F906D84,0xC1404233,0x6F77C0B3,0xC1147764,
0x6F5F02B2,0xC0E8B648,0x6F463383,0xC0BCFEE7,0x6F2D532C,0xC0915148,0x6F1461B0,
0xC065AD70,0x6EFB5F12,0xC03A1368,0x6EE24B57,0xC00E8336,0x6EC92683,0xBFE2FCDF,
0x6EAFF099,0xBFB7806C,0x6E96A99D,0xBF8C0DE3,0x6E7D5193,0xBF60A54A,0x6E63E87F,
0xBF3546A8,0x6E4A6E66,0xBF09F205,0x6E30E34A,0xBEDEA765,0x6E174730,0xBEB366D1,
0x6DFD9A1C,0xBE88304F,0x6DE3DC11,0xBE5D03E6,0x6DCA0D14,0xBE31E19B,0x6DB02D29,
0xBE06C977,0x6D963C54,0xBDDBBB7F,0x6D7C3A98,0xBDB0B7BB,0x6D6227FA,0xBD85BE30,
0x6D48047E,0xBD5ACEE5,0x6D2DD027,0xBD2FE9E2,0x6D138AFB,0xBD050F2C,0x6CF934FC,
0xBCDA3ECB,0x6CDECE2F,0xBCAF78C4,0x6CC45698,0xBC84BD1F,0x6CA9CE3B,0xBC5A0BE2,
0x6C8F351C,0xBC2F6513,0x6C748B3F,0xBC04C8BA,0x6C59D0A9,0xBBDA36DD,0x6C3F055D,
0xBBAFAF82,0x6C242960,0xBB8532B0,0x6C093CB6,0xBB5AC06D,0x6BEE3F62,0xBB3058C0,
0x6BD3316A,0xBB05FBB0,0x6BB812D1,0xBADBA943,0x6B9CE39B,0xBAB16180,0x6B81A3CD,
0xBA87246D,0x6B66536B,0xBA5CF210,0x6B4AF279,0xBA32CA71,0x6B2F80FB,0xBA08AD95,
0x6B13FEF5,0xB9DE9B83,0x6AF86C6C,0xB9B49442,0x6ADCC964,0xB98A97D8,0x6AC115E2,
0xB960A64C,0x6AA551E9,0xB936BFA4,0x6A897D7D,0xB90CE3E6,0x6A6D98A4,0xB8E31319,
0x6A51A361,0xB8B94D44,0x6A359DB9,0xB88F926D,0x6A1987B0,0xB865E299,0x69FD614A,
0xB83C3DD1,0x69E12A8C,0xB812A41A,0x69C4E37A,0xB7E9157A,0x69A88C19,0xB7BF91F8,
0x698C246C,0xB796199B,0x696FAC78,0xB76CAC69,0x69532442,0xB7434A67,0x69368BCE,
0xB719F39E,0x6919E320,0xB6F0A812,0x68FD2A3D,0xB6C767CA,0x68E06129,0xB69E32CD,
0x68C387E9,0xB6750921,0x68A69E81,0xB64BEACD,0x6889A4F6,0xB622D7D6,0x686C9B4B,
0xB5F9D043,0x684F8186,0xB5D0D41A,0x683257AB,0xB5A7E362,0x68151DBE,0xB57EFE22,
0x67F7D3C5,0xB556245E,0x67DA79C3,0xB52D561E,0x67BD0FBD,0xB5049368,0x679F95B7,
0xB4DBDC42,0x67820BB7,0xB4B330B3,0x676471C0,0xB48A90C0,0x6746C7D8,0xB461FC70,
0x67290E02,0xB43973CA,0x670B4444,0xB410F6D3,0x66ED6AA1,0xB3E88592,0x66CF8120,
0xB3C0200C,0x66B187C3,0xB397C649,0x66937E91,0xB36F784F,0x6675658C,0xB3473623,
0x66573CBB,0xB31EFFCC,0x66390422,0xB2F6D550,0x661ABBC5,0xB2CEB6B5,0x65FC63A9,
0xB2A6A402,0x65DDFBD3,0xB27E9D3C,0x65BF8447,0xB256A26A,0x65A0FD0B,0xB22EB392,
0x65826622,0xB206D0BA,0x6563BF92,0xB1DEF9E9,0x6545095F,0xB1B72F23,0x6526438F,
0xB18F7071,0x65076E25,0xB167BDD7,0x64E88926,0xB140175B,0x64C99498,0xB1187D05,
0x64AA907F,0xB0F0EEDA,0x648B7CE0,0xB0C96CE0,0x646C59BF,0xB0A1F71D,0x644D2722,
0xB07A8D97,0x642DE50D,0xB0533055,0x640E9386,0xB02BDF5C,0x63EF3290,0xB0049AB3,
0x63CFC231,0xAFDD625F,0x63B0426D,0xAFB63667,0x6390B34A,0xAF8F16D1,0x637114CC,
0xAF6803A2,0x635166F9,0xAF40FCE1,0x6331A9D4,0xAF1A0293,0x6311DD64,0xAEF314C0,
0x62F201AC,0xAECC336C,0x62D216B3,0xAEA55E9E,0x62B21C7B,0xAE7E965B,0x6292130C,
0xAE57DAAB,0x6271FA69,0xAE312B92,0x6251D298,0xAE0A8916,0x62319B9D,0xADE3F33E,
0x6211557E,0xADBD6A10,0x61F1003F,0xAD96ED92,0x61D09BE5,0xAD707DC8,0x61B02876,
0xAD4A1ABA,0x618FA5F7,0xAD23C46E,0x616F146C,0xACFD7AE8,0x614E73DA,0xACD73E30,
0x612DC447,0xACB10E4B,0x610D05B7,0xAC8AEB3E,0x60EC3830,0xAC64D510,0x60CB5BB7,
0xAC3ECBC7,0x60AA7050,0xAC18CF69,0x60897601,0xABF2DFFB,0x60686CCF,0xABCCFD83,
0x604754BF,0xABA72807,0x60262DD6,0xAB815F8D,0x6004F819,0xAB5BA41A,0x5FE3B38D,
0xAB35F5B5,0x5FC26038,0xAB105464,0x5FA0FE1F,0xAAEAC02C,0x5F7F8D46,0xAAC53912,
0x5F5E0DB3,0xAA9FBF1E,0x5F3C7F6B,0xAA7A5253,0x5F1AE274,0xAA54F2BA,0x5EF936D1,
0xAA2FA056,0x5ED77C8A,0xAA0A5B2E,0x5EB5B3A2,0xA9E52347,0x5E93DC1F,0xA9BFF8A8,
0x5E71F606,0xA99ADB56,0x5E50015D,0xA975CB57,0x5E2DFE29,0xA950C8B0,0x5E0BEC6E,
0xA92BD367,0x5DE9CC33,0xA906EB82,0x5DC79D7C,0xA8E21106,0x5DA5604F,0xA8BD43FA,
0x5D8314B1,0xA8988463,0x5D60BAA7,0xA873D246,0x5D3E5237,0xA84F2DAA,0x5D1BDB65,
0xA82A9693,0x5CF95638,0xA8060D08,0x5CD6C2B5,0xA7E1910F,0x5CB420E0,0xA7BD22AC,
0x5C9170BF,0xA798C1E5,0x5C6EB258,0xA7746EC0,0x5C4BE5B0,0xA7502943,0x5C290ACC,
0xA72BF174,0x5C0621B2,0xA707C757,0x5BE32A67,0xA6E3AAF2,0x5BC024F0,0xA6BF9C4B,
0x5B9D1154,0xA69B9B68,0x5B79EF96,0xA677A84E,0x5B56BFBD,0xA653C303,0x5B3381CE,
0xA62FEB8B,0x5B1035CF,0xA60C21EE,0x5AECDBC5,0xA5E8662F,0x5AC973B5,0xA5C4B855,
0x5AA5FDA5,0xA5A11866,0x5A82799A,0xA57D8666,0x5A5EE79A,0xA55A025B,0x5A3B47AB,
0xA5368C4B,0x5A1799D1,0xA513243B,0x59F3DE12,0xA4EFCA31,0x59D01475,0xA4CC7E32,
0x59AC3CFD,0xA4A94043,0x598857B2,0xA486106A,0x59646498,0xA462EEAC,0x594063B5,
0xA43FDB10,0x591C550E,0xA41CD599,0x58F838A9,0xA3F9DE4E,0x58D40E8C,0xA3D6F534,
0x58AFD6BD,0xA3B41A50,0x588B9140,0xA3914DA8,0x58673E1B,0xA36E8F41,0x5842DD54,
0xA34BDF20,0x581E6EF1,0xA3293D4B,0x57F9F2F8,0xA306A9C8,0x57D5696D,0xA2E4249B,
0x57B0D256,0xA2C1ADC9,0x578C2DBA,0xA29F4559,0x57677B9D,0xA27CEB4F,0x5742BC06,
0xA25A9FB1,0x571DEEFA,0xA2386284,0x56F9147E,0xA21633CD,0x56D42C99,0xA1F41392,
0x56AF3750,0xA1D201D7,0x568A34A9,0xA1AFFEA3,0x566524AA,0xA18E09FA,0x56400758,
0xA16C23E1,0x561ADCB9,0xA14A4C5E,0x55F5A4D2,0xA1288376,0x55D05FAA,0xA106C92F,
0x55AB0D46,0xA0E51D8C,0x5585ADAD,0xA0C38095,0x556040E2,0xA0A1F24D,0x553AC6EE,
0xA08072BA,0x55153FD4,0xA05F01E1,0x54EFAB9C,0xA03D9FC8,0x54CA0A4B,0xA01C4C73,
0x54A45BE6,0x9FFB07E7,0x547EA073,0x9FD9D22A,0x5458D7F9,0x9FB8AB41,0x5433027D,
0x9F979331,0x540D2005,0x9F7689FF,0x53E73097,0x9F558FB0,0x53C13439,0x9F34A449,
0x539B2AF0,0x9F13C7D0,0x537514C2,0x9EF2FA49,0x534EF1B5,0x9ED23BB9,0x5328C1D0,
0x9EB18C26,0x53028518,0x9E90EB94,0x52DC3B92,0x9E705A09,0x52B5E546,0x9E4FD78A,
0x528F8238,0x9E2F641B,0x5269126E,0x9E0EFFC1,0x524295F0,0x9DEEAA82,0x521C0CC2,
0x9DCE6463,0x51F576EA,0x9DAE2D68,0x51CED46E,0x9D8E0597,0x51A82555,0x9D6DECF4,
0x518169A5,0x9D4DE385,0x515AA162,0x9D2DE94D,0x5133CC94,0x9D0DFE54,0x510CEB40,
0x9CEE229C,0x50E5FD6D,0x9CCE562C,0x50BF031F,0x9CAE9907,0x5097FC5E,0x9C8EEB34,
0x5070E92F,0x9C6F4CB6,0x5049C999,0x9C4FBD93,0x50229DA1,0x9C303DCF,0x4FFB654D,
0x9C10CD70,0x4FD420A4,0x9BF16C7A,0x4FACCFAB,0x9BD21AF3,0x4F857269,0x9BB2D8DE,
0x4F5E08E3,0x9B93A641,0x4F369320,0x9B748320,0x4F0F1126,0x9B556F81,0x4EE782FB,
0x9B366B68,0x4EBFE8A5,0x9B1776DA,0x4E984229,0x9AF891DB,0x4E708F8F,0x9AD9BC71,
0x4E48D0DD,0x9ABAF6A1,0x4E210617,0x9A9C406E,0x4DF92F46,0x9A7D99DE,0x4DD14C6E,
0x9A5F02F5,0x4DA95D96,0x9A407BB9,0x4D8162C4,0x9A22042D,0x4D595BFE,0x9A039C57,
0x4D31494B,0x99E5443B,0x4D092AB0,0x99C6FBDE,0x4CE10034,0x99A8C345,0x4CB8C9DD,
0x998A9A74,0x4C9087B1,0x996C816F,0x4C6839B7,0x994E783D,0x4C3FDFF4,0x99307EE0,
0x4C177A6E,0x9912955F,0x4BEF092D,0x98F4BBBC,0x4BC68C36,0x98D6F1FE,0x4B9E0390,
0x98B93828,0x4B756F40,0x989B8E40,0x4B4CCF4D,0x987DF449,0x4B2423BE,0x98606A49,
0x4AFB6C98,0x9842F043,0x4AD2A9E2,0x9825863D,0x4AA9DBA2,0x98082C3B,0x4A8101DE,
0x97EAE242,0x4A581C9E,0x97CDA855,0x4A2F2BE6,0x97B07E7A,0x4A062FBD,0x979364B5,
0x49DD282A,0x97765B0A,0x49B41533,0x9759617F,0x498AF6DF,0x973C7817,0x4961CD33,
0x971F9ED7,0x49389836,0x9702D5C3,0x490F57EE,0x96E61CE0,0x48E60C62,0x96C97432,
0x48BCB599,0x96ACDBBE,0x48935397,0x96905388,0x4869E665,0x9673DB94,0x48406E08,
0x965773E7,0x4816EA86,0x963B1C86,0x47ED5BE6,0x961ED574,0x47C3C22F,0x96029EB6,
0x479A1D67,0x95E67850,0x47706D93,0x95CA6247,0x4746B2BC,0x95AE5C9F,0x471CECE7,
0x9592675C,0x46F31C1A,0x95768283,0x46C9405C,0x955AAE17,0x469F59B4,0x953EEA1E,
0x46756828,0x9523369C,0x464B6BBE,0x95079394,0x4621647D,0x94EC010B,0x45F7526B,
0x94D07F05,0x45CD358F,0x94B50D87,0x45A30DF0,0x9499AC95,0x4578DB93,0x947E5C33,
0x454E9E80,0x94631C65,0x452456BD,0x9447ED2F,0x44FA0450,0x942CCE96,0x44CFA740,
0x9411C09E,0x44A53F93,0x93F6C34A,0x447ACD50,0x93DBD6A0,0x4450507E,0x93C0FAA3,
0x4425C923,0x93A62F57,0x43FB3746,0x938B74C1,0x43D09AED,0x9370CAE4,0x43A5F41E,
0x935631C5,0x437B42E1,0x933BA968,0x4350873C,0x932131D1,0x4325C135,0x9306CB04,
0x42FAF0D4,0x92EC7505,0x42D0161E,0x92D22FD9,0x42A5311B,0x92B7FB82,0x427A41D0,
0x929DD806,0x424F4845,0x9283C568,0x42244481,0x9269C3AC,0x41F93689,0x924FD2D7,
0x41CE1E65,0x9235F2EC,0x41A2FC1A,0x921C23EF,0x4177CFB1,0x920265E4,0x414C992F,
0x91E8B8D0,0x4121589B,0x91CF1CB6,0x40F60DFB,0x91B5919A,0x40CAB958,0x919C1781,
0x409F5AB6,0x9182AE6D,0x4073F21D,0x91695663,0x40487F94,0x91500F67,0x401D0321,
0x9136D97D,0x3FF17CCA,0x911DB4A9,0x3FC5EC98,0x9104A0EE,0x3F9A5290,0x90EB9E50,
0x3F6EAEB8,0x90D2ACD4,0x3F430119,0x90B9CC7D,0x3F1749B8,0x90A0FD4E,0x3EEB889C,
0x90883F4D,0x3EBFBDCD,0x906F927C,0x3E93E950,0x9056F6DF,0x3E680B2C,0x903E6C7B,
0x3E3C2369,0x9025F352,0x3E10320D,0x900D8B69,0x3DE4371F,0x8FF534C4,0x3DB832A6,
0x8FDCEF66,0x3D8C24A8,0x8FC4BB53,0x3D600D2C,0x8FAC988F,0x3D33EC39,0x8F94871D,
0x3D07C1D6,0x8F7C8701,0x3CDB8E09,0x8F649840,0x3CAF50DA,0x8F4CBADB,0x3C830A50,
0x8F34EED8,0x3C56BA70,0x8F1D343A,0x3C2A6142,0x8F058B04,0x3BFDFECD,0x8EEDF33B,
0x3BD19318,0x8ED66CE1,0x3BA51E29,0x8EBEF7FB,0x3B78A007,0x8EA7948C,0x3B4C18BA,
0x8E904298,0x3B1F8848,0x8E790222,0x3AF2EEB7,0x8E61D32E,0x3AC64C0F,0x8E4AB5BF,
0x3A99A057,0x8E33A9DA,0x3A6CEB96,0x8E1CAF80,0x3A402DD2,0x8E05C6B7,0x3A136712,
0x8DEEEF82,0x39E6975E,0x8DD829E4,0x39B9BEBC,0x8DC175E0,0x398CDD32,0x8DAAD37B,
0x395FF2C9,0x8D9442B8,0x3932FF87,0x8D7DC399,0x39060373,0x8D675623,0x38D8FE93,
0x8D50FA59,0x38ABF0EF,0x8D3AB03F,0x387EDA8E,0x8D2477D8,0x3851BB77,0x8D0E5127,
0x382493B0,0x8CF83C30,0x37F76341,0x8CE238F6,0x37CA2A30,0x8CCC477D,0x379CE885,
0x8CB667C8,0x376F9E46,0x8CA099DA,0x37424B7B,0x8C8ADDB7,0x3714F02A,0x8C753362,
0x36E78C5B,0x8C5F9ADE,0x36BA2014,0x8C4A142F,0x368CAB5C,0x8C349F58,0x365F2E3B,
0x8C1F3C5D,0x3631A8B8,0x8C09EB40,0x36041AD9,0x8BF4AC05,0x35D684A6,0x8BDF7EB0,
0x35A8E625,0x8BCA6343,0x357B3F5D,0x8BB559C1,0x354D9057,0x8BA0622F,0x351FD918,
0x8B8B7C8F,0x34F219A8,0x8B76A8E4,0x34C4520D,0x8B61E733,0x34968250,0x8B4D377C,
0x3468AA76,0x8B3899C6,0x343ACA87,0x8B240E11,0x340CE28B,0x8B0F9462,0x33DEF287,
0x8AFB2CBB,0x33B0FA84,0x8AE6D720,0x3382FA88,0x8AD29394,0x3354F29B,0x8ABE6219,
0x3326E2C3,0x8AAA42B4,0x32F8CB07,0x8A963567,0x32CAAB6F,0x8A823A36,0x329C8402,
0x8A6E5123,0x326E54C7,0x8A5A7A31,0x32401DC6,0x8A46B564,0x3211DF04,0x8A3302BE,
0x31E39889,0x8A1F6243,0x31B54A5E,0x8A0BD3F5,0x3186F487,0x89F857D8,0x3158970E,
0x89E4EDEF,0x312A31F8,0x89D1963C,0x30FBC54D,0x89BE50C3,0x30CD5115,0x89AB1D87,
0x309ED556,0x8997FC8A,0x30705217,0x8984EDCF,0x3041C761,0x8971F15A,0x30133539,
0x895F072E,0x2FE49BA7,0x894C2F4C,0x2FB5FAB2,0x893969B9,0x2F875262,0x8926B677,
0x2F58A2BE,0x89141589,0x2F29EBCC,0x890186F2,0x2EFB2D95,0x88EF0AB4,0x2ECC681E,
0x88DCA0D3,0x2E9D9B70,0x88CA4951,0x2E6EC792,0x88B80432,0x2E3FEC8B,0x88A5D177,
0x2E110A62,0x8893B125,0x2DE2211E,0x8881A33D,0x2DB330C7,0x886FA7C2,0x2D843964,
0x885DBEB8,0x2D553AFC,0x884BE821,0x2D263596,0x883A23FF,0x2CF72939,0x88287256,
0x2CC815EE,0x8816D327,0x2C98FBBA,0x88054677,0x2C69DAA6,0x87F3CC48,0x2C3AB2B9,
0x87E2649B,0x2C0B83FA,0x87D10F75,0x2BDC4E6F,0x87BFCCD7,0x2BAD1221,0x87AE9CC5,
0x2B7DCF17,0x879D7F41,0x2B4E8558,0x878C744D,0x2B1F34EB,0x877B7BEC,0x2AEFDDD8,
0x876A9621,0x2AC08026,0x8759C2EF,0x2A911BDC,0x87490258,0x2A61B101,0x8738545E,
0x2A323F9E,0x8727B905,0x2A02C7B8,0x8717304E,0x29D34958,0x8706BA3D,0x29A3C485,
0x86F656D3,0x29743946,0x86E60614,0x2944A7A2,0x86D5C802,0x29150FA1,0x86C59C9F,
0x28E5714B,0x86B583EE,0x28B5CCA5,0x86A57DF2,0x288621B9,0x86958AAC,0x2856708D,
0x8685AA20,0x2826B928,0x8675DC4F,0x27F6FB92,0x8666213C,0x27C737D3,0x865678EB,
0x27976DF1,0x8646E35C,0x27679DF4,0x86376092,0x2737C7E3,0x8627F091,0x2707EBC7,
0x86189359,0x26D809A5,0x860948EF,0x26A82186,0x85FA1153,0x26783370,0x85EAEC88,
0x26483F6C,0x85DBDA91,0x26184581,0x85CCDB70,0x25E845B6,0x85BDEF28,0x25B84012,
0x85AF15B9,0x2588349D,0x85A04F28,0x2558235F,0x85919B76,0x25280C5E,0x8582FAA5,
0x24F7EFA2,0x85746CB8,0x24C7CD33,0x8565F1B0,0x2497A517,0x85578991,0x24677758,
0x8549345C,0x243743FA,0x853AF214,0x24070B08,0x852CC2BB,0x23D6CC87,0x851EA652,
0x23A6887F,0x85109CDD,0x23763EF7,0x8502A65C,0x2345EFF8,0x84F4C2D4,0x23159B88,
0x84E6F244,0x22E541AF,0x84D934B1,0x22B4E274,0x84CB8A1B,0x22847DE0,0x84BDF286,
0x225413F8,0x84B06DF2,0x2223A4C5,0x84A2FC62,0x21F3304F,0x84959DD9,0x21C2B69C,
0x84885258,0x219237B5,0x847B19E1,0x2161B3A0,0x846DF477,0x21312A65,0x8460E21A,
0x21009C0C,0x8453E2CF,0x20D0089C,0x8446F695,0x209F701C,0x843A1D70,0x206ED295,
0x842D5762,0x203E300D,0x8420A46C,0x200D888D,0x84140490,0x1FDCDC1B,0x840777D0,
0x1FAC2ABF,0x83FAFE2E,0x1F7B7481,0x83EE97AD,0x1F4AB968,0x83E2444D,0x1F19F97B,
0x83D60412,0x1EE934C3,0x83C9D6FC,0x1EB86B46,0x83BDBD0E,0x1E879D0D,0x83B1B649,
0x1E56CA1E,0x83A5C2B0,0x1E25F282,0x8399E244,0x1DF5163F,0x838E1507,0x1DC4355E,
0x83825AFB,0x1D934FE5,0x8376B422,0x1D6265DD,0x836B207D,0x1D31774D,0x835FA00F,
0x1D00843D,0x835432D8,0x1CCF8CB3,0x8348D8DC,0x1C9E90B8,0x833D921B,0x1C6D9053,
0x83325E97,0x1C3C8B8C,0x83273E52,0x1C0B826A,0x831C314E,0x1BDA74F6,0x8311378D,
0x1BA96335,0x83065110,0x1B784D30,0x82FB7DD8,0x1B4732EF,0x82F0BDE8,0x1B161479,
0x82E61141,0x1AE4F1D6,0x82DB77E5,0x1AB3CB0D,0x82D0F1D5,0x1A82A026,0x82C67F14,
0x1A517128,0x82BC1FA2,0x1A203E1B,0x82B1D381,0x19EF0707,0x82A79AB3,0x19BDCBF3,
0x829D753A,0x198C8CE7,0x82936317,0x195B49EA,0x8289644B,0x192A0304,0x827F78D8,
0x18F8B83C,0x8275A0C0,0x18C7699B,0x826BDC04,0x18961728,0x82622AA6,0x1864C0EA,
0x82588CA7,0x183366E9,0x824F0208,0x1802092C,0x82458ACC,0x17D0A7BC,0x823C26F3,
0x179F429F,0x8232D67F,0x176DD9DE,0x82299971,0x173C6D80,0x82206FCC,0x170AFD8D,
0x82175990,0x16D98A0C,0x820E56BE,0x16A81305,0x82056758,0x1676987F,0x81FC8B60,
0x16451A83,0x81F3C2D7,0x16139918,0x81EB0DBE,0x15E21445,0x81E26C16,0x15B08C12,
0x81D9DDE1,0x157F0086,0x81D16321,0x154D71AA,0x81C8FBD6,0x151BDF86,0x81C0A801,
0x14EA4A1F,0x81B867A5,0x14B8B17F,0x81B03AC2,0x148715AE,0x81A82159,0x145576B1,
0x81A01B6D,0x1423D492,0x819828FD,0x13F22F58,0x81904A0C,0x13C0870A,0x81887E9A,
0x138EDBB1,0x8180C6A9,0x135D2D53,0x8179223A,0x132B7BF9,0x8171914E,0x12F9C7AA,
0x816A13E6,0x12C8106F,0x8162AA04,0x1296564D,0x815B53A8,0x1264994E,0x815410D4,
0x1232D979,0x814CE188,0x120116D5,0x8145C5C7,0x11CF516A,0x813EBD90,0x119D8941,
0x8137C8E6,0x116BBE60,0x8130E7C9,0x1139F0CF,0x812A1A3A,0x11082096,0x8123603A,
0x10D64DBD,0x811CB9CA,0x10A4784B,0x811626EC,0x1072A048,0x810FA7A0,0x1040C5BB,
0x81093BE8,0x100EE8AD,0x8102E3C4,0x0FDD0926,0x80FC9F35,0x0FAB272B,0x80F66E3C,
0x0F7942C7,0x80F050DB,0x0F475BFF,0x80EA4712,0x0F1572DC,0x80E450E2,0x0EE38766,
0x80DE6E4C,0x0EB199A4,0x80D89F51,0x0E7FA99E,0x80D2E3F2,0x0E4DB75B,0x80CD3C2F,
0x0E1BC2E4,0x80C7A80A,0x0DE9CC40,0x80C22784,0x0DB7D376,0x80BCBA9D,0x0D85D88F,
0x80B76156,0x0D53DB92,0x80B21BAF,0x0D21DC87,0x80ACE9AB,0x0CEFDB76,0x80A7CB49,
0x0CBDD865,0x80A2C08B,0x0C8BD35E,0x809DC971,0x0C59CC68,0x8098E5FB,0x0C27C389,
0x8094162C,0x0BF5B8CB,0x808F5A02,0x0BC3AC35,0x808AB180,0x0B919DCF,0x80861CA6,
0x0B5F8D9F,0x80819B74,0x0B2D7BAF,0x807D2DEC,0x0AFB6805,0x8078D40D,0x0AC952AA,
0x80748DD9,0x0A973BA5,0x80705B50,0x0A6522FE,0x806C3C74,0x0A3308BD,0x80683143,
0x0A00ECE8,0x806439C0,0x09CECF89,0x806055EB,0x099CB0A7,0x805C85C4,0x096A9049,
0x8058C94C,0x09386E78,0x80552084,0x09064B3A,0x80518B6B,0x08D42699,0x804E0A04,
0x08A2009A,0x804A9C4D,0x086FD947,0x80474248,0x083DB0A7,0x8043FBF6,0x080B86C2,
0x8040C956,0x07D95B9E,0x803DAA6A,0x07A72F45,0x803A9F31,0x077501BE,0x8037A7AC,
0x0742D311,0x8034C3DD,0x0710A345,0x8031F3C2,0x06DE7262,0x802F375D,0x06AC406F,
0x802C8EAD,0x067A0D76,0x8029F9B4,0x0647D97C,0x80277872,0x0615A48B,0x80250AE7,
0x05E36EA9,0x8022B114,0x05B137DF,0x80206AF8,0x057F0035,0x801E3895,0x054CC7B1,
0x801C19EA,0x051A8E5C,0x801A0EF8,0x04E8543E,0x801817BF,0x04B6195D,0x80163440,
0x0483DDC3,0x8014647B,0x0451A177,0x8012A86F,0x041F6480,0x8011001F,0x03ED26E6,
0x800F6B88,0x03BAE8B2,0x800DEAAD,0x0388A9EA,0x800C7D8C,0x03566A96,0x800B2427,
0x03242ABF,0x8009DE7E,0x02F1EA6C,0x8008AC90,0x02BFA9A4,0x80078E5E,0x028D6870,
0x800683E8,0x025B26D7,0x80058D2F,0x0228E4E2,0x8004AA32,0x01F6A297,0x8003DAF1,
0x01C45FFE,0x80031F6D,0x01921D20,0x800277A6,0x015FDA03,0x8001E39B,0x012D96B1,
0x8001634E,0x00FB5330,0x8000F6BD,0x00C90F88,0x80009DEA,0x0096CBC1,0x800058D4,
0x006487E3,0x8000277A,0x003243F5,0x800009DF,0x7FFFFFFF,0x00000000,0x7FFF6216,
0xFF36F078,0x7FFD885A,0xFE6DE2E0,0x7FFA72D1,0xFDA4D929,0x7FF62182,0xFCDBD541,
0x7FF09478,0xFC12D91A,0x7FE9CBC0,0xFB49E6A3,0x7FE1C76B,0xFA80FFCB,0x7FD8878E,
0xF9B82684,0x7FCE0C3E,0xF8EF5CBB,0x7FC25596,0xF826A462,0x7FB563B3,0xF75DFF66,
0x7FA736B4,0xF6956FB7,0x7F97CEBD,0xF5CCF743,0x7F872BF3,0xF50497FB,0x7F754E80,
0xF43C53CB,0x7F62368F,0xF3742CA2,0x7F4DE451,0xF2AC246E,0x7F3857F6,0xF1E43D1C,
0x7F2191B4,0xF11C789A,0x7F0991C4,0xF054D8D5,0x7EF05860,0xEF8D5FB8,0x7ED5E5C6,
0xEEC60F31,0x7EBA3A39,0xEDFEE92B,0x7E9D55FC,0xED37EF91,0x7E7F3957,0xEC71244F,
0x7E5FE493,0xEBAA894F,0x7E3F57FF,0xEAE4207A,0x7E1D93EA,0xEA1DEBBB,0x7DFA98A8,
0xE957ECFB,0x7DD6668F,0xE8922622,0x7DB0FDF8,0xE7CC9917,0x7D8A5F40,0xE70747C4,
0x7D628AC6,0xE642340D,0x7D3980EC,0xE57D5FDA,0x7D0F4218,0xE4B8CD11,0x7CE3CEB2,
0xE3F47D96,0x7CB72724,0xE330734D,0x7C894BDE,0xE26CB01B,0x7C5A3D50,0xE1A935E2,
0x7C29FBEE,0xE0E60685,0x7BF88830,0xE02323E5,0x7BC5E290,0xDF608FE4,0x7B920B89,
0xDE9E4C60,0x7B5D039E,0xDDDC5B3B,0x7B26CB4F,0xDD1ABE51,0x7AEF6323,0xDC597781,
0x7AB6CBA4,0xDB9888A8,0x7A7D055B,0xDAD7F3A2,0x7A4210D8,0xDA17BA4A,0x7A05EEAD,
0xD957DE7A,0x79C89F6E,0xD898620C,0x798A23B1,0xD7D946D8,0x794A7C12,0xD71A8EB5,
0x7909A92D,0xD65C3B7B,0x78C7ABA2,0xD59E4EFF,0x78848414,0xD4E0CB15,0x78403329,
0xD423B191,0x77FAB989,0xD3670446,0x77B417DF,0xD2AAC504,0x776C4EDB,0xD1EEF59E,
0x77235F2D,0xD13397E2,0x76D94989,0xD078AD9E,0x768E0EA6,0xCFBE389F,0x7641AF3D,
0xCF043AB3,0x75F42C0B,0xCE4AB5A2,0x75A585CF,0xCD91AB39,0x7555BD4C,0xCCD91D3D,
0x7504D345,0xCC210D79,0x74B2C884,0xCB697DB0,0x745F9DD1,0xCAB26FA9,0x740B53FB,
0xC9FBE527,0x73B5EBD1,0xC945DFEC,0x735F6626,0xC89061BA,0x7307C3D0,0xC7DB6C50,
0x72AF05A7,0xC727016D,0x72552C85,0xC67322CE,0x71FA3949,0xC5BFD22E,0x719E2CD2,
0xC50D1149,0x71410805,0xC45AE1D7,0x70E2CBC6,0xC3A94590,0x708378FF,0xC2F83E2A,
0x7023109A,0xC247CD5A,0x6FC19385,0xC197F4D4,0x6F5F02B2,0xC0E8B648,0x6EFB5F12,
0xC03A1368,0x6E96A99D,0xBF8C0DE3,0x6E30E34A,0xBEDEA765,0x6DCA0D14,0xBE31E19B,
0x6D6227FA,0xBD85BE30,0x6CF934FC,0xBCDA3ECB,0x6C8F351C,0xBC2F6513,0x6C242960,
0xBB8532B0,0x6BB812D1,0xBADBA943,0x6B4AF279,0xBA32CA71,0x6ADCC964,0xB98A97D8,
0x6A6D98A4,0xB8E31319,0x69FD614A,0xB83C3DD1,0x698C246C,0xB796199B,0x6919E320,
0xB6F0A812,0x68A69E81,0xB64BEACD,0x683257AB,0xB5A7E362,0x67BD0FBD,0xB5049368,
0x6746C7D8,0xB461FC70,0x66CF8120,0xB3C0200C,0x66573CBB,0xB31EFFCC,0x65DDFBD3,
0xB27E9D3C,0x6563BF92,0xB1DEF9E9,0x64E88926,0xB140175B,0x646C59BF,0xB0A1F71D,
0x63EF3290,0xB0049AB3,0x637114CC,0xAF6803A2,0x62F201AC,0xAECC336C,0x6271FA69,
0xAE312B92,0x61F1003F,0xAD96ED92,0x616F146C,0xACFD7AE8,0x60EC3830,0xAC64D510,
0x60686CCF,0xABCCFD83,0x5FE3B38D,0xAB35F5B5,0x5F5E0DB3,0xAA9FBF1E,0x5ED77C8A,
0xAA0A5B2E,0x5E50015D,0xA975CB57,0x5DC79D7C,0xA8E21106,0x5D3E5237,0xA84F2DAA,
0x5CB420E0,0xA7BD22AC,0x5C290ACC,0xA72BF174,0x5B9D1154,0xA69B9B68,0x5B1035CF,
0xA60C21EE,0x5A82799A,0xA57D8666,0x59F3DE12,0xA4EFCA31,0x59646498,0xA462EEAC,
0x58D40E8C,0xA3D6F534,0x5842DD54,0xA34BDF20,0x57B0D256,0xA2C1ADC9,0x571DEEFA,
0xA2386284,0x568A34A9,0xA1AFFEA3,0x55F5A4D2,0xA1288376,0x556040E2,0xA0A1F24D,
0x54CA0A4B,0xA01C4C73,0x5433027D,0x9F979331,0x539B2AF0,0x9F13C7D0,0x53028518,
0x9E90EB94,0x5269126E,0x9E0EFFC1,0x51CED46E,0x9D8E0597,0x5133CC94,0x9D0DFE54,
0x5097FC5E,0x9C8EEB34,0x4FFB654D,0x9C10CD70,0x4F5E08E3,0x9B93A641,0x4EBFE8A5,
0x9B1776DA,0x4E210617,0x9A9C406E,0x4D8162C4,0x9A22042D,0x4CE10034,0x99A8C345,
0x4C3FDFF4,0x99307EE0,0x4B9E0390,0x98B93828,0x4AFB6C98,0x9842F043,0x4A581C9E,
0x97CDA855,0x49B41533,0x9759617F,0x490F57EE,0x96E61CE0,0x4869E665,0x9673DB94,
0x47C3C22F,0x96029EB6,0x471CECE7,0x9592675C,0x46756828,0x9523369C,0x45CD358F,
0x94B50D87,0x452456BD,0x9447ED2F,0x447ACD50,0x93DBD6A0,0x43D09AED,0x9370CAE4,
0x4325C135,0x9306CB04,0x427A41D0,0x929DD806,0x41CE1E65,0x9235F2EC,0x4121589B,
0x91CF1CB6,0x4073F21D,0x91695663,0x3FC5EC98,0x9104A0EE,0x3F1749B8,0x90A0FD4E,
0x3E680B2C,0x903E6C7B,0x3DB832A6,0x8FDCEF66,0x3D07C1D6,0x8F7C8701,0x3C56BA70,
0x8F1D343A,0x3BA51E29,0x8EBEF7FB,0x3AF2EEB7,0x8E61D32E,0x3A402DD2,0x8E05C6B7,
0x398CDD32,0x8DAAD37B,0x38D8FE93,0x8D50FA59,0x382493B0,0x8CF83C30,0x376F9E46,
0x8CA099DA,0x36BA2014,0x8C4A142F,0x36041AD9,0x8BF4AC05,0x354D9057,0x8BA0622F,
0x34968250,0x8B4D377C,0x33DEF287,0x8AFB2CBB,0x3326E2C3,0x8AAA42B4,0x326E54C7,
0x8A5A7A31,0x31B54A5E,0x8A0BD3F5,0x30FBC54D,0x89BE50C3,0x3041C761,0x8971F15A,
0x2F875262,0x8926B677,0x2ECC681E,0x88DCA0D3,0x2E110A62,0x8893B125,0x2D553AFC,
0x884BE821,0x2C98FBBA,0x88054677,0x2BDC4E6F,0x87BFCCD7,0x2B1F34EB,0x877B7BEC,
0x2A61B101,0x8738545E,0x29A3C485,0x86F656D3,0x28E5714B,0x86B583EE,0x2826B928,
0x8675DC4F,0x27679DF4,0x86376092,0x26A82186,0x85FA1153,0x25E845B6,0x85BDEF28,
0x25280C5E,0x8582FAA5,0x24677758,0x8549345C,0x23A6887F,0x85109CDD,0x22E541AF,
0x84D934B1,0x2223A4C5,0x84A2FC62,0x2161B3A0,0x846DF477,0x209F701C,0x843A1D70,
0x1FDCDC1B,0x840777D0,0x1F19F97B,0x83D60412,0x1E56CA1E,0x83A5C2B0,0x1D934FE5,
0x8376B422,0x1CCF8CB3,0x8348D8DC,0x1C0B826A,0x831C314E,0x1B4732EF,0x82F0BDE8,
0x1A82A026,0x82C67F14,0x19BDCBF3,0x829D753A,0x18F8B83C,0x8275A0C0,0x183366E9,
0x824F0208,0x176DD9DE,0x82299971,0x16A81305,0x82056758,0x15E21445,0x81E26C16,
0x151BDF86,0x81C0A801,0x145576B1,0x81A01B6D,0x138EDBB1,0x8180C6A9,0x12C8106F,
0x8162AA04,0x120116D5,0x8145C5C7,0x1139F0CF,0x812A1A3A,0x1072A048,0x810FA7A0,
0x0FAB272B,0x80F66E3C,0x0EE38766,0x80DE6E4C,0x0E1BC2E4,0x80C7A80A,0x0D53DB92,
0x80B21BAF,0x0C8BD35E,0x809DC971,0x0BC3AC35,0x808AB180,0x0AFB6805,0x8078D40D,
0x0A3308BD,0x80683143,0x096A9049,0x8058C94C,0x08A2009A,0x804A9C4D,0x07D95B9E,
0x803DAA6A,0x0710A345,0x8031F3C2,0x0647D97C,0x80277872,0x057F0035,0x801E3895,
0x04B6195D,0x80163440,0x03ED26E6,0x800F6B88,0x03242ABF,0x8009DE7E,0x025B26D7,
0x80058D2F,0x01921D20,0x800277A6,0x00C90F88,0x80009DEA,0x7FFFFFFF,0x00000000,
0x7FF62182,0xFCDBD541,0x7FD8878E,0xF9B82684,0x7FA736B4,0xF6956FB7,0x7F62368F,
0xF3742CA2,0x7F0991C4,0xF054D8D5,0x7E9D55FC,0xED37EF91,0x7E1D93EA,0xEA1DEBBB,
0x7D8A5F40,0xE70747C4,0x7CE3CEB2,0xE3F47D96,0x7C29FBEE,0xE0E60685,0x7B5D039E,
0xDDDC5B3B,0x7A7D055B,0xDAD7F3A2,0x798A23B1,0xD7D946D8,0x78848414,0xD4E0CB15,
0x776C4EDB,0xD1EEF59E,0x7641AF3D,0xCF043AB3,0x7504D345,0xCC210D79,0x73B5EBD1,
0xC945DFEC,0x72552C85,0xC67322CE,0x70E2CBC6,0xC3A94590,0x6F5F02B2,0xC0E8B648,
0x6DCA0D14,0xBE31E19B,0x6C242960,0xBB8532B0,0x6A6D98A4,0xB8E31319,0x68A69E81,
0xB64BEACD,0x66CF8120,0xB3C0200C,0x64E88926,0xB140175B,0x62F201AC,0xAECC336C,
0x60EC3830,0xAC64D510,0x5ED77C8A,0xAA0A5B2E,0x5CB420E0,0xA7BD22AC,0x5A82799A,
0xA57D8666,0x5842DD54,0xA34BDF20,0x55F5A4D2,0xA1288376,0x539B2AF0,0x9F13C7D0,
0x5133CC94,0x9D0DFE54,0x4EBFE8A5,0x9B1776DA,0x4C3FDFF4,0x99307EE0,0x49B41533,
0x9759617F,0x471CECE7,0x9592675C,0x447ACD50,0x93DBD6A0,0x41CE1E65,0x9235F2EC,
0x3F1749B8,0x90A0FD4E,0x3C56BA70,0x8F1D343A,0x398CDD32,0x8DAAD37B,0x36BA2014,
0x8C4A142F,0x33DEF287,0x8AFB2CBB,0x30FBC54D,0x89BE50C3,0x2E110A62,0x8893B125,
0x2B1F34EB,0x877B7BEC,0x2826B928,0x8675DC4F,0x25280C5E,0x8582FAA5,0x2223A4C5,
0x84A2FC62,0x1F19F97B,0x83D60412,0x1C0B826A,0x831C314E,0x18F8B83C,0x8275A0C0,
0x15E21445,0x81E26C16,0x12C8106F,0x8162AA04,0x0FAB272B,0x80F66E3C,0x0C8BD35E,
0x809DC971,0x096A9049,0x8058C94C,0x0647D97C,0x80277872,0x03242ABF,0x8009DE7E,
0x7FFFFFFF,0x00000000,0x7F62368F,0xF3742CA2,0x7D8A5F40,0xE70747C4,0x7A7D055B,
0xDAD7F3A2,0x7641AF3D,0xCF043AB3,0x70E2CBC6,0xC3A94590,0x6A6D98A4,0xB8E31319,
0x62F201AC,0xAECC336C,0x5A82799A,0xA57D8666,0x5133CC94,0x9D0DFE54,0x471CECE7,
0x9592675C,0x3C56BA70,0x8F1D343A,0x30FBC54D,0x89BE50C3,0x25280C5E,0x8582FAA5,
0x18F8B83C,0x8275A0C0,0x0C8BD35E,0x809DC971,0x7FFFFFFF,0x00000000,0x7641AF3D,
0xCF043AB3,0x5A82799A,0xA57D8666,0x30FBC54D,0x89BE50C3,};

q31_t rearranged_twiddle_stride2_4096_q31[2728]={
0x7FFFFFFF,0x00000000,0x7FFFD886,0xFF9B781D,0x7FFF6216,0xFF36F078,0x7FFE9CB2,
0xFED2694F,0x7FFD885A,0xFE6DE2E0,0x7FFC250F,0xFE095D69,0x7FFA72D1,0xFDA4D929,
0x7FF871A2,0xFD40565C,0x7FF62182,0xFCDBD541,0x7FF38274,0xFC775616,0x7FF09478,
0xFC12D91A,0x7FED5791,0xFBAE5E89,0x7FE9CBC0,0xFB49E6A3,0x7FE5F108,0xFAE571A4,
0x7FE1C76B,0xFA80FFCB,0x7FDD4EEC,0xFA1C9157,0x7FD8878E,0xF9B82684,0x7FD37153,
0xF953BF91,0x7FCE0C3E,0xF8EF5CBB,0x7FC85854,0xF88AFE42,0x7FC25596,0xF826A462,
0x7FBC040A,0xF7C24F59,0x7FB563B3,0xF75DFF66,0x7FAE7495,0xF6F9B4C6,0x7FA736B4,
0xF6956FB7,0x7F9FAA15,0xF6313077,0x7F97CEBD,0xF5CCF743,0x7F8FA4B0,0xF568C45B,
0x7F872BF3,0xF50497FB,0x7F7E648C,0xF4A07261,0x7F754E80,0xF43C53CB,0x7F6BE9D4,
0xF3D83C77,0x7F62368F,0xF3742CA2,0x7F5834B7,0xF310248A,0x7F4DE451,0xF2AC246E,
0x7F434563,0xF2482C8A,0x7F3857F6,0xF1E43D1C,0x7F2D1C0E,0xF1805662,0x7F2191B4,
0xF11C789A,0x7F15B8EE,0xF0B8A401,0x7F0991C4,0xF054D8D5,0x7EFD1C3C,0xEFF11753,
0x7EF05860,0xEF8D5FB8,0x7EE34636,0xEF29B243,0x7ED5E5C6,0xEEC60F31,0x7EC8371A,
0xEE6276BF,0x7EBA3A39,0xEDFEE92B,0x7EABEF2C,0xED9B66B2,0x7E9D55FC,0xED37EF91,
0x7E8E6EB2,0xECD48407,0x7E7F3957,0xEC71244F,0x7E6FB5F4,0xEC0DD0A8,0x7E5FE493,
0xEBAA894F,0x7E4FC53E,0xEB474E81,0x7E3F57FF,0xEAE4207A,0x7E2E9CDF,0xEA80FF7A,
0x7E1D93EA,0xEA1DEBBB,0x7E0C3D29,0xE9BAE57D,0x7DFA98A8,0xE957ECFB,0x7DE8A670,
0xE8F50273,0x7DD6668F,0xE8922622,0x7DC3D90D,0xE82F5844,0x7DB0FDF8,0xE7CC9917,
0x7D9DD55A,0xE769E8D8,0x7D8A5F40,0xE70747C4,0x7D769BB5,0xE6A4B616,0x7D628AC6,
0xE642340D,0x7D4E2C7F,0xE5DFC1E5,0x7D3980EC,0xE57D5FDA,0x7D24881B,0xE51B0E2A,
0x7D0F4218,0xE4B8CD11,0x7CF9AEF0,0xE4569CCB,0x7CE3CEB2,0xE3F47D96,0x7CCDA169,
0xE3926FAD,0x7CB72724,0xE330734D,0x7CA05FF1,0xE2CE88B3,0x7C894BDE,0xE26CB01B,
0x7C71EAF9,0xE20AE9C1,0x7C5A3D50,0xE1A935E2,0x7C4242F2,0xE14794BA,0x7C29FBEE,
0xE0E60685,0x7C116853,0xE0848B7F,0x7BF88830,0xE02323E5,0x7BDF5B94,0xDFC1CFF3,
0x7BC5E290,0xDF608FE4,0x7BAC1D31,0xDEFF63F4,0x7B920B89,0xDE9E4C60,0x7B77ADA8,
0xDE3D4964,0x7B5D039E,0xDDDC5B3B,0x7B420D7A,0xDD7B8220,0x7B26CB4F,0xDD1ABE51,
0x7B0B3D2C,0xDCBA1008,0x7AEF6323,0xDC597781,0x7AD33D45,0xDBF8F4F8,0x7AB6CBA4,
0xDB9888A8,0x7A9A0E50,0xDB3832CD,0x7A7D055B,0xDAD7F3A2,0x7A5FB0D8,0xDA77CB63,
0x7A4210D8,0xDA17BA4A,0x7A24256F,0xD9B7C094,0x7A05EEAD,0xD957DE7A,0x79E76CA7,
0xD8F81439,0x79C89F6E,0xD898620C,0x79A98715,0xD838C82D,0x798A23B1,0xD7D946D8,
0x796A7554,0xD779DE47,0x794A7C12,0xD71A8EB5,0x792A37FE,0xD6BB585E,0x7909A92D,
0xD65C3B7B,0x78E8CFB2,0xD5FD3848,0x78C7ABA2,0xD59E4EFF,0x78A63D11,0xD53F7FDA,
0x78848414,0xD4E0CB15,0x786280BF,0xD48230E9,0x78403329,0xD423B191,0x781D9B65,
0xD3C54D47,0x77FAB989,0xD3670446,0x77D78DAA,0xD308D6C7,0x77B417DF,0xD2AAC504,
0x7790583E,0xD24CCF39,0x776C4EDB,0xD1EEF59E,0x7747FBCE,0xD191386E,0x77235F2D,
0xD13397E2,0x76FE790E,0xD0D61434,0x76D94989,0xD078AD9E,0x76B3D0B4,0xD01B6459,
0x768E0EA6,0xCFBE389F,0x76680376,0xCF612AAA,0x7641AF3D,0xCF043AB3,0x761B1211,
0xCEA768F2,0x75F42C0B,0xCE4AB5A2,0x75CCFD42,0xCDEE20FC,0x75A585CF,0xCD91AB39,
0x757DC5CA,0xCD355491,0x7555BD4C,0xCCD91D3D,0x752D6C6C,0xCC7D0578,0x7504D345,
0xCC210D79,0x74DBF1EF,0xCBC53579,0x74B2C884,0xCB697DB0,0x7489571C,0xCB0DE658,
0x745F9DD1,0xCAB26FA9,0x74359CBD,0xCA5719DB,0x740B53FB,0xC9FBE527,0x73E0C3A3,
0xC9A0D1C5,0x73B5EBD1,0xC945DFEC,0x738ACC9E,0xC8EB0FD6,0x735F6626,0xC89061BA,
0x7333B883,0xC835D5D0,0x7307C3D0,0xC7DB6C50,0x72DB8828,0xC7812572,0x72AF05A7,
0xC727016D,0x72823C67,0xC6CD0079,0x72552C85,0xC67322CE,0x7227D61C,0xC61968A2,
0x71FA3949,0xC5BFD22E,0x71CC5626,0xC5665FA9,0x719E2CD2,0xC50D1149,0x716FBD68,
0xC4B3E746,0x71410805,0xC45AE1D7,0x71120CC5,0xC4020133,0x70E2CBC6,0xC3A94590,
0x70B34525,0xC350AF26,0x708378FF,0xC2F83E2A,0x70536771,0xC29FF2D4,0x7023109A,
0xC247CD5A,0x6FF27497,0xC1EFCDF3,0x6FC19385,0xC197F4D4,0x6F906D84,0xC1404233,
0x6F5F02B2,0xC0E8B648,0x6F2D532C,0xC0915148,0x6EFB5F12,0xC03A1368,0x6EC92683,
0xBFE2FCDF,0x6E96A99D,0xBF8C0DE3,0x6E63E87F,0xBF3546A8,0x6E30E34A,0xBEDEA765,
0x6DFD9A1C,0xBE88304F,0x6DCA0D14,0xBE31E19B,0x6D963C54,0xBDDBBB7F,0x6D6227FA,
0xBD85BE30,0x6D2DD027,0xBD2FE9E2,0x6CF934FC,0xBCDA3ECB,0x6CC45698,0xBC84BD1F,
0x6C8F351C,0xBC2F6513,0x6C59D0A9,0xBBDA36DD,0x6C242960,0xBB8532B0,0x6BEE3F62,
0xBB3058C0,0x6BB812D1,0xBADBA943,0x6B81A3CD,0xBA87246D,0x6B4AF279,0xBA32CA71,
0x6B13FEF5,0xB9DE9B83,0x6ADCC964,0xB98A97D8,0x6AA551E9,0xB936BFA4,0x6A6D98A4,
0xB8E31319,0x6A359DB9,0xB88F926D,0x69FD614A,0xB83C3DD1,0x69C4E37A,0xB7E9157A,
0x698C246C,0xB796199B,0x69532442,0xB7434A67,0x6919E320,0xB6F0A812,0x68E06129,
0xB69E32CD,0x68A69E81,0xB64BEACD,0x686C9B4B,0xB5F9D043,0x683257AB,0xB5A7E362,
0x67F7D3C5,0xB556245E,0x67BD0FBD,0xB5049368,0x67820BB7,0xB4B330B3,0x6746C7D8,
0xB461FC70,0x670B4444,0xB410F6D3,0x66CF8120,0xB3C0200C,0x66937E91,0xB36F784F,
0x66573CBB,0xB31EFFCC,0x661ABBC5,0xB2CEB6B5,0x65DDFBD3,0xB27E9D3C,0x65A0FD0B,
0xB22EB392,0x6563BF92,0xB1DEF9E9,0x6526438F,0xB18F7071,0x64E88926,0xB140175B,
0x64AA907F,0xB0F0EEDA,0x646C59BF,0xB0A1F71D,0x642DE50D,0xB0533055,0x63EF3290,
0xB0049AB3,0x63B0426D,0xAFB63667,0x637114CC,0xAF6803A2,0x6331A9D4,0xAF1A0293,
0x62F201AC,0xAECC336C,0x62B21C7B,0xAE7E965B,0x6271FA69,0xAE312B92,0x62319B9D,
0xADE3F33E,0x61F1003F,0xAD96ED92,0x61B02876,0xAD4A1ABA,0x616F146C,0xACFD7AE8,
0x612DC447,0xACB10E4B,0x60EC3830,0xAC64D510,0x60AA7050,0xAC18CF69,0x60686CCF,
0xABCCFD83,0x60262DD6,0xAB815F8D,0x5FE3B38D,0xAB35F5B5,0x5FA0FE1F,0xAAEAC02C,
0x5F5E0DB3,0xAA9FBF1E,0x5F1AE274,0xAA54F2BA,0x5ED77C8A,0xAA0A5B2E,0x5E93DC1F,
0xA9BFF8A8,0x5E50015D,0xA975CB57,0x5E0BEC6E,0xA92BD367,0x5DC79D7C,0xA8E21106,
0x5D8314B1,0xA8988463,0x5D3E5237,0xA84F2DAA,0x5CF95638,0xA8060D08,0x5CB420E0,
0xA7BD22AC,0x5C6EB258,0xA7746EC0,0x5C290ACC,0xA72BF174,0x5BE32A67,0xA6E3AAF2,
0x5B9D1154,0xA69B9B68,0x5B56BFBD,0xA653C303,0x5B1035CF,0xA60C21EE,0x5AC973B5,
0xA5C4B855,0x5A82799A,0xA57D8666,0x5A3B47AB,0xA5368C4B,0x59F3DE12,0xA4EFCA31,
0x59AC3CFD,0xA4A94043,0x59646498,0xA462EEAC,0x591C550E,0xA41CD599,0x58D40E8C,
0xA3D6F534,0x588B9140,0xA3914DA8,0x5842DD54,0xA34BDF20,0x57F9F2F8,0xA306A9C8,
0x57B0D256,0xA2C1ADC9,0x57677B9D,0xA27CEB4F,0x571DEEFA,0xA2386284,0x56D42C99,
0xA1F41392,0x568A34A9,0xA1AFFEA3,0x56400758,0xA16C23E1,0x55F5A4D2,0xA1288376,
0x55AB0D46,0xA0E51D8C,0x556040E2,0xA0A1F24D,0x55153FD4,0xA05F01E1,0x54CA0A4B,
0xA01C4C73,0x547EA073,0x9FD9D22A,0x5433027D,0x9F979331,0x53E73097,0x9F558FB0,
0x539B2AF0,0x9F13C7D0,0x534EF1B5,0x9ED23BB9,0x53028518,0x9E90EB94,0x52B5E546,
0x9E4FD78A,0x5269126E,0x9E0EFFC1,0x521C0CC2,0x9DCE6463,0x51CED46E,0x9D8E0597,
0x518169A5,0x9D4DE385,0x5133CC94,0x9D0DFE54,0x50E5FD6D,0x9CCE562C,0x5097FC5E,
0x9C8EEB34,0x5049C999,0x9C4FBD93,0x4FFB654D,0x9C10CD70,0x4FACCFAB,0x9BD21AF3,
0x4F5E08E3,0x9B93A641,0x4F0F1126,0x9B556F81,0x4EBFE8A5,0x9B1776DA,0x4E708F8F,
0x9AD9BC71,0x4E210617,0x9A9C406E,0x4DD14C6E,0x9A5F02F5,0x4D8162C4,0x9A22042D,
0x4D31494B,0x99E5443B,0x4CE10034,0x99A8C345,0x4C9087B1,0x996C816F,0x4C3FDFF4,
0x99307EE0,0x4BEF092D,0x98F4BBBC,0x4B9E0390,0x98B93828,0x4B4CCF4D,0x987DF449,
0x4AFB6C98,0x9842F043,0x4AA9DBA2,0x98082C3B,0x4A581C9E,0x97CDA855,0x4A062FBD,
0x979364B5,0x49B41533,0x9759617F,0x4961CD33,0x971F9ED7,0x490F57EE,0x96E61CE0,
0x48BCB599,0x96ACDBBE,0x4869E665,0x9673DB94,0x4816EA86,0x963B1C86,0x47C3C22F,
0x96029EB6,0x47706D93,0x95CA6247,0x471CECE7,0x9592675C,0x46C9405C,0x955AAE17,
0x46756828,0x9523369C,0x4621647D,0x94EC010B,0x45CD358F,0x94B50D87,0x4578DB93,
0x947E5C33,0x452456BD,0x9447ED2F,0x44CFA740,0x9411C09E,0x447ACD50,0x93DBD6A0,
0x4425C923,0x93A62F57,0x43D09AED,0x9370CAE4,0x437B42E1,0x933BA968,0x4325C135,
0x9306CB04,0x42D0161E,0x92D22FD9,0x427A41D0,0x929DD806,0x42244481,0x9269C3AC,
0x41CE1E65,0x9235F2EC,0x4177CFB1,0x920265E4,0x4121589B,0x91CF1CB6,0x40CAB958,
0x919C1781,0x4073F21D,0x91695663,0x401D0321,0x9136D97D,0x3FC5EC98,0x9104A0EE,
0x3F6EAEB8,0x90D2ACD4,0x3F1749B8,0x90A0FD4E,0x3EBFBDCD,0x906F927C,0x3E680B2C,
0x903E6C7B,0x3E10320D,0x900D8B69,0x3DB832A6,0x8FDCEF66,0x3D600D2C,0x8FAC988F,
0x3D07C1D6,0x8F7C8701,0x3CAF50DA,0x8F4CBADB,0x3C56BA70,0x8F1D343A,0x3BFDFECD,
0x8EEDF33B,0x3BA51E29,0x8EBEF7FB,0x3B4C18BA,0x8E904298,0x3AF2EEB7,0x8E61D32E,
0x3A99A057,0x8E33A9DA,0x3A402DD2,0x8E05C6B7,0x39E6975E,0x8DD829E4,0x398CDD32,
0x8DAAD37B,0x3932FF87,0x8D7DC399,0x38D8FE93,0x8D50FA59,0x387EDA8E,0x8D2477D8,
0x382493B0,0x8CF83C30,0x37CA2A30,0x8CCC477D,0x376F9E46,0x8CA099DA,0x3714F02A,
0x8C753362,0x36BA2014,0x8C4A142F,0x365F2E3B,0x8C1F3C5D,0x36041AD9,0x8BF4AC05,
0x35A8E625,0x8BCA6343,0x354D9057,0x8BA0622F,0x34F219A8,0x8B76A8E4,0x34968250,
0x8B4D377C,0x343ACA87,0x8B240E11,0x33DEF287,0x8AFB2CBB,0x3382FA88,0x8AD29394,
0x3326E2C3,0x8AAA42B4,0x32CAAB6F,0x8A823A36,0x326E54C7,0x8A5A7A31,0x3211DF04,
0x8A3302BE,0x31B54A5E,0x8A0BD3F5,0x3158970E,0x89E4EDEF,0x30FBC54D,0x89BE50C3,
0x309ED556,0x8997FC8A,0x3041C761,0x8971F15A,0x2FE49BA7,0x894C2F4C,0x2F875262,
0x8926B677,0x2F29EBCC,0x890186F2,0x2ECC681E,0x88DCA0D3,0x2E6EC792,0x88B80432,
0x2E110A62,0x8893B125,0x2DB330C7,0x886FA7C2,0x2D553AFC,0x884BE821,0x2CF72939,
0x88287256,0x2C98FBBA,0x88054677,0x2C3AB2B9,0x87E2649B,0x2BDC4E6F,0x87BFCCD7,
0x2B7DCF17,0x879D7F41,0x2B1F34EB,0x877B7BEC,0x2AC08026,0x8759C2EF,0x2A61B101,
0x8738545E,0x2A02C7B8,0x8717304E,0x29A3C485,0x86F656D3,0x2944A7A2,0x86D5C802,
0x28E5714B,0x86B583EE,0x288621B9,0x86958AAC,0x2826B928,0x8675DC4F,0x27C737D3,
0x865678EB,0x27679DF4,0x86376092,0x2707EBC7,0x86189359,0x26A82186,0x85FA1153,
0x26483F6C,0x85DBDA91,0x25E845B6,0x85BDEF28,0x2588349D,0x85A04F28,0x25280C5E,
0x8582FAA5,0x24C7CD33,0x8565F1B0,0x24677758,0x8549345C,0x24070B08,0x852CC2BB,
0x23A6887F,0x85109CDD,0x2345EFF8,0x84F4C2D4,0x22E541AF,0x84D934B1,0x22847DE0,
0x84BDF286,0x2223A4C5,0x84A2FC62,0x21C2B69C,0x84885258,0x2161B3A0,0x846DF477,
0x21009C0C,0x8453E2CF,0x209F701C,0x843A1D70,0x203E300D,0x8420A46C,0x1FDCDC1B,
0x840777D0,0x1F7B7481,0x83EE97AD,0x1F19F97B,0x83D60412,0x1EB86B46,0x83BDBD0E,
0x1E56CA1E,0x83A5C2B0,0x1DF5163F,0x838E1507,0x1D934FE5,0x8376B422,0x1D31774D,
0x835FA00F,0x1CCF8CB3,0x8348D8DC,0x1C6D9053,0x83325E97,0x1C0B826A,0x831C314E,
0x1BA96335,0x83065110,0x1B4732EF,0x82F0BDE8,0x1AE4F1D6,0x82DB77E5,0x1A82A026,
0x82C67F14,0x1A203E1B,0x82B1D381,0x19BDCBF3,0x829D753A,0x195B49EA,0x8289644B,
0x18F8B83C,0x8275A0C0,0x18961728,0x82622AA6,0x183366E9,0x824F0208,0x17D0A7BC,
0x823C26F3,0x176DD9DE,0x82299971,0x170AFD8D,0x82175990,0x16A81305,0x82056758,
0x16451A83,0x81F3C2D7,0x15E21445,0x81E26C16,0x157F0086,0x81D16321,0x151BDF86,
0x81C0A801,0x14B8B17F,0x81B03AC2,0x145576B1,0x81A01B6D,0x13F22F58,0x81904A0C,
0x138EDBB1,0x8180C6A9,0x132B7BF9,0x8171914E,0x12C8106F,0x8162AA04,0x1264994E,
0x815410D4,0x120116D5,0x8145C5C7,0x119D8941,0x8137C8E6,0x1139F0CF,0x812A1A3A,
0x10D64DBD,0x811CB9CA,0x1072A048,0x810FA7A0,0x100EE8AD,0x8102E3C4,0x0FAB272B,
0x80F66E3C,0x0F475BFF,0x80EA4712,0x0EE38766,0x80DE6E4C,0x0E7FA99E,0x80D2E3F2,
0x0E1BC2E4,0x80C7A80A,0x0DB7D376,0x80BCBA9D,0x0D53DB92,0x80B21BAF,0x0CEFDB76,
0x80A7CB49,0x0C8BD35E,0x809DC971,0x0C27C389,0x8094162C,0x0BC3AC35,0x808AB180,
0x0B5F8D9F,0x80819B74,0x0AFB6805,0x8078D40D,0x0A973BA5,0x80705B50,0x0A3308BD,
0x80683143,0x09CECF89,0x806055EB,0x096A9049,0x8058C94C,0x09064B3A,0x80518B6B,
0x08A2009A,0x804A9C4D,0x083DB0A7,0x8043FBF6,0x07D95B9E,0x803DAA6A,0x077501BE,
0x8037A7AC,0x0710A345,0x8031F3C2,0x06AC406F,0x802C8EAD,0x0647D97C,0x80277872,
0x05E36EA9,0x8022B114,0x057F0035,0x801E3895,0x051A8E5C,0x801A0EF8,0x04B6195D,
0x80163440,0x0451A177,0x8012A86F,0x03ED26E6,0x800F6B88,0x0388A9EA,0x800C7D8C,
0x03242ABF,0x8009DE7E,0x02BFA9A4,0x80078E5E,0x025B26D7,0x80058D2F,0x01F6A297,
0x8003DAF1,0x01921D20,0x800277A6,0x012D96B1,0x8001634E,0x00C90F88,0x80009DEA,
0x006487E3,0x8000277A,0x00000000,0x80000000,0xFF9B781D,0x8000277A,0xFF36F078,
0x80009DEA,0xFED2694F,0x8001634E,0xFE6DE2E0,0x800277A6,0xFE095D69,0x8003DAF1,
0xFDA4D929,0x80058D2F,0xFD40565C,0x80078E5E,0xFCDBD541,0x8009DE7E,0xFC775616,
0x800C7D8C,0xFC12D91A,0x800F6B88,0xFBAE5E89,0x8012A86F,0xFB49E6A3,0x80163440,
0xFAE571A4,0x801A0EF8,0xFA80FFCB,0x801E3895,0xFA1C9157,0x8022B114,0xF9B82684,
0x80277872,0xF953BF91,0x802C8EAD,0xF8EF5CBB,0x8031F3C2,0xF88AFE42,0x8037A7AC,
0xF826A462,0x803DAA6A,0xF7C24F59,0x8043FBF6,0xF75DFF66,0x804A9C4D,0xF6F9B4C6,
0x80518B6B,0xF6956FB7,0x8058C94C,0xF6313077,0x806055EB,0xF5CCF743,0x80683143,
0xF568C45B,0x80705B50,0xF50497FB,0x8078D40D,0xF4A07261,0x80819B74,0xF43C53CB,
0x808AB180,0xF3D83C77,0x8094162C,0xF3742CA2,0x809DC971,0xF310248A,0x80A7CB49,
0xF2AC246E,0x80B21BAF,0xF2482C8A,0x80BCBA9D,0xF1E43D1C,0x80C7A80A,0xF1805662,
0x80D2E3F2,0xF11C789A,0x80DE6E4C,0xF0B8A401,0x80EA4712,0xF054D8D5,0x80F66E3C,
0xEFF11753,0x8102E3C4,0xEF8D5FB8,0x810FA7A0,0xEF29B243,0x811CB9CA,0xEEC60F31,
0x812A1A3A,0xEE6276BF,0x8137C8E6,0xEDFEE92B,0x8145C5C7,0xED9B66B2,0x815410D4,
0xED37EF91,0x8162AA04,0xECD48407,0x8171914E,0xEC71244F,0x8180C6A9,0xEC0DD0A8,
0x81904A0C,0xEBAA894F,0x81A01B6D,0xEB474E81,0x81B03AC2,0xEAE4207A,0x81C0A801,
0xEA80FF7A,0x81D16321,0xEA1DEBBB,0x81E26C16,0xE9BAE57D,0x81F3C2D7,0xE957ECFB,
0x82056758,0xE8F50273,0x82175990,0xE8922622,0x82299971,0xE82F5844,0x823C26F3,
0xE7CC9917,0x824F0208,0xE769E8D8,0x82622AA6,0xE70747C4,0x8275A0C0,0xE6A4B616,
0x8289644B,0xE642340D,0x829D753A,0xE5DFC1E5,0x82B1D381,0xE57D5FDA,0x82C67F14,
0xE51B0E2A,0x82DB77E5,0xE4B8CD11,0x82F0BDE8,0xE4569CCB,0x83065110,0xE3F47D96,
0x831C314E,0xE3926FAD,0x83325E97,0xE330734D,0x8348D8DC,0xE2CE88B3,0x835FA00F,
0xE26CB01B,0x8376B422,0xE20AE9C1,0x838E1507,0xE1A935E2,0x83A5C2B0,0xE14794BA,
0x83BDBD0E,0xE0E60685,0x83D60412,0xE0848B7F,0x83EE97AD,0xE02323E5,0x840777D0,
0xDFC1CFF3,0x8420A46C,0xDF608FE4,0x843A1D70,0xDEFF63F4,0x8453E2CF,0xDE9E4C60,
0x846DF477,0xDE3D4964,0x84885258,0xDDDC5B3B,0x84A2FC62,0xDD7B8220,0x84BDF286,
0xDD1ABE51,0x84D934B1,0xDCBA1008,0x84F4C2D4,0xDC597781,0x85109CDD,0xDBF8F4F8,
0x852CC2BB,0xDB9888A8,0x8549345C,0xDB3832CD,0x8565F1B0,0xDAD7F3A2,0x8582FAA5,
0xDA77CB63,0x85A04F28,0xDA17BA4A,0x85BDEF28,0xD9B7C094,0x85DBDA91,0xD957DE7A,
0x85FA1153,0xD8F81439,0x86189359,0xD898620C,0x86376092,0xD838C82D,0x865678EB,
0xD7D946D8,0x8675DC4F,0xD779DE47,0x86958AAC,0xD71A8EB5,0x86B583EE,0xD6BB585E,
0x86D5C802,0xD65C3B7B,0x86F656D3,0xD5FD3848,0x8717304E,0xD59E4EFF,0x8738545E,
0xD53F7FDA,0x8759C2EF,0xD4E0CB15,0x877B7BEC,0xD48230E9,0x879D7F41,0xD423B191,
0x87BFCCD7,0xD3C54D47,0x87E2649B,0xD3670446,0x88054677,0xD308D6C7,0x88287256,
0xD2AAC504,0x884BE821,0xD24CCF39,0x886FA7C2,0xD1EEF59E,0x8893B125,0xD191386E,
0x88B80432,0xD13397E2,0x88DCA0D3,0xD0D61434,0x890186F2,0xD078AD9E,0x8926B677,
0xD01B6459,0x894C2F4C,0xCFBE389F,0x8971F15A,0xCF612AAA,0x8997FC8A,0xCF043AB3,
0x89BE50C3,0xCEA768F2,0x89E4EDEF,0xCE4AB5A2,0x8A0BD3F5,0xCDEE20FC,0x8A3302BE,
0xCD91AB39,0x8A5A7A31,0xCD355491,0x8A823A36,0xCCD91D3D,0x8AAA42B4,0xCC7D0578,
0x8AD29394,0xCC210D79,0x8AFB2CBB,0xCBC53579,0x8B240E11,0xCB697DB0,0x8B4D377C,
0xCB0DE658,0x8B76A8E4,0xCAB26FA9,0x8BA0622F,0xCA5719DB,0x8BCA6343,0xC9FBE527,
0x8BF4AC05,0xC9A0D1C5,0x8C1F3C5D,0xC945DFEC,0x8C4A142F,0xC8EB0FD6,0x8C753362,
0xC89061BA,0x8CA099DA,0xC835D5D0,0x8CCC477D,0xC7DB6C50,0x8CF83C30,0xC7812572,
0x8D2477D8,0xC727016D,0x8D50FA59,0xC6CD0079,0x8D7DC399,0xC67322CE,0x8DAAD37B,
0xC61968A2,0x8DD829E4,0xC5BFD22E,0x8E05C6B7,0xC5665FA9,0x8E33A9DA,0xC50D1149,
0x8E61D32E,0xC4B3E746,0x8E904298,0xC45AE1D7,0x8EBEF7FB,0xC4020133,0x8EEDF33B,
0xC3A94590,0x8F1D343A,0xC350AF26,0x8F4CBADB,0xC2F83E2A,0x8F7C8701,0xC29FF2D4,
0x8FAC988F,0xC247CD5A,0x8FDCEF66,0xC1EFCDF3,0x900D8B69,0xC197F4D4,0x903E6C7B,
0xC1404233,0x906F927C,0xC0E8B648,0x90A0FD4E,0xC0915148,0x90D2ACD4,0xC03A1368,
0x9104A0EE,0xBFE2FCDF,0x9136D97D,0xBF8C0DE3,0x91695663,0xBF3546A8,0x919C1781,
0xBEDEA765,0x91CF1CB6,0xBE88304F,0x920265E4,0xBE31E19B,0x9235F2EC,0xBDDBBB7F,
0x9269C3AC,0xBD85BE30,0x929DD806,0xBD2FE9E2,0x92D22FD9,0xBCDA3ECB,0x9306CB04,
0xBC84BD1F,0x933BA968,0xBC2F6513,0x9370CAE4,0xBBDA36DD,0x93A62F57,0xBB8532B0,
0x93DBD6A0,0xBB3058C0,0x9411C09E,0xBADBA943,0x9447ED2F,0xBA87246D,0x947E5C33,
0xBA32CA71,0x94B50D87,0xB9DE9B83,0x94EC010B,0xB98A97D8,0x9523369C,0xB936BFA4,
0x955AAE17,0xB8E31319,0x9592675C,0xB88F926D,0x95CA6247,0xB83C3DD1,0x96029EB6,
0xB7E9157A,0x963B1C86,0xB796199B,0x9673DB94,0xB7434A67,0x96ACDBBE,0xB6F0A812,
0x96E61CE0,0xB69E32CD,0x971F9ED7,0xB64BEACD,0x9759617F,0xB5F9D043,0x979364B5,
0xB5A7E362,0x97CDA855,0xB556245E,0x98082C3B,0xB5049368,0x9842F043,0xB4B330B3,
0x987DF449,0xB461FC70,0x98B93828,0xB410F6D3,0x98F4BBBC,0xB3C0200C,0x99307EE0,
0xB36F784F,0x996C816F,0xB31EFFCC,0x99A8C345,0xB2CEB6B5,0x99E5443B,0xB27E9D3C,
0x9A22042D,0xB22EB392,0x9A5F02F5,0xB1DEF9E9,0x9A9C406E,0xB18F7071,0x9AD9BC71,
0xB140175B,0x9B1776DA,0xB0F0EEDA,0x9B556F81,0xB0A1F71D,0x9B93A641,0xB0533055,
0x9BD21AF3,0xB0049AB3,0x9C10CD70,0xAFB63667,0x9C4FBD93,0xAF6803A2,0x9C8EEB34,
0xAF1A0293,0x9CCE562C,0xAECC336C,0x9D0DFE54,0xAE7E965B,0x9D4DE385,0xAE312B92,
0x9D8E0597,0xADE3F33E,0x9DCE6463,0xAD96ED92,0x9E0EFFC1,0xAD4A1ABA,0x9E4FD78A,
0xACFD7AE8,0x9E90EB94,0xACB10E4B,0x9ED23BB9,0xAC64D510,0x9F13C7D0,0xAC18CF69,
0x9F558FB0,0xABCCFD83,0x9F979331,0xAB815F8D,0x9FD9D22A,0xAB35F5B5,0xA01C4C73,
0xAAEAC02C,0xA05F01E1,0xAA9FBF1E,0xA0A1F24D,0xAA54F2BA,0xA0E51D8C,0xAA0A5B2E,
0xA1288376,0xA9BFF8A8,0xA16C23E1,0xA975CB57,0xA1AFFEA3,0xA92BD367,0xA1F41392,
0xA8E21106,0xA2386284,0xA8988463,0xA27CEB4F,0xA84F2DAA,0xA2C1ADC9,0xA8060D08,
0xA306A9C8,0xA7BD22AC,0xA34BDF20,0xA7746EC0,0xA3914DA8,0xA72BF174,0xA3D6F534,
0xA6E3AAF2,0xA41CD599,0xA69B9B68,0xA462EEAC,0xA653C303,0xA4A94043,0xA60C21EE,
0xA4EFCA31,0xA5C4B855,0xA5368C4B,0xA57D8666,0xA57D8666,0xA5368C4B,0xA5C4B855,
0xA4EFCA31,0xA60C21EE,0xA4A94043,0xA653C303,0xA462EEAC,0xA69B9B68,0xA41CD599,
0xA6E3AAF2,0xA3D6F534,0xA72BF174,0xA3914DA8,0xA7746EC0,0xA34BDF20,0xA7BD22AC,
0xA306A9C8,0xA8060D08,0xA2C1ADC9,0xA84F2DAA,0xA27CEB4F,0xA8988463,0xA2386284,
0xA8E21106,0xA1F41392,0xA92BD367,0xA1AFFEA3,0xA975CB57,0xA16C23E1,0xA9BFF8A8,
0xA1288376,0xAA0A5B2E,0xA0E51D8C,0xAA54F2BA,0xA0A1F24D,0xAA9FBF1E,0xA05F01E1,
0xAAEAC02C,0xA01C4C73,0xAB35F5B5,0x9FD9D22A,0xAB815F8D,0x9F979331,0xABCCFD83,
0x9F558FB0,0xAC18CF69,0x9F13C7D0,0xAC64D510,0x9ED23BB9,0xACB10E4B,0x9E90EB94,
0xACFD7AE8,0x9E4FD78A,0xAD4A1ABA,0x9E0EFFC1,0xAD96ED92,0x9DCE6463,0xADE3F33E,
0x9D8E0597,0xAE312B92,0x9D4DE385,0xAE7E965B,0x9D0DFE54,0xAECC336C,0x9CCE562C,
0xAF1A0293,0x9C8EEB34,0xAF6803A2,0x9C4FBD93,0xAFB63667,0x9C10CD70,0xB0049AB3,
0x9BD21AF3,0xB0533055,0x9B93A641,0xB0A1F71D,0x9B556F81,0xB0F0EEDA,0x9B1776DA,
0xB140175B,0x9AD9BC71,0xB18F7071,0x9A9C406E,0xB1DEF9E9,0x9A5F02F5,0xB22EB392,
0x9A22042D,0xB27E9D3C,0x99E5443B,0xB2CEB6B5,0x99A8C345,0xB31EFFCC,0x996C816F,
0xB36F784F,0x99307EE0,0xB3C0200C,0x98F4BBBC,0xB410F6D3,0x98B93828,0xB461FC70,
0x987DF449,0xB4B330B3,0x9842F043,0xB5049368,0x98082C3B,0xB556245E,0x97CDA855,
0xB5A7E362,0x979364B5,0xB5F9D043,0x9759617F,0xB64BEACD,0x971F9ED7,0xB69E32CD,
0x96E61CE0,0xB6F0A812,0x96ACDBBE,0xB7434A67,0x9673DB94,0xB796199B,0x963B1C86,
0xB7E9157A,0x96029EB6,0xB83C3DD1,0x95CA6247,0xB88F926D,0x9592675C,0xB8E31319,
0x955AAE17,0xB936BFA4,0x9523369C,0xB98A97D8,0x94EC010B,0xB9DE9B83,0x94B50D87,
0xBA32CA71,0x947E5C33,0xBA87246D,0x9447ED2F,0xBADBA943,0x9411C09E,0xBB3058C0,
0x93DBD6A0,0xBB8532B0,0x93A62F57,0xBBDA36DD,0x9370CAE4,0xBC2F6513,0x933BA968,
0xBC84BD1F,0x9306CB04,0xBCDA3ECB,0x92D22FD9,0xBD2FE9E2,0x929DD806,0xBD85BE30,
0x9269C3AC,0xBDDBBB7F,0x9235F2EC,0xBE31E19B,0x920265E4,0xBE88304F,0x91CF1CB6,
0xBEDEA765,0x919C1781,0xBF3546A8,0x91695663,0xBF8C0DE3,0x9136D97D,0xBFE2FCDF,
0x9104A0EE,0xC03A1368,0x90D2ACD4,0xC0915148,0x90A0FD4E,0xC0E8B648,0x906F927C,
0xC1404233,0x903E6C7B,0xC197F4D4,0x900D8B69,0xC1EFCDF3,0x8FDCEF66,0xC247CD5A,
0x8FAC988F,0xC29FF2D4,0x8F7C8701,0xC2F83E2A,0x8F4CBADB,0xC350AF26,0x8F1D343A,
0xC3A94590,0x8EEDF33B,0xC4020133,0x8EBEF7FB,0xC45AE1D7,0x8E904298,0xC4B3E746,
0x8E61D32E,0xC50D1149,0x8E33A9DA,0xC5665FA9,0x8E05C6B7,0xC5BFD22E,0x8DD829E4,
0xC61968A2,0x8DAAD37B,0xC67322CE,0x8D7DC399,0xC6CD0079,0x8D50FA59,0xC727016D,
0x8D2477D8,0xC7812572,0x8CF83C30,0xC7DB6C50,0x8CCC477D,0xC835D5D0,0x8CA099DA,
0xC89061BA,0x8C753362,0xC8EB0FD6,0x8C4A142F,0xC945DFEC,0x8C1F3C5D,0xC9A0D1C5,
0x8BF4AC05,0xC9FBE527,0x8BCA6343,0xCA5719DB,0x8BA0622F,0xCAB26FA9,0x8B76A8E4,
0xCB0DE658,0x8B4D377C,0xCB697DB0,0x8B240E11,0xCBC53579,0x8AFB2CBB,0xCC210D79,
0x8AD29394,0xCC7D0578,0x8AAA42B4,0xCCD91D3D,0x8A823A36,0xCD355491,0x8A5A7A31,
0xCD91AB39,0x8A3302BE,0xCDEE20FC,0x8A0BD3F5,0xCE4AB5A2,0x89E4EDEF,0xCEA768F2,
0x89BE50C3,0xCF043AB3,0x8997FC8A,0xCF612AAA,0x8971F15A,0xCFBE389F,0x894C2F4C,
0xD01B6459,0x8926B677,0xD078AD9E,0x890186F2,0xD0D61434,0x88DCA0D3,0xD13397E2,
0x88B80432,0xD191386E,0x8893B125,0xD1EEF59E,0x886FA7C2,0xD24CCF39,0x884BE821,
0xD2AAC504,0x88287256,0xD308D6C7,0x88054677,0xD3670446,0x87E2649B,0xD3C54D47,
0x87BFCCD7,0xD423B191,0x879D7F41,0xD48230E9,0x877B7BEC,0xD4E0CB15,0x8759C2EF,
0xD53F7FDA,0x8738545E,0xD59E4EFF,0x8717304E,0xD5FD3848,0x86F656D3,0xD65C3B7B,
0x86D5C802,0xD6BB585E,0x86B583EE,0xD71A8EB5,0x86958AAC,0xD779DE47,0x8675DC4F,
0xD7D946D8,0x865678EB,0xD838C82D,0x86376092,0xD898620C,0x86189359,0xD8F81439,
0x85FA1153,0xD957DE7A,0x85DBDA91,0xD9B7C094,0x85BDEF28,0xDA17BA4A,0x85A04F28,
0xDA77CB63,0x8582FAA5,0xDAD7F3A2,0x8565F1B0,0xDB3832CD,0x8549345C,0xDB9888A8,
0x852CC2BB,0xDBF8F4F8,0x85109CDD,0xDC597781,0x84F4C2D4,0xDCBA1008,0x84D934B1,
0xDD1ABE51,0x84BDF286,0xDD7B8220,0x84A2FC62,0xDDDC5B3B,0x84885258,0xDE3D4964,
0x846DF477,0xDE9E4C60,0x8453E2CF,0xDEFF63F4,0x843A1D70,0xDF608FE4,0x8420A46C,
0xDFC1CFF3,0x840777D0,0xE02323E5,0x83EE97AD,0xE0848B7F,0x83D60412,0xE0E60685,
0x83BDBD0E,0xE14794BA,0x83A5C2B0,0xE1A935E2,0x838E1507,0xE20AE9C1,0x8376B422,
0xE26CB01B,0x835FA00F,0xE2CE88B3,0x8348D8DC,0xE330734D,0x83325E97,0xE3926FAD,
0x831C314E,0xE3F47D96,0x83065110,0xE4569CCB,0x82F0BDE8,0xE4B8CD11,0x82DB77E5,
0xE51B0E2A,0x82C67F14,0xE57D5FDA,0x82B1D381,0xE5DFC1E5,0x829D753A,0xE642340D,
0x8289644B,0xE6A4B616,0x8275A0C0,0xE70747C4,0x82622AA6,0xE769E8D8,0x824F0208,
0xE7CC9917,0x823C26F3,0xE82F5844,0x82299971,0xE8922622,0x82175990,0xE8F50273,
0x82056758,0xE957ECFB,0x81F3C2D7,0xE9BAE57D,0x81E26C16,0xEA1DEBBB,0x81D16321,
0xEA80FF7A,0x81C0A801,0xEAE4207A,0x81B03AC2,0xEB474E81,0x81A01B6D,0xEBAA894F,
0x81904A0C,0xEC0DD0A8,0x8180C6A9,0xEC71244F,0x8171914E,0xECD48407,0x8162AA04,
0xED37EF91,0x815410D4,0xED9B66B2,0x8145C5C7,0xEDFEE92B,0x8137C8E6,0xEE6276BF,
0x812A1A3A,0xEEC60F31,0x811CB9CA,0xEF29B243,0x810FA7A0,0xEF8D5FB8,0x8102E3C4,
0xEFF11753,0x80F66E3C,0xF054D8D5,0x80EA4712,0xF0B8A401,0x80DE6E4C,0xF11C789A,
0x80D2E3F2,0xF1805662,0x80C7A80A,0xF1E43D1C,0x80BCBA9D,0xF2482C8A,0x80B21BAF,
0xF2AC246E,0x80A7CB49,0xF310248A,0x809DC971,0xF3742CA2,0x8094162C,0xF3D83C77,
0x808AB180,0xF43C53CB,0x80819B74,0xF4A07261,0x8078D40D,0xF50497FB,0x80705B50,
0xF568C45B,0x80683143,0xF5CCF743,0x806055EB,0xF6313077,0x8058C94C,0xF6956FB7,
0x80518B6B,0xF6F9B4C6,0x804A9C4D,0xF75DFF66,0x8043FBF6,0xF7C24F59,0x803DAA6A,
0xF826A462,0x8037A7AC,0xF88AFE42,0x8031F3C2,0xF8EF5CBB,0x802C8EAD,0xF953BF91,
0x80277872,0xF9B82684,0x8022B114,0xFA1C9157,0x801E3895,0xFA80FFCB,0x801A0EF8,
0xFAE571A4,0x80163440,0xFB49E6A3,0x8012A86F,0xFBAE5E89,0x800F6B88,0xFC12D91A,
0x800C7D8C,0xFC775616,0x8009DE7E,0xFCDBD541,0x80078E5E,0xFD40565C,0x80058D2F,
0xFDA4D929,0x8003DAF1,0xFE095D69,0x800277A6,0xFE6DE2E0,0x8001634E,0xFED2694F,
0x80009DEA,0xFF36F078,0x8000277A,0xFF9B781D,0x7FFFFFFF,0x00000000,0x7FFD885A,
0xFE6DE2E0,0x7FF62182,0xFCDBD541,0x7FE9CBC0,0xFB49E6A3,0x7FD8878E,0xF9B82684,
0x7FC25596,0xF826A462,0x7FA736B4,0xF6956FB7,0x7F872BF3,0xF50497FB,0x7F62368F,
0xF3742CA2,0x7F3857F6,0xF1E43D1C,0x7F0991C4,0xF054D8D5,0x7ED5E5C6,0xEEC60F31,
0x7E9D55FC,0xED37EF91,0x7E5FE493,0xEBAA894F,0x7E1D93EA,0xEA1DEBBB,0x7DD6668F,
0xE8922622,0x7D8A5F40,0xE70747C4,0x7D3980EC,0xE57D5FDA,0x7CE3CEB2,0xE3F47D96,
0x7C894BDE,0xE26CB01B,0x7C29FBEE,0xE0E60685,0x7BC5E290,0xDF608FE4,0x7B5D039E,
0xDDDC5B3B,0x7AEF6323,0xDC597781,0x7A7D055B,0xDAD7F3A2,0x7A05EEAD,0xD957DE7A,
0x798A23B1,0xD7D946D8,0x7909A92D,0xD65C3B7B,0x78848414,0xD4E0CB15,0x77FAB989,
0xD3670446,0x776C4EDB,0xD1EEF59E,0x76D94989,0xD078AD9E,0x7641AF3D,0xCF043AB3,
0x75A585CF,0xCD91AB39,0x7504D345,0xCC210D79,0x745F9DD1,0xCAB26FA9,0x73B5EBD1,
0xC945DFEC,0x7307C3D0,0xC7DB6C50,0x72552C85,0xC67322CE,0x719E2CD2,0xC50D1149,
0x70E2CBC6,0xC3A94590,0x7023109A,0xC247CD5A,0x6F5F02B2,0xC0E8B648,0x6E96A99D,
0xBF8C0DE3,0x6DCA0D14,0xBE31E19B,0x6CF934FC,0xBCDA3ECB,0x6C242960,0xBB8532B0,
0x6B4AF279,0xBA32CA71,0x6A6D98A4,0xB8E31319,0x698C246C,0xB796199B,0x68A69E81,
0xB64BEACD,0x67BD0FBD,0xB5049368,0x66CF8120,0xB3C0200C,0x65DDFBD3,0xB27E9D3C,
0x64E88926,0xB140175B,0x63EF3290,0xB0049AB3,0x62F201AC,0xAECC336C,0x61F1003F,
0xAD96ED92,0x60EC3830,0xAC64D510,0x5FE3B38D,0xAB35F5B5,0x5ED77C8A,0xAA0A5B2E,
0x5DC79D7C,0xA8E21106,0x5CB420E0,0xA7BD22AC,0x5B9D1154,0xA69B9B68,0x5A82799A,
0xA57D8666,0x59646498,0xA462EEAC,0x5842DD54,0xA34BDF20,0x571DEEFA,0xA2386284,
0x55F5A4D2,0xA1288376,0x54CA0A4B,0xA01C4C73,0x539B2AF0,0x9F13C7D0,0x5269126E,
0x9E0EFFC1,0x5133CC94,0x9D0DFE54,0x4FFB654D,0x9C10CD70,0x4EBFE8A5,0x9B1776DA,
0x4D8162C4,0x9A22042D,0x4C3FDFF4,0x99307EE0,0x4AFB6C98,0x9842F043,0x49B41533,
0x9759617F,0x4869E665,0x9673DB94,0x471CECE7,0x9592675C,0x45CD358F,0x94B50D87,
0x447ACD50,0x93DBD6A0,0x4325C135,0x9306CB04,0x41CE1E65,0x9235F2EC,0x4073F21D,
0x91695663,0x3F1749B8,0x90A0FD4E,0x3DB832A6,0x8FDCEF66,0x3C56BA70,0x8F1D343A,
0x3AF2EEB7,0x8E61D32E,0x398CDD32,0x8DAAD37B,0x382493B0,0x8CF83C30,0x36BA2014,
0x8C4A142F,0x354D9057,0x8BA0622F,0x33DEF287,0x8AFB2CBB,0x326E54C7,0x8A5A7A31,
0x30FBC54D,0x89BE50C3,0x2F875262,0x8926B677,0x2E110A62,0x8893B125,0x2C98FBBA,
0x88054677,0x2B1F34EB,0x877B7BEC,0x29A3C485,0x86F656D3,0x2826B928,0x8675DC4F,
0x26A82186,0x85FA1153,0x25280C5E,0x8582FAA5,0x23A6887F,0x85109CDD,0x2223A4C5,
0x84A2FC62,0x209F701C,0x843A1D70,0x1F19F97B,0x83D60412,0x1D934FE5,0x8376B422,
0x1C0B826A,0x831C314E,0x1A82A026,0x82C67F14,0x18F8B83C,0x8275A0C0,0x176DD9DE,
0x82299971,0x15E21445,0x81E26C16,0x145576B1,0x81A01B6D,0x12C8106F,0x8162AA04,
0x1139F0CF,0x812A1A3A,0x0FAB272B,0x80F66E3C,0x0E1BC2E4,0x80C7A80A,0x0C8BD35E,
0x809DC971,0x0AFB6805,0x8078D40D,0x096A9049,0x8058C94C,0x07D95B9E,0x803DAA6A,
0x0647D97C,0x80277872,0x04B6195D,0x80163440,0x03242ABF,0x8009DE7E,0x01921D20,
0x800277A6,0x00000000,0x80000000,0xFE6DE2E0,0x800277A6,0xFCDBD541,0x8009DE7E,
0xFB49E6A3,0x80163440,0xF9B82684,0x80277872,0xF826A462,0x803DAA6A,0xF6956FB7,
0x8058C94C,0xF50497FB,0x8078D40D,0xF3742CA2,0x809DC971,0xF1E43D1C,0x80C7A80A,
0xF054D8D5,0x80F66E3C,0xEEC60F31,0x812A1A3A,0xED37EF91,0x8162AA04,0xEBAA894F,
0x81A01B6D,0xEA1DEBBB,0x81E26C16,0xE8922622,0x82299971,0xE70747C4,0x8275A0C0,
0xE57D5FDA,0x82C67F14,0xE3F47D96,0x831C314E,0xE26CB01B,0x8376B422,0xE0E60685,
0x83D60412,0xDF608FE4,0x843A1D70,0xDDDC5B3B,0x84A2FC62,0xDC597781,0x85109CDD,
0xDAD7F3A2,0x8582FAA5,0xD957DE7A,0x85FA1153,0xD7D946D8,0x8675DC4F,0xD65C3B7B,
0x86F656D3,0xD4E0CB15,0x877B7BEC,0xD3670446,0x88054677,0xD1EEF59E,0x8893B125,
0xD078AD9E,0x8926B677,0xCF043AB3,0x89BE50C3,0xCD91AB39,0x8A5A7A31,0xCC210D79,
0x8AFB2CBB,0xCAB26FA9,0x8BA0622F,0xC945DFEC,0x8C4A142F,0xC7DB6C50,0x8CF83C30,
0xC67322CE,0x8DAAD37B,0xC50D1149,0x8E61D32E,0xC3A94590,0x8F1D343A,0xC247CD5A,
0x8FDCEF66,0xC0E8B648,0x90A0FD4E,0xBF8C0DE3,0x91695663,0xBE31E19B,0x9235F2EC,
0xBCDA3ECB,0x9306CB04,0xBB8532B0,0x93DBD6A0,0xBA32CA71,0x94B50D87,0xB8E31319,
0x9592675C,0xB796199B,0x9673DB94,0xB64BEACD,0x9759617F,0xB5049368,0x9842F043,
0xB3C0200C,0x99307EE0,0xB27E9D3C,0x9A22042D,0xB140175B,0x9B1776DA,0xB0049AB3,
0x9C10CD70,0xAECC336C,0x9D0DFE54,0xAD96ED92,0x9E0EFFC1,0xAC64D510,0x9F13C7D0,
0xAB35F5B5,0xA01C4C73,0xAA0A5B2E,0xA1288376,0xA8E21106,0xA2386284,0xA7BD22AC,
0xA34BDF20,0xA69B9B68,0xA462EEAC,0xA57D8666,0xA57D8666,0xA462EEAC,0xA69B9B68,
0xA34BDF20,0xA7BD22AC,0xA2386284,0xA8E21106,0xA1288376,0xAA0A5B2E,0xA01C4C73,
0xAB35F5B5,0x9F13C7D0,0xAC64D510,0x9E0EFFC1,0xAD96ED92,0x9D0DFE54,0xAECC336C,
0x9C10CD70,0xB0049AB3,0x9B1776DA,0xB140175B,0x9A22042D,0xB27E9D3C,0x99307EE0,
0xB3C0200C,0x9842F043,0xB5049368,0x9759617F,0xB64BEACD,0x9673DB94,0xB796199B,
0x9592675C,0xB8E31319,0x94B50D87,0xBA32CA71,0x93DBD6A0,0xBB8532B0,0x9306CB04,
0xBCDA3ECB,0x9235F2EC,0xBE31E19B,0x91695663,0xBF8C0DE3,0x90A0FD4E,0xC0E8B648,
0x8FDCEF66,0xC247CD5A,0x8F1D343A,0xC3A94590,0x8E61D32E,0xC50D1149,0x8DAAD37B,
0xC67322CE,0x8CF83C30,0xC7DB6C50,0x8C4A142F,0xC945DFEC,0x8BA0622F,0xCAB26FA9,
0x8AFB2CBB,0xCC210D79,0x8A5A7A31,0xCD91AB39,0x89BE50C3,0xCF043AB3,0x8926B677,
0xD078AD9E,0x8893B125,0xD1EEF59E,0x88054677,0xD3670446,0x877B7BEC,0xD4E0CB15,
0x86F656D3,0xD65C3B7B,0x8675DC4F,0xD7D946D8,0x85FA1153,0xD957DE7A,0x8582FAA5,
0xDAD7F3A2,0x85109CDD,0xDC597781,0x84A2FC62,0xDDDC5B3B,0x843A1D70,0xDF608FE4,
0x83D60412,0xE0E60685,0x8376B422,0xE26CB01B,0x831C314E,0xE3F47D96,0x82C67F14,
0xE57D5FDA,0x8275A0C0,0xE70747C4,0x82299971,0xE8922622,0x81E26C16,0xEA1DEBBB,
0x81A01B6D,0xEBAA894F,0x8162AA04,0xED37EF91,0x812A1A3A,0xEEC60F31,0x80F66E3C,
0xF054D8D5,0x80C7A80A,0xF1E43D1C,0x809DC971,0xF3742CA2,0x8078D40D,0xF50497FB,
0x8058C94C,0xF6956FB7,0x803DAA6A,0xF826A462,0x80277872,0xF9B82684,0x80163440,
0xFB49E6A3,0x8009DE7E,0xFCDBD541,0x800277A6,0xFE6DE2E0,0x7FFFFFFF,0x00000000,
0x7FD8878E,0xF9B82684,0x7F62368F,0xF3742CA2,0x7E9D55FC,0xED37EF91,0x7D8A5F40,
0xE70747C4,0x7C29FBEE,0xE0E60685,0x7A7D055B,0xDAD7F3A2,0x78848414,0xD4E0CB15,
0x7641AF3D,0xCF043AB3,0x73B5EBD1,0xC945DFEC,0x70E2CBC6,0xC3A94590,0x6DCA0D14,
0xBE31E19B,0x6A6D98A4,0xB8E31319,0x66CF8120,0xB3C0200C,0x62F201AC,0xAECC336C,
0x5ED77C8A,0xAA0A5B2E,0x5A82799A,0xA57D8666,0x55F5A4D2,0xA1288376,0x5133CC94,
0x9D0DFE54,0x4C3FDFF4,0x99307EE0,0x471CECE7,0x9592675C,0x41CE1E65,0x9235F2EC,
0x3C56BA70,0x8F1D343A,0x36BA2014,0x8C4A142F,0x30FBC54D,0x89BE50C3,0x2B1F34EB,
0x877B7BEC,0x25280C5E,0x8582FAA5,0x1F19F97B,0x83D60412,0x18F8B83C,0x8275A0C0,
0x12C8106F,0x8162AA04,0x0C8BD35E,0x809DC971,0x0647D97C,0x80277872,0x00000000,
0x80000000,0xF9B82684,0x80277872,0xF3742CA2,0x809DC971,0xED37EF91,0x8162AA04,
0xE70747C4,0x8275A0C0,0xE0E60685,0x83D60412,0xDAD7F3A2,0x8582FAA5,0xD4E0CB15,
0x877B7BEC,0xCF043AB3,0x89BE50C3,0xC945DFEC,0x8C4A142F,0xC3A94590,0x8F1D343A,
0xBE31E19B,0x9235F2EC,0xB8E31319,0x9592675C,0xB3C0200C,0x99307EE0,0xAECC336C,
0x9D0DFE54,0xAA0A5B2E,0xA1288376,0xA57D8666,0xA57D8666,0xA1288376,0xAA0A5B2E,
0x9D0DFE54,0xAECC336C,0x99307EE0,0xB3C0200C,0x9592675C,0xB8E31319,0x9235F2EC,
0xBE31E19B,0x8F1D343A,0xC3A94590,0x8C4A142F,0xC945DFEC,0x89BE50C3,0xCF043AB3,
0x877B7BEC,0xD4E0CB15,0x8582FAA5,0xDAD7F3A2,0x83D60412,0xE0E60685,0x8275A0C0,
0xE70747C4,0x8162AA04,0xED37EF91,0x809DC971,0xF3742CA2,0x80277872,0xF9B82684,
0x7FFFFFFF,0x00000000,0x7D8A5F40,0xE70747C4,0x7641AF3D,0xCF043AB3,0x6A6D98A4,
0xB8E31319,0x5A82799A,0xA57D8666,0x471CECE7,0x9592675C,0x30FBC54D,0x89BE50C3,
0x18F8B83C,0x8275A0C0,0x00000000,0x80000000,0xE70747C4,0x8275A0C0,0xCF043AB3,
0x89BE50C3,0xB8E31319,0x9592675C,0xA57D8666,0xA57D8666,0x9592675C,0xB8E31319,
0x89BE50C3,0xCF043AB3,0x8275A0C0,0xE70747C4,0x7FFFFFFF,0x00000000,0x5A82799A,
0xA57D8666,0x00000000,0x80000000,0xA57D8666,0xA57D8666,};

q31_t rearranged_twiddle_stride3_4096_q31[2728]={
0x7FFFFFFF,0x00000000,0x7FFFA72C,0xFF69343F,0x7FFE9CB2,0xFED2694F,0x7FFCE093,
0xFE3BA002,0x7FFA72D1,0xFDA4D929,0x7FF75370,0xFD0E1594,0x7FF38274,0xFC775616,
0x7FEEFFE1,0xFBE09B80,0x7FE9CBC0,0xFB49E6A3,0x7FE3E616,0xFAB3384F,0x7FDD4EEC,
0xFA1C9157,0x7FD6064C,0xF985F28A,0x7FCE0C3E,0xF8EF5CBB,0x7FC560CF,0xF858D0BB,
0x7FBC040A,0xF7C24F59,0x7FB1F5FC,0xF72BD967,0x7FA736B4,0xF6956FB7,0x7F9BC640,
0xF5FF1318,0x7F8FA4B0,0xF568C45B,0x7F82D214,0xF4D28451,0x7F754E80,0xF43C53CB,
0x7F671A05,0xF3A63398,0x7F5834B7,0xF310248A,0x7F489EAA,0xF27A2771,0x7F3857F6,
0xF1E43D1C,0x7F2760AF,0xF14E665C,0x7F15B8EE,0xF0B8A401,0x7F0360CB,0xF022F6DA,
0x7EF05860,0xEF8D5FB8,0x7EDC9FC6,0xEEF7DF6A,0x7EC8371A,0xEE6276BF,0x7EB31E78,
0xEDCD2687,0x7E9D55FC,0xED37EF91,0x7E86DDC6,0xECA2D2AD,0x7E6FB5F4,0xEC0DD0A8,
0x7E57DEA7,0xEB78EA52,0x7E3F57FF,0xEAE4207A,0x7E26221F,0xEA4F73EE,0x7E0C3D29,
0xE9BAE57D,0x7DF1A942,0xE92675F4,0x7DD6668F,0xE8922622,0x7DBA7534,0xE7FDF6D4,
0x7D9DD55A,0xE769E8D8,0x7D808728,0xE6D5FCFC,0x7D628AC6,0xE642340D,0x7D43E05E,
0xE5AE8ED8,0x7D24881B,0xE51B0E2A,0x7D048228,0xE487B2D0,0x7CE3CEB2,0xE3F47D96,
0x7CC26DE5,0xE3616F48,0x7CA05FF1,0xE2CE88B3,0x7C7DA505,0xE23BCAA2,0x7C5A3D50,
0xE1A935E2,0x7C362904,0xE116CB3D,0x7C116853,0xE0848B7F,0x7BEBFB70,0xDFF27773,
0x7BC5E290,0xDF608FE4,0x7B9F1DE6,0xDECED59B,0x7B77ADA8,0xDE3D4964,0x7B4F920E,
0xDDABEC08,0x7B26CB4F,0xDD1ABE51,0x7AFD59A4,0xDC89C109,0x7AD33D45,0xDBF8F4F8,
0x7AA8766F,0xDB685AE9,0x7A7D055B,0xDAD7F3A2,0x7A50EA47,0xDA47BFEE,0x7A24256F,
0xD9B7C094,0x79F6B711,0xD927F65B,0x79C89F6E,0xD898620C,0x7999DEC4,0xD809046E,
0x796A7554,0xD779DE47,0x793A6361,0xD6EAF05F,0x7909A92D,0xD65C3B7B,0x78D846FB,
0xD5CDC062,0x78A63D11,0xD53F7FDA,0x78738BB3,0xD4B17AA8,0x78403329,0xD423B191,
0x780C33B8,0xD396255A,0x77D78DAA,0xD308D6C7,0x77A24148,0xD27BC69C,0x776C4EDB,
0xD1EEF59E,0x7735B6AF,0xD1626490,0x76FE790E,0xD0D61434,0x76C69647,0xD04A054E,
0x768E0EA6,0xCFBE389F,0x7654E279,0xCF32AEEB,0x761B1211,0xCEA768F2,0x75E09DBD,
0xCE1C6777,0x75A585CF,0xCD91AB39,0x7569CA99,0xCD0734F9,0x752D6C6C,0xCC7D0578,
0x74F06B9E,0xCBF31D75,0x74B2C884,0xCB697DB0,0x74748371,0xCAE026E8,0x74359CBD,
0xCA5719DB,0x73F614C0,0xC9CE5748,0x73B5EBD1,0xC945DFEC,0x73752249,0xC8BDB485,
0x7333B883,0xC835D5D0,0x72F1AED9,0xC7AE4489,0x72AF05A7,0xC727016D,0x726BBD48,
0xC6A00D37,0x7227D61C,0xC61968A2,0x71E35080,0xC593146A,0x719E2CD2,0xC50D1149,
0x71586B74,0xC4875FF9,0x71120CC5,0xC4020133,0x70CB1128,0xC37CF5B0,0x708378FF,
0xC2F83E2A,0x703B44AD,0xC273DB58,0x6FF27497,0xC1EFCDF3,0x6FA90921,0xC16C16B0,
0x6F5F02B2,0xC0E8B648,0x6F1461B0,0xC065AD70,0x6EC92683,0xBFE2FCDF,0x6E7D5193,
0xBF60A54A,0x6E30E34A,0xBEDEA765,0x6DE3DC11,0xBE5D03E6,0x6D963C54,0xBDDBBB7F,
0x6D48047E,0xBD5ACEE5,0x6CF934FC,0xBCDA3ECB,0x6CA9CE3B,0xBC5A0BE2,0x6C59D0A9,
0xBBDA36DD,0x6C093CB6,0xBB5AC06D,0x6BB812D1,0xBADBA943,0x6B66536B,0xBA5CF210,
0x6B13FEF5,0xB9DE9B83,0x6AC115E2,0xB960A64C,0x6A6D98A4,0xB8E31319,0x6A1987B0,
0xB865E299,0x69C4E37A,0xB7E9157A,0x696FAC78,0xB76CAC69,0x6919E320,0xB6F0A812,
0x68C387E9,0xB6750921,0x686C9B4B,0xB5F9D043,0x68151DBE,0xB57EFE22,0x67BD0FBD,
0xB5049368,0x676471C0,0xB48A90C0,0x670B4444,0xB410F6D3,0x66B187C3,0xB397C649,
0x66573CBB,0xB31EFFCC,0x65FC63A9,0xB2A6A402,0x65A0FD0B,0xB22EB392,0x6545095F,
0xB1B72F23,0x64E88926,0xB140175B,0x648B7CE0,0xB0C96CE0,0x642DE50D,0xB0533055,
0x63CFC231,0xAFDD625F,0x637114CC,0xAF6803A2,0x6311DD64,0xAEF314C0,0x62B21C7B,
0xAE7E965B,0x6251D298,0xAE0A8916,0x61F1003F,0xAD96ED92,0x618FA5F7,0xAD23C46E,
0x612DC447,0xACB10E4B,0x60CB5BB7,0xAC3ECBC7,0x60686CCF,0xABCCFD83,0x6004F819,
0xAB5BA41A,0x5FA0FE1F,0xAAEAC02C,0x5F3C7F6B,0xAA7A5253,0x5ED77C8A,0xAA0A5B2E,
0x5E71F606,0xA99ADB56,0x5E0BEC6E,0xA92BD367,0x5DA5604F,0xA8BD43FA,0x5D3E5237,
0xA84F2DAA,0x5CD6C2B5,0xA7E1910F,0x5C6EB258,0xA7746EC0,0x5C0621B2,0xA707C757,
0x5B9D1154,0xA69B9B68,0x5B3381CE,0xA62FEB8B,0x5AC973B5,0xA5C4B855,0x5A5EE79A,
0xA55A025B,0x59F3DE12,0xA4EFCA31,0x598857B2,0xA486106A,0x591C550E,0xA41CD599,
0x58AFD6BD,0xA3B41A50,0x5842DD54,0xA34BDF20,0x57D5696D,0xA2E4249B,0x57677B9D,
0xA27CEB4F,0x56F9147E,0xA21633CD,0x568A34A9,0xA1AFFEA3,0x561ADCB9,0xA14A4C5E,
0x55AB0D46,0xA0E51D8C,0x553AC6EE,0xA08072BA,0x54CA0A4B,0xA01C4C73,0x5458D7F9,
0x9FB8AB41,0x53E73097,0x9F558FB0,0x537514C2,0x9EF2FA49,0x53028518,0x9E90EB94,
0x528F8238,0x9E2F641B,0x521C0CC2,0x9DCE6463,0x51A82555,0x9D6DECF4,0x5133CC94,
0x9D0DFE54,0x50BF031F,0x9CAE9907,0x5049C999,0x9C4FBD93,0x4FD420A4,0x9BF16C7A,
0x4F5E08E3,0x9B93A641,0x4EE782FB,0x9B366B68,0x4E708F8F,0x9AD9BC71,0x4DF92F46,
0x9A7D99DE,0x4D8162C4,0x9A22042D,0x4D092AB0,0x99C6FBDE,0x4C9087B1,0x996C816F,
0x4C177A6E,0x9912955F,0x4B9E0390,0x98B93828,0x4B2423BE,0x98606A49,0x4AA9DBA2,
0x98082C3B,0x4A2F2BE6,0x97B07E7A,0x49B41533,0x9759617F,0x49389836,0x9702D5C3,
0x48BCB599,0x96ACDBBE,0x48406E08,0x965773E7,0x47C3C22F,0x96029EB6,0x4746B2BC,
0x95AE5C9F,0x46C9405C,0x955AAE17,0x464B6BBE,0x95079394,0x45CD358F,0x94B50D87,
0x454E9E80,0x94631C65,0x44CFA740,0x9411C09E,0x4450507E,0x93C0FAA3,0x43D09AED,
0x9370CAE4,0x4350873C,0x932131D1,0x42D0161E,0x92D22FD9,0x424F4845,0x9283C568,
0x41CE1E65,0x9235F2EC,0x414C992F,0x91E8B8D0,0x40CAB958,0x919C1781,0x40487F94,
0x91500F67,0x3FC5EC98,0x9104A0EE,0x3F430119,0x90B9CC7D,0x3EBFBDCD,0x906F927C,
0x3E3C2369,0x9025F352,0x3DB832A6,0x8FDCEF66,0x3D33EC39,0x8F94871D,0x3CAF50DA,
0x8F4CBADB,0x3C2A6142,0x8F058B04,0x3BA51E29,0x8EBEF7FB,0x3B1F8848,0x8E790222,
0x3A99A057,0x8E33A9DA,0x3A136712,0x8DEEEF82,0x398CDD32,0x8DAAD37B,0x39060373,
0x8D675623,0x387EDA8E,0x8D2477D8,0x37F76341,0x8CE238F6,0x376F9E46,0x8CA099DA,
0x36E78C5B,0x8C5F9ADE,0x365F2E3B,0x8C1F3C5D,0x35D684A6,0x8BDF7EB0,0x354D9057,
0x8BA0622F,0x34C4520D,0x8B61E733,0x343ACA87,0x8B240E11,0x33B0FA84,0x8AE6D720,
0x3326E2C3,0x8AAA42B4,0x329C8402,0x8A6E5123,0x3211DF04,0x8A3302BE,0x3186F487,
0x89F857D8,0x30FBC54D,0x89BE50C3,0x30705217,0x8984EDCF,0x2FE49BA7,0x894C2F4C,
0x2F58A2BE,0x89141589,0x2ECC681E,0x88DCA0D3,0x2E3FEC8B,0x88A5D177,0x2DB330C7,
0x886FA7C2,0x2D263596,0x883A23FF,0x2C98FBBA,0x88054677,0x2C0B83FA,0x87D10F75,
0x2B7DCF17,0x879D7F41,0x2AEFDDD8,0x876A9621,0x2A61B101,0x8738545E,0x29D34958,
0x8706BA3D,0x2944A7A2,0x86D5C802,0x28B5CCA5,0x86A57DF2,0x2826B928,0x8675DC4F,
0x27976DF1,0x8646E35C,0x2707EBC7,0x86189359,0x26783370,0x85EAEC88,0x25E845B6,
0x85BDEF28,0x2558235F,0x85919B76,0x24C7CD33,0x8565F1B0,0x243743FA,0x853AF214,
0x23A6887F,0x85109CDD,0x23159B88,0x84E6F244,0x22847DE0,0x84BDF286,0x21F3304F,
0x84959DD9,0x2161B3A0,0x846DF477,0x20D0089C,0x8446F695,0x203E300D,0x8420A46C,
0x1FAC2ABF,0x83FAFE2E,0x1F19F97B,0x83D60412,0x1E879D0D,0x83B1B649,0x1DF5163F,
0x838E1507,0x1D6265DD,0x836B207D,0x1CCF8CB3,0x8348D8DC,0x1C3C8B8C,0x83273E52,
0x1BA96335,0x83065110,0x1B161479,0x82E61141,0x1A82A026,0x82C67F14,0x19EF0707,
0x82A79AB3,0x195B49EA,0x8289644B,0x18C7699B,0x826BDC04,0x183366E9,0x824F0208,
0x179F429F,0x8232D67F,0x170AFD8D,0x82175990,0x1676987F,0x81FC8B60,0x15E21445,
0x81E26C16,0x154D71AA,0x81C8FBD6,0x14B8B17F,0x81B03AC2,0x1423D492,0x819828FD,
0x138EDBB1,0x8180C6A9,0x12F9C7AA,0x816A13E6,0x1264994E,0x815410D4,0x11CF516A,
0x813EBD90,0x1139F0CF,0x812A1A3A,0x10A4784B,0x811626EC,0x100EE8AD,0x8102E3C4,
0x0F7942C7,0x80F050DB,0x0EE38766,0x80DE6E4C,0x0E4DB75B,0x80CD3C2F,0x0DB7D376,
0x80BCBA9D,0x0D21DC87,0x80ACE9AB,0x0C8BD35E,0x809DC971,0x0BF5B8CB,0x808F5A02,
0x0B5F8D9F,0x80819B74,0x0AC952AA,0x80748DD9,0x0A3308BD,0x80683143,0x099CB0A7,
0x805C85C4,0x09064B3A,0x80518B6B,0x086FD947,0x80474248,0x07D95B9E,0x803DAA6A,
0x0742D311,0x8034C3DD,0x06AC406F,0x802C8EAD,0x0615A48B,0x80250AE7,0x057F0035,
0x801E3895,0x04E8543E,0x801817BF,0x0451A177,0x8012A86F,0x03BAE8B2,0x800DEAAD,
0x03242ABF,0x8009DE7E,0x028D6870,0x800683E8,0x01F6A297,0x8003DAF1,0x015FDA03,
0x8001E39B,0x00C90F88,0x80009DEA,0x003243F5,0x800009DF,0xFF9B781D,0x8000277A,
0xFF04ACD0,0x8000F6BD,0xFE6DE2E0,0x800277A6,0xFDD71B1E,0x8004AA32,0xFD40565C,
0x80078E5E,0xFCA9956A,0x800B2427,0xFC12D91A,0x800F6B88,0xFB7C223D,0x8014647B,
0xFAE571A4,0x801A0EF8,0xFA4EC821,0x80206AF8,0xF9B82684,0x80277872,0xF9218D9E,
0x802F375D,0xF88AFE42,0x8037A7AC,0xF7F4793E,0x8040C956,0xF75DFF66,0x804A9C4D,
0xF6C79188,0x80552084,0xF6313077,0x806055EB,0xF59ADD02,0x806C3C74,0xF50497FB,
0x8078D40D,0xF46E6231,0x80861CA6,0xF3D83C77,0x8094162C,0xF342279B,0x80A2C08B,
0xF2AC246E,0x80B21BAF,0xF21633C0,0x80C22784,0xF1805662,0x80D2E3F2,0xF0EA8D24,
0x80E450E2,0xF054D8D5,0x80F66E3C,0xEFBF3A45,0x81093BE8,0xEF29B243,0x811CB9CA,
0xEE9441A0,0x8130E7C9,0xEDFEE92B,0x8145C5C7,0xED69A9B3,0x815B53A8,0xECD48407,
0x8171914E,0xEC3F78F6,0x81887E9A,0xEBAA894F,0x81A01B6D,0xEB15B5E1,0x81B867A5,
0xEA80FF7A,0x81D16321,0xE9EC66E8,0x81EB0DBE,0xE957ECFB,0x82056758,0xE8C39280,
0x82206FCC,0xE82F5844,0x823C26F3,0xE79B3F16,0x82588CA7,0xE70747C4,0x8275A0C0,
0xE6737319,0x82936317,0xE5DFC1E5,0x82B1D381,0xE54C34F3,0x82D0F1D5,0xE4B8CD11,
0x82F0BDE8,0xE4258B0A,0x8311378D,0xE3926FAD,0x83325E97,0xE2FF7BC3,0x835432D8,
0xE26CB01B,0x8376B422,0xE1DA0D7E,0x8399E244,0xE14794BA,0x83BDBD0E,0xE0B54698,
0x83E2444D,0xE02323E5,0x840777D0,0xDF912D6B,0x842D5762,0xDEFF63F4,0x8453E2CF,
0xDE6DC84B,0x847B19E1,0xDDDC5B3B,0x84A2FC62,0xDD4B1D8C,0x84CB8A1B,0xDCBA1008,
0x84F4C2D4,0xDC293379,0x851EA652,0xDB9888A8,0x8549345C,0xDB08105E,0x85746CB8,
0xDA77CB63,0x85A04F28,0xD9E7BA7F,0x85CCDB70,0xD957DE7A,0x85FA1153,0xD8C8381D,
0x8627F091,0xD838C82D,0x865678EB,0xD7A98F73,0x8685AA20,0xD71A8EB5,0x86B583EE,
0xD68BC6BA,0x86E60614,0xD5FD3848,0x8717304E,0xD56EE424,0x87490258,0xD4E0CB15,
0x877B7BEC,0xD452EDDF,0x87AE9CC5,0xD3C54D47,0x87E2649B,0xD337EA12,0x8816D327,
0xD2AAC504,0x884BE821,0xD21DDEE2,0x8881A33D,0xD191386E,0x88B80432,0xD104D26B,
0x88EF0AB4,0xD078AD9E,0x8926B677,0xCFECCAC7,0x895F072E,0xCF612AAA,0x8997FC8A,
0xCED5CE08,0x89D1963C,0xCE4AB5A2,0x8A0BD3F5,0xCDBFE23A,0x8A46B564,0xCD355491,
0x8A823A36,0xCCAB0D65,0x8ABE6219,0xCC210D79,0x8AFB2CBB,0xCB97558A,0x8B3899C6,
0xCB0DE658,0x8B76A8E4,0xCA84C0A3,0x8BB559C1,0xC9FBE527,0x8BF4AC05,0xC97354A4,
0x8C349F58,0xC8EB0FD6,0x8C753362,0xC863177B,0x8CB667C8,0xC7DB6C50,0x8CF83C30,
0xC7540F11,0x8D3AB03F,0xC6CD0079,0x8D7DC399,0xC6464144,0x8DC175E0,0xC5BFD22E,
0x8E05C6B7,0xC539B3F1,0x8E4AB5BF,0xC4B3E746,0x8E904298,0xC42E6CE8,0x8ED66CE1,
0xC3A94590,0x8F1D343A,0xC32471F7,0x8F649840,0xC29FF2D4,0x8FAC988F,0xC21BC8E1,
0x8FF534C4,0xC197F4D4,0x903E6C7B,0xC1147764,0x90883F4D,0xC0915148,0x90D2ACD4,
0xC00E8336,0x911DB4A9,0xBF8C0DE3,0x91695663,0xBF09F205,0x91B5919A,0xBE88304F,
0x920265E4,0xBE06C977,0x924FD2D7,0xBD85BE30,0x929DD806,0xBD050F2C,0x92EC7505,
0xBC84BD1F,0x933BA968,0xBC04C8BA,0x938B74C1,0xBB8532B0,0x93DBD6A0,0xBB05FBB0,
0x942CCE96,0xBA87246D,0x947E5C33,0xBA08AD95,0x94D07F05,0xB98A97D8,0x9523369C,
0xB90CE3E6,0x95768283,0xB88F926D,0x95CA6247,0xB812A41A,0x961ED574,0xB796199B,
0x9673DB94,0xB719F39E,0x96C97432,0xB69E32CD,0x971F9ED7,0xB622D7D6,0x97765B0A,
0xB5A7E362,0x97CDA855,0xB52D561E,0x9825863D,0xB4B330B3,0x987DF449,0xB43973CA,
0x98D6F1FE,0xB3C0200C,0x99307EE0,0xB3473623,0x998A9A74,0xB2CEB6B5,0x99E5443B,
0xB256A26A,0x9A407BB9,0xB1DEF9E9,0x9A9C406E,0xB167BDD7,0x9AF891DB,0xB0F0EEDA,
0x9B556F81,0xB07A8D97,0x9BB2D8DE,0xB0049AB3,0x9C10CD70,0xAF8F16D1,0x9C6F4CB6,
0xAF1A0293,0x9CCE562C,0xAEA55E9E,0x9D2DE94D,0xAE312B92,0x9D8E0597,0xADBD6A10,
0x9DEEAA82,0xAD4A1ABA,0x9E4FD78A,0xACD73E30,0x9EB18C26,0xAC64D510,0x9F13C7D0,
0xABF2DFFB,0x9F7689FF,0xAB815F8D,0x9FD9D22A,0xAB105464,0xA03D9FC8,0xAA9FBF1E,
0xA0A1F24D,0xAA2FA056,0xA106C92F,0xA9BFF8A8,0xA16C23E1,0xA950C8B0,0xA1D201D7,
0xA8E21106,0xA2386284,0xA873D246,0xA29F4559,0xA8060D08,0xA306A9C8,0xA798C1E5,
0xA36E8F41,0xA72BF174,0xA3D6F534,0xA6BF9C4B,0xA43FDB10,0xA653C303,0xA4A94043,
0xA5E8662F,0xA513243B,0xA57D8666,0xA57D8666,0xA513243B,0xA5E8662F,0xA4A94043,
0xA653C303,0xA43FDB10,0xA6BF9C4B,0xA3D6F534,0xA72BF174,0xA36E8F41,0xA798C1E5,
0xA306A9C8,0xA8060D08,0xA29F4559,0xA873D246,0xA2386284,0xA8E21106,0xA1D201D7,
0xA950C8B0,0xA16C23E1,0xA9BFF8A8,0xA106C92F,0xAA2FA056,0xA0A1F24D,0xAA9FBF1E,
0xA03D9FC8,0xAB105464,0x9FD9D22A,0xAB815F8D,0x9F7689FF,0xABF2DFFB,0x9F13C7D0,
0xAC64D510,0x9EB18C26,0xACD73E30,0x9E4FD78A,0xAD4A1ABA,0x9DEEAA82,0xADBD6A10,
0x9D8E0597,0xAE312B92,0x9D2DE94D,0xAEA55E9E,0x9CCE562C,0xAF1A0293,0x9C6F4CB6,
0xAF8F16D1,0x9C10CD70,0xB0049AB3,0x9BB2D8DE,0xB07A8D97,0x9B556F81,0xB0F0EEDA,
0x9AF891DB,0xB167BDD7,0x9A9C406E,0xB1DEF9E9,0x9A407BB9,0xB256A26A,0x99E5443B,
0xB2CEB6B5,0x998A9A74,0xB3473623,0x99307EE0,0xB3C0200C,0x98D6F1FE,0xB43973CA,
0x987DF449,0xB4B330B3,0x9825863D,0xB52D561E,0x97CDA855,0xB5A7E362,0x97765B0A,
0xB622D7D6,0x971F9ED7,0xB69E32CD,0x96C97432,0xB719F39E,0x9673DB94,0xB796199B,
0x961ED574,0xB812A41A,0x95CA6247,0xB88F926D,0x95768283,0xB90CE3E6,0x9523369C,
0xB98A97D8,0x94D07F05,0xBA08AD95,0x947E5C33,0xBA87246D,0x942CCE96,0xBB05FBB0,
0x93DBD6A0,0xBB8532B0,0x938B74C1,0xBC04C8BA,0x933BA968,0xBC84BD1F,0x92EC7505,
0xBD050F2C,0x929DD806,0xBD85BE30,0x924FD2D7,0xBE06C977,0x920265E4,0xBE88304F,
0x91B5919A,0xBF09F205,0x91695663,0xBF8C0DE3,0x911DB4A9,0xC00E8336,0x90D2ACD4,
0xC0915148,0x90883F4D,0xC1147764,0x903E6C7B,0xC197F4D4,0x8FF534C4,0xC21BC8E1,
0x8FAC988F,0xC29FF2D4,0x8F649840,0xC32471F7,0x8F1D343A,0xC3A94590,0x8ED66CE1,
0xC42E6CE8,0x8E904298,0xC4B3E746,0x8E4AB5BF,0xC539B3F1,0x8E05C6B7,0xC5BFD22E,
0x8DC175E0,0xC6464144,0x8D7DC399,0xC6CD0079,0x8D3AB03F,0xC7540F11,0x8CF83C30,
0xC7DB6C50,0x8CB667C8,0xC863177B,0x8C753362,0xC8EB0FD6,0x8C349F58,0xC97354A4,
0x8BF4AC05,0xC9FBE527,0x8BB559C1,0xCA84C0A3,0x8B76A8E4,0xCB0DE658,0x8B3899C6,
0xCB97558A,0x8AFB2CBB,0xCC210D79,0x8ABE6219,0xCCAB0D65,0x8A823A36,0xCD355491,
0x8A46B564,0xCDBFE23A,0x8A0BD3F5,0xCE4AB5A2,0x89D1963C,0xCED5CE08,0x8997FC8A,
0xCF612AAA,0x895F072E,0xCFECCAC7,0x8926B677,0xD078AD9E,0x88EF0AB4,0xD104D26B,
0x88B80432,0xD191386E,0x8881A33D,0xD21DDEE2,0x884BE821,0xD2AAC504,0x8816D327,
0xD337EA12,0x87E2649B,0xD3C54D47,0x87AE9CC5,0xD452EDDF,0x877B7BEC,0xD4E0CB15,
0x87490258,0xD56EE424,0x8717304E,0xD5FD3848,0x86E60614,0xD68BC6BA,0x86B583EE,
0xD71A8EB5,0x8685AA20,0xD7A98F73,0x865678EB,0xD838C82D,0x8627F091,0xD8C8381D,
0x85FA1153,0xD957DE7A,0x85CCDB70,0xD9E7BA7F,0x85A04F28,0xDA77CB63,0x85746CB8,
0xDB08105E,0x8549345C,0xDB9888A8,0x851EA652,0xDC293379,0x84F4C2D4,0xDCBA1008,
0x84CB8A1B,0xDD4B1D8C,0x84A2FC62,0xDDDC5B3B,0x847B19E1,0xDE6DC84B,0x8453E2CF,
0xDEFF63F4,0x842D5762,0xDF912D6B,0x840777D0,0xE02323E5,0x83E2444D,0xE0B54698,
0x83BDBD0E,0xE14794BA,0x8399E244,0xE1DA0D7E,0x8376B422,0xE26CB01B,0x835432D8,
0xE2FF7BC3,0x83325E97,0xE3926FAD,0x8311378D,0xE4258B0A,0x82F0BDE8,0xE4B8CD11,
0x82D0F1D5,0xE54C34F3,0x82B1D381,0xE5DFC1E5,0x82936317,0xE6737319,0x8275A0C0,
0xE70747C4,0x82588CA7,0xE79B3F16,0x823C26F3,0xE82F5844,0x82206FCC,0xE8C39280,
0x82056758,0xE957ECFB,0x81EB0DBE,0xE9EC66E8,0x81D16321,0xEA80FF7A,0x81B867A5,
0xEB15B5E1,0x81A01B6D,0xEBAA894F,0x81887E9A,0xEC3F78F6,0x8171914E,0xECD48407,
0x815B53A8,0xED69A9B3,0x8145C5C7,0xEDFEE92B,0x8130E7C9,0xEE9441A0,0x811CB9CA,
0xEF29B243,0x81093BE8,0xEFBF3A45,0x80F66E3C,0xF054D8D5,0x80E450E2,0xF0EA8D24,
0x80D2E3F2,0xF1805662,0x80C22784,0xF21633C0,0x80B21BAF,0xF2AC246E,0x80A2C08B,
0xF342279B,0x8094162C,0xF3D83C77,0x80861CA6,0xF46E6231,0x8078D40D,0xF50497FB,
0x806C3C74,0xF59ADD02,0x806055EB,0xF6313077,0x80552084,0xF6C79188,0x804A9C4D,
0xF75DFF66,0x8040C956,0xF7F4793E,0x8037A7AC,0xF88AFE42,0x802F375D,0xF9218D9E,
0x80277872,0xF9B82684,0x80206AF8,0xFA4EC821,0x801A0EF8,0xFAE571A4,0x8014647B,
0xFB7C223D,0x800F6B88,0xFC12D91A,0x800B2427,0xFCA9956A,0x80078E5E,0xFD40565C,
0x8004AA32,0xFDD71B1E,0x800277A6,0xFE6DE2E0,0x8000F6BD,0xFF04ACD0,0x8000277A,
0xFF9B781D,0x800009DF,0x003243F5,0x80009DEA,0x00C90F88,0x8001E39B,0x015FDA03,
0x8003DAF1,0x01F6A297,0x800683E8,0x028D6870,0x8009DE7E,0x03242ABF,0x800DEAAD,
0x03BAE8B2,0x8012A86F,0x0451A177,0x801817BF,0x04E8543E,0x801E3895,0x057F0035,
0x80250AE7,0x0615A48B,0x802C8EAD,0x06AC406F,0x8034C3DD,0x0742D311,0x803DAA6A,
0x07D95B9E,0x80474248,0x086FD947,0x80518B6B,0x09064B3A,0x805C85C4,0x099CB0A7,
0x80683143,0x0A3308BD,0x80748DD9,0x0AC952AA,0x80819B74,0x0B5F8D9F,0x808F5A02,
0x0BF5B8CB,0x809DC971,0x0C8BD35E,0x80ACE9AB,0x0D21DC87,0x80BCBA9D,0x0DB7D376,
0x80CD3C2F,0x0E4DB75B,0x80DE6E4C,0x0EE38766,0x80F050DB,0x0F7942C7,0x8102E3C4,
0x100EE8AD,0x811626EC,0x10A4784B,0x812A1A3A,0x1139F0CF,0x813EBD90,0x11CF516A,
0x815410D4,0x1264994E,0x816A13E6,0x12F9C7AA,0x8180C6A9,0x138EDBB1,0x819828FD,
0x1423D492,0x81B03AC2,0x14B8B17F,0x81C8FBD6,0x154D71AA,0x81E26C16,0x15E21445,
0x81FC8B60,0x1676987F,0x82175990,0x170AFD8D,0x8232D67F,0x179F429F,0x824F0208,
0x183366E9,0x826BDC04,0x18C7699B,0x8289644B,0x195B49EA,0x82A79AB3,0x19EF0707,
0x82C67F14,0x1A82A026,0x82E61141,0x1B161479,0x83065110,0x1BA96335,0x83273E52,
0x1C3C8B8C,0x8348D8DC,0x1CCF8CB3,0x836B207D,0x1D6265DD,0x838E1507,0x1DF5163F,
0x83B1B649,0x1E879D0D,0x83D60412,0x1F19F97B,0x83FAFE2E,0x1FAC2ABF,0x8420A46C,
0x203E300D,0x8446F695,0x20D0089C,0x846DF477,0x2161B3A0,0x84959DD9,0x21F3304F,
0x84BDF286,0x22847DE0,0x84E6F244,0x23159B88,0x85109CDD,0x23A6887F,0x853AF214,
0x243743FA,0x8565F1B0,0x24C7CD33,0x85919B76,0x2558235F,0x85BDEF28,0x25E845B6,
0x85EAEC88,0x26783370,0x86189359,0x2707EBC7,0x8646E35C,0x27976DF1,0x8675DC4F,
0x2826B928,0x86A57DF2,0x28B5CCA5,0x86D5C802,0x2944A7A2,0x8706BA3D,0x29D34958,
0x8738545E,0x2A61B101,0x876A9621,0x2AEFDDD8,0x879D7F41,0x2B7DCF17,0x87D10F75,
0x2C0B83FA,0x88054677,0x2C98FBBA,0x883A23FF,0x2D263596,0x886FA7C2,0x2DB330C7,
0x88A5D177,0x2E3FEC8B,0x88DCA0D3,0x2ECC681E,0x89141589,0x2F58A2BE,0x894C2F4C,
0x2FE49BA7,0x8984EDCF,0x30705217,0x89BE50C3,0x30FBC54D,0x89F857D8,0x3186F487,
0x8A3302BE,0x3211DF04,0x8A6E5123,0x329C8402,0x8AAA42B4,0x3326E2C3,0x8AE6D720,
0x33B0FA84,0x8B240E11,0x343ACA87,0x8B61E733,0x34C4520D,0x8BA0622F,0x354D9057,
0x8BDF7EB0,0x35D684A6,0x8C1F3C5D,0x365F2E3B,0x8C5F9ADE,0x36E78C5B,0x8CA099DA,
0x376F9E46,0x8CE238F6,0x37F76341,0x8D2477D8,0x387EDA8E,0x8D675623,0x39060373,
0x8DAAD37B,0x398CDD32,0x8DEEEF82,0x3A136712,0x8E33A9DA,0x3A99A057,0x8E790222,
0x3B1F8848,0x8EBEF7FB,0x3BA51E29,0x8F058B04,0x3C2A6142,0x8F4CBADB,0x3CAF50DA,
0x8F94871D,0x3D33EC39,0x8FDCEF66,0x3DB832A6,0x9025F352,0x3E3C2369,0x906F927C,
0x3EBFBDCD,0x90B9CC7D,0x3F430119,0x9104A0EE,0x3FC5EC98,0x91500F67,0x40487F94,
0x919C1781,0x40CAB958,0x91E8B8D0,0x414C992F,0x9235F2EC,0x41CE1E65,0x9283C568,
0x424F4845,0x92D22FD9,0x42D0161E,0x932131D1,0x4350873C,0x9370CAE4,0x43D09AED,
0x93C0FAA3,0x4450507E,0x9411C09E,0x44CFA740,0x94631C65,0x454E9E80,0x94B50D87,
0x45CD358F,0x95079394,0x464B6BBE,0x955AAE17,0x46C9405C,0x95AE5C9F,0x4746B2BC,
0x96029EB6,0x47C3C22F,0x965773E7,0x48406E08,0x96ACDBBE,0x48BCB599,0x9702D5C3,
0x49389836,0x9759617F,0x49B41533,0x97B07E7A,0x4A2F2BE6,0x98082C3B,0x4AA9DBA2,
0x98606A49,0x4B2423BE,0x98B93828,0x4B9E0390,0x9912955F,0x4C177A6E,0x996C816F,
0x4C9087B1,0x99C6FBDE,0x4D092AB0,0x9A22042D,0x4D8162C4,0x9A7D99DE,0x4DF92F46,
0x9AD9BC71,0x4E708F8F,0x9B366B68,0x4EE782FB,0x9B93A641,0x4F5E08E3,0x9BF16C7A,
0x4FD420A4,0x9C4FBD93,0x5049C999,0x9CAE9907,0x50BF031F,0x9D0DFE54,0x5133CC94,
0x9D6DECF4,0x51A82555,0x9DCE6463,0x521C0CC2,0x9E2F641B,0x528F8238,0x9E90EB94,
0x53028518,0x9EF2FA49,0x537514C2,0x9F558FB0,0x53E73097,0x9FB8AB41,0x5458D7F9,
0xA01C4C73,0x54CA0A4B,0xA08072BA,0x553AC6EE,0xA0E51D8C,0x55AB0D46,0xA14A4C5E,
0x561ADCB9,0xA1AFFEA3,0x568A34A9,0xA21633CD,0x56F9147E,0xA27CEB4F,0x57677B9D,
0xA2E4249B,0x57D5696D,0xA34BDF20,0x5842DD54,0xA3B41A50,0x58AFD6BD,0xA41CD599,
0x591C550E,0xA486106A,0x598857B2,0xA4EFCA31,0x59F3DE12,0xA55A025B,0x5A5EE79A,
0xA5C4B855,0x5AC973B5,0xA62FEB8B,0x5B3381CE,0xA69B9B68,0x5B9D1154,0xA707C757,
0x5C0621B2,0xA7746EC0,0x5C6EB258,0xA7E1910F,0x5CD6C2B5,0xA84F2DAA,0x5D3E5237,
0xA8BD43FA,0x5DA5604F,0xA92BD367,0x5E0BEC6E,0xA99ADB56,0x5E71F606,0xAA0A5B2E,
0x5ED77C8A,0xAA7A5253,0x5F3C7F6B,0xAAEAC02C,0x5FA0FE1F,0xAB5BA41A,0x6004F819,
0xABCCFD83,0x60686CCF,0xAC3ECBC7,0x60CB5BB7,0xACB10E4B,0x612DC447,0xAD23C46E,
0x618FA5F7,0xAD96ED92,0x61F1003F,0xAE0A8916,0x6251D298,0xAE7E965B,0x62B21C7B,
0xAEF314C0,0x6311DD64,0xAF6803A2,0x637114CC,0xAFDD625F,0x63CFC231,0xB0533055,
0x642DE50D,0xB0C96CE0,0x648B7CE0,0xB140175B,0x64E88926,0xB1B72F23,0x6545095F,
0xB22EB392,0x65A0FD0B,0xB2A6A402,0x65FC63A9,0xB31EFFCC,0x66573CBB,0xB397C649,
0x66B187C3,0xB410F6D3,0x670B4444,0xB48A90C0,0x676471C0,0xB5049368,0x67BD0FBD,
0xB57EFE22,0x68151DBE,0xB5F9D043,0x686C9B4B,0xB6750921,0x68C387E9,0xB6F0A812,
0x6919E320,0xB76CAC69,0x696FAC78,0xB7E9157A,0x69C4E37A,0xB865E299,0x6A1987B0,
0xB8E31319,0x6A6D98A4,0xB960A64C,0x6AC115E2,0xB9DE9B83,0x6B13FEF5,0xBA5CF210,
0x6B66536B,0xBADBA943,0x6BB812D1,0xBB5AC06D,0x6C093CB6,0xBBDA36DD,0x6C59D0A9,
0xBC5A0BE2,0x6CA9CE3B,0xBCDA3ECB,0x6CF934FC,0xBD5ACEE5,0x6D48047E,0xBDDBBB7F,
0x6D963C54,0xBE5D03E6,0x6DE3DC11,0xBEDEA765,0x6E30E34A,0xBF60A54A,0x6E7D5193,
0xBFE2FCDF,0x6EC92683,0xC065AD70,0x6F1461B0,0xC0E8B648,0x6F5F02B2,0xC16C16B0,
0x6FA90921,0xC1EFCDF3,0x6FF27497,0xC273DB58,0x703B44AD,0xC2F83E2A,0x708378FF,
0xC37CF5B0,0x70CB1128,0xC4020133,0x71120CC5,0xC4875FF9,0x71586B74,0xC50D1149,
0x719E2CD2,0xC593146A,0x71E35080,0xC61968A2,0x7227D61C,0xC6A00D37,0x726BBD48,
0xC727016D,0x72AF05A7,0xC7AE4489,0x72F1AED9,0xC835D5D0,0x7333B883,0xC8BDB485,
0x73752249,0xC945DFEC,0x73B5EBD1,0xC9CE5748,0x73F614C0,0xCA5719DB,0x74359CBD,
0xCAE026E8,0x74748371,0xCB697DB0,0x74B2C884,0xCBF31D75,0x74F06B9E,0xCC7D0578,
0x752D6C6C,0xCD0734F9,0x7569CA99,0xCD91AB39,0x75A585CF,0xCE1C6777,0x75E09DBD,
0xCEA768F2,0x761B1211,0xCF32AEEB,0x7654E279,0xCFBE389F,0x768E0EA6,0xD04A054E,
0x76C69647,0xD0D61434,0x76FE790E,0xD1626490,0x7735B6AF,0xD1EEF59E,0x776C4EDB,
0xD27BC69C,0x77A24148,0xD308D6C7,0x77D78DAA,0xD396255A,0x780C33B8,0xD423B191,
0x78403329,0xD4B17AA8,0x78738BB3,0xD53F7FDA,0x78A63D11,0xD5CDC062,0x78D846FB,
0xD65C3B7B,0x7909A92D,0xD6EAF05F,0x793A6361,0xD779DE47,0x796A7554,0xD809046E,
0x7999DEC4,0xD898620C,0x79C89F6E,0xD927F65B,0x79F6B711,0xD9B7C094,0x7A24256F,
0xDA47BFEE,0x7A50EA47,0xDAD7F3A2,0x7A7D055B,0xDB685AE9,0x7AA8766F,0xDBF8F4F8,
0x7AD33D45,0xDC89C109,0x7AFD59A4,0xDD1ABE51,0x7B26CB4F,0xDDABEC08,0x7B4F920E,
0xDE3D4964,0x7B77ADA8,0xDECED59B,0x7B9F1DE6,0xDF608FE4,0x7BC5E290,0xDFF27773,
0x7BEBFB70,0xE0848B7F,0x7C116853,0xE116CB3D,0x7C362904,0xE1A935E2,0x7C5A3D50,
0xE23BCAA2,0x7C7DA505,0xE2CE88B3,0x7CA05FF1,0xE3616F48,0x7CC26DE5,0xE3F47D96,
0x7CE3CEB2,0xE487B2D0,0x7D048228,0xE51B0E2A,0x7D24881B,0xE5AE8ED8,0x7D43E05E,
0xE642340D,0x7D628AC6,0xE6D5FCFC,0x7D808728,0xE769E8D8,0x7D9DD55A,0xE7FDF6D4,
0x7DBA7534,0xE8922622,0x7DD6668F,0xE92675F4,0x7DF1A942,0xE9BAE57D,0x7E0C3D29,
0xEA4F73EE,0x7E26221F,0xEAE4207A,0x7E3F57FF,0xEB78EA52,0x7E57DEA7,0xEC0DD0A8,
0x7E6FB5F4,0xECA2D2AD,0x7E86DDC6,0xED37EF91,0x7E9D55FC,0xEDCD2687,0x7EB31E78,
0xEE6276BF,0x7EC8371A,0xEEF7DF6A,0x7EDC9FC6,0xEF8D5FB8,0x7EF05860,0xF022F6DA,
0x7F0360CB,0xF0B8A401,0x7F15B8EE,0xF14E665C,0x7F2760AF,0xF1E43D1C,0x7F3857F6,
0xF27A2771,0x7F489EAA,0xF310248A,0x7F5834B7,0xF3A63398,0x7F671A05,0xF43C53CB,
0x7F754E80,0xF4D28451,0x7F82D214,0xF568C45B,0x7F8FA4B0,0xF5FF1318,0x7F9BC640,
0xF6956FB7,0x7FA736B4,0xF72BD967,0x7FB1F5FC,0xF7C24F59,0x7FBC040A,0xF858D0BB,
0x7FC560CF,0xF8EF5CBB,0x7FCE0C3E,0xF985F28A,0x7FD6064C,0xFA1C9157,0x7FDD4EEC,
0xFAB3384F,0x7FE3E616,0xFB49E6A3,0x7FE9CBC0,0xFBE09B80,0x7FEEFFE1,0xFC775616,
0x7FF38274,0xFD0E1594,0x7FF75370,0xFDA4D929,0x7FFA72D1,0xFE3BA002,0x7FFCE093,
0xFED2694F,0x7FFE9CB2,0xFF69343F,0x7FFFA72C,0x7FFFFFFF,0x00000000,0x7FFA72D1,
0xFDA4D929,0x7FE9CBC0,0xFB49E6A3,0x7FCE0C3E,0xF8EF5CBB,0x7FA736B4,0xF6956FB7,
0x7F754E80,0xF43C53CB,0x7F3857F6,0xF1E43D1C,0x7EF05860,0xEF8D5FB8,0x7E9D55FC,
0xED37EF91,0x7E3F57FF,0xEAE4207A,0x7DD6668F,0xE8922622,0x7D628AC6,0xE642340D,
0x7CE3CEB2,0xE3F47D96,0x7C5A3D50,0xE1A935E2,0x7BC5E290,0xDF608FE4,0x7B26CB4F,
0xDD1ABE51,0x7A7D055B,0xDAD7F3A2,0x79C89F6E,0xD898620C,0x7909A92D,0xD65C3B7B,
0x78403329,0xD423B191,0x776C4EDB,0xD1EEF59E,0x768E0EA6,0xCFBE389F,0x75A585CF,
0xCD91AB39,0x74B2C884,0xCB697DB0,0x73B5EBD1,0xC945DFEC,0x72AF05A7,0xC727016D,
0x719E2CD2,0xC50D1149,0x708378FF,0xC2F83E2A,0x6F5F02B2,0xC0E8B648,0x6E30E34A,
0xBEDEA765,0x6CF934FC,0xBCDA3ECB,0x6BB812D1,0xBADBA943,0x6A6D98A4,0xB8E31319,
0x6919E320,0xB6F0A812,0x67BD0FBD,0xB5049368,0x66573CBB,0xB31EFFCC,0x64E88926,
0xB140175B,0x637114CC,0xAF6803A2,0x61F1003F,0xAD96ED92,0x60686CCF,0xABCCFD83,
0x5ED77C8A,0xAA0A5B2E,0x5D3E5237,0xA84F2DAA,0x5B9D1154,0xA69B9B68,0x59F3DE12,
0xA4EFCA31,0x5842DD54,0xA34BDF20,0x568A34A9,0xA1AFFEA3,0x54CA0A4B,0xA01C4C73,
0x53028518,0x9E90EB94,0x5133CC94,0x9D0DFE54,0x4F5E08E3,0x9B93A641,0x4D8162C4,
0x9A22042D,0x4B9E0390,0x98B93828,0x49B41533,0x9759617F,0x47C3C22F,0x96029EB6,
0x45CD358F,0x94B50D87,0x43D09AED,0x9370CAE4,0x41CE1E65,0x9235F2EC,0x3FC5EC98,
0x9104A0EE,0x3DB832A6,0x8FDCEF66,0x3BA51E29,0x8EBEF7FB,0x398CDD32,0x8DAAD37B,
0x376F9E46,0x8CA099DA,0x354D9057,0x8BA0622F,0x3326E2C3,0x8AAA42B4,0x30FBC54D,
0x89BE50C3,0x2ECC681E,0x88DCA0D3,0x2C98FBBA,0x88054677,0x2A61B101,0x8738545E,
0x2826B928,0x8675DC4F,0x25E845B6,0x85BDEF28,0x23A6887F,0x85109CDD,0x2161B3A0,
0x846DF477,0x1F19F97B,0x83D60412,0x1CCF8CB3,0x8348D8DC,0x1A82A026,0x82C67F14,
0x183366E9,0x824F0208,0x15E21445,0x81E26C16,0x138EDBB1,0x8180C6A9,0x1139F0CF,
0x812A1A3A,0x0EE38766,0x80DE6E4C,0x0C8BD35E,0x809DC971,0x0A3308BD,0x80683143,
0x07D95B9E,0x803DAA6A,0x057F0035,0x801E3895,0x03242ABF,0x8009DE7E,0x00C90F88,
0x80009DEA,0xFE6DE2E0,0x800277A6,0xFC12D91A,0x800F6B88,0xF9B82684,0x80277872,
0xF75DFF66,0x804A9C4D,0xF50497FB,0x8078D40D,0xF2AC246E,0x80B21BAF,0xF054D8D5,
0x80F66E3C,0xEDFEE92B,0x8145C5C7,0xEBAA894F,0x81A01B6D,0xE957ECFB,0x82056758,
0xE70747C4,0x8275A0C0,0xE4B8CD11,0x82F0BDE8,0xE26CB01B,0x8376B422,0xE02323E5,
0x840777D0,0xDDDC5B3B,0x84A2FC62,0xDB9888A8,0x8549345C,0xD957DE7A,0x85FA1153,
0xD71A8EB5,0x86B583EE,0xD4E0CB15,0x877B7BEC,0xD2AAC504,0x884BE821,0xD078AD9E,
0x8926B677,0xCE4AB5A2,0x8A0BD3F5,0xCC210D79,0x8AFB2CBB,0xC9FBE527,0x8BF4AC05,
0xC7DB6C50,0x8CF83C30,0xC5BFD22E,0x8E05C6B7,0xC3A94590,0x8F1D343A,0xC197F4D4,
0x903E6C7B,0xBF8C0DE3,0x91695663,0xBD85BE30,0x929DD806,0xBB8532B0,0x93DBD6A0,
0xB98A97D8,0x9523369C,0xB796199B,0x9673DB94,0xB5A7E362,0x97CDA855,0xB3C0200C,
0x99307EE0,0xB1DEF9E9,0x9A9C406E,0xB0049AB3,0x9C10CD70,0xAE312B92,0x9D8E0597,
0xAC64D510,0x9F13C7D0,0xAA9FBF1E,0xA0A1F24D,0xA8E21106,0xA2386284,0xA72BF174,
0xA3D6F534,0xA57D8666,0xA57D8666,0xA3D6F534,0xA72BF174,0xA2386284,0xA8E21106,
0xA0A1F24D,0xAA9FBF1E,0x9F13C7D0,0xAC64D510,0x9D8E0597,0xAE312B92,0x9C10CD70,
0xB0049AB3,0x9A9C406E,0xB1DEF9E9,0x99307EE0,0xB3C0200C,0x97CDA855,0xB5A7E362,
0x9673DB94,0xB796199B,0x9523369C,0xB98A97D8,0x93DBD6A0,0xBB8532B0,0x929DD806,
0xBD85BE30,0x91695663,0xBF8C0DE3,0x903E6C7B,0xC197F4D4,0x8F1D343A,0xC3A94590,
0x8E05C6B7,0xC5BFD22E,0x8CF83C30,0xC7DB6C50,0x8BF4AC05,0xC9FBE527,0x8AFB2CBB,
0xCC210D79,0x8A0BD3F5,0xCE4AB5A2,0x8926B677,0xD078AD9E,0x884BE821,0xD2AAC504,
0x877B7BEC,0xD4E0CB15,0x86B583EE,0xD71A8EB5,0x85FA1153,0xD957DE7A,0x8549345C,
0xDB9888A8,0x84A2FC62,0xDDDC5B3B,0x840777D0,0xE02323E5,0x8376B422,0xE26CB01B,
0x82F0BDE8,0xE4B8CD11,0x8275A0C0,0xE70747C4,0x82056758,0xE957ECFB,0x81A01B6D,
0xEBAA894F,0x8145C5C7,0xEDFEE92B,0x80F66E3C,0xF054D8D5,0x80B21BAF,0xF2AC246E,
0x8078D40D,0xF50497FB,0x804A9C4D,0xF75DFF66,0x80277872,0xF9B82684,0x800F6B88,
0xFC12D91A,0x800277A6,0xFE6DE2E0,0x80009DEA,0x00C90F88,0x8009DE7E,0x03242ABF,
0x801E3895,0x057F0035,0x803DAA6A,0x07D95B9E,0x80683143,0x0A3308BD,0x809DC971,
0x0C8BD35E,0x80DE6E4C,0x0EE38766,0x812A1A3A,0x1139F0CF,0x8180C6A9,0x138EDBB1,
0x81E26C16,0x15E21445,0x824F0208,0x183366E9,0x82C67F14,0x1A82A026,0x8348D8DC,
0x1CCF8CB3,0x83D60412,0x1F19F97B,0x846DF477,0x2161B3A0,0x85109CDD,0x23A6887F,
0x85BDEF28,0x25E845B6,0x8675DC4F,0x2826B928,0x8738545E,0x2A61B101,0x88054677,
0x2C98FBBA,0x88DCA0D3,0x2ECC681E,0x89BE50C3,0x30FBC54D,0x8AAA42B4,0x3326E2C3,
0x8BA0622F,0x354D9057,0x8CA099DA,0x376F9E46,0x8DAAD37B,0x398CDD32,0x8EBEF7FB,
0x3BA51E29,0x8FDCEF66,0x3DB832A6,0x9104A0EE,0x3FC5EC98,0x9235F2EC,0x41CE1E65,
0x9370CAE4,0x43D09AED,0x94B50D87,0x45CD358F,0x96029EB6,0x47C3C22F,0x9759617F,
0x49B41533,0x98B93828,0x4B9E0390,0x9A22042D,0x4D8162C4,0x9B93A641,0x4F5E08E3,
0x9D0DFE54,0x5133CC94,0x9E90EB94,0x53028518,0xA01C4C73,0x54CA0A4B,0xA1AFFEA3,
0x568A34A9,0xA34BDF20,0x5842DD54,0xA4EFCA31,0x59F3DE12,0xA69B9B68,0x5B9D1154,
0xA84F2DAA,0x5D3E5237,0xAA0A5B2E,0x5ED77C8A,0xABCCFD83,0x60686CCF,0xAD96ED92,
0x61F1003F,0xAF6803A2,0x637114CC,0xB140175B,0x64E88926,0xB31EFFCC,0x66573CBB,
0xB5049368,0x67BD0FBD,0xB6F0A812,0x6919E320,0xB8E31319,0x6A6D98A4,0xBADBA943,
0x6BB812D1,0xBCDA3ECB,0x6CF934FC,0xBEDEA765,0x6E30E34A,0xC0E8B648,0x6F5F02B2,
0xC2F83E2A,0x708378FF,0xC50D1149,0x719E2CD2,0xC727016D,0x72AF05A7,0xC945DFEC,
0x73B5EBD1,0xCB697DB0,0x74B2C884,0xCD91AB39,0x75A585CF,0xCFBE389F,0x768E0EA6,
0xD1EEF59E,0x776C4EDB,0xD423B191,0x78403329,0xD65C3B7B,0x7909A92D,0xD898620C,
0x79C89F6E,0xDAD7F3A2,0x7A7D055B,0xDD1ABE51,0x7B26CB4F,0xDF608FE4,0x7BC5E290,
0xE1A935E2,0x7C5A3D50,0xE3F47D96,0x7CE3CEB2,0xE642340D,0x7D628AC6,0xE8922622,
0x7DD6668F,0xEAE4207A,0x7E3F57FF,0xED37EF91,0x7E9D55FC,0xEF8D5FB8,0x7EF05860,
0xF1E43D1C,0x7F3857F6,0xF43C53CB,0x7F754E80,0xF6956FB7,0x7FA736B4,0xF8EF5CBB,
0x7FCE0C3E,0xFB49E6A3,0x7FE9CBC0,0xFDA4D929,0x7FFA72D1,0x7FFFFFFF,0x00000000,
0x7FA736B4,0xF6956FB7,0x7E9D55FC,0xED37EF91,0x7CE3CEB2,0xE3F47D96,0x7A7D055B,
0xDAD7F3A2,0x776C4EDB,0xD1EEF59E,0x73B5EBD1,0xC945DFEC,0x6F5F02B2,0xC0E8B648,
0x6A6D98A4,0xB8E31319,0x64E88926,0xB140175B,0x5ED77C8A,0xAA0A5B2E,0x5842DD54,
0xA34BDF20,0x5133CC94,0x9D0DFE54,0x49B41533,0x9759617F,0x41CE1E65,0x9235F2EC,
0x398CDD32,0x8DAAD37B,0x30FBC54D,0x89BE50C3,0x2826B928,0x8675DC4F,0x1F19F97B,
0x83D60412,0x15E21445,0x81E26C16,0x0C8BD35E,0x809DC971,0x03242ABF,0x8009DE7E,
0xF9B82684,0x80277872,0xF054D8D5,0x80F66E3C,0xE70747C4,0x8275A0C0,0xDDDC5B3B,
0x84A2FC62,0xD4E0CB15,0x877B7BEC,0xCC210D79,0x8AFB2CBB,0xC3A94590,0x8F1D343A,
0xBB8532B0,0x93DBD6A0,0xB3C0200C,0x99307EE0,0xAC64D510,0x9F13C7D0,0xA57D8666,
0xA57D8666,0x9F13C7D0,0xAC64D510,0x99307EE0,0xB3C0200C,0x93DBD6A0,0xBB8532B0,
0x8F1D343A,0xC3A94590,0x8AFB2CBB,0xCC210D79,0x877B7BEC,0xD4E0CB15,0x84A2FC62,
0xDDDC5B3B,0x8275A0C0,0xE70747C4,0x80F66E3C,0xF054D8D5,0x80277872,0xF9B82684,
0x8009DE7E,0x03242ABF,0x809DC971,0x0C8BD35E,0x81E26C16,0x15E21445,0x83D60412,
0x1F19F97B,0x8675DC4F,0x2826B928,0x89BE50C3,0x30FBC54D,0x8DAAD37B,0x398CDD32,
0x9235F2EC,0x41CE1E65,0x9759617F,0x49B41533,0x9D0DFE54,0x5133CC94,0xA34BDF20,
0x5842DD54,0xAA0A5B2E,0x5ED77C8A,0xB140175B,0x64E88926,0xB8E31319,0x6A6D98A4,
0xC0E8B648,0x6F5F02B2,0xC945DFEC,0x73B5EBD1,0xD1EEF59E,0x776C4EDB,0xDAD7F3A2,
0x7A7D055B,0xE3F47D96,0x7CE3CEB2,0xED37EF91,0x7E9D55FC,0xF6956FB7,0x7FA736B4,
0x7FFFFFFF,0x00000000,0x7A7D055B,0xDAD7F3A2,0x6A6D98A4,0xB8E31319,0x5133CC94,
0x9D0DFE54,0x30FBC54D,0x89BE50C3,0x0C8BD35E,0x809DC971,0xE70747C4,0x8275A0C0,
0xC3A94590,0x8F1D343A,0xA57D8666,0xA57D8666,0x8F1D343A,0xC3A94590,0x8275A0C0,
0xE70747C4,0x809DC971,0x0C8BD35E,0x89BE50C3,0x30FBC54D,0x9D0DFE54,0x5133CC94,
0xB8E31319,0x6A6D98A4,0xDAD7F3A2,0x7A7D055B,0x7FFFFFFF,0x00000000,0x30FBC54D,
0x89BE50C3,0xA57D8666,0xA57D8666,0x89BE50C3,0x30FBC54D,};

#endif



#endif /* !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_FFT_ALLOW_TABLES) */
#endif /* defined(ARM_MATH_MVEI)  */



#if defined(ARM_MATH_MVEI) && !defined(ARM_MATH_AUTOVECTORIZE)

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_FFT_ALLOW_TABLES)

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_Q15_16) || defined(ARM_TABLE_TWIDDLECOEF_Q15_32)

uint32_t rearranged_twiddle_tab_stride1_arr_16_q15[2]={
0,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_16_q15[2]={
0,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_16_q15[2]={
0,0,};

q15_t rearranged_twiddle_stride1_16_q15[8]={
0x7FFF,0x0000,0x7642,0xCF04,0x5A82,0xA57E,0x30FC,0x89BE,};

q15_t rearranged_twiddle_stride2_16_q15[8]={
0x7FFF,0x0000,0x5A82,0xA57E,0x0000,0x8000,0xA57E,0xA57E,};

q15_t rearranged_twiddle_stride3_16_q15[8]={
0x7FFF,0x0000,0x30FC,0x89BE,0xA57E,0xA57E,0x89BE,0x30FC,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_Q15_64) || defined(ARM_TABLE_TWIDDLECOEF_Q15_128)

uint32_t rearranged_twiddle_tab_stride1_arr_64_q15[3]={
0,32,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_64_q15[3]={
0,32,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_64_q15[3]={
0,32,0,};

q15_t rearranged_twiddle_stride1_64_q15[40]={
0x7FFF,0x0000,0x7F62,0xF374,0x7D8A,0xE707,0x7A7D,0xDAD8,0x7642,0xCF04,0x70E3,
0xC3A9,0x6A6E,0xB8E3,0x62F2,0xAECC,0x5A82,0xA57E,0x5134,0x9D0E,0x471D,0x9592,
0x3C57,0x8F1D,0x30FC,0x89BE,0x2528,0x8583,0x18F9,0x8276,0x0C8C,0x809E,0x7FFF,
0x0000,0x7642,0xCF04,0x5A82,0xA57E,0x30FC,0x89BE,};

q15_t rearranged_twiddle_stride2_64_q15[40]={
0x7FFF,0x0000,0x7D8A,0xE707,0x7642,0xCF04,0x6A6E,0xB8E3,0x5A82,0xA57E,0x471D,
0x9592,0x30FC,0x89BE,0x18F9,0x8276,0x0000,0x8000,0xE707,0x8276,0xCF04,0x89BE,
0xB8E3,0x9592,0xA57E,0xA57E,0x9592,0xB8E3,0x89BE,0xCF04,0x8276,0xE707,0x7FFF,
0x0000,0x5A82,0xA57E,0x0000,0x8000,0xA57E,0xA57E,};

q15_t rearranged_twiddle_stride3_64_q15[40]={
0x7FFF,0x0000,0x7A7D,0xDAD8,0x6A6E,0xB8E3,0x5134,0x9D0E,0x30FC,0x89BE,0x0C8C,
0x809E,0xE707,0x8276,0xC3A9,0x8F1D,0xA57E,0xA57E,0x8F1D,0xC3A9,0x8276,0xE707,
0x809E,0x0C8C,0x89BE,0x30FC,0x9D0E,0x5134,0xB8E3,0x6A6E,0xDAD8,0x7A7D,0x7FFF,
0x0000,0x30FC,0x89BE,0xA57E,0xA57E,0x89BE,0x30FC,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_Q15_256) || defined(ARM_TABLE_TWIDDLECOEF_Q15_512)

uint32_t rearranged_twiddle_tab_stride1_arr_256_q15[4]={
0,128,160,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_256_q15[4]={
0,128,160,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_256_q15[4]={
0,128,160,0,};

q15_t rearranged_twiddle_stride1_256_q15[168]={
0x7FFF,0x0000,0x7FF6,0xFCDC,0x7FD9,0xF9B8,0x7FA7,0xF695,0x7F62,0xF374,0x7F0A,
0xF055,0x7E9D,0xED38,0x7E1E,0xEA1E,0x7D8A,0xE707,0x7CE4,0xE3F4,0x7C2A,0xE0E6,
0x7B5D,0xDDDC,0x7A7D,0xDAD8,0x798A,0xD7D9,0x7885,0xD4E1,0x776C,0xD1EF,0x7642,
0xCF04,0x7505,0xCC21,0x73B6,0xC946,0x7255,0xC673,0x70E3,0xC3A9,0x6F5F,0xC0E9,
0x6DCA,0xBE32,0x6C24,0xBB85,0x6A6E,0xB8E3,0x68A7,0xB64C,0x66D0,0xB3C0,0x64E9,
0xB140,0x62F2,0xAECC,0x60EC,0xAC65,0x5ED7,0xAA0A,0x5CB4,0xA7BD,0x5A82,0xA57E,
0x5843,0xA34C,0x55F6,0xA129,0x539B,0x9F14,0x5134,0x9D0E,0x4EC0,0x9B17,0x4C40,
0x9930,0x49B4,0x9759,0x471D,0x9592,0x447B,0x93DC,0x41CE,0x9236,0x3F17,0x90A1,
0x3C57,0x8F1D,0x398D,0x8DAB,0x36BA,0x8C4A,0x33DF,0x8AFB,0x30FC,0x89BE,0x2E11,
0x8894,0x2B1F,0x877B,0x2827,0x8676,0x2528,0x8583,0x2224,0x84A3,0x1F1A,0x83D6,
0x1C0C,0x831C,0x18F9,0x8276,0x15E2,0x81E2,0x12C8,0x8163,0x0FAB,0x80F6,0x0C8C,
0x809E,0x096B,0x8059,0x0648,0x8027,0x0324,0x800A,0x7FFF,0x0000,0x7F62,0xF374,
0x7D8A,0xE707,0x7A7D,0xDAD8,0x7642,0xCF04,0x70E3,0xC3A9,0x6A6E,0xB8E3,0x62F2,
0xAECC,0x5A82,0xA57E,0x5134,0x9D0E,0x471D,0x9592,0x3C57,0x8F1D,0x30FC,0x89BE,
0x2528,0x8583,0x18F9,0x8276,0x0C8C,0x809E,0x7FFF,0x0000,0x7642,0xCF04,0x5A82,
0xA57E,0x30FC,0x89BE,};

q15_t rearranged_twiddle_stride2_256_q15[168]={
0x7FFF,0x0000,0x7FD9,0xF9B8,0x7F62,0xF374,0x7E9D,0xED38,0x7D8A,0xE707,0x7C2A,
0xE0E6,0x7A7D,0xDAD8,0x7885,0xD4E1,0x7642,0xCF04,0x73B6,0xC946,0x70E3,0xC3A9,
0x6DCA,0xBE32,0x6A6E,0xB8E3,0x66D0,0xB3C0,0x62F2,0xAECC,0x5ED7,0xAA0A,0x5A82,
0xA57E,0x55F6,0xA129,0x5134,0x9D0E,0x4C40,0x9930,0x471D,0x9592,0x41CE,0x9236,
0x3C57,0x8F1D,0x36BA,0x8C4A,0x30FC,0x89BE,0x2B1F,0x877B,0x2528,0x8583,0x1F1A,
0x83D6,0x18F9,0x8276,0x12C8,0x8163,0x0C8C,0x809E,0x0648,0x8027,0x0000,0x8000,
0xF9B8,0x8027,0xF374,0x809E,0xED38,0x8163,0xE707,0x8276,0xE0E6,0x83D6,0xDAD8,
0x8583,0xD4E1,0x877B,0xCF04,0x89BE,0xC946,0x8C4A,0xC3A9,0x8F1D,0xBE32,0x9236,
0xB8E3,0x9592,0xB3C0,0x9930,0xAECC,0x9D0E,0xAA0A,0xA129,0xA57E,0xA57E,0xA129,
0xAA0A,0x9D0E,0xAECC,0x9930,0xB3C0,0x9592,0xB8E3,0x9236,0xBE32,0x8F1D,0xC3A9,
0x8C4A,0xC946,0x89BE,0xCF04,0x877B,0xD4E1,0x8583,0xDAD8,0x83D6,0xE0E6,0x8276,
0xE707,0x8163,0xED38,0x809E,0xF374,0x8027,0xF9B8,0x7FFF,0x0000,0x7D8A,0xE707,
0x7642,0xCF04,0x6A6E,0xB8E3,0x5A82,0xA57E,0x471D,0x9592,0x30FC,0x89BE,0x18F9,
0x8276,0x0000,0x8000,0xE707,0x8276,0xCF04,0x89BE,0xB8E3,0x9592,0xA57E,0xA57E,
0x9592,0xB8E3,0x89BE,0xCF04,0x8276,0xE707,0x7FFF,0x0000,0x5A82,0xA57E,0x0000,
0x8000,0xA57E,0xA57E,};

q15_t rearranged_twiddle_stride3_256_q15[168]={
0x7FFF,0x0000,0x7FA7,0xF695,0x7E9D,0xED38,0x7CE4,0xE3F4,0x7A7D,0xDAD8,0x776C,
0xD1EF,0x73B6,0xC946,0x6F5F,0xC0E9,0x6A6E,0xB8E3,0x64E9,0xB140,0x5ED7,0xAA0A,
0x5843,0xA34C,0x5134,0x9D0E,0x49B4,0x9759,0x41CE,0x9236,0x398D,0x8DAB,0x30FC,
0x89BE,0x2827,0x8676,0x1F1A,0x83D6,0x15E2,0x81E2,0x0C8C,0x809E,0x0324,0x800A,
0xF9B8,0x8027,0xF055,0x80F6,0xE707,0x8276,0xDDDC,0x84A3,0xD4E1,0x877B,0xCC21,
0x8AFB,0xC3A9,0x8F1D,0xBB85,0x93DC,0xB3C0,0x9930,0xAC65,0x9F14,0xA57E,0xA57E,
0x9F14,0xAC65,0x9930,0xB3C0,0x93DC,0xBB85,0x8F1D,0xC3A9,0x8AFB,0xCC21,0x877B,
0xD4E1,0x84A3,0xDDDC,0x8276,0xE707,0x80F6,0xF055,0x8027,0xF9B8,0x800A,0x0324,
0x809E,0x0C8C,0x81E2,0x15E2,0x83D6,0x1F1A,0x8676,0x2827,0x89BE,0x30FC,0x8DAB,
0x398D,0x9236,0x41CE,0x9759,0x49B4,0x9D0E,0x5134,0xA34C,0x5843,0xAA0A,0x5ED7,
0xB140,0x64E9,0xB8E3,0x6A6E,0xC0E9,0x6F5F,0xC946,0x73B6,0xD1EF,0x776C,0xDAD8,
0x7A7D,0xE3F4,0x7CE4,0xED38,0x7E9D,0xF695,0x7FA7,0x7FFF,0x0000,0x7A7D,0xDAD8,
0x6A6E,0xB8E3,0x5134,0x9D0E,0x30FC,0x89BE,0x0C8C,0x809E,0xE707,0x8276,0xC3A9,
0x8F1D,0xA57E,0xA57E,0x8F1D,0xC3A9,0x8276,0xE707,0x809E,0x0C8C,0x89BE,0x30FC,
0x9D0E,0x5134,0xB8E3,0x6A6E,0xDAD8,0x7A7D,0x7FFF,0x0000,0x30FC,0x89BE,0xA57E,
0xA57E,0x89BE,0x30FC,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_Q15_1024) || defined(ARM_TABLE_TWIDDLECOEF_Q15_2048)

uint32_t rearranged_twiddle_tab_stride1_arr_1024_q15[5]={
0,512,640,672,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_1024_q15[5]={
0,512,640,672,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_1024_q15[5]={
0,512,640,672,0,};

q15_t rearranged_twiddle_stride1_1024_q15[680]={
0x7FFF,0x0000,0x7FFF,0xFF37,0x7FFE,0xFE6E,0x7FFA,0xFDA5,0x7FF6,0xFCDC,0x7FF1,
0xFC13,0x7FEA,0xFB4A,0x7FE2,0xFA81,0x7FD9,0xF9B8,0x7FCE,0xF8EF,0x7FC2,0xF827,
0x7FB5,0xF75E,0x7FA7,0xF695,0x7F98,0xF5CD,0x7F87,0xF505,0x7F75,0xF43C,0x7F62,
0xF374,0x7F4E,0xF2AC,0x7F38,0xF1E4,0x7F22,0xF11C,0x7F0A,0xF055,0x7EF0,0xEF8D,
0x7ED6,0xEEC6,0x7EBA,0xEDFF,0x7E9D,0xED38,0x7E7F,0xEC71,0x7E60,0xEBAB,0x7E3F,
0xEAE4,0x7E1E,0xEA1E,0x7DFB,0xE958,0x7DD6,0xE892,0x7DB1,0xE7CD,0x7D8A,0xE707,
0x7D63,0xE642,0x7D3A,0xE57D,0x7D0F,0xE4B9,0x7CE4,0xE3F4,0x7CB7,0xE330,0x7C89,
0xE26D,0x7C5A,0xE1A9,0x7C2A,0xE0E6,0x7BF9,0xE023,0x7BC6,0xDF61,0x7B92,0xDE9E,
0x7B5D,0xDDDC,0x7B27,0xDD1B,0x7AEF,0xDC59,0x7AB7,0xDB99,0x7A7D,0xDAD8,0x7A42,
0xDA18,0x7A06,0xD958,0x79C9,0xD898,0x798A,0xD7D9,0x794A,0xD71B,0x790A,0xD65C,
0x78C8,0xD59E,0x7885,0xD4E1,0x7840,0xD424,0x77FB,0xD367,0x77B4,0xD2AB,0x776C,
0xD1EF,0x7723,0xD134,0x76D9,0xD079,0x768E,0xCFBE,0x7642,0xCF04,0x75F4,0xCE4B,
0x75A6,0xCD92,0x7556,0xCCD9,0x7505,0xCC21,0x74B3,0xCB69,0x7460,0xCAB2,0x740B,
0xC9FC,0x73B6,0xC946,0x735F,0xC890,0x7308,0xC7DB,0x72AF,0xC727,0x7255,0xC673,
0x71FA,0xC5C0,0x719E,0xC50D,0x7141,0xC45B,0x70E3,0xC3A9,0x7083,0xC2F8,0x7023,
0xC248,0x6FC2,0xC198,0x6F5F,0xC0E9,0x6EFB,0xC03A,0x6E97,0xBF8C,0x6E31,0xBEDF,
0x6DCA,0xBE32,0x6D62,0xBD86,0x6CF9,0xBCDA,0x6C8F,0xBC2F,0x6C24,0xBB85,0x6BB8,
0xBADC,0x6B4B,0xBA33,0x6ADD,0xB98B,0x6A6E,0xB8E3,0x69FD,0xB83C,0x698C,0xB796,
0x691A,0xB6F1,0x68A7,0xB64C,0x6832,0xB5A8,0x67BD,0xB505,0x6747,0xB462,0x66D0,
0xB3C0,0x6657,0xB31F,0x65DE,0xB27F,0x6564,0xB1DF,0x64E9,0xB140,0x646C,0xB0A2,
0x63EF,0xB005,0x6371,0xAF68,0x62F2,0xAECC,0x6272,0xAE31,0x61F1,0xAD97,0x616F,
0xACFD,0x60EC,0xAC65,0x6068,0xABCD,0x5FE4,0xAB36,0x5F5E,0xAAA0,0x5ED7,0xAA0A,
0x5E50,0xA976,0x5DC8,0xA8E2,0x5D3E,0xA84F,0x5CB4,0xA7BD,0x5C29,0xA72C,0x5B9D,
0xA69C,0x5B10,0xA60C,0x5A82,0xA57E,0x59F4,0xA4F0,0x5964,0xA463,0x58D4,0xA3D7,
0x5843,0xA34C,0x57B1,0xA2C2,0x571E,0xA238,0x568A,0xA1B0,0x55F6,0xA129,0x5560,
0xA0A2,0x54CA,0xA01C,0x5433,0x9F98,0x539B,0x9F14,0x5303,0x9E91,0x5269,0x9E0F,
0x51CF,0x9D8E,0x5134,0x9D0E,0x5098,0x9C8F,0x4FFB,0x9C11,0x4F5E,0x9B94,0x4EC0,
0x9B17,0x4E21,0x9A9C,0x4D81,0x9A22,0x4CE1,0x99A9,0x4C40,0x9930,0x4B9E,0x98B9,
0x4AFB,0x9843,0x4A58,0x97CE,0x49B4,0x9759,0x490F,0x96E6,0x486A,0x9674,0x47C4,
0x9603,0x471D,0x9592,0x4675,0x9523,0x45CD,0x94B5,0x4524,0x9448,0x447B,0x93DC,
0x43D1,0x9371,0x4326,0x9307,0x427A,0x929E,0x41CE,0x9236,0x4121,0x91CF,0x4074,
0x9169,0x3FC6,0x9105,0x3F17,0x90A1,0x3E68,0x903E,0x3DB8,0x8FDD,0x3D08,0x8F7D,
0x3C57,0x8F1D,0x3BA5,0x8EBF,0x3AF3,0x8E62,0x3A40,0x8E06,0x398D,0x8DAB,0x38D9,
0x8D51,0x3825,0x8CF8,0x3770,0x8CA1,0x36BA,0x8C4A,0x3604,0x8BF5,0x354E,0x8BA0,
0x3497,0x8B4D,0x33DF,0x8AFB,0x3327,0x8AAA,0x326E,0x8A5A,0x31B5,0x8A0C,0x30FC,
0x89BE,0x3042,0x8972,0x2F87,0x8927,0x2ECC,0x88DD,0x2E11,0x8894,0x2D55,0x884C,
0x2C99,0x8805,0x2BDC,0x87C0,0x2B1F,0x877B,0x2A62,0x8738,0x29A4,0x86F6,0x28E5,
0x86B6,0x2827,0x8676,0x2768,0x8637,0x26A8,0x85FA,0x25E8,0x85BE,0x2528,0x8583,
0x2467,0x8549,0x23A7,0x8511,0x22E5,0x84D9,0x2224,0x84A3,0x2162,0x846E,0x209F,
0x843A,0x1FDD,0x8407,0x1F1A,0x83D6,0x1E57,0x83A6,0x1D93,0x8377,0x1CD0,0x8349,
0x1C0C,0x831C,0x1B47,0x82F1,0x1A83,0x82C6,0x19BE,0x829D,0x18F9,0x8276,0x1833,
0x824F,0x176E,0x822A,0x16A8,0x8205,0x15E2,0x81E2,0x151C,0x81C1,0x1455,0x81A0,
0x138F,0x8181,0x12C8,0x8163,0x1201,0x8146,0x113A,0x812A,0x1073,0x8110,0x0FAB,
0x80F6,0x0EE4,0x80DE,0x0E1C,0x80C8,0x0D54,0x80B2,0x0C8C,0x809E,0x0BC4,0x808B,
0x0AFB,0x8079,0x0A33,0x8068,0x096B,0x8059,0x08A2,0x804B,0x07D9,0x803E,0x0711,
0x8032,0x0648,0x8027,0x057F,0x801E,0x04B6,0x8016,0x03ED,0x800F,0x0324,0x800A,
0x025B,0x8006,0x0192,0x8002,0x00C9,0x8001,0x7FFF,0x0000,0x7FF6,0xFCDC,0x7FD9,
0xF9B8,0x7FA7,0xF695,0x7F62,0xF374,0x7F0A,0xF055,0x7E9D,0xED38,0x7E1E,0xEA1E,
0x7D8A,0xE707,0x7CE4,0xE3F4,0x7C2A,0xE0E6,0x7B5D,0xDDDC,0x7A7D,0xDAD8,0x798A,
0xD7D9,0x7885,0xD4E1,0x776C,0xD1EF,0x7642,0xCF04,0x7505,0xCC21,0x73B6,0xC946,
0x7255,0xC673,0x70E3,0xC3A9,0x6F5F,0xC0E9,0x6DCA,0xBE32,0x6C24,0xBB85,0x6A6E,
0xB8E3,0x68A7,0xB64C,0x66D0,0xB3C0,0x64E9,0xB140,0x62F2,0xAECC,0x60EC,0xAC65,
0x5ED7,0xAA0A,0x5CB4,0xA7BD,0x5A82,0xA57E,0x5843,0xA34C,0x55F6,0xA129,0x539B,
0x9F14,0x5134,0x9D0E,0x4EC0,0x9B17,0x4C40,0x9930,0x49B4,0x9759,0x471D,0x9592,
0x447B,0x93DC,0x41CE,0x9236,0x3F17,0x90A1,0x3C57,0x8F1D,0x398D,0x8DAB,0x36BA,
0x8C4A,0x33DF,0x8AFB,0x30FC,0x89BE,0x2E11,0x8894,0x2B1F,0x877B,0x2827,0x8676,
0x2528,0x8583,0x2224,0x84A3,0x1F1A,0x83D6,0x1C0C,0x831C,0x18F9,0x8276,0x15E2,
0x81E2,0x12C8,0x8163,0x0FAB,0x80F6,0x0C8C,0x809E,0x096B,0x8059,0x0648,0x8027,
0x0324,0x800A,0x7FFF,0x0000,0x7F62,0xF374,0x7D8A,0xE707,0x7A7D,0xDAD8,0x7642,
0xCF04,0x70E3,0xC3A9,0x6A6E,0xB8E3,0x62F2,0xAECC,0x5A82,0xA57E,0x5134,0x9D0E,
0x471D,0x9592,0x3C57,0x8F1D,0x30FC,0x89BE,0x2528,0x8583,0x18F9,0x8276,0x0C8C,
0x809E,0x7FFF,0x0000,0x7642,0xCF04,0x5A82,0xA57E,0x30FC,0x89BE,};

q15_t rearranged_twiddle_stride2_1024_q15[680]={
0x7FFF,0x0000,0x7FFE,0xFE6E,0x7FF6,0xFCDC,0x7FEA,0xFB4A,0x7FD9,0xF9B8,0x7FC2,
0xF827,0x7FA7,0xF695,0x7F87,0xF505,0x7F62,0xF374,0x7F38,0xF1E4,0x7F0A,0xF055,
0x7ED6,0xEEC6,0x7E9D,0xED38,0x7E60,0xEBAB,0x7E1E,0xEA1E,0x7DD6,0xE892,0x7D8A,
0xE707,0x7D3A,0xE57D,0x7CE4,0xE3F4,0x7C89,0xE26D,0x7C2A,0xE0E6,0x7BC6,0xDF61,
0x7B5D,0xDDDC,0x7AEF,0xDC59,0x7A7D,0xDAD8,0x7A06,0xD958,0x798A,0xD7D9,0x790A,
0xD65C,0x7885,0xD4E1,0x77FB,0xD367,0x776C,0xD1EF,0x76D9,0xD079,0x7642,0xCF04,
0x75A6,0xCD92,0x7505,0xCC21,0x7460,0xCAB2,0x73B6,0xC946,0x7308,0xC7DB,0x7255,
0xC673,0x719E,0xC50D,0x70E3,0xC3A9,0x7023,0xC248,0x6F5F,0xC0E9,0x6E97,0xBF8C,
0x6DCA,0xBE32,0x6CF9,0xBCDA,0x6C24,0xBB85,0x6B4B,0xBA33,0x6A6E,0xB8E3,0x698C,
0xB796,0x68A7,0xB64C,0x67BD,0xB505,0x66D0,0xB3C0,0x65DE,0xB27F,0x64E9,0xB140,
0x63EF,0xB005,0x62F2,0xAECC,0x61F1,0xAD97,0x60EC,0xAC65,0x5FE4,0xAB36,0x5ED7,
0xAA0A,0x5DC8,0xA8E2,0x5CB4,0xA7BD,0x5B9D,0xA69C,0x5A82,0xA57E,0x5964,0xA463,
0x5843,0xA34C,0x571E,0xA238,0x55F6,0xA129,0x54CA,0xA01C,0x539B,0x9F14,0x5269,
0x9E0F,0x5134,0x9D0E,0x4FFB,0x9C11,0x4EC0,0x9B17,0x4D81,0x9A22,0x4C40,0x9930,
0x4AFB,0x9843,0x49B4,0x9759,0x486A,0x9674,0x471D,0x9592,0x45CD,0x94B5,0x447B,
0x93DC,0x4326,0x9307,0x41CE,0x9236,0x4074,0x9169,0x3F17,0x90A1,0x3DB8,0x8FDD,
0x3C57,0x8F1D,0x3AF3,0x8E62,0x398D,0x8DAB,0x3825,0x8CF8,0x36BA,0x8C4A,0x354E,
0x8BA0,0x33DF,0x8AFB,0x326E,0x8A5A,0x30FC,0x89BE,0x2F87,0x8927,0x2E11,0x8894,
0x2C99,0x8805,0x2B1F,0x877B,0x29A4,0x86F6,0x2827,0x8676,0x26A8,0x85FA,0x2528,
0x8583,0x23A7,0x8511,0x2224,0x84A3,0x209F,0x843A,0x1F1A,0x83D6,0x1D93,0x8377,
0x1C0C,0x831C,0x1A83,0x82C6,0x18F9,0x8276,0x176E,0x822A,0x15E2,0x81E2,0x1455,
0x81A0,0x12C8,0x8163,0x113A,0x812A,0x0FAB,0x80F6,0x0E1C,0x80C8,0x0C8C,0x809E,
0x0AFB,0x8079,0x096B,0x8059,0x07D9,0x803E,0x0648,0x8027,0x04B6,0x8016,0x0324,
0x800A,0x0192,0x8002,0x0000,0x8000,0xFE6E,0x8002,0xFCDC,0x800A,0xFB4A,0x8016,
0xF9B8,0x8027,0xF827,0x803E,0xF695,0x8059,0xF505,0x8079,0xF374,0x809E,0xF1E4,
0x80C8,0xF055,0x80F6,0xEEC6,0x812A,0xED38,0x8163,0xEBAB,0x81A0,0xEA1E,0x81E2,
0xE892,0x822A,0xE707,0x8276,0xE57D,0x82C6,0xE3F4,0x831C,0xE26D,0x8377,0xE0E6,
0x83D6,0xDF61,0x843A,0xDDDC,0x84A3,0xDC59,0x8511,0xDAD8,0x8583,0xD958,0x85FA,
0xD7D9,0x8676,0xD65C,0x86F6,0xD4E1,0x877B,0xD367,0x8805,0xD1EF,0x8894,0xD079,
0x8927,0xCF04,0x89BE,0xCD92,0x8A5A,0xCC21,0x8AFB,0xCAB2,0x8BA0,0xC946,0x8C4A,
0xC7DB,0x8CF8,0xC673,0x8DAB,0xC50D,0x8E62,0xC3A9,0x8F1D,0xC248,0x8FDD,0xC0E9,
0x90A1,0xBF8C,0x9169,0xBE32,0x9236,0xBCDA,0x9307,0xBB85,0x93DC,0xBA33,0x94B5,
0xB8E3,0x9592,0xB796,0x9674,0xB64C,0x9759,0xB505,0x9843,0xB3C0,0x9930,0xB27F,
0x9A22,0xB140,0x9B17,0xB005,0x9C11,0xAECC,0x9D0E,0xAD97,0x9E0F,0xAC65,0x9F14,
0xAB36,0xA01C,0xAA0A,0xA129,0xA8E2,0xA238,0xA7BD,0xA34C,0xA69C,0xA463,0xA57E,
0xA57E,0xA463,0xA69C,0xA34C,0xA7BD,0xA238,0xA8E2,0xA129,0xAA0A,0xA01C,0xAB36,
0x9F14,0xAC65,0x9E0F,0xAD97,0x9D0E,0xAECC,0x9C11,0xB005,0x9B17,0xB140,0x9A22,
0xB27F,0x9930,0xB3C0,0x9843,0xB505,0x9759,0xB64C,0x9674,0xB796,0x9592,0xB8E3,
0x94B5,0xBA33,0x93DC,0xBB85,0x9307,0xBCDA,0x9236,0xBE32,0x9169,0xBF8C,0x90A1,
0xC0E9,0x8FDD,0xC248,0x8F1D,0xC3A9,0x8E62,0xC50D,0x8DAB,0xC673,0x8CF8,0xC7DB,
0x8C4A,0xC946,0x8BA0,0xCAB2,0x8AFB,0xCC21,0x8A5A,0xCD92,0x89BE,0xCF04,0x8927,
0xD079,0x8894,0xD1EF,0x8805,0xD367,0x877B,0xD4E1,0x86F6,0xD65C,0x8676,0xD7D9,
0x85FA,0xD958,0x8583,0xDAD8,0x8511,0xDC59,0x84A3,0xDDDC,0x843A,0xDF61,0x83D6,
0xE0E6,0x8377,0xE26D,0x831C,0xE3F4,0x82C6,0xE57D,0x8276,0xE707,0x822A,0xE892,
0x81E2,0xEA1E,0x81A0,0xEBAB,0x8163,0xED38,0x812A,0xEEC6,0x80F6,0xF055,0x80C8,
0xF1E4,0x809E,0xF374,0x8079,0xF505,0x8059,0xF695,0x803E,0xF827,0x8027,0xF9B8,
0x8016,0xFB4A,0x800A,0xFCDC,0x8002,0xFE6E,0x7FFF,0x0000,0x7FD9,0xF9B8,0x7F62,
0xF374,0x7E9D,0xED38,0x7D8A,0xE707,0x7C2A,0xE0E6,0x7A7D,0xDAD8,0x7885,0xD4E1,
0x7642,0xCF04,0x73B6,0xC946,0x70E3,0xC3A9,0x6DCA,0xBE32,0x6A6E,0xB8E3,0x66D0,
0xB3C0,0x62F2,0xAECC,0x5ED7,0xAA0A,0x5A82,0xA57E,0x55F6,0xA129,0x5134,0x9D0E,
0x4C40,0x9930,0x471D,0x9592,0x41CE,0x9236,0x3C57,0x8F1D,0x36BA,0x8C4A,0x30FC,
0x89BE,0x2B1F,0x877B,0x2528,0x8583,0x1F1A,0x83D6,0x18F9,0x8276,0x12C8,0x8163,
0x0C8C,0x809E,0x0648,0x8027,0x0000,0x8000,0xF9B8,0x8027,0xF374,0x809E,0xED38,
0x8163,0xE707,0x8276,0xE0E6,0x83D6,0xDAD8,0x8583,0xD4E1,0x877B,0xCF04,0x89BE,
0xC946,0x8C4A,0xC3A9,0x8F1D,0xBE32,0x9236,0xB8E3,0x9592,0xB3C0,0x9930,0xAECC,
0x9D0E,0xAA0A,0xA129,0xA57E,0xA57E,0xA129,0xAA0A,0x9D0E,0xAECC,0x9930,0xB3C0,
0x9592,0xB8E3,0x9236,0xBE32,0x8F1D,0xC3A9,0x8C4A,0xC946,0x89BE,0xCF04,0x877B,
0xD4E1,0x8583,0xDAD8,0x83D6,0xE0E6,0x8276,0xE707,0x8163,0xED38,0x809E,0xF374,
0x8027,0xF9B8,0x7FFF,0x0000,0x7D8A,0xE707,0x7642,0xCF04,0x6A6E,0xB8E3,0x5A82,
0xA57E,0x471D,0x9592,0x30FC,0x89BE,0x18F9,0x8276,0x0000,0x8000,0xE707,0x8276,
0xCF04,0x89BE,0xB8E3,0x9592,0xA57E,0xA57E,0x9592,0xB8E3,0x89BE,0xCF04,0x8276,
0xE707,0x7FFF,0x0000,0x5A82,0xA57E,0x0000,0x8000,0xA57E,0xA57E,};

q15_t rearranged_twiddle_stride3_1024_q15[680]={
0x7FFF,0x0000,0x7FFA,0xFDA5,0x7FEA,0xFB4A,0x7FCE,0xF8EF,0x7FA7,0xF695,0x7F75,
0xF43C,0x7F38,0xF1E4,0x7EF0,0xEF8D,0x7E9D,0xED38,0x7E3F,0xEAE4,0x7DD6,0xE892,
0x7D63,0xE642,0x7CE4,0xE3F4,0x7C5A,0xE1A9,0x7BC6,0xDF61,0x7B27,0xDD1B,0x7A7D,
0xDAD8,0x79C9,0xD898,0x790A,0xD65C,0x7840,0xD424,0x776C,0xD1EF,0x768E,0xCFBE,
0x75A6,0xCD92,0x74B3,0xCB69,0x73B6,0xC946,0x72AF,0xC727,0x719E,0xC50D,0x7083,
0xC2F8,0x6F5F,0xC0E9,0x6E31,0xBEDF,0x6CF9,0xBCDA,0x6BB8,0xBADC,0x6A6E,0xB8E3,
0x691A,0xB6F1,0x67BD,0xB505,0x6657,0xB31F,0x64E9,0xB140,0x6371,0xAF68,0x61F1,
0xAD97,0x6068,0xABCD,0x5ED7,0xAA0A,0x5D3E,0xA84F,0x5B9D,0xA69C,0x59F4,0xA4F0,
0x5843,0xA34C,0x568A,0xA1B0,0x54CA,0xA01C,0x5303,0x9E91,0x5134,0x9D0E,0x4F5E,
0x9B94,0x4D81,0x9A22,0x4B9E,0x98B9,0x49B4,0x9759,0x47C4,0x9603,0x45CD,0x94B5,
0x43D1,0x9371,0x41CE,0x9236,0x3FC6,0x9105,0x3DB8,0x8FDD,0x3BA5,0x8EBF,0x398D,
0x8DAB,0x3770,0x8CA1,0x354E,0x8BA0,0x3327,0x8AAA,0x30FC,0x89BE,0x2ECC,0x88DD,
0x2C99,0x8805,0x2A62,0x8738,0x2827,0x8676,0x25E8,0x85BE,0x23A7,0x8511,0x2162,
0x846E,0x1F1A,0x83D6,0x1CD0,0x8349,0x1A83,0x82C6,0x1833,0x824F,0x15E2,0x81E2,
0x138F,0x8181,0x113A,0x812A,0x0EE4,0x80DE,0x0C8C,0x809E,0x0A33,0x8068,0x07D9,
0x803E,0x057F,0x801E,0x0324,0x800A,0x00C9,0x8001,0xFE6E,0x8002,0xFC13,0x800F,
0xF9B8,0x8027,0xF75E,0x804B,0xF505,0x8079,0xF2AC,0x80B2,0xF055,0x80F6,0xEDFF,
0x8146,0xEBAB,0x81A0,0xE958,0x8205,0xE707,0x8276,0xE4B9,0x82F1,0xE26D,0x8377,
0xE023,0x8407,0xDDDC,0x84A3,0xDB99,0x8549,0xD958,0x85FA,0xD71B,0x86B6,0xD4E1,
0x877B,0xD2AB,0x884C,0xD079,0x8927,0xCE4B,0x8A0C,0xCC21,0x8AFB,0xC9FC,0x8BF5,
0xC7DB,0x8CF8,0xC5C0,0x8E06,0xC3A9,0x8F1D,0xC198,0x903E,0xBF8C,0x9169,0xBD86,
0x929E,0xBB85,0x93DC,0xB98B,0x9523,0xB796,0x9674,0xB5A8,0x97CE,0xB3C0,0x9930,
0xB1DF,0x9A9C,0xB005,0x9C11,0xAE31,0x9D8E,0xAC65,0x9F14,0xAAA0,0xA0A2,0xA8E2,
0xA238,0xA72C,0xA3D7,0xA57E,0xA57E,0xA3D7,0xA72C,0xA238,0xA8E2,0xA0A2,0xAAA0,
0x9F14,0xAC65,0x9D8E,0xAE31,0x9C11,0xB005,0x9A9C,0xB1DF,0x9930,0xB3C0,0x97CE,
0xB5A8,0x9674,0xB796,0x9523,0xB98B,0x93DC,0xBB85,0x929E,0xBD86,0x9169,0xBF8C,
0x903E,0xC198,0x8F1D,0xC3A9,0x8E06,0xC5C0,0x8CF8,0xC7DB,0x8BF5,0xC9FC,0x8AFB,
0xCC21,0x8A0C,0xCE4B,0x8927,0xD079,0x884C,0xD2AB,0x877B,0xD4E1,0x86B6,0xD71B,
0x85FA,0xD958,0x8549,0xDB99,0x84A3,0xDDDC,0x8407,0xE023,0x8377,0xE26D,0x82F1,
0xE4B9,0x8276,0xE707,0x8205,0xE958,0x81A0,0xEBAB,0x8146,0xEDFF,0x80F6,0xF055,
0x80B2,0xF2AC,0x8079,0xF505,0x804B,0xF75E,0x8027,0xF9B8,0x800F,0xFC13,0x8002,
0xFE6E,0x8001,0x00C9,0x800A,0x0324,0x801E,0x057F,0x803E,0x07D9,0x8068,0x0A33,
0x809E,0x0C8C,0x80DE,0x0EE4,0x812A,0x113A,0x8181,0x138F,0x81E2,0x15E2,0x824F,
0x1833,0x82C6,0x1A83,0x8349,0x1CD0,0x83D6,0x1F1A,0x846E,0x2162,0x8511,0x23A7,
0x85BE,0x25E8,0x8676,0x2827,0x8738,0x2A62,0x8805,0x2C99,0x88DD,0x2ECC,0x89BE,
0x30FC,0x8AAA,0x3327,0x8BA0,0x354E,0x8CA1,0x3770,0x8DAB,0x398D,0x8EBF,0x3BA5,
0x8FDD,0x3DB8,0x9105,0x3FC6,0x9236,0x41CE,0x9371,0x43D1,0x94B5,0x45CD,0x9603,
0x47C4,0x9759,0x49B4,0x98B9,0x4B9E,0x9A22,0x4D81,0x9B94,0x4F5E,0x9D0E,0x5134,
0x9E91,0x5303,0xA01C,0x54CA,0xA1B0,0x568A,0xA34C,0x5843,0xA4F0,0x59F4,0xA69C,
0x5B9D,0xA84F,0x5D3E,0xAA0A,0x5ED7,0xABCD,0x6068,0xAD97,0x61F1,0xAF68,0x6371,
0xB140,0x64E9,0xB31F,0x6657,0xB505,0x67BD,0xB6F1,0x691A,0xB8E3,0x6A6E,0xBADC,
0x6BB8,0xBCDA,0x6CF9,0xBEDF,0x6E31,0xC0E9,0x6F5F,0xC2F8,0x7083,0xC50D,0x719E,
0xC727,0x72AF,0xC946,0x73B6,0xCB69,0x74B3,0xCD92,0x75A6,0xCFBE,0x768E,0xD1EF,
0x776C,0xD424,0x7840,0xD65C,0x790A,0xD898,0x79C9,0xDAD8,0x7A7D,0xDD1B,0x7B27,
0xDF61,0x7BC6,0xE1A9,0x7C5A,0xE3F4,0x7CE4,0xE642,0x7D63,0xE892,0x7DD6,0xEAE4,
0x7E3F,0xED38,0x7E9D,0xEF8D,0x7EF0,0xF1E4,0x7F38,0xF43C,0x7F75,0xF695,0x7FA7,
0xF8EF,0x7FCE,0xFB4A,0x7FEA,0xFDA5,0x7FFA,0x7FFF,0x0000,0x7FA7,0xF695,0x7E9D,
0xED38,0x7CE4,0xE3F4,0x7A7D,0xDAD8,0x776C,0xD1EF,0x73B6,0xC946,0x6F5F,0xC0E9,
0x6A6E,0xB8E3,0x64E9,0xB140,0x5ED7,0xAA0A,0x5843,0xA34C,0x5134,0x9D0E,0x49B4,
0x9759,0x41CE,0x9236,0x398D,0x8DAB,0x30FC,0x89BE,0x2827,0x8676,0x1F1A,0x83D6,
0x15E2,0x81E2,0x0C8C,0x809E,0x0324,0x800A,0xF9B8,0x8027,0xF055,0x80F6,0xE707,
0x8276,0xDDDC,0x84A3,0xD4E1,0x877B,0xCC21,0x8AFB,0xC3A9,0x8F1D,0xBB85,0x93DC,
0xB3C0,0x9930,0xAC65,0x9F14,0xA57E,0xA57E,0x9F14,0xAC65,0x9930,0xB3C0,0x93DC,
0xBB85,0x8F1D,0xC3A9,0x8AFB,0xCC21,0x877B,0xD4E1,0x84A3,0xDDDC,0x8276,0xE707,
0x80F6,0xF055,0x8027,0xF9B8,0x800A,0x0324,0x809E,0x0C8C,0x81E2,0x15E2,0x83D6,
0x1F1A,0x8676,0x2827,0x89BE,0x30FC,0x8DAB,0x398D,0x9236,0x41CE,0x9759,0x49B4,
0x9D0E,0x5134,0xA34C,0x5843,0xAA0A,0x5ED7,0xB140,0x64E9,0xB8E3,0x6A6E,0xC0E9,
0x6F5F,0xC946,0x73B6,0xD1EF,0x776C,0xDAD8,0x7A7D,0xE3F4,0x7CE4,0xED38,0x7E9D,
0xF695,0x7FA7,0x7FFF,0x0000,0x7A7D,0xDAD8,0x6A6E,0xB8E3,0x5134,0x9D0E,0x30FC,
0x89BE,0x0C8C,0x809E,0xE707,0x8276,0xC3A9,0x8F1D,0xA57E,0xA57E,0x8F1D,0xC3A9,
0x8276,0xE707,0x809E,0x0C8C,0x89BE,0x30FC,0x9D0E,0x5134,0xB8E3,0x6A6E,0xDAD8,
0x7A7D,0x7FFF,0x0000,0x30FC,0x89BE,0xA57E,0xA57E,0x89BE,0x30FC,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_Q15_4096) || defined(ARM_TABLE_TWIDDLECOEF_Q15_8192)

uint32_t rearranged_twiddle_tab_stride1_arr_4096_q15[6]={
0,2048,2560,2688,2720,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_4096_q15[6]={
0,2048,2560,2688,2720,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_4096_q15[6]={
0,2048,2560,2688,2720,0,};

q15_t rearranged_twiddle_stride1_4096_q15[2728]={
0x7FFF,0x0000,0x7FFF,0xFFCE,0x7FFF,0xFF9B,0x7FFF,0xFF69,0x7FFF,0xFF37,0x7FFF,
0xFF05,0x7FFF,0xFED2,0x7FFE,0xFEA0,0x7FFE,0xFE6E,0x7FFD,0xFE3C,0x7FFC,0xFE09,
0x7FFB,0xFDD7,0x7FFA,0xFDA5,0x7FF9,0xFD73,0x7FF8,0xFD40,0x7FF7,0xFD0E,0x7FF6,
0xFCDC,0x7FF5,0xFCAA,0x7FF4,0xFC77,0x7FF2,0xFC45,0x7FF1,0xFC13,0x7FEF,0xFBE1,
0x7FED,0xFBAE,0x7FEC,0xFB7C,0x7FEA,0xFB4A,0x7FE8,0xFB18,0x7FE6,0xFAE5,0x7FE4,
0xFAB3,0x7FE2,0xFA81,0x7FE0,0xFA4F,0x7FDD,0xFA1D,0x7FDB,0xF9EA,0x7FD9,0xF9B8,
0x7FD6,0xF986,0x7FD3,0xF954,0x7FD1,0xF922,0x7FCE,0xF8EF,0x7FCB,0xF8BD,0x7FC8,
0xF88B,0x7FC5,0xF859,0x7FC2,0xF827,0x7FBF,0xF7F4,0x7FBC,0xF7C2,0x7FB9,0xF790,
0x7FB5,0xF75E,0x7FB2,0xF72C,0x7FAE,0xF6FA,0x7FAB,0xF6C8,0x7FA7,0xF695,0x7FA3,
0xF663,0x7FA0,0xF631,0x7F9C,0xF5FF,0x7F98,0xF5CD,0x7F94,0xF59B,0x7F90,0xF569,
0x7F8B,0xF537,0x7F87,0xF505,0x7F83,0xF4D3,0x7F7E,0xF4A0,0x7F7A,0xF46E,0x7F75,
0xF43C,0x7F71,0xF40A,0x7F6C,0xF3D8,0x7F67,0xF3A6,0x7F62,0xF374,0x7F5D,0xF342,
0x7F58,0xF310,0x7F53,0xF2DE,0x7F4E,0xF2AC,0x7F49,0xF27A,0x7F43,0xF248,0x7F3E,
0xF216,0x7F38,0xF1E4,0x7F33,0xF1B2,0x7F2D,0xF180,0x7F27,0xF14E,0x7F22,0xF11C,
0x7F1C,0xF0EB,0x7F16,0xF0B9,0x7F10,0xF087,0x7F0A,0xF055,0x7F03,0xF023,0x7EFD,
0xEFF1,0x7EF7,0xEFBF,0x7EF0,0xEF8D,0x7EEA,0xEF5C,0x7EE3,0xEF2A,0x7EDD,0xEEF8,
0x7ED6,0xEEC6,0x7ECF,0xEE94,0x7EC8,0xEE62,0x7EC1,0xEE31,0x7EBA,0xEDFF,0x7EB3,
0xEDCD,0x7EAC,0xED9B,0x7EA5,0xED6A,0x7E9D,0xED38,0x7E96,0xED06,0x7E8E,0xECD5,
0x7E87,0xECA3,0x7E7F,0xEC71,0x7E78,0xEC3F,0x7E70,0xEC0E,0x7E68,0xEBDC,0x7E60,
0xEBAB,0x7E58,0xEB79,0x7E50,0xEB47,0x7E48,0xEB16,0x7E3F,0xEAE4,0x7E37,0xEAB3,
0x7E2F,0xEA81,0x7E26,0xEA4F,0x7E1E,0xEA1E,0x7E15,0xE9EC,0x7E0C,0xE9BB,0x7E03,
0xE989,0x7DFB,0xE958,0x7DF2,0xE926,0x7DE9,0xE8F5,0x7DE0,0xE8C4,0x7DD6,0xE892,
0x7DCD,0xE861,0x7DC4,0xE82F,0x7DBA,0xE7FE,0x7DB1,0xE7CD,0x7DA7,0xE79B,0x7D9E,
0xE76A,0x7D94,0xE739,0x7D8A,0xE707,0x7D81,0xE6D6,0x7D77,0xE6A5,0x7D6D,0xE673,
0x7D63,0xE642,0x7D58,0xE611,0x7D4E,0xE5E0,0x7D44,0xE5AF,0x7D3A,0xE57D,0x7D2F,
0xE54C,0x7D25,0xE51B,0x7D1A,0xE4EA,0x7D0F,0xE4B9,0x7D05,0xE488,0x7CFA,0xE457,
0x7CEF,0xE426,0x7CE4,0xE3F4,0x7CD9,0xE3C3,0x7CCE,0xE392,0x7CC2,0xE361,0x7CB7,
0xE330,0x7CAC,0xE2FF,0x7CA0,0xE2CF,0x7C95,0xE29E,0x7C89,0xE26D,0x7C7E,0xE23C,
0x7C72,0xE20B,0x7C66,0xE1DA,0x7C5A,0xE1A9,0x7C4E,0xE178,0x7C42,0xE148,0x7C36,
0xE117,0x7C2A,0xE0E6,0x7C1E,0xE0B5,0x7C11,0xE085,0x7C05,0xE054,0x7BF9,0xE023,
0x7BEC,0xDFF2,0x7BDF,0xDFC2,0x7BD3,0xDF91,0x7BC6,0xDF61,0x7BB9,0xDF30,0x7BAC,
0xDEFF,0x7B9F,0xDECF,0x7B92,0xDE9E,0x7B85,0xDE6E,0x7B78,0xDE3D,0x7B6A,0xDE0D,
0x7B5D,0xDDDC,0x7B50,0xDDAC,0x7B42,0xDD7C,0x7B34,0xDD4B,0x7B27,0xDD1B,0x7B19,
0xDCEA,0x7B0B,0xDCBA,0x7AFD,0xDC8A,0x7AEF,0xDC59,0x7AE1,0xDC29,0x7AD3,0xDBF9,
0x7AC5,0xDBC9,0x7AB7,0xDB99,0x7AA8,0xDB68,0x7A9A,0xDB38,0x7A8C,0xDB08,0x7A7D,
0xDAD8,0x7A6E,0xDAA8,0x7A60,0xDA78,0x7A51,0xDA48,0x7A42,0xDA18,0x7A33,0xD9E8,
0x7A24,0xD9B8,0x7A15,0xD988,0x7A06,0xD958,0x79F7,0xD928,0x79E7,0xD8F8,0x79D8,
0xD8C8,0x79C9,0xD898,0x79B9,0xD869,0x79AA,0xD839,0x799A,0xD809,0x798A,0xD7D9,
0x797A,0xD7AA,0x796A,0xD77A,0x795B,0xD74A,0x794A,0xD71B,0x793A,0xD6EB,0x792A,
0xD6BB,0x791A,0xD68C,0x790A,0xD65C,0x78F9,0xD62D,0x78E9,0xD5FD,0x78D8,0xD5CE,
0x78C8,0xD59E,0x78B7,0xD56F,0x78A6,0xD53F,0x7895,0xD510,0x7885,0xD4E1,0x7874,
0xD4B1,0x7863,0xD482,0x7851,0xD453,0x7840,0xD424,0x782F,0xD3F4,0x781E,0xD3C5,
0x780C,0xD396,0x77FB,0xD367,0x77E9,0xD338,0x77D8,0xD309,0x77C6,0xD2DA,0x77B4,
0xD2AB,0x77A2,0xD27C,0x7790,0xD24D,0x777E,0xD21E,0x776C,0xD1EF,0x775A,0xD1C0,
0x7748,0xD191,0x7736,0xD162,0x7723,0xD134,0x7711,0xD105,0x76FE,0xD0D6,0x76EC,
0xD0A7,0x76D9,0xD079,0x76C7,0xD04A,0x76B4,0xD01B,0x76A1,0xCFED,0x768E,0xCFBE,
0x767B,0xCF90,0x7668,0xCF61,0x7655,0xCF33,0x7642,0xCF04,0x762E,0xCED6,0x761B,
0xCEA7,0x7608,0xCE79,0x75F4,0xCE4B,0x75E1,0xCE1C,0x75CD,0xCDEE,0x75B9,0xCDC0,
0x75A6,0xCD92,0x7592,0xCD63,0x757E,0xCD35,0x756A,0xCD07,0x7556,0xCCD9,0x7542,
0xCCAB,0x752D,0xCC7D,0x7519,0xCC4F,0x7505,0xCC21,0x74F0,0xCBF3,0x74DC,0xCBC5,
0x74C7,0xCB97,0x74B3,0xCB69,0x749E,0xCB3C,0x7489,0xCB0E,0x7475,0xCAE0,0x7460,
0xCAB2,0x744B,0xCA85,0x7436,0xCA57,0x7421,0xCA29,0x740B,0xC9FC,0x73F6,0xC9CE,
0x73E1,0xC9A1,0x73CB,0xC973,0x73B6,0xC946,0x73A0,0xC918,0x738B,0xC8EB,0x7375,
0xC8BE,0x735F,0xC890,0x734A,0xC863,0x7334,0xC836,0x731E,0xC809,0x7308,0xC7DB,
0x72F2,0xC7AE,0x72DC,0xC781,0x72C5,0xC754,0x72AF,0xC727,0x7299,0xC6FA,0x7282,
0xC6CD,0x726C,0xC6A0,0x7255,0xC673,0x723F,0xC646,0x7228,0xC619,0x7211,0xC5ED,
0x71FA,0xC5C0,0x71E3,0xC593,0x71CC,0xC566,0x71B5,0xC53A,0x719E,0xC50D,0x7187,
0xC4E0,0x7170,0xC4B4,0x7158,0xC487,0x7141,0xC45B,0x712A,0xC42E,0x7112,0xC402,
0x70FA,0xC3D6,0x70E3,0xC3A9,0x70CB,0xC37D,0x70B3,0xC351,0x709B,0xC324,0x7083,
0xC2F8,0x706B,0xC2CC,0x7053,0xC2A0,0x703B,0xC274,0x7023,0xC248,0x700B,0xC21C,
0x6FF2,0xC1F0,0x6FDA,0xC1C4,0x6FC2,0xC198,0x6FA9,0xC16C,0x6F90,0xC140,0x6F78,
0xC114,0x6F5F,0xC0E9,0x6F46,0xC0BD,0x6F2D,0xC091,0x6F14,0xC066,0x6EFB,0xC03A,
0x6EE2,0xC00F,0x6EC9,0xBFE3,0x6EB0,0xBFB8,0x6E97,0xBF8C,0x6E7D,0xBF61,0x6E64,
0xBF35,0x6E4A,0xBF0A,0x6E31,0xBEDF,0x6E17,0xBEB3,0x6DFE,0xBE88,0x6DE4,0xBE5D,
0x6DCA,0xBE32,0x6DB0,0xBE07,0x6D96,0xBDDC,0x6D7C,0xBDB1,0x6D62,0xBD86,0x6D48,
0xBD5B,0x6D2E,0xBD30,0x6D14,0xBD05,0x6CF9,0xBCDA,0x6CDF,0xBCAF,0x6CC4,0xBC85,
0x6CAA,0xBC5A,0x6C8F,0xBC2F,0x6C75,0xBC05,0x6C5A,0xBBDA,0x6C3F,0xBBB0,0x6C24,
0xBB85,0x6C09,0xBB5B,0x6BEE,0xBB30,0x6BD3,0xBB06,0x6BB8,0xBADC,0x6B9D,0xBAB1,
0x6B82,0xBA87,0x6B66,0xBA5D,0x6B4B,0xBA33,0x6B30,0xBA09,0x6B14,0xB9DF,0x6AF8,
0xB9B5,0x6ADD,0xB98B,0x6AC1,0xB961,0x6AA5,0xB937,0x6A89,0xB90D,0x6A6E,0xB8E3,
0x6A52,0xB8B9,0x6A36,0xB890,0x6A1A,0xB866,0x69FD,0xB83C,0x69E1,0xB813,0x69C5,
0xB7E9,0x69A9,0xB7C0,0x698C,0xB796,0x6970,0xB76D,0x6953,0xB743,0x6937,0xB71A,
0x691A,0xB6F1,0x68FD,0xB6C7,0x68E0,0xB69E,0x68C4,0xB675,0x68A7,0xB64C,0x688A,
0xB623,0x686D,0xB5FA,0x6850,0xB5D1,0x6832,0xB5A8,0x6815,0xB57F,0x67F8,0xB556,
0x67DA,0xB52D,0x67BD,0xB505,0x67A0,0xB4DC,0x6782,0xB4B3,0x6764,0xB48B,0x6747,
0xB462,0x6729,0xB439,0x670B,0xB411,0x66ED,0xB3E9,0x66D0,0xB3C0,0x66B2,0xB398,
0x6693,0xB36F,0x6675,0xB347,0x6657,0xB31F,0x6639,0xB2F7,0x661B,0xB2CF,0x65FC,
0xB2A7,0x65DE,0xB27F,0x65C0,0xB257,0x65A1,0xB22F,0x6582,0xB207,0x6564,0xB1DF,
0x6545,0xB1B7,0x6526,0xB18F,0x6507,0xB168,0x64E9,0xB140,0x64CA,0xB118,0x64AB,
0xB0F1,0x648B,0xB0C9,0x646C,0xB0A2,0x644D,0xB07B,0x642E,0xB053,0x640F,0xB02C,
0x63EF,0xB005,0x63D0,0xAFDD,0x63B0,0xAFB6,0x6391,0xAF8F,0x6371,0xAF68,0x6351,
0xAF41,0x6332,0xAF1A,0x6312,0xAEF3,0x62F2,0xAECC,0x62D2,0xAEA5,0x62B2,0xAE7F,
0x6292,0xAE58,0x6272,0xAE31,0x6252,0xAE0B,0x6232,0xADE4,0x6211,0xADBD,0x61F1,
0xAD97,0x61D1,0xAD70,0x61B0,0xAD4A,0x6190,0xAD24,0x616F,0xACFD,0x614E,0xACD7,
0x612E,0xACB1,0x610D,0xAC8B,0x60EC,0xAC65,0x60CB,0xAC3F,0x60AA,0xAC19,0x6089,
0xABF3,0x6068,0xABCD,0x6047,0xABA7,0x6026,0xAB81,0x6005,0xAB5C,0x5FE4,0xAB36,
0x5FC2,0xAB10,0x5FA1,0xAAEB,0x5F80,0xAAC5,0x5F5E,0xAAA0,0x5F3C,0xAA7A,0x5F1B,
0xAA55,0x5EF9,0xAA30,0x5ED7,0xAA0A,0x5EB6,0xA9E5,0x5E94,0xA9C0,0x5E72,0xA99B,
0x5E50,0xA976,0x5E2E,0xA951,0x5E0C,0xA92C,0x5DEA,0xA907,0x5DC8,0xA8E2,0x5DA5,
0xA8BD,0x5D83,0xA899,0x5D61,0xA874,0x5D3E,0xA84F,0x5D1C,0xA82B,0x5CF9,0xA806,
0x5CD7,0xA7E2,0x5CB4,0xA7BD,0x5C91,0xA799,0x5C6F,0xA774,0x5C4C,0xA750,0x5C29,
0xA72C,0x5C06,0xA708,0x5BE3,0xA6E4,0x5BC0,0xA6C0,0x5B9D,0xA69C,0x5B7A,0xA678,
0x5B57,0xA654,0x5B34,0xA630,0x5B10,0xA60C,0x5AED,0xA5E8,0x5AC9,0xA5C5,0x5AA6,
0xA5A1,0x5A82,0xA57E,0x5A5F,0xA55A,0x5A3B,0xA537,0x5A18,0xA513,0x59F4,0xA4F0,
0x59D0,0xA4CC,0x59AC,0xA4A9,0x5988,0xA486,0x5964,0xA463,0x5940,0xA440,0x591C,
0xA41D,0x58F8,0xA3FA,0x58D4,0xA3D7,0x58B0,0xA3B4,0x588C,0xA391,0x5867,0xA36F,
0x5843,0xA34C,0x581E,0xA329,0x57FA,0xA307,0x57D5,0xA2E4,0x57B1,0xA2C2,0x578C,
0xA29F,0x5767,0xA27D,0x5743,0xA25B,0x571E,0xA238,0x56F9,0xA216,0x56D4,0xA1F4,
0x56AF,0xA1D2,0x568A,0xA1B0,0x5665,0xA18E,0x5640,0xA16C,0x561B,0xA14A,0x55F6,
0xA129,0x55D0,0xA107,0x55AB,0xA0E5,0x5586,0xA0C4,0x5560,0xA0A2,0x553B,0xA080,
0x5515,0xA05F,0x54F0,0xA03E,0x54CA,0xA01C,0x54A4,0x9FFB,0x547F,0x9FDA,0x5459,
0x9FB9,0x5433,0x9F98,0x540D,0x9F77,0x53E7,0x9F56,0x53C1,0x9F35,0x539B,0x9F14,
0x5375,0x9EF3,0x534F,0x9ED2,0x5329,0x9EB2,0x5303,0x9E91,0x52DC,0x9E70,0x52B6,
0x9E50,0x5290,0x9E2F,0x5269,0x9E0F,0x5243,0x9DEF,0x521C,0x9DCE,0x51F5,0x9DAE,
0x51CF,0x9D8E,0x51A8,0x9D6E,0x5181,0x9D4E,0x515B,0x9D2E,0x5134,0x9D0E,0x510D,
0x9CEE,0x50E6,0x9CCE,0x50BF,0x9CAF,0x5098,0x9C8F,0x5071,0x9C6F,0x504A,0x9C50,
0x5023,0x9C30,0x4FFB,0x9C11,0x4FD4,0x9BF1,0x4FAD,0x9BD2,0x4F85,0x9BB3,0x4F5E,
0x9B94,0x4F37,0x9B75,0x4F0F,0x9B55,0x4EE8,0x9B36,0x4EC0,0x9B17,0x4E98,0x9AF9,
0x4E71,0x9ADA,0x4E49,0x9ABB,0x4E21,0x9A9C,0x4DF9,0x9A7E,0x4DD1,0x9A5F,0x4DA9,
0x9A40,0x4D81,0x9A22,0x4D59,0x9A04,0x4D31,0x99E5,0x4D09,0x99C7,0x4CE1,0x99A9,
0x4CB9,0x998B,0x4C91,0x996D,0x4C68,0x994E,0x4C40,0x9930,0x4C17,0x9913,0x4BEF,
0x98F5,0x4BC7,0x98D7,0x4B9E,0x98B9,0x4B75,0x989C,0x4B4D,0x987E,0x4B24,0x9860,
0x4AFB,0x9843,0x4AD3,0x9826,0x4AAA,0x9808,0x4A81,0x97EB,0x4A58,0x97CE,0x4A2F,
0x97B0,0x4A06,0x9793,0x49DD,0x9776,0x49B4,0x9759,0x498B,0x973C,0x4962,0x9720,
0x4939,0x9703,0x490F,0x96E6,0x48E6,0x96C9,0x48BD,0x96AD,0x4893,0x9690,0x486A,
0x9674,0x4840,0x9657,0x4817,0x963B,0x47ED,0x961F,0x47C4,0x9603,0x479A,0x95E6,
0x4770,0x95CA,0x4747,0x95AE,0x471D,0x9592,0x46F3,0x9577,0x46C9,0x955B,0x469F,
0x953F,0x4675,0x9523,0x464B,0x9508,0x4621,0x94EC,0x45F7,0x94D0,0x45CD,0x94B5,
0x45A3,0x949A,0x4579,0x947E,0x454F,0x9463,0x4524,0x9448,0x44FA,0x942D,0x44D0,
0x9412,0x44A5,0x93F7,0x447B,0x93DC,0x4450,0x93C1,0x4426,0x93A6,0x43FB,0x938B,
0x43D1,0x9371,0x43A6,0x9356,0x437B,0x933C,0x4351,0x9321,0x4326,0x9307,0x42FB,
0x92EC,0x42D0,0x92D2,0x42A5,0x92B8,0x427A,0x929E,0x424F,0x9284,0x4224,0x926A,
0x41F9,0x9250,0x41CE,0x9236,0x41A3,0x921C,0x4178,0x9202,0x414D,0x91E9,0x4121,
0x91CF,0x40F6,0x91B6,0x40CB,0x919C,0x409F,0x9183,0x4074,0x9169,0x4048,0x9150,
0x401D,0x9137,0x3FF1,0x911E,0x3FC6,0x9105,0x3F9A,0x90EC,0x3F6F,0x90D3,0x3F43,
0x90BA,0x3F17,0x90A1,0x3EEC,0x9088,0x3EC0,0x9070,0x3E94,0x9057,0x3E68,0x903E,
0x3E3C,0x9026,0x3E10,0x900E,0x3DE4,0x8FF5,0x3DB8,0x8FDD,0x3D8C,0x8FC5,0x3D60,
0x8FAD,0x3D34,0x8F95,0x3D08,0x8F7D,0x3CDC,0x8F65,0x3CAF,0x8F4D,0x3C83,0x8F35,
0x3C57,0x8F1D,0x3C2A,0x8F06,0x3BFE,0x8EEE,0x3BD2,0x8ED6,0x3BA5,0x8EBF,0x3B79,
0x8EA8,0x3B4C,0x8E90,0x3B20,0x8E79,0x3AF3,0x8E62,0x3AC6,0x8E4B,0x3A9A,0x8E34,
0x3A6D,0x8E1D,0x3A40,0x8E06,0x3A13,0x8DEF,0x39E7,0x8DD8,0x39BA,0x8DC1,0x398D,
0x8DAB,0x3960,0x8D94,0x3933,0x8D7E,0x3906,0x8D67,0x38D9,0x8D51,0x38AC,0x8D3B,
0x387F,0x8D24,0x3852,0x8D0E,0x3825,0x8CF8,0x37F7,0x8CE2,0x37CA,0x8CCC,0x379D,
0x8CB6,0x3770,0x8CA1,0x3742,0x8C8B,0x3715,0x8C75,0x36E8,0x8C60,0x36BA,0x8C4A,
0x368D,0x8C35,0x365F,0x8C1F,0x3632,0x8C0A,0x3604,0x8BF5,0x35D7,0x8BDF,0x35A9,
0x8BCA,0x357B,0x8BB5,0x354E,0x8BA0,0x3520,0x8B8B,0x34F2,0x8B77,0x34C4,0x8B62,
0x3497,0x8B4D,0x3469,0x8B39,0x343B,0x8B24,0x340D,0x8B10,0x33DF,0x8AFB,0x33B1,
0x8AE7,0x3383,0x8AD3,0x3355,0x8ABE,0x3327,0x8AAA,0x32F9,0x8A96,0x32CB,0x8A82,
0x329D,0x8A6E,0x326E,0x8A5A,0x3240,0x8A47,0x3212,0x8A33,0x31E4,0x8A1F,0x31B5,
0x8A0C,0x3187,0x89F8,0x3159,0x89E5,0x312A,0x89D2,0x30FC,0x89BE,0x30CD,0x89AB,
0x309F,0x8998,0x3070,0x8985,0x3042,0x8972,0x3013,0x895F,0x2FE5,0x894C,0x2FB6,
0x8939,0x2F87,0x8927,0x2F59,0x8914,0x2F2A,0x8902,0x2EFB,0x88EF,0x2ECC,0x88DD,
0x2E9E,0x88CA,0x2E6F,0x88B8,0x2E40,0x88A6,0x2E11,0x8894,0x2DE2,0x8882,0x2DB3,
0x8870,0x2D84,0x885E,0x2D55,0x884C,0x2D26,0x883A,0x2CF7,0x8828,0x2CC8,0x8817,
0x2C99,0x8805,0x2C6A,0x87F4,0x2C3B,0x87E2,0x2C0C,0x87D1,0x2BDC,0x87C0,0x2BAD,
0x87AF,0x2B7E,0x879D,0x2B4F,0x878C,0x2B1F,0x877B,0x2AF0,0x876B,0x2AC1,0x875A,
0x2A91,0x8749,0x2A62,0x8738,0x2A32,0x8728,0x2A03,0x8717,0x29D3,0x8707,0x29A4,
0x86F6,0x2974,0x86E6,0x2945,0x86D6,0x2915,0x86C6,0x28E5,0x86B6,0x28B6,0x86A5,
0x2886,0x8696,0x2856,0x8686,0x2827,0x8676,0x27F7,0x8666,0x27C7,0x8656,0x2797,
0x8647,0x2768,0x8637,0x2738,0x8628,0x2708,0x8619,0x26D8,0x8609,0x26A8,0x85FA,
0x2678,0x85EB,0x2648,0x85DC,0x2618,0x85CD,0x25E8,0x85BE,0x25B8,0x85AF,0x2588,
0x85A0,0x2558,0x8592,0x2528,0x8583,0x24F8,0x8574,0x24C8,0x8566,0x2498,0x8558,
0x2467,0x8549,0x2437,0x853B,0x2407,0x852D,0x23D7,0x851F,0x23A7,0x8511,0x2376,
0x8503,0x2346,0x84F5,0x2316,0x84E7,0x22E5,0x84D9,0x22B5,0x84CC,0x2284,0x84BE,
0x2254,0x84B0,0x2224,0x84A3,0x21F3,0x8496,0x21C3,0x8488,0x2192,0x847B,0x2162,
0x846E,0x2131,0x8461,0x2101,0x8454,0x20D0,0x8447,0x209F,0x843A,0x206F,0x842D,
0x203E,0x8421,0x200E,0x8414,0x1FDD,0x8407,0x1FAC,0x83FB,0x1F7B,0x83EF,0x1F4B,
0x83E2,0x1F1A,0x83D6,0x1EE9,0x83CA,0x1EB8,0x83BE,0x1E88,0x83B2,0x1E57,0x83A6,
0x1E26,0x839A,0x1DF5,0x838E,0x1DC4,0x8382,0x1D93,0x8377,0x1D62,0x836B,0x1D31,
0x8360,0x1D01,0x8354,0x1CD0,0x8349,0x1C9F,0x833E,0x1C6E,0x8332,0x1C3D,0x8327,
0x1C0C,0x831C,0x1BDA,0x8311,0x1BA9,0x8306,0x1B78,0x82FB,0x1B47,0x82F1,0x1B16,
0x82E6,0x1AE5,0x82DB,0x1AB4,0x82D1,0x1A83,0x82C6,0x1A51,0x82BC,0x1A20,0x82B2,
0x19EF,0x82A8,0x19BE,0x829D,0x198D,0x8293,0x195B,0x8289,0x192A,0x827F,0x18F9,
0x8276,0x18C7,0x826C,0x1896,0x8262,0x1865,0x8259,0x1833,0x824F,0x1802,0x8246,
0x17D1,0x823C,0x179F,0x8233,0x176E,0x822A,0x173C,0x8220,0x170B,0x8217,0x16DA,
0x820E,0x16A8,0x8205,0x1677,0x81FD,0x1645,0x81F4,0x1614,0x81EB,0x15E2,0x81E2,
0x15B1,0x81DA,0x157F,0x81D1,0x154D,0x81C9,0x151C,0x81C1,0x14EA,0x81B8,0x14B9,
0x81B0,0x1487,0x81A8,0x1455,0x81A0,0x1424,0x8198,0x13F2,0x8190,0x13C1,0x8188,
0x138F,0x8181,0x135D,0x8179,0x132B,0x8172,0x12FA,0x816A,0x12C8,0x8163,0x1296,
0x815B,0x1265,0x8154,0x1233,0x814D,0x1201,0x8146,0x11CF,0x813F,0x119E,0x8138,
0x116C,0x8131,0x113A,0x812A,0x1108,0x8123,0x10D6,0x811D,0x10A4,0x8116,0x1073,
0x8110,0x1041,0x8109,0x100F,0x8103,0x0FDD,0x80FD,0x0FAB,0x80F6,0x0F79,0x80F0,
0x0F47,0x80EA,0x0F15,0x80E4,0x0EE4,0x80DE,0x0EB2,0x80D9,0x0E80,0x80D3,0x0E4E,
0x80CD,0x0E1C,0x80C8,0x0DEA,0x80C2,0x0DB8,0x80BD,0x0D86,0x80B7,0x0D54,0x80B2,
0x0D22,0x80AD,0x0CF0,0x80A8,0x0CBE,0x80A3,0x0C8C,0x809E,0x0C5A,0x8099,0x0C28,
0x8094,0x0BF6,0x808F,0x0BC4,0x808B,0x0B92,0x8086,0x0B60,0x8082,0x0B2D,0x807D,
0x0AFB,0x8079,0x0AC9,0x8075,0x0A97,0x8070,0x0A65,0x806C,0x0A33,0x8068,0x0A01,
0x8064,0x09CF,0x8060,0x099D,0x805D,0x096B,0x8059,0x0938,0x8055,0x0906,0x8052,
0x08D4,0x804E,0x08A2,0x804B,0x0870,0x8047,0x083E,0x8044,0x080C,0x8041,0x07D9,
0x803E,0x07A7,0x803B,0x0775,0x8038,0x0743,0x8035,0x0711,0x8032,0x06DE,0x802F,
0x06AC,0x802D,0x067A,0x802A,0x0648,0x8027,0x0616,0x8025,0x05E3,0x8023,0x05B1,
0x8020,0x057F,0x801E,0x054D,0x801C,0x051B,0x801A,0x04E8,0x8018,0x04B6,0x8016,
0x0484,0x8014,0x0452,0x8013,0x041F,0x8011,0x03ED,0x800F,0x03BB,0x800E,0x0389,
0x800C,0x0356,0x800B,0x0324,0x800A,0x02F2,0x8009,0x02C0,0x8008,0x028D,0x8007,
0x025B,0x8006,0x0229,0x8005,0x01F7,0x8004,0x01C4,0x8003,0x0192,0x8002,0x0160,
0x8002,0x012E,0x8001,0x00FB,0x8001,0x00C9,0x8001,0x0097,0x8000,0x0065,0x8000,
0x0032,0x8000,0x7FFF,0x0000,0x7FFF,0xFF37,0x7FFE,0xFE6E,0x7FFA,0xFDA5,0x7FF6,
0xFCDC,0x7FF1,0xFC13,0x7FEA,0xFB4A,0x7FE2,0xFA81,0x7FD9,0xF9B8,0x7FCE,0xF8EF,
0x7FC2,0xF827,0x7FB5,0xF75E,0x7FA7,0xF695,0x7F98,0xF5CD,0x7F87,0xF505,0x7F75,
0xF43C,0x7F62,0xF374,0x7F4E,0xF2AC,0x7F38,0xF1E4,0x7F22,0xF11C,0x7F0A,0xF055,
0x7EF0,0xEF8D,0x7ED6,0xEEC6,0x7EBA,0xEDFF,0x7E9D,0xED38,0x7E7F,0xEC71,0x7E60,
0xEBAB,0x7E3F,0xEAE4,0x7E1E,0xEA1E,0x7DFB,0xE958,0x7DD6,0xE892,0x7DB1,0xE7CD,
0x7D8A,0xE707,0x7D63,0xE642,0x7D3A,0xE57D,0x7D0F,0xE4B9,0x7CE4,0xE3F4,0x7CB7,
0xE330,0x7C89,0xE26D,0x7C5A,0xE1A9,0x7C2A,0xE0E6,0x7BF9,0xE023,0x7BC6,0xDF61,
0x7B92,0xDE9E,0x7B5D,0xDDDC,0x7B27,0xDD1B,0x7AEF,0xDC59,0x7AB7,0xDB99,0x7A7D,
0xDAD8,0x7A42,0xDA18,0x7A06,0xD958,0x79C9,0xD898,0x798A,0xD7D9,0x794A,0xD71B,
0x790A,0xD65C,0x78C8,0xD59E,0x7885,0xD4E1,0x7840,0xD424,0x77FB,0xD367,0x77B4,
0xD2AB,0x776C,0xD1EF,0x7723,0xD134,0x76D9,0xD079,0x768E,0xCFBE,0x7642,0xCF04,
0x75F4,0xCE4B,0x75A6,0xCD92,0x7556,0xCCD9,0x7505,0xCC21,0x74B3,0xCB69,0x7460,
0xCAB2,0x740B,0xC9FC,0x73B6,0xC946,0x735F,0xC890,0x7308,0xC7DB,0x72AF,0xC727,
0x7255,0xC673,0x71FA,0xC5C0,0x719E,0xC50D,0x7141,0xC45B,0x70E3,0xC3A9,0x7083,
0xC2F8,0x7023,0xC248,0x6FC2,0xC198,0x6F5F,0xC0E9,0x6EFB,0xC03A,0x6E97,0xBF8C,
0x6E31,0xBEDF,0x6DCA,0xBE32,0x6D62,0xBD86,0x6CF9,0xBCDA,0x6C8F,0xBC2F,0x6C24,
0xBB85,0x6BB8,0xBADC,0x6B4B,0xBA33,0x6ADD,0xB98B,0x6A6E,0xB8E3,0x69FD,0xB83C,
0x698C,0xB796,0x691A,0xB6F1,0x68A7,0xB64C,0x6832,0xB5A8,0x67BD,0xB505,0x6747,
0xB462,0x66D0,0xB3C0,0x6657,0xB31F,0x65DE,0xB27F,0x6564,0xB1DF,0x64E9,0xB140,
0x646C,0xB0A2,0x63EF,0xB005,0x6371,0xAF68,0x62F2,0xAECC,0x6272,0xAE31,0x61F1,
0xAD97,0x616F,0xACFD,0x60EC,0xAC65,0x6068,0xABCD,0x5FE4,0xAB36,0x5F5E,0xAAA0,
0x5ED7,0xAA0A,0x5E50,0xA976,0x5DC8,0xA8E2,0x5D3E,0xA84F,0x5CB4,0xA7BD,0x5C29,
0xA72C,0x5B9D,0xA69C,0x5B10,0xA60C,0x5A82,0xA57E,0x59F4,0xA4F0,0x5964,0xA463,
0x58D4,0xA3D7,0x5843,0xA34C,0x57B1,0xA2C2,0x571E,0xA238,0x568A,0xA1B0,0x55F6,
0xA129,0x5560,0xA0A2,0x54CA,0xA01C,0x5433,0x9F98,0x539B,0x9F14,0x5303,0x9E91,
0x5269,0x9E0F,0x51CF,0x9D8E,0x5134,0x9D0E,0x5098,0x9C8F,0x4FFB,0x9C11,0x4F5E,
0x9B94,0x4EC0,0x9B17,0x4E21,0x9A9C,0x4D81,0x9A22,0x4CE1,0x99A9,0x4C40,0x9930,
0x4B9E,0x98B9,0x4AFB,0x9843,0x4A58,0x97CE,0x49B4,0x9759,0x490F,0x96E6,0x486A,
0x9674,0x47C4,0x9603,0x471D,0x9592,0x4675,0x9523,0x45CD,0x94B5,0x4524,0x9448,
0x447B,0x93DC,0x43D1,0x9371,0x4326,0x9307,0x427A,0x929E,0x41CE,0x9236,0x4121,
0x91CF,0x4074,0x9169,0x3FC6,0x9105,0x3F17,0x90A1,0x3E68,0x903E,0x3DB8,0x8FDD,
0x3D08,0x8F7D,0x3C57,0x8F1D,0x3BA5,0x8EBF,0x3AF3,0x8E62,0x3A40,0x8E06,0x398D,
0x8DAB,0x38D9,0x8D51,0x3825,0x8CF8,0x3770,0x8CA1,0x36BA,0x8C4A,0x3604,0x8BF5,
0x354E,0x8BA0,0x3497,0x8B4D,0x33DF,0x8AFB,0x3327,0x8AAA,0x326E,0x8A5A,0x31B5,
0x8A0C,0x30FC,0x89BE,0x3042,0x8972,0x2F87,0x8927,0x2ECC,0x88DD,0x2E11,0x8894,
0x2D55,0x884C,0x2C99,0x8805,0x2BDC,0x87C0,0x2B1F,0x877B,0x2A62,0x8738,0x29A4,
0x86F6,0x28E5,0x86B6,0x2827,0x8676,0x2768,0x8637,0x26A8,0x85FA,0x25E8,0x85BE,
0x2528,0x8583,0x2467,0x8549,0x23A7,0x8511,0x22E5,0x84D9,0x2224,0x84A3,0x2162,
0x846E,0x209F,0x843A,0x1FDD,0x8407,0x1F1A,0x83D6,0x1E57,0x83A6,0x1D93,0x8377,
0x1CD0,0x8349,0x1C0C,0x831C,0x1B47,0x82F1,0x1A83,0x82C6,0x19BE,0x829D,0x18F9,
0x8276,0x1833,0x824F,0x176E,0x822A,0x16A8,0x8205,0x15E2,0x81E2,0x151C,0x81C1,
0x1455,0x81A0,0x138F,0x8181,0x12C8,0x8163,0x1201,0x8146,0x113A,0x812A,0x1073,
0x8110,0x0FAB,0x80F6,0x0EE4,0x80DE,0x0E1C,0x80C8,0x0D54,0x80B2,0x0C8C,0x809E,
0x0BC4,0x808B,0x0AFB,0x8079,0x0A33,0x8068,0x096B,0x8059,0x08A2,0x804B,0x07D9,
0x803E,0x0711,0x8032,0x0648,0x8027,0x057F,0x801E,0x04B6,0x8016,0x03ED,0x800F,
0x0324,0x800A,0x025B,0x8006,0x0192,0x8002,0x00C9,0x8001,0x7FFF,0x0000,0x7FF6,
0xFCDC,0x7FD9,0xF9B8,0x7FA7,0xF695,0x7F62,0xF374,0x7F0A,0xF055,0x7E9D,0xED38,
0x7E1E,0xEA1E,0x7D8A,0xE707,0x7CE4,0xE3F4,0x7C2A,0xE0E6,0x7B5D,0xDDDC,0x7A7D,
0xDAD8,0x798A,0xD7D9,0x7885,0xD4E1,0x776C,0xD1EF,0x7642,0xCF04,0x7505,0xCC21,
0x73B6,0xC946,0x7255,0xC673,0x70E3,0xC3A9,0x6F5F,0xC0E9,0x6DCA,0xBE32,0x6C24,
0xBB85,0x6A6E,0xB8E3,0x68A7,0xB64C,0x66D0,0xB3C0,0x64E9,0xB140,0x62F2,0xAECC,
0x60EC,0xAC65,0x5ED7,0xAA0A,0x5CB4,0xA7BD,0x5A82,0xA57E,0x5843,0xA34C,0x55F6,
0xA129,0x539B,0x9F14,0x5134,0x9D0E,0x4EC0,0x9B17,0x4C40,0x9930,0x49B4,0x9759,
0x471D,0x9592,0x447B,0x93DC,0x41CE,0x9236,0x3F17,0x90A1,0x3C57,0x8F1D,0x398D,
0x8DAB,0x36BA,0x8C4A,0x33DF,0x8AFB,0x30FC,0x89BE,0x2E11,0x8894,0x2B1F,0x877B,
0x2827,0x8676,0x2528,0x8583,0x2224,0x84A3,0x1F1A,0x83D6,0x1C0C,0x831C,0x18F9,
0x8276,0x15E2,0x81E2,0x12C8,0x8163,0x0FAB,0x80F6,0x0C8C,0x809E,0x096B,0x8059,
0x0648,0x8027,0x0324,0x800A,0x7FFF,0x0000,0x7F62,0xF374,0x7D8A,0xE707,0x7A7D,
0xDAD8,0x7642,0xCF04,0x70E3,0xC3A9,0x6A6E,0xB8E3,0x62F2,0xAECC,0x5A82,0xA57E,
0x5134,0x9D0E,0x471D,0x9592,0x3C57,0x8F1D,0x30FC,0x89BE,0x2528,0x8583,0x18F9,
0x8276,0x0C8C,0x809E,0x7FFF,0x0000,0x7642,0xCF04,0x5A82,0xA57E,0x30FC,0x89BE,};

q15_t rearranged_twiddle_stride2_4096_q15[2728]={
0x7FFF,0x0000,0x7FFF,0xFF9B,0x7FFF,0xFF37,0x7FFF,0xFED2,0x7FFE,0xFE6E,0x7FFC,
0xFE09,0x7FFA,0xFDA5,0x7FF8,0xFD40,0x7FF6,0xFCDC,0x7FF4,0xFC77,0x7FF1,0xFC13,
0x7FED,0xFBAE,0x7FEA,0xFB4A,0x7FE6,0xFAE5,0x7FE2,0xFA81,0x7FDD,0xFA1D,0x7FD9,
0xF9B8,0x7FD3,0xF954,0x7FCE,0xF8EF,0x7FC8,0xF88B,0x7FC2,0xF827,0x7FBC,0xF7C2,
0x7FB5,0xF75E,0x7FAE,0xF6FA,0x7FA7,0xF695,0x7FA0,0xF631,0x7F98,0xF5CD,0x7F90,
0xF569,0x7F87,0xF505,0x7F7E,0xF4A0,0x7F75,0xF43C,0x7F6C,0xF3D8,0x7F62,0xF374,
0x7F58,0xF310,0x7F4E,0xF2AC,0x7F43,0xF248,0x7F38,0xF1E4,0x7F2D,0xF180,0x7F22,
0xF11C,0x7F16,0xF0B9,0x7F0A,0xF055,0x7EFD,0xEFF1,0x7EF0,0xEF8D,0x7EE3,0xEF2A,
0x7ED6,0xEEC6,0x7EC8,0xEE62,0x7EBA,0xEDFF,0x7EAC,0xED9B,0x7E9D,0xED38,0x7E8E,
0xECD5,0x7E7F,0xEC71,0x7E70,0xEC0E,0x7E60,0xEBAB,0x7E50,0xEB47,0x7E3F,0xEAE4,
0x7E2F,0xEA81,0x7E1E,0xEA1E,0x7E0C,0xE9BB,0x7DFB,0xE958,0x7DE9,0xE8F5,0x7DD6,
0xE892,0x7DC4,0xE82F,0x7DB1,0xE7CD,0x7D9E,0xE76A,0x7D8A,0xE707,0x7D77,0xE6A5,
0x7D63,0xE642,0x7D4E,0xE5E0,0x7D3A,0xE57D,0x7D25,0xE51B,0x7D0F,0xE4B9,0x7CFA,
0xE457,0x7CE4,0xE3F4,0x7CCE,0xE392,0x7CB7,0xE330,0x7CA0,0xE2CF,0x7C89,0xE26D,
0x7C72,0xE20B,0x7C5A,0xE1A9,0x7C42,0xE148,0x7C2A,0xE0E6,0x7C11,0xE085,0x7BF9,
0xE023,0x7BDF,0xDFC2,0x7BC6,0xDF61,0x7BAC,0xDEFF,0x7B92,0xDE9E,0x7B78,0xDE3D,
0x7B5D,0xDDDC,0x7B42,0xDD7C,0x7B27,0xDD1B,0x7B0B,0xDCBA,0x7AEF,0xDC59,0x7AD3,
0xDBF9,0x7AB7,0xDB99,0x7A9A,0xDB38,0x7A7D,0xDAD8,0x7A60,0xDA78,0x7A42,0xDA18,
0x7A24,0xD9B8,0x7A06,0xD958,0x79E7,0xD8F8,0x79C9,0xD898,0x79AA,0xD839,0x798A,
0xD7D9,0x796A,0xD77A,0x794A,0xD71B,0x792A,0xD6BB,0x790A,0xD65C,0x78E9,0xD5FD,
0x78C8,0xD59E,0x78A6,0xD53F,0x7885,0xD4E1,0x7863,0xD482,0x7840,0xD424,0x781E,
0xD3C5,0x77FB,0xD367,0x77D8,0xD309,0x77B4,0xD2AB,0x7790,0xD24D,0x776C,0xD1EF,
0x7748,0xD191,0x7723,0xD134,0x76FE,0xD0D6,0x76D9,0xD079,0x76B4,0xD01B,0x768E,
0xCFBE,0x7668,0xCF61,0x7642,0xCF04,0x761B,0xCEA7,0x75F4,0xCE4B,0x75CD,0xCDEE,
0x75A6,0xCD92,0x757E,0xCD35,0x7556,0xCCD9,0x752D,0xCC7D,0x7505,0xCC21,0x74DC,
0xCBC5,0x74B3,0xCB69,0x7489,0xCB0E,0x7460,0xCAB2,0x7436,0xCA57,0x740B,0xC9FC,
0x73E1,0xC9A1,0x73B6,0xC946,0x738B,0xC8EB,0x735F,0xC890,0x7334,0xC836,0x7308,
0xC7DB,0x72DC,0xC781,0x72AF,0xC727,0x7282,0xC6CD,0x7255,0xC673,0x7228,0xC619,
0x71FA,0xC5C0,0x71CC,0xC566,0x719E,0xC50D,0x7170,0xC4B4,0x7141,0xC45B,0x7112,
0xC402,0x70E3,0xC3A9,0x70B3,0xC351,0x7083,0xC2F8,0x7053,0xC2A0,0x7023,0xC248,
0x6FF2,0xC1F0,0x6FC2,0xC198,0x6F90,0xC140,0x6F5F,0xC0E9,0x6F2D,0xC091,0x6EFB,
0xC03A,0x6EC9,0xBFE3,0x6E97,0xBF8C,0x6E64,0xBF35,0x6E31,0xBEDF,0x6DFE,0xBE88,
0x6DCA,0xBE32,0x6D96,0xBDDC,0x6D62,0xBD86,0x6D2E,0xBD30,0x6CF9,0xBCDA,0x6CC4,
0xBC85,0x6C8F,0xBC2F,0x6C5A,0xBBDA,0x6C24,0xBB85,0x6BEE,0xBB30,0x6BB8,0xBADC,
0x6B82,0xBA87,0x6B4B,0xBA33,0x6B14,0xB9DF,0x6ADD,0xB98B,0x6AA5,0xB937,0x6A6E,
0xB8E3,0x6A36,0xB890,0x69FD,0xB83C,0x69C5,0xB7E9,0x698C,0xB796,0x6953,0xB743,
0x691A,0xB6F1,0x68E0,0xB69E,0x68A7,0xB64C,0x686D,0xB5FA,0x6832,0xB5A8,0x67F8,
0xB556,0x67BD,0xB505,0x6782,0xB4B3,0x6747,0xB462,0x670B,0xB411,0x66D0,0xB3C0,
0x6693,0xB36F,0x6657,0xB31F,0x661B,0xB2CF,0x65DE,0xB27F,0x65A1,0xB22F,0x6564,
0xB1DF,0x6526,0xB18F,0x64E9,0xB140,0x64AB,0xB0F1,0x646C,0xB0A2,0x642E,0xB053,
0x63EF,0xB005,0x63B0,0xAFB6,0x6371,0xAF68,0x6332,0xAF1A,0x62F2,0xAECC,0x62B2,
0xAE7F,0x6272,0xAE31,0x6232,0xADE4,0x61F1,0xAD97,0x61B0,0xAD4A,0x616F,0xACFD,
0x612E,0xACB1,0x60EC,0xAC65,0x60AA,0xAC19,0x6068,0xABCD,0x6026,0xAB81,0x5FE4,
0xAB36,0x5FA1,0xAAEB,0x5F5E,0xAAA0,0x5F1B,0xAA55,0x5ED7,0xAA0A,0x5E94,0xA9C0,
0x5E50,0xA976,0x5E0C,0xA92C,0x5DC8,0xA8E2,0x5D83,0xA899,0x5D3E,0xA84F,0x5CF9,
0xA806,0x5CB4,0xA7BD,0x5C6F,0xA774,0x5C29,0xA72C,0x5BE3,0xA6E4,0x5B9D,0xA69C,
0x5B57,0xA654,0x5B10,0xA60C,0x5AC9,0xA5C5,0x5A82,0xA57E,0x5A3B,0xA537,0x59F4,
0xA4F0,0x59AC,0xA4A9,0x5964,0xA463,0x591C,0xA41D,0x58D4,0xA3D7,0x588C,0xA391,
0x5843,0xA34C,0x57FA,0xA307,0x57B1,0xA2C2,0x5767,0xA27D,0x571E,0xA238,0x56D4,
0xA1F4,0x568A,0xA1B0,0x5640,0xA16C,0x55F6,0xA129,0x55AB,0xA0E5,0x5560,0xA0A2,
0x5515,0xA05F,0x54CA,0xA01C,0x547F,0x9FDA,0x5433,0x9F98,0x53E7,0x9F56,0x539B,
0x9F14,0x534F,0x9ED2,0x5303,0x9E91,0x52B6,0x9E50,0x5269,0x9E0F,0x521C,0x9DCE,
0x51CF,0x9D8E,0x5181,0x9D4E,0x5134,0x9D0E,0x50E6,0x9CCE,0x5098,0x9C8F,0x504A,
0x9C50,0x4FFB,0x9C11,0x4FAD,0x9BD2,0x4F5E,0x9B94,0x4F0F,0x9B55,0x4EC0,0x9B17,
0x4E71,0x9ADA,0x4E21,0x9A9C,0x4DD1,0x9A5F,0x4D81,0x9A22,0x4D31,0x99E5,0x4CE1,
0x99A9,0x4C91,0x996D,0x4C40,0x9930,0x4BEF,0x98F5,0x4B9E,0x98B9,0x4B4D,0x987E,
0x4AFB,0x9843,0x4AAA,0x9808,0x4A58,0x97CE,0x4A06,0x9793,0x49B4,0x9759,0x4962,
0x9720,0x490F,0x96E6,0x48BD,0x96AD,0x486A,0x9674,0x4817,0x963B,0x47C4,0x9603,
0x4770,0x95CA,0x471D,0x9592,0x46C9,0x955B,0x4675,0x9523,0x4621,0x94EC,0x45CD,
0x94B5,0x4579,0x947E,0x4524,0x9448,0x44D0,0x9412,0x447B,0x93DC,0x4426,0x93A6,
0x43D1,0x9371,0x437B,0x933C,0x4326,0x9307,0x42D0,0x92D2,0x427A,0x929E,0x4224,
0x926A,0x41CE,0x9236,0x4178,0x9202,0x4121,0x91CF,0x40CB,0x919C,0x4074,0x9169,
0x401D,0x9137,0x3FC6,0x9105,0x3F6F,0x90D3,0x3F17,0x90A1,0x3EC0,0x9070,0x3E68,
0x903E,0x3E10,0x900E,0x3DB8,0x8FDD,0x3D60,0x8FAD,0x3D08,0x8F7D,0x3CAF,0x8F4D,
0x3C57,0x8F1D,0x3BFE,0x8EEE,0x3BA5,0x8EBF,0x3B4C,0x8E90,0x3AF3,0x8E62,0x3A9A,
0x8E34,0x3A40,0x8E06,0x39E7,0x8DD8,0x398D,0x8DAB,0x3933,0x8D7E,0x38D9,0x8D51,
0x387F,0x8D24,0x3825,0x8CF8,0x37CA,0x8CCC,0x3770,0x8CA1,0x3715,0x8C75,0x36BA,
0x8C4A,0x365F,0x8C1F,0x3604,0x8BF5,0x35A9,0x8BCA,0x354E,0x8BA0,0x34F2,0x8B77,
0x3497,0x8B4D,0x343B,0x8B24,0x33DF,0x8AFB,0x3383,0x8AD3,0x3327,0x8AAA,0x32CB,
0x8A82,0x326E,0x8A5A,0x3212,0x8A33,0x31B5,0x8A0C,0x3159,0x89E5,0x30FC,0x89BE,
0x309F,0x8998,0x3042,0x8972,0x2FE5,0x894C,0x2F87,0x8927,0x2F2A,0x8902,0x2ECC,
0x88DD,0x2E6F,0x88B8,0x2E11,0x8894,0x2DB3,0x8870,0x2D55,0x884C,0x2CF7,0x8828,
0x2C99,0x8805,0x2C3B,0x87E2,0x2BDC,0x87C0,0x2B7E,0x879D,0x2B1F,0x877B,0x2AC1,
0x875A,0x2A62,0x8738,0x2A03,0x8717,0x29A4,0x86F6,0x2945,0x86D6,0x28E5,0x86B6,
0x2886,0x8696,0x2827,0x8676,0x27C7,0x8656,0x2768,0x8637,0x2708,0x8619,0x26A8,
0x85FA,0x2648,0x85DC,0x25E8,0x85BE,0x2588,0x85A0,0x2528,0x8583,0x24C8,0x8566,
0x2467,0x8549,0x2407,0x852D,0x23A7,0x8511,0x2346,0x84F5,0x22E5,0x84D9,0x2284,
0x84BE,0x2224,0x84A3,0x21C3,0x8488,0x2162,0x846E,0x2101,0x8454,0x209F,0x843A,
0x203E,0x8421,0x1FDD,0x8407,0x1F7B,0x83EF,0x1F1A,0x83D6,0x1EB8,0x83BE,0x1E57,
0x83A6,0x1DF5,0x838E,0x1D93,0x8377,0x1D31,0x8360,0x1CD0,0x8349,0x1C6E,0x8332,
0x1C0C,0x831C,0x1BA9,0x8306,0x1B47,0x82F1,0x1AE5,0x82DB,0x1A83,0x82C6,0x1A20,
0x82B2,0x19BE,0x829D,0x195B,0x8289,0x18F9,0x8276,0x1896,0x8262,0x1833,0x824F,
0x17D1,0x823C,0x176E,0x822A,0x170B,0x8217,0x16A8,0x8205,0x1645,0x81F4,0x15E2,
0x81E2,0x157F,0x81D1,0x151C,0x81C1,0x14B9,0x81B0,0x1455,0x81A0,0x13F2,0x8190,
0x138F,0x8181,0x132B,0x8172,0x12C8,0x8163,0x1265,0x8154,0x1201,0x8146,0x119E,
0x8138,0x113A,0x812A,0x10D6,0x811D,0x1073,0x8110,0x100F,0x8103,0x0FAB,0x80F6,
0x0F47,0x80EA,0x0EE4,0x80DE,0x0E80,0x80D3,0x0E1C,0x80C8,0x0DB8,0x80BD,0x0D54,
0x80B2,0x0CF0,0x80A8,0x0C8C,0x809E,0x0C28,0x8094,0x0BC4,0x808B,0x0B60,0x8082,
0x0AFB,0x8079,0x0A97,0x8070,0x0A33,0x8068,0x09CF,0x8060,0x096B,0x8059,0x0906,
0x8052,0x08A2,0x804B,0x083E,0x8044,0x07D9,0x803E,0x0775,0x8038,0x0711,0x8032,
0x06AC,0x802D,0x0648,0x8027,0x05E3,0x8023,0x057F,0x801E,0x051B,0x801A,0x04B6,
0x8016,0x0452,0x8013,0x03ED,0x800F,0x0389,0x800C,0x0324,0x800A,0x02C0,0x8008,
0x025B,0x8006,0x01F7,0x8004,0x0192,0x8002,0x012E,0x8001,0x00C9,0x8001,0x0065,
0x8000,0x0000,0x8000,0xFF9B,0x8000,0xFF37,0x8001,0xFED2,0x8001,0xFE6E,0x8002,
0xFE09,0x8004,0xFDA5,0x8006,0xFD40,0x8008,0xFCDC,0x800A,0xFC77,0x800C,0xFC13,
0x800F,0xFBAE,0x8013,0xFB4A,0x8016,0xFAE5,0x801A,0xFA81,0x801E,0xFA1D,0x8023,
0xF9B8,0x8027,0xF954,0x802D,0xF8EF,0x8032,0xF88B,0x8038,0xF827,0x803E,0xF7C2,
0x8044,0xF75E,0x804B,0xF6FA,0x8052,0xF695,0x8059,0xF631,0x8060,0xF5CD,0x8068,
0xF569,0x8070,0xF505,0x8079,0xF4A0,0x8082,0xF43C,0x808B,0xF3D8,0x8094,0xF374,
0x809E,0xF310,0x80A8,0xF2AC,0x80B2,0xF248,0x80BD,0xF1E4,0x80C8,0xF180,0x80D3,
0xF11C,0x80DE,0xF0B9,0x80EA,0xF055,0x80F6,0xEFF1,0x8103,0xEF8D,0x8110,0xEF2A,
0x811D,0xEEC6,0x812A,0xEE62,0x8138,0xEDFF,0x8146,0xED9B,0x8154,0xED38,0x8163,
0xECD5,0x8172,0xEC71,0x8181,0xEC0E,0x8190,0xEBAB,0x81A0,0xEB47,0x81B0,0xEAE4,
0x81C1,0xEA81,0x81D1,0xEA1E,0x81E2,0xE9BB,0x81F4,0xE958,0x8205,0xE8F5,0x8217,
0xE892,0x822A,0xE82F,0x823C,0xE7CD,0x824F,0xE76A,0x8262,0xE707,0x8276,0xE6A5,
0x8289,0xE642,0x829D,0xE5E0,0x82B2,0xE57D,0x82C6,0xE51B,0x82DB,0xE4B9,0x82F1,
0xE457,0x8306,0xE3F4,0x831C,0xE392,0x8332,0xE330,0x8349,0xE2CF,0x8360,0xE26D,
0x8377,0xE20B,0x838E,0xE1A9,0x83A6,0xE148,0x83BE,0xE0E6,0x83D6,0xE085,0x83EF,
0xE023,0x8407,0xDFC2,0x8421,0xDF61,0x843A,0xDEFF,0x8454,0xDE9E,0x846E,0xDE3D,
0x8488,0xDDDC,0x84A3,0xDD7C,0x84BE,0xDD1B,0x84D9,0xDCBA,0x84F5,0xDC59,0x8511,
0xDBF9,0x852D,0xDB99,0x8549,0xDB38,0x8566,0xDAD8,0x8583,0xDA78,0x85A0,0xDA18,
0x85BE,0xD9B8,0x85DC,0xD958,0x85FA,0xD8F8,0x8619,0xD898,0x8637,0xD839,0x8656,
0xD7D9,0x8676,0xD77A,0x8696,0xD71B,0x86B6,0xD6BB,0x86D6,0xD65C,0x86F6,0xD5FD,
0x8717,0xD59E,0x8738,0xD53F,0x875A,0xD4E1,0x877B,0xD482,0x879D,0xD424,0x87C0,
0xD3C5,0x87E2,0xD367,0x8805,0xD309,0x8828,0xD2AB,0x884C,0xD24D,0x8870,0xD1EF,
0x8894,0xD191,0x88B8,0xD134,0x88DD,0xD0D6,0x8902,0xD079,0x8927,0xD01B,0x894C,
0xCFBE,0x8972,0xCF61,0x8998,0xCF04,0x89BE,0xCEA7,0x89E5,0xCE4B,0x8A0C,0xCDEE,
0x8A33,0xCD92,0x8A5A,0xCD35,0x8A82,0xCCD9,0x8AAA,0xCC7D,0x8AD3,0xCC21,0x8AFB,
0xCBC5,0x8B24,0xCB69,0x8B4D,0xCB0E,0x8B77,0xCAB2,0x8BA0,0xCA57,0x8BCA,0xC9FC,
0x8BF5,0xC9A1,0x8C1F,0xC946,0x8C4A,0xC8EB,0x8C75,0xC890,0x8CA1,0xC836,0x8CCC,
0xC7DB,0x8CF8,0xC781,0x8D24,0xC727,0x8D51,0xC6CD,0x8D7E,0xC673,0x8DAB,0xC619,
0x8DD8,0xC5C0,0x8E06,0xC566,0x8E34,0xC50D,0x8E62,0xC4B4,0x8E90,0xC45B,0x8EBF,
0xC402,0x8EEE,0xC3A9,0x8F1D,0xC351,0x8F4D,0xC2F8,0x8F7D,0xC2A0,0x8FAD,0xC248,
0x8FDD,0xC1F0,0x900E,0xC198,0x903E,0xC140,0x9070,0xC0E9,0x90A1,0xC091,0x90D3,
0xC03A,0x9105,0xBFE3,0x9137,0xBF8C,0x9169,0xBF35,0x919C,0xBEDF,0x91CF,0xBE88,
0x9202,0xBE32,0x9236,0xBDDC,0x926A,0xBD86,0x929E,0xBD30,0x92D2,0xBCDA,0x9307,
0xBC85,0x933C,0xBC2F,0x9371,0xBBDA,0x93A6,0xBB85,0x93DC,0xBB30,0x9412,0xBADC,
0x9448,0xBA87,0x947E,0xBA33,0x94B5,0xB9DF,0x94EC,0xB98B,0x9523,0xB937,0x955B,
0xB8E3,0x9592,0xB890,0x95CA,0xB83C,0x9603,0xB7E9,0x963B,0xB796,0x9674,0xB743,
0x96AD,0xB6F1,0x96E6,0xB69E,0x9720,0xB64C,0x9759,0xB5FA,0x9793,0xB5A8,0x97CE,
0xB556,0x9808,0xB505,0x9843,0xB4B3,0x987E,0xB462,0x98B9,0xB411,0x98F5,0xB3C0,
0x9930,0xB36F,0x996D,0xB31F,0x99A9,0xB2CF,0x99E5,0xB27F,0x9A22,0xB22F,0x9A5F,
0xB1DF,0x9A9C,0xB18F,0x9ADA,0xB140,0x9B17,0xB0F1,0x9B55,0xB0A2,0x9B94,0xB053,
0x9BD2,0xB005,0x9C11,0xAFB6,0x9C50,0xAF68,0x9C8F,0xAF1A,0x9CCE,0xAECC,0x9D0E,
0xAE7F,0x9D4E,0xAE31,0x9D8E,0xADE4,0x9DCE,0xAD97,0x9E0F,0xAD4A,0x9E50,0xACFD,
0x9E91,0xACB1,0x9ED2,0xAC65,0x9F14,0xAC19,0x9F56,0xABCD,0x9F98,0xAB81,0x9FDA,
0xAB36,0xA01C,0xAAEB,0xA05F,0xAAA0,0xA0A2,0xAA55,0xA0E5,0xAA0A,0xA129,0xA9C0,
0xA16C,0xA976,0xA1B0,0xA92C,0xA1F4,0xA8E2,0xA238,0xA899,0xA27D,0xA84F,0xA2C2,
0xA806,0xA307,0xA7BD,0xA34C,0xA774,0xA391,0xA72C,0xA3D7,0xA6E4,0xA41D,0xA69C,
0xA463,0xA654,0xA4A9,0xA60C,0xA4F0,0xA5C5,0xA537,0xA57E,0xA57E,0xA537,0xA5C5,
0xA4F0,0xA60C,0xA4A9,0xA654,0xA463,0xA69C,0xA41D,0xA6E4,0xA3D7,0xA72C,0xA391,
0xA774,0xA34C,0xA7BD,0xA307,0xA806,0xA2C2,0xA84F,0xA27D,0xA899,0xA238,0xA8E2,
0xA1F4,0xA92C,0xA1B0,0xA976,0xA16C,0xA9C0,0xA129,0xAA0A,0xA0E5,0xAA55,0xA0A2,
0xAAA0,0xA05F,0xAAEB,0xA01C,0xAB36,0x9FDA,0xAB81,0x9F98,0xABCD,0x9F56,0xAC19,
0x9F14,0xAC65,0x9ED2,0xACB1,0x9E91,0xACFD,0x9E50,0xAD4A,0x9E0F,0xAD97,0x9DCE,
0xADE4,0x9D8E,0xAE31,0x9D4E,0xAE7F,0x9D0E,0xAECC,0x9CCE,0xAF1A,0x9C8F,0xAF68,
0x9C50,0xAFB6,0x9C11,0xB005,0x9BD2,0xB053,0x9B94,0xB0A2,0x9B55,0xB0F1,0x9B17,
0xB140,0x9ADA,0xB18F,0x9A9C,0xB1DF,0x9A5F,0xB22F,0x9A22,0xB27F,0x99E5,0xB2CF,
0x99A9,0xB31F,0x996D,0xB36F,0x9930,0xB3C0,0x98F5,0xB411,0x98B9,0xB462,0x987E,
0xB4B3,0x9843,0xB505,0x9808,0xB556,0x97CE,0xB5A8,0x9793,0xB5FA,0x9759,0xB64C,
0x9720,0xB69E,0x96E6,0xB6F1,0x96AD,0xB743,0x9674,0xB796,0x963B,0xB7E9,0x9603,
0xB83C,0x95CA,0xB890,0x9592,0xB8E3,0x955B,0xB937,0x9523,0xB98B,0x94EC,0xB9DF,
0x94B5,0xBA33,0x947E,0xBA87,0x9448,0xBADC,0x9412,0xBB30,0x93DC,0xBB85,0x93A6,
0xBBDA,0x9371,0xBC2F,0x933C,0xBC85,0x9307,0xBCDA,0x92D2,0xBD30,0x929E,0xBD86,
0x926A,0xBDDC,0x9236,0xBE32,0x9202,0xBE88,0x91CF,0xBEDF,0x919C,0xBF35,0x9169,
0xBF8C,0x9137,0xBFE3,0x9105,0xC03A,0x90D3,0xC091,0x90A1,0xC0E9,0x9070,0xC140,
0x903E,0xC198,0x900E,0xC1F0,0x8FDD,0xC248,0x8FAD,0xC2A0,0x8F7D,0xC2F8,0x8F4D,
0xC351,0x8F1D,0xC3A9,0x8EEE,0xC402,0x8EBF,0xC45B,0x8E90,0xC4B4,0x8E62,0xC50D,
0x8E34,0xC566,0x8E06,0xC5C0,0x8DD8,0xC619,0x8DAB,0xC673,0x8D7E,0xC6CD,0x8D51,
0xC727,0x8D24,0xC781,0x8CF8,0xC7DB,0x8CCC,0xC836,0x8CA1,0xC890,0x8C75,0xC8EB,
0x8C4A,0xC946,0x8C1F,0xC9A1,0x8BF5,0xC9FC,0x8BCA,0xCA57,0x8BA0,0xCAB2,0x8B77,
0xCB0E,0x8B4D,0xCB69,0x8B24,0xCBC5,0x8AFB,0xCC21,0x8AD3,0xCC7D,0x8AAA,0xCCD9,
0x8A82,0xCD35,0x8A5A,0xCD92,0x8A33,0xCDEE,0x8A0C,0xCE4B,0x89E5,0xCEA7,0x89BE,
0xCF04,0x8998,0xCF61,0x8972,0xCFBE,0x894C,0xD01B,0x8927,0xD079,0x8902,0xD0D6,
0x88DD,0xD134,0x88B8,0xD191,0x8894,0xD1EF,0x8870,0xD24D,0x884C,0xD2AB,0x8828,
0xD309,0x8805,0xD367,0x87E2,0xD3C5,0x87C0,0xD424,0x879D,0xD482,0x877B,0xD4E1,
0x875A,0xD53F,0x8738,0xD59E,0x8717,0xD5FD,0x86F6,0xD65C,0x86D6,0xD6BB,0x86B6,
0xD71B,0x8696,0xD77A,0x8676,0xD7D9,0x8656,0xD839,0x8637,0xD898,0x8619,0xD8F8,
0x85FA,0xD958,0x85DC,0xD9B8,0x85BE,0xDA18,0x85A0,0xDA78,0x8583,0xDAD8,0x8566,
0xDB38,0x8549,0xDB99,0x852D,0xDBF9,0x8511,0xDC59,0x84F5,0xDCBA,0x84D9,0xDD1B,
0x84BE,0xDD7C,0x84A3,0xDDDC,0x8488,0xDE3D,0x846E,0xDE9E,0x8454,0xDEFF,0x843A,
0xDF61,0x8421,0xDFC2,0x8407,0xE023,0x83EF,0xE085,0x83D6,0xE0E6,0x83BE,0xE148,
0x83A6,0xE1A9,0x838E,0xE20B,0x8377,0xE26D,0x8360,0xE2CF,0x8349,0xE330,0x8332,
0xE392,0x831C,0xE3F4,0x8306,0xE457,0x82F1,0xE4B9,0x82DB,0xE51B,0x82C6,0xE57D,
0x82B2,0xE5E0,0x829D,0xE642,0x8289,0xE6A5,0x8276,0xE707,0x8262,0xE76A,0x824F,
0xE7CD,0x823C,0xE82F,0x822A,0xE892,0x8217,0xE8F5,0x8205,0xE958,0x81F4,0xE9BB,
0x81E2,0xEA1E,0x81D1,0xEA81,0x81C1,0xEAE4,0x81B0,0xEB47,0x81A0,0xEBAB,0x8190,
0xEC0E,0x8181,0xEC71,0x8172,0xECD5,0x8163,0xED38,0x8154,0xED9B,0x8146,0xEDFF,
0x8138,0xEE62,0x812A,0xEEC6,0x811D,0xEF2A,0x8110,0xEF8D,0x8103,0xEFF1,0x80F6,
0xF055,0x80EA,0xF0B9,0x80DE,0xF11C,0x80D3,0xF180,0x80C8,0xF1E4,0x80BD,0xF248,
0x80B2,0xF2AC,0x80A8,0xF310,0x809E,0xF374,0x8094,0xF3D8,0x808B,0xF43C,0x8082,
0xF4A0,0x8079,0xF505,0x8070,0xF569,0x8068,0xF5CD,0x8060,0xF631,0x8059,0xF695,
0x8052,0xF6FA,0x804B,0xF75E,0x8044,0xF7C2,0x803E,0xF827,0x8038,0xF88B,0x8032,
0xF8EF,0x802D,0xF954,0x8027,0xF9B8,0x8023,0xFA1D,0x801E,0xFA81,0x801A,0xFAE5,
0x8016,0xFB4A,0x8013,0xFBAE,0x800F,0xFC13,0x800C,0xFC77,0x800A,0xFCDC,0x8008,
0xFD40,0x8006,0xFDA5,0x8004,0xFE09,0x8002,0xFE6E,0x8001,0xFED2,0x8001,0xFF37,
0x8000,0xFF9B,0x7FFF,0x0000,0x7FFE,0xFE6E,0x7FF6,0xFCDC,0x7FEA,0xFB4A,0x7FD9,
0xF9B8,0x7FC2,0xF827,0x7FA7,0xF695,0x7F87,0xF505,0x7F62,0xF374,0x7F38,0xF1E4,
0x7F0A,0xF055,0x7ED6,0xEEC6,0x7E9D,0xED38,0x7E60,0xEBAB,0x7E1E,0xEA1E,0x7DD6,
0xE892,0x7D8A,0xE707,0x7D3A,0xE57D,0x7CE4,0xE3F4,0x7C89,0xE26D,0x7C2A,0xE0E6,
0x7BC6,0xDF61,0x7B5D,0xDDDC,0x7AEF,0xDC59,0x7A7D,0xDAD8,0x7A06,0xD958,0x798A,
0xD7D9,0x790A,0xD65C,0x7885,0xD4E1,0x77FB,0xD367,0x776C,0xD1EF,0x76D9,0xD079,
0x7642,0xCF04,0x75A6,0xCD92,0x7505,0xCC21,0x7460,0xCAB2,0x73B6,0xC946,0x7308,
0xC7DB,0x7255,0xC673,0x719E,0xC50D,0x70E3,0xC3A9,0x7023,0xC248,0x6F5F,0xC0E9,
0x6E97,0xBF8C,0x6DCA,0xBE32,0x6CF9,0xBCDA,0x6C24,0xBB85,0x6B4B,0xBA33,0x6A6E,
0xB8E3,0x698C,0xB796,0x68A7,0xB64C,0x67BD,0xB505,0x66D0,0xB3C0,0x65DE,0xB27F,
0x64E9,0xB140,0x63EF,0xB005,0x62F2,0xAECC,0x61F1,0xAD97,0x60EC,0xAC65,0x5FE4,
0xAB36,0x5ED7,0xAA0A,0x5DC8,0xA8E2,0x5CB4,0xA7BD,0x5B9D,0xA69C,0x5A82,0xA57E,
0x5964,0xA463,0x5843,0xA34C,0x571E,0xA238,0x55F6,0xA129,0x54CA,0xA01C,0x539B,
0x9F14,0x5269,0x9E0F,0x5134,0x9D0E,0x4FFB,0x9C11,0x4EC0,0x9B17,0x4D81,0x9A22,
0x4C40,0x9930,0x4AFB,0x9843,0x49B4,0x9759,0x486A,0x9674,0x471D,0x9592,0x45CD,
0x94B5,0x447B,0x93DC,0x4326,0x9307,0x41CE,0x9236,0x4074,0x9169,0x3F17,0x90A1,
0x3DB8,0x8FDD,0x3C57,0x8F1D,0x3AF3,0x8E62,0x398D,0x8DAB,0x3825,0x8CF8,0x36BA,
0x8C4A,0x354E,0x8BA0,0x33DF,0x8AFB,0x326E,0x8A5A,0x30FC,0x89BE,0x2F87,0x8927,
0x2E11,0x8894,0x2C99,0x8805,0x2B1F,0x877B,0x29A4,0x86F6,0x2827,0x8676,0x26A8,
0x85FA,0x2528,0x8583,0x23A7,0x8511,0x2224,0x84A3,0x209F,0x843A,0x1F1A,0x83D6,
0x1D93,0x8377,0x1C0C,0x831C,0x1A83,0x82C6,0x18F9,0x8276,0x176E,0x822A,0x15E2,
0x81E2,0x1455,0x81A0,0x12C8,0x8163,0x113A,0x812A,0x0FAB,0x80F6,0x0E1C,0x80C8,
0x0C8C,0x809E,0x0AFB,0x8079,0x096B,0x8059,0x07D9,0x803E,0x0648,0x8027,0x04B6,
0x8016,0x0324,0x800A,0x0192,0x8002,0x0000,0x8000,0xFE6E,0x8002,0xFCDC,0x800A,
0xFB4A,0x8016,0xF9B8,0x8027,0xF827,0x803E,0xF695,0x8059,0xF505,0x8079,0xF374,
0x809E,0xF1E4,0x80C8,0xF055,0x80F6,0xEEC6,0x812A,0xED38,0x8163,0xEBAB,0x81A0,
0xEA1E,0x81E2,0xE892,0x822A,0xE707,0x8276,0xE57D,0x82C6,0xE3F4,0x831C,0xE26D,
0x8377,0xE0E6,0x83D6,0xDF61,0x843A,0xDDDC,0x84A3,0xDC59,0x8511,0xDAD8,0x8583,
0xD958,0x85FA,0xD7D9,0x8676,0xD65C,0x86F6,0xD4E1,0x877B,0xD367,0x8805,0xD1EF,
0x8894,0xD079,0x8927,0xCF04,0x89BE,0xCD92,0x8A5A,0xCC21,0x8AFB,0xCAB2,0x8BA0,
0xC946,0x8C4A,0xC7DB,0x8CF8,0xC673,0x8DAB,0xC50D,0x8E62,0xC3A9,0x8F1D,0xC248,
0x8FDD,0xC0E9,0x90A1,0xBF8C,0x9169,0xBE32,0x9236,0xBCDA,0x9307,0xBB85,0x93DC,
0xBA33,0x94B5,0xB8E3,0x9592,0xB796,0x9674,0xB64C,0x9759,0xB505,0x9843,0xB3C0,
0x9930,0xB27F,0x9A22,0xB140,0x9B17,0xB005,0x9C11,0xAECC,0x9D0E,0xAD97,0x9E0F,
0xAC65,0x9F14,0xAB36,0xA01C,0xAA0A,0xA129,0xA8E2,0xA238,0xA7BD,0xA34C,0xA69C,
0xA463,0xA57E,0xA57E,0xA463,0xA69C,0xA34C,0xA7BD,0xA238,0xA8E2,0xA129,0xAA0A,
0xA01C,0xAB36,0x9F14,0xAC65,0x9E0F,0xAD97,0x9D0E,0xAECC,0x9C11,0xB005,0x9B17,
0xB140,0x9A22,0xB27F,0x9930,0xB3C0,0x9843,0xB505,0x9759,0xB64C,0x9674,0xB796,
0x9592,0xB8E3,0x94B5,0xBA33,0x93DC,0xBB85,0x9307,0xBCDA,0x9236,0xBE32,0x9169,
0xBF8C,0x90A1,0xC0E9,0x8FDD,0xC248,0x8F1D,0xC3A9,0x8E62,0xC50D,0x8DAB,0xC673,
0x8CF8,0xC7DB,0x8C4A,0xC946,0x8BA0,0xCAB2,0x8AFB,0xCC21,0x8A5A,0xCD92,0x89BE,
0xCF04,0x8927,0xD079,0x8894,0xD1EF,0x8805,0xD367,0x877B,0xD4E1,0x86F6,0xD65C,
0x8676,0xD7D9,0x85FA,0xD958,0x8583,0xDAD8,0x8511,0xDC59,0x84A3,0xDDDC,0x843A,
0xDF61,0x83D6,0xE0E6,0x8377,0xE26D,0x831C,0xE3F4,0x82C6,0xE57D,0x8276,0xE707,
0x822A,0xE892,0x81E2,0xEA1E,0x81A0,0xEBAB,0x8163,0xED38,0x812A,0xEEC6,0x80F6,
0xF055,0x80C8,0xF1E4,0x809E,0xF374,0x8079,0xF505,0x8059,0xF695,0x803E,0xF827,
0x8027,0xF9B8,0x8016,0xFB4A,0x800A,0xFCDC,0x8002,0xFE6E,0x7FFF,0x0000,0x7FD9,
0xF9B8,0x7F62,0xF374,0x7E9D,0xED38,0x7D8A,0xE707,0x7C2A,0xE0E6,0x7A7D,0xDAD8,
0x7885,0xD4E1,0x7642,0xCF04,0x73B6,0xC946,0x70E3,0xC3A9,0x6DCA,0xBE32,0x6A6E,
0xB8E3,0x66D0,0xB3C0,0x62F2,0xAECC,0x5ED7,0xAA0A,0x5A82,0xA57E,0x55F6,0xA129,
0x5134,0x9D0E,0x4C40,0x9930,0x471D,0x9592,0x41CE,0x9236,0x3C57,0x8F1D,0x36BA,
0x8C4A,0x30FC,0x89BE,0x2B1F,0x877B,0x2528,0x8583,0x1F1A,0x83D6,0x18F9,0x8276,
0x12C8,0x8163,0x0C8C,0x809E,0x0648,0x8027,0x0000,0x8000,0xF9B8,0x8027,0xF374,
0x809E,0xED38,0x8163,0xE707,0x8276,0xE0E6,0x83D6,0xDAD8,0x8583,0xD4E1,0x877B,
0xCF04,0x89BE,0xC946,0x8C4A,0xC3A9,0x8F1D,0xBE32,0x9236,0xB8E3,0x9592,0xB3C0,
0x9930,0xAECC,0x9D0E,0xAA0A,0xA129,0xA57E,0xA57E,0xA129,0xAA0A,0x9D0E,0xAECC,
0x9930,0xB3C0,0x9592,0xB8E3,0x9236,0xBE32,0x8F1D,0xC3A9,0x8C4A,0xC946,0x89BE,
0xCF04,0x877B,0xD4E1,0x8583,0xDAD8,0x83D6,0xE0E6,0x8276,0xE707,0x8163,0xED38,
0x809E,0xF374,0x8027,0xF9B8,0x7FFF,0x0000,0x7D8A,0xE707,0x7642,0xCF04,0x6A6E,
0xB8E3,0x5A82,0xA57E,0x471D,0x9592,0x30FC,0x89BE,0x18F9,0x8276,0x0000,0x8000,
0xE707,0x8276,0xCF04,0x89BE,0xB8E3,0x9592,0xA57E,0xA57E,0x9592,0xB8E3,0x89BE,
0xCF04,0x8276,0xE707,0x7FFF,0x0000,0x5A82,0xA57E,0x0000,0x8000,0xA57E,0xA57E,};

q15_t rearranged_twiddle_stride3_4096_q15[2728]={
0x7FFF,0x0000,0x7FFF,0xFF69,0x7FFF,0xFED2,0x7FFD,0xFE3C,0x7FFA,0xFDA5,0x7FF7,
0xFD0E,0x7FF4,0xFC77,0x7FEF,0xFBE1,0x7FEA,0xFB4A,0x7FE4,0xFAB3,0x7FDD,0xFA1D,
0x7FD6,0xF986,0x7FCE,0xF8EF,0x7FC5,0xF859,0x7FBC,0xF7C2,0x7FB2,0xF72C,0x7FA7,
0xF695,0x7F9C,0xF5FF,0x7F90,0xF569,0x7F83,0xF4D3,0x7F75,0xF43C,0x7F67,0xF3A6,
0x7F58,0xF310,0x7F49,0xF27A,0x7F38,0xF1E4,0x7F27,0xF14E,0x7F16,0xF0B9,0x7F03,
0xF023,0x7EF0,0xEF8D,0x7EDD,0xEEF8,0x7EC8,0xEE62,0x7EB3,0xEDCD,0x7E9D,0xED38,
0x7E87,0xECA3,0x7E70,0xEC0E,0x7E58,0xEB79,0x7E3F,0xEAE4,0x7E26,0xEA4F,0x7E0C,
0xE9BB,0x7DF2,0xE926,0x7DD6,0xE892,0x7DBA,0xE7FE,0x7D9E,0xE76A,0x7D81,0xE6D6,
0x7D63,0xE642,0x7D44,0xE5AF,0x7D25,0xE51B,0x7D05,0xE488,0x7CE4,0xE3F4,0x7CC2,
0xE361,0x7CA0,0xE2CF,0x7C7E,0xE23C,0x7C5A,0xE1A9,0x7C36,0xE117,0x7C11,0xE085,
0x7BEC,0xDFF2,0x7BC6,0xDF61,0x7B9F,0xDECF,0x7B78,0xDE3D,0x7B50,0xDDAC,0x7B27,
0xDD1B,0x7AFD,0xDC8A,0x7AD3,0xDBF9,0x7AA8,0xDB68,0x7A7D,0xDAD8,0x7A51,0xDA48,
0x7A24,0xD9B8,0x79F7,0xD928,0x79C9,0xD898,0x799A,0xD809,0x796A,0xD77A,0x793A,
0xD6EB,0x790A,0xD65C,0x78D8,0xD5CE,0x78A6,0xD53F,0x7874,0xD4B1,0x7840,0xD424,
0x780C,0xD396,0x77D8,0xD309,0x77A2,0xD27C,0x776C,0xD1EF,0x7736,0xD162,0x76FE,
0xD0D6,0x76C7,0xD04A,0x768E,0xCFBE,0x7655,0xCF33,0x761B,0xCEA7,0x75E1,0xCE1C,
0x75A6,0xCD92,0x756A,0xCD07,0x752D,0xCC7D,0x74F0,0xCBF3,0x74B3,0xCB69,0x7475,
0xCAE0,0x7436,0xCA57,0x73F6,0xC9CE,0x73B6,0xC946,0x7375,0xC8BE,0x7334,0xC836,
0x72F2,0xC7AE,0x72AF,0xC727,0x726C,0xC6A0,0x7228,0xC619,0x71E3,0xC593,0x719E,
0xC50D,0x7158,0xC487,0x7112,0xC402,0x70CB,0xC37D,0x7083,0xC2F8,0x703B,0xC274,
0x6FF2,0xC1F0,0x6FA9,0xC16C,0x6F5F,0xC0E9,0x6F14,0xC066,0x6EC9,0xBFE3,0x6E7D,
0xBF61,0x6E31,0xBEDF,0x6DE4,0xBE5D,0x6D96,0xBDDC,0x6D48,0xBD5B,0x6CF9,0xBCDA,
0x6CAA,0xBC5A,0x6C5A,0xBBDA,0x6C09,0xBB5B,0x6BB8,0xBADC,0x6B66,0xBA5D,0x6B14,
0xB9DF,0x6AC1,0xB961,0x6A6E,0xB8E3,0x6A1A,0xB866,0x69C5,0xB7E9,0x6970,0xB76D,
0x691A,0xB6F1,0x68C4,0xB675,0x686D,0xB5FA,0x6815,0xB57F,0x67BD,0xB505,0x6764,
0xB48B,0x670B,0xB411,0x66B2,0xB398,0x6657,0xB31F,0x65FC,0xB2A7,0x65A1,0xB22F,
0x6545,0xB1B7,0x64E9,0xB140,0x648B,0xB0C9,0x642E,0xB053,0x63D0,0xAFDD,0x6371,
0xAF68,0x6312,0xAEF3,0x62B2,0xAE7F,0x6252,0xAE0B,0x61F1,0xAD97,0x6190,0xAD24,
0x612E,0xACB1,0x60CB,0xAC3F,0x6068,0xABCD,0x6005,0xAB5C,0x5FA1,0xAAEB,0x5F3C,
0xAA7A,0x5ED7,0xAA0A,0x5E72,0xA99B,0x5E0C,0xA92C,0x5DA5,0xA8BD,0x5D3E,0xA84F,
0x5CD7,0xA7E2,0x5C6F,0xA774,0x5C06,0xA708,0x5B9D,0xA69C,0x5B34,0xA630,0x5AC9,
0xA5C5,0x5A5F,0xA55A,0x59F4,0xA4F0,0x5988,0xA486,0x591C,0xA41D,0x58B0,0xA3B4,
0x5843,0xA34C,0x57D5,0xA2E4,0x5767,0xA27D,0x56F9,0xA216,0x568A,0xA1B0,0x561B,
0xA14A,0x55AB,0xA0E5,0x553B,0xA080,0x54CA,0xA01C,0x5459,0x9FB9,0x53E7,0x9F56,
0x5375,0x9EF3,0x5303,0x9E91,0x5290,0x9E2F,0x521C,0x9DCE,0x51A8,0x9D6E,0x5134,
0x9D0E,0x50BF,0x9CAF,0x504A,0x9C50,0x4FD4,0x9BF1,0x4F5E,0x9B94,0x4EE8,0x9B36,
0x4E71,0x9ADA,0x4DF9,0x9A7E,0x4D81,0x9A22,0x4D09,0x99C7,0x4C91,0x996D,0x4C17,
0x9913,0x4B9E,0x98B9,0x4B24,0x9860,0x4AAA,0x9808,0x4A2F,0x97B0,0x49B4,0x9759,
0x4939,0x9703,0x48BD,0x96AD,0x4840,0x9657,0x47C4,0x9603,0x4747,0x95AE,0x46C9,
0x955B,0x464B,0x9508,0x45CD,0x94B5,0x454F,0x9463,0x44D0,0x9412,0x4450,0x93C1,
0x43D1,0x9371,0x4351,0x9321,0x42D0,0x92D2,0x424F,0x9284,0x41CE,0x9236,0x414D,
0x91E9,0x40CB,0x919C,0x4048,0x9150,0x3FC6,0x9105,0x3F43,0x90BA,0x3EC0,0x9070,
0x3E3C,0x9026,0x3DB8,0x8FDD,0x3D34,0x8F95,0x3CAF,0x8F4D,0x3C2A,0x8F06,0x3BA5,
0x8EBF,0x3B20,0x8E79,0x3A9A,0x8E34,0x3A13,0x8DEF,0x398D,0x8DAB,0x3906,0x8D67,
0x387F,0x8D24,0x37F7,0x8CE2,0x3770,0x8CA1,0x36E8,0x8C60,0x365F,0x8C1F,0x35D7,
0x8BDF,0x354E,0x8BA0,0x34C4,0x8B62,0x343B,0x8B24,0x33B1,0x8AE7,0x3327,0x8AAA,
0x329D,0x8A6E,0x3212,0x8A33,0x3187,0x89F8,0x30FC,0x89BE,0x3070,0x8985,0x2FE5,
0x894C,0x2F59,0x8914,0x2ECC,0x88DD,0x2E40,0x88A6,0x2DB3,0x8870,0x2D26,0x883A,
0x2C99,0x8805,0x2C0C,0x87D1,0x2B7E,0x879D,0x2AF0,0x876B,0x2A62,0x8738,0x29D3,
0x8707,0x2945,0x86D6,0x28B6,0x86A5,0x2827,0x8676,0x2797,0x8647,0x2708,0x8619,
0x2678,0x85EB,0x25E8,0x85BE,0x2558,0x8592,0x24C8,0x8566,0x2437,0x853B,0x23A7,
0x8511,0x2316,0x84E7,0x2284,0x84BE,0x21F3,0x8496,0x2162,0x846E,0x20D0,0x8447,
0x203E,0x8421,0x1FAC,0x83FB,0x1F1A,0x83D6,0x1E88,0x83B2,0x1DF5,0x838E,0x1D62,
0x836B,0x1CD0,0x8349,0x1C3D,0x8327,0x1BA9,0x8306,0x1B16,0x82E6,0x1A83,0x82C6,
0x19EF,0x82A8,0x195B,0x8289,0x18C7,0x826C,0x1833,0x824F,0x179F,0x8233,0x170B,
0x8217,0x1677,0x81FD,0x15E2,0x81E2,0x154D,0x81C9,0x14B9,0x81B0,0x1424,0x8198,
0x138F,0x8181,0x12FA,0x816A,0x1265,0x8154,0x11CF,0x813F,0x113A,0x812A,0x10A4,
0x8116,0x100F,0x8103,0x0F79,0x80F0,0x0EE4,0x80DE,0x0E4E,0x80CD,0x0DB8,0x80BD,
0x0D22,0x80AD,0x0C8C,0x809E,0x0BF6,0x808F,0x0B60,0x8082,0x0AC9,0x8075,0x0A33,
0x8068,0x099D,0x805D,0x0906,0x8052,0x0870,0x8047,0x07D9,0x803E,0x0743,0x8035,
0x06AC,0x802D,0x0616,0x8025,0x057F,0x801E,0x04E8,0x8018,0x0452,0x8013,0x03BB,
0x800E,0x0324,0x800A,0x028D,0x8007,0x01F7,0x8004,0x0160,0x8002,0x00C9,0x8001,
0x0032,0x8000,0xFF9B,0x8000,0xFF05,0x8001,0xFE6E,0x8002,0xFDD7,0x8005,0xFD40,
0x8008,0xFCAA,0x800B,0xFC13,0x800F,0xFB7C,0x8014,0xFAE5,0x801A,0xFA4F,0x8020,
0xF9B8,0x8027,0xF922,0x802F,0xF88B,0x8038,0xF7F4,0x8041,0xF75E,0x804B,0xF6C8,
0x8055,0xF631,0x8060,0xF59B,0x806C,0xF505,0x8079,0xF46E,0x8086,0xF3D8,0x8094,
0xF342,0x80A3,0xF2AC,0x80B2,0xF216,0x80C2,0xF180,0x80D3,0xF0EB,0x80E4,0xF055,
0x80F6,0xEFBF,0x8109,0xEF2A,0x811D,0xEE94,0x8131,0xEDFF,0x8146,0xED6A,0x815B,
0xECD5,0x8172,0xEC3F,0x8188,0xEBAB,0x81A0,0xEB16,0x81B8,0xEA81,0x81D1,0xE9EC,
0x81EB,0xE958,0x8205,0xE8C4,0x8220,0xE82F,0x823C,0xE79B,0x8259,0xE707,0x8276,
0xE673,0x8293,0xE5E0,0x82B2,0xE54C,0x82D1,0xE4B9,0x82F1,0xE426,0x8311,0xE392,
0x8332,0xE2FF,0x8354,0xE26D,0x8377,0xE1DA,0x839A,0xE148,0x83BE,0xE0B5,0x83E2,
0xE023,0x8407,0xDF91,0x842D,0xDEFF,0x8454,0xDE6E,0x847B,0xDDDC,0x84A3,0xDD4B,
0x84CC,0xDCBA,0x84F5,0xDC29,0x851F,0xDB99,0x8549,0xDB08,0x8574,0xDA78,0x85A0,
0xD9E8,0x85CD,0xD958,0x85FA,0xD8C8,0x8628,0xD839,0x8656,0xD7AA,0x8686,0xD71B,
0x86B6,0xD68C,0x86E6,0xD5FD,0x8717,0xD56F,0x8749,0xD4E1,0x877B,0xD453,0x87AF,
0xD3C5,0x87E2,0xD338,0x8817,0xD2AB,0x884C,0xD21E,0x8882,0xD191,0x88B8,0xD105,
0x88EF,0xD079,0x8927,0xCFED,0x895F,0xCF61,0x8998,0xCED6,0x89D2,0xCE4B,0x8A0C,
0xCDC0,0x8A47,0xCD35,0x8A82,0xCCAB,0x8ABE,0xCC21,0x8AFB,0xCB97,0x8B39,0xCB0E,
0x8B77,0xCA85,0x8BB5,0xC9FC,0x8BF5,0xC973,0x8C35,0xC8EB,0x8C75,0xC863,0x8CB6,
0xC7DB,0x8CF8,0xC754,0x8D3B,0xC6CD,0x8D7E,0xC646,0x8DC1,0xC5C0,0x8E06,0xC53A,
0x8E4B,0xC4B4,0x8E90,0xC42E,0x8ED6,0xC3A9,0x8F1D,0xC324,0x8F65,0xC2A0,0x8FAD,
0xC21C,0x8FF5,0xC198,0x903E,0xC114,0x9088,0xC091,0x90D3,0xC00F,0x911E,0xBF8C,
0x9169,0xBF0A,0x91B6,0xBE88,0x9202,0xBE07,0x9250,0xBD86,0x929E,0xBD05,0x92EC,
0xBC85,0x933C,0xBC05,0x938B,0xBB85,0x93DC,0xBB06,0x942D,0xBA87,0x947E,0xBA09,
0x94D0,0xB98B,0x9523,0xB90D,0x9577,0xB890,0x95CA,0xB813,0x961F,0xB796,0x9674,
0xB71A,0x96C9,0xB69E,0x9720,0xB623,0x9776,0xB5A8,0x97CE,0xB52D,0x9826,0xB4B3,
0x987E,0xB439,0x98D7,0xB3C0,0x9930,0xB347,0x998B,0xB2CF,0x99E5,0xB257,0x9A40,
0xB1DF,0x9A9C,0xB168,0x9AF9,0xB0F1,0x9B55,0xB07B,0x9BB3,0xB005,0x9C11,0xAF8F,
0x9C6F,0xAF1A,0x9CCE,0xAEA5,0x9D2E,0xAE31,0x9D8E,0xADBD,0x9DEF,0xAD4A,0x9E50,
0xACD7,0x9EB2,0xAC65,0x9F14,0xABF3,0x9F77,0xAB81,0x9FDA,0xAB10,0xA03E,0xAAA0,
0xA0A2,0xAA30,0xA107,0xA9C0,0xA16C,0xA951,0xA1D2,0xA8E2,0xA238,0xA874,0xA29F,
0xA806,0xA307,0xA799,0xA36F,0xA72C,0xA3D7,0xA6C0,0xA440,0xA654,0xA4A9,0xA5E8,
0xA513,0xA57E,0xA57E,0xA513,0xA5E8,0xA4A9,0xA654,0xA440,0xA6C0,0xA3D7,0xA72C,
0xA36F,0xA799,0xA307,0xA806,0xA29F,0xA874,0xA238,0xA8E2,0xA1D2,0xA951,0xA16C,
0xA9C0,0xA107,0xAA30,0xA0A2,0xAAA0,0xA03E,0xAB10,0x9FDA,0xAB81,0x9F77,0xABF3,
0x9F14,0xAC65,0x9EB2,0xACD7,0x9E50,0xAD4A,0x9DEF,0xADBD,0x9D8E,0xAE31,0x9D2E,
0xAEA5,0x9CCE,0xAF1A,0x9C6F,0xAF8F,0x9C11,0xB005,0x9BB3,0xB07B,0x9B55,0xB0F1,
0x9AF9,0xB168,0x9A9C,0xB1DF,0x9A40,0xB257,0x99E5,0xB2CF,0x998B,0xB347,0x9930,
0xB3C0,0x98D7,0xB439,0x987E,0xB4B3,0x9826,0xB52D,0x97CE,0xB5A8,0x9776,0xB623,
0x9720,0xB69E,0x96C9,0xB71A,0x9674,0xB796,0x961F,0xB813,0x95CA,0xB890,0x9577,
0xB90D,0x9523,0xB98B,0x94D0,0xBA09,0x947E,0xBA87,0x942D,0xBB06,0x93DC,0xBB85,
0x938B,0xBC05,0x933C,0xBC85,0x92EC,0xBD05,0x929E,0xBD86,0x9250,0xBE07,0x9202,
0xBE88,0x91B6,0xBF0A,0x9169,0xBF8C,0x911E,0xC00F,0x90D3,0xC091,0x9088,0xC114,
0x903E,0xC198,0x8FF5,0xC21C,0x8FAD,0xC2A0,0x8F65,0xC324,0x8F1D,0xC3A9,0x8ED6,
0xC42E,0x8E90,0xC4B4,0x8E4B,0xC53A,0x8E06,0xC5C0,0x8DC1,0xC646,0x8D7E,0xC6CD,
0x8D3B,0xC754,0x8CF8,0xC7DB,0x8CB6,0xC863,0x8C75,0xC8EB,0x8C35,0xC973,0x8BF5,
0xC9FC,0x8BB5,0xCA85,0x8B77,0xCB0E,0x8B39,0xCB97,0x8AFB,0xCC21,0x8ABE,0xCCAB,
0x8A82,0xCD35,0x8A47,0xCDC0,0x8A0C,0xCE4B,0x89D2,0xCED6,0x8998,0xCF61,0x895F,
0xCFED,0x8927,0xD079,0x88EF,0xD105,0x88B8,0xD191,0x8882,0xD21E,0x884C,0xD2AB,
0x8817,0xD338,0x87E2,0xD3C5,0x87AF,0xD453,0x877B,0xD4E1,0x8749,0xD56F,0x8717,
0xD5FD,0x86E6,0xD68C,0x86B6,0xD71B,0x8686,0xD7AA,0x8656,0xD839,0x8628,0xD8C8,
0x85FA,0xD958,0x85CD,0xD9E8,0x85A0,0xDA78,0x8574,0xDB08,0x8549,0xDB99,0x851F,
0xDC29,0x84F5,0xDCBA,0x84CC,0xDD4B,0x84A3,0xDDDC,0x847B,0xDE6E,0x8454,0xDEFF,
0x842D,0xDF91,0x8407,0xE023,0x83E2,0xE0B5,0x83BE,0xE148,0x839A,0xE1DA,0x8377,
0xE26D,0x8354,0xE2FF,0x8332,0xE392,0x8311,0xE426,0x82F1,0xE4B9,0x82D1,0xE54C,
0x82B2,0xE5E0,0x8293,0xE673,0x8276,0xE707,0x8259,0xE79B,0x823C,0xE82F,0x8220,
0xE8C4,0x8205,0xE958,0x81EB,0xE9EC,0x81D1,0xEA81,0x81B8,0xEB16,0x81A0,0xEBAB,
0x8188,0xEC3F,0x8172,0xECD5,0x815B,0xED6A,0x8146,0xEDFF,0x8131,0xEE94,0x811D,
0xEF2A,0x8109,0xEFBF,0x80F6,0xF055,0x80E4,0xF0EB,0x80D3,0xF180,0x80C2,0xF216,
0x80B2,0xF2AC,0x80A3,0xF342,0x8094,0xF3D8,0x8086,0xF46E,0x8079,0xF505,0x806C,
0xF59B,0x8060,0xF631,0x8055,0xF6C8,0x804B,0xF75E,0x8041,0xF7F4,0x8038,0xF88B,
0x802F,0xF922,0x8027,0xF9B8,0x8020,0xFA4F,0x801A,0xFAE5,0x8014,0xFB7C,0x800F,
0xFC13,0x800B,0xFCAA,0x8008,0xFD40,0x8005,0xFDD7,0x8002,0xFE6E,0x8001,0xFF05,
0x8000,0xFF9B,0x8000,0x0032,0x8001,0x00C9,0x8002,0x0160,0x8004,0x01F7,0x8007,
0x028D,0x800A,0x0324,0x800E,0x03BB,0x8013,0x0452,0x8018,0x04E8,0x801E,0x057F,
0x8025,0x0616,0x802D,0x06AC,0x8035,0x0743,0x803E,0x07D9,0x8047,0x0870,0x8052,
0x0906,0x805D,0x099D,0x8068,0x0A33,0x8075,0x0AC9,0x8082,0x0B60,0x808F,0x0BF6,
0x809E,0x0C8C,0x80AD,0x0D22,0x80BD,0x0DB8,0x80CD,0x0E4E,0x80DE,0x0EE4,0x80F0,
0x0F79,0x8103,0x100F,0x8116,0x10A4,0x812A,0x113A,0x813F,0x11CF,0x8154,0x1265,
0x816A,0x12FA,0x8181,0x138F,0x8198,0x1424,0x81B0,0x14B9,0x81C9,0x154D,0x81E2,
0x15E2,0x81FD,0x1677,0x8217,0x170B,0x8233,0x179F,0x824F,0x1833,0x826C,0x18C7,
0x8289,0x195B,0x82A8,0x19EF,0x82C6,0x1A83,0x82E6,0x1B16,0x8306,0x1BA9,0x8327,
0x1C3D,0x8349,0x1CD0,0x836B,0x1D62,0x838E,0x1DF5,0x83B2,0x1E88,0x83D6,0x1F1A,
0x83FB,0x1FAC,0x8421,0x203E,0x8447,0x20D0,0x846E,0x2162,0x8496,0x21F3,0x84BE,
0x2284,0x84E7,0x2316,0x8511,0x23A7,0x853B,0x2437,0x8566,0x24C8,0x8592,0x2558,
0x85BE,0x25E8,0x85EB,0x2678,0x8619,0x2708,0x8647,0x2797,0x8676,0x2827,0x86A5,
0x28B6,0x86D6,0x2945,0x8707,0x29D3,0x8738,0x2A62,0x876B,0x2AF0,0x879D,0x2B7E,
0x87D1,0x2C0C,0x8805,0x2C99,0x883A,0x2D26,0x8870,0x2DB3,0x88A6,0x2E40,0x88DD,
0x2ECC,0x8914,0x2F59,0x894C,0x2FE5,0x8985,0x3070,0x89BE,0x30FC,0x89F8,0x3187,
0x8A33,0x3212,0x8A6E,0x329D,0x8AAA,0x3327,0x8AE7,0x33B1,0x8B24,0x343B,0x8B62,
0x34C4,0x8BA0,0x354E,0x8BDF,0x35D7,0x8C1F,0x365F,0x8C60,0x36E8,0x8CA1,0x3770,
0x8CE2,0x37F7,0x8D24,0x387F,0x8D67,0x3906,0x8DAB,0x398D,0x8DEF,0x3A13,0x8E34,
0x3A9A,0x8E79,0x3B20,0x8EBF,0x3BA5,0x8F06,0x3C2A,0x8F4D,0x3CAF,0x8F95,0x3D34,
0x8FDD,0x3DB8,0x9026,0x3E3C,0x9070,0x3EC0,0x90BA,0x3F43,0x9105,0x3FC6,0x9150,
0x4048,0x919C,0x40CB,0x91E9,0x414D,0x9236,0x41CE,0x9284,0x424F,0x92D2,0x42D0,
0x9321,0x4351,0x9371,0x43D1,0x93C1,0x4450,0x9412,0x44D0,0x9463,0x454F,0x94B5,
0x45CD,0x9508,0x464B,0x955B,0x46C9,0x95AE,0x4747,0x9603,0x47C4,0x9657,0x4840,
0x96AD,0x48BD,0x9703,0x4939,0x9759,0x49B4,0x97B0,0x4A2F,0x9808,0x4AAA,0x9860,
0x4B24,0x98B9,0x4B9E,0x9913,0x4C17,0x996D,0x4C91,0x99C7,0x4D09,0x9A22,0x4D81,
0x9A7E,0x4DF9,0x9ADA,0x4E71,0x9B36,0x4EE8,0x9B94,0x4F5E,0x9BF1,0x4FD4,0x9C50,
0x504A,0x9CAF,0x50BF,0x9D0E,0x5134,0x9D6E,0x51A8,0x9DCE,0x521C,0x9E2F,0x5290,
0x9E91,0x5303,0x9EF3,0x5375,0x9F56,0x53E7,0x9FB9,0x5459,0xA01C,0x54CA,0xA080,
0x553B,0xA0E5,0x55AB,0xA14A,0x561B,0xA1B0,0x568A,0xA216,0x56F9,0xA27D,0x5767,
0xA2E4,0x57D5,0xA34C,0x5843,0xA3B4,0x58B0,0xA41D,0x591C,0xA486,0x5988,0xA4F0,
0x59F4,0xA55A,0x5A5F,0xA5C5,0x5AC9,0xA630,0x5B34,0xA69C,0x5B9D,0xA708,0x5C06,
0xA774,0x5C6F,0xA7E2,0x5CD7,0xA84F,0x5D3E,0xA8BD,0x5DA5,0xA92C,0x5E0C,0xA99B,
0x5E72,0xAA0A,0x5ED7,0xAA7A,0x5F3C,0xAAEB,0x5FA1,0xAB5C,0x6005,0xABCD,0x6068,
0xAC3F,0x60CB,0xACB1,0x612E,0xAD24,0x6190,0xAD97,0x61F1,0xAE0B,0x6252,0xAE7F,
0x62B2,0xAEF3,0x6312,0xAF68,0x6371,0xAFDD,0x63D0,0xB053,0x642E,0xB0C9,0x648B,
0xB140,0x64E9,0xB1B7,0x6545,0xB22F,0x65A1,0xB2A7,0x65FC,0xB31F,0x6657,0xB398,
0x66B2,0xB411,0x670B,0xB48B,0x6764,0xB505,0x67BD,0xB57F,0x6815,0xB5FA,0x686D,
0xB675,0x68C4,0xB6F1,0x691A,0xB76D,0x6970,0xB7E9,0x69C5,0xB866,0x6A1A,0xB8E3,
0x6A6E,0xB961,0x6AC1,0xB9DF,0x6B14,0xBA5D,0x6B66,0xBADC,0x6BB8,0xBB5B,0x6C09,
0xBBDA,0x6C5A,0xBC5A,0x6CAA,0xBCDA,0x6CF9,0xBD5B,0x6D48,0xBDDC,0x6D96,0xBE5D,
0x6DE4,0xBEDF,0x6E31,0xBF61,0x6E7D,0xBFE3,0x6EC9,0xC066,0x6F14,0xC0E9,0x6F5F,
0xC16C,0x6FA9,0xC1F0,0x6FF2,0xC274,0x703B,0xC2F8,0x7083,0xC37D,0x70CB,0xC402,
0x7112,0xC487,0x7158,0xC50D,0x719E,0xC593,0x71E3,0xC619,0x7228,0xC6A0,0x726C,
0xC727,0x72AF,0xC7AE,0x72F2,0xC836,0x7334,0xC8BE,0x7375,0xC946,0x73B6,0xC9CE,
0x73F6,0xCA57,0x7436,0xCAE0,0x7475,0xCB69,0x74B3,0xCBF3,0x74F0,0xCC7D,0x752D,
0xCD07,0x756A,0xCD92,0x75A6,0xCE1C,0x75E1,0xCEA7,0x761B,0xCF33,0x7655,0xCFBE,
0x768E,0xD04A,0x76C7,0xD0D6,0x76FE,0xD162,0x7736,0xD1EF,0x776C,0xD27C,0x77A2,
0xD309,0x77D8,0xD396,0x780C,0xD424,0x7840,0xD4B1,0x7874,0xD53F,0x78A6,0xD5CE,
0x78D8,0xD65C,0x790A,0xD6EB,0x793A,0xD77A,0x796A,0xD809,0x799A,0xD898,0x79C9,
0xD928,0x79F7,0xD9B8,0x7A24,0xDA48,0x7A51,0xDAD8,0x7A7D,0xDB68,0x7AA8,0xDBF9,
0x7AD3,0xDC8A,0x7AFD,0xDD1B,0x7B27,0xDDAC,0x7B50,0xDE3D,0x7B78,0xDECF,0x7B9F,
0xDF61,0x7BC6,0xDFF2,0x7BEC,0xE085,0x7C11,0xE117,0x7C36,0xE1A9,0x7C5A,0xE23C,
0x7C7E,0xE2CF,0x7CA0,0xE361,0x7CC2,0xE3F4,0x7CE4,0xE488,0x7D05,0xE51B,0x7D25,
0xE5AF,0x7D44,0xE642,0x7D63,0xE6D6,0x7D81,0xE76A,0x7D9E,0xE7FE,0x7DBA,0xE892,
0x7DD6,0xE926,0x7DF2,0xE9BB,0x7E0C,0xEA4F,0x7E26,0xEAE4,0x7E3F,0xEB79,0x7E58,
0xEC0E,0x7E70,0xECA3,0x7E87,0xED38,0x7E9D,0xEDCD,0x7EB3,0xEE62,0x7EC8,0xEEF8,
0x7EDD,0xEF8D,0x7EF0,0xF023,0x7F03,0xF0B9,0x7F16,0xF14E,0x7F27,0xF1E4,0x7F38,
0xF27A,0x7F49,0xF310,0x7F58,0xF3A6,0x7F67,0xF43C,0x7F75,0xF4D3,0x7F83,0xF569,
0x7F90,0xF5FF,0x7F9C,0xF695,0x7FA7,0xF72C,0x7FB2,0xF7C2,0x7FBC,0xF859,0x7FC5,
0xF8EF,0x7FCE,0xF986,0x7FD6,0xFA1D,0x7FDD,0xFAB3,0x7FE4,0xFB4A,0x7FEA,0xFBE1,
0x7FEF,0xFC77,0x7FF4,0xFD0E,0x7FF7,0xFDA5,0x7FFA,0xFE3C,0x7FFD,0xFED2,0x7FFF,
0xFF69,0x7FFF,0x7FFF,0x0000,0x7FFA,0xFDA5,0x7FEA,0xFB4A,0x7FCE,0xF8EF,0x7FA7,
0xF695,0x7F75,0xF43C,0x7F38,0xF1E4,0x7EF0,0xEF8D,0x7E9D,0xED38,0x7E3F,0xEAE4,
0x7DD6,0xE892,0x7D63,0xE642,0x7CE4,0xE3F4,0x7C5A,0xE1A9,0x7BC6,0xDF61,0x7B27,
0xDD1B,0x7A7D,0xDAD8,0x79C9,0xD898,0x790A,0xD65C,0x7840,0xD424,0x776C,0xD1EF,
0x768E,0xCFBE,0x75A6,0xCD92,0x74B3,0xCB69,0x73B6,0xC946,0x72AF,0xC727,0x719E,
0xC50D,0x7083,0xC2F8,0x6F5F,0xC0E9,0x6E31,0xBEDF,0x6CF9,0xBCDA,0x6BB8,0xBADC,
0x6A6E,0xB8E3,0x691A,0xB6F1,0x67BD,0xB505,0x6657,0xB31F,0x64E9,0xB140,0x6371,
0xAF68,0x61F1,0xAD97,0x6068,0xABCD,0x5ED7,0xAA0A,0x5D3E,0xA84F,0x5B9D,0xA69C,
0x59F4,0xA4F0,0x5843,0xA34C,0x568A,0xA1B0,0x54CA,0xA01C,0x5303,0x9E91,0x5134,
0x9D0E,0x4F5E,0x9B94,0x4D81,0x9A22,0x4B9E,0x98B9,0x49B4,0x9759,0x47C4,0x9603,
0x45CD,0x94B5,0x43D1,0x9371,0x41CE,0x9236,0x3FC6,0x9105,0x3DB8,0x8FDD,0x3BA5,
0x8EBF,0x398D,0x8DAB,0x3770,0x8CA1,0x354E,0x8BA0,0x3327,0x8AAA,0x30FC,0x89BE,
0x2ECC,0x88DD,0x2C99,0x8805,0x2A62,0x8738,0x2827,0x8676,0x25E8,0x85BE,0x23A7,
0x8511,0x2162,0x846E,0x1F1A,0x83D6,0x1CD0,0x8349,0x1A83,0x82C6,0x1833,0x824F,
0x15E2,0x81E2,0x138F,0x8181,0x113A,0x812A,0x0EE4,0x80DE,0x0C8C,0x809E,0x0A33,
0x8068,0x07D9,0x803E,0x057F,0x801E,0x0324,0x800A,0x00C9,0x8001,0xFE6E,0x8002,
0xFC13,0x800F,0xF9B8,0x8027,0xF75E,0x804B,0xF505,0x8079,0xF2AC,0x80B2,0xF055,
0x80F6,0xEDFF,0x8146,0xEBAB,0x81A0,0xE958,0x8205,0xE707,0x8276,0xE4B9,0x82F1,
0xE26D,0x8377,0xE023,0x8407,0xDDDC,0x84A3,0xDB99,0x8549,0xD958,0x85FA,0xD71B,
0x86B6,0xD4E1,0x877B,0xD2AB,0x884C,0xD079,0x8927,0xCE4B,0x8A0C,0xCC21,0x8AFB,
0xC9FC,0x8BF5,0xC7DB,0x8CF8,0xC5C0,0x8E06,0xC3A9,0x8F1D,0xC198,0x903E,0xBF8C,
0x9169,0xBD86,0x929E,0xBB85,0x93DC,0xB98B,0x9523,0xB796,0x9674,0xB5A8,0x97CE,
0xB3C0,0x9930,0xB1DF,0x9A9C,0xB005,0x9C11,0xAE31,0x9D8E,0xAC65,0x9F14,0xAAA0,
0xA0A2,0xA8E2,0xA238,0xA72C,0xA3D7,0xA57E,0xA57E,0xA3D7,0xA72C,0xA238,0xA8E2,
0xA0A2,0xAAA0,0x9F14,0xAC65,0x9D8E,0xAE31,0x9C11,0xB005,0x9A9C,0xB1DF,0x9930,
0xB3C0,0x97CE,0xB5A8,0x9674,0xB796,0x9523,0xB98B,0x93DC,0xBB85,0x929E,0xBD86,
0x9169,0xBF8C,0x903E,0xC198,0x8F1D,0xC3A9,0x8E06,0xC5C0,0x8CF8,0xC7DB,0x8BF5,
0xC9FC,0x8AFB,0xCC21,0x8A0C,0xCE4B,0x8927,0xD079,0x884C,0xD2AB,0x877B,0xD4E1,
0x86B6,0xD71B,0x85FA,0xD958,0x8549,0xDB99,0x84A3,0xDDDC,0x8407,0xE023,0x8377,
0xE26D,0x82F1,0xE4B9,0x8276,0xE707,0x8205,0xE958,0x81A0,0xEBAB,0x8146,0xEDFF,
0x80F6,0xF055,0x80B2,0xF2AC,0x8079,0xF505,0x804B,0xF75E,0x8027,0xF9B8,0x800F,
0xFC13,0x8002,0xFE6E,0x8001,0x00C9,0x800A,0x0324,0x801E,0x057F,0x803E,0x07D9,
0x8068,0x0A33,0x809E,0x0C8C,0x80DE,0x0EE4,0x812A,0x113A,0x8181,0x138F,0x81E2,
0x15E2,0x824F,0x1833,0x82C6,0x1A83,0x8349,0x1CD0,0x83D6,0x1F1A,0x846E,0x2162,
0x8511,0x23A7,0x85BE,0x25E8,0x8676,0x2827,0x8738,0x2A62,0x8805,0x2C99,0x88DD,
0x2ECC,0x89BE,0x30FC,0x8AAA,0x3327,0x8BA0,0x354E,0x8CA1,0x3770,0x8DAB,0x398D,
0x8EBF,0x3BA5,0x8FDD,0x3DB8,0x9105,0x3FC6,0x9236,0x41CE,0x9371,0x43D1,0x94B5,
0x45CD,0x9603,0x47C4,0x9759,0x49B4,0x98B9,0x4B9E,0x9A22,0x4D81,0x9B94,0x4F5E,
0x9D0E,0x5134,0x9E91,0x5303,0xA01C,0x54CA,0xA1B0,0x568A,0xA34C,0x5843,0xA4F0,
0x59F4,0xA69C,0x5B9D,0xA84F,0x5D3E,0xAA0A,0x5ED7,0xABCD,0x6068,0xAD97,0x61F1,
0xAF68,0x6371,0xB140,0x64E9,0xB31F,0x6657,0xB505,0x67BD,0xB6F1,0x691A,0xB8E3,
0x6A6E,0xBADC,0x6BB8,0xBCDA,0x6CF9,0xBEDF,0x6E31,0xC0E9,0x6F5F,0xC2F8,0x7083,
0xC50D,0x719E,0xC727,0x72AF,0xC946,0x73B6,0xCB69,0x74B3,0xCD92,0x75A6,0xCFBE,
0x768E,0xD1EF,0x776C,0xD424,0x7840,0xD65C,0x790A,0xD898,0x79C9,0xDAD8,0x7A7D,
0xDD1B,0x7B27,0xDF61,0x7BC6,0xE1A9,0x7C5A,0xE3F4,0x7CE4,0xE642,0x7D63,0xE892,
0x7DD6,0xEAE4,0x7E3F,0xED38,0x7E9D,0xEF8D,0x7EF0,0xF1E4,0x7F38,0xF43C,0x7F75,
0xF695,0x7FA7,0xF8EF,0x7FCE,0xFB4A,0x7FEA,0xFDA5,0x7FFA,0x7FFF,0x0000,0x7FA7,
0xF695,0x7E9D,0xED38,0x7CE4,0xE3F4,0x7A7D,0xDAD8,0x776C,0xD1EF,0x73B6,0xC946,
0x6F5F,0xC0E9,0x6A6E,0xB8E3,0x64E9,0xB140,0x5ED7,0xAA0A,0x5843,0xA34C,0x5134,
0x9D0E,0x49B4,0x9759,0x41CE,0x9236,0x398D,0x8DAB,0x30FC,0x89BE,0x2827,0x8676,
0x1F1A,0x83D6,0x15E2,0x81E2,0x0C8C,0x809E,0x0324,0x800A,0xF9B8,0x8027,0xF055,
0x80F6,0xE707,0x8276,0xDDDC,0x84A3,0xD4E1,0x877B,0xCC21,0x8AFB,0xC3A9,0x8F1D,
0xBB85,0x93DC,0xB3C0,0x9930,0xAC65,0x9F14,0xA57E,0xA57E,0x9F14,0xAC65,0x9930,
0xB3C0,0x93DC,0xBB85,0x8F1D,0xC3A9,0x8AFB,0xCC21,0x877B,0xD4E1,0x84A3,0xDDDC,
0x8276,0xE707,0x80F6,0xF055,0x8027,0xF9B8,0x800A,0x0324,0x809E,0x0C8C,0x81E2,
0x15E2,0x83D6,0x1F1A,0x8676,0x2827,0x89BE,0x30FC,0x8DAB,0x398D,0x9236,0x41CE,
0x9759,0x49B4,0x9D0E,0x5134,0xA34C,0x5843,0xAA0A,0x5ED7,0xB140,0x64E9,0xB8E3,
0x6A6E,0xC0E9,0x6F5F,0xC946,0x73B6,0xD1EF,0x776C,0xDAD8,0x7A7D,0xE3F4,0x7CE4,
0xED38,0x7E9D,0xF695,0x7FA7,0x7FFF,0x0000,0x7A7D,0xDAD8,0x6A6E,0xB8E3,0x5134,
0x9D0E,0x30FC,0x89BE,0x0C8C,0x809E,0xE707,0x8276,0xC3A9,0x8F1D,0xA57E,0xA57E,
0x8F1D,0xC3A9,0x8276,0xE707,0x809E,0x0C8C,0x89BE,0x30FC,0x9D0E,0x5134,0xB8E3,
0x6A6E,0xDAD8,0x7A7D,0x7FFF,0x0000,0x30FC,0x89BE,0xA57E,0xA57E,0x89BE,0x30FC,};

#endif



#endif /* !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_FFT_ALLOW_TABLES) */
#endif /* defined(ARM_MATH_MVEI)  */


#endif // EIDSP_LOAD_CMSIS_DSP_SOURCES
