import './index.scss';
import { Basis, Component } from '../Basis';
import MenuItem from './components/MenuItem.vue';

@Component({
  template: require('./layout.html'),
  components: { MenuItem },
})
class Main extends Basis {
  menuList = [
    {
      'id': 1,
      'parentId': 0,
      'text': '系统管理',
      'type': '0',
      'icon': 'el-icon-upload',
      'ishide': 0,
      'resoEngname': '系统管理',
      'order': 1,
      'children': [
        {
          'id': 16,
          'parentId': 1,
          'text': '账号管理',
          'parentName': '系统管理',
          'resUrl': 'sysUser/sysUserPage.shtml',
          'type': '0',
          'icon': 'customer_info.png',
          'ishide': 0,
          'order': 2,
          'children': [],
        },
        {
          'id': 227,
          'parentId': 1,
          'text': '用户组织',
          'parentName': '系统管理',
          'resUrl': 'sysUser/userOrgPage.shtml',
          'type': '0',
          'icon': 'customer_info.png',
          'ishide': 0,
          'order': 2,
          'children': [],
        },
        {
          'id': 17,
          'parentId': 1,
          'text': '角色管理',
          'parentName': '系统管理',
          'resUrl': 'sysRole/sysRolePage.shtml',
          'type': '0',
          'icon': 'character_manage.png',
          'ishide': 1,
          'order': 3,
          'children': [],
        },
        {
          'id': 18,
          'parentId': 1,
          'text': '组织架构',
          'parentName': '系统管理',
          'resUrl': 'sysOrganization/sysOrganizationPage.shtml',
          'type': '0',
          'icon': 'organization_structure.png',
          'ishide': 0,
          'order': 3,
          'children': [],
        },
        {
          'id': 226,
          'parentId': 1,
          'text': '组织主管',
          'parentName': '系统管理',
          'resUrl': 'sysOrganization/sysOrgMangerPage.shtml',
          'type': '0',
          'icon': 'meeting_manage.png',
          'ishide': 0,
          'order': 3,
          'children': [],
        },
        {
          'id': 19,
          'parentId': 1,
          'text': '资源管理',
          'parentName': '系统管理',
          'resUrl': 'sysResource/sysResourcePage.shtml',
          'type': '0',
          'icon': 'meeting_manage.png',
          'ishide': 0,
          'order': 4,
          'children': [],
        },
        {
          'id': 228,
          'parentId': 1,
          'text': '角色分配',
          'parentName': '系统管理',
          'resUrl': 'sysRole/roleAssignPage.shtml',
          'type': '0',
          'icon': 'el-icon-upload',
          'ishide': 0,
          'order': 4,
          'children': [],
        },
        {
          'id': 20,
          'parentId': 1,
          'text': '日志管理',
          'parentName': '系统管理',
          'resUrl': 'sysLog/sysLogPage.shtml',
          'type': '0',
          'icon': 'logs_manage.png',
          'ishide': 0,
          'order': 5,
          'children': [],
        },
        {
          'id': 21,
          'parentId': 1,
          'text': '数据字典',
          'parentName': '系统管理',
          'resUrl': 'flSystemDictionary/sysDictionaryPage.shtml',
          'type': '0',
          'icon': 'data_dictionary.png',
          'ishide': 0,
          'order': 6,
          'children': [],
        },
        {
          'id': 233,
          'parentId': 1,
          'text': '数据权限',
          'parentName': '系统管理',
          'resUrl': 'grc/grcCfg.shtml',
          'type': '0',
          'icon': 'project_character.png',
          'ishide': 1,
          'order': 7,
          'children': [],
        },
        {
          'id': 234,
          'parentId': 1,
          'text': '权限查询',
          'parentName': '系统管理',
          'resUrl': 'grc/grcQuery.shtml',
          'type': '0',
          'icon': 'meeting_manage.png',
          'ishide': 1,
          'order': null,
          'children': [],
        }],
    },
    {
      'id': 13,
      'parentId': 0,
      'text': '个人门户',
      'resUrl': 'systemPortalset/userPortal.shtml',
      'type': '0',
      'icon': 'project_auth.png',
      'ishide': 1,
      'order': 2,
      'children': [],
    },
    {
      'id': 14,
      'parentId': 0,
      'text': '组织门户',
      'resUrl': 'systemPortalset/orgaPortal.shtml',
      'type': '0',
      'icon': 'source_manage.png',
      'ishide': 1,
      'order': 3,
      'children': [],
    },
    {
      'id': 4,
      'parentId': 0,
      'text': '信息管理',
      'type': '0',
      'icon': 'notice_manage.png',
      'ishide': 0,
      'resoEngname': '信息管理',
      'order': 4,
      'children': [
        {
          'id': 28,
          'parentId': 4,
          'text': '新闻资讯',
          'parentName': '信息管理',
          'resUrl': 'InfoNews/infoNewsPage.shtml',
          'type': '0',
          'icon': 'news_classify.png',
          'ishide': 0,
          'resoEngname': '新闻资讯',
          'order': 1,
          'children': [],
        },
        {
          'id': 30,
          'parentId': 4,
          'text': '公告管理',
          'parentName': '信息管理',
          'resUrl': 'infoNotice/infoNoticePage.shtml',
          'type': '0',
          'icon': 'notice_manage.png',
          'ishide': 0,
          'resoEngname': '公告栏',
          'order': 1,
          'children': [],
        },
        {
          'id': 31,
          'parentId': 4,
          'text': '评论管理',
          'parentName': '信息管理',
          'resUrl': 'infoDiscuss/infoDiscussPage.shtml',
          'type': '0',
          'icon': 'comment_manage.png',
          'ishide': 0,
          'resoEngname': '评论管理',
          'order': 1,
          'children': [],
        }],
    },
    {
      'id': 2,
      'parentId': 0,
      'text': '日程报告',
      'type': '0',
      'icon': 'finished_task.png',
      'ishide': 0,
      'resoEngname': '任务管理',
      'order': 5,
      'children': [
        {
          'id': 22,
          'parentId': 2,
          'text': '日程管理',
          'parentName': '日程报告',
          'resUrl': 'dutySchedule/dutySchedulePage.shtml',
          'type': '0',
          'icon': 'employee_birthday.png',
          'ishide': 0,
          'resoEngname': '日程管理',
          'order': 1,
          'children': [],
        },
        {
          'id': 23,
          'parentId': 2,
          'text': '日报管理',
          'parentName': '日程报告',
          'resUrl': 'dutyDaily/dutyDailyPage.shtml',
          'type': '0',
          'icon': 'work_day_report.png',
          'ishide': 0,
          'resoEngname': '日报管理',
          'order': 2,
          'children': [],
        },
        {
          'id': 24,
          'parentId': 2,
          'text': '周报管理',
          'parentName': '日程报告',
          'resUrl': 'dutyWeekly/dutyWeeklyPage.shtml',
          'type': '0',
          'icon': 'work_week_report.png',
          'ishide': 0,
          'resoEngname': '周报管理',
          'order': 3,
          'children': [],
        },
        {
          'id': 25,
          'parentId': 2,
          'text': '周报点评',
          'parentName': '日程报告',
          'resUrl': 'dutyWeekly/dutyWeeklyReviewPage.shtml',
          'type': '0',
          'icon': 'meeting_manage.png',
          'ishide': 0,
          'resoEngname': '周报点评',
          'order': 4,
          'children': [],
        },
        {
          'id': 26,
          'parentId': 2,
          'text': '月报管理',
          'parentName': '日程报告',
          'resUrl': 'dutyMonthly/dutyMonthlyPage.shtml',
          'type': '0',
          'icon': 'work_month_report.png',
          'ishide': 0,
          'resoEngname': '月报管理',
          'order': 5,
          'children': [],
        },
        {
          'id': 27,
          'parentId': 2,
          'text': '月报点评',
          'parentName': '日程报告',
          'resUrl': 'dutyMonthly/dutyMonthlyReviewPage.shtml',
          'type': '0',
          'icon': 'work_month_report.png',
          'ishide': 0,
          'resoEngname': '月报点评',
          'order': 6,
          'children': [],
        }],
    },
    {
      'id': 5,
      'parentId': 0,
      'text': '人事管理',
      'type': '0',
      'icon': 'customer_birthday.png',
      'ishide': 0,
      'order': 6,
      'children': [
        {
          'id': 32,
          'parentId': 5,
          'text': '人员管理',
          'parentName': '人事管理',
          'resUrl': 'pmUser/listUI.shtml',
          'type': '0',
          'icon': 'hr_manage.png',
          'ishide': 0,
          'order': 1,
          'children': [],
        },
        {
          'id': 36,
          'parentId': 5,
          'text': '绩效考核',
          'parentName': '人事管理',
          'type': '0',
          'icon': 'hr_manage.png',
          'ishide': 1,
          'order': 5,
          'children': [
            {
              'id': 122,
              'parentId': 36,
              'text': '考核统计',
              'parentName': '绩效考核',
              'resUrl': 'performance/performanceHistory/performanceHistoryPage.shtml',
              'type': '0',
              'icon': 'customer_info.png',
              'ishide': 1,
              'order': 2,
              'children': [],
            },
            {
              'id': 121,
              'parentId': 36,
              'text': '考核模板',
              'parentName': '绩效考核',
              'resUrl': 'performance/performanceDetail/performanceDetailPage.shtml',
              'type': '0',
              'icon': 'hr_manage.png',
              'ishide': 1,
              'order': 5,
              'children': [],
            }],
        },
        {
          'id': 39,
          'parentId': 5,
          'text': '员工年假管理',
          'parentName': '人事管理',
          'resUrl': 'pmAnnualLeave/pmAnnualLeavePage.shtml',
          'type': '1',
          'icon': 'customer_info.png',
          'ishide': 1,
          'order': 8,
          'children': [],
        },
        {
          'id': 38,
          'parentId': 5,
          'text': '招聘管理',
          'parentName': '人事管理',
          'type': '0',
          'icon': 'employee_birthday.png',
          'ishide': 0,
          'order': null,
          'children': [
            {
              'id': 126,
              'parentId': 38,
              'text': '招聘计划',
              'parentName': '招聘管理',
              'resUrl': 'joinus/info/listUI.shtml',
              'type': '0',
              'icon': 'notice_manage.png',
              'ishide': 1,
              'order': null,
              'children': [],
            },
            {
              'id': 125,
              'parentId': 38,
              'text': '人才库',
              'parentName': '招聘管理',
              'resUrl': 'joinus/hrsource/listUI.shtml',
              'type': '0',
              'icon': 'finished_task.png',
              'ishide': 1,
              'order': null,
              'children': [],
            }],
        },
        {
          'id': 37,
          'parentId': 5,
          'text': '培训管理',
          'parentName': '人事管理',
          'type': '0',
          'icon': 'new_task.png',
          'ishide': 0,
          'order': null,
          'children': [
            {
              'id': 124,
              'parentId': 37,
              'text': '培训讨论',
              'parentName': '培训管理',
              'resUrl': 'pmTrain/pmTrainUserPage.shtml',
              'type': '0',
              'icon': 'files_manage.png',
              'ishide': 1,
              'order': null,
              'children': [],
            },
            {
              'id': 123,
              'parentId': 37,
              'text': '培训通知',
              'parentName': '培训管理',
              'resUrl': 'pmTrain/pmTrainPage.shtml',
              'type': '0',
              'icon': 'inter_message.png',
              'ishide': 1,
              'order': null,
              'children': [],
            }],
        },
        {
          'id': 35,
          'parentId': 5,
          'text': '考勤管理',
          'parentName': '人事管理',
          'type': '0',
          'icon': 'employee_birthday.png',
          'ishide': 0,
          'order': null,
          'children': [
            {
              'id': 120,
              'parentId': 35,
              'text': '打卡方式',
              'parentName': '考勤管理',
              'resUrl': 'pmCheckwork/order/styleListUI.shtml',
              'type': '0',
              'icon': 'finished_task.png',
              'ishide': 1,
              'order': 0,
              'children': [],
            },
            {
              'id': 118,
              'parentId': 35,
              'text': '班次管理',
              'parentName': '考勤管理',
              'resUrl': 'pmCheckwork/shift/listUI.shtml',
              'type': '0',
              'icon': 'el-icon-upload',
              'ishide': 0,
              'order': 1,
              'children': [],
            },
            {
              'id': 116,
              'parentId': 35,
              'text': '班制管理',
              'parentName': '考勤管理',
              'resUrl': 'pmCheckwork/system/listUI.shtml',
              'type': '0',
              'icon': 'data_dictionary.png',
              'ishide': 1,
              'order': 2,
              'children': [],
            },
            {
              'id': 117,
              'parentId': 35,
              'text': '排班管理',
              'parentName': '考勤管理',
              'resUrl': 'pmCheckwork/order/listUI.shtml',
              'type': '0',
              'icon': 'pay_setup.png',
              'ishide': 1,
              'order': 3,
              'children': [],
            },
            {
              'id': 115,
              'parentId': 35,
              'text': '打卡记录',
              'parentName': '考勤管理',
              'resUrl': 'pmCheckwork/listUI.shtml',
              'type': '0',
              'icon': 'source_manage.png',
              'ishide': 1,
              'order': 4,
              'children': [],
            },
            {
              'id': 119,
              'parentId': 35,
              'text': '打卡统计',
              'parentName': '考勤管理',
              'resUrl': 'pmCheckwork/managerListUI.shtml',
              'type': '0',
              'icon': 'customer_birthday.png',
              'ishide': 1,
              'order': 5,
              'children': [],
            },
            {
              'id': 224,
              'parentId': 35,
              'text': '考勤统计',
              'parentName': '考勤管理',
              'resUrl': 'attendanceStatistics/attendanceStatisticsPage.shtml',
              'type': '0',
              'icon': 'hr_manage.png',
              'ishide': 1,
              'order': 7,
              'children': [],
            }],
        },
        {
          'id': 34,
          'parentId': 5,
          'text': '员工生日',
          'parentName': '人事管理',
          'resUrl': 'pmUser/userBirthday.shtml',
          'type': '0',
          'icon': 'pay_entering.png',
          'ishide': 1,
          'order': null,
          'children': [],
        },
        {
          'id': 33,
          'parentId': 5,
          'text': '个人卡片',
          'parentName': '人事管理',
          'resUrl': 'pmUser/userCard.shtml',
          'type': '0',
          'icon': 'flow_engine.png',
          'ishide': 0,
          'order': null,
          'children': [],
        }],
    },
    {
      'id': 8,
      'parentId': 0,
      'text': '项目管理',
      'type': '0',
      'icon': 'project_manage.png',
      'ishide': 0,
      'order': 7,
      'children': [
        {
          'id': 44,
          'parentId': 8,
          'text': '项目角色',
          'parentName': '项目管理',
          'resUrl': 'projectRole/projectRolePage.shtml',
          'type': '0',
          'icon': 'project_character.png',
          'ishide': 1,
          'order': 1,
          'children': [],
        },
        {
          'id': 45,
          'parentId': 8,
          'text': '项目管理',
          'parentName': '项目管理',
          'resUrl': 'projectBaseinfo/projectBaseinfoPage.shtml',
          'type': '0',
          'icon': 'hr_manage.png',
          'ishide': 1,
          'order': 1,
          'children': [],
        }],
    },
    {
      'id': 6,
      'parentId': 0,
      'text': '通讯管理',
      'type': '0',
      'icon': 'weixin.png',
      'ishide': 0,
      'order': 8,
      'children': [
        {
          'id': 41,
          'parentId': 6,
          'text': '企业通讯录',
          'parentName': '通讯管理',
          'resUrl': 'messageContacts/messagePage.shtml',
          'type': '0',
          'icon': 'borrow_auth.png',
          'ishide': 0,
          'order': 2,
          'children': [],
        }],
    },
    {
      'id': 7,
      'parentId': 0,
      'text': '客户管理',
      'type': '0',
      'icon': 'customer_info.png',
      'ishide': 0,
      'resoEngname': '客户管理',
      'order': 9,
      'children': [
        {
          'id': 43,
          'parentId': 7,
          'text': '客户生日',
          'parentName': '客户管理',
          'resUrl': 'cmCustomer/cmCustBirthdayPage.shtml',
          'type': '0',
          'icon': 'customer_birthday.png',
          'ishide': 0,
          'order': null,
          'children': [],
        },
        {
          'id': 42,
          'parentId': 7,
          'text': '我的客户',
          'parentName': '客户管理',
          'resUrl': 'cmCustomer/cmCustomerPage.shtml',
          'type': '0',
          'icon': 'customer_info.png',
          'ishide': 0,
          'order': null,
          'children': [],
        }],
    },
    {
      'id': 11,
      'parentId': 0,
      'text': '数据同步',
      'type': '0',
      'icon': 'gateway_manage.png',
      'ishide': 0,
      'order': 11,
      'children': [
        {
          'id': 219,
          'parentId': 11,
          'text': '环信数据同步',
          'parentName': '数据同步',
          'resUrl': 'userIMSynchr/userIMSyncIndividual.shtml',
          'type': '0',
          'icon': 'meeting_manage.png',
          'ishide': 1,
          'order': 2,
          'children': [],
        }],
    },
    {
      'id': 10,
      'parentId': 0,
      'text': '知识库',
      'type': '0',
      'icon': 'knowledge_library.png',
      'ishide': 0,
      'order': 12,
      'children': [
        {
          'id': 59,
          'parentId': 10,
          'text': '我的文档',
          'parentName': '知识库',
          'resUrl': 'knowledgeDocinfo/knowledgeDocinfoPage.shtml',
          'type': '0',
          'icon': 'employee_birthday.png',
          'ishide': 1,
          'order': null,
          'children': [],
        },
        {
          'id': 58,
          'parentId': 10,
          'text': '知识库分类',
          'parentName': '知识库',
          'resUrl': 'knowledgeCatalog/knowledgeCatalogPage.shtml',
          'type': '0',
          'icon': 'files_manage.png',
          'ishide': 1,
          'order': null,
          'children': [],
        },
        {
          'id': 57,
          'parentId': 10,
          'text': '知识搜索',
          'parentName': '知识库',
          'resUrl': 'knowledge/listUI.shtml',
          'type': '0',
          'icon': 'work_week_report.png',
          'ishide': 0,
          'order': null,
          'children': [],
        }],
    },
    {
      'id': 9,
      'parentId': 0,
      'text': '流程管理',
      'type': '2',
      'icon': 'gateway_manage.png',
      'ishide': 0,
      'order': 13,
      'children': [
        {
          'id': 48,
          'parentId': 9,
          'text': '流程申请',
          'parentName': '流程管理',
          'type': '2',
          'icon': 'borrow_apply.png',
          'ishide': 1,
          'order': 1,
          'children': [],
        },
        {
          'id': 49,
          'parentId': 9,
          'text': '我的待办',
          'parentName': '流程管理',
          'type': '2',
          'icon': 'project_type.png',
          'ishide': 1,
          'order': 2,
          'children': [],
        },
        {
          'id': 54,
          'parentId': 9,
          'text': '我的已办',
          'parentName': '流程管理',
          'type': '2',
          'icon': 'files_classify.png',
          'ishide': 1,
          'order': 3,
          'children': [],
        },
        {
          'id': 55,
          'parentId': 9,
          'text': '我的申请',
          'parentName': '流程管理',
          // tslint:disable-next-line:max-line-length
          'resUrl': 'http://zejiaxian.xicp.cn:15396/cas-server/login?service=http://zejiaxian.xicp.cn:15384/zejia-fw-bpm/myStartTaskProcessList?oaRequest=zjoa',
          'type': '2',
          'icon': 'organization_structure.png',
          'ishide': 1,
          'order': 4,
          'children': [],
        },
        {
          'id': 52,
          'parentId': 9,
          'text': '业务基础',
          'parentName': '流程管理',
          // tslint:disable-next-line:max-line-length
          'resUrl': 'http://zejiaxian.xicp.cn:15396/cas-server/login?service=http://zejiaxian.xicp.cn:15384/zejia-fw-bpm/bpmSysCfg?oaRequest=zjoa',
          'type': '2',
          'icon': 'customer_info.png',
          'ishide': 1,
          'order': 5,
          'children': [],
        },
        {
          'id': 53,
          'parentId': 9,
          'text': '业务组件',
          'parentName': '流程管理',
          // tslint:disable-next-line:max-line-length
          'resUrl': 'http://zejiaxian.xicp.cn:15396/cas-server/login?service=http://zejiaxian.xicp.cn:15384/zejia-fw-bpm/bpmBuCom?oaRequest=zjoa',
          'type': '2',
          'icon': 'data_dictionary.png',
          'ishide': 1,
          'order': 6,
          'children': [],
        },
        {
          'id': 51,
          'parentId': 9,
          'text': '业务模型',
          'parentName': '流程管理',
          // tslint:disable-next-line:max-line-length
          'type': '2',
          'icon': 'gateway_manage.png',
          'ishide': 1,
          'order': 7,
          'children': [],
        },
        {
          'id': 50,
          'parentId': 9,
          'text': '流程定义',
          'parentName': '流程管理',
          'type': '2',
          'icon': 'my_check.png',
          'ishide': 1,
          'order': 8,
          'children': [],
        },
        {
          'id': 56,
          'parentId': 9,
          'text': '初始化-别操作',
          'parentName': '流程管理',
          'type': '2',
          'icon': 'knowledge_library.png',
          'ishide': 1,
          'order': null,
          'children': [],
        },
        {
          'id': 47,
          'parentId': 9,
          'text': '调度作业',
          'parentName': '流程管理',
          'resUrl': 'http://zejiaxian.xicp.cn:15396/cas-server/login?service=http://zejiaxian.xicp.cn:15384/zejia-fw-bpm/sysJobCfg',
          'type': '2',
          'icon': 'organization_structure.png',
          'ishide': 1,
          'order': null,
          'children': [],
        }],
    },
    {
      'id': 15,
      'parentId': 0,
      'text': '报销管理',
      'type': '0',
      'icon': 'my_pay.png',
      'ishide': 0,
      'order': 14,
      'children': [
        {
          'id': 64,
          'parentId': 15,
          'text': '项目报销',
          'parentName': '报销管理',
          'type': '0',
          'icon': 'my_pay.png',
          'ishide': 0,
          'order': 0,
          'children': [
            {
              'id': 184,
              'parentId': 64,
              'text': '新建报销',
              'parentName': '项目报销',
              'resUrl': 'objectExpense/index.shtml?bxType=XM_BX&state=',
              'type': '0',
              'icon': 'task_auth.png',
              'ishide': 1,
              'order': 0,
              'children': [],
            },
            {
              'id': 181,
              'parentId': 64,
              'text': '我的待办',
              'parentName': '项目报销',
              'resUrl': 'objectExpense/index.shtml?bxType=XM_BX&state=DB',
              'type': '0',
              'icon': 'my_check.png',
              'ishide': 1,
              'order': 1,
              'children': [],
            },
            {
              'id': 182,
              'parentId': 64,
              'text': '我的已办',
              'parentName': '项目报销',
              'resUrl': 'objectExpense/index.shtml?bxType=XM_BX&state=YB',
              'type': '0',
              'icon': 'finished_task.png',
              'ishide': 1,
              'order': 1,
              'children': [],
            },
            {
              'id': 183,
              'parentId': 64,
              'text': '我的申请',
              'parentName': '项目报销',
              'resUrl': 'objectExpense/index.shtml?bxType=XM_BX&state=FQ',
              'type': '0',
              'icon': 'hr_manage.png',
              'ishide': 1,
              'order': 2,
              'children': [],
            }],
        },
        {
          'id': 65,
          'parentId': 15,
          'text': '部门报销',
          'parentName': '报销管理',
          'type': '0',
          'icon': 'my_pay.png',
          'ishide': 0,
          'order': 1,
          'children': [
            {
              'id': 188,
              'parentId': 65,
              'text': '新建报销',
              'parentName': '部门报销',
              'resUrl': 'objectExpense/index.shtml?bxType=BM_BX&state=',
              'type': '0',
              'icon': 'new_task.png',
              'ishide': 1,
              'order': 0,
              'children': [],
            },
            {
              'id': 185,
              'parentId': 65,
              'text': '我的待办',
              'parentName': '部门报销',
              'resUrl': 'objectExpense/index.shtml?bxType=BM_BX&state=DB',
              'type': '0',
              'icon': 'my_pay.png',
              'ishide': 1,
              'order': 1,
              'children': [],
            },
            {
              'id': 186,
              'parentId': 65,
              'text': '我的已办',
              'parentName': '部门报销',
              'resUrl': 'objectExpense/index.shtml?bxType=BM_BX&state=YB',
              'type': '0',
              'icon': 'finished_task.png',
              'ishide': 1,
              'order': 2,
              'children': [],
            },
            {
              'id': 187,
              'parentId': 65,
              'text': '我的申请',
              'parentName': '部门报销',
              'resUrl': 'objectExpense/index.shtml?bxType=BM_BX&state=FQ',
              'type': '0',
              'icon': 'hr_manage.png',
              'ishide': 1,
              'order': 3,
              'children': [],
            }],
        }],
    }];
  tags = [{
    id: 0,
    text: '首页首页首页首页首页1',
    closable: false,
  }, {
    id: 1,
    text: '首页首页首页首页首页2',
  }, {
    id: 2,
    text: '首页首页首页首页首页3',
  }, {
    id: 3,
    text: '首页首页首页首页首页4',
  }, {
    id: 4,
    text: '首页首页首页首页首页5',
  }, {
    id: 5,
    text: '首页首页首页首页首页6',
  }, {
    id: 6,
    text: '首页首页首页首页首页7',
  }, {
    id: 7,
    text: '首页首页首页首页首页8',
  }, {
    id: 8,
    text: '首页首页首页首页首页9',
  }, {
    id: 9,
    text: '首页首页首页首页首页10',
  }];
  value = '0';
  isCollapse = false;

  mounted() {
    const loadEl = document.getElementById('loading');
    if (loadEl) {
      loadEl.style.display = 'none';
    }
    // document.querySelector('.page-sidebar').addEventListener('mousewheel',function(event){console.log(event);},false);
  }

  onLeafNodeClick(node: any, event: Event) {
    console.log(node,event);
  }

  onTagClick(name: string) {
    console.log(name);
  }

  onTagClose(targetName: string) {
    const tabs = this.tags;
    let activeName = this.value;
    if (activeName === targetName) {
      tabs.forEach((tab, index) => {
        if (tab.id.toString() === targetName) {
          const nextTab = tabs[index - 1] || tabs[index + 1];
          if (nextTab) {
            activeName = nextTab.id.toString();
          }
        }
      });
    }
    this.value = activeName;
    this.tags = tabs.filter(tab => tab.id.toString() !== targetName);
  }
}

export default Main;
