/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.wrappers;

import org.ocamljava.runtime.values.Value;
import org.ocamljava.runtime.wrappers.OCamlUnit;
import org.ocamljava.runtime.wrappers.OCamlValue;
import org.ocamljava.runtime.wrappers.SimpleWrapper;
import org.ocamljava.runtime.wrappers.Wrapper;

public final class OCamlString
extends OCamlValue
implements CharSequence {
    public static final Wrapper<OCamlString> WRAPPER = new SimpleWrapper<OCamlString>(){

        @Override
        public OCamlString wrap(Value v) {
            return new OCamlString(v);
        }
    };

    private OCamlString(Value v) {
        super(v);
    }

    public Wrapper<? extends OCamlString> getWrapper() {
        return WRAPPER;
    }

    @Override
    public Wrapper<? extends OCamlValue> getWrapper(int idx) {
        return OCamlUnit.WRAPPER;
    }

    public String stringValue() {
        return this.value.asString();
    }

    public byte byteAt(int idx) {
        return this.value.getByte(idx);
    }

    @Override
    public char charAt(int idx) {
        return (char)this.value.getUnsignedByte(idx);
    }

    public void setByteAt(int idx, byte b) {
        this.value.setByte(idx, b);
    }

    public void setCharAt(int idx, char c) {
        this.value.setUnsignedByte(idx, c);
    }

    @Override
    public int length() {
        return (int)this.value.sizeBytes();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.value.asString().subSequence(start, end);
    }

    @Override
    public int hashCode() {
        return this.value.asString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OCamlString) {
            OCamlString that = (OCamlString)obj;
            return this.value.asString().equals(that.value.asString());
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OCamlString(");
        sb.append(this.value.asString());
        sb.append(")");
        return sb.toString();
    }

    public static OCamlString create(String v) {
        return new OCamlString(Value.createString(v));
    }

    public static OCamlString wrap(Value v) {
        assert (v != null) : "null v";
        return new OCamlString(v);
    }

    public static Wrapper<? extends OCamlString> wrapper() {
        return WRAPPER;
    }
}

