/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.wrappers;

import org.ocamljava.runtime.values.Value;
import org.ocamljava.runtime.wrappers.ComposedWrapper;
import org.ocamljava.runtime.wrappers.OCamlUnit;
import org.ocamljava.runtime.wrappers.OCamlValue;
import org.ocamljava.runtime.wrappers.Wrapper;

public final class OCamlOption<T extends OCamlValue>
extends OCamlValue {
    private final Wrapper<T> wrapper;

    private OCamlOption(Wrapper<T> w, Value v) {
        super(v);
        assert (w != null) : "null w";
        this.wrapper = w;
    }

    public Wrapper<? extends OCamlOption<T>> getWrapper() {
        return OCamlOption.wrapper(this.wrapper);
    }

    @Override
    public Wrapper<? extends OCamlValue> getWrapper(int idx) {
        switch (idx) {
            case 0: {
                return this.wrapper;
            }
        }
        return OCamlUnit.WRAPPER;
    }

    public T get() {
        if (this.value.isLong()) {
            return null;
        }
        return this.wrapper.wrap(this.value.get0());
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OCamlOption) {
            OCamlOption that = (OCamlOption)obj;
            if (this.value.isLong()) {
                if (that.value.isLong()) {
                    return this.value.asLong() == that.value.asLong();
                }
                return false;
            }
            if (that.value.isLong()) {
                return false;
            }
            return this.value.get0() == that.value.get0();
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OCamlOption(");
        if (this.value.isLong()) {
            sb.append("None");
        } else {
            sb.append("Some(");
            sb.append(((OCamlValue)this.wrapper.wrap(this.value.get0())).toString());
            sb.append(")");
        }
        sb.append(")");
        return sb.toString();
    }

    public static <T extends OCamlValue> OCamlOption<T> create(T v) {
        return new OCamlOption<OCamlValue>(v.getWrapper(), Value.createBlock(0, v.value()));
    }

    public static <T extends OCamlValue> OCamlOption<T> create() {
        return new OCamlOption<OCamlUnit>(OCamlUnit.WRAPPER, Value.ZERO);
    }

    public static <T extends OCamlValue> OCamlOption<T> wrap(Wrapper<T> w, Value v) {
        assert (v != null) : "null v";
        return new OCamlOption<T>(w, v);
    }

    public static <T extends OCamlValue> Wrapper<? extends OCamlOption<T>> wrapper(final Wrapper<T> w) {
        return new ComposedWrapper<OCamlOption<T>>(new Wrapper[0]){

            @Override
            public OCamlOption<T> wrap(Value v) {
                return new OCamlOption(w, v);
            }
        };
    }
}

