/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.wrappers;

import org.ocamljava.runtime.kernel.NativeApply;
import org.ocamljava.runtime.values.Value;
import org.ocamljava.runtime.wrappers.ComposedWrapper;
import org.ocamljava.runtime.wrappers.OCamlFunction;
import org.ocamljava.runtime.wrappers.OCamlUnit;
import org.ocamljava.runtime.wrappers.OCamlValue;
import org.ocamljava.runtime.wrappers.Wrapper;

public final class OCamlLazy<T extends OCamlValue>
extends OCamlValue {
    private final Wrapper<T> wrapper;

    private OCamlLazy(Wrapper<T> w, Value v) {
        super(v);
        assert (w != null) : "null w";
        this.wrapper = w;
    }

    public Wrapper<? extends OCamlLazy<T>> getWrapper() {
        return OCamlLazy.wrapper(this.wrapper);
    }

    @Override
    public Wrapper<? extends OCamlValue> getWrapper(int idx) {
        switch (idx) {
            case 0: {
                return this.wrapper;
            }
        }
        return OCamlUnit.WRAPPER;
    }

    public T get() {
        if (this.value.isLong()) {
            return this.wrapper.wrap(this.value);
        }
        switch (this.value.getTag()) {
            case 246: {
                return null;
            }
            case 250: {
                return this.wrapper.wrap(this.value.get0());
            }
        }
        return this.wrapper.wrap(this.value);
    }

    public T force() {
        if (this.value.isLong()) {
            return this.wrapper.wrap(this.value);
        }
        switch (this.value.getTag()) {
            case 246: {
                try {
                    Value res = NativeApply.apply(this.value.get0(), Value.UNIT);
                    this.value.setTag(250);
                    this.value.set0(res);
                    return this.wrapper.wrap(res);
                }
                catch (Throwable t) {
                    assert (false) : "exception during lazy evaluation";
                    return null;
                }
            }
            case 250: {
                return this.wrapper.wrap(this.value.get0());
            }
        }
        return this.wrapper.wrap(this.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OCamlLazy) {
            OCamlLazy that = (OCamlLazy)obj;
            return this == that;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OCamlLazy(");
        T v = this.get();
        if (v == null) {
            sb.append("...");
        } else {
            sb.append(((OCamlValue)this.wrapper.wrap(((OCamlValue)v).value())).toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public static <T extends OCamlValue> OCamlLazy<T> create(T v) {
        return new OCamlLazy<OCamlValue>(v.getWrapper(), Value.createBlock(250, v.value()));
    }

    public static <T extends OCamlValue> OCamlLazy<T> create(Wrapper<T> w, OCamlFunction<OCamlUnit, T> c) {
        Value clos = c.getClosure(OCamlUnit.WRAPPER);
        return new OCamlLazy<T>(w, Value.createBlock(246, clos));
    }

    public static <T extends OCamlValue> OCamlLazy<T> wrap(Wrapper<T> w, Value v) {
        assert (v != null) : "null v";
        return new OCamlLazy<T>(w, v);
    }

    public static <T extends OCamlValue> Wrapper<? extends OCamlLazy<T>> wrapper(final Wrapper<T> w) {
        return new ComposedWrapper<OCamlLazy<T>>(new Wrapper[]{w}){

            @Override
            public OCamlLazy<T> wrap(Value v) {
                return new OCamlLazy(w, v);
            }
        };
    }
}

