/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.support.toplevel;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import javax.swing.JFrame;
import org.ocamljava.runtime.annotations.parameters.Parameters;
import org.ocamljava.runtime.context.FileHook;
import org.ocamljava.runtime.gui.InOutPanel;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.kernel.Interpreter;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.parameters.ByteCodeParameters;
import org.ocamljava.runtime.parameters.CommonParameters;
import org.ocamljava.runtime.util.RandomAccessInputStream;
import org.ocamljava.runtime.values.CustomOperations;

abstract class AbstractTopLevel {
    private static final String TITLE = "OCaml toplevel";
    private static final int WIDTH = 600;
    private static final int HEIGHT = 400;
    private InOutPanel panel;
    private Throwable exception;

    protected AbstractTopLevel(String path, RandomAccessInputStream stream, String[] args, FileHook hook, boolean stopJVM) {
        assert (path != null) : "null path";
        assert (stream != null) : "null stream";
        assert (args != null) : "null args";
        PipedInputStream in = new PipedInputStream();
        PipedOutputStream out = new PipedOutputStream();
        PipedOutputStream err = new PipedOutputStream();
        this.exception = null;
        try {
            ByteCodeParameters params = Parameters.defaultByteCodeParameters();
            params = Parameters.setFile(params, path);
            params = Parameters.setUnparsedElements(params, args);
            params = Parameters.setBooleanParameter(params, CommonParameters.BooleanParameterID.STOP_JVM, stopJVM);
            params = Parameters.setInputStreamParameter(params, CommonParameters.InputStreamParameterID.IN, (InputStream)in);
            params = Parameters.setPrintStreamParameter(params, CommonParameters.PrintStreamParameterID.OUT, new PrintStream(out, true));
            params = Parameters.setPrintStreamParameter(params, CommonParameters.PrintStreamParameterID.ERR, new PrintStream(err, true));
            Interpreter interp = new Interpreter(params, new File("."), stream, new CustomOperations[0]);
            if (hook != null) {
                interp.getContext().getFilesState().setFileHook(hook);
            }
            this.panel = new InOutPanel(interp, new PrintStream(new PipedOutputStream(in), true), new PipedInputStream(out), new PipedInputStream(err));
        }
        catch (Throwable t) {
            this.exception = t;
        }
    }

    final Throwable getException() {
        return this.exception;
    }

    final InOutPanel getPanel() {
        return this.panel;
    }

    protected final JFrame createFrame() {
        if (this.exception == null) {
            JFrame frame = new JFrame(TITLE);
            frame.getContentPane().add((Component)this.panel, "Center");
            frame.setSize(600, 400);
            frame.setDefaultCloseOperation(3);
            frame.setVisible(true);
            return frame;
        }
        if (this.exception instanceof OCamlJavaException) {
            Throwable t = this.exception.getCause();
            if (!(t instanceof FailException) && !(t instanceof FatalError)) {
                System.out.println("error: " + this.exception.getMessage());
            } else {
                System.out.println("error: " + t.getMessage());
            }
        } else if (this.exception instanceof FatalError) {
            System.out.println("fatal error: " + this.exception.getMessage());
        } else if (this.exception instanceof IOException) {
            System.out.println("i/o error: " + this.exception.getMessage());
        } else if (this.exception instanceof Exception) {
            System.out.println("internal error: " + this.exception.getMessage());
            this.exception.printStackTrace(System.err);
        } else {
            System.out.println("Java error: " + this.exception.getMessage());
            this.exception.printStackTrace(System.err);
        }
        System.exit(1);
        return null;
    }
}

