/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.graph;

import java.awt.Graphics2D;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.otherlibs.graph.GraphSlot;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="graph", module="Graphics", source="otherlibs/graph/fill.c")
public final class Fill {
    private Fill() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int", "int", "int"}, returnType="unit")
    public static Value caml_gr_fill_rect(Value vx, Value vy, Value vw, Value vh) throws FailException {
        Graphics2D store;
        GraphSlot slot = GraphSlot.checkGraph();
        int w = vw.asCastedInt();
        int h = vh.asCastedInt();
        int x = vx.asCastedInt();
        int y = slot.convertY(vy.asCastedInt()) - h;
        Graphics2D win = slot.createWindowGraphics();
        if (win != null) {
            win.fillRect(x, y, w, h);
            win.dispose();
            slot.repaint();
        }
        if ((store = slot.createBackingStoreGraphics()) != null) {
            store.fillRect(x, y, w, h);
            store.dispose();
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"(int * int) array"}, returnType="unit")
    public static Value caml_gr_fill_poly(Value array) throws FailException {
        Graphics2D store;
        GraphSlot slot = GraphSlot.checkGraph();
        int len = (int)array.sizeValues();
        int[] x = new int[len];
        int[] y = new int[len];
        for (int i = 0; i < len; ++i) {
            Value pt = array.get(i);
            x[i] = pt.get0().asCastedInt();
            y[i] = slot.convertY(pt.get1().asCastedInt());
        }
        Graphics2D win = slot.createWindowGraphics();
        if (win != null) {
            win.fillPolygon(x, y, len);
            win.dispose();
            slot.repaint();
        }
        if ((store = slot.createBackingStoreGraphics()) != null) {
            store.fillPolygon(x, y, len);
            store.dispose();
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int", "int", "int", "int", "int"}, returnType="unit")
    public static Value caml_gr_fill_arc(Value vx, Value vy, Value vrx, Value vry, Value va1, Value va2) throws FailException {
        Graphics2D store;
        GraphSlot slot = GraphSlot.checkGraph();
        int rx = vrx.asCastedInt();
        int ry = vry.asCastedInt();
        int x = vx.asCastedInt() - rx;
        int y = slot.convertY(vy.asCastedInt()) - ry;
        int w = rx * 2;
        int h = ry * 2;
        int sa = va1.asCastedInt();
        int aa = va2.asCastedInt() - sa;
        Graphics2D win = slot.createWindowGraphics();
        if (win != null) {
            win.fillArc(x, y, w, h, sa, aa);
            win.dispose();
            slot.repaint();
        }
        if ((store = slot.createBackingStoreGraphics()) != null) {
            store.fillArc(x, y, w, h, sa, aa);
            store.dispose();
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int", "int", "int", "int", "int"}, returnType="unit")
    public static Value caml_gr_fill_arc_nat(Value vx, Value vy, Value vrx, Value vry, Value va1, Value va2) throws FailException {
        return Fill.caml_gr_fill_arc(vx, vy, vrx, vry, va1, va2);
    }
}

