/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.javalibs.concurrent.STMSlot;
import org.ocamljava.runtime.primitives.javalibs.concurrent.STMVariable;
import org.ocamljava.runtime.values.Value;

final class STMTransaction
implements Comparable<STMTransaction> {
    private static final AtomicInteger NEXT_ID = new AtomicInteger(0);
    private final int identifier = NEXT_ID.getAndIncrement();
    private final int readVersion;
    private final SortedMap<STMVariable, Value> writeSet;
    private final SortedSet<STMVariable> readSet;
    private final Thread originalThread;
    private boolean invalidated;

    STMTransaction(int rv) {
        this.readVersion = rv;
        this.writeSet = new TreeMap<STMVariable, Value>();
        this.readSet = new TreeSet<STMVariable>();
        this.invalidated = false;
        this.originalThread = Thread.currentThread();
    }

    long getReadVersion() {
        return this.readVersion;
    }

    Value readVariable(STMVariable var) throws FailException {
        this.checkNotInvalidated();
        Value localVersion = (Value)this.writeSet.get(var);
        if (localVersion != null) {
            return localVersion;
        }
        Value res = var.get();
        if (var.getWriteLock().availablePermits() > 0 && var.getVersionNumber() <= this.readVersion) {
            this.readSet.add(var);
            return res;
        }
        this.invalidate();
        STMTransaction.raiseRetry();
        return null;
    }

    void writeVariable(STMVariable var, Value val) throws FailException {
        this.checkNotInvalidated();
        this.writeSet.put(var, val);
    }

    void commit() throws FailException {
        for (STMVariable var : this.writeSet.keySet()) {
            var.getWriteLock().acquireUninterruptibly(1);
        }
        int writeVersionNumber = STMSlot.get().getGlobalVersionClock().incrementAndGet();
        for (STMVariable sTMVariable : this.readSet) {
            if ((this.writeSet.keySet().contains(sTMVariable) || sTMVariable.getWriteLock().availablePermits() != 0) && sTMVariable.getVersionNumber() <= this.readVersion) continue;
            for (STMVariable vr : this.writeSet.keySet()) {
                vr.getWriteLock().release();
            }
            this.invalidate();
            STMTransaction.raiseRetry();
        }
        for (Map.Entry entry : this.writeSet.entrySet()) {
            STMVariable var = (STMVariable)entry.getKey();
            Value val = (Value)entry.getValue();
            var.set(val, writeVersionNumber);
        }
        for (STMVariable sTMVariable : this.writeSet.keySet()) {
            sTMVariable.getWriteLock().release();
        }
        this.invalidate();
    }

    void invalidate() {
        this.invalidated = true;
        this.writeSet.clear();
        this.readSet.clear();
    }

    void checkNotInvalidated() throws FailException {
        if (this.invalidated) {
            Fail.failWith("Invalidated transaction");
        }
        if (Thread.currentThread() != this.originalThread) {
            Fail.failWith("Accessor called from another thread");
        }
    }

    public int hashCode() {
        return this.identifier;
    }

    public boolean equals(Object obj) {
        if (obj instanceof STMTransaction) {
            STMTransaction that = (STMTransaction)obj;
            return that.identifier == this.identifier;
        }
        return false;
    }

    @Override
    public int compareTo(STMTransaction that) {
        return Integer.compare(this.identifier, that.identifier);
    }

    static void raiseRetry() throws FailException {
        Value exn = CurrentContext.getCodeState().getCallback("Concurrent.STM.Retry");
        if (exn != null) {
            Fail.raiseWithConstant(exn);
        } else {
            Fail.invalidArgument("Exception Concurrent.STM.Retry not initialized");
        }
    }
}

