/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="AtomicReferenceArray", source="")
public final class AtomicReferenceArray {
    private AtomicReferenceArray() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int32", "'a"}, returnType="'a AtomicReferenceArray.t")
    public static Value ocamljava_atomicreferencearray_make(Value length, Value initialValue) throws FailException {
        try {
            int len = length.asInt32();
            java.util.concurrent.atomic.AtomicReferenceArray<Value> res = new java.util.concurrent.atomic.AtomicReferenceArray<Value>(len);
            for (int i = 0; i < len; ++i) {
                res.set(i, initialValue);
            }
            return Value.createInstance(res);
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.AtomicReferenceArray.make");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a AtomicReferenceArray.t", "int32", "'a", "'a"}, returnType="bool")
    public static Value ocamljava_atomicreferencearray_compare_and_set(Value obj, Value i, Value expect, Value update) throws FailException {
        try {
            java.util.concurrent.atomic.AtomicReferenceArray inst = (java.util.concurrent.atomic.AtomicReferenceArray)obj.asCustom();
            boolean res = inst.compareAndSet(i.asInt32(), expect, update);
            return res ? Value.TRUE : Value.FALSE;
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a AtomicReferenceArray.t", "int32"}, returnType="'a")
    public static Value ocamljava_atomicreferencearray_get(Value obj, Value i) throws FailException {
        try {
            java.util.concurrent.atomic.AtomicReferenceArray inst = (java.util.concurrent.atomic.AtomicReferenceArray)obj.asCustom();
            Value res = (Value)inst.get(i.asInt32());
            return res;
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a AtomicReferenceArray.t", "int32", "'a"}, returnType="'a")
    public static Value ocamljava_atomicreferencearray_get_and_set(Value obj, Value i, Value newValue) throws FailException {
        try {
            java.util.concurrent.atomic.AtomicReferenceArray inst = (java.util.concurrent.atomic.AtomicReferenceArray)obj.asCustom();
            Value res = inst.getAndSet(i.asInt32(), newValue);
            return res;
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a AtomicReferenceArray.t", "int32", "'a"}, returnType="unit")
    public static Value ocamljava_atomicreferencearray_lazy_set(Value obj, Value i, Value newValue) throws FailException {
        try {
            java.util.concurrent.atomic.AtomicReferenceArray inst = (java.util.concurrent.atomic.AtomicReferenceArray)obj.asCustom();
            inst.lazySet(i.asInt32(), newValue);
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a AtomicReferenceArray.t"}, returnType="int32")
    public static Value ocamljava_atomicreferencearray_length(Value obj) {
        java.util.concurrent.atomic.AtomicReferenceArray inst = (java.util.concurrent.atomic.AtomicReferenceArray)obj.asCustom();
        int res = inst.length();
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a AtomicReferenceArray.t", "int32", "'a"}, returnType="unit")
    public static Value ocamljava_atomicreferencearray_set(Value obj, Value i, Value newValue) throws FailException {
        try {
            java.util.concurrent.atomic.AtomicReferenceArray inst = (java.util.concurrent.atomic.AtomicReferenceArray)obj.asCustom();
            inst.set(i.asInt32(), newValue);
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a AtomicReferenceArray.t", "int32", "'a", "'a"}, returnType="bool")
    public static Value ocamljava_atomicreferencearray_weak_compare_and_set(Value obj, Value i, Value expect, Value update) throws FailException {
        try {
            java.util.concurrent.atomic.AtomicReferenceArray inst = (java.util.concurrent.atomic.AtomicReferenceArray)obj.asCustom();
            boolean res = inst.weakCompareAndSet(i.asInt32(), expect, update);
            return res ? Value.TRUE : Value.FALSE;
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }
}

