/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.parameters;

import java.io.InputStream;
import java.io.PrintStream;
import org.ocamljava.runtime.annotations.parameters.BooleanParameter;
import org.ocamljava.runtime.annotations.parameters.FileParameter;
import org.ocamljava.runtime.annotations.parameters.InputStreamParameter;
import org.ocamljava.runtime.annotations.parameters.OutputStreamParameter;
import org.ocamljava.runtime.annotations.parameters.StringParameter;
import org.ocamljava.runtime.annotations.parameters.UnparsedElementsParameter;

public interface CommonParameters {
    @UnparsedElementsParameter(key="ARGUMENTS", defaultValue={})
    public String[] getArguments();

    @BooleanParameter(key="BACKTRACE", commandLineSwitch="backtrace", guiLabel="Backtrace state:", guiStrings={"disabled", "enabled"}, description="whether exception backtrace should be printed", defaultValue=false)
    public boolean isBacktraceRequested();

    @BooleanParameter(key="STOP_JVM", commandLineSwitch="stop-jvm", guiLabel="Action upon exit:", guiStrings={"nothing", "stop JVM"}, description="whether program end should stop JVM", defaultValue=true)
    public boolean isExitStoppingJVM();

    @InputStreamParameter(key="IN")
    public InputStream getStandardInput();

    @OutputStreamParameter(key="OUT", isErrorOutput=false)
    public PrintStream getStandardOutput();

    @OutputStreamParameter(key="ERR", isErrorOutput=true)
    public PrintStream getStandardError();

    @BooleanParameter(key="AWT", commandLineSwitch="awt", guiLabel="Graphics frame:", guiStrings={"Swing", "AWT"}, description="whether Graphics library should use AWT", defaultValue=false)
    public boolean isFrameAWT();

    @BooleanParameter(key="BARE_CANVAS", commandLineSwitch="", guiLabel="", guiStrings={}, description="", defaultValue=false)
    public boolean isBareCanvas();

    @BooleanParameter(key="JAVAX_SOUND", commandLineSwitch="javax-sound", guiLabel="Sound:", guiStrings={"beep", "javax.sound"}, description="whether Graphics library should use javax.sound", defaultValue=false)
    public boolean isJavaxSoundUsed();

    @StringParameter(key="OS", commandLineSwitch="os", guiLabel="OS:", description="how underlying OS should be identified", argumentDescription="auto|Unix|Cygwin|Win32|Java", defaultValue="auto", possibleValues={"auto", "Unix", "Cygwin", "Win32", "Java"})
    public String getOS();

    @BooleanParameter(key="UNIX_EMULATION", commandLineSwitch="unix-emulation", guiLabel="Unix primitives:", guiStrings={"not implemented", "emulated"}, description="whether unix primitives should be emulated", defaultValue=false)
    public boolean isUnixEmulated();

    @FileParameter(key="FILE", defaultValue="")
    public String getFile();

    @BooleanParameter(key="EMBEDDED", commandLineSwitch="embedded", guiLabel="Embedded mode:", guiStrings={"disabled", "enabled"}, description="whether embedded mode should be activated", defaultValue=false)
    public boolean isEmbedded();

    @StringParameter(key="EMBEDDED_BASE", commandLineSwitch="embedded-base", guiLabel="Embedded base:", description="base class used by embedded mode", argumentDescription="fully-qualified class name", defaultValue="")
    public String getEmbeddedBase();

    @BooleanParameter(key="RUNTIME_LOCK", commandLineSwitch="runtime-lock", guiLabel="Runtime lock:", guiStrings={"disabled", "enabled"}, description="whether runtime lock should be activated", defaultValue=true)
    public boolean hasRuntimeLock();

    public static enum BooleanParameterID {
        BACKTRACE,
        STOP_JVM,
        AWT,
        BARE_CANVAS,
        JAVAX_SOUND,
        UNIX_EMULATION,
        EMBEDDED,
        RUNTIME_LOCK;

    }

    public static enum StringParameterID {
        OS,
        EMBEDDED_BASE;

    }

    public static enum PrintStreamParameterID {
        OUT,
        ERR;

    }

    public static enum InputStreamParameterID {
        IN;

    }
}

