/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.ocamljava.runtime.kernel.Dispatcher;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.kernel.FatalErrorKind;
import org.ocamljava.runtime.kernel.Invoker;
import org.ocamljava.runtime.values.Value;

final class MethodHandleDispatcher
implements Dispatcher {
    private int size;
    private String[] names;
    private Method[] implementations;
    private MethodHandle[] handles;

    MethodHandleDispatcher(String[] nams, Method[] impls) throws IllegalAccessException {
        assert (nams != null) : "null nams";
        assert (impls != null) : "null impls";
        assert (nams.length == impls.length) : "nams and impls should have the same length";
        this.size = nams.length;
        this.names = Arrays.copyOf(nams, nams.length);
        this.implementations = Arrays.copyOf(impls, impls.length);
        this.handles = new MethodHandle[impls.length];
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        for (int i = 0; i < this.handles.length; ++i) {
            this.handles[i] = lookup.unreflect(impls[i]);
        }
    }

    @Override
    public String[] getNames() {
        return this.names;
    }

    @Override
    public Method[] getMethods() {
        return this.implementations;
    }

    @Override
    public String getName(int prim) {
        if (prim >= 0 && prim < this.size) {
            return this.names[prim];
        }
        return null;
    }

    @Override
    public Method getMethod(int prim) {
        if (prim >= 0 && prim < this.size) {
            return this.implementations[prim];
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Value invoke(int prim, Value[] params) throws FatalError, FailException, FalseExit {
        assert (params != null) : "null params";
        try {
            return Invoker.call(this.handles[prim], params);
        }
        catch (FailException | FalseExit | FatalError fe) {
            throw fe;
        }
        catch (Throwable t) {
            this.reportFatal(prim, t);
            return null;
        }
    }

    @Override
    public Value invoke(int prim, Value p0) throws FatalError, FailException, FalseExit {
        assert (p0 != null) : "null p0";
        try {
            return this.handles[prim].invokeExact(p0);
        }
        catch (FailException | FalseExit | FatalError fe) {
            throw fe;
        }
        catch (Throwable t) {
            this.reportFatal(prim, t);
            return null;
        }
    }

    @Override
    public Value invoke(int prim, Value p0, Value p1) throws FatalError, FailException, FalseExit {
        assert (p0 != null) : "null p0";
        assert (p1 != null) : "null p1";
        try {
            return this.handles[prim].invokeExact(p0, p1);
        }
        catch (FailException | FalseExit | FatalError fe) {
            throw fe;
        }
        catch (Throwable t) {
            this.reportFatal(prim, t);
            return null;
        }
    }

    @Override
    public Value invoke(int prim, Value p0, Value p1, Value p2) throws FatalError, FailException, FalseExit {
        assert (p0 != null) : "null p0";
        assert (p1 != null) : "null p1";
        assert (p2 != null) : "null p2";
        try {
            return this.handles[prim].invokeExact(p0, p1, p2);
        }
        catch (FailException | FalseExit | FatalError fe) {
            throw fe;
        }
        catch (Throwable t) {
            this.reportFatal(prim, t);
            return null;
        }
    }

    @Override
    public Value invoke(int prim, Value p0, Value p1, Value p2, Value p3) throws FatalError, FailException, FalseExit {
        assert (p0 != null) : "null p0";
        assert (p1 != null) : "null p1";
        assert (p2 != null) : "null p2";
        assert (p3 != null) : "null p3";
        try {
            return this.handles[prim].invokeExact(p0, p1, p2, p3);
        }
        catch (FailException | FalseExit | FatalError fe) {
            throw fe;
        }
        catch (Throwable t) {
            this.reportFatal(prim, t);
            return null;
        }
    }

    @Override
    public Value invoke(int prim, Value p0, Value p1, Value p2, Value p3, Value p4) throws FatalError, FailException, FalseExit {
        assert (p0 != null) : "null p0";
        assert (p1 != null) : "null p1";
        assert (p2 != null) : "null p2";
        assert (p3 != null) : "null p3";
        assert (p4 != null) : "null p4";
        try {
            return this.handles[prim].invokeExact(p0, p1, p2, p3, p4);
        }
        catch (FailException | FalseExit | FatalError fe) {
            throw fe;
        }
        catch (Throwable t) {
            this.reportFatal(prim, t);
            return null;
        }
    }

    @Override
    public int addPrimitive(String name, Method impl) throws IllegalAccessException {
        assert (name != null) : "null name";
        assert (impl != null) : "null impl";
        int oldSize = this.size++;
        Method[] impls = new Method[this.size];
        System.arraycopy(this.implementations, 0, impls, 0, oldSize);
        impls[oldSize] = impl;
        this.implementations = impls;
        String[] nams = new String[this.size];
        System.arraycopy(this.names, 0, nams, 0, oldSize);
        nams[oldSize] = name;
        this.names = nams;
        MethodHandle[] handls = new MethodHandle[this.size];
        System.arraycopy(this.handles, 0, handls, 0, oldSize);
        handls[oldSize] = MethodHandles.lookup().unreflect(impl);
        this.handles = handls;
        return oldSize;
    }

    private void reportFatal(int prim, Throwable t) throws FatalError {
        assert (t != null) : "null t";
        StringWriter sw = new StringWriter();
        sw.append(this.getName(prim));
        sw.append(":\n");
        t.printStackTrace(new PrintWriter(sw));
        Fatal.raise(FatalErrorKind.PRIMITIVE_ERROR, sw.toString());
    }
}

