/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.values.Value;

public final class Fail {
    private Fail() {
    }

    public static void raise(Value v) throws FailException {
        assert (v != null) : "null v";
        throw new FailException(v);
    }

    public static void raiseWithConstant(Value tag) throws FailException {
        assert (tag != null) : "null tag";
        throw new FailException(Value.createBlock(0, tag));
    }

    public static FailException createWithConstant(Value tag) {
        assert (tag != null) : "null tag";
        return new FailException(Value.createBlock(0, tag));
    }

    public static void raiseWithArg(Value tag, Value arg) throws FailException {
        assert (tag != null) : "null tag";
        assert (arg != null) : "null arg";
        throw new FailException(Value.createBlock(0, tag, arg));
    }

    public static FailException createWithArg(Value tag, Value arg) {
        assert (tag != null) : "null tag";
        assert (arg != null) : "null arg";
        return new FailException(Value.createBlock(0, tag, arg));
    }

    public static void raiseWithArgs(Value tag, Value ... args) throws FailException {
        assert (tag != null) : "null tag";
        assert (args != null) : "null args";
        int len = args.length;
        Value b = Value.createBlock(0, 1 + len);
        b.set0(tag);
        for (int i = 0; i < len; ++i) {
            b.set(1 + i, args[i]);
        }
        throw new FailException(b);
    }

    public static void raiseWithString(Value tag, String msg) throws FailException {
        assert (tag != null) : "null tag";
        assert (msg != null) : "null msg";
        throw new FailException(Value.createBlock(0, tag, Value.createString(msg)));
    }

    public static FailException createWithString(Value tag, String msg) {
        assert (tag != null) : "null tag";
        assert (msg != null) : "null msg";
        return new FailException(Value.createBlock(0, tag, Value.createString(msg)));
    }

    public static void failWith(String msg) throws FailException {
        assert (msg != null) : "null msg";
        Value tag = CurrentContext.getPredefinedExceptions().exnFailure;
        throw new FailException(Value.createBlock(0, tag, Value.createString(msg)));
    }

    public static void invalidArgument(String msg) throws FailException {
        assert (msg != null) : "null msg";
        Value tag = CurrentContext.getPredefinedExceptions().exnInvalidArgument;
        throw new FailException(Value.createBlock(0, tag, Value.createString(msg)));
    }

    public static void raiseSysError(String msg) throws FailException {
        assert (msg != null) : "null msg";
        Value tag = CurrentContext.getPredefinedExceptions().exnSysError;
        throw new FailException(Value.createBlock(0, tag, Value.createString(msg)));
    }

    public static void arrayBoundError() throws FailException {
        Fail.invalidArgument("index out of bounds");
    }

    public static void raiseOutOfMemory() throws FailException {
        Value tag = CurrentContext.getPredefinedExceptions().exnOutOfMemory;
        throw new FailException(Value.createBlock(0, tag));
    }

    public static void raiseStackOverflow() throws FailException {
        Value tag = CurrentContext.getPredefinedExceptions().exnStackOverflow;
        throw new FailException(Value.createBlock(0, tag));
    }

    public static void raiseEndOfFile() throws FailException {
        Value tag = CurrentContext.getPredefinedExceptions().exnEndOfFile;
        throw new FailException(Value.createBlock(0, tag));
    }

    public static void raiseZeroDivide() throws FailException {
        Value tag = CurrentContext.getPredefinedExceptions().exnDivisionByZero;
        throw new FailException(Value.createBlock(0, tag));
    }

    public static void raiseNotFound() throws FailException {
        Value tag = CurrentContext.getPredefinedExceptions().exnNotFound;
        throw new FailException(Value.createBlock(0, tag));
    }

    public static void raiseSysBlockedIO() throws FailException {
        Value tag = CurrentContext.getPredefinedExceptions().exnSysBlockedIO;
        throw new FailException(Value.createBlock(0, tag));
    }

    static FailException createZeroDivide() {
        Value tag = CurrentContext.getPredefinedExceptions().exnDivisionByZero;
        return new FailException(Value.createBlock(0, tag));
    }

    static FailException createStackOverflow() {
        Value tag = CurrentContext.getPredefinedExceptions().exnStackOverflow;
        return new FailException(Value.createBlock(0, tag));
    }

    public static Value asValue(Throwable t) throws FalseExit {
        if (t instanceof FailException) {
            return ((FailException)t).getValue();
        }
        if (t instanceof FatalError) {
            throw (FatalError)t;
        }
        if (t instanceof FalseExit) {
            throw (FalseExit)t;
        }
        Value tag = t instanceof Exception ? CurrentContext.getPredefinedExceptions().exnJavaException : CurrentContext.getPredefinedExceptions().exnJavaError;
        return Value.createBlock(0, tag, Value.createInstance(t));
    }

    public static void reraise(Throwable t, Value v) throws FailException {
        if (t instanceof Throwable) {
            throw (FailException)t;
        }
        throw new FailException(v);
    }
}

