/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.DebuggerState;
import org.ocamljava.runtime.kernel.ByteCodeRunner;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.kernel.FatalErrorKind;
import org.ocamljava.runtime.kernel.MarshalExtern;
import org.ocamljava.runtime.kernel.ValueStack;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.IO;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.Value;

public final class Debugger {
    private static final Map<Integer, Request> REQUEST_MAP = new HashMap<Integer, Request>();
    private static final Map<Integer, Reply> REPLY_MAP = new HashMap<Integer, Reply>();

    private Debugger() {
    }

    public static void init(Context ctxt) throws FatalError {
        Socket socket;
        String host;
        String address;
        assert (ctxt != null) : "null ctxt";
        DebuggerState state = ctxt.getDebuggerState();
        try {
            address = System.getenv("CAML_DEBUG_SOCKET");
        }
        catch (SecurityException t) {
            return;
        }
        if (address == null) {
            return;
        }
        int colonIndex = address.indexOf(":");
        String port = colonIndex >= 0 ? address.substring(colonIndex + 1) : null;
        String string = host = colonIndex >= 0 ? address.substring(0, colonIndex) : address;
        if (port == null) {
            Fatal.raise(FatalErrorKind.DEBUGGER_ERROR, "Unix sockets not supported");
            return;
        }
        try {
            socket = new Socket(host, Integer.parseInt(port));
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            if (!state.isDebuggerInUse()) {
                IO.write32s(out, -1);
            }
            IO.write32u(out, 0L);
            out.flush();
        }
        catch (Exception e) {
            String msg = String.format("cannot connect to debugger at %s: %s", address, e.getMessage());
            Fatal.raise(FatalErrorKind.DEBUGGER_ERROR, msg);
            return;
        }
        state.setDebuggerInUse(true);
        state.setDebuggerSocket(socket);
        state.setDebuggerTrapBarrier(0);
    }

    public static void handleEvent(ByteCodeRunner runner, EventKind event) throws FailException, FatalError, FalseExit {
        DataOutputStream out;
        DataInputStream in;
        assert (runner != null) : "null runner";
        assert (event != null) : "null event";
        Context ctxt = runner.getContext();
        DebuggerState state = ctxt.getDebuggerState();
        Socket socket = state.getDebuggerSocket();
        if (socket == null) {
            return;
        }
        try {
            in = new DataInputStream(socket.getInputStream());
            out = new DataOutputStream(socket.getOutputStream());
        }
        catch (IOException ioe) {
            return;
        }
        try {
            ArrayList<Value> values = new ArrayList<Value>();
            ValueStack stack = runner.getStack();
            int stackSize = stack.size();
            int frame = stackSize - 2;
            switch (event) {
                case PROGRAM_START: {
                    break;
                }
                case EVENT_COUNT: {
                    IO.write8u(out, Reply.REP_EVENT.getCharCode());
                    break;
                }
                case BREAKPOINT: {
                    IO.write8u(out, Reply.REP_BREAKPOINT.getCharCode());
                    break;
                }
                case PROGRAM_EXIT: {
                    IO.write8u(out, Reply.REP_EXITED.getCharCode());
                    break;
                }
                case TRAP_BARRIER: {
                    IO.write8u(out, Reply.REP_TRAP.getCharCode());
                    break;
                }
                case UNCAUGHT_EXC: {
                    IO.write8u(out, Reply.REP_UNCAUGHT_EXC.getCharCode());
                    break;
                }
                default: {
                    assert (false) : "invalid event";
                    break;
                }
            }
            if (event != EventKind.PROGRAM_START) {
                IO.write32u(out, state.getDebuggerEventCount());
                if (event == EventKind.EVENT_COUNT || event == EventKind.BREAKPOINT) {
                    IO.write32s(out, frame);
                    IO.write32s(out, (int)stack.peek(1).asCodeOffset() * 4);
                } else {
                    IO.write32s(out, 0);
                    IO.write32s(out, 0);
                }
                out.flush();
            }
            int[] code = ctxt.getCodeState().getCode();
            int[] savedCode = ctxt.getCodeState().getSavedCode();
            int codeLen = code.length;
            block35: while (true) {
                int command;
                if ((command = in.read()) == -1) {
                    return;
                }
                Request req = Request.fromCharCode(command);
                switch (req) {
                    case REQ_SET_EVENT: {
                        int pos = IO.read32s(in) / 4;
                        assert (pos >= 0 && pos < codeLen) : "invalid code position";
                        code[pos] = 144;
                        continue block35;
                    }
                    case REQ_SET_BREAKPOINT: {
                        int pos = IO.read32s(in) / 4;
                        assert (pos >= 0 && pos < codeLen) : "invalid code position";
                        code[pos] = 145;
                        continue block35;
                    }
                    case REQ_RESET_INSTR: {
                        int pos = IO.read32s(in) / 4;
                        assert (pos >= 0 && pos < codeLen) : "invalid code position";
                        code[pos] = savedCode[pos];
                        continue block35;
                    }
                    case REQ_CHECKPOINT: {
                        Fatal.raise(FatalErrorKind.DEBUGGER_ERROR, "REQ_CHECKPOINT command");
                        return;
                    }
                    case REQ_GO: {
                        state.setDebuggerEventCount(IO.read32u(in));
                        return;
                    }
                    case REQ_STOP: {
                        if (!ctxt.getParameters().isExitStoppingJVM()) {
                            ctxt.getThreadsState().getThreadGroup().interrupt();
                            ctxt.getThreadsState().interruptAdditionalThreads();
                            throw new FalseExit(ctxt, 0);
                        }
                        System.exit(0);
                        return;
                    }
                    case REQ_WAIT: {
                        Fatal.raise(FatalErrorKind.DEBUGGER_ERROR, "REQ_WAIT command");
                        return;
                    }
                    case REQ_INITIAL_FRAME: {
                        frame = stackSize - 2;
                    }
                    case REQ_GET_FRAME: {
                        IO.write32s(out, frame);
                        if (frame > 0) {
                            IO.write32s(out, (int)stack.peek(1).asCodeOffset() * 4);
                        } else {
                            IO.write32s(out, 0);
                        }
                        out.flush();
                        continue block35;
                    }
                    case REQ_SET_FRAME: {
                        int pos = IO.read32s(in);
                        frame = stackSize - pos;
                        continue block35;
                    }
                    case REQ_UP_FRAME: {
                        int pos = IO.read32s(in);
                        int extraArgs = stack.peek(stackSize - 2 - frame + 3).asCastedInt();
                        if (frame - extraArgs - pos - 3 <= 0) {
                            IO.write32s(out, -1);
                            continue block35;
                        }
                        IO.write32s(out, frame -= extraArgs + pos + 3);
                        IO.write32s(out, (int)stack.peek(stackSize - 2 - frame + 1).asCodeOffset() * 4);
                        continue block35;
                    }
                    case REQ_SET_TRAP_BARRIER: {
                        int pos = IO.read32s(in);
                        state.setDebuggerTrapBarrier(pos);
                        continue block35;
                    }
                    case REQ_GET_LOCAL: {
                        int pos = IO.read32s(in);
                        Debugger.putVal(out, values, stack.peek(stackSize - 2 - frame + 4 + pos));
                        out.flush();
                        continue block35;
                    }
                    case REQ_GET_ENVIRONMENT: {
                        int pos = IO.read32s(in);
                        Debugger.putVal(out, values, stack.peek(stackSize - 2 - frame + 2).get(pos));
                        out.flush();
                        continue block35;
                    }
                    case REQ_GET_GLOBAL: {
                        int pos = IO.read32s(in);
                        Debugger.putVal(out, values, ctxt.getCodeState().getGlobalData().get(pos));
                        out.flush();
                        continue block35;
                    }
                    case REQ_GET_ACCU: {
                        Debugger.putVal(out, values, stack.peek(0));
                        out.flush();
                        continue block35;
                    }
                    case REQ_GET_HEADER: {
                        Value val = Debugger.getVal(in, values);
                        IO.write32s(out, (int)val.getHeader());
                        out.flush();
                        continue block35;
                    }
                    case REQ_GET_FIELD: {
                        Value val = Debugger.getVal(in, values);
                        int pos = IO.read32s(in);
                        if (val.getTag() != 254) {
                            IO.write8s(out, 0);
                            Debugger.putVal(out, values, val.get(pos));
                        } else {
                            IO.write8s(out, 1);
                            IO.write64s(out, Double.doubleToRawLongBits(val.getDouble(pos)));
                        }
                        out.flush();
                        continue block35;
                    }
                    case REQ_MARSHAL_OBJ: {
                        Value val = Debugger.getVal(in, values);
                        out.write(MarshalExtern.externValue(ctxt, val, Value.UNIT));
                        out.flush();
                        continue block35;
                    }
                    case REQ_GET_CLOSURE: {
                        Value val = Debugger.getVal(in, values);
                        IO.write32s(out, (int)val.get0().asCodeOffset() * 4);
                        out.flush();
                        continue block35;
                    }
                    case REQ_SET_FORK_MODE: {
                        IO.read32s(in);
                        continue block35;
                    }
                }
                if (!$assertionsDisabled) break;
            }
            throw new AssertionError((Object)"invalid request");
        }
        catch (IOException ioe) {
            Fatal.raise(FatalErrorKind.DEBUGGER_ERROR, "communication error");
            return;
        }
    }

    private static void putVal(DataOutputStream out, List<Value> l, Value v) throws IOException {
        assert (out != null) : "null out";
        assert (l != null) : "null l";
        assert (v != null) : "null v";
        if (v.isBlock()) {
            int index;
            int len = l.size();
            for (index = 0; index < len && l.get(index) != v; ++index) {
            }
            if (index < len) {
                IO.write64s(out, index << 1);
            } else {
                l.add(v);
                IO.write64s(out, len << 1);
            }
        } else {
            IO.write64s(out, v.getRawValue());
        }
    }

    private static Value getVal(DataInputStream in, List<Value> l) throws FatalError, IOException {
        assert (in != null) : "null in";
        assert (l != null) : "null l";
        long v = IO.read64s(in);
        if ((v & 1L) == 0L) {
            int idx = (int)v >> 1;
            if (idx >= 0 && idx < l.size()) {
                return l.get(idx);
            }
            Fatal.raise(FatalErrorKind.DEBUGGER_ERROR, "unknown value");
            return null;
        }
        return Value.createFromRawValue(v);
    }

    public static final class Reply
    extends Enum<Reply> {
        public static final /* enum */ Reply REP_EVENT = new Reply('e');
        public static final /* enum */ Reply REP_BREAKPOINT = new Reply('b');
        public static final /* enum */ Reply REP_EXITED = new Reply('x');
        public static final /* enum */ Reply REP_TRAP = new Reply('s');
        public static final /* enum */ Reply REP_UNCAUGHT_EXC = new Reply('u');
        private final int code;
        private static final /* synthetic */ Reply[] $VALUES;

        public static Reply[] values() {
            return (Reply[])$VALUES.clone();
        }

        public static Reply valueOf(String name) {
            return Enum.valueOf(Reply.class, name);
        }

        private Reply(char c) {
            int x;
            this.code = x = IntegerUtils.signedToUnsignedByte(EncodingUtils.convertCharToByte(c));
            REPLY_MAP.put(x, this);
        }

        public static Reply fromCharCode(int c) {
            Reply res = (Reply)((Object)REPLY_MAP.get(c));
            assert (res != null) : "invalid code";
            return res;
        }

        public int getCharCode() {
            return this.code;
        }

        static {
            $VALUES = new Reply[]{REP_EVENT, REP_BREAKPOINT, REP_EXITED, REP_TRAP, REP_UNCAUGHT_EXC};
        }
    }

    public static final class Request
    extends Enum<Request> {
        public static final /* enum */ Request REQ_SET_EVENT = new Request('e');
        public static final /* enum */ Request REQ_SET_BREAKPOINT = new Request('B');
        public static final /* enum */ Request REQ_RESET_INSTR = new Request('i');
        public static final /* enum */ Request REQ_CHECKPOINT = new Request('c');
        public static final /* enum */ Request REQ_GO = new Request('g');
        public static final /* enum */ Request REQ_STOP = new Request('s');
        public static final /* enum */ Request REQ_WAIT = new Request('w');
        public static final /* enum */ Request REQ_INITIAL_FRAME = new Request('0');
        public static final /* enum */ Request REQ_GET_FRAME = new Request('f');
        public static final /* enum */ Request REQ_SET_FRAME = new Request('S');
        public static final /* enum */ Request REQ_UP_FRAME = new Request('U');
        public static final /* enum */ Request REQ_SET_TRAP_BARRIER = new Request('b');
        public static final /* enum */ Request REQ_GET_LOCAL = new Request('L');
        public static final /* enum */ Request REQ_GET_ENVIRONMENT = new Request('E');
        public static final /* enum */ Request REQ_GET_GLOBAL = new Request('G');
        public static final /* enum */ Request REQ_GET_ACCU = new Request('A');
        public static final /* enum */ Request REQ_GET_HEADER = new Request('H');
        public static final /* enum */ Request REQ_GET_FIELD = new Request('F');
        public static final /* enum */ Request REQ_MARSHAL_OBJ = new Request('M');
        public static final /* enum */ Request REQ_GET_CLOSURE = new Request('C');
        public static final /* enum */ Request REQ_SET_FORK_MODE = new Request('K');
        private final int code;
        private static final /* synthetic */ Request[] $VALUES;

        public static Request[] values() {
            return (Request[])$VALUES.clone();
        }

        public static Request valueOf(String name) {
            return Enum.valueOf(Request.class, name);
        }

        private Request(char c) {
            int x;
            this.code = x = IntegerUtils.signedToUnsignedByte(EncodingUtils.convertCharToByte(c));
            REQUEST_MAP.put(x, this);
        }

        public static Request fromCharCode(int c) {
            Request res = (Request)((Object)REQUEST_MAP.get(c));
            assert (res != null) : "invalid code";
            return res;
        }

        public int getCharCode() {
            return this.code;
        }

        static {
            $VALUES = new Request[]{REQ_SET_EVENT, REQ_SET_BREAKPOINT, REQ_RESET_INSTR, REQ_CHECKPOINT, REQ_GO, REQ_STOP, REQ_WAIT, REQ_INITIAL_FRAME, REQ_GET_FRAME, REQ_SET_FRAME, REQ_UP_FRAME, REQ_SET_TRAP_BARRIER, REQ_GET_LOCAL, REQ_GET_ENVIRONMENT, REQ_GET_GLOBAL, REQ_GET_ACCU, REQ_GET_HEADER, REQ_GET_FIELD, REQ_MARSHAL_OBJ, REQ_GET_CLOSURE, REQ_SET_FORK_MODE};
        }
    }

    public static enum EventKind {
        EVENT_COUNT,
        BREAKPOINT,
        PROGRAM_START,
        PROGRAM_EXIT,
        TRAP_BARRIER,
        UNCAUGHT_EXC;

    }
}

