/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.MemoryInputStream;
import org.ocamljava.runtime.util.PermissionsUtils;
import org.ocamljava.runtime.util.PlatformUtils;

public final class Channel {
    public static final int STDIN = 0;
    public static final int STDOUT = 1;
    public static final int STDERR = 2;
    public static final int O_RDONLY = 0;
    public static final int O_WRONLY = 1;
    public static final int O_APPEND = 8;
    public static final int O_CREAT = 512;
    public static final int O_TRUNC = 1024;
    public static final int O_EXCL = 2048;
    public static final int O_NONBLOCK = 4;
    public static final int O_BINARY = 0;
    public static final int O_TEXT = 0;
    public static final int BUFFER_SIZE = 65536;
    public static final int SEEK_SET = 0;
    public static final int SEEK_CUR = 1;
    public static final int SEEK_END = 2;
    private static final int NEW_LINE = 10;
    private static final int CARRIAGE_RETURN = 13;
    private static final boolean IS_WINDOWS = PlatformUtils.isWindowPlatform();
    private static final Console CONSOLE = System.console();
    private final Kind kind;
    private int fd;
    private ByteBuffer buffer;
    private int limit;
    private final ByteBuffer writeBuffer;
    private final java.nio.channels.Channel channel;
    private ServerSocketChannel server;
    private InetSocketAddress bindAddress;

    public Channel(File f, int flags, int perms) throws IOException {
        assert (f != null) : "null f";
        this.kind = Kind.ORDINARY;
        this.fd = -1;
        this.buffer = ByteBuffer.allocate(65536);
        this.writeBuffer = ByteBuffer.allocate(65536);
        this.limit = 0;
        FileAttribute<?> attr = PermissionsUtils.intToAttributes(perms);
        this.channel = attr != null && !IS_WINDOWS ? FileChannel.open(f.toPath(), Channel.openOptions(flags), attr) : FileChannel.open(f.toPath(), Channel.openOptions(flags), new FileAttribute[0]);
        this.server = null;
        this.bindAddress = null;
    }

    public Channel(java.nio.channels.Channel ch) {
        assert (ch != null) : "null ch";
        this.kind = Kind.ORDINARY;
        this.fd = -1;
        this.buffer = ByteBuffer.allocate(65536);
        this.writeBuffer = ByteBuffer.allocate(65536);
        this.limit = 0;
        this.channel = ch;
        this.server = null;
        this.bindAddress = null;
    }

    public Channel() throws IOException {
        this.fd = -1;
        this.kind = Kind.ORDINARY;
        this.buffer = ByteBuffer.allocate(65536);
        this.writeBuffer = ByteBuffer.allocate(65536);
        this.limit = 0;
        this.channel = SocketChannel.open();
        this.server = ServerSocketChannel.open();
        this.bindAddress = null;
    }

    public Channel(InputStream in) {
        assert (in != null) : "null in";
        int available = 0;
        try {
            available = in.available();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.kind = in == System.in && available == 0 && CONSOLE != null ? Kind.STANDARD_INPUT : Kind.ORDINARY;
        this.fd = -1;
        this.buffer = ByteBuffer.allocate(65536);
        this.writeBuffer = ByteBuffer.allocate(65536);
        this.limit = 0;
        this.channel = in instanceof MemoryInputStream ? ((MemoryInputStream)in).createChannel() : Channels.newChannel(in);
        this.server = null;
        this.bindAddress = null;
    }

    public Channel(OutputStream out) {
        assert (out != null) : "null out";
        this.kind = out == System.out || out == System.err ? Kind.STANDARD_OUTPUT_OR_ERROR : Kind.ORDINARY;
        this.fd = -1;
        this.buffer = ByteBuffer.allocate(65536);
        this.writeBuffer = ByteBuffer.allocate(65536);
        this.limit = 0;
        this.channel = Channels.newChannel(out);
        this.server = null;
        this.bindAddress = null;
    }

    public boolean isStandardOutputOrError() {
        return this.kind.equals((Object)Kind.STANDARD_OUTPUT_OR_ERROR);
    }

    public int getFD() {
        return this.fd;
    }

    public void setFD(int d) {
        this.fd = d;
    }

    public boolean isOutputChannel() {
        return this.channel instanceof WritableByteChannel;
    }

    public java.nio.channels.Channel asChannel() {
        return this.channel;
    }

    public SocketChannel asSocket() {
        if (this.channel instanceof SocketChannel) {
            return (SocketChannel)this.channel;
        }
        return null;
    }

    public ServerSocketChannel asServerSocket() {
        return this.server;
    }

    public DatagramChannel asDatagramSocket() {
        if (this.channel instanceof DatagramChannel) {
            return (DatagramChannel)this.channel;
        }
        return null;
    }

    public InputStream newInputStream() {
        return Channels.newInputStream((ReadableByteChannel)this.channel);
    }

    public OutputStream newOutputStream() {
        return Channels.newOutputStream((WritableByteChannel)this.channel);
    }

    public void truncate(long size) throws IOException {
        if (!(this.channel instanceof SeekableByteChannel)) {
            throw new IOException("unable to truncate channel");
        }
        ((SeekableByteChannel)this.channel).truncate(size);
    }

    public long position() throws IOException {
        if (this.channel instanceof WritableByteChannel) {
            Channel.writeBufferContents(this.writeBuffer, (WritableByteChannel)this.channel);
        }
        if (this.channel instanceof SeekableByteChannel) {
            return ((SeekableByteChannel)this.channel).position() - (long)this.buffer.position();
        }
        throw new IOException("unable to get channel position");
    }

    public long seek(long pos, int cmd) throws IOException {
        if (this.channel instanceof WritableByteChannel) {
            Channel.writeBufferContents(this.writeBuffer, (WritableByteChannel)this.channel);
        }
        if (this.channel instanceof SeekableByteChannel) {
            long p;
            SeekableByteChannel chan = (SeekableByteChannel)this.channel;
            switch (cmd) {
                case 0: {
                    p = pos;
                    break;
                }
                case 1: {
                    p = chan.position() - (long)this.buffer.position() + pos;
                    break;
                }
                case 2: {
                    p = chan.size() + pos;
                    break;
                }
                default: {
                    assert (false) : "invalid seek command";
                    p = -1L;
                }
            }
            this.buffer.clear();
            this.writeBuffer.clear();
            this.limit = 0;
            return chan.position(p).position();
        }
        throw new IOException("unable to set channel position");
    }

    public long size() throws IOException {
        if (this.channel instanceof WritableByteChannel) {
            Channel.writeBufferContents(this.writeBuffer, (WritableByteChannel)this.channel);
        }
        if (this.channel instanceof SeekableByteChannel) {
            return ((SeekableByteChannel)this.channel).size();
        }
        throw new IOException("unable to get channel size");
    }

    public int inputScanline() throws IOException {
        int limit;
        int pos = this.buffer.position();
        if (pos < (limit = this.limit)) {
            return this.getIndexOfEOL();
        }
        boolean refilled = this.refillNormal();
        if (refilled) {
            return this.getIndexOfEOL();
        }
        return 0;
    }

    private int getIndexOfEOL() {
        int position = this.buffer.position();
        int limit = this.limit;
        int pos = position;
        byte b = this.buffer.get(pos++);
        while (!Channel.isEOL(b)) {
            if (pos == limit) {
                return -(pos - position);
            }
            b = this.buffer.get(pos++);
        }
        return pos - position;
    }

    private boolean refillStandardInput() {
        this.buffer.clear();
        String line = CONSOLE.readLine();
        if (line != null) {
            int len = line.length();
            byte[] bytes = new byte[len + 1];
            EncodingUtils.convertStringToBytes(line, bytes, 0);
            bytes[len] = 10;
            if (len + 1 > this.buffer.capacity()) {
                this.buffer = ByteBuffer.allocate(len + 2);
            }
            this.buffer.put(bytes);
            this.buffer.position(0);
            this.limit = len + 1;
            return true;
        }
        this.limit = 0;
        return false;
    }

    private boolean refillNormal() throws IOException {
        this.buffer.clear();
        int read = ((ReadableByteChannel)this.channel).read(this.buffer);
        if (read >= 0) {
            this.buffer.position(0);
            this.limit = read;
            return true;
        }
        this.buffer.clear();
        this.limit = 0;
        return false;
    }

    public int read(byte[] b, int start, int len) throws IOException {
        if (this.channel instanceof ReadableByteChannel) {
            int remaining = this.limit - this.buffer.position();
            if (remaining > 0) {
                int nb = Math.min(remaining, len);
                this.buffer.get(b, start, nb);
                if (nb == remaining) {
                    this.buffer.clear();
                    this.limit = 0;
                }
                if (nb == len) {
                    return nb;
                }
                return nb + ((ReadableByteChannel)this.channel).read(ByteBuffer.wrap(b, start + nb, len - nb));
            }
            return ((ReadableByteChannel)this.channel).read(ByteBuffer.wrap(b, start, len));
        }
        throw new IOException("not an input channel");
    }

    public int read8u() throws IOException {
        byte[] b = new byte[1];
        int read = this.read(b, 0, 1);
        if (read == 1) {
            byte x = b[0];
            return x & 0xFF;
        }
        throw new ClosedChannelException();
    }

    public int read32s() throws IOException {
        byte[] b = new byte[4];
        int read = this.read(b, 0, 4);
        if (read == 4) {
            return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
        }
        throw new ClosedChannelException();
    }

    public void write8u(int x) throws IOException {
        if (this.writeBuffer.position() >= this.writeBuffer.limit()) {
            if (this.channel instanceof WritableByteChannel) {
                Channel.writeBufferContents(this.writeBuffer, (WritableByteChannel)this.channel);
            } else {
                throw new IOException("not an output channel");
            }
        }
        this.writeBuffer.put((byte)x);
    }

    public void write32s(int x) throws IOException {
        if (this.writeBuffer.position() + 3 >= this.writeBuffer.limit()) {
            if (this.channel instanceof WritableByteChannel) {
                Channel.writeBufferContents(this.writeBuffer, (WritableByteChannel)this.channel);
            } else {
                throw new IOException("not an output channel");
            }
        }
        this.writeBuffer.put((byte)(0xFF & x >> 24));
        this.writeBuffer.put((byte)(0xFF & x >> 16));
        this.writeBuffer.put((byte)(0xFF & x >> 8));
        this.writeBuffer.put((byte)(0xFF & x));
    }

    public int write(byte[] b, int start, int len) throws IOException {
        assert (b != null) : "null b";
        int rem = this.writeBuffer.limit() - this.writeBuffer.position();
        if (rem < len) {
            if (this.channel instanceof WritableByteChannel) {
                WritableByteChannel wbc = (WritableByteChannel)this.channel;
                Channel.writeBufferContents(this.writeBuffer, (WritableByteChannel)this.channel);
                return wbc.write(ByteBuffer.wrap(b, start, len));
            }
            throw new IOException("not an output channel");
        }
        this.writeBuffer.put(b, start, len);
        return len;
    }

    public int write(byte[] b) throws IOException {
        assert (b != null) : "null b";
        return this.write(b, 0, b.length);
    }

    public static void tryWrite(Channel ch, String s) {
        assert (s != null) : "null s";
        if (ch != null && ch.channel instanceof WritableByteChannel) {
            try {
                WritableByteChannel chan = (WritableByteChannel)ch.channel;
                if (ch.writeBuffer.position() > 0) {
                    chan.write(ch.writeBuffer);
                    ch.writeBuffer.clear();
                }
                chan.write(ByteBuffer.wrap(EncodingUtils.convertStringToBytes(s)));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void writeBufferContents(ByteBuffer b, WritableByteChannel wbc) throws IOException {
        assert (wbc != null) : "null wbc";
        assert (b != null) : "null b";
        if (b.position() > 0) {
            b.limit(b.position());
            b.position(0);
            wbc.write(b);
            b.clear();
        }
    }

    public void flush() throws IOException {
        if (this.channel instanceof WritableByteChannel) {
            Channel.writeBufferContents(this.writeBuffer, (WritableByteChannel)this.channel);
        }
        if (this.channel instanceof FileChannel) {
            ((FileChannel)this.channel).force(true);
        }
        if (this.channel instanceof AsynchronousFileChannel) {
            ((AsynchronousFileChannel)this.channel).force(true);
        }
    }

    public void configureBlocking(boolean block) throws IOException {
        if (this.channel instanceof SelectableChannel) {
            ((SelectableChannel)this.channel).configureBlocking(block);
        }
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public void bind(InetSocketAddress a) throws IOException {
        if (this.channel instanceof DatagramChannel) {
            this.bindAddress = a;
            ((DatagramChannel)this.channel).bind(a);
        } else if (this.channel instanceof SocketChannel || this.server != null) {
            this.bindAddress = a;
        } else {
            throw new IOException("not a socket");
        }
    }

    public void connect(InetSocketAddress a) throws IOException {
        assert (a != null) : "null a";
        if (this.channel instanceof SocketChannel) {
            SocketChannel s = (SocketChannel)this.channel;
            s.bind(this.bindAddress);
            s.connect(a);
            this.server = null;
        } else if (this.channel instanceof DatagramChannel) {
            ((DatagramChannel)this.channel).connect(a);
        } else {
            throw new IOException("not a socket");
        }
    }

    public void listen(int backlog) throws IOException {
        if (this.server == null) {
            throw new IOException("not a socket");
        }
        this.server.bind(this.bindAddress, backlog);
    }

    public void close() throws IOException {
        this.channel.close();
        if (this.server != null) {
            this.server.close();
        }
    }

    private static Set<OpenOption> openOptions(int flags) {
        HashSet<OpenOption> res = new HashSet<OpenOption>();
        if ((flags & 1) != 0) {
            res.add(StandardOpenOption.READ);
            res.add(StandardOpenOption.WRITE);
        } else {
            res.add(StandardOpenOption.READ);
        }
        if ((flags & 8) != 0) {
            res.add(StandardOpenOption.APPEND);
        }
        if ((flags & 0x200) != 0) {
            res.add(StandardOpenOption.CREATE);
        }
        if ((flags & 0x400) != 0) {
            res.add(StandardOpenOption.TRUNCATE_EXISTING);
        }
        return res;
    }

    private static boolean isEOL(int ch) {
        switch (ch) {
            case 10: {
                return true;
            }
            case 13: {
                return true;
            }
        }
        return false;
    }

    private static enum Kind {
        ORDINARY,
        STANDARD_INPUT,
        STANDARD_OUTPUT_OR_ERROR;

    }
}

