/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.AbstractCodeRunner;
import org.ocamljava.runtime.kernel.AtExit;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Debugger;
import org.ocamljava.runtime.kernel.Dispatcher;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.kernel.FatalErrorKind;
import org.ocamljava.runtime.kernel.Instructions;
import org.ocamljava.runtime.kernel.Interpreter;
import org.ocamljava.runtime.kernel.LocInfo;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.kernel.Signals;
import org.ocamljava.runtime.kernel.ValueStack;
import org.ocamljava.runtime.parameters.ByteCodeParameters;
import org.ocamljava.runtime.primitives.otherlibs.systhreads.ThreadStatus;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.Value;

public final class ByteCodeRunner
extends AbstractCodeRunner
implements Instructions {
    private final Interpreter interpreter;
    private ValueStack stack;
    private Value env;
    private Value result;
    private Throwable exception;
    private final List<Integer> backtraceBuffer;
    private Value backtraceLastException;
    private int savedPc;
    private int savedTrapSp;

    public ByteCodeRunner(Interpreter interp, Value status, boolean main) {
        super(interp.getContext());
        assert (interp != null) : "null interp";
        this.interpreter = interp;
        ByteCodeParameters params = (ByteCodeParameters)this.context.getParameters();
        this.stack = new ValueStack(main ? params.getInitStackSize() : params.getInitStackSize() / 4);
        this.threadStatus = status;
        this.env = null;
        this.backtraceBuffer = new LinkedList<Integer>();
        this.backtraceLastException = Value.UNIT;
    }

    @Override
    public void clearBacktraceInfo() {
        this.backtraceBuffer.clear();
    }

    @Override
    public CodeRunner createNewThread(Value status) {
        return new ByteCodeRunner(this.interpreter, status, false);
    }

    @Override
    public Value callback(Value closure, Value ... params) throws FailException, FatalError, OCamlJavaException, FalseExit {
        Throwable exn;
        assert (closure != null) : "null closure";
        assert (params != null) : "null params";
        assert (params.length + 4 <= 256) : "params is too long";
        Thread currentThread = Thread.currentThread();
        boolean isOCamlJavaThread = currentThread instanceof OCamlJavaThread;
        if (!isOCamlJavaThread) {
            this.context.getThreadsState().addAdditionalThread(currentThread);
        }
        ByteCodeRunner runner = new ByteCodeRunner(this.interpreter, null, false);
        runner.setup(closure, params);
        runner.run();
        if (!isOCamlJavaThread) {
            this.context.getThreadsState().removeAdditionalThread(currentThread);
        }
        if ((exn = runner.getException()) == null) {
            return runner.getResult();
        }
        if (exn instanceof FailException) {
            throw (FailException)exn;
        }
        if (exn instanceof FatalError) {
            throw (FatalError)exn;
        }
        if (runner.exception instanceof FalseExit) {
            AtExit.execute(this);
            throw (FalseExit)runner.exception;
        }
        Fatal.raise(FatalErrorKind.CALLBACK_ERROR, runner.exception.getMessage());
        return Value.UNIT;
    }

    public Interpreter getInterpreter() {
        return this.interpreter;
    }

    public ValueStack getStack() {
        return this.stack;
    }

    public void resizeStack(int requiredSize) throws FailException {
        ByteCodeParameters params = (ByteCodeParameters)this.context.getParameters();
        if (requiredSize > params.getMaxStackSize()) {
            Fail.raiseStackOverflow();
        }
        try {
            int currentSize = this.stack.maxSize();
            if (currentSize < requiredSize) {
                ValueStack newStack = new ValueStack(requiredSize);
                newStack.pushSlice(this.stack.popSlice(this.stack.size()));
                this.stack = newStack;
            }
        }
        catch (Throwable t) {
            Fail.raiseStackOverflow();
        }
    }

    public Value getEnv() {
        return this.env;
    }

    @Override
    public void run() {
        this.exception = null;
        this.result = null;
        try {
            CurrentContext.leaveBlockingSection();
        }
        catch (FailException | FalseExit fe) {
            return;
        }
        try {
            this.result = this.interprete(this.closure, this.args);
        }
        catch (Throwable t) {
            this.exception = t;
        }
        if (this.threadStatus != null) {
            ((ThreadStatus)this.threadStatus.get(2L).asCustom()).terminate();
        }
        CurrentContext.enterBlockingSection();
    }

    Throwable getException() {
        return this.exception;
    }

    public Value getResult() {
        return this.result;
    }

    public Value interprete(Value closure, Value ... args) throws FailException, FatalError, OCamlJavaException {
        int pc;
        Value accu = Value.UNIT;
        CodeState codeState = this.context.getCodeState();
        this.env = codeState.getAtom(0);
        int extraArgs = 0;
        int trapSp = -1;
        this.stack.pop(this.stack.size());
        if (closure != null) {
            this.stack.push(closure);
            this.stack.push(Value.ZERO);
            this.stack.push(Value.UNIT);
            this.stack.push(Value.createCodeOffset(codeState.getCallbackTail()));
            int nbArgs = args.length;
            for (int i = nbArgs - 1; i >= 0; --i) {
                this.stack.push(args[i]);
            }
            accu = this.stack.peek(nbArgs + 3);
            extraArgs = nbArgs - 1;
            pc = (int)accu.getCode();
            this.env = accu;
        } else {
            pc = 0;
        }
        try {
            Debugger.handleEvent(this, Debugger.EventKind.PROGRAM_START);
        }
        catch (FalseExit fe) {
            return Value.createLong(fe.getExitCode());
        }
        boolean restartCurrentInstruction = false;
        FailException exception = null;
        Value globalData = null;
        block169: while (true) {
            block219: {
                exception = null;
                int[] code = codeState.getCode();
                Dispatcher dispatcher = codeState.getDispatcher();
                globalData = codeState.getGlobalData();
                int currInstr = restartCurrentInstruction ? codeState.getSavedCode()[pc++] : code[pc++];
                restartCurrentInstruction = false;
                switch (currInstr) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        accu = this.stack.peek(currInstr - 0);
                        continue block169;
                    }
                    case 8: {
                        accu = this.stack.peek(code[pc++]);
                        continue block169;
                    }
                    case 9: 
                    case 10: {
                        this.stack.push(accu);
                        continue block169;
                    }
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: {
                        this.stack.push(accu);
                        accu = this.stack.peek(currInstr - 11 + 1);
                        continue block169;
                    }
                    case 18: {
                        this.stack.push(accu);
                        accu = this.stack.peek(code[pc++]);
                        continue block169;
                    }
                    case 19: {
                        this.stack.pop(code[pc++]);
                        continue block169;
                    }
                    case 20: {
                        this.stack.assign(code[pc++], accu);
                        accu = Value.UNIT;
                        continue block169;
                    }
                    case 21: {
                        accu = this.env.get1();
                        continue block169;
                    }
                    case 22: {
                        accu = this.env.get2();
                        continue block169;
                    }
                    case 23: {
                        accu = this.env.get3();
                        continue block169;
                    }
                    case 24: {
                        accu = this.env.get4();
                        continue block169;
                    }
                    case 25: {
                        accu = this.env.get(code[pc++]);
                        continue block169;
                    }
                    case 26: {
                        this.stack.push(accu);
                        accu = this.env.get1();
                        continue block169;
                    }
                    case 27: {
                        this.stack.push(accu);
                        accu = this.env.get2();
                        continue block169;
                    }
                    case 28: {
                        this.stack.push(accu);
                        accu = this.env.get3();
                        continue block169;
                    }
                    case 29: {
                        this.stack.push(accu);
                        accu = this.env.get4();
                        continue block169;
                    }
                    case 30: {
                        this.stack.push(accu);
                        accu = this.env.get(code[pc++]);
                        continue block169;
                    }
                    case 31: {
                        this.stack.push(Value.createLong(extraArgs));
                        this.stack.push(this.env);
                        this.stack.push(Value.createCodeOffset(pc + code[pc++]));
                        continue block169;
                    }
                    case 32: {
                        extraArgs = code[pc] - 1;
                        pc = (int)accu.getCode();
                        this.env = accu;
                        break;
                    }
                    case 33: {
                        this.stack.inject(1, Value.createLong(extraArgs), this.env, Value.createCodeOffset(pc));
                        pc = (int)accu.getCode();
                        this.env = accu;
                        extraArgs = 0;
                        break;
                    }
                    case 34: {
                        this.stack.inject(2, Value.createLong(extraArgs), this.env, Value.createCodeOffset(pc));
                        pc = (int)accu.getCode();
                        this.env = accu;
                        extraArgs = 1;
                        break;
                    }
                    case 35: {
                        this.stack.inject(3, Value.createLong(extraArgs), this.env, Value.createCodeOffset(pc));
                        pc = (int)accu.getCode();
                        this.env = accu;
                        extraArgs = 2;
                        break;
                    }
                    case 36: {
                        int nbArgs = code[pc++];
                        int slotSize = code[pc];
                        this.stack.slide(nbArgs, slotSize - nbArgs);
                        pc = (int)accu.getCode();
                        this.env = accu;
                        extraArgs += nbArgs - 1;
                        break;
                    }
                    case 37: {
                        this.stack.slide(1, code[pc] - 1);
                        pc = (int)accu.getCode();
                        this.env = accu;
                        break;
                    }
                    case 38: {
                        this.stack.slide(2, code[pc] - 2);
                        pc = (int)accu.getCode();
                        this.env = accu;
                        ++extraArgs;
                        break;
                    }
                    case 39: {
                        this.stack.slide(3, code[pc] - 3);
                        pc = (int)accu.getCode();
                        this.env = accu;
                        extraArgs += 2;
                        break;
                    }
                    case 40: {
                        this.stack.pop(code[pc]);
                        if (extraArgs > 0) {
                            --extraArgs;
                            pc = (int)accu.getCode();
                            this.env = accu;
                            continue block169;
                        }
                        pc = (int)this.stack.pop().asCodeOffset();
                        this.env = this.stack.pop();
                        extraArgs = this.stack.pop().asCastedInt();
                        continue block169;
                    }
                    case 41: {
                        int numArgs = (int)this.env.sizeValues() - 2;
                        for (int i = numArgs - 1; i >= 0; --i) {
                            this.stack.push(this.env.get(i + 2));
                        }
                        this.env = this.env.get1();
                        extraArgs += numArgs;
                        continue block169;
                    }
                    case 42: {
                        int i;
                        int required = code[pc++];
                        if (extraArgs >= required) {
                            extraArgs -= required;
                            continue block169;
                        }
                        int numArgs = 1 + extraArgs;
                        Value block = Value.createClosure(numArgs + 2);
                        block.set1(this.env);
                        for (i = 0; i < numArgs; ++i) {
                            block.set(i + 2, this.stack.pop());
                        }
                        block.setCode(pc - 3);
                        accu = block;
                        pc = (int)this.stack.pop().asCodeOffset();
                        this.env = this.stack.pop();
                        extraArgs = this.stack.pop().asCastedInt();
                        continue block169;
                    }
                    case 43: {
                        int nbVars = code[pc++];
                        if (nbVars > 0) {
                            this.stack.push(accu);
                        }
                        Value block = Value.createClosure(nbVars + 1);
                        block.setCode(pc + code[pc++]);
                        for (int i = 0; i < nbVars; ++i) {
                            block.set(i + 1, this.stack.pop());
                        }
                        accu = block;
                        continue block169;
                    }
                    case 44: {
                        Value block;
                        int i;
                        int nbFuncs = code[pc++];
                        int nbVars = code[pc++];
                        if (nbVars > 0) {
                            this.stack.push(accu);
                        }
                        accu = block = Value.createClosure(2 * nbFuncs - 1 + nbVars);
                        for (i = 0; i < nbVars; ++i) {
                            block.set(2 * nbFuncs - 1 + i, this.stack.pop());
                        }
                        block.setCode(pc + code[pc]);
                        this.stack.push(accu);
                        BlockValue parent = block.asBlock();
                        for (int i2 = 1; i2 < nbFuncs; ++i2) {
                            Value blk = Value.createInfix(i2 * 2);
                            blk.setCode(pc + code[pc + i2]);
                            blk.setParent(parent);
                            block.set(2 * i2 - 1, Value.createFromRawValue(blk.getHeader()));
                            Value v = blk;
                            block.set(2 * i2, v);
                            this.stack.push(v);
                        }
                        pc += nbFuncs;
                        continue block169;
                    }
                    case 45: {
                        accu = this.env.offset(-2L);
                        continue block169;
                    }
                    case 46: {
                        accu = this.env;
                        continue block169;
                    }
                    case 47: {
                        accu = this.env.offset(2L);
                        continue block169;
                    }
                    case 48: {
                        accu = this.env.offset(code[pc++]);
                        continue block169;
                    }
                    case 49: {
                        this.stack.push(accu);
                        accu = this.env.offset(-2L);
                        continue block169;
                    }
                    case 50: {
                        this.stack.push(accu);
                        accu = this.env;
                        continue block169;
                    }
                    case 51: {
                        this.stack.push(accu);
                        accu = this.env.offset(2L);
                        continue block169;
                    }
                    case 52: {
                        this.stack.push(accu);
                        accu = this.env.offset(code[pc++]);
                        continue block169;
                    }
                    case 53: {
                        accu = codeState.getGlobalData().get(code[pc++]);
                        continue block169;
                    }
                    case 54: {
                        this.stack.push(accu);
                        accu = codeState.getGlobalData().get(code[pc++]);
                        continue block169;
                    }
                    case 55: {
                        accu = codeState.getGlobalData().get(code[pc++]);
                        accu = accu.get(code[pc++]);
                        continue block169;
                    }
                    case 56: {
                        this.stack.push(accu);
                        accu = codeState.getGlobalData().get(code[pc++]);
                        accu = accu.get(code[pc++]);
                        continue block169;
                    }
                    case 57: {
                        codeState.getGlobalData().set(code[pc++], accu);
                        accu = Value.UNIT;
                        continue block169;
                    }
                    case 58: {
                        accu = codeState.getAtom(0);
                        continue block169;
                    }
                    case 59: {
                        accu = codeState.getAtom(code[pc++]);
                        continue block169;
                    }
                    case 60: {
                        this.stack.push(accu);
                        accu = codeState.getAtom(0);
                        continue block169;
                    }
                    case 61: {
                        this.stack.push(accu);
                        accu = codeState.getAtom(code[pc++]);
                        continue block169;
                    }
                    case 62: {
                        int i;
                        int blSize = code[pc++];
                        int blTag = code[pc++];
                        Value bl = Value.createBlock(blTag, blSize);
                        bl.set0(accu);
                        for (i = 1; i < blSize; ++i) {
                            bl.set(i, this.stack.pop());
                        }
                        accu = bl;
                        continue block169;
                    }
                    case 63: {
                        int blTag = code[pc++];
                        accu = Value.createBlock(blTag, accu);
                        continue block169;
                    }
                    case 64: {
                        int blTag = code[pc++];
                        Value v1 = this.stack.pop();
                        accu = Value.createBlock(blTag, accu, v1);
                        continue block169;
                    }
                    case 65: {
                        int blTag = code[pc++];
                        Value v1 = this.stack.pop();
                        Value v2 = this.stack.pop();
                        accu = Value.createBlock(blTag, accu, v1, v2);
                        continue block169;
                    }
                    case 66: {
                        int dblArraySize = code[pc++];
                        Value dblArray = Value.createDoubleArray(dblArraySize);
                        dblArray.setDouble0(accu.asDouble());
                        for (int i = 1; i < dblArraySize; ++i) {
                            dblArray.setDouble(i, this.stack.pop().asDouble());
                        }
                        accu = dblArray;
                        continue block169;
                    }
                    case 67: {
                        accu = accu.get0();
                        continue block169;
                    }
                    case 68: {
                        accu = accu.get1();
                        continue block169;
                    }
                    case 69: {
                        accu = accu.get2();
                        continue block169;
                    }
                    case 70: {
                        accu = accu.get3();
                        continue block169;
                    }
                    case 71: {
                        accu = accu.get(code[pc++]);
                        continue block169;
                    }
                    case 72: {
                        accu = Value.createDouble(accu.isDoubleArray() ? accu.getDouble(code[pc++]) : accu.get(code[pc++]).asDouble());
                        continue block169;
                    }
                    case 73: {
                        accu.set0(this.stack.pop());
                        accu = Value.UNIT;
                        continue block169;
                    }
                    case 74: {
                        accu.set1(this.stack.pop());
                        accu = Value.UNIT;
                        continue block169;
                    }
                    case 75: {
                        accu.set2(this.stack.pop());
                        accu = Value.UNIT;
                        continue block169;
                    }
                    case 76: {
                        accu.set3(this.stack.pop());
                        accu = Value.UNIT;
                        continue block169;
                    }
                    case 77: {
                        accu.set(code[pc++], this.stack.pop());
                        accu = Value.UNIT;
                        continue block169;
                    }
                    case 78: {
                        double dbl = this.stack.pop().asDouble();
                        if (accu.isDoubleArray()) {
                            accu.setDouble(code[pc++], dbl);
                        } else {
                            accu.set(code[pc++], Value.createDouble(dbl));
                        }
                        accu = Value.UNIT;
                        continue block169;
                    }
                    case 79: {
                        accu = Value.createLong(accu.arrayLength());
                        continue block169;
                    }
                    case 80: {
                        accu = accu.get(this.stack.pop().asLong());
                        continue block169;
                    }
                    case 81: {
                        long vectIdx = this.stack.pop().asLong();
                        Value vectVal = this.stack.pop();
                        accu.set(vectIdx, vectVal);
                        accu = Value.UNIT;
                        continue block169;
                    }
                    case 82: {
                        accu = Value.createLong(accu.getUnsignedByte(this.stack.pop().asLong()));
                        continue block169;
                    }
                    case 83: {
                        long charIdx = this.stack.pop().asLong();
                        int charVal = this.stack.pop().asCastedInt();
                        accu.setUnsignedByte(charIdx, charVal);
                        accu = Value.UNIT;
                        continue block169;
                    }
                    case 84: {
                        pc += code[pc];
                        continue block169;
                    }
                    case 85: {
                        if (accu != Value.FALSE) {
                            pc += code[pc];
                            continue block169;
                        }
                        ++pc;
                        continue block169;
                    }
                    case 86: {
                        if (accu == Value.FALSE) {
                            pc += code[pc];
                            continue block169;
                        }
                        ++pc;
                        continue block169;
                    }
                    case 87: {
                        long sizes = IntegerUtils.signedToUnsigned(code[pc++]);
                        int szTag = (int)(sizes >> 16);
                        int szInt = (int)(sizes & 0xFFFFL);
                        if (accu.isBlock()) {
                            int index = accu.getTag();
                            assert (index >= 0 && index < szTag) : "invalid switch index";
                            pc += code[pc + szInt + index];
                            continue block169;
                        }
                        int index = accu.asCastedInt();
                        assert (IntegerUtils.signedToUnsigned(index) < (long)szInt) : "invalid switch index";
                        pc += code[pc + index];
                        continue block169;
                    }
                    case 88: {
                        accu = accu == Value.FALSE ? Value.TRUE : Value.FALSE;
                        continue block169;
                    }
                    case 89: {
                        this.stack.push(Value.createLong(extraArgs));
                        this.stack.push(this.env);
                        this.stack.push(Value.createLong(trapSp));
                        this.stack.push(Value.createCodeOffset(pc + code[pc]));
                        trapSp = this.stack.size();
                        ++pc;
                        continue block169;
                    }
                    case 90: {
                        boolean signal2;
                        try {
                            signal2 = Signals.processSignal(this);
                        }
                        catch (FalseExit fe) {
                            return Value.createLong(fe.getExitCode());
                        }
                        catch (FailException fe) {
                            boolean signal2 = true;
                            exception = fe;
                            --pc;
                            break block219;
                        }
                        if (signal2) {
                            --pc;
                            continue block169;
                        }
                        this.stack.pop();
                        trapSp = this.stack.pop().asCastedInt();
                        this.stack.pop(2);
                        continue block169;
                    }
                    case 91: {
                        if (trapSp <= this.context.getDebuggerState().getDebuggerTrapBarrier()) {
                            try {
                                Debugger.handleEvent(this, Debugger.EventKind.TRAP_BARRIER);
                            }
                            catch (FalseExit fe) {
                                return Value.createLong(fe.getExitCode());
                            }
                        }
                        if (codeState.isBacktraceActive()) {
                            this.stashBacktrace(accu, pc, trapSp);
                        }
                        if (trapSp == -1) {
                            if (this.context.getDebuggerState().isDebuggerInUse()) {
                                this.stack.push(accu);
                            }
                            Fail.raise(accu);
                        }
                        this.stack.pop(this.stack.size() - trapSp);
                        pc = (int)this.stack.pop().asCodeOffset();
                        trapSp = this.stack.pop().asCastedInt();
                        this.env = this.stack.pop();
                        extraArgs = this.stack.pop().asCastedInt();
                        continue block169;
                    }
                    case 92: {
                        break;
                    }
                    case 93: {
                        this.savedPc = pc;
                        this.savedTrapSp = trapSp;
                        this.stack.push(this.env);
                        int primitive = code[pc++];
                        try {
                            accu = dispatcher.invoke(primitive, accu);
                            this.env = this.stack.pop();
                            continue block169;
                        }
                        catch (FailException fail) {
                            exception = fail;
                            break block219;
                        }
                        catch (FalseExit sfe) {
                            return accu;
                        }
                    }
                    case 94: {
                        this.savedPc = pc;
                        this.savedTrapSp = trapSp;
                        this.stack.push(this.env);
                        int primitive = code[pc++];
                        try {
                            accu = dispatcher.invoke(primitive, accu, this.stack.peek(1));
                            this.env = this.stack.pop();
                            this.stack.pop(1);
                            continue block169;
                        }
                        catch (FailException fail) {
                            exception = fail;
                            break block219;
                        }
                        catch (FalseExit sfe) {
                            return accu;
                        }
                    }
                    case 95: {
                        this.savedPc = pc;
                        this.savedTrapSp = trapSp;
                        this.stack.push(this.env);
                        int primitive = code[pc++];
                        try {
                            accu = dispatcher.invoke(primitive, accu, this.stack.peek(1), this.stack.peek(2));
                            this.env = this.stack.pop();
                            this.stack.pop(2);
                            continue block169;
                        }
                        catch (FailException fail) {
                            exception = fail;
                            break block219;
                        }
                        catch (FalseExit sfe) {
                            return accu;
                        }
                    }
                    case 96: {
                        this.savedPc = pc;
                        this.savedTrapSp = trapSp;
                        this.stack.push(this.env);
                        int primitive = code[pc++];
                        try {
                            accu = dispatcher.invoke(primitive, accu, this.stack.peek(1), this.stack.peek(2), this.stack.peek(3));
                            this.env = this.stack.pop();
                            this.stack.pop(3);
                            continue block169;
                        }
                        catch (FailException fail) {
                            exception = fail;
                            break block219;
                        }
                        catch (FalseExit sfe) {
                            return accu;
                        }
                    }
                    case 97: {
                        this.savedPc = pc;
                        this.savedTrapSp = trapSp;
                        this.stack.push(this.env);
                        int primitive = code[pc++];
                        try {
                            accu = dispatcher.invoke(primitive, accu, this.stack.peek(1), this.stack.peek(2), this.stack.peek(3), this.stack.peek(4));
                            this.env = this.stack.pop();
                            this.stack.pop(4);
                            continue block169;
                        }
                        catch (FailException fail) {
                            exception = fail;
                            break block219;
                        }
                        catch (FalseExit sfe) {
                            return accu;
                        }
                    }
                    case 98: {
                        this.savedPc = pc;
                        this.savedTrapSp = trapSp;
                        int nbArgs = code[pc++];
                        this.stack.push(accu);
                        this.stack.push(this.env);
                        int primitive = code[pc++];
                        Value[] params = new Value[nbArgs];
                        for (int i = 0; i < nbArgs; ++i) {
                            params[i] = this.stack.peek(i + 1);
                        }
                        try {
                            accu = dispatcher.invoke(primitive, params);
                            this.env = this.stack.pop();
                            this.stack.pop(nbArgs);
                            continue block169;
                        }
                        catch (FailException fail) {
                            exception = fail;
                            break block219;
                        }
                        catch (FalseExit sfe) {
                            return accu;
                        }
                    }
                    case 99: {
                        accu = Value.ZERO;
                        continue block169;
                    }
                    case 100: {
                        accu = Value.ONE;
                        continue block169;
                    }
                    case 101: {
                        accu = Value.TWO;
                        continue block169;
                    }
                    case 102: {
                        accu = Value.THREE;
                        continue block169;
                    }
                    case 103: {
                        accu = Value.createLong(code[pc++]);
                        continue block169;
                    }
                    case 104: {
                        this.stack.push(accu);
                        accu = Value.ZERO;
                        continue block169;
                    }
                    case 105: {
                        this.stack.push(accu);
                        accu = Value.ONE;
                        continue block169;
                    }
                    case 106: {
                        this.stack.push(accu);
                        accu = Value.TWO;
                        continue block169;
                    }
                    case 107: {
                        this.stack.push(accu);
                        accu = Value.THREE;
                        continue block169;
                    }
                    case 108: {
                        this.stack.push(accu);
                        accu = Value.createLong(code[pc++]);
                        continue block169;
                    }
                    case 109: {
                        accu = Value.createFromRawValue(2L - accu.getRawValue());
                        continue block169;
                    }
                    case 110: {
                        accu = Value.createFromRawValue(accu.getRawValue() + this.stack.pop().getRawValue() - 1L);
                        continue block169;
                    }
                    case 111: {
                        accu = Value.createFromRawValue(accu.getRawValue() - this.stack.pop().getRawValue() + 1L);
                        continue block169;
                    }
                    case 112: {
                        accu = Value.createLong(accu.asLong() * this.stack.pop().asLong());
                        continue block169;
                    }
                    case 113: {
                        long div = this.stack.pop().asLong();
                        if (div != 0L) {
                            accu = Value.createLong(accu.asLong() / div);
                            continue block169;
                        }
                        exception = Fail.createZeroDivide();
                        break block219;
                    }
                    case 114: {
                        long div = this.stack.pop().asLong();
                        if (div != 0L) {
                            accu = Value.createLong(accu.asLong() % div);
                            continue block169;
                        }
                        exception = Fail.createZeroDivide();
                        break block219;
                    }
                    case 115: {
                        accu = Value.createFromRawValue(accu.getRawValue() & this.stack.pop().getRawValue());
                        continue block169;
                    }
                    case 116: {
                        accu = Value.createFromRawValue(accu.getRawValue() | this.stack.pop().getRawValue());
                        continue block169;
                    }
                    case 117: {
                        accu = Value.createFromRawValue(accu.getRawValue() ^ this.stack.pop().getRawValue() | 1L);
                        continue block169;
                    }
                    case 118: {
                        accu = Value.createFromRawValue((accu.getRawValue() - 1L << (int)this.stack.pop().asLong()) + 1L);
                        continue block169;
                    }
                    case 119: {
                        accu = Value.createFromRawValue(accu.getRawValue() - 1L >>> (int)this.stack.pop().asLong() | 1L);
                        continue block169;
                    }
                    case 120: {
                        accu = Value.createFromRawValue(accu.getRawValue() - 1L >> (int)this.stack.pop().asLong() | 1L);
                        continue block169;
                    }
                    case 121: {
                        accu = Value.compare(accu, this.stack.pop()) == 0 ? Value.TRUE : Value.FALSE;
                        continue block169;
                    }
                    case 122: {
                        accu = Value.compare(accu, this.stack.pop()) != 0 ? Value.TRUE : Value.FALSE;
                        continue block169;
                    }
                    case 123: {
                        accu = Value.compare(accu, this.stack.pop()) < 0 ? Value.TRUE : Value.FALSE;
                        continue block169;
                    }
                    case 124: {
                        accu = Value.compare(accu, this.stack.pop()) <= 0 ? Value.TRUE : Value.FALSE;
                        continue block169;
                    }
                    case 125: {
                        accu = Value.compare(accu, this.stack.pop()) > 0 ? Value.TRUE : Value.FALSE;
                        continue block169;
                    }
                    case 126: {
                        accu = Value.compare(accu, this.stack.pop()) >= 0 ? Value.TRUE : Value.FALSE;
                        continue block169;
                    }
                    case 127: {
                        accu = Value.createFromRawValue(accu.getRawValue() + (long)(code[pc++] << 1));
                        continue block169;
                    }
                    case 128: {
                        long tmpOfs = accu.get0().getRawValue();
                        accu.set0(Value.createFromRawValue(tmpOfs + (long)(code[pc++] << 1)));
                        accu = Value.UNIT;
                        continue block169;
                    }
                    case 129: {
                        accu = accu.isLong() ? Value.TRUE : Value.FALSE;
                        continue block169;
                    }
                    case 130: {
                        accu = this.stack.peek(0).get0().get(accu.asLong());
                        continue block169;
                    }
                    case 131: {
                        int c = code[pc++];
                        if (Value.compare(Value.createLong(c), accu) == 0) {
                            pc += code[pc];
                            continue block169;
                        }
                        ++pc;
                        continue block169;
                    }
                    case 132: {
                        int c = code[pc++];
                        if (Value.compare(Value.createLong(c), accu) != 0) {
                            pc += code[pc];
                            continue block169;
                        }
                        ++pc;
                        continue block169;
                    }
                    case 133: {
                        Value c = Value.createLong(code[pc++]);
                        if (Value.compare(c, accu) < 0) {
                            pc += code[pc];
                            continue block169;
                        }
                        ++pc;
                        continue block169;
                    }
                    case 134: {
                        Value c = Value.createLong(code[pc++]);
                        if (Value.compare(c, accu) <= 0) {
                            pc += code[pc];
                            continue block169;
                        }
                        ++pc;
                        continue block169;
                    }
                    case 135: {
                        Value c = Value.createLong(code[pc++]);
                        if (Value.compare(c, accu) > 0) {
                            pc += code[pc];
                            continue block169;
                        }
                        ++pc;
                        continue block169;
                    }
                    case 136: {
                        Value c = Value.createLong(code[pc++]);
                        if (Value.compare(c, accu) >= 0) {
                            pc += code[pc];
                            continue block169;
                        }
                        ++pc;
                        continue block169;
                    }
                    case 137: {
                        if (Value.compareUnsigned(accu, this.stack.pop()) < 0) {
                            accu = Value.TRUE;
                            continue block169;
                        }
                        accu = Value.FALSE;
                        continue block169;
                    }
                    case 138: {
                        if (Value.compareUnsigned(accu, this.stack.pop()) >= 0) {
                            accu = Value.TRUE;
                            continue block169;
                        }
                        accu = Value.FALSE;
                        continue block169;
                    }
                    case 139: {
                        Value c = Value.createLong(code[pc++]);
                        if (Value.compareUnsigned(c, accu) < 0) {
                            pc += code[pc];
                            continue block169;
                        }
                        ++pc;
                        continue block169;
                    }
                    case 140: {
                        Value c = Value.createLong(code[pc++]);
                        if (Value.compareUnsigned(c, accu) >= 0) {
                            pc += code[pc];
                            continue block169;
                        }
                        ++pc;
                        continue block169;
                    }
                    case 141: {
                        Value meths = accu.get0();
                        this.stack.push(accu);
                        accu = Value.createLong(code[pc++]);
                        long ofs = ((long)code[pc] & meths.get1().getRawValue()) >> 2;
                        long tag = accu.getRawValue();
                        if (meths.get(3L + ofs).getRawValue() == tag) {
                            accu = meths.get(2L + ofs);
                        } else {
                            long li = 3L;
                            long hi = meths.get0().getRawValue();
                            while (li < hi) {
                                long mi = li + hi >> 1 | 1L;
                                if (tag < meths.get(mi).getRawValue()) {
                                    hi = mi - 2L;
                                    continue;
                                }
                                li = mi;
                            }
                            code[pc] = (int)(li - 3L);
                            accu = meths.get(li - 1L);
                        }
                        ++pc;
                        continue block169;
                    }
                    case 142: {
                        accu = ByteCodeRunner.getMethod(this.stack.peek(0), accu.getRawValue());
                        continue block169;
                    }
                    case 143: {
                        return accu;
                    }
                    case 144: {
                        if (this.context.getDebuggerState().decrementDebuggerEventCount()) {
                            this.stack.push(Value.createLong(extraArgs));
                            this.stack.push(this.env);
                            this.stack.push(Value.createCodeOffset(pc - 1));
                            this.stack.push(accu);
                            try {
                                Debugger.handleEvent(this, Debugger.EventKind.EVENT_COUNT);
                            }
                            catch (FalseExit fe) {
                                return Value.createLong(fe.getExitCode());
                            }
                            this.stack.pop(4);
                        }
                        --pc;
                        restartCurrentInstruction = true;
                        continue block169;
                    }
                    case 145: {
                        this.stack.push(Value.createLong(extraArgs));
                        this.stack.push(this.env);
                        this.stack.push(Value.createCodeOffset(pc - 1));
                        this.stack.push(accu);
                        try {
                            Debugger.handleEvent(this, Debugger.EventKind.BREAKPOINT);
                        }
                        catch (FalseExit fe) {
                            return Value.createLong(fe.getExitCode());
                        }
                        this.stack.pop(4);
                        --pc;
                        restartCurrentInstruction = true;
                        continue block169;
                    }
                    default: {
                        Fatal.raise(FatalErrorKind.INVALID_BYTECODE, Integer.toString(currInstr));
                        continue block169;
                    }
                }
                if (Thread.interrupted()) {
                    Exception e = this.context.getSignalsState().getAndClearAsyncException();
                    if (e == null || e instanceof FalseExit) {
                        return accu;
                    }
                    exception = (FailException)e;
                } else {
                    try {
                        Signals.processSignal(this);
                    }
                    catch (FalseExit fe) {
                        return Value.createLong(fe.getExitCode());
                    }
                    catch (FailException fe) {
                        exception = fe;
                    }
                }
                try {
                    CurrentContext.getFinalizersState().runFinalizers();
                }
                catch (FalseExit fe) {
                    return Value.createLong(fe.getExitCode());
                }
            }
            accu = exception.getValue();
            if (codeState.isBacktraceActive()) {
                this.stashBacktrace(accu, pc, trapSp);
            }
            if (trapSp == -1) {
                if (this.context.getDebuggerState().isDebuggerInUse()) {
                    this.stack.push(accu);
                }
                Fail.raise(accu);
            }
            this.stack.pop(this.stack.size() - trapSp);
            pc = (int)this.stack.pop().asCodeOffset();
            trapSp = this.stack.pop().asCastedInt();
            this.env = this.stack.pop();
            extraArgs = this.stack.pop().asCastedInt();
        }
    }

    private static Value eventForLocation(Value events, int pc) {
        Value bestEv = null;
        int pos = pc * 4;
        long sz = events.sizeValues();
        for (long i = 0L; i < sz; ++i) {
            for (Value l = events.get(i); l != Value.EMPTY_LIST; l = l.get1()) {
                Value ev = l.get0();
                int evPos = ev.get(0L).asCastedInt();
                if (evPos == pos) {
                    return ev;
                }
                if (evPos != pos + 8) continue;
                bestEv = ev;
            }
        }
        return bestEv != null ? bestEv : Value.FALSE;
    }

    private LocInfo extractLocationInfo(Value events, int pc) {
        boolean isRaise;
        Value ev = ByteCodeRunner.eventForLocation(events, pc);
        boolean bl = isRaise = pc != -1 && this.context.getCodeState().getCode()[pc] == 91;
        if (ev == Value.FALSE) {
            return new LocInfo(false, isRaise, "", 0, 0, 0);
        }
        Value evStart = ev.get(2L).get(0L);
        int bol = evStart.get(2L).asCastedInt();
        int cnum = evStart.get(3L).asCastedInt();
        return new LocInfo(true, isRaise, evStart.get(0L).asString(), evStart.get(1L).asCastedInt(), cnum - bol, ev.get(2L).get(1L).get(3L).asCastedInt() - bol);
    }

    private void printLocation(PrintStream err, LocInfo li, int index) {
        assert (err != null) : "null err";
        assert (li != null) : "null li";
        if (!li.valid && li.isRaise) {
            return;
        }
        String info = li.isRaise ? (index == 0 ? "Raised at" : "Re-raised at") : (index == 0 ? "Raised by primitive operation at" : "Called from");
        if (!li.valid) {
            err.printf("%s unkown location\n", info);
        } else {
            err.printf("%s file \"%s\", line %d, characters %d-%d\n", info, li.filename, li.lnum, li.startChr, li.endChr);
        }
    }

    @Override
    public void printExceptionBacktrace(PrintStream err) {
        assert (err != null) : "null err";
        Value events = this.context.getCodeState().getDebugInfo();
        if (events == Value.ZERO) {
            err.println("(Program not linked with -g, cannot print stack backtrace)");
        } else {
            int sz = this.backtraceBuffer.size();
            for (int i = 0; i < sz; ++i) {
                LocInfo li = this.extractLocationInfo(events, this.backtraceBuffer.get(i));
                this.printLocation(err, li, i);
            }
        }
    }

    private Value convertBacktrace(List<Integer> buffer) {
        Value events = this.context.getCodeState().getDebugInfo();
        if (events == Value.FALSE) {
            return Value.ZERO;
        }
        int sz = buffer.size();
        Value arr = Value.createBlock(0, sz);
        for (int i = 0; i < sz; ++i) {
            LocInfo li = this.extractLocationInfo(events, buffer.get(i));
            Value p = li.valid ? Value.createBlock(0, li.isRaise ? Value.TRUE : Value.FALSE, Value.createString(li.filename), Value.createLong(li.lnum), Value.createLong(li.startChr), Value.createLong(li.endChr)) : Value.createBlock(1, li.isRaise ? Value.TRUE : Value.FALSE);
            arr.set(i, p);
        }
        return Value.createBlock(0, arr);
    }

    @Override
    public Value getExceptionRawBacktrace() {
        return this.convertBacktrace(this.backtraceBuffer);
    }

    @Override
    public Value getCurrentCallStack(int n) {
        LinkedList<Integer> buffer = new LinkedList<Integer>();
        try {
            this.stashBacktrace(buffer, this.savedPc, this.savedTrapSp, n);
        }
        catch (FatalError fatalError) {
            // empty catch block
        }
        return this.convertBacktrace(buffer);
    }

    private void stashBacktrace(Value exception, int currentPC, int trapSp) throws FatalError {
        if (exception != this.backtraceLastException) {
            this.backtraceBuffer.clear();
            this.backtraceLastException = exception;
            this.stashBacktrace(this.backtraceBuffer, currentPC, trapSp, 1024);
        }
    }

    private void stashBacktrace(List<Integer> backtraceBuffer, int currentPC, int trapSp, int max) throws FatalError {
        int pc = currentPC;
        if (pc >= 0 && pc < this.context.getCodeState().getCode().length) {
            this.backtraceBuffer.add(pc - 1);
        }
        while (this.stack.size() > 0 && this.stack.size() > trapSp && this.backtraceBuffer.size() <= max) {
            Value v = this.stack.pop();
            if (!v.isCodeOffset()) continue;
            this.backtraceBuffer.add((int)v.asCodeOffset());
        }
    }
}

