/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.context;

import java.util.HashSet;
import java.util.Set;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.kernel.ThreadLocalFactory;

public final class ThreadsState {
    private CodeRunner mainCodeRunner = null;
    private OCamlJavaThread mainThread = null;
    private final ThreadGroup threadGroup;
    private final Set<Thread> additThreads;

    ThreadsState(boolean isNative) {
        this.threadGroup = new ThreadGroup(OCamlJavaThread.getNextThreadGroupName(isNative));
        this.additThreads = new HashSet<Thread>();
    }

    public CodeRunner getMainCodeRunner() {
        return this.mainCodeRunner;
    }

    public void setMainCodeRunner(CodeRunner cr) {
        assert (cr != null) : "null cr";
        this.mainCodeRunner = cr;
    }

    public OCamlJavaThread getMainThread() {
        return this.mainThread;
    }

    public void setMainThread(OCamlJavaThread ct) {
        assert (ct != null) : "null ct";
        this.mainThread = ct;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAdditionalThread(Thread t) {
        assert (t != null) : "null t";
        Set<Thread> set = this.additThreads;
        synchronized (set) {
            this.additThreads.add(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAdditionalThread(Thread t) {
        assert (t != null) : "null t";
        Set<Thread> set = this.additThreads;
        synchronized (set) {
            this.additThreads.remove(t);
        }
        if (t == Thread.currentThread()) {
            ThreadLocalFactory.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptAdditionalThreads() {
        Set<Thread> set = this.additThreads;
        synchronized (set) {
            for (Thread t : this.additThreads) {
                t.interrupt();
            }
            this.additThreads.clear();
        }
    }
}

