/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.context;

import java.util.Iterator;
import org.ocamljava.runtime.kernel.Channel;

final class ChannelMap {
    private static final int SIZE = 256;
    private Channel[] channels = new Channel[256];

    public void put(int k, Channel v) {
        int len = this.channels.length;
        if (k < len) {
            this.channels[k] = v;
        } else {
            int newLen = k + 1;
            Channel[] newArray = new Channel[newLen];
            System.arraycopy(this.channels, 0, newArray, 0, len);
            newArray[k] = v;
            this.channels = newArray;
        }
    }

    public Channel remove(int k) {
        Channel res = this.channels[k];
        this.channels[k] = null;
        return res;
    }

    public Channel get(int k) {
        return this.channels[k];
    }

    public int firstAvailableKey() {
        int i;
        int len = this.channels.length;
        for (i = 0; i < len && this.channels[i] != null; ++i) {
        }
        return i;
    }

    public Iterator<Channel> valueIterator() {
        return new ChannelIterator(this.channels);
    }

    private static final class ChannelIterator
    implements Iterator<Channel> {
        private final Channel[] array;
        private final int length;
        private int lastReturned;
        private int nextElement;

        private ChannelIterator(Channel[] a) {
            assert (a != null) : "null a";
            this.array = a;
            this.length = a.length;
            this.lastReturned = -1;
            this.nextElement = this.computeNextElement(0);
        }

        @Override
        public boolean hasNext() {
            return this.nextElement < this.length;
        }

        @Override
        public Channel next() {
            Channel res = this.array[this.nextElement];
            this.lastReturned = this.nextElement;
            this.nextElement = this.computeNextElement(this.nextElement + 1);
            return res;
        }

        @Override
        public void remove() {
            this.array[this.lastReturned] = null;
        }

        private int computeNextElement(int start) {
            int idx;
            for (idx = start; idx < this.length && this.array[idx] == null; ++idx) {
            }
            return idx;
        }
    }
}

