/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.annotations.parameters;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.ocamljava.runtime.annotations.parameters.BooleanParameter;
import org.ocamljava.runtime.annotations.parameters.IntegerParameter;
import org.ocamljava.runtime.annotations.parameters.StringParameter;
import org.ocamljava.runtime.kernel.ParameterException;
import org.ocamljava.runtime.parameters.ByteCodeParameters;

final class ParameterComponents {
    private ParameterComponents() {
    }

    static JComponent createComponent(Method m, ByteCodeParameters bcp) throws ParameterException {
        assert (m != null) : "null m";
        assert (bcp != null) : "null bcp";
        Object value = null;
        try {
            value = m.invoke((Object)bcp, new Object[0]);
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException ite) {
            // empty catch block
        }
        BooleanParameter bp = m.getAnnotation(BooleanParameter.class);
        if (bp != null) {
            JComboBox<String> res = new JComboBox<String>(bp.guiStrings());
            if (value != null) {
                res.setSelectedIndex((Boolean)value != false ? 1 : 0);
            } else {
                res.setSelectedIndex(bp.defaultValue() ? 1 : 0);
            }
            return res;
        }
        IntegerParameter ip = m.getAnnotation(IntegerParameter.class);
        if (ip != null) {
            SpinnerNumberModel mdl = new SpinnerNumberModel(value != null ? ((Integer)value).intValue() : ip.defaultValue(), ip.minValue(), ip.maxValue(), 1);
            JSpinner res = new JSpinner(mdl);
            return res;
        }
        StringParameter sp = m.getAnnotation(StringParameter.class);
        if (sp != null) {
            String[] possibleValues = sp.possibleValues();
            if (possibleValues.length == 0) {
                return new JTextField(value != null ? (String)value : sp.defaultValue());
            }
            JComboBox<String> res = new JComboBox<String>(possibleValues);
            res.setSelectedItem(value != null ? (String)value : sp.defaultValue());
            return res;
        }
        throw new ParameterException("unsuppoted parameter");
    }

    static Object readComponentValue(Method m, JComponent comp) throws ParameterException {
        assert (m != null) : "null m";
        assert (comp != null) : "null comp";
        BooleanParameter bp = m.getAnnotation(BooleanParameter.class);
        if (bp != null) {
            return ((JComboBox)comp).getSelectedIndex() == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        IntegerParameter ip = m.getAnnotation(IntegerParameter.class);
        if (ip != null) {
            return ((JSpinner)comp).getValue();
        }
        StringParameter sp = m.getAnnotation(StringParameter.class);
        if (sp != null) {
            if (sp.possibleValues().length == 0) {
                return ((JTextField)comp).getText();
            }
            return ((JComboBox)comp).getSelectedItem();
        }
        throw new ParameterException("unsuppoted parameter");
    }
}

