#FLM: Make Text Font (SMuFL 1.12)
import time
import os

def format_codepoint(dec_codepoint):
    if (dec_codepoint > 0x10000):
        return "u"+hex(dec_codepoint).upper()[2:]
    else:
        return "uni"+hex(dec_codepoint).upper()[2:]


base_font_name = fl.font.family_name.split()[0]

new_filename = os.path.join(os.path.dirname(fl.font.file_name), 
    base_font_name + 'Text.vfb') 
    
fl.Save(new_filename)
fl.Close(0)
fl.Open(new_filename)

# Append text to the font family names
fl.font.family_name = base_font_name + " Text"
fl.font.font_name   = base_font_name + "Text"
fl.font.full_name   = base_font_name + " Text"
fl.font.menu_name   = base_font_name + " Text"
fl.font.apple_name  = base_font_name + " Text"

# Names and Copyright -> OpenType specific names
fl.font.pref_family_name = base_font_name + " Text"
fl.font.mac_compatible   = base_font_name + "Text"

# Version and identification => Identification settings
if fl.font.tt_u_id is not None:
    fl.font.tt_u_id = fl.font.tt_u_id.replace(base_font_name, base_font_name + " Text")

# Names and Copyright -> Additional OpenType names: click import names
for fn in fl.font.fontnames:
    if fn.nid == 1 or (fn.nid == 4 and fn.pid == 1):
        fn.name = base_font_name + " Text"
    elif fn.nid == 6 or fn.nid == 18 or (fn.nid == 4 and fn.pid == 3):
        fn.name = base_font_name + "Text"
    elif fn.nid == 3:
        fn.name = fn.name.replace(base_font_name, base_font_name + " Text")

fl.font.ascender[0]   = 800
fl.font.descender[0]  = -200
fl.font.cap_height[0] = 720
fl.font.x_height[0]   = 470

fl.font.ttinfo.os2_s_typo_ascender  = 800
fl.font.ttinfo.os2_s_typo_descender = -200
fl.font.ttinfo.os2_s_typo_line_gap  = 200
fl.font.ttinfo.os2_us_win_ascent    = 1130
fl.font.ttinfo.os2_us_win_descent   = 330

fl.font.ttinfo.hhea_ascender   = 1130
fl.font.ttinfo.hhea_descender  = -330
fl.font.ttinfo.hhea_line_gap   = 0

# These arrays will be populated by SMuFL admin with the decimal unicode codepoints of the glyphs in each of these classes
zero_width_glyphs = [57360, 57361, 57362, 57363, 57364, 57365, 57366, 57367, 57368, 57369, 57370, 57371, 57372, 57373, 57374, 57375, 57376, 57377, 57378, 57379, 57380, 57472, 62789, 62790, 57473, 62791, 62792, 62850, 57474, 62793, 62794, 62838, 62839, 62840, 57475, 62795, 62796, 62841, 62842, 57476, 62797, 62798, 62843, 62844, 62846, 57477, 62799, 62800, 62845, 57478, 62801, 62802, 62847, 57479, 62803, 62804, 62848, 57480, 62805, 62806, 62849, 57481, 62807, 62808, 59251, 59255, 59259, 59263, 59267, 59271, 59275, 59279, 59283, 59287, 59301, 59305, 59309, 59313, 59318, 59322, 59326, 59330, 59334, 59338, 59369, 59370, 59371, 59632, 59633, 59634, 60320, 60321, 60322] # tf_zeroWidth
g_clefs = [57424, 57425, 57426, 57427, 57428, 57429, 57430, 57431, 57432, 57433, 57434, 57435, 57459] # clefsG
c_clefs = [57436, 57437, 57438, 57439, 57440, 57441, 57461] # clefsC
f_clefs = [57442, 57443, 57444, 57445, 57446, 57447, 57448, 57462] # clefsF
glyphs_for_combining_staff_positions = {57378: 'legerLine',
57379: 'legerLineWide',
57380: 'legerLineNarrow',
57460: 'gClefTurned',
57463: 'fClefTurned',
57504: 'noteheadDoubleWhole',
57505: 'noteheadDoubleWholeSquare',
57506: 'noteheadWhole',
57507: 'noteheadHalf',
57508: 'noteheadBlack',
57509: 'noteheadNull',
57510: 'noteheadXDoubleWhole',
57511: 'noteheadXWhole',
57512: 'noteheadXHalf',
57513: 'noteheadXBlack',
57514: 'noteheadXOrnate',
57516: 'noteheadPlusDoubleWhole',
57517: 'noteheadPlusWhole',
57518: 'noteheadPlusHalf',
57519: 'noteheadPlusBlack',
57520: 'noteheadCircleXDoubleWhole',
57521: 'noteheadCircleXWhole',
57522: 'noteheadCircleXHalf',
57523: 'noteheadCircleX',
57524: 'noteheadDoubleWholeWithX',
57525: 'noteheadWholeWithX',
57526: 'noteheadHalfWithX',
57527: 'noteheadVoidWithX',
57528: 'noteheadSquareWhite',
57529: 'noteheadSquareBlack',
57530: 'noteheadTriangleUpDoubleWhole',
57531: 'noteheadTriangleUpWhole',
57532: 'noteheadTriangleUpHalf',
57533: 'noteheadTriangleUpWhite',
57534: 'noteheadTriangleUpBlack',
57535: 'noteheadTriangleLeftWhite',
57536: 'noteheadTriangleLeftBlack',
57537: 'noteheadTriangleRightWhite',
57538: 'noteheadTriangleRightBlack',
57539: 'noteheadTriangleDownDoubleWhole',
57540: 'noteheadTriangleDownWhole',
57541: 'noteheadTriangleDownHalf',
57542: 'noteheadTriangleDownWhite',
57543: 'noteheadTriangleDownBlack',
57544: 'noteheadTriangleUpRightWhite',
57545: 'noteheadTriangleUpRightBlack',
57546: 'noteheadMoonWhite',
57547: 'noteheadMoonBlack',
57548: 'noteheadTriangleRoundDownWhite',
57549: 'noteheadTriangleRoundDownBlack',
57550: 'noteheadParenthesis',
57551: 'noteheadSlashedBlack1',
57552: 'noteheadSlashedBlack2',
57553: 'noteheadSlashedHalf1',
57554: 'noteheadSlashedHalf2',
57555: 'noteheadSlashedWhole1',
57556: 'noteheadSlashedWhole2',
57557: 'noteheadSlashedDoubleWhole1',
57558: 'noteheadSlashedDoubleWhole2',
57559: 'noteheadDiamondDoubleWhole',
57560: 'noteheadDiamondWhole',
57561: 'noteheadDiamondHalf',
57563: 'noteheadDiamondBlack',
57565: 'noteheadDiamondWhite',
57566: 'noteheadDiamondWhiteWide',
57567: 'noteheadDiamondDoubleWholeOld',
57568: 'noteheadDiamondWholeOld',
57569: 'noteheadDiamondHalfOld',
57570: 'noteheadDiamondBlackOld',
57571: 'noteheadDiamondHalfFilled',
57572: 'noteheadCircledBlack',
57573: 'noteheadCircledHalf',
57574: 'noteheadCircledWhole',
57575: 'noteheadCircledDoubleWhole',
57581: 'noteheadLargeArrowUpDoubleWhole',
57582: 'noteheadLargeArrowUpWhole',
57583: 'noteheadLargeArrowUpHalf',
57584: 'noteheadLargeArrowUpBlack',
57585: 'noteheadLargeArrowDownDoubleWhole',
57586: 'noteheadLargeArrowDownWhole',
57587: 'noteheadLargeArrowDownHalf',
57588: 'noteheadLargeArrowDownBlack',
57589: 'noteheadParenthesisLeft',
57590: 'noteheadParenthesisRight',
57591: 'noteheadCircleSlash',
57592: 'noteheadHeavyX',
57593: 'noteheadHeavyXHat',
57594: 'noteheadWholeFilled',
57595: 'noteheadHalfFilled',
57596: 'noteheadDiamondOpen',
57600: 'noteheadSlashVerticalEnds',
57601: 'noteheadSlashHorizontalEnds',
57602: 'noteheadSlashWhiteWhole',
57603: 'noteheadSlashWhiteHalf',
57604: 'noteheadSlashDiamondWhite',
57605: 'noteheadSlashVerticalEndsSmall',
57606: 'noteheadSlashX',
57607: 'noteheadSlashVerticalEndsMuted',
57608: 'noteheadSlashHorizontalEndsMuted',
57609: 'noteheadSlashWhiteMuted',
57616: 'noteheadRoundBlackLarge',
57617: 'noteheadRoundWhiteLarge',
57618: 'noteheadRoundWhiteWithDotLarge',
57619: 'noteheadRoundBlack',
57620: 'noteheadRoundWhite',
57621: 'noteheadRoundWhiteWithDot',
57622: 'noteheadRoundBlackSlashedLarge',
57623: 'noteheadRoundWhiteSlashedLarge',
57624: 'noteheadRoundBlackSlashed',
57625: 'noteheadRoundWhiteSlashed',
57626: 'noteheadSquareBlackLarge',
57627: 'noteheadSquareBlackWhite',
57632: 'noteheadClusterSquareWhite',
57633: 'noteheadClusterSquareBlack',
57634: 'noteheadClusterRoundWhite',
57635: 'noteheadClusterRoundBlack',
57636: 'noteheadClusterDoubleWhole2nd',
57637: 'noteheadClusterWhole2nd',
57638: 'noteheadClusterHalf2nd',
57639: 'noteheadClusterQuarter2nd',
57640: 'noteheadClusterDoubleWhole3rd',
57641: 'noteheadClusterWhole3rd',
57642: 'noteheadClusterHalf3rd',
57643: 'noteheadClusterQuarter3rd',
57644: 'noteheadClusterDoubleWholeTop',
57645: 'noteheadClusterDoubleWholeMiddle',
57646: 'noteheadClusterDoubleWholeBottom',
57647: 'noteheadClusterWholeTop',
57648: 'noteheadClusterWholeMiddle',
57649: 'noteheadClusterWholeBottom',
57650: 'noteheadClusterHalfTop',
57651: 'noteheadClusterHalfMiddle',
57652: 'noteheadClusterHalfBottom',
57653: 'noteheadClusterQuarterTop',
57654: 'noteheadClusterQuarterMiddle',
57655: 'noteheadClusterQuarterBottom',
57656: 'noteheadDiamondClusterWhite2nd',
57657: 'noteheadDiamondClusterBlack2nd',
57658: 'noteheadDiamondClusterWhite3rd',
57659: 'noteheadDiamondClusterBlack3rd',
57660: 'noteheadDiamondClusterWhiteTop',
57661: 'noteheadDiamondClusterWhiteMiddle',
57662: 'noteheadDiamondClusterWhiteBottom',
57663: 'noteheadDiamondClusterBlackTop',
57664: 'noteheadDiamondClusterBlackMiddle',
57665: 'noteheadDiamondClusterBlackBottom',
57666: 'noteheadRectangularClusterBlackTop',
57667: 'noteheadRectangularClusterBlackMiddle',
57668: 'noteheadRectangularClusterBlackBottom',
57669: 'noteheadRectangularClusterWhiteTop',
57670: 'noteheadRectangularClusterWhiteMiddle',
57671: 'noteheadRectangularClusterWhiteBottom',
57680: 'noteDoWhole',
57681: 'noteReWhole',
57682: 'noteMiWhole',
57683: 'noteFaWhole',
57684: 'noteSoWhole',
57685: 'noteLaWhole',
57686: 'noteTiWhole',
57687: 'noteSiWhole',
57688: 'noteDoHalf',
57689: 'noteReHalf',
57690: 'noteMiHalf',
57691: 'noteFaHalf',
57692: 'noteSoHalf',
57693: 'noteLaHalf',
57694: 'noteTiHalf',
57695: 'noteSiHalf',
57696: 'noteDoBlack',
57697: 'noteReBlack',
57698: 'noteMiBlack',
57699: 'noteFaBlack',
57700: 'noteSoBlack',
57701: 'noteLaBlack',
57702: 'noteTiBlack',
57703: 'noteSiBlack',
57704: 'noteAFlatWhole',
57705: 'noteAWhole',
57706: 'noteASharpWhole',
57707: 'noteBFlatWhole',
57708: 'noteBWhole',
57709: 'noteBSharpWhole',
57710: 'noteCFlatWhole',
57711: 'noteCWhole',
57712: 'noteCSharpWhole',
57713: 'noteDFlatWhole',
57714: 'noteDWhole',
57715: 'noteDSharpWhole',
57716: 'noteEFlatWhole',
57717: 'noteEWhole',
57718: 'noteESharpWhole',
57719: 'noteFFlatWhole',
57720: 'noteFWhole',
57721: 'noteFSharpWhole',
57722: 'noteGFlatWhole',
57723: 'noteGWhole',
57724: 'noteGSharpWhole',
57725: 'noteHWhole',
57726: 'noteHSharpWhole',
57727: 'noteAFlatHalf',
57728: 'noteAHalf',
57729: 'noteASharpHalf',
57730: 'noteBFlatHalf',
57731: 'noteBHalf',
57732: 'noteBSharpHalf',
57733: 'noteCFlatHalf',
57734: 'noteCHalf',
57735: 'noteCSharpHalf',
57736: 'noteDFlatHalf',
57737: 'noteDHalf',
57738: 'noteDSharpHalf',
57739: 'noteEFlatHalf',
57740: 'noteEHalf',
57741: 'noteESharpHalf',
57742: 'noteFFlatHalf',
57743: 'noteFHalf',
57744: 'noteFSharpHalf',
57745: 'noteGFlatHalf',
57746: 'noteGHalf',
57747: 'noteGSharpHalf',
57748: 'noteHHalf',
57749: 'noteHSharpHalf',
57750: 'noteAFlatBlack',
57751: 'noteABlack',
57752: 'noteASharpBlack',
57753: 'noteBFlatBlack',
57754: 'noteBBlack',
57755: 'noteBSharpBlack',
57756: 'noteCFlatBlack',
57757: 'noteCBlack',
57758: 'noteCSharpBlack',
57759: 'noteDFlatBlack',
57760: 'noteDBlack',
57761: 'noteDSharpBlack',
57762: 'noteEFlatBlack',
57763: 'noteEBlack',
57764: 'noteESharpBlack',
57765: 'noteFFlatBlack',
57766: 'noteFBlack',
57767: 'noteFSharpBlack',
57768: 'noteGFlatBlack',
57769: 'noteGBlack',
57770: 'noteGSharpBlack',
57771: 'noteHBlack',
57772: 'noteHSharpBlack',
57773: 'noteEmptyWhole',
57774: 'noteEmptyHalf',
57775: 'noteEmptyBlack',
57776: 'noteShapeRoundWhite',
57777: 'noteShapeRoundBlack',
57778: 'noteShapeSquareWhite',
57779: 'noteShapeSquareBlack',
57780: 'noteShapeTriangleRightWhite',
57781: 'noteShapeTriangleRightBlack',
57782: 'noteShapeTriangleLeftWhite',
57783: 'noteShapeTriangleLeftBlack',
57784: 'noteShapeDiamondWhite',
57785: 'noteShapeDiamondBlack',
57786: 'noteShapeTriangleUpWhite',
57787: 'noteShapeTriangleUpBlack',
57788: 'noteShapeMoonWhite',
57789: 'noteShapeMoonBlack',
57790: 'noteShapeTriangleRoundWhite',
57791: 'noteShapeTriangleRoundBlack',
57808: 'noteDoubleWhole',
57809: 'noteDoubleWholeSquare',
57810: 'noteWhole',
57811: 'noteHalfUp',
57812: 'noteHalfDown',
57813: 'noteQuarterUp',
57814: 'noteQuarterDown',
57815: 'note8thUp',
57816: 'note8thDown',
57817: 'note16thUp',
57818: 'note16thDown',
57819: 'note32ndUp',
57820: 'note32ndDown',
57821: 'note64thUp',
57822: 'note64thDown',
57823: 'note128thUp',
57824: 'note128thDown',
57825: 'note256thUp',
57826: 'note256thDown',
57827: 'note512thUp',
57828: 'note512thDown',
57829: 'note1024thUp',
57830: 'note1024thDown',
57831: 'augmentationDot',
57840: 'textBlackNoteShortStem',
57841: 'textBlackNoteLongStem',
57842: 'textBlackNoteFrac8thShortStem',
57843: 'textBlackNoteFrac8thLongStem',
57844: 'textBlackNoteFrac16thShortStem',
57845: 'textBlackNoteFrac16thLongStem',
57846: 'textBlackNoteFrac32ndLongStem',
57847: 'textCont8thBeamShortStem',
57848: 'textCont8thBeamLongStem',
57849: 'textCont16thBeamShortStem',
57850: 'textCont16thBeamLongStem',
57851: 'textCont32ndBeamLongStem',
57852: 'textAugmentationDot',
57853: 'textTie',
57854: 'textTupletBracketStartShortStem',
57855: 'textTuplet3ShortStem',
57856: 'textTupletBracketEndShortStem',
57857: 'textTupletBracketStartLongStem',
57858: 'textTuplet3LongStem',
57859: 'textTupletBracketEndLongStem',
57872: 'stem',
57873: 'stemSprechgesang',
57874: 'stemSwished',
57875: 'stemPendereckiTremolo',
57876: 'stemSulPonticello',
57877: 'stemBowOnBridge',
57878: 'stemBowOnTailpiece',
57879: 'stemBuzzRoll',
57880: 'stemDamp',
57881: 'stemVibratoPulse',
57882: 'stemMultiphonicsBlack',
57883: 'stemMultiphonicsWhite',
57884: 'stemMultiphonicsBlackWhite',
57885: 'stemSussurando',
57886: 'stemRimShot',
57887: 'stemHarpStringNoise',
57920: 'flag8thUp',
57921: 'flag8thDown',
57922: 'flag16thUp',
57923: 'flag16thDown',
57924: 'flag32ndUp',
57925: 'flag32ndDown',
57926: 'flag64thUp',
57927: 'flag64thDown',
57928: 'flag128thUp',
57929: 'flag128thDown',
57930: 'flag256thUp',
57931: 'flag256thDown',
57932: 'flag512thUp',
57933: 'flag512thDown',
57934: 'flag1024thUp',
57935: 'flag1024thDown',
57936: 'flagInternalUp',
57937: 'flagInternalDown',
57952: 'accidentalFlat',
57953: 'accidentalNatural',
57954: 'accidentalSharp',
57955: 'accidentalDoubleSharp',
57956: 'accidentalDoubleFlat',
57957: 'accidentalTripleSharp',
57958: 'accidentalTripleFlat',
57959: 'accidentalNaturalFlat',
57960: 'accidentalNaturalSharp',
57961: 'accidentalSharpSharp',
57962: 'accidentalParensLeft',
57963: 'accidentalParensRight',
57968: 'accidentalQuarterToneFlatArrowUp',
57969: 'accidentalThreeQuarterTonesFlatArrowDown',
57970: 'accidentalQuarterToneSharpNaturalArrowUp',
57971: 'accidentalQuarterToneFlatNaturalArrowDown',
57972: 'accidentalThreeQuarterTonesSharpArrowUp',
57973: 'accidentalQuarterToneSharpArrowDown',
57974: 'accidentalFiveQuarterTonesSharpArrowUp',
57975: 'accidentalThreeQuarterTonesSharpArrowDown',
57976: 'accidentalThreeQuarterTonesFlatArrowUp',
57977: 'accidentalFiveQuarterTonesFlatArrowDown',
57978: 'accidentalArrowUp',
57979: 'accidentalArrowDown',
57984: 'accidentalQuarterToneFlatStein',
57985: 'accidentalThreeQuarterTonesFlatZimmermann',
57986: 'accidentalQuarterToneSharpStein',
57987: 'accidentalThreeQuarterTonesSharpStein',
57988: 'accidentalNarrowReversedFlat',
57989: 'accidentalNarrowReversedFlatAndFlat',
58000: 'accidentalReversedFlatArrowUp',
58001: 'accidentalReversedFlatArrowDown',
58002: 'accidentalFilledReversedFlatArrowUp',
58003: 'accidentalFilledReversedFlatArrowDown',
58004: 'accidentalReversedFlatAndFlatArrowUp',
58005: 'accidentalReversedFlatAndFlatArrowDown',
58006: 'accidentalFilledReversedFlatAndFlat',
58007: 'accidentalFilledReversedFlatAndFlatArrowUp',
58008: 'accidentalFilledReversedFlatAndFlatArrowDown',
58009: 'accidentalHalfSharpArrowUp',
58010: 'accidentalHalfSharpArrowDown',
58011: 'accidentalOneAndAHalfSharpsArrowUp',
58012: 'accidentalOneAndAHalfSharpsArrowDown',
58016: 'accidentalSims12Down',
58017: 'accidentalSims6Down',
58018: 'accidentalSims4Down',
58019: 'accidentalSims12Up',
58020: 'accidentalSims6Up',
58021: 'accidentalSims4Up',
58032: 'accidentalJohnstonPlus',
58033: 'accidentalJohnstonMinus',
58034: 'accidentalJohnstonEl',
58035: 'accidentalJohnstonSeven',
58036: 'accidentalJohnstonUp',
58037: 'accidentalJohnstonDown',
58038: 'accidentalJohnston13',
58039: 'accidentalJohnston31',
58048: 'accidentalDoubleFlatOneArrowDown',
58049: 'accidentalFlatOneArrowDown',
58050: 'accidentalNaturalOneArrowDown',
58051: 'accidentalSharpOneArrowDown',
58052: 'accidentalDoubleSharpOneArrowDown',
58053: 'accidentalDoubleFlatOneArrowUp',
58054: 'accidentalFlatOneArrowUp',
58055: 'accidentalNaturalOneArrowUp',
58056: 'accidentalSharpOneArrowUp',
58057: 'accidentalDoubleSharpOneArrowUp',
58058: 'accidentalDoubleFlatTwoArrowsDown',
58059: 'accidentalFlatTwoArrowsDown',
58060: 'accidentalNaturalTwoArrowsDown',
58061: 'accidentalSharpTwoArrowsDown',
58062: 'accidentalDoubleSharpTwoArrowsDown',
58063: 'accidentalDoubleFlatTwoArrowsUp',
58064: 'accidentalFlatTwoArrowsUp',
58065: 'accidentalNaturalTwoArrowsUp',
58066: 'accidentalSharpTwoArrowsUp',
58067: 'accidentalDoubleSharpTwoArrowsUp',
58068: 'accidentalDoubleFlatThreeArrowsDown',
58069: 'accidentalFlatThreeArrowsDown',
58070: 'accidentalNaturalThreeArrowsDown',
58071: 'accidentalSharpThreeArrowsDown',
58072: 'accidentalDoubleSharpThreeArrowsDown',
58073: 'accidentalDoubleFlatThreeArrowsUp',
58074: 'accidentalFlatThreeArrowsUp',
58075: 'accidentalNaturalThreeArrowsUp',
58076: 'accidentalSharpThreeArrowsUp',
58077: 'accidentalDoubleSharpThreeArrowsUp',
58078: 'accidentalLowerOneSeptimalComma',
58079: 'accidentalRaiseOneSeptimalComma',
58080: 'accidentalLowerTwoSeptimalCommas',
58081: 'accidentalRaiseTwoSeptimalCommas',
58082: 'accidentalLowerOneUndecimalQuartertone',
58083: 'accidentalRaiseOneUndecimalQuartertone',
58084: 'accidentalLowerOneTridecimalQuartertone',
58085: 'accidentalRaiseOneTridecimalQuartertone',
58086: 'accidentalCombiningLower17Schisma',
58087: 'accidentalCombiningRaise17Schisma',
58088: 'accidentalCombiningLower19Schisma',
58089: 'accidentalCombiningRaise19Schisma',
58090: 'accidentalCombiningLower23Limit29LimitComma',
58091: 'accidentalCombiningRaise23Limit29LimitComma',
58092: 'accidentalCombiningLower31Schisma',
58093: 'accidentalCombiningRaise31Schisma',
58094: 'accidentalCombiningOpenCurlyBrace',
58095: 'accidentalCombiningCloseCurlyBrace',
58096: 'accidentalDoubleFlatEqualTempered',
58097: 'accidentalFlatEqualTempered',
58098: 'accidentalNaturalEqualTempered',
58099: 'accidentalSharpEqualTempered',
58100: 'accidentalDoubleSharpEqualTempered',
58112: 'accSagittal5v7KleismaUp',
58113: 'accSagittal5v7KleismaDown',
58114: 'accSagittal5CommaUp',
58115: 'accSagittal5CommaDown',
58116: 'accSagittal7CommaUp',
58117: 'accSagittal7CommaDown',
58118: 'accSagittal25SmallDiesisUp',
58119: 'accSagittal25SmallDiesisDown',
58120: 'accSagittal35MediumDiesisUp',
58121: 'accSagittal35MediumDiesisDown',
58122: 'accSagittal11MediumDiesisUp',
58123: 'accSagittal11MediumDiesisDown',
58124: 'accSagittal11LargeDiesisUp',
58125: 'accSagittal11LargeDiesisDown',
58126: 'accSagittal35LargeDiesisUp',
58127: 'accSagittal35LargeDiesisDown',
58128: 'accSagittalSharp25SDown',
58129: 'accSagittalFlat25SUp',
58130: 'accSagittalSharp7CDown',
58131: 'accSagittalFlat7CUp',
58132: 'accSagittalSharp5CDown',
58133: 'accSagittalFlat5CUp',
58134: 'accSagittalSharp5v7kDown',
58135: 'accSagittalFlat5v7kUp',
58136: 'accSagittalSharp',
58137: 'accSagittalFlat',
58138: 'accSagittalUnused1',
58139: 'accSagittalUnused2',
58140: 'accSagittalSharp5v7kUp',
58141: 'accSagittalFlat5v7kDown',
58142: 'accSagittalSharp5CUp',
58143: 'accSagittalFlat5CDown',
58144: 'accSagittalSharp7CUp',
58145: 'accSagittalFlat7CDown',
58146: 'accSagittalSharp25SUp',
58147: 'accSagittalFlat25SDown',
58148: 'accSagittalSharp35MUp',
58149: 'accSagittalFlat35MDown',
58150: 'accSagittalSharp11MUp',
58151: 'accSagittalFlat11MDown',
58152: 'accSagittalSharp11LUp',
58153: 'accSagittalFlat11LDown',
58154: 'accSagittalSharp35LUp',
58155: 'accSagittalFlat35LDown',
58156: 'accSagittalDoubleSharp25SDown',
58157: 'accSagittalDoubleFlat25SUp',
58158: 'accSagittalDoubleSharp7CDown',
58159: 'accSagittalDoubleFlat7CUp',
58160: 'accSagittalDoubleSharp5CDown',
58161: 'accSagittalDoubleFlat5CUp',
58162: 'accSagittalDoubleSharp5v7kDown',
58163: 'accSagittalDoubleFlat5v7kUp',
58164: 'accSagittalDoubleSharp',
58165: 'accSagittalDoubleFlat',
58176: 'accSagittal7v11KleismaUp',
58177: 'accSagittal7v11KleismaDown',
58178: 'accSagittal17CommaUp',
58179: 'accSagittal17CommaDown',
58180: 'accSagittal55CommaUp',
58181: 'accSagittal55CommaDown',
58182: 'accSagittal7v11CommaUp',
58183: 'accSagittal7v11CommaDown',
58184: 'accSagittal5v11SmallDiesisUp',
58185: 'accSagittal5v11SmallDiesisDown',
58186: 'accSagittalSharp5v11SDown',
58187: 'accSagittalFlat5v11SUp',
58188: 'accSagittalSharp7v11CDown',
58189: 'accSagittalFlat7v11CUp',
58190: 'accSagittalSharp55CDown',
58191: 'accSagittalFlat55CUp',
58192: 'accSagittalSharp17CDown',
58193: 'accSagittalFlat17CUp',
58194: 'accSagittalSharp7v11kDown',
58195: 'accSagittalFlat7v11kUp',
58196: 'accSagittalSharp7v11kUp',
58197: 'accSagittalFlat7v11kDown',
58198: 'accSagittalSharp17CUp',
58199: 'accSagittalFlat17CDown',
58200: 'accSagittalSharp55CUp',
58201: 'accSagittalFlat55CDown',
58202: 'accSagittalSharp7v11CUp',
58203: 'accSagittalFlat7v11CDown',
58204: 'accSagittalSharp5v11SUp',
58205: 'accSagittalFlat5v11SDown',
58206: 'accSagittalDoubleSharp5v11SDown',
58207: 'accSagittalDoubleFlat5v11SUp',
58208: 'accSagittalDoubleSharp7v11CDown',
58209: 'accSagittalDoubleFlat7v11CUp',
58210: 'accSagittalDoubleSharp55CDown',
58211: 'accSagittalDoubleFlat55CUp',
58212: 'accSagittalDoubleSharp17CDown',
58213: 'accSagittalDoubleFlat17CUp',
58214: 'accSagittalDoubleSharp7v11kDown',
58215: 'accSagittalDoubleFlat7v11kUp',
58224: 'accSagittal23CommaUp',
58225: 'accSagittal23CommaDown',
58226: 'accSagittal5v19CommaUp',
58227: 'accSagittal5v19CommaDown',
58228: 'accSagittal5v23SmallDiesisUp',
58229: 'accSagittal5v23SmallDiesisDown',
58230: 'accSagittalSharp5v23SDown',
58231: 'accSagittalFlat5v23SUp',
58232: 'accSagittalSharp5v19CDown',
58233: 'accSagittalFlat5v19CUp',
58234: 'accSagittalSharp23CDown',
58235: 'accSagittalFlat23CUp',
58236: 'accSagittalSharp23CUp',
58237: 'accSagittalFlat23CDown',
58238: 'accSagittalSharp5v19CUp',
58239: 'accSagittalFlat5v19CDown',
58240: 'accSagittalSharp5v23SUp',
58241: 'accSagittalFlat5v23SDown',
58242: 'accSagittalDoubleSharp5v23SDown',
58243: 'accSagittalDoubleFlat5v23SUp',
58244: 'accSagittalDoubleSharp5v19CDown',
58245: 'accSagittalDoubleFlat5v19CUp',
58246: 'accSagittalDoubleSharp23CDown',
58247: 'accSagittalDoubleFlat23CUp',
58256: 'accSagittal19SchismaUp',
58257: 'accSagittal19SchismaDown',
58258: 'accSagittal17KleismaUp',
58259: 'accSagittal17KleismaDown',
58260: 'accSagittal143CommaUp',
58261: 'accSagittal143CommaDown',
58262: 'accSagittal11v49CommaUp',
58263: 'accSagittal11v49CommaDown',
58264: 'accSagittal19CommaUp',
58265: 'accSagittal19CommaDown',
58266: 'accSagittal7v19CommaUp',
58267: 'accSagittal7v19CommaDown',
58268: 'accSagittal49SmallDiesisUp',
58269: 'accSagittal49SmallDiesisDown',
58270: 'accSagittal23SmallDiesisUp',
58271: 'accSagittal23SmallDiesisDown',
58272: 'accSagittal5v13MediumDiesisUp',
58273: 'accSagittal5v13MediumDiesisDown',
58274: 'accSagittal11v19MediumDiesisUp',
58275: 'accSagittal11v19MediumDiesisDown',
58276: 'accSagittal49MediumDiesisUp',
58277: 'accSagittal49MediumDiesisDown',
58278: 'accSagittal5v49MediumDiesisUp',
58279: 'accSagittal5v49MediumDiesisDown',
58280: 'accSagittal49LargeDiesisUp',
58281: 'accSagittal49LargeDiesisDown',
58282: 'accSagittal11v19LargeDiesisUp',
58283: 'accSagittal11v19LargeDiesisDown',
58284: 'accSagittal5v13LargeDiesisUp',
58285: 'accSagittal5v13LargeDiesisDown',
58288: 'accSagittalSharp23SDown',
58289: 'accSagittalFlat23SUp',
58290: 'accSagittalSharp49SDown',
58291: 'accSagittalFlat49SUp',
58292: 'accSagittalSharp7v19CDown',
58293: 'accSagittalFlat7v19CUp',
58294: 'accSagittalSharp19CDown',
58295: 'accSagittalFlat19CUp',
58296: 'accSagittalSharp11v49CDown',
58297: 'accSagittalFlat11v49CUp',
58298: 'accSagittalSharp143CDown',
58299: 'accSagittalFlat143CUp',
58300: 'accSagittalSharp17kDown',
58301: 'accSagittalFlat17kUp',
58302: 'accSagittalSharp19sDown',
58303: 'accSagittalFlat19sUp',
58304: 'accSagittalSharp19sUp',
58305: 'accSagittalFlat19sDown',
58306: 'accSagittalSharp17kUp',
58307: 'accSagittalFlat17kDown',
58308: 'accSagittalSharp143CUp',
58309: 'accSagittalFlat143CDown',
58310: 'accSagittalSharp11v49CUp',
58311: 'accSagittalFlat11v49CDown',
58312: 'accSagittalSharp19CUp',
58313: 'accSagittalFlat19CDown',
58314: 'accSagittalSharp7v19CUp',
58315: 'accSagittalFlat7v19CDown',
58316: 'accSagittalSharp49SUp',
58317: 'accSagittalFlat49SDown',
58318: 'accSagittalSharp23SUp',
58319: 'accSagittalFlat23SDown',
58320: 'accSagittalSharp5v13MUp',
58321: 'accSagittalFlat5v13MDown',
58322: 'accSagittalSharp11v19MUp',
58323: 'accSagittalFlat11v19MDown',
58324: 'accSagittalSharp49MUp',
58325: 'accSagittalFlat49MDown',
58326: 'accSagittalSharp5v49MUp',
58327: 'accSagittalFlat5v49MDown',
58328: 'accSagittalSharp49LUp',
58329: 'accSagittalFlat49LDown',
58330: 'accSagittalSharp11v19LUp',
58331: 'accSagittalFlat11v19LDown',
58332: 'accSagittalSharp5v13LUp',
58333: 'accSagittalFlat5v13LDown',
58334: 'accSagittalUnused3',
58335: 'accSagittalUnused4',
58336: 'accSagittalDoubleSharp23SDown',
58337: 'accSagittalDoubleFlat23SUp',
58338: 'accSagittalDoubleSharp49SDown',
58339: 'accSagittalDoubleFlat49SUp',
58340: 'accSagittalDoubleSharp7v19CDown',
58341: 'accSagittalDoubleFlat7v19CUp',
58342: 'accSagittalDoubleSharp19CDown',
58343: 'accSagittalDoubleFlat19CUp',
58344: 'accSagittalDoubleSharp11v49CDown',
58345: 'accSagittalDoubleFlat11v49CUp',
58346: 'accSagittalDoubleSharp143CDown',
58347: 'accSagittalDoubleFlat143CUp',
58348: 'accSagittalDoubleSharp17kDown',
58349: 'accSagittalDoubleFlat17kUp',
58350: 'accSagittalDoubleSharp19sDown',
58351: 'accSagittalDoubleFlat19sUp',
58352: 'accSagittalShaftUp',
58353: 'accSagittalShaftDown',
58354: 'accSagittalAcute',
58355: 'accSagittalGrave',
58400: 'accidentalWyschnegradsky1TwelfthsSharp',
58401: 'accidentalWyschnegradsky2TwelfthsSharp',
58402: 'accidentalWyschnegradsky3TwelfthsSharp',
58403: 'accidentalWyschnegradsky4TwelfthsSharp',
58404: 'accidentalWyschnegradsky5TwelfthsSharp',
58405: 'accidentalWyschnegradsky6TwelfthsSharp',
58406: 'accidentalWyschnegradsky7TwelfthsSharp',
58407: 'accidentalWyschnegradsky8TwelfthsSharp',
58408: 'accidentalWyschnegradsky9TwelfthsSharp',
58409: 'accidentalWyschnegradsky10TwelfthsSharp',
58410: 'accidentalWyschnegradsky11TwelfthsSharp',
58411: 'accidentalWyschnegradsky1TwelfthsFlat',
58412: 'accidentalWyschnegradsky2TwelfthsFlat',
58413: 'accidentalWyschnegradsky3TwelfthsFlat',
58414: 'accidentalWyschnegradsky4TwelfthsFlat',
58415: 'accidentalWyschnegradsky5TwelfthsFlat',
58416: 'accidentalWyschnegradsky6TwelfthsFlat',
58417: 'accidentalWyschnegradsky7TwelfthsFlat',
58418: 'accidentalWyschnegradsky8TwelfthsFlat',
58419: 'accidentalWyschnegradsky9TwelfthsFlat',
58420: 'accidentalWyschnegradsky10TwelfthsFlat',
58421: 'accidentalWyschnegradsky11TwelfthsFlat',
58432: 'accidentalBuyukMucennebFlat',
58433: 'accidentalKucukMucennebFlat',
58434: 'accidentalBakiyeFlat',
58435: 'accidentalKomaFlat',
58436: 'accidentalKomaSharp',
58437: 'accidentalBakiyeSharp',
58438: 'accidentalKucukMucennebSharp',
58439: 'accidentalBuyukMucennebSharp',
58448: 'accidental1CommaSharp',
58449: 'accidental2CommaSharp',
58450: 'accidental3CommaSharp',
58451: 'accidental5CommaSharp',
58452: 'accidental1CommaFlat',
58453: 'accidental2CommaFlat',
58454: 'accidental3CommaFlat',
58455: 'accidental4CommaFlat',
58464: 'accidentalKoron',
58465: 'accidentalSori',
58480: 'accidentalXenakisOneThirdToneSharp',
58481: 'accidentalXenakisTwoThirdTonesSharp',
58482: 'accidentalQuarterToneSharpBusotti',
58483: 'accidentalSharpOneHorizontalStroke',
58484: 'accidentalThreeQuarterTonesSharpBusotti',
58485: 'accidentalQuarterToneSharpWiggle',
58486: 'accidentalTavenerSharp',
58487: 'accidentalTavenerFlat',
58488: 'accidentalQuarterToneFlatPenderecki',
58489: 'accidentalCommaSlashUp',
58490: 'accidentalCommaSlashDown',
58491: 'accidentalWilsonPlus',
58492: 'accidentalWilsonMinus',
58493: 'accidentalLargeDoubleSharp',
58494: 'accidentalQuarterToneSharp4',
58495: 'accidentalQuarterToneFlat4',
58496: 'accidentalQuarterToneFlatFilledReversed',
58497: 'accidentalSharpReversed',
58498: 'accidentalNaturalReversed',
58499: 'accidentalDoubleFlatReversed',
58500: 'accidentalFlatTurned',
58501: 'accidentalDoubleFlatTurned',
58502: 'accidentalThreeQuarterTonesFlatGrisey',
58503: 'accidentalThreeQuarterTonesFlatTartini',
58504: 'accidentalQuarterToneFlatVanBlankenburg',
58505: 'accidentalThreeQuarterTonesFlatCouper',
58506: 'accidentalOneThirdToneSharpFerneyhough',
58507: 'accidentalOneThirdToneFlatFerneyhough',
58508: 'accidentalTwoThirdTonesSharpFerneyhough',
58509: 'accidentalTwoThirdTonesFlatFerneyhough',
58528: 'articAccentAbove',
58529: 'articAccentBelow',
58530: 'articStaccatoAbove',
58531: 'articStaccatoBelow',
58532: 'articTenutoAbove',
58533: 'articTenutoBelow',
58534: 'articStaccatissimoAbove',
58535: 'articStaccatissimoBelow',
58536: 'articStaccatissimoWedgeAbove',
58537: 'articStaccatissimoWedgeBelow',
58538: 'articStaccatissimoStrokeAbove',
58539: 'articStaccatissimoStrokeBelow',
58540: 'articMarcatoAbove',
58541: 'articMarcatoBelow',
58542: 'articMarcatoStaccatoAbove',
58543: 'articMarcatoStaccatoBelow',
58544: 'articAccentStaccatoAbove',
58545: 'articAccentStaccatoBelow',
58546: 'articTenutoStaccatoAbove',
58547: 'articTenutoStaccatoBelow',
58548: 'articTenutoAccentAbove',
58549: 'articTenutoAccentBelow',
58550: 'articStressAbove',
58551: 'articStressBelow',
58552: 'articUnstressAbove',
58553: 'articUnstressBelow',
58554: 'articLaissezVibrerAbove',
58555: 'articLaissezVibrerBelow',
58560: 'fermataAbove',
58561: 'fermataBelow',
58562: 'fermataVeryShortAbove',
58563: 'fermataVeryShortBelow',
58564: 'fermataShortAbove',
58565: 'fermataShortBelow',
58566: 'fermataLongAbove',
58567: 'fermataLongBelow',
58568: 'fermataVeryLongAbove',
58569: 'fermataVeryLongBelow',
58570: 'fermataLongHenzeAbove',
58571: 'fermataLongHenzeBelow',
58572: 'fermataShortHenzeAbove',
58573: 'fermataShortHenzeBelow',
58574: 'breathMarkComma',
58577: 'caesura',
58578: 'caesuraThick',
58579: 'caesuraShort',
58581: 'breathMarkSalzedo',
58582: 'curlewSign',
58593: 'restLonga',
58594: 'restDoubleWhole',
58595: 'restWhole',
58596: 'restHalf',
58597: 'restQuarter',
58598: 'rest8th',
58599: 'rest16th',
58600: 'rest32nd',
58601: 'rest64th',
58602: 'rest128th',
58603: 'rest256th',
58604: 'rest512th',
58605: 'rest1024th',
58606: 'restHBar',
58607: 'restHBarLeft',
58609: 'restHBarRight',
58610: 'restQuarterOld',
58612: 'restWholeLegerLine',
58613: 'restHalfLegerLine',
58624: 'repeat1Bar',
58625: 'repeat2Bars',
58626: 'repeat4Bars',
59648: 'mensuralGclef',
59649: 'mensuralGclefPetrucci',
59650: 'chantFclef',
59651: 'mensuralFclef',
59652: 'mensuralFclefPetrucci',
59654: 'chantCclef',
59657: 'mensuralCclefPetrucciPosMiddle',
59664: 'mensuralProlation1',
59665: 'mensuralProlation2',
59666: 'mensuralProlation3',
59667: 'mensuralProlation4',
59668: 'mensuralProlation5',
59669: 'mensuralProlation6',
59670: 'mensuralProlation7',
59671: 'mensuralProlation8',
59672: 'mensuralProlation9',
59673: 'mensuralProlation10',
59674: 'mensuralProlation11',
59675: 'mensuralProportionTempusPerfectum',
59676: 'mensuralProportionProportioDupla1',
59677: 'mensuralProportionProportioDupla2',
59678: 'mensuralProportionProportioTripla',
59679: 'mensuralProportionProportioQuadrupla',
59680: 'mensuralProlationCombiningDot',
59681: 'mensuralProlationCombiningTwoDots',
59682: 'mensuralProlationCombiningThreeDots',
59683: 'mensuralProlationCombiningThreeDotsTri',
59684: 'mensuralProlationCombiningDotVoid',
59685: 'mensuralProlationCombiningStroke',
59686: 'mensuralProportion1',
59687: 'mensuralProportion2',
59688: 'mensuralProportion3',
59689: 'mensuralProportion4',
59696: 'mensuralNoteheadMaximaBlack',
59697: 'mensuralNoteheadMaximaVoid',
59698: 'mensuralNoteheadMaximaBlackVoid',
59699: 'mensuralNoteheadMaximaWhite',
59700: 'mensuralNoteheadLongaBlack',
59701: 'mensuralNoteheadLongaVoid',
59702: 'mensuralNoteheadLongaBlackVoid',
59703: 'mensuralNoteheadLongaWhite',
59704: 'mensuralNoteheadSemibrevisBlack',
59705: 'mensuralNoteheadSemibrevisVoid',
59706: 'mensuralNoteheadSemibrevisBlackVoid',
59707: 'mensuralNoteheadSemibrevisBlackVoidTurned',
59708: 'mensuralNoteheadMinimaWhite',
59709: 'mensuralNoteheadSemiminimaWhite',
59710: 'mensuralCombStemUp',
59711: 'mensuralCombStemDown',
59712: 'mensuralCombStemDiagonal',
59713: 'mensuralCombStemUpFlagRight',
59714: 'mensuralCombStemDownFlagRight',
59715: 'mensuralCombStemUpFlagLeft',
59716: 'mensuralCombStemDownFlagLeft',
59717: 'mensuralCombStemUpFlagFlared',
59718: 'mensuralCombStemDownFlagFlared',
59719: 'mensuralCombStemUpFlagExtended',
59720: 'mensuralCombStemDownFlagExtended',
59721: 'mensuralCombStemUpFlagSemiminima',
59722: 'mensuralCombStemDownFlagSemiminima',
59723: 'mensuralCombStemUpFlagFusa',
59724: 'mensuralCombStemDownFlagFusa',
59728: 'mensuralBlackMaxima',
59729: 'mensuralBlackLonga',
59730: 'mensuralBlackBrevis',
59731: 'mensuralBlackSemibrevis',
59732: 'mensuralBlackMinima',
59733: 'mensuralBlackSemiminima',
59734: 'mensuralBlackBrevisVoid',
59735: 'mensuralBlackSemibrevisVoid',
59736: 'mensuralBlackMinimaVoid',
59737: 'mensuralBlackSemibrevisCaudata',
59738: 'mensuralBlackDragma',
59739: 'mensuralBlackSemibrevisOblique',
59740: 'mensuralWhiteMaxima',
59741: 'mensuralWhiteLonga',
59742: 'mensuralWhiteBrevis',
59743: 'mensuralWhiteMinima',
59744: 'mensuralWhiteSemiminima',
59745: 'mensuralWhiteFusa',
59792: 'chantPunctum',
59793: 'chantPunctumInclinatum',
59794: 'chantPunctumInclinatumAuctum',
59795: 'chantPunctumInclinatumDeminutum',
59796: 'chantAuctumAsc',
59797: 'chantAuctumDesc',
59798: 'chantPunctumVirga',
59799: 'chantPunctumVirgaReversed',
59800: 'chantPunctumCavum',
59801: 'chantPunctumLinea',
59802: 'chantPunctumLineaCavum',
59803: 'chantQuilisma',
59804: 'chantOriscusAscending',
59805: 'chantOriscusDescending',
59807: 'chantStrophicus',
59808: 'chantStrophicusAuctus',
59824: 'chantPodatusLower',
59825: 'chantPodatusUpper',
59826: 'chantDeminutumUpper',
59827: 'chantDeminutumLower',
59828: 'chantEntryLineAsc2nd',
59829: 'chantEntryLineAsc3rd',
59830: 'chantEntryLineAsc4th',
59831: 'chantEntryLineAsc5th',
59832: 'chantEntryLineAsc6th',
59833: 'chantLigaturaDesc2nd',
59834: 'chantLigaturaDesc3rd',
59835: 'chantLigaturaDesc4th',
59836: 'chantLigaturaDesc5th',
59837: 'chantConnectingLineAsc2nd',
59838: 'chantConnectingLineAsc3rd',
59839: 'chantConnectingLineAsc4th',
59840: 'chantConnectingLineAsc5th',
59841: 'chantConnectingLineAsc6th',
59856: 'chantIctusAbove',
59857: 'chantIctusBelow',
59858: 'chantCirculusAbove',
59859: 'chantCirculusBelow',
59860: 'chantSemicirculusAbove',
59861: 'chantSemicirculusBelow',
59862: 'chantAccentusAbove',
59863: 'chantAccentusBelow',
59864: 'chantEpisema',
59865: 'chantAugmentum',
59872: 'medRenFlatSoftB',
59873: 'medRenFlatHardB',
59874: 'medRenNatural',
59875: 'medRenSharpCroix',
59876: 'medRenFlatWithDot',
59877: 'medRenNaturalWithCross',
59904: 'mensuralSignumUp',
59905: 'mensuralSignumDown',
59906: 'mensuralCustosUp',
59907: 'mensuralCustosDown',
59910: 'chantCustosStemUpPosMiddle',
59911: 'chantCustosStemDownPosMiddle',
59914: 'mensuralCustosCheckmark',
59915: 'mensuralCustosTurn',
59916: 'mensuralColorationStartSquare',
59917: 'mensuralColorationEndSquare',
59918: 'mensuralColorationStartRound',
59919: 'mensuralColorationEndRound',
59920: 'mensuralAlterationSign',
60464: 'kievanCClef',
60465: 'kievanEndingSymbol',
60466: 'kievanNoteReciting',
60467: 'kievanNoteWhole',
60468: 'kievanNoteWholeFinal',
60469: 'kievanNoteHalfStaffLine',
60471: 'kievanNoteQuarterStemUp',
60472: 'kievanNoteQuarterStemDown',
60473: 'kievanNote8thStemUp',
60474: 'kievanNote8thStemDown',
60476: 'kievanAugmentationDot',
60477: 'kievanAccidentalSharp',
60478: 'kievanAccidentalFlat'} # combiningStaffPositions
octaves = [58640, 58641, 58642, 58643, 58644, 58645, 58646, 58647, 58648, 58649, 58650, 58651, 58652, 58653, 58654, 58655, 60560] # octaves
dynamics = [58656, 58657, 58658, 58659, 58660, 58661, 58662, 58663, 58664, 58665, 58666, 58667, 58668, 58669, 58670, 58671, 58672, 58673, 58674, 58675, 58676, 58677, 58678, 58679, 58680, 58681, 58682, 58683, 58684, 58685, 58686, 58687, 58688, 58689] # dynamics
hairpins = [58686, 58687, 58688] # tf_hairpins
ornaments = [58720, 58721, 58722, 58723, 58724, 58725, 58726, 58727, 58728, 58729, 58730, 58731, 58732, 58733, 58734, 58735, 58736, 58737, 58738, 58739, 58740, 58741, 58742, 58743, 58744, 58745, 58746, 58747, 58748, 58749, 58750, 58751, 58752, 58753, 58754, 58755, 58756, 58757, 58758, 58759, 58768, 58769, 58770, 58771, 58772, 58773, 58774, 58775, 58776, 58777, 58778, 58779, 58780, 58781, 58782, 58783, 58784, 58785, 58786, 58787, 58788, 58789, 58790, 58791, 58792, 58800, 58801, 58802, 58803, 58804, 58805, 58806, 58807, 58808, 58809, 58810, 58811, 58812, 58813, 58814, 58815, 58816, 58817, 58818, 58819, 58820, 58821, 58822, 58823, 58824] # tf_ornaments
pedals = [58960, 58961, 58962, 58963, 58964, 58965, 58966, 58967, 58968, 58969, 58970] # tf_pedals
harp_pedals = [59008, 59009, 59010, 59011] # tf_harpPedals
pictograms = [59040, 59041, 59042, 59043, 59044, 59045, 59046, 59047, 59048, 59049, 59050, 59051, 59052, 59053, 59054, 59055, 59056, 59057, 59058, 59072, 59073, 59074, 59075, 59076, 59077, 59078, 59079, 59080, 59088, 59089, 59090, 59091, 59092, 59093, 59094, 59095, 59096, 59097, 59098, 59099, 59100, 59101, 59102, 59103, 59104, 59105, 59106, 59107, 59108, 59120, 59121, 59122, 59123, 59124, 59125, 59126, 59127, 59128, 59129, 59130, 59131, 59132, 59136, 59137, 59152, 59153, 59154, 59155, 59156, 59157, 59158, 59159, 59160, 59161, 59162, 59168, 59169, 59170, 59171, 59172, 59173, 59174, 59175, 59176, 59177, 59178, 59184, 59185, 59186, 59187, 59188, 59200, 59201, 59202, 59203, 59204, 59205, 59206, 59207, 59208, 59216, 59217, 59218, 59219, 59220, 59221, 59222, 59223, 59224, 59225, 59226, 59232, 59233, 59234, 59235, 59236, 59237, 59238, 59239, 59248, 59249, 59250, 59251, 59252, 59253, 59254, 59255, 59256, 59257, 59258, 59259, 59260, 59261, 59262, 59263, 59264, 59265, 59266, 59267, 59268, 59269, 59270, 59271, 59272, 59273, 59274, 59275, 59276, 59277, 59278, 59279, 59280, 59281, 59282, 59283, 59284, 59285, 59286, 59287, 59288, 59289, 59290, 59291, 59292, 59293, 59294, 59295, 59296, 59297, 59298, 59299, 59300, 59301, 59302, 59303, 59304, 59305, 59306, 59307, 59308, 59309, 59310, 59311, 59312, 59313, 59314, 59315, 59316, 59317, 59318, 59319, 59320, 59321, 59322, 59323, 59324, 59325, 59326, 59327, 59328, 59329, 59330, 59331, 59332, 59333, 59334, 59335, 59336, 59337, 59338, 59339, 59340, 59341, 59342, 59343, 59344, 59345, 59346, 59347, 59376, 59377, 59378, 59379, 59380, 59381, 59382, 59383, 59384, 59385, 59386, 59387, 59388, 59389, 59390, 59391, 59392, 59393, 59394, 59395, 59396, 59397, 59398, 59399, 59400, 59401, 59402, 59403, 59404, 59405, 59552, 59553, 59554, 59555, 59556, 59557, 59558, 59559, 59560, 59561, 59562, 59563, 59564, 59565, 59566, 59567, 59568, 59569, 59570, 59571, 59572, 59573, 59574, 59575, 59576, 59577, 59578, 59579, 59580, 59581, 59582, 59583, 59584, 59585, 59586, 59587, 59588, 59589, 59590, 59591, 59592, 59593, 59594, 59595, 59596, 59597, 59598, 59599, 59600, 59601, 59602, 59603, 59604, 59605, 59606] # tf_pictograms
figured_bass = [59984, 59985, 59986, 59987, 59988, 59989, 59990, 59991, 59992, 59993, 59994, 59995, 59996, 59997, 59998, 59999, 60000, 60001, 60002, 60003, 60004, 60005, 60006, 60007, 60008, 60009, 60010, 60011, 60012, 60013, 60014] # tf_figuredBass
prolations = [59690, 59691, 59692, 59693, 59694, 59695] # tf_prolations
daseian_notation = [59952, 59953, 59954, 59955, 59956, 59957, 59958, 59959, 59960, 59961, 59962, 59963, 59964, 59965, 59966, 59967, 59968, 59969] # tf_daseianNotation
chord_symbols = [ 59504, ] # tf_chordSymbols

# Loop over the glyphs and decompose them
for g in fl.font.glyphs:
    if len(g.components) > 0:
        g.Decompose()

# Loop over the glyphs
for g in fl.font.glyphs:
    if g.unicode in [ 9833, 9834, 9835, 9836 ]: # quarter note, 8th, beamed 8ths, beamed 16ths
        g.Scale(Point(0.75,0.75),Point(0,0))
    # Scale Unicode flat, natural, sharp so they are large enough to sit on the baseline
    elif g.unicode == 9837: # flat
        g.Scale(Point(1.5,1.5),Point(0,0))
    elif g.unicode in [ 9838, 9839 ]: # natural / sharp
        g.Scale(Point(1.3,1.3),Point(0,0))
	# Scale octaves by 165%
    elif g.unicode in octaves:
        g.Scale(Point(1.65,1.65),Point(0,0))
	# Scale dynamics by 165%
    elif g.unicode in dynamics:
        g.Scale(Point(1.65,1.65),Point(0,0))
    # Scale ornaments by 145%
    elif g.unicode in ornaments:
        g.Scale(Point(1.45,1.45),Point(0,0))
    # Scale keyboard pedal marks by 130%
    elif g.unicode in pedals:
        g.Scale(Point(1.30,1.30),Point(0,0))
    # Scale pedal diagrams by 100% (i.e. leave unchanged)
    elif g.unicode in harp_pedals:
        g.Scale(Point(1.0,1.0),Point(0,0))
    # Scale pictograms (percussion, accordion couplers) by 100% (i.e. unchanged)
    elif g.unicode in pictograms:
        g.Scale(Point(1.0,1.0),Point(0,0))
    # Scale prolations by 100% (i.e. unchanged)
    elif g.unicode in prolations:
        g.Scale(Point(1.0,1.0),Point(0,0))
    # Scale figured bass by 185%
    elif g.unicode in figured_bass:
        g.Scale(Point(1.85,1.85),Point(0,0))
    # Scale Daseian notation by 100% (i.e. unchanged)
    elif g.unicode in daseian_notation:
        g.Scale(Point(1.0,1.0),Point(0,0))
    # Scale chord symbols glyphs by 150% to make them caps height (0.75em)
    elif g.unicode in chord_symbols:
        g.Scale(Point(1.50,1.50),Point(0,0))
    # Scale remaining glyphs by 80% around the centre point
    else:
        g.Scale(Point(0.80,0.80),Point(0,0))
	# Set advance width to 0 for zero-width glyphs...
    bounding_box = g.GetBoundingRect()
    metrics      = g.GetMetrics()
    if g.unicode in zero_width_glyphs:
#         print "Zero width glyph (%s)"%hex(g.unicode)
        metrics.x = 0
    else:
        if g.nodes_number > 0:
            # ...or to the bbox x value (minus any overhang to the left)
            metrics.x = bounding_box.width + bounding_box.x
    g.SetMetrics(metrics)
    
    # Shift the glyph vertically for certain classes
    if g.unicode in [ 9833, 9834, 9835, 9836 ]: # quarter note, 8th, beamed 8ths, beamed 16ths
        g.Shift(Point(0,94))
    elif g.unicode == 9837: # flat
        g.Shift(Point(0,250))
    elif g.unicode in [ 9838, 9839 ]: # natural / sharp
        g.Shift(Point(0,350))
    elif g.unicode in g_clefs:
#         print "Shifting g clef"
        g.Shift(Point(0,200))
    elif g.unicode in c_clefs:
#         print "Shifting c clef"
        g.Shift(Point(0,400))
    elif g.unicode in f_clefs:
#         print "Shifting f clef"
        g.Shift(Point(0,600))
    elif g.unicode in hairpins:
#         print "Shifting hairpins"
        g.Shift(Point(0,-50))
    elif g.unicode in prolations:
#         print "Shifting prolations"
        g.Shift(Point(0,250))
    elif g.unicode in glyphs_for_combining_staff_positions:
#         print "Shifting comb pos"
        g.Shift(Point(0,400))
    
# An empty array to hold the ligatures of the combining staff positions
combining_staff_position_ligatures = [  ]

next_optional_codepoint = 62851
combining_staff_positions = {60304: 'staffPosRaise1',
60305: 'staffPosRaise2',
60306: 'staffPosRaise3',
60307: 'staffPosRaise4',
60308: 'staffPosRaise5',
60309: 'staffPosRaise6',
60310: 'staffPosRaise7',
60311: 'staffPosRaise8',
60312: 'staffPosLower1',
60313: 'staffPosLower2',
60314: 'staffPosLower3',
60315: 'staffPosLower4',
60316: 'staffPosLower5',
60317: 'staffPosLower6',
60318: 'staffPosLower7',
60319: 'staffPosLower8'}
print "Please wait, creating permutations of combined staff positions..."
for g2c_codepoint, g2c_name in glyphs_for_combining_staff_positions.iteritems():

    g2c_glyph_idx = fl.font.FindGlyph(format_codepoint(g2c_codepoint))
    if g2c_glyph_idx == -1:
        print "Cannot find %s (%s), skipping permutation"%(format_codepoint(g2c_codepoint), g2c_name)
        continue
    g2c_glyph = fl.font.glyphs[g2c_glyph_idx]
    
    for csp_codepoint, csp_name in combining_staff_positions.iteritems():
        new_glyph = Glyph()
#         new_glyph.unicode = next_optional_codepoint
        new_glyph.name = "%s_%s"%(hex(csp_codepoint).upper()[2:], hex(g2c_codepoint).upper()[2:])
        new_glyph.note = "%s with %s"%(g2c_name, csp_name)
        offset = int(csp_name[-1:])*100
        if 'Lower' in csp_name:
            offset = -offset
        new_glyph.components.append(Component(g2c_glyph_idx, Point(0,offset)))
        new_glyph.Decompose()
        bounding_box = g2c_glyph.GetBoundingRect()
        metrics      = g2c_glyph.GetMetrics()
        metrics.x = bounding_box.width
        new_glyph.SetMetrics(metrics)
        
        combining_staff_position_ligatures.append(\
            "sub %s %s by %s_%s; # %s with %s"%(format_codepoint(csp_codepoint), format_codepoint(g2c_codepoint), 
                                  hex(csp_codepoint).upper()[2:], hex(g2c_codepoint).upper()[2:], g2c_name, csp_name),
                                   )
        fl.font.glyphs.append(new_glyph)
        next_optional_codepoint +=1
        
cspl_text = ["\n  # Ligatures for combining staff position glyphs"]
cspl_subtable_len = 0
cspl_subtable_idx = 2
cspl_text.append("lookup liga_%s useExtension {"%cspl_subtable_idx)
for cspl in combining_staff_position_ligatures:
    
    if cspl_subtable_len > 48000:
        cspl_text.append("} liga_%s;\n"%cspl_subtable_idx)
        cspl_subtable_idx += 1
        cspl_text.append("lookup liga_%s useExtension {"%cspl_subtable_idx)
        cspl_subtable_len = 0
    cspl_text.append("  %s"%cspl)
    cspl_subtable_len += len(cspl) + 4
cspl_text.append("} liga_%s;\n"%cspl_subtable_idx)

if 'liga' not in fl.font.features:
	fl.font.features.append(Feature('liga', "\n  ".join(cspl_text)))
else:
	fl.font.features['liga'].value = fl.font.features['liga'].value.replace("} liga;",
  	  "\n  ".join(cspl_text) + "\n} liga;")

space_glyph = fl.font.glyphs[fl.font.FindGlyph(0x20)]
space_glyph.width = 100

hyphen_glyph = Glyph()
hyphen_glyph.name = 'hyphen'
hyphen_glyph.unicode = 0x2D
hyphen_glyph.width = 200
fl.font.glyphs.append(hyphen_glyph)

equal_glyph = Glyph()
equal_glyph.name = 'equal'
equal_glyph.unicode = 0x3D
equal_glyph.width = 400
fl.font.glyphs.append(equal_glyph)


# 33239 is FontSortByUnicode
fl.CallCommand(33239)
fl.UpdateFont()
print "Finished..."
