A number of different shape note traditions remain in common use in the
shape note community. SMuFL encodes the noteheads required for four such
systems: one four-shape system; and three seven-shape systems (Walker,
Funk, and Aikin). All three seven-shape systems also use the four shapes
of the four-shape system, each introducing three additional shapes.

The four-shape system, used in books such as William Walker’s *Southern
Harmony* (1835), uses a form of solmization where the syllables *fa*,
*so*, *la*, *fa*, *so*, *la*, *mi* are assigned to the seven notes of an
ascending major scale. Each syllable has its own note shape:

| *Syllable* | *Half notes and longer* | *Quarter notes and shorter*
| ---------- | ----------------------- | ---------------------------
| *fa* (or *faw*) | Stem down: noteShapeTriangleRightWhite<br>Stem up: noteShapeTriangleLeftWhite | Stem down: noteShapeTriangleRightBlack<br>Stem up: noteShapeTriangleLeftBlack
| *so* (or *sol*) | noteShapeRoundWhite | noteShapeRoundBlack
| *la* (or *law*) | noteShapeSquareWhite | noteShapeSquareBlack
| *mi* | noteShapeDiamondWhite | noteShapeDiamondBlack

Joseph Funk devised his seven-shape system, building upon the existing
four-shape system, for his book *Harmonia Sacra* (1851), adding to the
four-shape system by adding the syllables *do*, *re* and *ti* (sometimes
*si*), so the ascending major scale would use the syllables *do*, *re*,
*mi*, *fa*, *so*, *la*, *ti*. The note shapes for each syllable are as
follows:

| *Syllable* | *Half notes and longer* | *Quarter notes and shorter*
| ---------- | ----------------------- | ---------------------------
| *do* | noteShapeMoonLeftWhite | noteShapeMoonLeftBlack
| *re* | noteShapeArrowheadLeftWhite | noteShapeArrowheadLeftBlack
| *mi* | noteShapeDiamondWhite | noteShapeDiamondBlack
| *fa* (or *faw*) | Stem down: noteShapeTriangleRightWhite<br>Stem up: noteShapeTriangleLeftWhite | Stem down: noteShapeTriangleRightBlack<br>Stem up: noteShapeTriangleLeftBlack
| *so* (or *sol*) | noteShapeRoundWhite | noteShapeRoundBlack
| *la* (or *law*) | noteShapeSquareWhite | noteShapeSquareBlack
| ti (or *si*) | noteShapeTriangleRoundLeftWhite | noteShapeTriangleRoundLeftBlack

In addition to being the composer of *Southern Harmony*, William Walker
also later devised his own seven-shape system for the book *Christian
Harmony* (1867), using the same solmization as Funk. The note shapes for
each syllable are as follows:

| *Syllable* | *Half notes and longer* | *Quarter notes and shorter*
| ---------- | ----------------------- | ---------------------------
| *do* | noteShapeKeystoneWhite | noteShapeKeystoneBlack
| *re* | noteShapeQuarterMoonWhite | noteShapeQuarterMoonBlack
| *mi* | noteShapeDiamondWhite | noteShapeDiamondBlack
| *fa* (or *faw*) | Stem down: noteShapeTriangleRightWhite<br>Stem up: noteShapeTriangleLeftWhite | Stem down: noteShapeTriangleRightBlack<br>Stem up: noteShapeTriangleLeftBlack
| *so* (or *sol*) | noteShapeRoundWhite | noteShapeRoundBlack
| *la* (or *law*) | noteShapeSquareWhite | noteShapeSquareBlack
| ti (or *si*) | noteShapeIsoscelesTriangleWhite | noteShapeIsoscelesTriangleBlack

Perhaps the most commonly-used seven-shape system, however, is that
devised by Jesse B. Aikin, though his system is sometimes incorrectly
referred to as the “Aiken” system due to an error made by the
musicologist George Pullen Jackson. Aikin introduced his system in *The
Christian Minstrel* (1846), and after his shapes were adopted by the
influential Ruebush & Kieffer Publishing Company in the late 19th
century they have become increasingly widely used. Again using the same
solmization as both Funk and Walker, the note shapes for each syllable
are as follows:

| *Syllable* | *Half notes and longer* | *Quarter notes and shorter*
| ---------- | ----------------------- | ---------------------------
| *do* | noteShapeTriangleUpWhite | noteShapeTriangleUpBlack
| *re* | noteShapeMoonWhite | noteShapeMoonBlack
| *mi* | noteShapeDiamondWhite | noteShapeDiamondBlack
| *fa* (or *faw*) | Stem down: noteShapeTriangleRightWhite<br>Stem up: noteShapeTriangleLeftWhite | Stem down: noteShapeTriangleRightBlack<br>Stem up: noteShapeTriangleLeftBlack
| *so* (or *sol*) | noteShapeRoundWhite | noteShapeRoundBlack
| *la* (or *law*) | noteShapeSquareWhite | noteShapeSquareBlack
| *ti* (or *si*) | noteShapeTriangleRoundWhite | noteShapeTriangleRoundBlack

For practical use, scoring applications should provide a means of
automatically substituting regular noteheads for the appropriate shape
note notehead glyph according to the pitch of each note.

*See also* the implementation notes for noteheads.
