Time signatures (U+E080–U+E09F)
===============================

| **Glyph** | **Description** | **Glyph** | **Description**
| :-------: | --------------- | :-------: | ---------------
|<span class="bravura_large">&#xe080;</span> | **U+E080**<br/>*timeSig0*<br/>Time signature 0 | <span class="bravura_large">&#xe081;</span> | **U+E081**<br/>*timeSig1*<br/>Time signature 1
|<span class="bravura_large">&#xe082;</span> | **U+E082**<br/>*timeSig2*<br/>Time signature 2 | <span class="bravura_large">&#xe083;</span> | **U+E083**<br/>*timeSig3*<br/>Time signature 3
|<span class="bravura_large">&#xe084;</span> | **U+E084**<br/>*timeSig4*<br/>Time signature 4 | <span class="bravura_large">&#xe085;</span> | **U+E085**<br/>*timeSig5*<br/>Time signature 5
|<span class="bravura_large">&#xe086;</span> | **U+E086**<br/>*timeSig6*<br/>Time signature 6 | <span class="bravura_large">&#xe087;</span> | **U+E087**<br/>*timeSig7*<br/>Time signature 7
|<span class="bravura_large">&#xe088;</span> | **U+E088**<br/>*timeSig8*<br/>Time signature 8 | <span class="bravura_large">&#xe089;</span> | **U+E089**<br/>*timeSig9*<br/>Time signature 9
|<span class="bravura_large">&#xe08a;</span> | **U+E08A** (and U+1D134)<br/>*timeSigCommon*<br/>Common time | <span class="bravura_large">&#xe08b;</span> | **U+E08B** (and U+1D135)<br/>*timeSigCutCommon*<br/>Cut time
|<span class="bravura_large">&#xe08c;</span> | **U+E08C**<br/>*timeSigPlus*<br/>Time signature + | <span class="bravura_large">&#xe08d;</span> | **U+E08D**<br/>*timeSigPlusSmall*<br/>Time signature + (for numerators)
|<span class="bravura_large">&#xe08e;</span> | **U+E08E**<br/>*timeSigFractionalSlash*<br/>Time signature fraction slash | <span class="bravura_large">&#xe08f;</span> | **U+E08F**<br/>*timeSigEquals*<br/>Time signature equals
|<span class="bravura_large">&#xe090;</span> | **U+E090**<br/>*timeSigMinus*<br/>Time signature minus | <span class="bravura_large">&#xe091;</span> | **U+E091**<br/>*timeSigMultiply*<br/>Time signature multiply
|<span class="bravura_large">&#xe092;</span> | **U+E092**<br/>*timeSigParensLeftSmall*<br/>Left parenthesis for numerator only | <span class="bravura_large">&#xe093;</span> | **U+E093**<br/>*timeSigParensRightSmall*<br/>Right parenthesis for numerator only
|<span class="bravura_large">&#xe094;</span> | **U+E094**<br/>*timeSigParensLeft*<br/>Left parenthesis for whole time signature | <span class="bravura_large">&#xe095;</span> | **U+E095**<br/>*timeSigParensRight*<br/>Right parenthesis for whole time signature
|<span class="bravura_large">&#xe096;</span> | **U+E096**<br/>*timeSigComma*<br/>Time signature comma | <span class="bravura_large">&#xe097;</span> | **U+E097**<br/>*timeSigFractionQuarter*<br/>Time signature fraction ¼
|<span class="bravura_large">&#xe098;</span> | **U+E098**<br/>*timeSigFractionHalf*<br/>Time signature fraction ½ | <span class="bravura_large">&#xe099;</span> | **U+E099**<br/>*timeSigFractionThreeQuarters*<br/>Time signature fraction ¾
|<span class="bravura_large">&#xe09a;</span> | **U+E09A**<br/>*timeSigFractionOneThird*<br/>Time signature fraction ⅓ | <span class="bravura_large">&#xe09b;</span> | **U+E09B**<br/>*timeSigFractionTwoThirds*<br/>Time signature fraction ⅔
|<span class="bravura_large">&#xe09c;</span> | **U+E09C**<br/>*timeSigX*<br/>Open time signature | <span class="bravura_large">&#xe09d;</span> | **U+E09D**<br/>*timeSigOpenPenderecki*<br/>Open time signature (Penderecki)
|<span class="bravura_large">&#xe09e;</span> | **U+E09E**<br/>*timeSigCombNumerator*<br/>Control character for numerator digit | <span class="bravura_large">&#xe09f;</span> | **U+E09F**<br/>*timeSigCombDenominator*<br/>Control character for denominator digit

Recommended stylistic alternates
--------------------------------
| **Glyph** | **Description** | **Glyph** | **Description**
| :-------: | --------------- | :-------: | ---------------
|<span class="bravura_large">&#xf440;</span> | **uniE080.ss04**<br/>*timeSig0Large*<br/>Time signature 0 (outside staff) | <span class="bravura_large">&#xf45d;</span> | **uniE080.ss01**<br/>*timeSig0Small*<br/>Time signature 0 (small staff)
|<span class="bravura_large">&#xf506;</span> | **uniE080.ss09**<br/>*timeSig0Narrow*<br/>Time signature 0 (large, narrow) | <span class="bravura_large">&#xf441;</span> | **uniE081.ss04**<br/>*timeSig1Large*<br/>Time signature 1 (outside staff)
|<span class="bravura_large">&#xf45e;</span> | **uniE081.ss01**<br/>*timeSig1Small*<br/>Time signature 1 (small staff) | <span class="bravura_large">&#xf507;</span> | **uniE081.ss09**<br/>*timeSig1Narrow*<br/>Time signature 1 (large, narrow)
|<span class="bravura_large">&#xf442;</span> | **uniE082.ss04**<br/>*timeSig2Large*<br/>Time signature 2 (outside staff) | <span class="bravura_large">&#xf45f;</span> | **uniE082.ss01**<br/>*timeSig2Small*<br/>Time signature 2 (small staff)
|<span class="bravura_large">&#xf508;</span> | **uniE082.ss09**<br/>*timeSig2Narrow*<br/>Time signature 2 (large, narrow) | <span class="bravura_large">&#xf443;</span> | **uniE083.ss04**<br/>*timeSig3Large*<br/>Time signature 3 (outside staff)
|<span class="bravura_large">&#xf460;</span> | **uniE083.ss01**<br/>*timeSig3Small*<br/>Time signature 3 (small staff) | <span class="bravura_large">&#xf509;</span> | **uniE083.ss09**<br/>*timeSig3Narrow*<br/>Time signature 3 (large, narrow)
|<span class="bravura_large">&#xf444;</span> | **uniE084.ss04**<br/>*timeSig4Large*<br/>Time signature 4 (outside staff) | <span class="bravura_large">&#xf461;</span> | **uniE084.ss01**<br/>*timeSig4Small*<br/>Time signature 4 (small staff)
|<span class="bravura_large">&#xf50a;</span> | **uniE084.ss09**<br/>*timeSig4Narrow*<br/>Time signature 4 (large, narrow) | <span class="bravura_large">&#xf445;</span> | **uniE085.ss04**<br/>*timeSig5Large*<br/>Time signature 5 (outside staff)
|<span class="bravura_large">&#xf462;</span> | **uniE085.ss01**<br/>*timeSig5Small*<br/>Time signature 5 (small staff) | <span class="bravura_large">&#xf50b;</span> | **uniE085.ss09**<br/>*timeSig5Narrow*<br/>Time signature 5 (large, narrow)
|<span class="bravura_large">&#xf446;</span> | **uniE086.ss04**<br/>*timeSig6Large*<br/>Time signature 6 (outside staff) | <span class="bravura_large">&#xf463;</span> | **uniE086.ss01**<br/>*timeSig6Small*<br/>Time signature 6 (small staff)
|<span class="bravura_large">&#xf50c;</span> | **uniE086.ss09**<br/>*timeSig6Narrow*<br/>Time signature 6 (large, narrow) | <span class="bravura_large">&#xf447;</span> | **uniE087.ss04**<br/>*timeSig7Large*<br/>Time signature 7 (outside staff)
|<span class="bravura_large">&#xf464;</span> | **uniE087.ss01**<br/>*timeSig7Small*<br/>Time signature 7 (small staff) | <span class="bravura_large">&#xf50d;</span> | **uniE087.ss09**<br/>*timeSig7Narrow*<br/>Time signature 7 (large, narrow)
|<span class="bravura_large">&#xf448;</span> | **uniE088.ss04**<br/>*timeSig8Large*<br/>Time signature 8 (outside staff) | <span class="bravura_large">&#xf465;</span> | **uniE088.ss01**<br/>*timeSig8Small*<br/>Time signature 8 (small staff)
|<span class="bravura_large">&#xf50e;</span> | **uniE088.ss09**<br/>*timeSig8Narrow*<br/>Time signature 8 (large, narrow) | <span class="bravura_large">&#xf449;</span> | **uniE089.ss04**<br/>*timeSig9Large*<br/>Time signature 9 (outside staff)
|<span class="bravura_large">&#xf466;</span> | **uniE089.ss01**<br/>*timeSig9Small*<br/>Time signature 9 (small staff) | <span class="bravura_large">&#xf50f;</span> | **uniE089.ss09**<br/>*timeSig9Narrow*<br/>Time signature 9 (large, narrow)
|<span class="bravura_large">&#xf44a;</span> | **uniE08A.ss04**<br/>*timeSigCommonLarge*<br/>Common time (outside staff) | <span class="bravura_large">&#xf510;</span> | **uniE08A.ss09**<br/>*timeSigCommonNarrow*<br/>Common time (large, narrow)
|<span class="bravura_large">&#xf44b;</span> | **uniE08B.ss04**<br/>*timeSigCutCommonLarge*<br/>Cut time (outside staff) | <span class="bravura_large">&#xf511;</span> | **uniE08B.ss09**<br/>*timeSigCutCommonNarrow*<br/>Cut time (large, narrow)
|<span class="bravura_large">&#xf44c;</span> | **uniE08C.ss04**<br/>*timeSigPlusLarge*<br/>Time signature + (outside staff) | <span class="bravura_large">&#xf512;</span> | **uniE08C.ss09**<br/>*timeSigPlusNarrow*<br/>Time signature + (large, narrow)
|<span class="bravura_large">&#xf4ee;</span> | **uniE08D.ss04**<br/>*timeSigPlusSmallLarge*<br/>Time signature + (for numerators) (outside staff) | <span class="bravura_large">&#xf513;</span> | **uniE08D.ss09**<br/>*timeSigPlusSmallNarrow*<br/>Time signature + (for numerators) (large, narrow)
|<span class="bravura_large">&#xf4ef;</span> | **uniE08E.ss04**<br/>*timeSigFractionalSlashLarge*<br/>Time signature fraction slash (outside staff) | <span class="bravura_large">&#xf514;</span> | **uniE08E.ss09**<br/>*timeSigFractionalSlashNarrow*<br/>Time signature fraction slash (large, narrow)
|<span class="bravura_large">&#xf4f0;</span> | **uniE08F.ss04**<br/>*timeSigEqualsLarge*<br/>Time signature equals (outside staff) | <span class="bravura_large">&#xf515;</span> | **uniE08F.ss09**<br/>*timeSigEqualsNarrow*<br/>Time signature equals (large, narrow)
|<span class="bravura_large">&#xf4f1;</span> | **uniE090.ss04**<br/>*timeSigMinusLarge*<br/>Time signature minus (outside staff) | <span class="bravura_large">&#xf516;</span> | **uniE090.ss09**<br/>*timeSigMinusNarrow*<br/>Time signature minus (large, narrow)
|<span class="bravura_large">&#xf4f2;</span> | **uniE091.ss04**<br/>*timeSigMultiplyLarge*<br/>Time signature multiply (outside staff) | <span class="bravura_large">&#xf517;</span> | **uniE091.ss09**<br/>*timeSigMultiplyNarrow*<br/>Time signature multiply (large, narrow)
|<span class="bravura_large">&#xf4f3;</span> | **uniE092.ss04**<br/>*timeSigParensLeftSmallLarge*<br/>Left parenthesis for numerator only (outside staff) | <span class="bravura_large">&#xf518;</span> | **uniE092.ss09**<br/>*timeSigParensLeftSmallNarrow*<br/>Left parenthesis for numerator only (large, narrow)
|<span class="bravura_large">&#xf4f4;</span> | **uniE093.ss04**<br/>*timeSigParensRightSmallLarge*<br/>Right parenthesis for numerator only (outside staff) | <span class="bravura_large">&#xf519;</span> | **uniE093.ss09**<br/>*timeSigParensRightSmallNarrow*<br/>Right parenthesis for numerator only (large, narrow)
|<span class="bravura_large">&#xf4f5;</span> | **uniE094.ss04**<br/>*timeSigParensLeftLarge*<br/>Left parenthesis for whole time signature (outside staff) | <span class="bravura_large">&#xf51a;</span> | **uniE094.ss09**<br/>*timeSigParensLeftNarrow*<br/>Left parenthesis for whole time signature (large, narrow)
|<span class="bravura_large">&#xf4f6;</span> | **uniE095.ss04**<br/>*timeSigParensRightLarge*<br/>Right parenthesis for whole time signature (outside staff) | <span class="bravura_large">&#xf51b;</span> | **uniE095.ss09**<br/>*timeSigParensRightNarrow*<br/>Right parenthesis for whole time signature (large, narrow)
|<span class="bravura_large">&#xf4f7;</span> | **uniE096.ss04**<br/>*timeSigCommaLarge*<br/>Time signature comma (outside staff) | <span class="bravura_large">&#xf51c;</span> | **uniE096.ss09**<br/>*timeSigCommaNarrow*<br/>Time signature comma (large, narrow)
|<span class="bravura_large">&#xf4f8;</span> | **uniE097.ss04**<br/>*timeSigFractionQuarterLarge*<br/>Time signature fraction ¼ (outside staff) | <span class="bravura_large">&#xf51d;</span> | **uniE097.ss09**<br/>*timeSigFractionQuarterNarrow*<br/>Time signature fraction ¼ (large, narrow)
|<span class="bravura_large">&#xf4f9;</span> | **uniE098.ss04**<br/>*timeSigFractionHalfLarge*<br/>Time signature fraction ½ (outside staff) | <span class="bravura_large">&#xf51e;</span> | **uniE098.ss09**<br/>*timeSigFractionHalfNarrow*<br/>Time signature fraction ½ (large, narrow)
|<span class="bravura_large">&#xf4fa;</span> | **uniE099.ss04**<br/>*timeSigFractionThreeQuartersLarge*<br/>Time signature fraction ¾ (outside staff) | <span class="bravura_large">&#xf51f;</span> | **uniE099.ss09**<br/>*timeSigFractionThreeQuartersNarrow*<br/>Time signature fraction ¾ (large, narrow)
|<span class="bravura_large">&#xf4fb;</span> | **uniE09A.ss04**<br/>*timeSigFractionOneThirdLarge*<br/>Time signature fraction ⅓ (outside staff) | <span class="bravura_large">&#xf520;</span> | **uniE09A.ss09**<br/>*timeSigFractionOneThirdNarrow*<br/>Time signature fraction ⅓ (large, narrow)
|<span class="bravura_large">&#xf4fc;</span> | **uniE09B.ss04**<br/>*timeSigFractionTwoThirdsLarge*<br/>Time signature fraction ⅔ (outside staff) | <span class="bravura_large">&#xf521;</span> | **uniE09B.ss09**<br/>*timeSigFractionTwoThirdsNarrow*<br/>Time signature fraction ⅔ (large, narrow)
|<span class="bravura_large">&#xf4fd;</span> | **uniE09C.ss04**<br/>*timeSigXLarge*<br/>Open time signature (outside staff) | <span class="bravura_large">&#xf522;</span> | **uniE09C.ss09**<br/>*timeSigXNarrow*<br/>Open time signature (large, narrow)
|<span class="bravura_large">&#xf4fe;</span> | **uniE09D.ss04**<br/>*timeSigOpenPendereckiLarge*<br/>Open time signature (Penderecki) (outside staff) | <span class="bravura_large">&#xf523;</span> | **uniE09D.ss09**<br/>*timeSigOpenPendereckiNarrow*<br/>Open time signature (Penderecki) (narrow, large)

Recommended ligatures
---------------------
| **Glyph** | **Description** | **Glyph** | **Description**
| :-------: | --------------- | :-------: | ---------------
|<span class="bravura_large">&#xf5c8;</span> | **uniE09F_uniE080**<br/>*timeSig0Denominator*<br/>Time signature 0 (denominator) | <span class="bravura_large">&#xf5c9;</span> | **uniE09E_uniE080**<br/>*timeSig0Numerator*<br/>Time signature 0 (numerator)
|<span class="bravura_large">&#xf5ca;</span> | **uniE09F_uniE081**<br/>*timeSig1Denominator*<br/>Time signature 1 (denominator) | <span class="bravura_large">&#xf5cb;</span> | **uniE09E_uniE081**<br/>*timeSig1Numerator*<br/>Time signature 1 (numerator)
|<span class="bravura_large">&#xf5cc;</span> | **uniE09F_uniE082**<br/>*timeSig2Denominator*<br/>Time signature 2 (denominator) | <span class="bravura_large">&#xf5cd;</span> | **uniE09E_uniE082**<br/>*timeSig2Numerator*<br/>Time signature 2 (numerator)
|<span class="bravura_large">&#xf5ce;</span> | **uniE09F_uniE083**<br/>*timeSig3Denominator*<br/>Time signature 3 (denominator) | <span class="bravura_large">&#xf5cf;</span> | **uniE09E_uniE083**<br/>*timeSig3Numerator*<br/>Time signature 3 (numerator)
|<span class="bravura_large">&#xf5d0;</span> | **uniE09F_uniE084**<br/>*timeSig4Denominator*<br/>Time signature 4 (denominator) | <span class="bravura_large">&#xf5d1;</span> | **uniE09E_uniE084**<br/>*timeSig4Numerator*<br/>Time signature 4 (numerator)
|<span class="bravura_large">&#xf5d2;</span> | **uniE09F_uniE085**<br/>*timeSig5Denominator*<br/>Time signature 5 (denominator) | <span class="bravura_large">&#xf5d3;</span> | **uniE09E_uniE085**<br/>*timeSig5Numerator*<br/>Time signature 5 (numerator)
|<span class="bravura_large">&#xf5d4;</span> | **uniE09F_uniE086**<br/>*timeSig6Denominator*<br/>Time signature 6 (denominator) | <span class="bravura_large">&#xf5d5;</span> | **uniE09E_uniE086**<br/>*timeSig6Numerator*<br/>Time signature 6 (numerator)
|<span class="bravura_large">&#xf5d6;</span> | **uniE09F_uniE087**<br/>*timeSig7Denominator*<br/>Time signature 7 (denominator) | <span class="bravura_large">&#xf5d7;</span> | **uniE09E_uniE087**<br/>*timeSig7Numerator*<br/>Time signature 7 (numerator)
|<span class="bravura_large">&#xf5d8;</span> | **uniE09F_uniE088**<br/>*timeSig8Denominator*<br/>Time signature 8 (denominator) | <span class="bravura_large">&#xf5d9;</span> | **uniE09E_uniE088**<br/>*timeSig8Numerator*<br/>Time signature 8 (numerator)
|<span class="bravura_large">&#xf5da;</span> | **uniE09F_uniE089**<br/>*timeSig9Denominator*<br/>Time signature 9 (denominator) | <span class="bravura_large">&#xf5db;</span> | **uniE09E_uniE089**<br/>*timeSig9Numerator*<br/>Time signature 9 (numerator)
|<span class="bravura_large">&#xf5f9;</span> | **uniE09E_uniE082_uniE09F_uniE084**<br/>*timeSig2over4*<br/>2/4 time signature | <span class="bravura_large">&#xf5fa;</span> | **uniE09E_uniE082_uniE09F_uniE082**<br/>*timeSig2over2*<br/>2/2 time signature
|<span class="bravura_large">&#xf5fb;</span> | **uniE09E_uniE083_uniE09F_uniE082**<br/>*timeSig3over2*<br/>3/2 time signature | <span class="bravura_large">&#xf5fc;</span> | **uniE09E_uniE083_uniE09F_uniE084**<br/>*timeSig3over4*<br/>3/4 time signature
|<span class="bravura_large">&#xf5fd;</span> | **uniE09E_uniE083_uniE09F_uniE088**<br/>*timeSig3over8*<br/>3/8 time signature | <span class="bravura_large">&#xf5fe;</span> | **uniE09E_uniE084_uniE09F_uniE084**<br/>*timeSig4over4*<br/>4/4 time signature
|<span class="bravura_large">&#xf5ff;</span> | **uniE09E_uniE085_uniE09F_uniE084**<br/>*timeSig5over4*<br/>5/4 time signature | <span class="bravura_large">&#xf600;</span> | **uniE09E_uniE085_uniE09F_uniE088**<br/>*timeSig5over8*<br/>5/8 time signature
|<span class="bravura_large">&#xf601;</span> | **uniE09E_uniE086_uniE09F_uniE084**<br/>*timeSig6over4*<br/>6/4 time signature | <span class="bravura_large">&#xf602;</span> | **uniE09E_uniE086_uniE09F_uniE088**<br/>*timeSig6over8*<br/>6/8 time signature
|<span class="bravura_large">&#xf603;</span> | **uniE09E_uniE087_uniE09F_uniE088**<br/>*timeSig7over8*<br/>7/8 time signature | <span class="bravura_large">&#xf604;</span> | **uniE09E_uniE089_uniE09F_uniE088**<br/>*timeSig9over8*<br/>9/8 time signature
|<span class="bravura_large">&#xf605;</span> | **uniE09E_uniE081_uniE09E_uniE082_uniE09F_uniE088**<br/>*timeSig12over8*<br/>12/8 time signature | &nbsp; | &nbsp;

Supplementary Groups
---------------------
[Time signatures supplement](time-signatures-supplement.md)

Implementation notes
---------------------

{{#include ../implementation_notes/time_signatures.md}}