Standard accidentals for chord symbols (U+ED60–U+ED6F)
======================================================

Supplementary to [Chord symbols](chord-symbols.md)

| **Glyph** | **Description** | **Glyph** | **Description**
| :-------: | --------------- | :-------: | ---------------
|<span class="bravura_large">&#xed60;</span> | **U+ED60**<br/>*csymAccidentalFlat*<br/>Flat | <span class="bravura_large">&#xed61;</span> | **U+ED61**<br/>*csymAccidentalNatural*<br/>Natural
|<span class="bravura_large">&#xed62;</span> | **U+ED62**<br/>*csymAccidentalSharp*<br/>Sharp | <span class="bravura_large">&#xed63;</span> | **U+ED63**<br/>*csymAccidentalDoubleSharp*<br/>Double sharp
|<span class="bravura_large">&#xed64;</span> | **U+ED64**<br/>*csymAccidentalDoubleFlat*<br/>Double flat | <span class="bravura_large">&#xed65;</span> | **U+ED65**<br/>*csymAccidentalTripleSharp*<br/>Triple sharp
|<span class="bravura_large">&#xed66;</span> | **U+ED66**<br/>*csymAccidentalTripleFlat*<br/>Triple flat | &nbsp; | &nbsp;

Recommended stylistic alternates
--------------------------------
| **Glyph** | **Description** | **Glyph** | **Description**
| :-------: | --------------- | :-------: | ---------------
|<span class="bravura_large">&#xf4dc;</span> | **uniED60.ss07**<br/>*csymAccidentalFlatSmall*<br/>Flat (superscript or subscript) | <span class="bravura_large">&#xf4dd;</span> | **uniED61.ss07**<br/>*csymAccidentalNaturalSmall*<br/>Natural (superscript or subscript)
|<span class="bravura_large">&#xf4de;</span> | **uniED62.ss07**<br/>*csymAccidentalSharpSmall*<br/>Sharp (superscript or subscript) | <span class="bravura_large">&#xf4df;</span> | **uniED63.ss07**<br/>*csymAccidentalDoubleSharpSmall*<br/>Double sharp (superscript or subscript)
|<span class="bravura_large">&#xf4e0;</span> | **uniED64.ss07**<br/>*csymAccidentalDoubleFlatSmall*<br/>Double flat (superscript or subscript) | <span class="bravura_large">&#xf4e1;</span> | **uniED65.ss07**<br/>*csymAccidentalTripleSharpSmall*<br/>Triple sharp (superscript or subscript)
|<span class="bravura_large">&#xf4e2;</span> | **uniED66.ss07**<br/>*csymAccidentalTripleFlatSmall*<br/>Triple flat (superscript or subscript) | &nbsp; | &nbsp;

Implementation notes
---------------------

{{#include ../implementation_notes/standard_accidentals_for_chord_symbols.md}}