A brief history of music fonts
------------------------------

Computer software has been displaying musical symbols of various kinds
since the 1960s, but the first font for musical symbols did not arrive
until 1985, when Cleo Huggins designed Sonata for Adobe.[^1]

Sonata mapped the musical symbols onto keys on the standard QWERTY
keyboard, using some simple mnemonics (the treble G clef, for example,
was mapped onto the & key, and the sharp sign onto \#). Most music fonts
developed since then, including Steve Peha’s Petrucci (the first music
font for Finale, dating from 1988[^2]) and Jonathan Finn’s Opus (the
first music font for Sibelius, dating from 1993), have followed Sonata’s
layout.

However, since Sonata includes fewer than 200 glyphs, and even
conventional music notation[^3] requires many more symbols than that,
individual vendors have devised their own mappings for glyphs beyond
Sonata’s initial set.

By 2013, for example, the Opus font family that is still Sibelius’s
default font set contains no fewer than 18 fonts with more than 600
glyphs between them.

In 1998, Perry Roland of the University of Virginia drafted a proposal
for a new range of musical symbols to be incorporated into the Unicode
Standard[^4]. This range of 220 characters was duly accepted into the
Unicode Standard, and those symbols are found at code points
U+1D100–U+1D1FF[^5]. However, its repertoire of 220 symbols does not
extend dramatically beyond the scope of the original 1985 version of
Sonata, though it does add some symbols for mensural and Gregorian
notation.

To date the only commercially available music font that uses the Unicode
mapping is Adobe Sonata Std, and its repertoire is incomplete.

[^1]: See http://www.identifont.com/show?12A

[^2]: See http://www.finalemusic.com/blog/meet-steve-peha-creator-of-petrucci-finales-first-music-font/

[^3]: A term coined by [Donald Byrd](http://www.informatics.indiana.edu/donbyrd/DonBiography.htm), Senior Scientist and Adjunct Associate Professor of Informatics at Indiana University.

[^4]: The original proposal is no longer available, but an archived version can be found at http://archive.is/PzkaT

[^5]: See http://www.unicode.org/charts/PDF/U1D100.pdf
