# Summary

[Home](./README.md)
* [Preamble](./preamble/index.md)
  * [Acknowledgements](./preamble/acknowledgements.md)
  * [License](./preamble/license.md)
  * [Version history](./preamble/version-history.md)
* [About SMuFL](./about/index.md)
  * [A brief history of music fonts](./about/brief-history.md)
  * [How SMuFL is organised](./about/how-smufl-is-organised.md)
  * [Recommended characters and optional glyphs](./about/recommended-chars-optional-glyphs.md)
  * [Implementations](./about/implementations.md)
  * [Sources for symbols](./about/sources-for-symbols.md)
  * [Other contributors](./about/other-contributors.md)
  * [Missing symbols](./about/missing-symbols.md)
* [Specification](./specification/index.md)
  * [Metadata for SMuFL glyphs and ranges](./specification/smufl-metadata.md)
    * [glyphnames.json](./specification/glyphnames.md)
    * [classes.json](./specification/classes.md)
    * [ranges.json](./specification/ranges.md)
  * [Designing for scoring applications and text-based applications](./specification/scoring-vs-text-applications.md)
  * [Metrics and glyph registration for scoring applications](./specification/scoring-metrics-glyph-registration.md)
  * [Metadata for SMuFL-compliant fonts](./specification/font-specific-metadata.md)
    * [engravingDefaults](./specification/engravingdefaults.md)
    * [glyphAdvanceWidths](./specification/glyphadvancewidths.md)
    * [glyphsWithAnchors](./specification/glyphswithanchors.md)
    * [glyphsWithAlternates](./specification/glyphswithalternates.md)
    * [glyphBBoxes](./specification/glyphbboxes.md)
    * [ligatures](./specification/ligatures.md)
    * [sets](./specification/sets.md)
    * [optionalGlyphs](./specification/optionalglyphs.md)
  * [Example of glyph registration for notes with flags](./specification/glyph-registration-notes-flags.md)
  * [Bounding box cut-outs](./specification/bbox-cut-outs.md)
  * [Repeat offsets](./specification/repeat-offsets.md)
  * [Aligning noteheads horizontally](./specification/aligning-noteheads-horizontally.md)
  * [Aligning dynamics with noteheads and stems](./specification/aligning-dynamics.md)
  * [Metrics and glyph registration for text-based applications](./specification/text-metrics-glyph-registration.md)
  * [Font-specific metadata locations](./specification/font-metadata-locations.md)
* [Glyph tables](./tables/index.md)
  * [Staff brackets and dividers](./tables/staff-brackets-and-dividers.md)
  * [Staves](./tables/staves.md)
  * [Barlines](./tables/barlines.md)
  * [Repeats](./tables/repeats.md)
  * [Clefs](./tables/clefs.md)
  * [Time signatures](./tables/time-signatures.md)
  * [Noteheads](./tables/noteheads.md)
  * [Slash noteheads](./tables/slash-noteheads.md)
  * [Round and square noteheads](./tables/round-and-square-noteheads.md)
  * [Note clusters](./tables/note-clusters.md)
  * [Note name noteheads](./tables/note-name-noteheads.md)
  * [Shape note noteheads](./tables/shape-note-noteheads.md)
  * [Individual notes](./tables/individual-notes.md)
  * [Beamed groups of notes](./tables/beamed-groups-of-notes.md)
  * [Stems](./tables/stems.md)
  * [Tremolos](./tables/tremolos.md)
  * [Flags](./tables/flags.md)
  * [Standard accidentals (12-EDO)](./tables/standard-accidentals-12-edo.md)
  * [Gould arrow quartertone accidentals (24-EDO)](./tables/gould-arrow-quartertone-accidentals-24-edo.md)
  * [Stein-Zimmermann accidentals (24-EDO)](./tables/stein-zimmermann-accidentals-24-edo.md)
  * [Extended Stein-Zimmermann accidentals](./tables/extended-stein-zimmermann-accidentals.md)
  * [Sims accidentals (72-EDO)](./tables/sims-accidentals-72-edo.md)
  * [Johnston accidentals (just intonation)](./tables/johnston-accidentals-just-intonation.md)
  * [Extended Helmholtz-Ellis accidentals (just intonation)](./tables/extended-helmholtz-ellis-accidentals-just-intonation.md)
  * [Spartan Sagittal single-shaft accidentals](./tables/spartan-sagittal-single-shaft-accidentals.md)
  * [Spartan Sagittal multi-shaft accidentals](./tables/spartan-sagittal-multi-shaft-accidentals.md)
  * [Athenian Sagittal extension (medium precision) accidentals](./tables/athenian-sagittal-extension-medium-precision-accidentals.md)
  * [Trojan Sagittal extension (12-EDO relative) accidentals](./tables/trojan-sagittal-extension-12-edo-relative-accidentals.md)
  * [Promethean Sagittal extension (high precision) single-shaft accidentals](./tables/promethean-sagittal-extension-high-precision-single-shaft-accidentals.md)
  * [Promethean Sagittal extension (high precision) multi-shaft accidentals](./tables/promethean-sagittal-extension-high-precision-multi-shaft-accidentals.md)
  * [Herculean Sagittal extension (very high precision) accidental diacritics](./tables/herculean-sagittal-extension-very-high-precision-accidental-diacritics.md)
  * [Olympian Sagittal extension (extreme precision) accidental diacritics](./tables/olympian-sagittal-extension-extreme-precision-accidental-diacritics.md)
  * [Magrathean Sagittal extension (insane precision) accidental diacritics](./tables/magrathean-sagittal-extension-insane-precision-accidental-diacritics.md)
  * [Wyschnegradsky accidentals (72-EDO)](./tables/wyschnegradsky-accidentals-72-edo.md)
  * [Arel-Ezgi-Uzdilek (AEU) accidentals](./tables/arel-ezgi-uzdilek-aeu-accidentals.md)
  * [Turkish folk music accidentals](./tables/turkish-folk-music-accidentals.md)
  * [Persian accidentals](./tables/persian-accidentals.md)
  * [Other accidentals](./tables/other-accidentals.md)
  * [Articulation](./tables/articulation.md)
  * [Holds and pauses](./tables/holds-and-pauses.md)
  * [Rests](./tables/rests.md)
  * [Bar repeats](./tables/bar-repeats.md)
  * [Octaves](./tables/octaves.md)
  * [Dynamics](./tables/dynamics.md)
  * [Lyrics](./tables/lyrics.md)
  * [Common ornaments](./tables/common-ornaments.md)
  * [Other baroque ornaments](./tables/other-baroque-ornaments.md)
  * [Combining strokes for trills and mordents](./tables/combining-strokes-for-trills-and-mordents.md)
  * [Precomposed trills and mordents](./tables/precomposed-trills-and-mordents.md)
  * [Brass techniques](./tables/brass-techniques.md)
  * [Wind techniques](./tables/wind-techniques.md)
  * [String techniques](./tables/string-techniques.md)
  * [Plucked techniques](./tables/plucked-techniques.md)
  * [Vocal techniques](./tables/vocal-techniques.md)
  * [Keyboard techniques](./tables/keyboard-techniques.md)
  * [Harp techniques](./tables/harp-techniques.md)
  * [Tuned mallet percussion pictograms](./tables/tuned-mallet-percussion-pictograms.md)
  * [Chimes pictograms](./tables/chimes-pictograms.md)
  * [Drums pictograms](./tables/drums-pictograms.md)
  * [Wooden struck or scraped percussion pictograms](./tables/wooden-struck-or-scraped-percussion-pictograms.md)
  * [Metallic struck percussion pictograms](./tables/metallic-struck-percussion-pictograms.md)
  * [Bells pictograms](./tables/bells-pictograms.md)
  * [Cymbals pictograms](./tables/cymbals-pictograms.md)
  * [Gongs pictograms](./tables/gongs-pictograms.md)
  * [Shakers or rattles pictograms](./tables/shakers-or-rattles-pictograms.md)
  * [Whistles and aerophones pictograms](./tables/whistles-and-aerophones-pictograms.md)
  * [Miscellaneous percussion instrument pictograms](./tables/miscellaneous-percussion-instrument-pictograms.md)
  * [Beaters pictograms](./tables/beaters-pictograms.md)
  * [Percussion playing technique pictograms](./tables/percussion-playing-technique-pictograms.md)
  * [Handbells](./tables/handbells.md)
  * [Guitar](./tables/guitar.md)
  * [Chord diagrams](./tables/chord-diagrams.md)
  * [Analytics](./tables/analytics.md)
  * [Chord symbols](./tables/chord-symbols.md)
  * [Tuplets](./tables/tuplets.md)
  * [Conductor symbols](./tables/conductor-symbols.md)
  * [Accordion](./tables/accordion.md)
  * [Beams and slurs](./tables/beams-and-slurs.md)
  * [Medieval and Renaissance staves](./tables/medieval-and-renaissance-staves.md)
  * [Medieval and Renaissance clefs](./tables/medieval-and-renaissance-clefs.md)
  * [Medieval and Renaissance prolations](./tables/medieval-and-renaissance-prolations.md)
  * [Medieval and Renaissance noteheads and stems](./tables/medieval-and-renaissance-noteheads-and-stems.md)
  * [Medieval and Renaissance individual notes](./tables/medieval-and-renaissance-individual-notes.md)
  * [Medieval and Renaissance oblique forms](./tables/medieval-and-renaissance-oblique-forms.md)
  * [Medieval and Renaissance plainchant single-note forms](./tables/medieval-and-renaissance-plainchant-single-note-forms.md)
  * [Medieval and Renaissance plainchant multiple-note forms](./tables/medieval-and-renaissance-plainchant-multiple-note-forms.md)
  * [Medieval and Renaissance plainchant articulations](./tables/medieval-and-renaissance-plainchant-articulations.md)
  * [Medieval and Renaissance accidentals](./tables/medieval-and-renaissance-accidentals.md)
  * [Medieval and Renaissance rests](./tables/medieval-and-renaissance-rests.md)
  * [Medieval and Renaissance miscellany](./tables/medieval-and-renaissance-miscellany.md)
  * [Medieval and Renaissance symbols in CMN](./tables/medieval-and-renaissance-symbols-in-cmn.md)
  * [Daseian notation](./tables/daseian-notation.md)
  * [Figured bass](./tables/figured-bass.md)
  * [Function theory symbols](./tables/function-theory-symbols.md)
  * [Multi-segment lines](./tables/multi-segment-lines.md)
  * [Electronic music pictograms](./tables/electronic-music-pictograms.md)
  * [Arrows and arrowheads](./tables/arrows-and-arrowheads.md)
  * [Combining staff positions](./tables/combining-staff-positions.md)
  * [Renaissance lute tablature](./tables/renaissance-lute-tablature.md)
  * [French and English Renaissance lute tablature](./tables/french-and-english-renaissance-lute-tablature.md)
  * [Italian and Spanish Renaissance lute tablature](./tables/italian-and-spanish-renaissance-lute-tablature.md)
  * [German Renaissance lute tablature](./tables/german-renaissance-lute-tablature.md)
  * [Kievan square notation](./tables/kievan-square-notation.md)
  * [Kodály hand signs](./tables/kodaly-hand-signs.md)
  * [Simplified Music Notation](./tables/simplified-music-notation.md)
  * [Miscellaneous symbols](./tables/miscellaneous-symbols.md)
  * [Time signatures supplement](./tables/time-signatures-supplement.md)
  * [Octaves supplement](./tables/octaves-supplement.md)
  * [Metronome marks](./tables/metronome-marks.md)
  * [Figured bass supplement](./tables/figured-bass-supplement.md)
  * [Shape note noteheads supplement](./tables/shape-note-noteheads-supplement.md)
  * [Turned time signatures](./tables/turned-time-signatures.md)
  * [Reversed time signatures](./tables/reversed-time-signatures.md)
  * [Function theory symbols supplement](./tables/function-theory-symbols-supplement.md)
  * [Fingering](./tables/fingering.md)
  * [Arabic accidentals](./tables/arabic-accidentals.md)
  * [Articulation supplement](./tables/articulation-supplement.md)
  * [Stockhausen accidentals (24-EDO)](./tables/stockhausen-accidentals-24-edo.md)
  * [Standard accidentals for chord symbols](./tables/standard-accidentals-for-chord-symbols.md)
  * [Clefs supplement](./tables/clefs-supplement.md)
  * [Fingering supplement](./tables/fingering-supplement.md)
  * [Kahnotation](./tables/kahnotation.md)
  * [German organ tablature](./tables/german-organ-tablature.md)
  * [Extended Helmholtz-Ellis accidentals (just intonation) supplement](./tables/extended-helmholtz-ellis-accidentals-just-intonation-supplement.md)
  * [Other accidentals supplement](./tables/other-accidentals-supplement.md)
  * [Techniques noteheads](./tables/techniques-noteheads.md)
  * [Chop (percussive bowing) notation](./tables/chop-percussive-bowing-notation.md)
  * [Medieval and Renaissance prolations supplement](./tables/medieval-and-renaissance-prolations-supplement.md)
  * [Noteheads supplement](./tables/noteheads-supplement.md)
  * [Note name noteheads supplement](./tables/note-name-noteheads-supplement.md)
  * [Scale degrees](./tables/scale-degrees.md)