# Similar and adjacent projects

I collected in this list (almost) all projects related to exporting/handling/converting/migrating Evernote data.

## Export

Project                                                                                    |  Description                                                                                                      |  Language
-------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------|----------------
[ExportAllEverNote](https://github.com/dong-s/ExportAllEverNote)                           |  Export notes in ENEX format driectly from your account                                                           |  Python
[evernote2](https://github.com/JackonYang/evernote2)                                       |  Improved version of standard Evernote SDK. Also provides a tool for exporting notes driectly from your account   |  Python
[evernote-to-sqlite](https://github.com/dogsheep/evernote-to-sqlite)                       |  Converts ENEX files into SQLite database                                                                         |  Python
[enote](https://github.com/tkjacobsen/enote)                                               |  Utility that can backup Evernote notes and notebooks                                                             |  Python
[evernote-exporter](https://github.com/shawndaniel/evernote-exporter)                      |  Export notes from old Evernote local database .exb format                                                        |  Python

## Export / Sync

Project                                                                                    |  Description                                                                                                      |  Language
-------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------|----------------
[SyncToGit](https://github.com/KostyaEsmukov/SyncToGit)                                    |  Syncs your notes with their resources to the git repository in HTML format                                       |  Python
[evermark](https://github.com/akuma/evermark)                                              |  A command line tool for syncing markdown notes to Evernote                                                       |  JavaScript
[eversync](https://github.com/yejianye/eversync)                                           |  Sync your local directories with evernote notebooks                                                              |  Python
[EverMark](https://github.com/liuwons/EverMark)                                            |  A tool that can sync local markdown/text notes to Evernote                                                       |  Python
[LocalEvernote](https://github.com/lwabish/LocalEvernote)                                  |  Syncs local directory containing notes in Markdown format with Evernote                                          |  Python

## Conversion / Parsing

Project                                                                                    |  Description                                                                                                      |  Language
-------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------|----------------
[evernote2md](https://github.com/wormi4ok/evernote2md)                                     |  CLI tool to convert Evernote notes exported in *.enex format to a directory with markdown files                  |  Go
[yarle](https://github.com/akosbalasko/yarle)                                              |  Ultimate converter of Evernote notes to Markdown                                                                 |  TypeScript
[dumper](https://github.com/notable/dumper)                                                |  Library for extracting attachments, notes and metadata out of formats used by popular note-taking apps           |  TypeScript
[evernote-dump](https://github.com/exomut/evernote-dump)                                   |  Exports and extracts Evernote notes and attachments from .enex files                                             |  Python
[enex2md](https://github.com/janik6n/enex2md)                                              |  CLI utility to convert Evernote export files (*.enex) to GitHub Flavored Markdown                                |  Python
[enml2md](https://github.com/zerobase/enml2md)                                             |  Converts an Evernote export format (ENML, .enex) into Markdown (.md) files                                       |  CoffeeScript
[enml2html](https://github.com/everblogjs/enml2html)                                       |  Parse ENML to HTML, used by everblog                                                                             |  JavaScript
[evernote_parser](https://github.com/push-things/evernote_parser)                          |  Evernote Parser to export your notes in HTML or Markdown                                                         |  Python
[evernote2turtl](https://github.com/magnusmanske/evernote2turtl)                           |  Converts an Evernote ENEX into turtl backup format                                                               |  Rust
[sntools](https://github.com/standardnotes/sntools)                                        |  Evernote converter and other tools                                                                               |  JavaScript

## Migration

Project                                                                                    |  Description                                                                                                      |  Language
-------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------|----------------
[evernote-to-raindrop-exporter](https://github.com/luhmann/evernote-to-raindrop-exporter)  |  Exports Evernote notes to raindrop.io                                                                            |  TypeScript
[ever2simple](https://github.com/claytron/ever2simple)                                     |  Migrate from Evernote to simplenote with markdown formatting                                                     |  Python
[ever2boost](https://github.com/BoostIO/ever2boost)                                        |  Exports Evernote notes to Boostnote                                                                              |  Ruby
[EverOrg](https://github.com/mgmart/EverOrg)                                               |  Exports Evernote notes to MobileOrg                                                                              |  Go
[notexfr](https://github.com/rafaelespinoza/notexfr)                                       |  Exports Evernote data into StandardNotes format                                                                  |  Go
[everlink](https://github.com/msbentley/everlink)                                          |  Helps to migrate notes from Evernote to Joplin                                                                   |  Python
[enex2laverna](https://github.com/m00rt1/enex2laverna)                                     |  Exports Evernote notes to Laverna                                                                                |  Python
[evernote2dayone](https://github.com/hollyxu/evernote2dayone)                              |  Migrate exported notes from Evernote into individual entries in DayOne                                           |  JavaScript

## Alternative Evernote clients (CLI)

Project                                                                                    |  Description                                                                                                      |  Language
-------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------|----------------
[geeknote](https://github.com/VitaliyRodnenko/geeknote)                                    |  Command line client for Evernote                                                                                 |  Python
[clinote](https://github.com/TcM1911/clinote)                                              |  Command line client for Evernote inspired by geeknote                                                            |  Go
[not](https://github.com/lorencarvalho/not)                                                |  The quickest dirtiest cli Evernote client ever                                                                   |  Python
[Everpy](https://github.com/RealP/Everpy)                                                  |  An enhanced Evernote CLI                                                                                         |  Python
[evermutt](https://github.com/scootersmk/evermutt)                                         |  A ncurse based Evernote client with a look and feel similar to the Mutt mail client                              |  Python
[clevernote](https://github.com/dvj/clevernote)                                            |  A command line interface to Evernote                                                                             |  Python

## Alternative Evernote clients (GUI)

Project                                                                                    |  Description                                                                                                      |  Language
-------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------|----------------
[everpad](https://github.com/nvbn/everpad)                                                 |  Evernote client well integrated with linux desktop                                                               |  Python
[quentier](https://github.com/d1vanov/quentier)                                            |  Cross-platform desktop note taking app capable of working as Evernote client                                     |  C++
[nixnote2](https://github.com/robert7/nixnote2)                                            |  Evernote desktop client for Linux and macOS                                                                      |  C++
[whatever](https://github.com/sbrshk/whatever)                                             |  Lightweight unofficial Evernote client for Linux desktop                                                         |  JavaScript
[tusk](https://github.com/klaussinani/tusk)                                                |  Alternative cross-platform Evernote client                                                                       |  JavaScript
[wxNote](https://github.com/torinkwok/wxNote)                                              |  Open source copy of Evernote                                                                                     |  C++
[en4j](https://github.com/ecerulm/en4j)                                                    |  Java Desktop Client to Evernote                                                                                  |  Java
[hippo](https://github.com/Vytax/hippo)                                                    |  An open source client for Evernote                                                                               |  C++

## Plugins & Libraries

Project                                                                                    |  Description                                                                                                      |  Language
-------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------|----------------
[sublime-evernote](https://github.com/bordaigorl/sublime-evernote)                         |  Sublime Text plugin for Evernote                                                                                 |  Python
[evermonkey](https://github.com/michalyao/evermonkey)                                      |  VSCode plugin for Evernote                                                                                       |  TypeScript
[evernote-alfred](https://github.com/buginux/evernote-alfred)                              |  Alfred plugin for Evernote                                                                                       |  -
[alfred-evernote](https://github.com/shaoshing/alfred-evernote)                            |  Alfred plugin for Evernote                                                                                       |  JavaScript
[anknotes](https://github.com/brumar/anknotes)                                             |  Import Evernote notes into Anki                                                                                  |  Python
[AnkiEvernoteImporter](https://github.com/tansongchen/AnkiEvernoteImporter)                |  Import Evernote notes into Anki                                                                                  |  HTML
[enno](https://github.com/Jaymon/enno)                                                     |  Convenient wrapper around standard Evernote API SDK                                                              |  Python

## Other

Project                                                                                    |  Description                                                                                                      |  Language
-------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------|----------------
[enwrite](https://github.com/zzamboni/enwrite)                                             |  Evernote-powered statically-generated blogs and websites                                                         |  Ruby
[everblog](https://github.com/everblogjs/everblog)                                         |  Write blogs in your evernote                                                                                     |  JavaScript
[elephantBlog](https://github.com/jiangfb/elephantBlog)                                    |  Using Koa2 and base on Evernote API, publish your Evernote notes to personal website as blog                     |  JavaScript
[evernote-ocr](https://github.com/BradEstey/evernote-ocr)                                  |  Use the Evernote API to perform text recognition (OCR) on an image file                                          |  PHP
[evernote-telegram-bot](https://github.com/djudman/evernote-telegram-bot)                  |  This bot can save everything that you send to your Evernote account                                              |  Python
[gist-evernote](https://github.com/leemengtaiwan/gist-evernote)                            |  Sync your Github Gists and save them to your Evernote notebook as screenshots                                    |  Python
[evernote-url2clip](https://github.com/yell/evernote-url2clip)                             |  Clip webpages to Evernote from a text file                                                                       |  Python
[eversticky](https://github.com/itsmejoeeey/eversticky)                                    |  A Linux open-source sticky note client that syncs to Evernote                                                    |  C++
[random-note-universal](https://github.com/bjaanes/random-note-universal)                  |  Surface random notes from your Evernote account whenever you want                                                |  JavaScript
[toever](https://github.com/nissy/toever)                                                  |  Command-line tool to create a note to Evernote                                                                   |  Python
