/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.mathcollection;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.mXparser;
import org.mariuszgromada.math.mxparser.mathcollection.BinaryRelations;
import org.mariuszgromada.math.mxparser.mathcollection.MathFunctions;

public final class NumberTheory {
    public static final long DEFAULT_TO_FRACTION_INIT_SEARCH_SIZE = 10000L;
    private static long TO_FRACTION_INIT_SEARCH_SIZE = 10000L;

    public static final void setToFractionInitSearchSize(long l) {
        if (l >= 0L) {
            TO_FRACTION_INIT_SEARCH_SIZE = l;
        }
    }

    public static final long getToFractionInitSearchSize() {
        return TO_FRACTION_INIT_SEARCH_SIZE;
    }

    public static final double min(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        return Math.min(d, d2);
    }

    public static final double min(double ... dArray) {
        if (dArray == null) {
            return Double.NaN;
        }
        if (dArray.length == 0) {
            return Double.NaN;
        }
        double d = Double.POSITIVE_INFINITY;
        for (double d2 : dArray) {
            if (Double.isNaN(d2)) {
                return Double.NaN;
            }
            if (d2 < d) {
                d = d2;
            }
            if (!mXparser.isCurrentCalculationCancelled()) continue;
            return Double.NaN;
        }
        return d;
    }

    public static final double argmin(double ... dArray) {
        if (dArray == null) {
            return Double.NaN;
        }
        if (dArray.length == 0) {
            return Double.NaN;
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = -1.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = dArray[i];
            if (Double.isNaN(d3)) {
                return Double.NaN;
            }
            if (BinaryRelations.lt(d3, d) == 1.0) {
                d = d3;
                d2 = i;
            }
            if (!mXparser.isCurrentCalculationCancelled()) continue;
            return Double.NaN;
        }
        return d2 + 1.0;
    }

    public static final double max(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        return Math.max(d, d2);
    }

    public static final double max(double ... dArray) {
        if (dArray == null) {
            return Double.NaN;
        }
        if (dArray.length == 0) {
            return Double.NaN;
        }
        double d = Double.NEGATIVE_INFINITY;
        for (double d2 : dArray) {
            if (Double.isNaN(d2)) {
                return Double.NaN;
            }
            if (d2 > d) {
                d = d2;
            }
            if (!mXparser.isCurrentCalculationCancelled()) continue;
            return Double.NaN;
        }
        return d;
    }

    public static final double argmax(double ... dArray) {
        if (dArray == null) {
            return Double.NaN;
        }
        if (dArray.length == 0) {
            return Double.NaN;
        }
        double d = Double.NEGATIVE_INFINITY;
        double d2 = -1.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = dArray[i];
            if (Double.isNaN(d3)) {
                return Double.NaN;
            }
            if (BinaryRelations.gt(d3, d) == 1.0) {
                d = d3;
                d2 = i;
            }
            if (!mXparser.isCurrentCalculationCancelled()) continue;
            return Double.NaN;
        }
        return d2 + 1.0;
    }

    private static final void sortAsc(double[] dArray, int[] nArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        double d = dArray[(n + n2) / 2];
        while (true) {
            if (BinaryRelations.lt(dArray[n3], d) == 1.0) {
                ++n3;
                continue;
            }
            while (BinaryRelations.gt(dArray[n4], d) == 1.0) {
                --n4;
            }
            if (n3 <= n4) {
                double d2 = dArray[n3];
                dArray[n3] = dArray[n4];
                dArray[n4] = d2;
                int n5 = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n5;
                ++n3;
                --n4;
            }
            if (mXparser.isCurrentCalculationCancelled()) {
                return;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            NumberTheory.sortAsc(dArray, nArray, n, n4);
        }
        if (n3 < n2) {
            NumberTheory.sortAsc(dArray, nArray, n3, n2);
        }
    }

    public static final int[] sortAsc(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = i;
        }
        if (dArray.length < 2) {
            return nArray;
        }
        NumberTheory.sortAsc(dArray, nArray, 0, dArray.length - 1);
        return nArray;
    }

    public static final double[][] getDistValues(double[] dArray, boolean bl) {
        if (dArray == null) {
            return null;
        }
        double[][] dArray2 = new double[dArray.length][3];
        if (dArray.length == 0) {
            return dArray2;
        }
        if (dArray.length == 1) {
            dArray2[0][0] = dArray[0];
            dArray2[0][1] = 1.0;
            dArray2[0][2] = 0.0;
            return dArray2;
        }
        int[] nArray = NumberTheory.sortAsc(dArray);
        double d = dArray[0];
        int n = 1;
        int n2 = nArray[0];
        int n3 = 0;
        for (int i = 1; i < dArray.length && !mXparser.isCurrentCalculationCancelled(); ++i) {
            if (BinaryRelations.eq(d, dArray[i]) == 1.0) {
                ++n;
                if (nArray[i] < n2) {
                    n2 = nArray[i];
                }
            }
            if (BinaryRelations.eq(d, dArray[i]) == 0.0 && i < dArray.length - 1) {
                dArray2[n3][0] = d;
                dArray2[n3][1] = n;
                dArray2[n3][2] = n2;
                ++n3;
                d = dArray[i];
                n = 1;
                n2 = nArray[i];
                continue;
            }
            if (BinaryRelations.eq(d, dArray[i]) == 0.0 && i == dArray.length - 1) {
                dArray2[n3][0] = d;
                dArray2[n3][1] = n;
                dArray2[n3][2] = n2;
                dArray2[++n3][0] = dArray[i];
                dArray2[n3][1] = 1.0;
                dArray2[n3][2] = nArray[i];
                ++n3;
                continue;
            }
            if (i != dArray.length - 1) continue;
            dArray2[n3][0] = d;
            dArray2[n3][1] = n;
            dArray2[n3][2] = n2;
            ++n3;
        }
        double[][] dArray3 = new double[n3][3];
        double d2 = 0.0;
        for (int i = 0; i < n3 && !mXparser.isCurrentCalculationCancelled(); ++i) {
            dArray3[i][0] = dArray2[i][0];
            dArray3[i][1] = dArray2[i][1];
            dArray3[i][2] = dArray2[i][2];
            if (dArray2[i][1] > d2) {
                d2 = dArray2[i][1];
            }
            if (!(dArray2[i][2] > d2)) continue;
            d2 = dArray2[i][2];
        }
        if (!bl) {
            return dArray3;
        }
        d2 += 1.0;
        double[] dArray4 = new double[n3];
        for (int i = 0; i < n3 && !mXparser.isCurrentCalculationCancelled(); ++i) {
            dArray4[i] = (d2 - dArray2[i][1] - 1.0) * d2 + dArray2[i][2];
        }
        int[] nArray2 = NumberTheory.sortAsc(dArray4);
        for (int i = 0; i < n3 && !mXparser.isCurrentCalculationCancelled(); ++i) {
            dArray3[i][0] = dArray2[nArray2[i]][0];
            dArray3[i][1] = dArray2[nArray2[i]][1];
            dArray3[i][2] = dArray2[nArray2[i]][2];
        }
        return dArray3;
    }

    public static final double numberOfDistValues(double ... dArray) {
        if (dArray == null) {
            return Double.NaN;
        }
        if (dArray.length == 0) {
            return 0.0;
        }
        for (double d : dArray) {
            if (!Double.isNaN(d)) continue;
            return Double.NaN;
        }
        if (dArray.length == 1) {
            return 1.0;
        }
        return NumberTheory.getDistValues(dArray, false).length;
    }

    public static final long gcd(long l, long l2) {
        if (l < 0L) {
            l = -l;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        if (l == 0L && l2 != 0L) {
            return l2;
        }
        if (l != 0L && l2 == 0L) {
            return l;
        }
        if (l == 0L) {
            return -1L;
        }
        if (l2 == 0L) {
            return -1L;
        }
        if (l == l2) {
            return l;
        }
        while (l2 != 0L) {
            long l3;
            if (mXparser.isCurrentCalculationCancelled()) {
                return 0L;
            }
            if (l > l2) {
                l3 = l / l2 - 1L;
                if (l3 > 0L) {
                    l -= l2 * l3;
                    continue;
                }
                l -= l2;
                continue;
            }
            l3 = l2 / l - 1L;
            if (l3 > 0L) {
                l2 -= l * l3;
                continue;
            }
            l2 -= l;
        }
        return l;
    }

    public static final double gcd(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        d = MathFunctions.floor(MathFunctions.abs(d));
        d2 = MathFunctions.floor(MathFunctions.abs(d2));
        if (d == 0.0 && d2 != 0.0) {
            return d2;
        }
        if (d != 0.0 && d2 == 0.0) {
            return d;
        }
        if (d == 0.0) {
            return Double.NaN;
        }
        if (d2 == 0.0) {
            return Double.NaN;
        }
        if (d == d2) {
            return d;
        }
        while (d2 != 0.0) {
            double d3;
            if (mXparser.isCurrentCalculationCancelled()) {
                return Double.NaN;
            }
            if (d > d2) {
                d3 = Math.floor(d / d2) - 1.0;
                if (d3 > 0.0) {
                    d = Math.floor(d - d2 * d3);
                    continue;
                }
                d = Math.floor(d - d2);
                continue;
            }
            d3 = Math.floor(d2 / d) - 1.0;
            if (d3 > 0.0) {
                d2 = Math.floor(d2 - d * d3);
                continue;
            }
            d2 = Math.floor(d2 - d);
        }
        return d;
    }

    public static final long gcd(long ... lArray) {
        if (lArray == null) {
            return -1L;
        }
        if (lArray.length == 0) {
            return -1L;
        }
        if (lArray.length == 1) {
            if (lArray[0] >= 0L) {
                return lArray[0];
            }
            return -lArray[0];
        }
        if (lArray.length == 2) {
            return NumberTheory.gcd(lArray[0], lArray[1]);
        }
        for (int i = 1; i < lArray.length; ++i) {
            if (mXparser.isCurrentCalculationCancelled()) {
                return 0L;
            }
            lArray[i] = NumberTheory.gcd(lArray[i - 1], lArray[i]);
        }
        return lArray[lArray.length - 1];
    }

    public static final double gcd(double ... dArray) {
        if (dArray == null) {
            return Double.NaN;
        }
        if (dArray.length == 0) {
            return Double.NaN;
        }
        if (dArray.length == 1) {
            return MathFunctions.floor(MathFunctions.abs(dArray[0]));
        }
        if (dArray.length == 2) {
            return NumberTheory.gcd(dArray[0], dArray[1]);
        }
        for (int i = 1; i < dArray.length; ++i) {
            if (mXparser.isCurrentCalculationCancelled()) {
                return Double.NaN;
            }
            dArray[i] = NumberTheory.gcd(dArray[i - 1], dArray[i]);
        }
        return dArray[dArray.length - 1];
    }

    public static final long lcm(long l, long l2) {
        l = Math.abs(l);
        l2 = Math.abs(l2);
        if (l == 0L || l2 == 0L) {
            return 0L;
        }
        return l * l2 / NumberTheory.gcd(l, l2);
    }

    public static final double lcm(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d)) {
            return Double.NaN;
        }
        d = MathFunctions.floor(MathFunctions.abs(d));
        d2 = MathFunctions.floor(MathFunctions.abs(d2));
        return d * d2 / NumberTheory.gcd(d, d2);
    }

    public static final long lcm(long ... lArray) {
        if (lArray == null) {
            return -1L;
        }
        if (lArray.length == 0) {
            return -1L;
        }
        if (lArray.length == 1) {
            if (lArray[0] >= 0L) {
                return lArray[0];
            }
            return -lArray[0];
        }
        if (lArray.length == 2) {
            return NumberTheory.lcm(lArray[0], lArray[1]);
        }
        for (int i = 1; i < lArray.length; ++i) {
            if (mXparser.isCurrentCalculationCancelled()) {
                return 0L;
            }
            lArray[i] = NumberTheory.lcm(lArray[i - 1], lArray[i]);
        }
        return lArray[lArray.length - 1];
    }

    public static final double lcm(double ... dArray) {
        if (dArray == null) {
            return Double.NaN;
        }
        if (dArray.length == 0) {
            return Double.NaN;
        }
        if (dArray.length == 1) {
            MathFunctions.floor(MathFunctions.abs(dArray[0]));
        }
        if (dArray.length == 2) {
            return NumberTheory.lcm(dArray[0], dArray[1]);
        }
        for (int i = 1; i < dArray.length; ++i) {
            if (mXparser.isCurrentCalculationCancelled()) {
                return Double.NaN;
            }
            dArray[i] = NumberTheory.lcm(dArray[i - 1], dArray[i]);
        }
        return dArray[dArray.length - 1];
    }

    public static final double sum(double ... dArray) {
        if (dArray == null) {
            return Double.NaN;
        }
        if (dArray.length == 0) {
            return Double.NaN;
        }
        if (dArray.length == 1) {
            return dArray[0];
        }
        if (mXparser.checkIfCanonicalRounding()) {
            BigDecimal bigDecimal = BigDecimal.ZERO;
            for (double d : dArray) {
                if (Double.isNaN(d)) {
                    return Double.NaN;
                }
                if (Double.isInfinite(d)) {
                    return Double.NaN;
                }
                bigDecimal = bigDecimal.add(BigDecimal.valueOf(d));
                if (!mXparser.isCurrentCalculationCancelled()) continue;
                return Double.NaN;
            }
            return bigDecimal.doubleValue();
        }
        double d = 0.0;
        for (double d2 : dArray) {
            if (Double.isNaN(d2)) {
                return Double.NaN;
            }
            if (Double.isInfinite(d2)) {
                return Double.NaN;
            }
            d += d2;
            if (!mXparser.isCurrentCalculationCancelled()) continue;
            return Double.NaN;
        }
        return d;
    }

    public static final double prod(double ... dArray) {
        if (dArray == null) {
            return Double.NaN;
        }
        if (dArray.length == 0) {
            return Double.NaN;
        }
        if (dArray.length == 1) {
            return dArray[0];
        }
        if (mXparser.checkIfCanonicalRounding()) {
            BigDecimal bigDecimal = BigDecimal.ONE;
            for (double d : dArray) {
                if (Double.isNaN(d)) {
                    return Double.NaN;
                }
                if (Double.isInfinite(d)) {
                    return Double.NaN;
                }
                bigDecimal = bigDecimal.multiply(BigDecimal.valueOf(d));
                if (!mXparser.isCurrentCalculationCancelled()) continue;
                return Double.NaN;
            }
            return bigDecimal.doubleValue();
        }
        double d = 1.0;
        for (double d2 : dArray) {
            if (Double.isNaN(d2)) {
                return Double.NaN;
            }
            if (Double.isInfinite(d2)) {
                return Double.NaN;
            }
            d *= d2;
            if (!mXparser.isCurrentCalculationCancelled()) continue;
            return Double.NaN;
        }
        return d;
    }

    public static final boolean primeTest(long l) {
        long l2;
        if (l == 2L) {
            return true;
        }
        if (l % 2L == 0L) {
            return false;
        }
        if (l <= 1L) {
            return false;
        }
        long l3 = (long)Math.sqrt(l);
        long l4 = 3L;
        if (mXparser.primesCache != null && mXparser.primesCache.cacheStatus) {
            long l5;
            if (l <= (long)mXparser.primesCache.maxNumInCache) {
                return mXparser.primesCache.isPrime[(int)l];
            }
            l2 = Math.min(l3, (long)mXparser.primesCache.maxNumInCache);
            for (l5 = 3L; l5 <= l2; l5 += 2L) {
                if (mXparser.primesCache.isPrime[(int)l5] && l % l5 == 0L) {
                    return false;
                }
                if (!mXparser.isCurrentCalculationCancelled()) continue;
                return false;
            }
            l4 = l5;
        }
        for (l2 = l4; l2 <= l3; l2 += 2L) {
            if (l % l2 == 0L) {
                return false;
            }
            if (!mXparser.isCurrentCalculationCancelled()) continue;
            return false;
        }
        return true;
    }

    public static final double primeTest(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        boolean bl = NumberTheory.primeTest((long)d);
        if (bl) {
            return 1.0;
        }
        return 0.0;
    }

    public static final long primeCount(long l) {
        if (l <= 1L) {
            return 0L;
        }
        if (l == 2L) {
            return 1L;
        }
        long l2 = 1L;
        for (long i = 3L; i <= l; ++i) {
            if (mXparser.isCurrentCalculationCancelled()) {
                return 0L;
            }
            if (!NumberTheory.primeTest(i)) continue;
            ++l2;
        }
        return l2;
    }

    public static final double primeCount(double d) {
        return NumberTheory.primeCount((long)d);
    }

    public static final double sigmaSummation(Expression expression, Argument argument, double d, double d2, double d3) {
        if (Double.isNaN(d3) || Double.isNaN(d) || Double.isNaN(d2) || d3 == 0.0) {
            return Double.NaN;
        }
        if (mXparser.checkIfCanonicalRounding()) {
            BigDecimal bigDecimal = BigDecimal.ZERO;
            if (d2 >= d && d3 > 0.0) {
                double d4;
                double d5;
                for (d5 = d; d5 < d2; d5 += d3) {
                    if (mXparser.isCurrentCalculationCancelled()) {
                        return Double.NaN;
                    }
                    d4 = mXparser.getFunctionValue(expression, argument, d5);
                    if (Double.isNaN(d4) || Double.isInfinite(d4)) {
                        return Double.NaN;
                    }
                    bigDecimal = bigDecimal.add(BigDecimal.valueOf(d4));
                }
                if (d3 - (d5 - d2) > 0.5 * d3) {
                    d4 = mXparser.getFunctionValue(expression, argument, d2);
                    if (Double.isNaN(d4) || Double.isInfinite(d4)) {
                        return Double.NaN;
                    }
                    bigDecimal = bigDecimal.add(BigDecimal.valueOf(d4));
                }
            } else if (d2 <= d && d3 < 0.0) {
                double d6;
                double d7;
                for (d7 = d; d7 > d2; d7 += d3) {
                    if (mXparser.isCurrentCalculationCancelled()) {
                        return Double.NaN;
                    }
                    d6 = mXparser.getFunctionValue(expression, argument, d7);
                    if (Double.isNaN(d6) || Double.isInfinite(d6)) {
                        return Double.NaN;
                    }
                    bigDecimal = bigDecimal.add(BigDecimal.valueOf(d6));
                }
                if (-d3 - (d2 - d7) > -0.5 * d3) {
                    d6 = mXparser.getFunctionValue(expression, argument, d2);
                    if (Double.isNaN(d6) || Double.isInfinite(d6)) {
                        return Double.NaN;
                    }
                    bigDecimal = bigDecimal.add(BigDecimal.valueOf(d6));
                }
            } else if (d == d2) {
                double d8 = mXparser.getFunctionValue(expression, argument, d);
                if (Double.isNaN(d8) || Double.isInfinite(d8)) {
                    return Double.NaN;
                }
                bigDecimal = bigDecimal.add(BigDecimal.valueOf(d8));
            }
            return bigDecimal.doubleValue();
        }
        double d9 = 0.0;
        if (d2 >= d && d3 > 0.0) {
            double d10;
            double d11;
            for (d11 = d; d11 < d2; d11 += d3) {
                if (mXparser.isCurrentCalculationCancelled()) {
                    return Double.NaN;
                }
                d10 = mXparser.getFunctionValue(expression, argument, d11);
                if (Double.isNaN(d10) || Double.isInfinite(d10)) {
                    return Double.NaN;
                }
                d9 += d10;
            }
            if (d3 - (d11 - d2) > 0.5 * d3) {
                d10 = mXparser.getFunctionValue(expression, argument, d2);
                if (Double.isNaN(d10) || Double.isInfinite(d10)) {
                    return Double.NaN;
                }
                d9 += d10;
            }
        } else if (d2 <= d && d3 < 0.0) {
            double d12;
            double d13;
            for (d13 = d; d13 > d2; d13 += d3) {
                if (mXparser.isCurrentCalculationCancelled()) {
                    return Double.NaN;
                }
                d12 = mXparser.getFunctionValue(expression, argument, d13);
                if (Double.isNaN(d12) || Double.isInfinite(d12)) {
                    return Double.NaN;
                }
                d9 += d12;
            }
            if (-d3 - (d2 - d13) > -0.5 * d3) {
                d12 = mXparser.getFunctionValue(expression, argument, d2);
                if (Double.isNaN(d12) || Double.isInfinite(d12)) {
                    return Double.NaN;
                }
                d9 += d12;
            }
        } else if (d == d2) {
            double d14 = mXparser.getFunctionValue(expression, argument, d);
            if (Double.isNaN(d14) || Double.isInfinite(d14)) {
                return Double.NaN;
            }
            d9 += d14;
        }
        return d9;
    }

    public static final double piProduct(Expression expression, Argument argument, double d, double d2, double d3) {
        if (Double.isNaN(d3) || Double.isNaN(d) || Double.isNaN(d2) || d3 == 0.0) {
            return Double.NaN;
        }
        if (mXparser.checkIfCanonicalRounding()) {
            BigDecimal bigDecimal = BigDecimal.ONE;
            if (d2 >= d && d3 > 0.0) {
                double d4;
                double d5;
                for (d5 = d; d5 < d2; d5 += d3) {
                    if (mXparser.isCurrentCalculationCancelled()) {
                        return Double.NaN;
                    }
                    d4 = mXparser.getFunctionValue(expression, argument, d5);
                    if (Double.isNaN(d4) || Double.isInfinite(d4)) {
                        return Double.NaN;
                    }
                    bigDecimal = bigDecimal.multiply(BigDecimal.valueOf(d4));
                }
                if (d3 - (d5 - d2) > 0.5 * d3) {
                    d4 = mXparser.getFunctionValue(expression, argument, d2);
                    if (Double.isNaN(d4) || Double.isInfinite(d4)) {
                        return Double.NaN;
                    }
                    bigDecimal = bigDecimal.multiply(BigDecimal.valueOf(d4));
                }
            } else if (d2 <= d && d3 < 0.0) {
                double d6;
                double d7;
                for (d7 = d; d7 > d2; d7 += d3) {
                    if (mXparser.isCurrentCalculationCancelled()) {
                        return Double.NaN;
                    }
                    d6 = mXparser.getFunctionValue(expression, argument, d7);
                    if (Double.isNaN(d6) || Double.isInfinite(d6)) {
                        return Double.NaN;
                    }
                    bigDecimal = bigDecimal.multiply(BigDecimal.valueOf(d6));
                }
                if (-d3 - (d2 - d7) > -0.5 * d3) {
                    d6 = mXparser.getFunctionValue(expression, argument, d2);
                    if (Double.isNaN(d6) || Double.isInfinite(d6)) {
                        return Double.NaN;
                    }
                    bigDecimal = bigDecimal.multiply(BigDecimal.valueOf(d6));
                }
            } else if (d == d2) {
                double d8 = mXparser.getFunctionValue(expression, argument, d);
                if (Double.isNaN(d8) || Double.isInfinite(d8)) {
                    return Double.NaN;
                }
                bigDecimal = bigDecimal.multiply(BigDecimal.valueOf(d8));
            }
            return bigDecimal.doubleValue();
        }
        double d9 = 1.0;
        if (d2 >= d && d3 > 0.0) {
            double d10;
            double d11;
            for (d11 = d; d11 < d2; d11 += d3) {
                if (mXparser.isCurrentCalculationCancelled()) {
                    return Double.NaN;
                }
                d10 = mXparser.getFunctionValue(expression, argument, d11);
                if (Double.isNaN(d10) || Double.isInfinite(d10)) {
                    return Double.NaN;
                }
                d9 *= d10;
            }
            if (d3 - (d11 - d2) > 0.5 * d3) {
                d10 = mXparser.getFunctionValue(expression, argument, d2);
                if (Double.isNaN(d10) || Double.isInfinite(d10)) {
                    return Double.NaN;
                }
                d9 *= d10;
            }
        } else if (d2 <= d && d3 < 0.0) {
            double d12;
            double d13;
            for (d13 = d; d13 > d2; d13 += d3) {
                if (mXparser.isCurrentCalculationCancelled()) {
                    return Double.NaN;
                }
                d12 = mXparser.getFunctionValue(expression, argument, d13);
                if (Double.isNaN(d12) || Double.isInfinite(d12)) {
                    return Double.NaN;
                }
                d9 *= d12;
            }
            if (-d3 - (d2 - d13) > -0.5 * d3) {
                d12 = mXparser.getFunctionValue(expression, argument, d2);
                if (Double.isNaN(d12) || Double.isInfinite(d12)) {
                    return Double.NaN;
                }
                d9 *= d12;
            }
        } else if (d == d2) {
            double d14 = mXparser.getFunctionValue(expression, argument, d);
            if (Double.isNaN(d14) || Double.isInfinite(d14)) {
                return Double.NaN;
            }
            d9 *= d14;
        }
        return d9;
    }

    public static final double min(Expression expression, Argument argument, double d, double d2, double d3) {
        if (Double.isNaN(d3) || Double.isNaN(d) || Double.isNaN(d2) || d3 == 0.0) {
            return Double.NaN;
        }
        double d4 = Double.POSITIVE_INFINITY;
        if (d2 >= d && d3 > 0.0) {
            double d5;
            for (double d6 = d; d6 < d2; d6 += d3) {
                if (mXparser.isCurrentCalculationCancelled()) {
                    return Double.NaN;
                }
                d5 = mXparser.getFunctionValue(expression, argument, d6);
                if (!(d5 < d4)) continue;
                d4 = d5;
            }
            d5 = mXparser.getFunctionValue(expression, argument, d2);
            if (d5 < d4) {
                d4 = d5;
            }
        } else if (d2 <= d && d3 < 0.0) {
            double d7;
            for (double d8 = d; d8 > d2; d8 += d3) {
                if (mXparser.isCurrentCalculationCancelled()) {
                    return Double.NaN;
                }
                d7 = mXparser.getFunctionValue(expression, argument, d8);
                if (!(d7 < d4)) continue;
                d4 = d7;
            }
            d7 = mXparser.getFunctionValue(expression, argument, d2);
            if (d7 < d4) {
                d4 = d7;
            }
        } else if (d == d2) {
            d4 = mXparser.getFunctionValue(expression, argument, d);
        }
        return d4;
    }

    public static final double max(Expression expression, Argument argument, double d, double d2, double d3) {
        if (Double.isNaN(d3) || Double.isNaN(d) || Double.isNaN(d2) || d3 == 0.0) {
            return Double.NaN;
        }
        double d4 = Double.NEGATIVE_INFINITY;
        if (d2 >= d && d3 > 0.0) {
            double d5;
            for (double d6 = d; d6 < d2; d6 += d3) {
                if (mXparser.isCurrentCalculationCancelled()) {
                    return Double.NaN;
                }
                d5 = mXparser.getFunctionValue(expression, argument, d6);
                if (!(d5 > d4)) continue;
                d4 = d5;
            }
            d5 = mXparser.getFunctionValue(expression, argument, d2);
            if (d5 > d4) {
                d4 = d5;
            }
        } else if (d2 <= d && d3 < 0.0) {
            double d7;
            for (double d8 = d; d8 > d2; d8 += d3) {
                if (mXparser.isCurrentCalculationCancelled()) {
                    return Double.NaN;
                }
                d7 = mXparser.getFunctionValue(expression, argument, d8);
                if (!(d7 > d4)) continue;
                d4 = d7;
            }
            d7 = mXparser.getFunctionValue(expression, argument, d2);
            if (d7 > d4) {
                d4 = d7;
            }
        } else if (d == d2) {
            d4 = mXparser.getFunctionValue(expression, argument, d);
        }
        return d4;
    }

    private static final String getRegExpForNumeralSystem(int n) {
        switch (n) {
            case 1: {
                return "[+-]?[bB]1\\.(1)*";
            }
            case 2: {
                return "[+-]?[bB][2]?\\.[01]([01])*";
            }
            case 3: {
                return "[+-]?[bB]3\\.[0-2]([0-2])*";
            }
            case 4: {
                return "[+-]?[bB]4\\.[0-3]([0-3])*";
            }
            case 5: {
                return "[+-]?[bB]5\\.[0-4]([0-4])*";
            }
            case 6: {
                return "[+-]?[bB]6\\.[0-5]([0-5])*";
            }
            case 7: {
                return "[+-]?[bB]7\\.[0-6]([0-6])*";
            }
            case 8: {
                return "[+-]?([bB]8|[oO])\\.[0-7]([0-7])*";
            }
            case 9: {
                return "[+-]?[bB]9\\.[0-8]([0-8])*";
            }
            case 10: {
                return "[+-]?[bB]10\\.[0-9]([0-9])*";
            }
            case 11: {
                return "[+-]?[bB]11\\.[0-9aA]([0-9aA])*";
            }
            case 12: {
                return "[+-]?[bB]12\\.[0-9a-bA-B]([0-9a-bA-B])*";
            }
            case 13: {
                return "[+-]?[bB]13\\.[0-9a-cA-C]([0-9a-cA-C])*";
            }
            case 14: {
                return "[+-]?[bB]14\\.[0-9a-dA-D]([0-9a-dA-D])*";
            }
            case 15: {
                return "[+-]?[bB]15\\.[0-9a-eA-E]([0-9a-eA-E])*";
            }
            case 16: {
                return "[+-]?([bB]16|[hH])\\.[0-9a-fA-F]([0-9a-fA-F])*";
            }
            case 17: {
                return "[+-]?[bB]17\\.[0-9a-gA-G]([0-9a-gA-G])*";
            }
            case 18: {
                return "[+-]?[bB]18\\.[0-9a-hA-H]([0-9a-hA-H])*";
            }
            case 19: {
                return "[+-]?[bB]19\\.[0-9a-iA-I]([0-9a-iA-I])*";
            }
            case 20: {
                return "[+-]?[bB]20\\.[0-9a-jA-J]([0-9a-jA-J])*";
            }
            case 21: {
                return "[+-]?[bB]21\\.[0-9a-kA-K]([0-9a-kA-K])*";
            }
            case 22: {
                return "[+-]?[bB]22\\.[0-9a-lA-L]([0-9a-lA-L])*";
            }
            case 23: {
                return "[+-]?[bB]23\\.[0-9a-mA-M]([0-9a-mA-M])*";
            }
            case 24: {
                return "[+-]?[bB]24\\.[0-9a-nA-N]([0-9a-nA-N])*";
            }
            case 25: {
                return "[+-]?[bB]25\\.[0-9a-oA-O]([0-9a-oA-O])*";
            }
            case 26: {
                return "[+-]?[bB]26\\.[0-9a-pA-P]([0-9a-pA-P])*";
            }
            case 27: {
                return "[+-]?[bB]27\\.[0-9a-qA-Q]([0-9a-qA-Q])*";
            }
            case 28: {
                return "[+-]?[bB]28\\.[0-9a-rA-R]([0-9a-rA-R])*";
            }
            case 29: {
                return "[+-]?[bB]29\\.[0-9a-sA-S]([0-9a-sA-S])*";
            }
            case 30: {
                return "[+-]?[bB]30\\.[0-9a-tA-T]([0-9a-tA-T])*";
            }
            case 31: {
                return "[+-]?[bB]31\\.[0-9a-uA-U]([0-9a-uA-U])*";
            }
            case 32: {
                return "[+-]?[bB]32\\.[0-9a-vA-V]([0-9a-vA-V])*";
            }
            case 33: {
                return "[+-]?[bB]33\\.[0-9a-wA-W]([0-9a-wA-W])*";
            }
            case 34: {
                return "[+-]?[bB]34\\.[0-9a-xA-X]([0-9a-xA-X])*";
            }
            case 35: {
                return "[+-]?[bB]35\\.[0-9a-yA-Y]([0-9a-yA-Y])*";
            }
            case 36: {
                return "[+-]?[bB]36\\.[0-9a-zA-Z]([0-9a-zA-Z])*";
            }
        }
        return "\\b\\B";
    }

    public static final int digitIndex(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': {
                return 10;
            }
            case 'B': {
                return 11;
            }
            case 'C': {
                return 12;
            }
            case 'D': {
                return 13;
            }
            case 'E': {
                return 14;
            }
            case 'F': {
                return 15;
            }
            case 'G': {
                return 16;
            }
            case 'H': {
                return 17;
            }
            case 'I': {
                return 18;
            }
            case 'J': {
                return 19;
            }
            case 'K': {
                return 20;
            }
            case 'L': {
                return 21;
            }
            case 'M': {
                return 22;
            }
            case 'N': {
                return 23;
            }
            case 'O': {
                return 24;
            }
            case 'P': {
                return 25;
            }
            case 'Q': {
                return 26;
            }
            case 'R': {
                return 27;
            }
            case 'S': {
                return 28;
            }
            case 'T': {
                return 29;
            }
            case 'U': {
                return 30;
            }
            case 'V': {
                return 31;
            }
            case 'W': {
                return 32;
            }
            case 'X': {
                return 33;
            }
            case 'Y': {
                return 34;
            }
            case 'Z': {
                return 35;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
            case 'g': {
                return 16;
            }
            case 'h': {
                return 17;
            }
            case 'i': {
                return 18;
            }
            case 'j': {
                return 19;
            }
            case 'k': {
                return 20;
            }
            case 'l': {
                return 21;
            }
            case 'm': {
                return 22;
            }
            case 'n': {
                return 23;
            }
            case 'o': {
                return 24;
            }
            case 'p': {
                return 25;
            }
            case 'q': {
                return 26;
            }
            case 'r': {
                return 27;
            }
            case 's': {
                return 28;
            }
            case 't': {
                return 29;
            }
            case 'u': {
                return 30;
            }
            case 'v': {
                return 31;
            }
            case 'w': {
                return 32;
            }
            case 'x': {
                return 33;
            }
            case 'y': {
                return 34;
            }
            case 'z': {
                return 35;
            }
        }
        return -1;
    }

    public static final char digitChar(int n) {
        switch (n) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return 'A';
            }
            case 11: {
                return 'B';
            }
            case 12: {
                return 'C';
            }
            case 13: {
                return 'D';
            }
            case 14: {
                return 'E';
            }
            case 15: {
                return 'F';
            }
            case 16: {
                return 'G';
            }
            case 17: {
                return 'H';
            }
            case 18: {
                return 'I';
            }
            case 19: {
                return 'J';
            }
            case 20: {
                return 'K';
            }
            case 21: {
                return 'L';
            }
            case 22: {
                return 'M';
            }
            case 23: {
                return 'N';
            }
            case 24: {
                return 'O';
            }
            case 25: {
                return 'P';
            }
            case 26: {
                return 'Q';
            }
            case 27: {
                return 'R';
            }
            case 28: {
                return 'S';
            }
            case 29: {
                return 'T';
            }
            case 30: {
                return 'U';
            }
            case 31: {
                return 'V';
            }
            case 32: {
                return 'W';
            }
            case 33: {
                return 'X';
            }
            case 34: {
                return 'Y';
            }
            case 35: {
                return 'Z';
            }
        }
        return '?';
    }

    public static final int getNumeralSystemBase(String string) {
        for (int i = 0; i <= 36; ++i) {
            if (!mXparser.regexMatch(string, NumberTheory.getRegExpForNumeralSystem(i))) continue;
            return i;
        }
        return -1;
    }

    public static final double convOthBase2Decimal(String string, int n) {
        if (string == null) {
            return Double.NaN;
        }
        if ((string = string.trim()).length() == 0) {
            if (n == 1) {
                return 0.0;
            }
            return Double.NaN;
        }
        if (n < 1) {
            return Double.NaN;
        }
        if (n > 36) {
            return Double.NaN;
        }
        char c = string.charAt(0);
        double d = 1.0;
        if (c == '-') {
            d = -1.0;
            string = string.substring(1);
        } else if (c == '+') {
            d = 1.0;
            string = string.substring(1);
        }
        int n2 = string.length();
        double d2 = 0.0;
        for (int i = 0; i < n2; ++i) {
            if (mXparser.isCurrentCalculationCancelled()) {
                return Double.NaN;
            }
            int n3 = NumberTheory.digitIndex(string.charAt(i));
            if (n > 1) {
                if (n3 >= 0 && n3 < n) {
                    d2 = (double)n * d2 + (double)n3;
                    continue;
                }
                return Double.NaN;
            }
            if (n3 == 1) {
                d2 = (double)n * d2 + (double)n3;
                continue;
            }
            return Double.NaN;
        }
        return d * d2;
    }

    public static final double convOthBase2Decimal(String string) {
        if (string == null) {
            return Double.NaN;
        }
        int n = (string = string.trim()).length();
        if (n < 2) {
            return Double.NaN;
        }
        int n2 = NumberTheory.getNumeralSystemBase(string);
        if (n2 == -1) {
            return Double.NaN;
        }
        int n3 = string.indexOf(46);
        if (n3 == 0) {
            return Double.NaN;
        }
        char c = string.charAt(0);
        double d = 1.0;
        if (c == '-') {
            d = -1.0;
        }
        String string2 = "";
        if (n > n3 + 1) {
            string2 = string.substring(n3 + 1);
        }
        return d * NumberTheory.convOthBase2Decimal(string2, n2);
    }

    public static final double convOthBase2Decimal(int n, int ... nArray) {
        if (n < 1) {
            return Double.NaN;
        }
        if (nArray == null) {
            return Double.NaN;
        }
        int n2 = nArray.length;
        if (n2 == 0) {
            if (n == 1) {
                return 0.0;
            }
            return Double.NaN;
        }
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            if (n > 1) {
                if (n3 >= 0 && n3 < n) {
                    d = (double)n * d + (double)n3;
                    continue;
                }
                return Double.NaN;
            }
            if (n3 == 1) {
                d = (double)n * d + (double)n3;
                continue;
            }
            return Double.NaN;
        }
        return d;
    }

    public static final double convOthBase2Decimal(double d, double ... dArray) {
        if (d < 0.0) {
            return Double.NaN;
        }
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        int n = (int)MathFunctions.floor(d);
        if (dArray == null) {
            return Double.NaN;
        }
        int n2 = dArray.length;
        if (n2 == 0) {
            if (n == 1) {
                return 0.0;
            }
            return Double.NaN;
        }
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            double d2 = dArray[i];
            if (Double.isNaN(d2)) {
                return Double.NaN;
            }
            nArray[i] = (int)d2;
        }
        return NumberTheory.convOthBase2Decimal(n, nArray);
    }

    public static final double convOthBase2Decimal(int[] nArray) {
        if (nArray == null) {
            return Double.NaN;
        }
        if (nArray.length == 0) {
            return Double.NaN;
        }
        int n = nArray[0];
        int[] nArray2 = new int[nArray.length - 1];
        for (int i = 1; i < nArray.length; ++i) {
            nArray2[i - 1] = nArray[i];
        }
        return NumberTheory.convOthBase2Decimal(n, nArray2);
    }

    public static final double convOthBase2Decimal(double[] dArray) {
        if (dArray == null) {
            return Double.NaN;
        }
        if (dArray.length == 0) {
            return Double.NaN;
        }
        double d = dArray[0];
        double[] dArray2 = new double[dArray.length - 1];
        for (int i = 1; i < dArray.length; ++i) {
            dArray2[i - 1] = dArray[i];
        }
        return NumberTheory.convOthBase2Decimal(d, dArray2);
    }

    public static final String convDecimal2OthBase(double d, int n) {
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (n < 1) {
            return "NaN";
        }
        if (n > 36) {
            return "NaN";
        }
        if (d == 0.0) {
            if (n > 1) {
                return "0";
            }
            return "";
        }
        double d2 = MathFunctions.floor(MathFunctions.abs(d));
        double d3 = MathFunctions.sgn(d);
        String string = "";
        if (d3 < 0.0) {
            string = "-";
        }
        if (d2 < (double)n) {
            return string + NumberTheory.digitChar((int)d2);
        }
        String string2 = "";
        double d4 = d2;
        if (n > 1) {
            while (d4 >= 1.0) {
                int n2 = (int)(d4 % (double)n);
                d4 = MathFunctions.floor(d4 / (double)n);
                string2 = NumberTheory.digitChar(n2) + string2;
            }
        } else {
            char[] cArray = new char[(int)d2];
            Arrays.fill(cArray, '1');
            string2 = new String(cArray);
        }
        return string + string2;
    }

    public static final String convDecimal2OthBase(double d, int n, int n2) {
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (n < 1) {
            return "NaN";
        }
        if (n > 36) {
            return "NaN";
        }
        String string = "";
        if (n2 == 1 || n2 == 2) {
            string = "b" + n + ".";
        }
        if (n2 == 2) {
            if (n == 2) {
                string = "b.";
            }
            if (n == 8) {
                string = "o.";
            }
            if (n == 16) {
                string = "h.";
            }
        }
        String string2 = "";
        if (d < 0.0) {
            string2 = "-";
        }
        return string2 + string + NumberTheory.convDecimal2OthBase(MathFunctions.abs(d), n);
    }

    public static final int numberOfDigits(long l) {
        if (l < 0L) {
            l = -l;
        }
        if (l < 10L) {
            return 1;
        }
        if (l < 100L) {
            return 2;
        }
        if (l < 1000L) {
            return 3;
        }
        if (l < 10000L) {
            return 4;
        }
        if (l < 100000L) {
            return 5;
        }
        if (l < 1000000L) {
            return 6;
        }
        if (l < 10000000L) {
            return 7;
        }
        if (l < 100000000L) {
            return 8;
        }
        if (l < 1000000000L) {
            return 9;
        }
        return 10;
    }

    public static final double numberOfDigits(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d)) {
            return Double.POSITIVE_INFINITY;
        }
        if (d < 0.0) {
            d = -d;
        }
        if ((d = MathFunctions.floor(d)) < 10.0) {
            return 1.0;
        }
        if (d < 100.0) {
            return 2.0;
        }
        if (d < 1000.0) {
            return 3.0;
        }
        if (d < 10000.0) {
            return 4.0;
        }
        if (d < 100000.0) {
            return 5.0;
        }
        if (d < 1000000.0) {
            return 6.0;
        }
        if (d < 1.0E7) {
            return 7.0;
        }
        if (d < 1.0E8) {
            return 8.0;
        }
        if (d < 1.0E9) {
            return 9.0;
        }
        if (d < 1.0E10) {
            return 10.0;
        }
        if (d < 1.0E11) {
            return 11.0;
        }
        if (d < 1.0E12) {
            return 12.0;
        }
        if (d < 1.0E13) {
            return 13.0;
        }
        if (d < 1.0E14) {
            return 14.0;
        }
        if (d < 1.0E15) {
            return 15.0;
        }
        if (d < 1.0E16) {
            return 16.0;
        }
        if (d < 1.0E17) {
            return 17.0;
        }
        if (d < 1.0E18) {
            return 18.0;
        }
        if (d < 1.0E19) {
            return 19.0;
        }
        if (d < 1.0E20) {
            return 20.0;
        }
        if (d < 1.0E21) {
            return 21.0;
        }
        if (d < 1.0E22) {
            return 22.0;
        }
        if (d < 1.0E23) {
            return 23.0;
        }
        if (d < 1.0E24) {
            return 24.0;
        }
        if (d < 1.0E25) {
            return 25.0;
        }
        if (d < 1.0E26) {
            return 26.0;
        }
        if (d < 1.0E27) {
            return 27.0;
        }
        if (d < 1.0E28) {
            return 28.0;
        }
        if (d < 1.0E29) {
            return 29.0;
        }
        if (d < 1.0E30) {
            return 30.0;
        }
        if (d < 1.0E31) {
            return 31.0;
        }
        if (d < 1.0E32) {
            return 32.0;
        }
        if (d < 1.0E33) {
            return 33.0;
        }
        if (d < 1.0E34) {
            return 34.0;
        }
        if (d < 1.0E35) {
            return 35.0;
        }
        if (d < 1.0E36) {
            return 36.0;
        }
        if (d < 1.0E37) {
            return 37.0;
        }
        if (d < 1.0E38) {
            return 38.0;
        }
        if (d < 1.0E39) {
            return 39.0;
        }
        if (d < 1.0E40) {
            return 40.0;
        }
        if (d < 1.0E41) {
            return 41.0;
        }
        if (d < 1.0E42) {
            return 42.0;
        }
        if (d < 1.0E43) {
            return 43.0;
        }
        if (d < 1.0E44) {
            return 44.0;
        }
        if (d < 1.0E45) {
            return 45.0;
        }
        if (d < 1.0E46) {
            return 46.0;
        }
        if (d < 1.0E47) {
            return 47.0;
        }
        if (d < 1.0E48) {
            return 48.0;
        }
        if (d < 1.0E49) {
            return 49.0;
        }
        if (d < 1.0E50) {
            return 50.0;
        }
        if (d < 1.0E51) {
            return 51.0;
        }
        if (d < 1.0E52) {
            return 52.0;
        }
        if (d < 1.0E53) {
            return 53.0;
        }
        if (d < 1.0E54) {
            return 54.0;
        }
        if (d < 1.0E55) {
            return 55.0;
        }
        if (d < 1.0E56) {
            return 56.0;
        }
        if (d < 1.0E57) {
            return 57.0;
        }
        if (d < 1.0E58) {
            return 58.0;
        }
        if (d < 1.0E59) {
            return 59.0;
        }
        if (d < 1.0E60) {
            return 60.0;
        }
        if (d < 1.0E61) {
            return 61.0;
        }
        if (d < 1.0E62) {
            return 62.0;
        }
        if (d < 1.0E63) {
            return 63.0;
        }
        if (d < 1.0E64) {
            return 64.0;
        }
        if (d < 1.0E65) {
            return 65.0;
        }
        if (d < 1.0E66) {
            return 66.0;
        }
        if (d < 1.0E67) {
            return 67.0;
        }
        if (d < 1.0E68) {
            return 68.0;
        }
        if (d < 1.0E69) {
            return 69.0;
        }
        if (d < 1.0E70) {
            return 70.0;
        }
        if (d < 1.0E71) {
            return 71.0;
        }
        if (d < 1.0E72) {
            return 72.0;
        }
        if (d < 1.0E73) {
            return 73.0;
        }
        if (d < 1.0E74) {
            return 74.0;
        }
        if (d < 1.0E75) {
            return 75.0;
        }
        if (d < 1.0E76) {
            return 76.0;
        }
        if (d < 1.0E77) {
            return 77.0;
        }
        if (d < 1.0E78) {
            return 78.0;
        }
        if (d < 1.0E79) {
            return 79.0;
        }
        if (d < 1.0E80) {
            return 80.0;
        }
        if (d < 1.0E81) {
            return 81.0;
        }
        if (d < 1.0E82) {
            return 82.0;
        }
        if (d < 1.0E83) {
            return 83.0;
        }
        if (d < 1.0E84) {
            return 84.0;
        }
        if (d < 1.0E85) {
            return 85.0;
        }
        if (d < 1.0E86) {
            return 86.0;
        }
        if (d < 1.0E87) {
            return 87.0;
        }
        if (d < 1.0E88) {
            return 88.0;
        }
        if (d < 1.0E89) {
            return 89.0;
        }
        if (d < 1.0E90) {
            return 90.0;
        }
        if (d < 1.0E91) {
            return 91.0;
        }
        if (d < 1.0E92) {
            return 92.0;
        }
        if (d < 1.0E93) {
            return 93.0;
        }
        if (d < 1.0E94) {
            return 94.0;
        }
        if (d < 1.0E95) {
            return 95.0;
        }
        if (d < 1.0E96) {
            return 96.0;
        }
        if (d < 1.0E97) {
            return 97.0;
        }
        if (d < 1.0E98) {
            return 98.0;
        }
        if (d < 1.0E99) {
            return 99.0;
        }
        if (d < 1.0E100) {
            return 100.0;
        }
        if (d < 1.0E101) {
            return 101.0;
        }
        if (d < 1.0E102) {
            return 102.0;
        }
        if (d < 1.0E103) {
            return 103.0;
        }
        if (d < 1.0E104) {
            return 104.0;
        }
        if (d < 1.0E105) {
            return 105.0;
        }
        if (d < 1.0E106) {
            return 106.0;
        }
        if (d < 1.0E107) {
            return 107.0;
        }
        if (d < 1.0E108) {
            return 108.0;
        }
        if (d < 1.0E109) {
            return 109.0;
        }
        if (d < 1.0E110) {
            return 110.0;
        }
        if (d < 1.0E111) {
            return 111.0;
        }
        if (d < 1.0E112) {
            return 112.0;
        }
        if (d < 1.0E113) {
            return 113.0;
        }
        if (d < 1.0E114) {
            return 114.0;
        }
        if (d < 1.0E115) {
            return 115.0;
        }
        if (d < 1.0E116) {
            return 116.0;
        }
        if (d < 1.0E117) {
            return 117.0;
        }
        if (d < 1.0E118) {
            return 118.0;
        }
        if (d < 1.0E119) {
            return 119.0;
        }
        if (d < 1.0E120) {
            return 120.0;
        }
        if (d < 1.0E121) {
            return 121.0;
        }
        if (d < 1.0E122) {
            return 122.0;
        }
        if (d < 1.0E123) {
            return 123.0;
        }
        if (d < 1.0E124) {
            return 124.0;
        }
        if (d < 1.0E125) {
            return 125.0;
        }
        if (d < 1.0E126) {
            return 126.0;
        }
        if (d < 1.0E127) {
            return 127.0;
        }
        if (d < 1.0E128) {
            return 128.0;
        }
        if (d < 1.0E129) {
            return 129.0;
        }
        if (d < 1.0E130) {
            return 130.0;
        }
        if (d < 1.0E131) {
            return 131.0;
        }
        if (d < 1.0E132) {
            return 132.0;
        }
        if (d < 1.0E133) {
            return 133.0;
        }
        if (d < 1.0E134) {
            return 134.0;
        }
        if (d < 1.0E135) {
            return 135.0;
        }
        if (d < 1.0E136) {
            return 136.0;
        }
        if (d < 1.0E137) {
            return 137.0;
        }
        if (d < 1.0E138) {
            return 138.0;
        }
        if (d < 1.0E139) {
            return 139.0;
        }
        if (d < 1.0E140) {
            return 140.0;
        }
        if (d < 1.0E141) {
            return 141.0;
        }
        if (d < 1.0E142) {
            return 142.0;
        }
        if (d < 1.0E143) {
            return 143.0;
        }
        if (d < 1.0E144) {
            return 144.0;
        }
        if (d < 1.0E145) {
            return 145.0;
        }
        if (d < 1.0E146) {
            return 146.0;
        }
        if (d < 1.0E147) {
            return 147.0;
        }
        if (d < 1.0E148) {
            return 148.0;
        }
        if (d < 1.0E149) {
            return 149.0;
        }
        if (d < 1.0E150) {
            return 150.0;
        }
        if (d < 1.0E151) {
            return 151.0;
        }
        if (d < 1.0E152) {
            return 152.0;
        }
        if (d < 1.0E153) {
            return 153.0;
        }
        if (d < 1.0E154) {
            return 154.0;
        }
        if (d < 1.0E155) {
            return 155.0;
        }
        if (d < 1.0E156) {
            return 156.0;
        }
        if (d < 1.0E157) {
            return 157.0;
        }
        if (d < 1.0E158) {
            return 158.0;
        }
        if (d < 1.0E159) {
            return 159.0;
        }
        if (d < 1.0E160) {
            return 160.0;
        }
        if (d < 1.0E161) {
            return 161.0;
        }
        if (d < 1.0E162) {
            return 162.0;
        }
        if (d < 1.0E163) {
            return 163.0;
        }
        if (d < 1.0E164) {
            return 164.0;
        }
        if (d < 1.0E165) {
            return 165.0;
        }
        if (d < 1.0E166) {
            return 166.0;
        }
        if (d < 1.0E167) {
            return 167.0;
        }
        if (d < 1.0E168) {
            return 168.0;
        }
        if (d < 1.0E169) {
            return 169.0;
        }
        if (d < 1.0E170) {
            return 170.0;
        }
        if (d < 1.0E171) {
            return 171.0;
        }
        if (d < 1.0E172) {
            return 172.0;
        }
        if (d < 1.0E173) {
            return 173.0;
        }
        if (d < 1.0E174) {
            return 174.0;
        }
        if (d < 1.0E175) {
            return 175.0;
        }
        if (d < 1.0E176) {
            return 176.0;
        }
        if (d < 1.0E177) {
            return 177.0;
        }
        if (d < 1.0E178) {
            return 178.0;
        }
        if (d < 1.0E179) {
            return 179.0;
        }
        if (d < 1.0E180) {
            return 180.0;
        }
        if (d < 1.0E181) {
            return 181.0;
        }
        if (d < 1.0E182) {
            return 182.0;
        }
        if (d < 1.0E183) {
            return 183.0;
        }
        if (d < 1.0E184) {
            return 184.0;
        }
        if (d < 1.0E185) {
            return 185.0;
        }
        if (d < 1.0E186) {
            return 186.0;
        }
        if (d < 1.0E187) {
            return 187.0;
        }
        if (d < 1.0E188) {
            return 188.0;
        }
        if (d < 1.0E189) {
            return 189.0;
        }
        if (d < 1.0E190) {
            return 190.0;
        }
        if (d < 1.0E191) {
            return 191.0;
        }
        if (d < 1.0E192) {
            return 192.0;
        }
        if (d < 1.0E193) {
            return 193.0;
        }
        if (d < 1.0E194) {
            return 194.0;
        }
        if (d < 1.0E195) {
            return 195.0;
        }
        if (d < 1.0E196) {
            return 196.0;
        }
        if (d < 1.0E197) {
            return 197.0;
        }
        if (d < 1.0E198) {
            return 198.0;
        }
        if (d < 1.0E199) {
            return 199.0;
        }
        if (d < 1.0E200) {
            return 200.0;
        }
        if (d < 1.0E201) {
            return 201.0;
        }
        if (d < 1.0E202) {
            return 202.0;
        }
        if (d < 1.0E203) {
            return 203.0;
        }
        if (d < 1.0E204) {
            return 204.0;
        }
        if (d < 1.0E205) {
            return 205.0;
        }
        if (d < 1.0E206) {
            return 206.0;
        }
        if (d < 1.0E207) {
            return 207.0;
        }
        if (d < 1.0E208) {
            return 208.0;
        }
        if (d < 1.0E209) {
            return 209.0;
        }
        if (d < 1.0E210) {
            return 210.0;
        }
        if (d < 1.0E211) {
            return 211.0;
        }
        if (d < 1.0E212) {
            return 212.0;
        }
        if (d < 1.0E213) {
            return 213.0;
        }
        if (d < 1.0E214) {
            return 214.0;
        }
        if (d < 1.0E215) {
            return 215.0;
        }
        if (d < 1.0E216) {
            return 216.0;
        }
        if (d < 1.0E217) {
            return 217.0;
        }
        if (d < 1.0E218) {
            return 218.0;
        }
        if (d < 1.0E219) {
            return 219.0;
        }
        if (d < 1.0E220) {
            return 220.0;
        }
        if (d < 1.0E221) {
            return 221.0;
        }
        if (d < 1.0E222) {
            return 222.0;
        }
        if (d < 1.0E223) {
            return 223.0;
        }
        if (d < 1.0E224) {
            return 224.0;
        }
        if (d < 1.0E225) {
            return 225.0;
        }
        if (d < 1.0E226) {
            return 226.0;
        }
        if (d < 1.0E227) {
            return 227.0;
        }
        if (d < 1.0E228) {
            return 228.0;
        }
        if (d < 1.0E229) {
            return 229.0;
        }
        if (d < 1.0E230) {
            return 230.0;
        }
        if (d < 1.0E231) {
            return 231.0;
        }
        if (d < 1.0E232) {
            return 232.0;
        }
        if (d < 1.0E233) {
            return 233.0;
        }
        if (d < 1.0E234) {
            return 234.0;
        }
        if (d < 1.0E235) {
            return 235.0;
        }
        if (d < 1.0E236) {
            return 236.0;
        }
        if (d < 1.0E237) {
            return 237.0;
        }
        if (d < 1.0E238) {
            return 238.0;
        }
        if (d < 1.0E239) {
            return 239.0;
        }
        if (d < 1.0E240) {
            return 240.0;
        }
        if (d < 1.0E241) {
            return 241.0;
        }
        if (d < 1.0E242) {
            return 242.0;
        }
        if (d < 1.0E243) {
            return 243.0;
        }
        if (d < 1.0E244) {
            return 244.0;
        }
        if (d < 1.0E245) {
            return 245.0;
        }
        if (d < 1.0E246) {
            return 246.0;
        }
        if (d < 1.0E247) {
            return 247.0;
        }
        if (d < 1.0E248) {
            return 248.0;
        }
        if (d < 1.0E249) {
            return 249.0;
        }
        if (d < 1.0E250) {
            return 250.0;
        }
        if (d < 1.0E251) {
            return 251.0;
        }
        if (d < 1.0E252) {
            return 252.0;
        }
        if (d < 1.0E253) {
            return 253.0;
        }
        if (d < 1.0E254) {
            return 254.0;
        }
        if (d < 1.0E255) {
            return 255.0;
        }
        if (d < 1.0E256) {
            return 256.0;
        }
        if (d < 1.0E257) {
            return 257.0;
        }
        if (d < 1.0E258) {
            return 258.0;
        }
        if (d < 1.0E259) {
            return 259.0;
        }
        if (d < 1.0E260) {
            return 260.0;
        }
        if (d < 1.0E261) {
            return 261.0;
        }
        if (d < 1.0E262) {
            return 262.0;
        }
        if (d < 1.0E263) {
            return 263.0;
        }
        if (d < 1.0E264) {
            return 264.0;
        }
        if (d < 1.0E265) {
            return 265.0;
        }
        if (d < 1.0E266) {
            return 266.0;
        }
        if (d < 1.0E267) {
            return 267.0;
        }
        if (d < 1.0E268) {
            return 268.0;
        }
        if (d < 1.0E269) {
            return 269.0;
        }
        if (d < 1.0E270) {
            return 270.0;
        }
        if (d < 1.0E271) {
            return 271.0;
        }
        if (d < 1.0E272) {
            return 272.0;
        }
        if (d < 1.0E273) {
            return 273.0;
        }
        if (d < 1.0E274) {
            return 274.0;
        }
        if (d < 1.0E275) {
            return 275.0;
        }
        if (d < 1.0E276) {
            return 276.0;
        }
        if (d < 1.0E277) {
            return 277.0;
        }
        if (d < 1.0E278) {
            return 278.0;
        }
        if (d < 1.0E279) {
            return 279.0;
        }
        if (d < 1.0E280) {
            return 280.0;
        }
        if (d < 1.0E281) {
            return 281.0;
        }
        if (d < 1.0E282) {
            return 282.0;
        }
        if (d < 1.0E283) {
            return 283.0;
        }
        if (d < 1.0E284) {
            return 284.0;
        }
        if (d < 1.0E285) {
            return 285.0;
        }
        if (d < 1.0E286) {
            return 286.0;
        }
        if (d < 1.0E287) {
            return 287.0;
        }
        if (d < 1.0E288) {
            return 288.0;
        }
        if (d < 1.0E289) {
            return 289.0;
        }
        if (d < 1.0E290) {
            return 290.0;
        }
        if (d < 1.0E291) {
            return 291.0;
        }
        if (d < 1.0E292) {
            return 292.0;
        }
        if (d < 1.0E293) {
            return 293.0;
        }
        if (d < 1.0E294) {
            return 294.0;
        }
        if (d < 1.0E295) {
            return 295.0;
        }
        if (d < 1.0E296) {
            return 296.0;
        }
        if (d < 1.0E297) {
            return 297.0;
        }
        if (d < 1.0E298) {
            return 298.0;
        }
        if (d < 1.0E299) {
            return 299.0;
        }
        if (d < 1.0E300) {
            return 300.0;
        }
        if (d < 1.0E301) {
            return 301.0;
        }
        if (d < 1.0E302) {
            return 302.0;
        }
        if (d < 1.0E303) {
            return 303.0;
        }
        if (d < 1.0E304) {
            return 304.0;
        }
        if (d < 1.0E305) {
            return 305.0;
        }
        if (d < 1.0E306) {
            return 306.0;
        }
        if (d < 1.0E307) {
            return 307.0;
        }
        if (d < 1.0E308) {
            return 308.0;
        }
        return 309.0;
    }

    public static final long numberOfDigits(long l, long l2) {
        if (l2 < 1L) {
            return -1L;
        }
        if (l < 0L) {
            l = -l;
        }
        if (l2 == 10L) {
            return NumberTheory.numberOfDigits(l);
        }
        if (l2 == 1L) {
            return (int)l;
        }
        if (l < l2) {
            return 1L;
        }
        long l3 = l;
        long l4 = 0L;
        while (l3 >= 1L) {
            if (mXparser.isCurrentCalculationCancelled()) {
                return 0L;
            }
            l3 /= l2;
            ++l4;
        }
        return l4;
    }

    public static final double numberOfDigits(double d, double d2) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d2)) {
            return Double.NaN;
        }
        if (d2 < 1.0) {
            return Double.NaN;
        }
        if (Double.isInfinite(d)) {
            return Double.POSITIVE_INFINITY;
        }
        if (d < 0.0) {
            d = -d;
        }
        d = MathFunctions.floor(d);
        if ((d2 = MathFunctions.floor(d2)) == 10.0) {
            return NumberTheory.numberOfDigits(d);
        }
        if (d2 == 1.0) {
            return (int)d;
        }
        if (d < d2) {
            return 1.0;
        }
        double d3 = d;
        double d4 = 0.0;
        while (d3 >= 1.0) {
            if (mXparser.isCurrentCalculationCancelled()) {
                return Double.NaN;
            }
            d3 = MathFunctions.floor(d3 / d2);
            d4 += 1.0;
        }
        return d4;
    }

    public static final int digitAtPosition(long l, int n, int n2) {
        int n3;
        if (n2 < 1) {
            return -1;
        }
        if (l < 0L) {
            l = -l;
        }
        if (n <= -(n3 = (int)NumberTheory.numberOfDigits(l, n2))) {
            if (n2 > 1) {
                return 0;
            }
            return -1;
        }
        if (n > n3) {
            return -1;
        }
        if (n2 == 1) {
            return 1;
        }
        int[] nArray = new int[n3];
        int n4 = n3;
        for (long i = l; i >= 1L; i /= (long)n2) {
            if (mXparser.isCurrentCalculationCancelled()) {
                return 0;
            }
            int n5 = (int)i % n2;
            nArray[--n4] = n5;
        }
        if (n >= 1) {
            return nArray[n - 1];
        }
        return nArray[n3 + n - 1];
    }

    public static final int digitAtPosition(long l, int n) {
        return NumberTheory.digitAtPosition(l, n, 10);
    }

    public static final double digitAtPosition(double d, double d2, double d3) {
        int n;
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (Double.isNaN(d3)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d2)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d3)) {
            return Double.NaN;
        }
        if (d3 < 1.0) {
            return Double.NaN;
        }
        if (d < 0.0) {
            d = -d;
        }
        if (d2 <= (double)(-(n = (int)NumberTheory.numberOfDigits(d = MathFunctions.floor(d), d3 = MathFunctions.floor(d3))))) {
            if (d3 > 1.0) {
                return 0.0;
            }
            return Double.NaN;
        }
        if (d2 > (double)n) {
            return Double.NaN;
        }
        if (d3 == 1.0) {
            return 1.0;
        }
        double[] dArray = new double[n];
        double d4 = d;
        int n2 = n;
        while (d4 >= 1.0) {
            if (mXparser.isCurrentCalculationCancelled()) {
                return Double.NaN;
            }
            double d5 = MathFunctions.floor(d4 % d3);
            d4 = MathFunctions.floor(d4 / d3);
            dArray[--n2] = d5;
        }
        if (d2 >= 1.0) {
            return dArray[(int)(d2 - 1.0)];
        }
        return dArray[(int)((double)n + d2 - 1.0)];
    }

    public static final double digitAtPosition(double d, double d2) {
        return NumberTheory.digitAtPosition(d, d2, 10.0);
    }

    public static final long[] primeFactors(long l) {
        long[] lArray = new long[]{};
        if (l == 0L) {
            return lArray;
        }
        if (l < 0L) {
            l = -l;
        }
        if (l == 1L) {
            long[] lArray2 = new long[]{1L};
            return lArray2;
        }
        if (mXparser.primesCache != null && mXparser.primesCache.getCacheStatus() && l <= Integer.MAX_VALUE && mXparser.primesCache.primeTest((int)l) == 1) {
            long[] lArray3 = new long[]{l};
            return lArray3;
        }
        long l2 = l;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (long i = 2L; i <= l2 / i; ++i) {
            while (l2 % i == 0L) {
                arrayList.add(i);
                l2 /= i;
            }
        }
        if (l2 > 1L) {
            arrayList.add(l2);
        }
        int n = arrayList.size();
        long[] lArray4 = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray4[i] = (Long)arrayList.get(i);
        }
        return lArray4;
    }

    public static final double[] primeFactors(double d) {
        double[] dArray = new double[]{};
        if (Double.isNaN(d)) {
            return dArray;
        }
        if (Double.isInfinite(d)) {
            return dArray;
        }
        if ((d = MathFunctions.floor(MathFunctions.abs(d))) == 0.0) {
            return dArray;
        }
        if (d == 1.0) {
            double[] dArray2 = new double[]{1.0};
            return dArray2;
        }
        if (mXparser.primesCache != null && mXparser.primesCache.getCacheStatus() && d <= 2.147483647E9 && mXparser.primesCache.primeTest((int)d) == 1) {
            double[] dArray3 = new double[]{d};
            return dArray3;
        }
        double d2 = d;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double d3 = 2.0;
        while (d3 <= MathFunctions.floor(d2 / d3)) {
            while (d2 % d3 == 0.0) {
                arrayList.add(d3);
                d2 = MathFunctions.floor(d2 / d3);
            }
            double d4 = d3;
            d3 = d4 + 1.0;
            MathFunctions.floor(d4);
        }
        if (d2 > 1.0) {
            arrayList.add(d2);
        }
        int n = arrayList.size();
        double[] dArray4 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray4[i] = (Double)arrayList.get(i);
        }
        return dArray4;
    }

    public static final double numberOfPrimeFactors(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        double[] dArray = NumberTheory.primeFactors(d);
        if (dArray.length <= 1) {
            return dArray.length;
        }
        double[][] dArray2 = NumberTheory.getDistValues(dArray, false);
        return dArray2.length;
    }

    public static final double primeFactorValue(double d, double d2) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d2)) {
            return Double.NaN;
        }
        if ((d = MathFunctions.floor(MathFunctions.abs(d))) == 0.0) {
            return Double.NaN;
        }
        if (d2 < 1.0) {
            return 1.0;
        }
        if ((d2 = MathFunctions.floor(d2)) > 2.147483647E9) {
            return 1.0;
        }
        double[] dArray = NumberTheory.primeFactors(d);
        double[][] dArray2 = NumberTheory.getDistValues(dArray, false);
        int n = dArray2.length;
        if (d2 > (double)n) {
            return 1.0;
        }
        return dArray2[(int)(d2 - 1.0)][0];
    }

    public static final double primeFactorExponent(double d, double d2) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d2)) {
            return Double.NaN;
        }
        if ((d = MathFunctions.floor(MathFunctions.abs(d))) == 0.0) {
            return Double.NaN;
        }
        if (d2 < 1.0) {
            return 0.0;
        }
        if ((d2 = MathFunctions.floor(d2)) > 2.147483647E9) {
            return 0.0;
        }
        double[] dArray = NumberTheory.primeFactors(d);
        double[][] dArray2 = NumberTheory.getDistValues(dArray, false);
        int n = dArray2.length;
        if (d2 > (double)n) {
            return 0.0;
        }
        return dArray2[(int)(d2 - 1.0)][1];
    }

    private static final double[] fractionToDoubleArray(double d, double d2, double d3) {
        double[] dArray = new double[]{d, d2, d3};
        return dArray;
    }

    private static final double[] mixedFractionToDoubleArray(double d, double d2, double d3, double d4) {
        double[] dArray = new double[]{d, d2, d3, d4};
        return dArray;
    }

    public static final double[] toFraction(double d) {
        double d2;
        double d3;
        double d4;
        if (Double.isNaN(d)) {
            return NumberTheory.fractionToDoubleArray(Double.NaN, Double.NaN, Double.NaN);
        }
        if (Double.isInfinite(d)) {
            return NumberTheory.fractionToDoubleArray(Double.NaN, Double.NaN, Double.NaN);
        }
        if (d == 0.0) {
            return NumberTheory.fractionToDoubleArray(0.0, 0.0, 1.0);
        }
        double d5 = 1.0;
        if (d < 0.0) {
            d = -d;
            d5 = -1.0;
        }
        double d6 = MathFunctions.roundHalfUp(d, 0);
        double d7 = Math.floor(d);
        double d8 = NumberTheory.numberOfDigits(d7);
        double d9 = 1.0;
        int n = 1;
        while ((double)n < d8 - 1.0) {
            d9 = Math.floor(d9 * 10.0);
            ++n;
        }
        double d10 = 1.0E-14 * d9;
        if (d >= 1.0 && Math.abs(d - d6) <= d10) {
            return NumberTheory.fractionToDoubleArray(d5, d7, 1.0);
        }
        int n2 = MathFunctions.ulpDecimalDigitsBefore(d);
        if (n2 <= 0) {
            return NumberTheory.fractionToDoubleArray(d5, d7, 1.0);
        }
        double d11 = d - d7;
        double d12 = 0.0;
        while (d12 <= (double)TO_FRACTION_INIT_SEARCH_SIZE && !mXparser.isCurrentCalculationCancelled()) {
            double d13 = (d12 += 1.0) / d11;
            double d14 = MathFunctions.roundHalfUp(d13, 0);
            double d15 = d12 / d14;
            if (!(Math.abs(d13 - d14) <= d10) && !(Math.abs(d15 - d11) <= d10)) continue;
            double d16 = d12;
            double d17 = d14;
            double d18 = NumberTheory.gcd(d16, d17);
            d16 = Math.floor(d16 / d18);
            d17 = Math.floor(d17 / d18);
            return NumberTheory.fractionToDoubleArray(d5, Math.floor(d7 * d17 + d16), d17);
        }
        double d19 = MathFunctions.roundHalfUp(d, n2);
        d9 = 1.0;
        for (int i = 1; i < n2; ++i) {
            d9 = Math.floor(d9 * 10.0);
        }
        double d20 = Math.floor(d19 * d9);
        double d21 = d9;
        double d22 = NumberTheory.gcd(d20, d21);
        double d23 = Math.floor(d20 / d22);
        double d24 = Math.floor(d21 / d22);
        if (d24 > d23) {
            d4 = d24;
            d3 = d23;
        } else {
            d4 = d23;
            d3 = d24;
        }
        double d25 = d4 / d3;
        int n3 = MathFunctions.ulpDecimalDigitsBefore(d25);
        if (n3 > 0) {
            d25 = MathFunctions.roundHalfUp(d25, n3 - 1);
        }
        if (Math.abs(d25 - (d2 = Math.floor(d25))) <= d10) {
            d23 = Math.floor(d23 / d3);
            d24 = Math.floor(d24 / d3);
        }
        return NumberTheory.fractionToDoubleArray(d5, d23, d24);
    }

    public static final double[] toMixedFraction(double d) {
        double[] dArray = NumberTheory.toFraction(d);
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        if (Double.isNaN(d3)) {
            return NumberTheory.mixedFractionToDoubleArray(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        }
        if (Double.isNaN(d4)) {
            return NumberTheory.mixedFractionToDoubleArray(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        }
        if (d3 < d4) {
            return NumberTheory.mixedFractionToDoubleArray(d2, 0.0, d3, d4);
        }
        double d5 = Math.floor(d3 / d4);
        d3 = Math.floor(d3 - d5 * d4);
        return NumberTheory.mixedFractionToDoubleArray(d2, d5, d3, d4);
    }

    public static final String fractionToString(double[] dArray) {
        int n;
        int n2;
        boolean bl = false;
        if (dArray.length != 3 && dArray.length != 4) {
            return "[NaN]";
        }
        if (dArray.length == 4) {
            bl = true;
            n2 = 2;
            n = 3;
        } else {
            n2 = 1;
            n = 2;
        }
        if (Double.isNaN(dArray[0])) {
            return "[NaN]";
        }
        if (Double.isNaN(dArray[1])) {
            return "[NaN]";
        }
        if (Double.isNaN(dArray[2])) {
            return "[NaN]";
        }
        if (bl && Double.isNaN(dArray[3])) {
            return "[NaN]";
        }
        double d = dArray[0];
        double d2 = dArray[n2];
        double d3 = dArray[n];
        String string = String.format("%.0f", d2);
        String string2 = String.format("%.0f", d3);
        if (!bl) {
            if (d2 == 0.0) {
                return "0";
            }
            if (d3 == 1.0) {
                if (d >= 0.0) {
                    return string;
                }
                return "-" + string;
            }
            if (d >= 0.0) {
                return string + "/" + string2;
            }
            return "-" + string + "/" + string2;
        }
        double d4 = dArray[1];
        String string3 = String.format("%.0f", d4);
        if (d2 == 0.0) {
            if (d4 == 0.0) {
                return "0";
            }
            if (d >= 0.0) {
                return string3;
            }
            return "-" + string3;
        }
        if (d4 == 0.0) {
            if (d >= 0.0) {
                return string + "/" + string2;
            }
            return "-" + string + "/" + string2;
        }
        if (d >= 0.0) {
            return string3 + "+" + string + "/" + string2;
        }
        return "-" + string3 + "-" + string + "/" + string2;
    }

    public static final String toFractionString(double d) {
        return NumberTheory.fractionToString(NumberTheory.toFraction(d));
    }

    public static final String toMixedFractionString(double d) {
        return NumberTheory.fractionToString(NumberTheory.toMixedFraction(d));
    }
}

