/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.mathcollection;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.mariuszgromada.math.mxparser.mXparser;
import org.mariuszgromada.math.mxparser.mathcollection.MathConstants;
import org.mariuszgromada.math.mxparser.mathcollection.SpecialFunctions;
import org.mariuszgromada.math.mxparser.mathcollection.SpecialValue;
import org.mariuszgromada.math.mxparser.mathcollection.SpecialValueTrigonometric;

public final class MathFunctions {
    public static final double plus(double d, double d2) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (!mXparser.checkIfCanonicalRounding()) {
            return d + d2;
        }
        if (Double.isInfinite(d)) {
            return d + d2;
        }
        if (Double.isInfinite(d2)) {
            return d + d2;
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(d);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(d2);
        return bigDecimal.add(bigDecimal2).doubleValue();
    }

    public static final double minus(double d, double d2) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (!mXparser.checkIfCanonicalRounding()) {
            return d - d2;
        }
        if (Double.isInfinite(d)) {
            return d - d2;
        }
        if (Double.isInfinite(d2)) {
            return d - d2;
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(d);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(d2);
        return bigDecimal.subtract(bigDecimal2).doubleValue();
    }

    public static final double multiply(double d, double d2) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (!mXparser.checkIfCanonicalRounding()) {
            return d * d2;
        }
        if (Double.isInfinite(d)) {
            return d * d2;
        }
        if (Double.isInfinite(d2)) {
            return d * d2;
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(d);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(d2);
        return bigDecimal.multiply(bigDecimal2).doubleValue();
    }

    public static final double div(double d, double d2) {
        if (d2 == 0.0) {
            return Double.NaN;
        }
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (!mXparser.checkIfCanonicalRounding()) {
            return d / d2;
        }
        if (Double.isInfinite(d)) {
            return d / d2;
        }
        if (Double.isInfinite(d2)) {
            return d / d2;
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(d);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(d2);
        return bigDecimal.divide(bigDecimal2, MathContext.DECIMAL128).doubleValue();
    }

    public static final double bellNumber(int n) {
        double d = Double.NaN;
        if (n > 1) {
            long[][] lArray = new long[--n + 1][n + 1];
            lArray[0][0] = 1L;
            lArray[1][0] = 1L;
            for (int i = 1; i <= n; ++i) {
                for (int j = 0; j < i; ++j) {
                    lArray[i][j + 1] = lArray[i - 1][j] + lArray[i][j];
                }
                if (i < n) {
                    lArray[i + 1][0] = lArray[i][i];
                }
                if (!mXparser.isCurrentCalculationCancelled()) continue;
                return Double.NaN;
            }
            d = lArray[n][n];
        } else if (n >= 0) {
            d = 1.0;
        }
        return d;
    }

    public static final double bellNumber(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return MathFunctions.bellNumber((int)Math.round(d));
    }

    public static final double eulerNumber(int n, int n2) {
        if (n < 0) {
            return Double.NaN;
        }
        if (n2 < 0) {
            return 0.0;
        }
        if (n == 0) {
            if (n2 == 0) {
                return 1.0;
            }
            return 0.0;
        }
        return (double)(n2 + 1) * MathFunctions.eulerNumber(n - 1, n2) + (double)(n - n2) * MathFunctions.eulerNumber(n - 1, n2 - 1);
    }

    public static final double eulerNumber(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        return MathFunctions.eulerNumber((int)Math.round(d), (int)Math.round(d2));
    }

    public static final double factorial(int n) {
        double d = Double.NaN;
        if (n >= 0) {
            if (n < 2) {
                d = 1.0;
            } else {
                d = 1.0;
                for (int i = 1; i <= n; ++i) {
                    d *= (double)i;
                }
            }
        }
        return d;
    }

    public static final double factorial(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return MathFunctions.factorial((int)Math.round(d));
    }

    public static final double binomCoeff(double d, long l) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        double d2 = Double.NaN;
        if (l >= 0L) {
            double d3 = 1.0;
            if (l > 0L) {
                for (long i = 0L; i <= l - 1L; ++i) {
                    d3 *= d - (double)i;
                }
            }
            double d4 = 1.0;
            if (l > 1L) {
                for (long i = 1L; i <= l; ++i) {
                    d4 *= (double)i;
                }
            }
            d2 = d3 / d4;
        }
        return d2;
    }

    public static final double binomCoeff(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        return MathFunctions.binomCoeff(d, Math.round(d2));
    }

    public static final double numberOfPermutations(double d, long l) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        double d2 = Double.NaN;
        if (l >= 0L) {
            double d3 = 1.0;
            if (l > 0L) {
                for (long i = 0L; i <= l - 1L; ++i) {
                    d3 *= d - (double)i;
                }
            }
            d2 = d3;
        }
        return d2;
    }

    public static final double numberOfPermutations(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        return MathFunctions.numberOfPermutations(d, Math.round(d2));
    }

    public static final double bernoulliNumber(int n, int n2) {
        double d = Double.NaN;
        if (n >= 0 && n2 >= 0) {
            d = 0.0;
            for (int i = 0; i <= n; ++i) {
                for (int j = 0; j <= i; ++j) {
                    d += Math.pow(-1.0, j) * MathFunctions.binomCoeff((double)i, j) * (Math.pow(n2 + j, n) / (double)(i + 1));
                    if (!mXparser.isCurrentCalculationCancelled()) continue;
                    return Double.NaN;
                }
            }
        }
        return d;
    }

    public static final double bernoulliNumber(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        return MathFunctions.bernoulliNumber((int)Math.round(d), (int)Math.round(d2));
    }

    public static final double Stirling1Number(int n, int n2) {
        if (n2 > n) {
            return 0.0;
        }
        if (n == 0) {
            if (n2 == 0) {
                return 1.0;
            }
            return 0.0;
        }
        if (n2 == 0) {
            if (n == 0) {
                return 1.0;
            }
            return 0.0;
        }
        return (double)(n - 1) * MathFunctions.Stirling1Number(n - 1, n2) + MathFunctions.Stirling1Number(n - 1, n2 - 1);
    }

    public static final double Stirling1Number(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        return MathFunctions.Stirling1Number((int)Math.round(d), (int)Math.round(d2));
    }

    public static final double Stirling2Number(int n, int n2) {
        if (n2 > n) {
            return 0.0;
        }
        if (n == 0) {
            if (n2 == 0) {
                return 1.0;
            }
            return 0.0;
        }
        if (n2 == 0) {
            if (n == 0) {
                return 1.0;
            }
            return 0.0;
        }
        if (mXparser.isCurrentCalculationCancelled()) {
            return Double.NaN;
        }
        return (double)n2 * MathFunctions.Stirling2Number(n - 1, n2) + MathFunctions.Stirling2Number(n - 1, n2 - 1);
    }

    public static final double Stirling2Number(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        return MathFunctions.Stirling2Number((int)Math.round(d), (int)Math.round(d2));
    }

    public static final double worpitzkyNumber(int n, int n2) {
        double d = Double.NaN;
        if (n >= 0 && n2 >= 0 && n2 <= n) {
            d = 0.0;
            for (int i = 0; i <= n2; ++i) {
                d += Math.pow(-1.0, i + n2) * Math.pow(i + 1, n) * MathFunctions.binomCoeff((double)n2, i);
                if (!mXparser.isCurrentCalculationCancelled()) continue;
                return Double.NaN;
            }
        }
        return d;
    }

    public static final double worpitzkyNumber(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        return MathFunctions.worpitzkyNumber((int)Math.round(d), (int)Math.round(d2));
    }

    public static final double harmonicNumber(int n) {
        if (n <= 0) {
            return 0.0;
        }
        if (n == 1) {
            return 1.0;
        }
        double d = 1.0;
        for (double d2 = 2.0; d2 <= (double)n; d2 += 1.0) {
            d += 1.0 / d2;
        }
        return d;
    }

    public static final double harmonicNumber(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return MathFunctions.harmonicNumber((int)Math.round(d));
    }

    public static final double harmonicNumber(double d, int n) {
        if (Double.isNaN(d) || d < 0.0) {
            return Double.NaN;
        }
        if (n <= 0) {
            return 0.0;
        }
        if (n == 1) {
            return d;
        }
        double d2 = 1.0;
        for (double d3 = 2.0; d3 <= (double)n; d3 += 1.0) {
            d2 += 1.0 / MathFunctions.power(d3, d);
        }
        return d2;
    }

    public static final double harmonicNumber(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        return MathFunctions.harmonicNumber(d, (int)Math.round(d2));
    }

    public static final double catalanNumber(int n) {
        return MathFunctions.binomCoeff((double)(2 * n), n) * MathFunctions.div(1.0, n + 1);
    }

    public static final double catalanNumber(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return MathFunctions.catalanNumber((int)Math.round(d));
    }

    public static final double fibonacciNumber(int n) {
        if (n < 0) {
            return Double.NaN;
        }
        if (n == 0) {
            return 0.0;
        }
        if (n == 1) {
            return 1.0;
        }
        if (mXparser.isCurrentCalculationCancelled()) {
            return Double.NaN;
        }
        return MathFunctions.fibonacciNumber(n - 1) + MathFunctions.fibonacciNumber(n - 2);
    }

    public static final double fibonacciNumber(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return MathFunctions.fibonacciNumber((int)Math.round(d));
    }

    public static final double lucasNumber(int n) {
        if (n < 0) {
            return Double.NaN;
        }
        if (n == 0) {
            return 2.0;
        }
        if (n == 1) {
            return 1.0;
        }
        if (mXparser.isCurrentCalculationCancelled()) {
            return Double.NaN;
        }
        return MathFunctions.lucasNumber(n - 1) + MathFunctions.lucasNumber(n - 2);
    }

    public static final double lucasNumber(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return MathFunctions.lucasNumber((int)Math.round(d));
    }

    public static final double kroneckerDelta(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (d == d2) {
            return 1.0;
        }
        return 0.0;
    }

    public static final double kroneckerDelta(int n, int n2) {
        if (n == n2) {
            return 1.0;
        }
        return 0.0;
    }

    public static final double continuedFraction(double ... dArray) {
        int n;
        if (dArray == null) {
            return Double.NaN;
        }
        if (dArray.length == 0) {
            return Double.NaN;
        }
        double d = 0.0;
        if (dArray.length == 1) {
            return dArray[0];
        }
        for (int i = n = dArray.length - 1; i >= 0; --i) {
            double d2 = dArray[i];
            if (Double.isNaN(d2)) {
                return Double.NaN;
            }
            if (i == n) {
                d = d2;
            } else {
                if (d == 0.0) {
                    return Double.NaN;
                }
                d = d2 + 1.0 / d;
            }
            if (!mXparser.isCurrentCalculationCancelled()) continue;
            return Double.NaN;
        }
        return d;
    }

    private static final double continuedPolynomial(int n, double[] dArray) {
        if (dArray == null) {
            return Double.NaN;
        }
        if (dArray.length == 0) {
            return Double.NaN;
        }
        if (n == 0) {
            return 1.0;
        }
        if (n == 1) {
            return dArray[0];
        }
        if (mXparser.isCurrentCalculationCancelled()) {
            return Double.NaN;
        }
        return dArray[n - 1] * MathFunctions.continuedPolynomial(n - 1, dArray) + MathFunctions.continuedPolynomial(n - 2, dArray);
    }

    public static final double continuedPolynomial(double ... dArray) {
        if (dArray == null) {
            return Double.NaN;
        }
        if (dArray.length == 0) {
            return Double.NaN;
        }
        for (double d : dArray) {
            if (!Double.isNaN(d)) continue;
            return Double.NaN;
        }
        return MathFunctions.continuedPolynomial(dArray.length, dArray);
    }

    public static final double eulerPolynomial(int n, double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        double d2 = Double.NaN;
        if (n >= 0) {
            d2 = 0.0;
            for (int i = 0; i <= n; ++i) {
                for (int j = 0; j <= i; ++j) {
                    d2 += Math.pow(-1.0, j) * MathFunctions.binomCoeff((double)i, j) * Math.pow(d + (double)j, n);
                    if (!mXparser.isCurrentCalculationCancelled()) continue;
                    return Double.NaN;
                }
                d2 /= Math.pow(2.0, i);
            }
        }
        return d2;
    }

    public static final double eulerPolynomial(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        return MathFunctions.eulerPolynomial((int)Math.round(d), (double)((int)Math.round(d2)));
    }

    public static final double chi(double d, double d2, double d3) {
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3)) {
            return Double.NaN;
        }
        double d4 = Double.NaN;
        if (!(Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3))) {
            d4 = d > d2 && d < d3 ? 1.0 : 0.0;
        }
        return d4;
    }

    public static final double chi_LR(double d, double d2, double d3) {
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3)) {
            return Double.NaN;
        }
        double d4 = Double.NaN;
        if (!(Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3))) {
            d4 = d >= d2 && d <= d3 ? 1.0 : 0.0;
        }
        return d4;
    }

    public static final double chi_L(double d, double d2, double d3) {
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3)) {
            return Double.NaN;
        }
        double d4 = Double.NaN;
        if (!(Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3))) {
            d4 = d >= d2 && d < d3 ? 1.0 : 0.0;
        }
        return d4;
    }

    public static final double chi_R(double d, double d2, double d3) {
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3)) {
            return Double.NaN;
        }
        double d4 = Double.NaN;
        if (!(Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3))) {
            d4 = d > d2 && d <= d3 ? 1.0 : 0.0;
        }
        return d4;
    }

    public static final boolean isAlmostInt(double d) {
        double d2 = Math.round(d);
        return MathFunctions.abs(d - d2) <= 1.0E-14;
    }

    private static final double powInt(double d, int n) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d)) {
            Math.pow(d, n);
        }
        if (d == 0.0) {
            return Math.pow(d, n);
        }
        if (n == 0) {
            return 1.0;
        }
        if (n == 1) {
            return d;
        }
        if (mXparser.checkIfCanonicalRounding()) {
            BigDecimal bigDecimal = BigDecimal.valueOf(d);
            if (n >= 0) {
                return bigDecimal.pow(n).doubleValue();
            }
            return BigDecimal.ONE.divide(bigDecimal, MathContext.DECIMAL128).pow(-n).doubleValue();
        }
        return Math.pow(d, n);
    }

    public static final double power(double d, double d2) {
        double d3;
        double d4;
        double d5;
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d)) {
            Math.pow(d, d2);
        }
        if (Double.isInfinite(d2)) {
            Math.pow(d, d2);
        }
        if (MathFunctions.abs((d5 = Math.abs(d2)) - (d4 = (double)Math.round(d5))) <= 1.0E-14) {
            if (d2 >= 0.0) {
                return MathFunctions.powInt(d, (int)d4);
            }
            return MathFunctions.powInt(d, -((int)d4));
        }
        if (d >= 0.0) {
            return Math.pow(d, d2);
        }
        if (MathFunctions.abs(d2) >= 1.0) {
            return Math.pow(d, d2);
        }
        if (d2 == 0.0) {
            return Math.pow(d, d2);
        }
        double d6 = 1.0 / MathFunctions.abs(d2);
        if (MathFunctions.abs(d6 - (d3 = (double)Math.round(d6))) <= 1.0E-14) {
            long l = (long)d3;
            if (l % 2L == 1L) {
                if (d2 > 0.0) {
                    return -Math.pow(MathFunctions.abs(d), 1.0 / d6);
                }
                return -Math.pow(MathFunctions.abs(d), -1.0 / d6);
            }
            return Double.NaN;
        }
        return Double.NaN;
    }

    public static final double root(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d) || Double.isInfinite(d)) {
            return Double.NaN;
        }
        if (d < -1.0E-14) {
            return Double.NaN;
        }
        if (MathFunctions.abs(d) <= 1.0E-14) {
            if (MathFunctions.abs(d2) <= 1.0E-14) {
                return 0.0;
            }
            if (MathFunctions.abs(d2 - 1.0) <= 1.0E-14) {
                return 1.0;
            }
            return Double.NaN;
        }
        long l = (long)MathFunctions.floor(d);
        if (l == 1L) {
            return d2;
        }
        if (l == 2L) {
            return MathFunctions.sqrt(d2);
        }
        if (l % 2L == 1L) {
            if (d2 >= 0.0) {
                return Math.pow(d2, 1.0 / (double)l);
            }
            return -Math.pow(MathFunctions.abs(d2), 1.0 / (double)l);
        }
        if (d2 >= 0.0) {
            return Math.pow(d2, 1.0 / (double)l);
        }
        return Double.NaN;
    }

    public static final double tetration(double d, double d2) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            if (MathFunctions.abs(d - MathConstants.EXP_MINUS_E) <= 1.0E-14) {
                return 0.36787944117144233;
            }
            if (MathFunctions.abs(d - MathConstants.EXP_1_OVER_E) <= 1.0E-14) {
                return Math.E;
            }
            if (d > MathConstants.EXP_MINUS_E && d < MathConstants.EXP_1_OVER_E) {
                return SpecialFunctions.lambertW(-MathFunctions.ln(d), 0.0) / -MathFunctions.ln(d);
            }
            if (d > MathConstants.EXP_1_OVER_E) {
                return Double.POSITIVE_INFINITY;
            }
            if (d < MathConstants.EXP_MINUS_E) {
                return Double.NaN;
            }
        }
        if (d2 < -1.0E-14) {
            return Double.NaN;
        }
        if (MathFunctions.abs(d2) <= 1.0E-14) {
            if (MathFunctions.abs(d) > 1.0E-14) {
                return 1.0;
            }
            return Double.NaN;
        }
        if ((d2 = MathFunctions.floor(d2)) == 0.0) {
            if (MathFunctions.abs(d) > 1.0E-14) {
                return 1.0;
            }
            return Double.NaN;
        }
        if (MathFunctions.abs(d) <= 1.0E-14) {
            return 0.0;
        }
        if (d2 == 1.0) {
            return d;
        }
        double d3 = d;
        for (double d4 = 2.0; d4 <= d2; d4 += 1.0) {
            d3 = Math.pow(d, d3);
        }
        return d3;
    }

    public static final double mod(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        return d % d2;
    }

    public static final double sin(double d) {
        SpecialValueTrigonometric specialValueTrigonometric;
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (mXparser.checkIfDegreesMode()) {
            d *= Math.PI / 180;
        }
        if ((specialValueTrigonometric = SpecialValueTrigonometric.getSpecialValueTrigonometric(d)) != null) {
            return specialValueTrigonometric.sin;
        }
        return Math.sin(d);
    }

    public static final double cos(double d) {
        SpecialValueTrigonometric specialValueTrigonometric;
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (mXparser.checkIfDegreesMode()) {
            d *= Math.PI / 180;
        }
        if ((specialValueTrigonometric = SpecialValueTrigonometric.getSpecialValueTrigonometric(d)) != null) {
            return specialValueTrigonometric.cos;
        }
        return Math.cos(d);
    }

    public static final double tan(double d) {
        SpecialValueTrigonometric specialValueTrigonometric;
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (mXparser.checkIfDegreesMode()) {
            d *= Math.PI / 180;
        }
        if ((specialValueTrigonometric = SpecialValueTrigonometric.getSpecialValueTrigonometric(d)) != null) {
            return specialValueTrigonometric.tan;
        }
        return Math.tan(d);
    }

    public static final double ctan(double d) {
        SpecialValueTrigonometric specialValueTrigonometric;
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (mXparser.checkIfDegreesMode()) {
            d *= Math.PI / 180;
        }
        if ((specialValueTrigonometric = SpecialValueTrigonometric.getSpecialValueTrigonometric(d)) != null) {
            return specialValueTrigonometric.ctan;
        }
        double d2 = Double.NaN;
        double d3 = Math.tan(d);
        if (d3 != 0.0) {
            d2 = 1.0 / d3;
        }
        return d2;
    }

    public static final double sec(double d) {
        SpecialValueTrigonometric specialValueTrigonometric;
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (mXparser.checkIfDegreesMode()) {
            d *= Math.PI / 180;
        }
        if ((specialValueTrigonometric = SpecialValueTrigonometric.getSpecialValueTrigonometric(d)) != null) {
            return specialValueTrigonometric.sec;
        }
        double d2 = Double.NaN;
        double d3 = Math.cos(d);
        if (d3 != 0.0) {
            d2 = 1.0 / d3;
        }
        return d2;
    }

    public static final double cosec(double d) {
        SpecialValueTrigonometric specialValueTrigonometric;
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (mXparser.checkIfDegreesMode()) {
            d *= Math.PI / 180;
        }
        if ((specialValueTrigonometric = SpecialValueTrigonometric.getSpecialValueTrigonometric(d)) != null) {
            return specialValueTrigonometric.csc;
        }
        double d2 = Double.NaN;
        double d3 = Math.sin(d);
        if (d3 != 0.0) {
            d2 = 1.0 / d3;
        }
        return d2;
    }

    private static final double intIfAlmostIntOtherwiseOrig(double d) {
        double d2 = Math.round(d);
        if (Math.abs(d - d2) <= 1.0E-14) {
            return d2;
        }
        return d;
    }

    public static final double asin(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        SpecialValue specialValue = SpecialValueTrigonometric.getSpecialValueAsin(d);
        double d2 = specialValue != null ? specialValue.fv : Math.asin(d);
        if (mXparser.checkIfDegreesMode()) {
            if (specialValue != null) {
                return specialValue.fvdeg;
            }
            return MathFunctions.intIfAlmostIntOtherwiseOrig(d2 / (Math.PI / 180));
        }
        return d2;
    }

    public static final double acos(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        SpecialValue specialValue = SpecialValueTrigonometric.getSpecialValueAcos(d);
        double d2 = specialValue != null ? specialValue.fv : Math.acos(d);
        if (mXparser.checkIfDegreesMode()) {
            if (specialValue != null) {
                return specialValue.fvdeg;
            }
            return MathFunctions.intIfAlmostIntOtherwiseOrig(d2 / (Math.PI / 180));
        }
        return d2;
    }

    public static final double atan(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        SpecialValue specialValue = SpecialValueTrigonometric.getSpecialValueAtan(d);
        double d2 = specialValue != null ? specialValue.fv : Math.atan(d);
        if (mXparser.checkIfDegreesMode()) {
            if (specialValue != null) {
                return specialValue.fvdeg;
            }
            return MathFunctions.intIfAlmostIntOtherwiseOrig(d2 / (Math.PI / 180));
        }
        return d2;
    }

    public static final double actan(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        SpecialValue specialValue = SpecialValueTrigonometric.getSpecialValueActan(d);
        double d2 = specialValue != null ? specialValue.fv : (d > 0.0 ? Math.atan(1.0 / d) : (d < 0.0 ? Math.atan(1.0 / d) + Math.PI : Double.NaN));
        if (mXparser.checkIfDegreesMode()) {
            if (specialValue != null) {
                return specialValue.fvdeg;
            }
            return MathFunctions.intIfAlmostIntOtherwiseOrig(d2 / (Math.PI / 180));
        }
        return d2;
    }

    public static final double asec(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        SpecialValue specialValue = SpecialValueTrigonometric.getSpecialValueAsec(d);
        double d2 = specialValue != null ? specialValue.fv : Math.acos(1.0 / d);
        if (mXparser.checkIfDegreesMode()) {
            if (specialValue != null) {
                return specialValue.fvdeg;
            }
            return MathFunctions.intIfAlmostIntOtherwiseOrig(d2 / (Math.PI / 180));
        }
        return d2;
    }

    public static final double acosec(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        SpecialValue specialValue = SpecialValueTrigonometric.getSpecialValueAcsc(d);
        double d2 = specialValue != null ? specialValue.fv : Math.asin(1.0 / d);
        if (mXparser.checkIfDegreesMode()) {
            if (specialValue != null) {
                return specialValue.fvdeg;
            }
            return MathFunctions.intIfAlmostIntOtherwiseOrig(d2 / (Math.PI / 180));
        }
        return d2;
    }

    public static final double ln(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return Math.log(d);
    }

    public static final double log2(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return Math.log(d) / Math.log(2.0);
    }

    public static final double log10(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return Math.log10(d);
    }

    public static final double rad(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return Math.toRadians(d);
    }

    public static final double exp(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return Math.exp(d);
    }

    public static final double sqrt(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return Math.sqrt(d);
    }

    public static final double sinh(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return Math.sinh(d);
    }

    public static final double cosh(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return Math.cosh(d);
    }

    public static final double tanh(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return Math.tanh(d);
    }

    public static final double coth(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        double d2 = Double.NaN;
        double d3 = Math.tanh(d);
        if (d3 != 0.0) {
            d2 = 1.0 / d3;
        }
        return d2;
    }

    public static final double sech(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        double d2 = Double.NaN;
        double d3 = Math.cosh(d);
        if (d3 != 0.0) {
            d2 = 1.0 / d3;
        }
        return d2;
    }

    public static final double csch(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        double d2 = Double.NaN;
        double d3 = Math.sinh(d);
        if (d3 != 0.0) {
            d2 = 1.0 / d3;
        }
        return d2;
    }

    public static final double deg(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return Math.toDegrees(d);
    }

    public static final double abs(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return Math.abs(d);
    }

    public static final double sgn(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return Math.signum(d);
    }

    public static final double floor(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return Math.floor(d);
    }

    public static final double ceil(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return Math.ceil(d);
    }

    public static final double arsinh(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return Math.log(d + Math.sqrt(d * d + 1.0));
    }

    public static final double arcosh(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        return Math.log(d + Math.sqrt(d * d - 1.0));
    }

    public static final double artanh(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        double d2 = Double.NaN;
        if (1.0 - d != 0.0) {
            d2 = 0.5 * Math.log((1.0 + d) / (1.0 - d));
        }
        return d2;
    }

    public static final double arcoth(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        double d2 = Double.NaN;
        if (d - 1.0 != 0.0) {
            d2 = 0.5 * Math.log((d + 1.0) / (d - 1.0));
        }
        return d2;
    }

    public static final double arsech(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        double d2 = Double.NaN;
        if (d != 0.0) {
            d2 = Math.log((1.0 + Math.sqrt(1.0 - d * d)) / d);
        }
        return d2;
    }

    public static final double arcsch(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        double d2 = Double.NaN;
        if (d != 0.0) {
            d2 = Math.log(1.0 / d + Math.sqrt(1.0 + d * d) / Math.abs(d));
        }
        return d2;
    }

    public static final double sa(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        double d2 = Math.PI * d;
        double d3 = Double.NaN;
        d3 = d2 != 0.0 ? Math.sin(d2) / d2 : 1.0;
        return d3;
    }

    public static final double sinc(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        double d2 = Double.NaN;
        d2 = d != 0.0 ? (mXparser.checkIfDegreesMode() ? Math.sin(d * (Math.PI / 180)) / d : Math.sin(d) / d) : 1.0;
        return d2;
    }

    public static final double log(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        double d3 = Double.NaN;
        double d4 = Math.log(d2);
        if (d4 != 0.0) {
            d3 = Math.log(d) / d4;
        }
        return d3;
    }

    public static final double round(double d, int n) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d)) {
            return d;
        }
        if (n < 0) {
            return Double.NaN;
        }
        BigDecimal bigDecimal = new BigDecimal(Double.toString(d));
        bigDecimal = bigDecimal.setScale(n, RoundingMode.HALF_UP);
        return bigDecimal.doubleValue();
    }

    public static final double roundHalfUp(double d, int n) {
        int n2;
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (n < 0) {
            return Double.NaN;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = 1.0;
        double d3 = d;
        if (d < 0.0) {
            d2 = -1.0;
            d = -d;
        }
        if ((n2 = MathFunctions.ulpDecimalDigitsBefore(d)) <= 0) {
            return d2 * Math.floor(d);
        }
        if (n > n2) {
            return d3;
        }
        double d4 = 1.0;
        for (int i = 0; i < n; ++i) {
            d4 = Math.floor(d4 * 10.0);
        }
        double d5 = d * d4;
        double d6 = Math.floor(d5);
        if (Math.abs(d5 - d6) >= 0.5) {
            d6 = Math.floor(d6 + 1.0);
        }
        return Math.floor(d2 * d6) / d4;
    }

    public static final double roundDown(double d, int n) {
        int n2;
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (n < 0) {
            return Double.NaN;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = 1.0;
        double d3 = d;
        if (d < 0.0) {
            d2 = -1.0;
            d = -d;
        }
        if ((n2 = MathFunctions.ulpDecimalDigitsBefore(d)) <= 0) {
            return d2 * Math.floor(d);
        }
        if (n > n2) {
            return d3;
        }
        double d4 = 1.0;
        for (int i = 0; i < n; ++i) {
            d4 = Math.floor(d4 * 10.0);
        }
        double d5 = d * d4;
        double d6 = Math.floor(d5);
        return Math.floor(d2 * d6) / d4;
    }

    public static final double roundUlp(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d) || d == 0.0) {
            return d;
        }
        int n = MathFunctions.ulpDecimalDigitsBefore(d);
        if (n >= 1) {
            return MathFunctions.round(d, n - 5);
        }
        if (n == 0) {
            return MathFunctions.round(d, 0);
        }
        return d;
    }

    public static final double integerPart(double d) {
        if (d > 0.0) {
            return Math.floor(d);
        }
        if (d < 0.0) {
            return -Math.floor(-d);
        }
        return 0.0;
    }

    public static final int decimalDigitsBefore(double d) {
        if (d == 0.0) {
            return -1;
        }
        if (d <= 9.9E-323) {
            return 322;
        }
        if (d <= 1.0E-321) {
            return 321;
        }
        if (d <= 1.0E-320) {
            return 320;
        }
        if (d <= 1.0E-319) {
            return 319;
        }
        if (d <= 1.0E-318) {
            return 318;
        }
        if (d <= 1.0E-317) {
            return 317;
        }
        if (d <= 1.0E-316) {
            return 316;
        }
        if (d <= 1.0E-315) {
            return 315;
        }
        if (d <= 1.0E-314) {
            return 314;
        }
        if (d <= 1.0E-313) {
            return 313;
        }
        if (d <= 1.0E-312) {
            return 312;
        }
        if (d <= 1.0E-311) {
            return 311;
        }
        if (d <= 1.0E-310) {
            return 310;
        }
        if (d <= 1.0E-309) {
            return 309;
        }
        if (d <= 1.0E-308) {
            return 308;
        }
        if (d <= 1.0E-307) {
            return 307;
        }
        if (d <= 1.0E-306) {
            return 306;
        }
        if (d <= 1.0E-305) {
            return 305;
        }
        if (d <= 1.0E-304) {
            return 304;
        }
        if (d <= 1.0E-303) {
            return 303;
        }
        if (d <= 1.0E-302) {
            return 302;
        }
        if (d <= 1.0E-301) {
            return 301;
        }
        if (d <= 1.0E-300) {
            return 300;
        }
        if (d <= 1.0E-299) {
            return 299;
        }
        if (d <= 1.0E-298) {
            return 298;
        }
        if (d <= 1.0E-297) {
            return 297;
        }
        if (d <= 1.0E-296) {
            return 296;
        }
        if (d <= 1.0E-295) {
            return 295;
        }
        if (d <= 1.0E-294) {
            return 294;
        }
        if (d <= 1.0E-293) {
            return 293;
        }
        if (d <= 1.0E-292) {
            return 292;
        }
        if (d <= 1.0E-291) {
            return 291;
        }
        if (d <= 1.0E-290) {
            return 290;
        }
        if (d <= 1.0E-289) {
            return 289;
        }
        if (d <= 1.0E-288) {
            return 288;
        }
        if (d <= 1.0E-287) {
            return 287;
        }
        if (d <= 1.0E-286) {
            return 286;
        }
        if (d <= 1.0E-285) {
            return 285;
        }
        if (d <= 1.0E-284) {
            return 284;
        }
        if (d <= 1.0E-283) {
            return 283;
        }
        if (d <= 1.0E-282) {
            return 282;
        }
        if (d <= 1.0E-281) {
            return 281;
        }
        if (d <= 1.0E-280) {
            return 280;
        }
        if (d <= 1.0E-279) {
            return 279;
        }
        if (d <= 1.0E-278) {
            return 278;
        }
        if (d <= 1.0E-277) {
            return 277;
        }
        if (d <= 1.0E-276) {
            return 276;
        }
        if (d <= 1.0E-275) {
            return 275;
        }
        if (d <= 1.0E-274) {
            return 274;
        }
        if (d <= 1.0E-273) {
            return 273;
        }
        if (d <= 1.0E-272) {
            return 272;
        }
        if (d <= 1.0E-271) {
            return 271;
        }
        if (d <= 1.0E-270) {
            return 270;
        }
        if (d <= 1.0E-269) {
            return 269;
        }
        if (d <= 1.0E-268) {
            return 268;
        }
        if (d <= 1.0E-267) {
            return 267;
        }
        if (d <= 1.0E-266) {
            return 266;
        }
        if (d <= 1.0E-265) {
            return 265;
        }
        if (d <= 1.0E-264) {
            return 264;
        }
        if (d <= 1.0E-263) {
            return 263;
        }
        if (d <= 1.0E-262) {
            return 262;
        }
        if (d <= 1.0E-261) {
            return 261;
        }
        if (d <= 1.0E-260) {
            return 260;
        }
        if (d <= 1.0E-259) {
            return 259;
        }
        if (d <= 1.0E-258) {
            return 258;
        }
        if (d <= 1.0E-257) {
            return 257;
        }
        if (d <= 1.0E-256) {
            return 256;
        }
        if (d <= 1.0E-255) {
            return 255;
        }
        if (d <= 1.0E-254) {
            return 254;
        }
        if (d <= 1.0E-253) {
            return 253;
        }
        if (d <= 1.0E-252) {
            return 252;
        }
        if (d <= 1.0E-251) {
            return 251;
        }
        if (d <= 1.0E-250) {
            return 250;
        }
        if (d <= 1.0E-249) {
            return 249;
        }
        if (d <= 1.0E-248) {
            return 248;
        }
        if (d <= 1.0E-247) {
            return 247;
        }
        if (d <= 1.0E-246) {
            return 246;
        }
        if (d <= 1.0E-245) {
            return 245;
        }
        if (d <= 1.0E-244) {
            return 244;
        }
        if (d <= 1.0E-243) {
            return 243;
        }
        if (d <= 1.0E-242) {
            return 242;
        }
        if (d <= 1.0E-241) {
            return 241;
        }
        if (d <= 1.0E-240) {
            return 240;
        }
        if (d <= 1.0E-239) {
            return 239;
        }
        if (d <= 1.0E-238) {
            return 238;
        }
        if (d <= 1.0E-237) {
            return 237;
        }
        if (d <= 1.0E-236) {
            return 236;
        }
        if (d <= 1.0E-235) {
            return 235;
        }
        if (d <= 1.0E-234) {
            return 234;
        }
        if (d <= 1.0E-233) {
            return 233;
        }
        if (d <= 1.0E-232) {
            return 232;
        }
        if (d <= 1.0E-231) {
            return 231;
        }
        if (d <= 1.0E-230) {
            return 230;
        }
        if (d <= 1.0E-229) {
            return 229;
        }
        if (d <= 1.0E-228) {
            return 228;
        }
        if (d <= 1.0E-227) {
            return 227;
        }
        if (d <= 1.0E-226) {
            return 226;
        }
        if (d <= 1.0E-225) {
            return 225;
        }
        if (d <= 1.0E-224) {
            return 224;
        }
        if (d <= 1.0E-223) {
            return 223;
        }
        if (d <= 1.0E-222) {
            return 222;
        }
        if (d <= 1.0E-221) {
            return 221;
        }
        if (d <= 1.0E-220) {
            return 220;
        }
        if (d <= 1.0E-219) {
            return 219;
        }
        if (d <= 1.0E-218) {
            return 218;
        }
        if (d <= 1.0E-217) {
            return 217;
        }
        if (d <= 1.0E-216) {
            return 216;
        }
        if (d <= 1.0E-215) {
            return 215;
        }
        if (d <= 1.0E-214) {
            return 214;
        }
        if (d <= 1.0E-213) {
            return 213;
        }
        if (d <= 1.0E-212) {
            return 212;
        }
        if (d <= 1.0E-211) {
            return 211;
        }
        if (d <= 1.0E-210) {
            return 210;
        }
        if (d <= 1.0E-209) {
            return 209;
        }
        if (d <= 1.0E-208) {
            return 208;
        }
        if (d <= 1.0E-207) {
            return 207;
        }
        if (d <= 1.0E-206) {
            return 206;
        }
        if (d <= 1.0E-205) {
            return 205;
        }
        if (d <= 1.0E-204) {
            return 204;
        }
        if (d <= 1.0E-203) {
            return 203;
        }
        if (d <= 1.0E-202) {
            return 202;
        }
        if (d <= 1.0E-201) {
            return 201;
        }
        if (d <= 1.0E-200) {
            return 200;
        }
        if (d <= 1.0E-199) {
            return 199;
        }
        if (d <= 1.0E-198) {
            return 198;
        }
        if (d <= 1.0E-197) {
            return 197;
        }
        if (d <= 1.0E-196) {
            return 196;
        }
        if (d <= 1.0E-195) {
            return 195;
        }
        if (d <= 1.0E-194) {
            return 194;
        }
        if (d <= 1.0E-193) {
            return 193;
        }
        if (d <= 1.0E-192) {
            return 192;
        }
        if (d <= 1.0E-191) {
            return 191;
        }
        if (d <= 1.0E-190) {
            return 190;
        }
        if (d <= 1.0E-189) {
            return 189;
        }
        if (d <= 1.0E-188) {
            return 188;
        }
        if (d <= 1.0E-187) {
            return 187;
        }
        if (d <= 1.0E-186) {
            return 186;
        }
        if (d <= 1.0E-185) {
            return 185;
        }
        if (d <= 1.0E-184) {
            return 184;
        }
        if (d <= 1.0E-183) {
            return 183;
        }
        if (d <= 1.0E-182) {
            return 182;
        }
        if (d <= 1.0E-181) {
            return 181;
        }
        if (d <= 1.0E-180) {
            return 180;
        }
        if (d <= 1.0E-179) {
            return 179;
        }
        if (d <= 1.0E-178) {
            return 178;
        }
        if (d <= 1.0E-177) {
            return 177;
        }
        if (d <= 1.0E-176) {
            return 176;
        }
        if (d <= 1.0E-175) {
            return 175;
        }
        if (d <= 1.0E-174) {
            return 174;
        }
        if (d <= 1.0E-173) {
            return 173;
        }
        if (d <= 1.0E-172) {
            return 172;
        }
        if (d <= 1.0E-171) {
            return 171;
        }
        if (d <= 1.0E-170) {
            return 170;
        }
        if (d <= 1.0E-169) {
            return 169;
        }
        if (d <= 1.0E-168) {
            return 168;
        }
        if (d <= 1.0E-167) {
            return 167;
        }
        if (d <= 1.0E-166) {
            return 166;
        }
        if (d <= 1.0E-165) {
            return 165;
        }
        if (d <= 1.0E-164) {
            return 164;
        }
        if (d <= 1.0E-163) {
            return 163;
        }
        if (d <= 1.0E-162) {
            return 162;
        }
        if (d <= 1.0E-161) {
            return 161;
        }
        if (d <= 1.0E-160) {
            return 160;
        }
        if (d <= 1.0E-159) {
            return 159;
        }
        if (d <= 1.0E-158) {
            return 158;
        }
        if (d <= 1.0E-157) {
            return 157;
        }
        if (d <= 1.0E-156) {
            return 156;
        }
        if (d <= 1.0E-155) {
            return 155;
        }
        if (d <= 1.0E-154) {
            return 154;
        }
        if (d <= 1.0E-153) {
            return 153;
        }
        if (d <= 1.0E-152) {
            return 152;
        }
        if (d <= 1.0E-151) {
            return 151;
        }
        if (d <= 1.0E-150) {
            return 150;
        }
        if (d <= 1.0E-149) {
            return 149;
        }
        if (d <= 1.0E-148) {
            return 148;
        }
        if (d <= 1.0E-147) {
            return 147;
        }
        if (d <= 1.0E-146) {
            return 146;
        }
        if (d <= 1.0E-145) {
            return 145;
        }
        if (d <= 1.0E-144) {
            return 144;
        }
        if (d <= 1.0E-143) {
            return 143;
        }
        if (d <= 1.0E-142) {
            return 142;
        }
        if (d <= 1.0E-141) {
            return 141;
        }
        if (d <= 1.0E-140) {
            return 140;
        }
        if (d <= 1.0E-139) {
            return 139;
        }
        if (d <= 1.0E-138) {
            return 138;
        }
        if (d <= 1.0E-137) {
            return 137;
        }
        if (d <= 1.0E-136) {
            return 136;
        }
        if (d <= 1.0E-135) {
            return 135;
        }
        if (d <= 1.0E-134) {
            return 134;
        }
        if (d <= 1.0E-133) {
            return 133;
        }
        if (d <= 1.0E-132) {
            return 132;
        }
        if (d <= 1.0E-131) {
            return 131;
        }
        if (d <= 1.0E-130) {
            return 130;
        }
        if (d <= 1.0E-129) {
            return 129;
        }
        if (d <= 1.0E-128) {
            return 128;
        }
        if (d <= 1.0E-127) {
            return 127;
        }
        if (d <= 1.0E-126) {
            return 126;
        }
        if (d <= 1.0E-125) {
            return 125;
        }
        if (d <= 1.0E-124) {
            return 124;
        }
        if (d <= 1.0E-123) {
            return 123;
        }
        if (d <= 1.0E-122) {
            return 122;
        }
        if (d <= 1.0E-121) {
            return 121;
        }
        if (d <= 1.0E-120) {
            return 120;
        }
        if (d <= 1.0E-119) {
            return 119;
        }
        if (d <= 1.0E-118) {
            return 118;
        }
        if (d <= 1.0E-117) {
            return 117;
        }
        if (d <= 1.0E-116) {
            return 116;
        }
        if (d <= 1.0E-115) {
            return 115;
        }
        if (d <= 1.0E-114) {
            return 114;
        }
        if (d <= 1.0E-113) {
            return 113;
        }
        if (d <= 1.0E-112) {
            return 112;
        }
        if (d <= 1.0E-111) {
            return 111;
        }
        if (d <= 1.0E-110) {
            return 110;
        }
        if (d <= 1.0E-109) {
            return 109;
        }
        if (d <= 1.0E-108) {
            return 108;
        }
        if (d <= 1.0E-107) {
            return 107;
        }
        if (d <= 1.0E-106) {
            return 106;
        }
        if (d <= 1.0E-105) {
            return 105;
        }
        if (d <= 1.0E-104) {
            return 104;
        }
        if (d <= 1.0E-103) {
            return 103;
        }
        if (d <= 1.0E-102) {
            return 102;
        }
        if (d <= 1.0E-101) {
            return 101;
        }
        if (d <= 1.0E-100) {
            return 100;
        }
        if (d <= 1.0E-99) {
            return 99;
        }
        if (d <= 1.0E-98) {
            return 98;
        }
        if (d <= 1.0E-97) {
            return 97;
        }
        if (d <= 1.0E-96) {
            return 96;
        }
        if (d <= 1.0E-95) {
            return 95;
        }
        if (d <= 1.0E-94) {
            return 94;
        }
        if (d <= 1.0E-93) {
            return 93;
        }
        if (d <= 1.0E-92) {
            return 92;
        }
        if (d <= 1.0E-91) {
            return 91;
        }
        if (d <= 1.0E-90) {
            return 90;
        }
        if (d <= 1.0E-89) {
            return 89;
        }
        if (d <= 1.0E-88) {
            return 88;
        }
        if (d <= 1.0E-87) {
            return 87;
        }
        if (d <= 1.0E-86) {
            return 86;
        }
        if (d <= 1.0E-85) {
            return 85;
        }
        if (d <= 1.0E-84) {
            return 84;
        }
        if (d <= 1.0E-83) {
            return 83;
        }
        if (d <= 1.0E-82) {
            return 82;
        }
        if (d <= 1.0E-81) {
            return 81;
        }
        if (d <= 1.0E-80) {
            return 80;
        }
        if (d <= 1.0E-79) {
            return 79;
        }
        if (d <= 1.0E-78) {
            return 78;
        }
        if (d <= 1.0E-77) {
            return 77;
        }
        if (d <= 1.0E-76) {
            return 76;
        }
        if (d <= 1.0E-75) {
            return 75;
        }
        if (d <= 1.0E-74) {
            return 74;
        }
        if (d <= 1.0E-73) {
            return 73;
        }
        if (d <= 1.0E-72) {
            return 72;
        }
        if (d <= 1.0E-71) {
            return 71;
        }
        if (d <= 1.0E-70) {
            return 70;
        }
        if (d <= 1.0E-69) {
            return 69;
        }
        if (d <= 1.0E-68) {
            return 68;
        }
        if (d <= 1.0E-67) {
            return 67;
        }
        if (d <= 1.0E-66) {
            return 66;
        }
        if (d <= 1.0E-65) {
            return 65;
        }
        if (d <= 1.0E-64) {
            return 64;
        }
        if (d <= 1.0E-63) {
            return 63;
        }
        if (d <= 1.0E-62) {
            return 62;
        }
        if (d <= 1.0E-61) {
            return 61;
        }
        if (d <= 1.0E-60) {
            return 60;
        }
        if (d <= 1.0E-59) {
            return 59;
        }
        if (d <= 1.0E-58) {
            return 58;
        }
        if (d <= 1.0E-57) {
            return 57;
        }
        if (d <= 1.0E-56) {
            return 56;
        }
        if (d <= 1.0E-55) {
            return 55;
        }
        if (d <= 1.0E-54) {
            return 54;
        }
        if (d <= 1.0E-53) {
            return 53;
        }
        if (d <= 1.0E-52) {
            return 52;
        }
        if (d <= 1.0E-51) {
            return 51;
        }
        if (d <= 1.0E-50) {
            return 50;
        }
        if (d <= 1.0E-49) {
            return 49;
        }
        if (d <= 1.0E-48) {
            return 48;
        }
        if (d <= 1.0E-47) {
            return 47;
        }
        if (d <= 1.0E-46) {
            return 46;
        }
        if (d <= 1.0E-45) {
            return 45;
        }
        if (d <= 1.0E-44) {
            return 44;
        }
        if (d <= 1.0E-43) {
            return 43;
        }
        if (d <= 1.0E-42) {
            return 42;
        }
        if (d <= 1.0E-41) {
            return 41;
        }
        if (d <= 1.0E-40) {
            return 40;
        }
        if (d <= 1.0E-39) {
            return 39;
        }
        if (d <= 1.0E-38) {
            return 38;
        }
        if (d <= 1.0E-37) {
            return 37;
        }
        if (d <= 1.0E-36) {
            return 36;
        }
        if (d <= 1.0E-35) {
            return 35;
        }
        if (d <= 1.0E-34) {
            return 34;
        }
        if (d <= 1.0E-33) {
            return 33;
        }
        if (d <= 1.0E-32) {
            return 32;
        }
        if (d <= 1.0E-31) {
            return 31;
        }
        if (d <= 1.0E-30) {
            return 30;
        }
        if (d <= 1.0E-29) {
            return 29;
        }
        if (d <= 1.0E-28) {
            return 28;
        }
        if (d <= 1.0E-27) {
            return 27;
        }
        if (d <= 1.0E-26) {
            return 26;
        }
        if (d <= 1.0E-25) {
            return 25;
        }
        if (d <= 1.0E-24) {
            return 24;
        }
        if (d <= 1.0E-23) {
            return 23;
        }
        if (d <= 1.0E-22) {
            return 22;
        }
        if (d <= 1.0E-21) {
            return 21;
        }
        if (d <= 1.0E-20) {
            return 20;
        }
        if (d <= 1.0E-19) {
            return 19;
        }
        if (d <= 1.0E-18) {
            return 18;
        }
        if (d <= 1.0E-17) {
            return 17;
        }
        if (d <= 1.0E-16) {
            return 16;
        }
        if (d <= 1.0E-15) {
            return 15;
        }
        if (d <= 1.0E-14) {
            return 14;
        }
        if (d <= 1.0E-13) {
            return 13;
        }
        if (d <= 1.0E-12) {
            return 12;
        }
        if (d <= 1.0E-11) {
            return 11;
        }
        if (d <= 1.0E-10) {
            return 10;
        }
        if (d <= 1.0E-9) {
            return 9;
        }
        if (d <= 1.0E-8) {
            return 8;
        }
        if (d <= 1.0E-7) {
            return 7;
        }
        if (d <= 1.0E-6) {
            return 6;
        }
        if (d <= 1.0E-5) {
            return 5;
        }
        if (d <= 1.0E-4) {
            return 4;
        }
        if (d <= 0.001) {
            return 3;
        }
        if (d <= 0.01) {
            return 2;
        }
        if (d <= 0.1) {
            return 1;
        }
        if (d <= 1.0) {
            return 0;
        }
        return -1;
    }

    public static final double ulp(double d) {
        return Math.ulp(d);
    }

    public static final int ulpDecimalDigitsBefore(double d) {
        if (Double.isNaN(d)) {
            return -2;
        }
        double d2 = MathFunctions.ulp(d);
        return MathFunctions.decimalDigitsBefore(d2);
    }

    public static final double coalesce(double[] dArray) {
        if (dArray == null) {
            return Double.NaN;
        }
        if (dArray.length == 0) {
            return Double.NaN;
        }
        for (double d : dArray) {
            if (Double.isNaN(d)) continue;
            return d;
        }
        return Double.NaN;
    }

    public static final boolean isInteger(double d) {
        double d2;
        if (Double.isNaN(d)) {
            return false;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return false;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return false;
        }
        if (d < 0.0) {
            d = -d;
        }
        return Math.abs(d - (d2 = (double)Math.round(d))) < 1.0E-14;
    }

    public static final boolean almostEqual(double d, double d2) {
        if (Double.isNaN(d)) {
            return false;
        }
        if (Double.isNaN(d2)) {
            return false;
        }
        if (d == d2) {
            return true;
        }
        return Math.abs(d - d2) <= 1.0E-14;
    }
}

