/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.mathcollection;

import org.mariuszgromada.math.mxparser.mathcollection.MathFunctions;
import org.mariuszgromada.math.mxparser.mathcollection.NumberTheory;

public final class BinaryRelations {
    public static final double DEFAULT_COMPARISON_EPSILON = 1.0E-14;
    static double epsilon = 1.0E-14;
    static boolean epsilonComparison = true;

    public static final void setExactComparison() {
        epsilonComparison = false;
    }

    public static final void setEpsilonComparison() {
        epsilonComparison = true;
    }

    public static final void setEpsilon(double d) {
        if (d > 0.0) {
            epsilon = d;
        }
    }

    public static final void setDefaultEpsilon() {
        epsilon = 1.0E-14;
    }

    public static final double getEpsilon() {
        return epsilon;
    }

    public static final boolean checkIfEpsilonMode() {
        return epsilonComparison;
    }

    public static final boolean checkIfExactMode() {
        return !epsilonComparison;
    }

    public static final double eq(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        double d3 = NumberTheory.max(epsilon, MathFunctions.ulp(d2));
        if (Double.isInfinite(d) || Double.isInfinite(d2)) {
            d3 = 0.0;
        }
        double d4 = 0.0;
        if (epsilonComparison) {
            if (MathFunctions.abs(d - d2) <= d3) {
                d4 = 1.0;
            }
        } else if (d == d2) {
            d4 = 1.0;
        }
        return d4;
    }

    public static final double neq(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        double d3 = NumberTheory.max(epsilon, MathFunctions.ulp(d2));
        if (Double.isInfinite(d) || Double.isInfinite(d2)) {
            d3 = 0.0;
        }
        double d4 = 0.0;
        if (epsilonComparison) {
            if (MathFunctions.abs(d - d2) > d3) {
                d4 = 1.0;
            }
        } else if (d != d2) {
            d4 = 1.0;
        }
        return d4;
    }

    public static final double lt(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        double d3 = NumberTheory.max(epsilon, MathFunctions.ulp(d2));
        if (Double.isInfinite(d) || Double.isInfinite(d2)) {
            d3 = 0.0;
        }
        double d4 = 0.0;
        if (epsilonComparison) {
            if (d < d2 - d3) {
                d4 = 1.0;
            }
        } else if (d < d2) {
            d4 = 1.0;
        }
        return d4;
    }

    public static final double gt(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        double d3 = NumberTheory.max(epsilon, MathFunctions.ulp(d2));
        if (Double.isInfinite(d) || Double.isInfinite(d2)) {
            d3 = 0.0;
        }
        double d4 = 0.0;
        if (epsilonComparison) {
            if (d > d2 + d3) {
                d4 = 1.0;
            }
        } else if (d > d2) {
            d4 = 1.0;
        }
        return d4;
    }

    public static final double leq(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        double d3 = NumberTheory.max(epsilon, MathFunctions.ulp(d2));
        if (Double.isInfinite(d) || Double.isInfinite(d2)) {
            d3 = 0.0;
        }
        double d4 = 0.0;
        if (epsilonComparison) {
            if (d <= d2 + d3) {
                d4 = 1.0;
            }
        } else if (d <= d2) {
            d4 = 1.0;
        }
        return d4;
    }

    public static final double geq(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        double d3 = NumberTheory.max(epsilon, MathFunctions.ulp(d2));
        if (Double.isInfinite(d) || Double.isInfinite(d2)) {
            d3 = 0.0;
        }
        double d4 = 0.0;
        if (epsilonComparison) {
            if (d >= d2 - d3) {
                d4 = 1.0;
            }
        } else if (d >= d2) {
            d4 = 1.0;
        }
        return d4;
    }
}

