/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import org.mariuszgromada.math.mxparser.TokenModification;
import org.mariuszgromada.math.mxparser.mathcollection.BinaryRelations;
import org.mariuszgromada.math.mxparser.mathcollection.NumberTheory;
import org.mariuszgromada.math.mxparser.mathcollection.PrimesCache;
import org.mariuszgromada.math.mxparser.mathcollection.ProbabilityDistributions;
import org.mariuszgromada.math.mxparser.parsertokens.KeyWord;
import org.mariuszgromada.math.mxparser.parsertokens.Token;

public final class mXparser {
    public static final String VERSION = "4.4.0";
    public static final String VERSION_CODE_NAME = "Gemoni";
    public static final String VERSION_NAME = "4.4.0 Gemoni";
    public static final String BUIT_FOR = "JDK 8";
    static final int NOT_FOUND = -1;
    static final int FOUND = 0;
    private static volatile String CONSOLE_OUTPUT = "";
    private static volatile String CONSOLE_PREFIX;
    private static volatile String CONSOLE_OUTPUT_PREFIX;
    private static volatile int CONSOLE_ROW_NUMBER;
    public static volatile PrimesCache primesCache;
    public static final int PRIMES_CACHE_NOT_INITIALIZED = -1;
    private static int THREADS_NUMBER;
    static volatile Expression mXparserExp;
    static volatile boolean ulpRounding;
    static volatile boolean canonicalRounding;
    static volatile boolean almostIntRounding;
    static final int DEFAULT_MAX_RECURSION_CALLS = 200;
    static volatile int MAX_RECURSION_CALLS;
    static volatile List<String> tokensToRemove;
    static volatile List<TokenModification> tokensToModify;
    static volatile boolean degreesMode;
    static volatile boolean overrideBuiltinTokens;
    static volatile int optionsChangesetNumber;
    private static volatile boolean cancelCurrentCalculationFlag;
    public static final String LICENSE = "                      mXparser - version 4.4.0\n         A flexible mathematical eXpressions parser for JAVA.\n\nYou may use this software under the condition of Simplified BSD License:\n\nCopyright 2010-2018 MARIUSZ GROMADA. All rights reserved.\n\nRedistribution and use in source and binary forms, with or without modification, are\npermitted provided that the following conditions are met:\n\n   1. Redistributions of source code must retain the above copyright notice, this list of\n      conditions and the following disclaimer.\n\n   2. Redistributions in binary form must reproduce the above copyright notice, this list\n      of conditions and the following disclaimer in the documentation and/or other materials\n      provided with the distribution.\n\nTHIS SOFTWARE IS PROVIDED BY MARIUSZ GROMADA ``AS IS'' AND ANY EXPRESS OR IMPLIED\nWARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND\nFITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL MARIUSZ GROMADA OR\nCONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR\nCONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR\nSERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON\nANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\nNEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF\nADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n\nThe views and conclusions contained in the software and documentation are those of the\nauthors and should not be interpreted as representing official policies, either expressed\nor implied, of MARIUSZ GROMADA.\n\nIf you have any questions/bugs feel free to contact:\n\n    Mariusz Gromada\n    mariuszgromada.org@gmail.com\n    http://mathspace.plt/\n    http://mathparser.org/\n    http://github.com/mariuszgromada/MathParser.org-mXparser\n    http://mariuszgromada.github.io/MathParser.org-mXparser/\n    http://mxparser.sourceforge.net/\n    http://bitbucket.org/mariuszgromada/mxparser/\n    http://mxparser.codeplex.com/\n    http://janetsudoku.mariuszgromada.org/\n";
    public static final String NAMEv10 = "1.0";
    public static final String NAMEv20 = "2.0";
    public static final String NAMEv23 = "2.3";
    public static final String NAMEv24 = "2.4";
    public static final String NAMEv30 = "3.0";
    public static final String NAMEv40 = "4.0";
    public static final String NAMEv41 = "4.1";
    public static final String NAMEv42 = "4.2";
    public static final String NAMEv43 = "4.3";
    public static final String NAMEv44 = "4.4";

    public static final void initPrimesCache() {
        primesCache = new PrimesCache();
    }

    public static final void initPrimesCache(int n) {
        primesCache = new PrimesCache(n);
    }

    public static final void initPrimesCache(PrimesCache primesCache) {
        mXparser.primesCache = primesCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isInitPrimesCacheSuccessful() {
        if (primesCache == null) {
            return false;
        }
        PrimesCache primesCache = mXparser.primesCache;
        synchronized (primesCache) {
            return mXparser.primesCache.isInitSuccessful();
        }
    }

    public static void setNoPrimesCache() {
        primesCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int getMaxNumInPrimesCache() {
        if (primesCache != null) {
            PrimesCache primesCache = mXparser.primesCache;
            synchronized (primesCache) {
                return mXparser.primesCache.getMaxNumInCache();
            }
        }
        return -1;
    }

    public static final int getThreadsNumber() {
        return THREADS_NUMBER;
    }

    public static final void setDefaultThreadsNumber() {
        THREADS_NUMBER = Runtime.getRuntime().availableProcessors();
    }

    public static final void setThreadsNumber(int n) {
        if (n > 0) {
            THREADS_NUMBER = n;
        }
    }

    public static final double getFunctionValue(Expression expression, Argument argument, double d) {
        argument.setArgumentValue(d);
        return expression.calculate();
    }

    public static final double[] arrayList2double(List<Double> list) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = list.get(i);
        }
        return dArray;
    }

    public static final double[] getFunctionValues(Expression expression, Argument argument, double d, double d2, double d3) {
        double[] dArray;
        if (Double.isNaN(d3) || Double.isNaN(d) || Double.isNaN(d2) || d3 == 0.0) {
            return null;
        }
        int n = 0;
        if (d2 >= d && d3 > 0.0) {
            for (double d4 = d; d4 < d2; d4 += d3) {
                ++n;
            }
            dArray = new double[++n];
            int n2 = 0;
            for (double d5 = d; d5 < d2; d5 += d3) {
                dArray[n2] = mXparser.getFunctionValue(expression, argument, d5);
                ++n2;
            }
            dArray[n2] = mXparser.getFunctionValue(expression, argument, d2);
        } else if (d2 <= d && d3 < 0.0) {
            for (double d6 = d; d6 > d2; d6 += d3) {
                ++n;
            }
            dArray = new double[++n];
            int n3 = 0;
            for (double d7 = d; d7 > d2; d7 += d3) {
                dArray[n3] = mXparser.getFunctionValue(expression, argument, d7);
                ++n3;
            }
            dArray[n3] = mXparser.getFunctionValue(expression, argument, d2);
        } else if (d == d2) {
            n = 1;
            dArray = new double[n];
            dArray[0] = mXparser.getFunctionValue(expression, argument, d);
        } else {
            dArray = null;
        }
        return dArray;
    }

    public static final void setRandomGenerator(Random random) {
        if (random != null) {
            ProbabilityDistributions.randomGenerator = random;
        }
    }

    public static final void setExactComparison() {
        BinaryRelations.setExactComparison();
    }

    public static final void setEpsilonComparison() {
        BinaryRelations.setEpsilonComparison();
    }

    public static final void setEpsilon(double d) {
        BinaryRelations.setEpsilon(d);
    }

    public static final void setDefaultEpsilon() {
        BinaryRelations.setDefaultEpsilon();
    }

    public static final double getEpsilon() {
        return BinaryRelations.getEpsilon();
    }

    public static final boolean checkIfEpsilonMode() {
        return BinaryRelations.checkIfEpsilonMode();
    }

    public static final boolean checkIfExactMode() {
        return BinaryRelations.checkIfExactMode();
    }

    public static final void enableUlpRounding() {
        ulpRounding = true;
    }

    public static final void disableUlpRounding() {
        ulpRounding = false;
    }

    public static final void setUlpRounding(boolean bl) {
        ulpRounding = bl;
    }

    public static final boolean checkIfUlpRounding() {
        return ulpRounding;
    }

    public static final void enableCanonicalRounding() {
        canonicalRounding = true;
    }

    public static final void disableCanonicalRounding() {
        canonicalRounding = false;
    }

    public static final void setCanonicalRounding(boolean bl) {
        canonicalRounding = bl;
    }

    public static final boolean checkIfCanonicalRounding() {
        return canonicalRounding;
    }

    public static final void enableAlmostIntRounding() {
        almostIntRounding = true;
    }

    public static final void disableAlmostIntRounding() {
        almostIntRounding = false;
    }

    public static final void setAlmostIntRounding(boolean bl) {
        almostIntRounding = bl;
    }

    public static final boolean checkIfAlmostIntRounding() {
        return almostIntRounding;
    }

    public static final void setMaxAllowedRecursionDepth(int n) {
        MAX_RECURSION_CALLS = n;
    }

    public static final int getMaxAllowedRecursionDepth() {
        return MAX_RECURSION_CALLS;
    }

    public static final void setRadiansMode() {
        degreesMode = false;
    }

    public static final void setDegreesMode() {
        degreesMode = true;
    }

    public static final boolean checkIfRadiansMode() {
        return !degreesMode;
    }

    public static final boolean checkIfDegreesMode() {
        return degreesMode;
    }

    public static final void setToFractionInitSearchSize(long l) {
        NumberTheory.setToFractionInitSearchSize(l);
    }

    public static final long getToFractionInitSearchSize() {
        return NumberTheory.getToFractionInitSearchSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void removeBuiltinTokens(String ... stringArray) {
        if (stringArray == null) {
            return;
        }
        List<String> list = tokensToRemove;
        synchronized (list) {
            for (String string : stringArray) {
                if (string == null || string.length() <= 0 || tokensToRemove.contains(string)) continue;
                tokensToRemove.add(string);
            }
            ++optionsChangesetNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unremoveBuiltinTokens(String ... stringArray) {
        if (stringArray == null) {
            return;
        }
        if (stringArray.length == 0) {
            return;
        }
        if (tokensToRemove.size() == 0) {
            return;
        }
        List<String> list = tokensToRemove;
        synchronized (list) {
            for (String string : stringArray) {
                if (string == null) continue;
                tokensToRemove.remove(string);
            }
            ++optionsChangesetNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unremoveAllBuiltinTokens() {
        List<String> list = tokensToRemove;
        synchronized (list) {
            tokensToRemove.clear();
            ++optionsChangesetNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String[] getBuiltinTokensToRemove() {
        List<String> list = tokensToRemove;
        synchronized (list) {
            int n = tokensToRemove.size();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = tokensToRemove.get(i);
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void modifyBuiltinToken(String string, String string2) {
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            return;
        }
        if (string2 == null) {
            return;
        }
        if (string2.length() == 0) {
            return;
        }
        List<TokenModification> list = tokensToModify;
        synchronized (list) {
            for (TokenModification tokenModification : tokensToModify) {
                if (!tokenModification.currentToken.equals(string)) continue;
                return;
            }
            TokenModification tokenModification = new TokenModification();
            tokenModification.currentToken = string;
            tokenModification.newToken = string2;
            tokenModification.newTokenDescription = null;
            tokensToModify.add(tokenModification);
            ++optionsChangesetNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void modifyBuiltinToken(String string, String string2, String string3) {
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            return;
        }
        if (string2 == null) {
            return;
        }
        if (string2.length() == 0) {
            return;
        }
        List<TokenModification> list = tokensToModify;
        synchronized (list) {
            for (TokenModification tokenModification : tokensToModify) {
                if (!tokenModification.currentToken.equals(string)) continue;
                return;
            }
            TokenModification tokenModification = new TokenModification();
            tokenModification.currentToken = string;
            tokenModification.newToken = string2;
            tokenModification.newTokenDescription = string3;
            tokensToModify.add(tokenModification);
            ++optionsChangesetNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unmodifyBuiltinTokens(String ... stringArray) {
        if (stringArray == null) {
            return;
        }
        if (stringArray.length == 0) {
            return;
        }
        if (tokensToModify.size() == 0) {
            return;
        }
        List<TokenModification> list = tokensToModify;
        synchronized (list) {
            ArrayList<TokenModification> arrayList = new ArrayList<TokenModification>();
            for (String string : stringArray) {
                if (string == null || string.length() <= 0) continue;
                for (TokenModification tokenModification : tokensToModify) {
                    if (!string.equals(tokenModification.currentToken) && !string.equals(tokenModification.newToken)) continue;
                    arrayList.add(tokenModification);
                }
            }
            for (TokenModification tokenModification : arrayList) {
                tokensToModify.remove(tokenModification);
            }
            ++optionsChangesetNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unmodifyAllBuiltinTokens() {
        List<TokenModification> list = tokensToModify;
        synchronized (list) {
            tokensToModify.clear();
            ++optionsChangesetNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String[][] getBuiltinTokensToModify() {
        List<TokenModification> list = tokensToModify;
        synchronized (list) {
            int n = tokensToModify.size();
            String[][] stringArray = new String[n][3];
            for (int i = 0; i < n; ++i) {
                TokenModification tokenModification = tokensToModify.get(i);
                stringArray[i][0] = tokenModification.currentToken;
                stringArray[i][1] = tokenModification.newToken;
                stringArray[i][2] = tokenModification.newTokenDescription;
            }
            return stringArray;
        }
    }

    public static final synchronized void setToOverrideBuiltinTokens() {
        overrideBuiltinTokens = true;
        ++optionsChangesetNumber;
    }

    public static final synchronized void setNotToOverrideBuiltinTokens() {
        overrideBuiltinTokens = false;
        ++optionsChangesetNumber;
    }

    public static final boolean checkIfsetToOverrideBuiltinTokens() {
        return overrideBuiltinTokens;
    }

    public static final synchronized void setDefaultOptions() {
        mXparser.enableUlpRounding();
        mXparser.enableAlmostIntRounding();
        mXparser.setMaxAllowedRecursionDepth(200);
        mXparser.setNotToOverrideBuiltinTokens();
        mXparser.unmodifyAllBuiltinTokens();
        mXparser.setRadiansMode();
        mXparser.resetCancelCurrentCalculationFlag();
        mXparser.setDefaultEpsilon();
        mXparser.setEpsilonComparison();
        mXparser.setToFractionInitSearchSize(10000L);
        ++optionsChangesetNumber;
    }

    public static final String getTokenTypeDescription(int n) {
        String string = "";
        switch (n) {
            case 20: {
                string = "Parser Symbol";
                break;
            }
            case 0: {
                string = "Number";
                break;
            }
            case 1: {
                string = "Operator";
                break;
            }
            case 2: {
                string = "Boolean Operator";
                break;
            }
            case 3: {
                string = "Binary Relation";
                break;
            }
            case 4: {
                string = "Unary Function";
                break;
            }
            case 5: {
                string = "Binary Function";
                break;
            }
            case 6: {
                string = "3-args Function";
                break;
            }
            case 7: {
                string = "Variadic Function";
                break;
            }
            case 8: {
                string = "Calculus Operator";
                break;
            }
            case 10: {
                string = "Random Variable";
                break;
            }
            case 9: {
                string = "Constant Value";
                break;
            }
            case 101: {
                string = "User defined argument";
                break;
            }
            case 102: {
                string = "User defined recursive argument";
                break;
            }
            case 103: {
                string = "User defined function";
                break;
            }
            case 104: {
                string = "User defined constant";
                break;
            }
            case 12: {
                string = "Unit";
                break;
            }
            case 11: {
                string = "Bitwise Operator";
            }
        }
        return string;
    }

    public static final String numberToHexString(int n) {
        return Integer.toHexString(n);
    }

    public static final String numberToHexString(long l) {
        return Long.toHexString(l);
    }

    public static final String numberToHexString(double d) {
        return mXparser.numberToHexString((long)d);
    }

    public static final String hexString2AsciiString(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); i += 2) {
            String string3 = string.substring(i, i + 2);
            int n = Integer.parseInt(string3, 16);
            string2 = string2 + (char)n;
        }
        return string2;
    }

    public static final String numberToAsciiString(int n) {
        return mXparser.hexString2AsciiString(mXparser.numberToHexString(n));
    }

    public static final String numberToAsciiString(long l) {
        return mXparser.hexString2AsciiString(mXparser.numberToHexString(l));
    }

    public static final String numberToAsciiString(double d) {
        return mXparser.hexString2AsciiString(mXparser.numberToHexString(d));
    }

    public static final double convOthBase2Decimal(String string, int n) {
        return NumberTheory.convOthBase2Decimal(string, n);
    }

    public static final double convOthBase2Decimal(String string) {
        return NumberTheory.convOthBase2Decimal(string);
    }

    public static final double convOthBase2Decimal(int n, int ... nArray) {
        return NumberTheory.convOthBase2Decimal(n, nArray);
    }

    public static final double convOthBase2Decimal(double d, double ... dArray) {
        return NumberTheory.convOthBase2Decimal(d, dArray);
    }

    public static final String convDecimal2OthBase(double d, int n) {
        return NumberTheory.convDecimal2OthBase(d, n);
    }

    public static final String convDecimal2OthBase(double d, int n, int n2) {
        return NumberTheory.convDecimal2OthBase(d, n, n2);
    }

    public static final double[] toFraction(double d) {
        return NumberTheory.toFraction(d);
    }

    public static final double[] toMixedFraction(double d) {
        return NumberTheory.toMixedFraction(d);
    }

    public static final String fractionToString(double[] dArray) {
        return NumberTheory.fractionToString(dArray);
    }

    public static final String toFractionString(double d) {
        return NumberTheory.toFractionString(d);
    }

    public static final String toMixedFractionString(double d) {
        return NumberTheory.toMixedFractionString(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void consolePrintln(Object object) {
        String string = CONSOLE_OUTPUT;
        synchronized (string) {
            if (CONSOLE_ROW_NUMBER == 1 && CONSOLE_OUTPUT.equals("")) {
                System.out.print(CONSOLE_PREFIX);
                CONSOLE_OUTPUT = CONSOLE_PREFIX;
            }
            System.out.println(object);
            ++CONSOLE_ROW_NUMBER;
            System.out.print(CONSOLE_PREFIX);
            CONSOLE_OUTPUT = CONSOLE_OUTPUT + object + "\n" + CONSOLE_OUTPUT_PREFIX;
        }
    }

    public static final void consolePrintln(String[] stringArray) {
        if (stringArray == null) {
            mXparser.consolePrintln("null");
            return;
        }
        for (String string : stringArray) {
            mXparser.consolePrintln(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void consolePrintln() {
        String string = CONSOLE_OUTPUT;
        synchronized (string) {
            if (CONSOLE_ROW_NUMBER == 1 && CONSOLE_OUTPUT.equals("")) {
                System.out.print(CONSOLE_PREFIX);
                CONSOLE_OUTPUT = CONSOLE_PREFIX;
            }
            System.out.println();
            ++CONSOLE_ROW_NUMBER;
            System.out.print(CONSOLE_PREFIX);
            CONSOLE_OUTPUT = CONSOLE_OUTPUT + "\n" + CONSOLE_OUTPUT_PREFIX;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void consolePrint(Object object) {
        String string = CONSOLE_OUTPUT;
        synchronized (string) {
            if (CONSOLE_ROW_NUMBER == 1 && CONSOLE_OUTPUT.equals("")) {
                System.out.print(CONSOLE_PREFIX);
                CONSOLE_OUTPUT = CONSOLE_PREFIX;
            }
            System.out.print(object);
            CONSOLE_OUTPUT = CONSOLE_OUTPUT + object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void resetConsoleOutput() {
        String string = CONSOLE_OUTPUT;
        synchronized (string) {
            CONSOLE_OUTPUT = "";
            CONSOLE_ROW_NUMBER = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultConsolePrefix() {
        String string = CONSOLE_PREFIX;
        synchronized (string) {
            CONSOLE_PREFIX = "[mXparser-v.4.4.0] ";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultConsoleOutputPrefix() {
        String string = CONSOLE_OUTPUT_PREFIX;
        synchronized (string) {
            CONSOLE_OUTPUT_PREFIX = "[mXparser-v.4.4.0] ";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConsolePrefix(String string) {
        String string2 = CONSOLE_PREFIX;
        synchronized (string2) {
            CONSOLE_PREFIX = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConsoleOutputPrefix(String string) {
        String string2 = CONSOLE_OUTPUT_PREFIX;
        synchronized (string2) {
            CONSOLE_OUTPUT_PREFIX = string;
        }
    }

    public static final String getConsoleOutput() {
        return CONSOLE_OUTPUT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getHelp() {
        Expression expression = mXparserExp;
        synchronized (expression) {
            return mXparserExp.getHelp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getHelp(String string) {
        Expression expression = mXparserExp;
        synchronized (expression) {
            return mXparserExp.getHelp(string);
        }
    }

    public static final void consolePrintHelp() {
        System.out.println(mXparser.getHelp());
    }

    public static final void consolePrintHelp(String string) {
        System.out.println(mXparser.getHelp(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<KeyWord> getKeyWords() {
        Expression expression = mXparserExp;
        synchronized (expression) {
            return mXparserExp.getKeyWords();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<KeyWord> getKeyWords(String string) {
        Expression expression = mXparserExp;
        synchronized (expression) {
            return mXparserExp.getKeyWords(string);
        }
    }

    public static final boolean regexMatch(String string, String string2) {
        return Pattern.matches(string2, string);
    }

    public static final void consolePrintTokens(List<Token> list) {
        Expression.showTokens(list);
    }

    public static final String getLicense() {
        return LICENSE;
    }

    public static final void wait(int n) {
        long l;
        long l2 = System.currentTimeMillis();
        while ((l = System.currentTimeMillis()) - l2 < (long)n) {
        }
    }

    public static final void cancelCurrentCalculation() {
        cancelCurrentCalculationFlag = true;
    }

    public static final void resetCancelCurrentCalculationFlag() {
        cancelCurrentCalculationFlag = false;
    }

    public static final boolean isCurrentCalculationCancelled() {
        return cancelCurrentCalculationFlag;
    }

    static {
        CONSOLE_OUTPUT_PREFIX = CONSOLE_PREFIX = "[mXparser-v.4.4.0 bin JDK 8] ";
        CONSOLE_ROW_NUMBER = 1;
        THREADS_NUMBER = Runtime.getRuntime().availableProcessors();
        mXparserExp = new Expression(new PrimitiveElement[0]);
        ulpRounding = false;
        canonicalRounding = true;
        almostIntRounding = true;
        MAX_RECURSION_CALLS = 200;
        tokensToRemove = new ArrayList<String>();
        tokensToModify = new ArrayList<TokenModification>();
        degreesMode = false;
        overrideBuiltinTokens = false;
        optionsChangesetNumber = 0;
        cancelCurrentCalculationFlag = false;
    }
}

