/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.ArgumentParameter;
import org.mariuszgromada.math.mxparser.Constant;
import org.mariuszgromada.math.mxparser.DescKwLenComparator;
import org.mariuszgromada.math.mxparser.Function;
import org.mariuszgromada.math.mxparser.FunctionParameter;
import org.mariuszgromada.math.mxparser.IterativeOperatorParameters;
import org.mariuszgromada.math.mxparser.KwStrComparator;
import org.mariuszgromada.math.mxparser.KwTypeComparator;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import org.mariuszgromada.math.mxparser.RecursiveArgument;
import org.mariuszgromada.math.mxparser.SyntaxStackElement;
import org.mariuszgromada.math.mxparser.TokenModification;
import org.mariuszgromada.math.mxparser.TokenStackElement;
import org.mariuszgromada.math.mxparser.mXparser;
import org.mariuszgromada.math.mxparser.mathcollection.BinaryRelations;
import org.mariuszgromada.math.mxparser.mathcollection.BooleanAlgebra;
import org.mariuszgromada.math.mxparser.mathcollection.Calculus;
import org.mariuszgromada.math.mxparser.mathcollection.MathFunctions;
import org.mariuszgromada.math.mxparser.mathcollection.NumberTheory;
import org.mariuszgromada.math.mxparser.mathcollection.ProbabilityDistributions;
import org.mariuszgromada.math.mxparser.mathcollection.SpecialFunctions;
import org.mariuszgromada.math.mxparser.mathcollection.Statistics;
import org.mariuszgromada.math.mxparser.parsertokens.KeyWord;
import org.mariuszgromada.math.mxparser.parsertokens.Token;
import org.mariuszgromada.math.mxparser.syntaxchecker.SyntaxChecker;

public class Expression
extends PrimitiveElement {
    public static final int TYPE_ID = 100;
    public static final String TYPE_DESC = "User defined expression";
    static final int NOT_FOUND = -1;
    static final int FOUND = 0;
    static final boolean INTERNAL = true;
    private static final boolean WITH_EXP_STR = true;
    private static final boolean NO_EXP_STR = false;
    public static final boolean NO_SYNTAX_ERRORS = true;
    public static final boolean SYNTAX_ERROR_OR_STATUS_UNKNOWN = false;
    String expressionString;
    private String description;
    List<Argument> argumentsList;
    List<Function> functionsList;
    List<Constant> constantsList;
    private List<KeyWord> keyWordsList;
    private List<Token> initialTokens;
    private List<Token> tokensList;
    List<Expression> relatedExpressionsList;
    private double computingTime;
    private boolean expressionWasModified;
    boolean recursiveMode;
    private boolean verboseMode;
    boolean disableRounding;
    static final boolean DISABLE_ROUNDING = true;
    static final boolean KEEP_ROUNDING_SETTINGS = false;
    private boolean syntaxStatus;
    private String errorMessage;
    private boolean recursionCallPending;
    private int recursionCallsCounter;
    private boolean parserKeyWordsOnly;
    boolean UDFExpression = false;
    List<Double> UDFVariadicParamsAtRunTime;
    private boolean internalClone;
    private int optionsChangesetNumber = -1;
    private final String FUNCTION = "function";
    private final String ARGUMENT = "argument";
    private final String UNITCONST = "unit/const";
    private final String ERROR = "error";

    void addRelatedExpression(Expression expression) {
        if (expression != null && expression != this && !this.relatedExpressionsList.contains(expression)) {
            this.relatedExpressionsList.add(expression);
        }
    }

    void removeRelatedExpression(Expression expression) {
        this.relatedExpressionsList.remove(expression);
    }

    void showRelatedExpressions() {
        mXparser.consolePrintln();
        mXparser.consolePrintln(this.description + " = " + this.expressionString + ":");
        for (Expression expression : this.relatedExpressionsList) {
            mXparser.consolePrintln("-> " + expression.description + " = " + expression.expressionString);
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean getSyntaxStatus() {
        return this.syntaxStatus;
    }

    void setSyntaxStatus(boolean bl, String string) {
        this.syntaxStatus = bl;
        this.errorMessage = string;
        this.expressionWasModified = false;
    }

    void setExpressionModifiedFlag() {
        if (!this.recursionCallPending) {
            this.recursionCallPending = true;
            this.recursionCallsCounter = 0;
            this.internalClone = false;
            this.expressionWasModified = true;
            this.syntaxStatus = false;
            this.errorMessage = "Syntax status unknown.";
            for (Expression expression : this.relatedExpressionsList) {
                expression.setExpressionModifiedFlag();
            }
            this.recursionCallPending = false;
        }
    }

    private void expressionInternalVarsInit() {
        this.description = "";
        this.errorMessage = "";
        this.computingTime = 0.0;
        this.recursionCallPending = false;
        this.recursionCallsCounter = 0;
        this.internalClone = false;
        this.parserKeyWordsOnly = false;
        this.disableRounding = false;
    }

    private void expressionInit() {
        this.argumentsList = new ArrayList<Argument>();
        this.functionsList = new ArrayList<Function>();
        this.constantsList = new ArrayList<Constant>();
        this.relatedExpressionsList = new ArrayList<Expression>();
        this.setSilentMode();
        this.disableRecursiveMode();
        this.expressionInternalVarsInit();
    }

    public Expression(PrimitiveElement ... primitiveElementArray) {
        super(100);
        this.expressionString = "";
        this.expressionInit();
        this.setExpressionModifiedFlag();
        this.addDefinitions(primitiveElementArray);
    }

    public Expression(String string, PrimitiveElement ... primitiveElementArray) {
        super(100);
        this.expressionInit();
        this.expressionString = new String(string);
        this.setExpressionModifiedFlag();
        this.addDefinitions(primitiveElementArray);
    }

    Expression(String string, boolean bl) {
        super(100);
        this.expressionInit();
        this.expressionString = new String(string);
        this.setExpressionModifiedFlag();
        this.parserKeyWordsOnly = bl;
    }

    Expression(String string, List<Token> list, List<Argument> list2, List<Function> list3, List<Constant> list4, boolean bl, boolean bl2, List<Double> list5) {
        super(100);
        this.expressionString = string;
        this.initialTokens = list;
        this.argumentsList = list2;
        this.functionsList = list3;
        this.constantsList = list4;
        this.relatedExpressionsList = new ArrayList<Expression>();
        this.expressionWasModified = false;
        this.syntaxStatus = true;
        this.description = "_internal_";
        this.errorMessage = "";
        this.computingTime = 0.0;
        this.recursionCallPending = false;
        this.recursionCallsCounter = 0;
        this.internalClone = false;
        this.parserKeyWordsOnly = false;
        this.UDFExpression = bl2;
        this.UDFVariadicParamsAtRunTime = list5;
        this.disableRounding = bl;
        this.setSilentMode();
        this.disableRecursiveMode();
    }

    Expression(String string, List<Argument> list, List<Function> list2, List<Constant> list3, boolean bl, boolean bl2, List<Double> list4) {
        super(100);
        this.expressionString = new String(string);
        this.expressionInternalVarsInit();
        this.setSilentMode();
        this.disableRecursiveMode();
        this.argumentsList = list;
        this.functionsList = list2;
        this.constantsList = list3;
        this.UDFExpression = bl2;
        this.UDFVariadicParamsAtRunTime = list4;
        this.relatedExpressionsList = new ArrayList<Expression>();
        this.setExpressionModifiedFlag();
    }

    private Expression(Expression expression) {
        super(100);
        this.expressionString = new String(expression.expressionString);
        this.description = new String(expression.description);
        this.argumentsList = expression.argumentsList;
        this.functionsList = expression.functionsList;
        this.constantsList = expression.constantsList;
        this.keyWordsList = expression.keyWordsList;
        this.relatedExpressionsList = expression.relatedExpressionsList;
        this.computingTime = 0.0;
        this.expressionWasModified = expression.expressionWasModified;
        this.recursiveMode = expression.recursiveMode;
        this.verboseMode = expression.verboseMode;
        this.syntaxStatus = expression.syntaxStatus;
        this.errorMessage = new String(expression.errorMessage);
        this.recursionCallPending = expression.recursionCallPending;
        this.recursionCallsCounter = expression.recursionCallsCounter;
        this.parserKeyWordsOnly = expression.parserKeyWordsOnly;
        this.disableRounding = expression.disableRounding;
        this.UDFExpression = expression.UDFExpression;
        this.UDFVariadicParamsAtRunTime = expression.UDFVariadicParamsAtRunTime;
        this.internalClone = true;
    }

    public void setExpressionString(String string) {
        this.expressionString = string;
        this.setExpressionModifiedFlag();
    }

    public String getExpressionString() {
        return this.expressionString;
    }

    public void clearExpressionString() {
        this.expressionString = "";
        this.setExpressionModifiedFlag();
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void clearDescription() {
        this.description = "";
    }

    public void setVerboseMode() {
        this.verboseMode = true;
    }

    public void setSilentMode() {
        this.verboseMode = false;
    }

    public boolean getVerboseMode() {
        return this.verboseMode;
    }

    void setRecursiveMode() {
        this.recursiveMode = true;
    }

    void disableRecursiveMode() {
        this.recursiveMode = false;
    }

    public boolean getRecursiveMode() {
        return this.recursiveMode;
    }

    public double getComputingTime() {
        return this.computingTime;
    }

    public void addDefinitions(PrimitiveElement ... primitiveElementArray) {
        for (PrimitiveElement primitiveElement : primitiveElementArray) {
            if (primitiveElement == null) continue;
            int n = primitiveElement.getMyTypeId();
            if (n == 101) {
                this.addArguments((Argument)primitiveElement);
                continue;
            }
            if (n == 104) {
                this.addConstants((Constant)primitiveElement);
                continue;
            }
            if (n == 103) {
                this.addFunctions((Function)primitiveElement);
                continue;
            }
            if (n != 102) continue;
            this.addArguments((Argument)primitiveElement);
        }
    }

    public void removeDefinitions(PrimitiveElement ... primitiveElementArray) {
        for (PrimitiveElement primitiveElement : primitiveElementArray) {
            if (primitiveElement == null) continue;
            int n = primitiveElement.getMyTypeId();
            if (n == 101) {
                this.removeArguments((Argument)primitiveElement);
                continue;
            }
            if (n == 104) {
                this.removeConstants((Constant)primitiveElement);
                continue;
            }
            if (n == 103) {
                this.removeFunctions((Function)primitiveElement);
                continue;
            }
            if (n != 102) continue;
            this.removeArguments((Argument)primitiveElement);
        }
    }

    public void addArguments(Argument ... argumentArray) {
        for (Argument argument : argumentArray) {
            if (argument == null) continue;
            this.argumentsList.add(argument);
            if (argument.getArgumentBodyType() != 1) continue;
            argument.addRelatedExpression(this);
        }
        this.setExpressionModifiedFlag();
    }

    public void defineArguments(String ... stringArray) {
        for (String string : stringArray) {
            Argument argument = new Argument(string, new PrimitiveElement[0]);
            argument.addRelatedExpression(this);
            this.argumentsList.add(argument);
        }
        this.setExpressionModifiedFlag();
    }

    public void defineArgument(String string, double d) {
        Argument argument = new Argument(string, d);
        argument.addRelatedExpression(this);
        this.argumentsList.add(argument);
        this.setExpressionModifiedFlag();
    }

    public int getArgumentIndex(String string) {
        int n = this.argumentsList.size();
        if (n > 0) {
            int n2 = 0;
            int n3 = -1;
            while (n2 < n && n3 == -1) {
                if (this.argumentsList.get(n2).getArgumentName().equals(string)) {
                    n3 = 0;
                    continue;
                }
                ++n2;
            }
            if (n3 == 0) {
                return n2;
            }
            return -1;
        }
        return -1;
    }

    public Argument getArgument(String string) {
        int n = this.getArgumentIndex(string);
        if (n == -1) {
            return null;
        }
        return this.argumentsList.get(n);
    }

    public Argument getArgument(int n) {
        if (n < 0 || n >= this.argumentsList.size()) {
            return null;
        }
        return this.argumentsList.get(n);
    }

    public int getArgumentsNumber() {
        return this.argumentsList.size();
    }

    public void setArgumentValue(String string, double d) {
        int n = this.getArgumentIndex(string);
        if (n != -1) {
            this.argumentsList.get(n).setArgumentValue(d);
        }
    }

    public double getArgumentValue(String string) {
        int n = this.getArgumentIndex(string);
        if (n != -1) {
            return this.argumentsList.get(n).getArgumentValue();
        }
        return Double.NaN;
    }

    public void removeArguments(String ... stringArray) {
        for (String string : stringArray) {
            int n = this.getArgumentIndex(string);
            if (n == -1) continue;
            Argument argument = this.argumentsList.get(n);
            argument.removeRelatedExpression(this);
            this.argumentsList.remove(n);
        }
        this.setExpressionModifiedFlag();
    }

    public void removeArguments(Argument ... argumentArray) {
        for (Argument argument : argumentArray) {
            if (argument == null) continue;
            this.argumentsList.remove(argument);
            argument.removeRelatedExpression(this);
        }
        this.setExpressionModifiedFlag();
    }

    public void removeAllArguments() {
        for (Argument argument : this.argumentsList) {
            argument.removeRelatedExpression(this);
        }
        this.argumentsList.clear();
        this.setExpressionModifiedFlag();
    }

    public void addConstants(Constant ... constantArray) {
        for (Constant constant : constantArray) {
            if (constant == null) continue;
            this.constantsList.add(constant);
            constant.addRelatedExpression(this);
        }
        this.setExpressionModifiedFlag();
    }

    public void addConstants(List<Constant> list) {
        this.constantsList.addAll(list);
        for (Constant constant : list) {
            constant.addRelatedExpression(this);
        }
        this.setExpressionModifiedFlag();
    }

    public void defineConstant(String string, double d) {
        Constant constant = new Constant(string, d);
        constant.addRelatedExpression(this);
        this.constantsList.add(constant);
        this.setExpressionModifiedFlag();
    }

    public int getConstantIndex(String string) {
        int n = this.constantsList.size();
        if (n > 0) {
            int n2 = 0;
            int n3 = -1;
            while (n2 < n && n3 == -1) {
                if (this.constantsList.get(n2).getConstantName().equals(string)) {
                    n3 = 0;
                    continue;
                }
                ++n2;
            }
            if (n3 == 0) {
                return n2;
            }
            return -1;
        }
        return -1;
    }

    public Constant getConstant(String string) {
        int n = this.getConstantIndex(string);
        if (n == -1) {
            return null;
        }
        return this.constantsList.get(n);
    }

    public Constant getConstant(int n) {
        if (n < 0 || n >= this.constantsList.size()) {
            return null;
        }
        return this.constantsList.get(n);
    }

    public int getConstantsNumber() {
        return this.constantsList.size();
    }

    public void removeConstants(String ... stringArray) {
        for (String string : stringArray) {
            int n = this.getConstantIndex(string);
            if (n == -1) continue;
            Constant constant = this.constantsList.get(n);
            constant.removeRelatedExpression(this);
            this.constantsList.remove(n);
        }
        this.setExpressionModifiedFlag();
    }

    public void removeConstants(Constant ... constantArray) {
        for (Constant constant : constantArray) {
            if (constant == null) continue;
            this.constantsList.remove(constant);
            constant.removeRelatedExpression(this);
            this.setExpressionModifiedFlag();
        }
    }

    public void removeAllConstants() {
        for (Constant constant : this.constantsList) {
            constant.removeRelatedExpression(this);
        }
        this.constantsList.clear();
        this.setExpressionModifiedFlag();
    }

    public void addFunctions(Function ... functionArray) {
        for (Function function : functionArray) {
            if (function == null) continue;
            this.functionsList.add(function);
            if (function.getFunctionBodyType() != 1) continue;
            function.addRelatedExpression(this);
        }
        this.setExpressionModifiedFlag();
    }

    public void defineFunction(String string, String string2, String ... stringArray) {
        Function function = new Function(string, string2, stringArray);
        this.functionsList.add(function);
        function.addRelatedExpression(this);
        this.setExpressionModifiedFlag();
    }

    public int getFunctionIndex(String string) {
        int n = this.functionsList.size();
        if (n > 0) {
            int n2 = 0;
            int n3 = -1;
            while (n2 < n && n3 == -1) {
                if (this.functionsList.get(n2).getFunctionName().equals(string)) {
                    n3 = 0;
                    continue;
                }
                ++n2;
            }
            if (n3 == 0) {
                return n2;
            }
            return -1;
        }
        return -1;
    }

    public Function getFunction(String string) {
        int n = this.getFunctionIndex(string);
        if (n == -1) {
            return null;
        }
        return this.functionsList.get(n);
    }

    public Function getFunction(int n) {
        if (n < 0 || n >= this.functionsList.size()) {
            return null;
        }
        return this.functionsList.get(n);
    }

    public int getFunctionsNumber() {
        return this.functionsList.size();
    }

    public void removeFunctions(String ... stringArray) {
        for (String string : stringArray) {
            int n = this.getFunctionIndex(string);
            if (n == -1) continue;
            Function function = this.functionsList.get(n);
            function.removeRelatedExpression(this);
            this.functionsList.remove(function);
        }
        this.setExpressionModifiedFlag();
    }

    public void removeFunctions(Function ... functionArray) {
        for (Function function : functionArray) {
            if (function == null) continue;
            function.removeRelatedExpression(this);
            this.functionsList.remove(function);
        }
        this.setExpressionModifiedFlag();
    }

    public void removeAllFunctions() {
        for (Function function : this.functionsList) {
            function.removeRelatedExpression(this);
        }
        this.functionsList.clear();
        this.setExpressionModifiedFlag();
    }

    private void setToNumber(int n, double d, boolean bl) {
        int n2;
        Token token = this.tokensList.get(n);
        token.tokenValue = mXparser.ulpRounding && !this.disableRounding ? (bl ? (Double.isNaN(d) || Double.isInfinite(d) ? d : ((n2 = MathFunctions.ulpDecimalDigitsBefore(d)) >= 0 ? MathFunctions.round(d, n2) : d)) : d) : d;
        token.tokenTypeId = 0;
        token.tokenId = 1;
        token.keyWord = "_num_";
    }

    private void setToNumber(int n, double d) {
        this.setToNumber(n, d, false);
    }

    private void f1SetDecreaseRemove(int n, double d, boolean bl) {
        this.setToNumber(n, d, bl);
        --this.tokensList.get((int)n).tokenLevel;
        this.tokensList.remove(n + 1);
    }

    private void f1SetDecreaseRemove(int n, double d) {
        this.f1SetDecreaseRemove(n, d, false);
    }

    private void f2SetDecreaseRemove(int n, double d, boolean bl) {
        this.setToNumber(n, d, bl);
        --this.tokensList.get((int)n).tokenLevel;
        this.tokensList.remove(n + 2);
        this.tokensList.remove(n + 1);
    }

    private void f2SetDecreaseRemove(int n, double d) {
        this.f2SetDecreaseRemove(n, d, false);
    }

    private void f3SetDecreaseRemove(int n, double d, boolean bl) {
        this.setToNumber(n, d, bl);
        --this.tokensList.get((int)n).tokenLevel;
        this.tokensList.remove(n + 3);
        this.tokensList.remove(n + 2);
        this.tokensList.remove(n + 1);
    }

    private void f3SetDecreaseRemove(int n, double d) {
        this.f3SetDecreaseRemove(n, d, false);
    }

    private void opSetDecreaseRemove(int n, double d, boolean bl) {
        this.setToNumber(n, d, bl);
        this.tokensList.remove(n + 1);
        this.tokensList.remove(n - 1);
    }

    private void opSetDecreaseRemove(int n, double d) {
        this.opSetDecreaseRemove(n, d, false);
    }

    private void calcSetDecreaseRemove(int n, double d, boolean bl) {
        this.setToNumber(n, d, bl);
        --this.tokensList.get((int)n).tokenLevel;
        int n2 = n + 1;
        int n3 = n2 + 1;
        while (this.tokensList.get((int)n3).tokenTypeId != 20 || this.tokensList.get((int)n3).tokenId != 2 || this.tokensList.get((int)n3).tokenLevel != this.tokensList.get((int)n2).tokenLevel) {
            ++n3;
        }
        for (int i = n3; i >= n2; --i) {
            this.tokensList.remove(i);
        }
    }

    private void calcSetDecreaseRemove(int n, double d) {
        this.calcSetDecreaseRemove(n, d, false);
    }

    private void variadicSetDecreaseRemove(int n, double d, int n2, boolean bl) {
        this.setToNumber(n, d, bl);
        --this.tokensList.get((int)n).tokenLevel;
        for (int i = n + n2; i > n; --i) {
            this.tokensList.remove(i);
        }
    }

    private void variadicSetDecreaseRemove(int n, double d, int n2) {
        this.variadicSetDecreaseRemove(n, d, n2, false);
    }

    private void ifSetRemove(int n, double d, boolean bl) {
        int n2 = n + 1;
        int n3 = this.tokensList.get((int)n2).tokenLevel;
        int n4 = n2 + 1;
        while (this.tokensList.get((int)n4).tokenTypeId != 20 || this.tokensList.get((int)n4).tokenId != 3 || this.tokensList.get((int)n4).tokenLevel != n3) {
            ++n4;
        }
        int n5 = n4 + 1;
        while (this.tokensList.get((int)n5).tokenTypeId != 20 || this.tokensList.get((int)n5).tokenId != 3 || this.tokensList.get((int)n5).tokenLevel != n3) {
            ++n5;
        }
        int n6 = n5 + 1;
        while (this.tokensList.get((int)n6).tokenTypeId != 20 || this.tokensList.get((int)n6).tokenId != 2 || this.tokensList.get((int)n6).tokenLevel != n3) {
            ++n6;
        }
        if (!Double.isNaN(d)) {
            if (d != 0.0) {
                this.setToNumber(n5 + 1, Double.NaN);
                this.tokensList.get((int)(n5 + 1)).tokenLevel = n3;
                this.removeTokens(n5 + 2, n6 - 1);
            } else {
                this.setToNumber(n4 + 1, Double.NaN);
                this.tokensList.get((int)(n4 + 1)).tokenLevel = n3;
                this.removeTokens(n4 + 2, n5 - 1);
            }
        } else {
            this.setToNumber(n4 + 1, Double.NaN);
            this.setToNumber(n5 + 1, Double.NaN);
            this.tokensList.get((int)(n4 + 1)).tokenLevel = n3;
            this.tokensList.get((int)(n5 + 1)).tokenLevel = n3;
            this.removeTokens(n5 + 2, n6 - 1);
            this.removeTokens(n4 + 2, n5 - 1);
        }
        this.setToNumber(n2 + 1, d, bl);
        this.tokensList.get((int)(n2 + 1)).tokenLevel = n3;
        this.removeTokens(n2 + 2, n4 - 1);
        this.tokensList.get((int)n).tokenId = 2;
    }

    private void removeTokens(int n, int n2) {
        if (n < n2) {
            for (int i = n2; i >= n; --i) {
                this.tokensList.remove(i);
            }
        } else if (n == n2) {
            this.tokensList.remove(n);
        }
    }

    private void ifSetRemove(int n, double d) {
        this.ifSetRemove(n, d, false);
    }

    private List<Token> createInitialTokens(int n, int n2, List<Token> list) {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        for (int i = n; i <= n2; ++i) {
            Token token = list.get(i).clone();
            arrayList.add(token);
        }
        return arrayList;
    }

    private int getParametersNumber(int n) {
        int n2 = n + 1;
        if (n2 == this.initialTokens.size()) {
            return -1;
        }
        if (this.initialTokens.get((int)n2).tokenTypeId == 20 && this.initialTokens.get((int)n2).tokenId == 1) {
            int n3 = this.initialTokens.get((int)n2).tokenLevel;
            int n4 = n2 + 1;
            while (this.initialTokens.get((int)n4).tokenTypeId != 20 || this.initialTokens.get((int)n4).tokenId != 2 || this.initialTokens.get((int)n4).tokenLevel != n3) {
                ++n4;
            }
            if (n4 == n2 + 1) {
                return 0;
            }
            int n5 = 0;
            for (int i = n2; i < n4; ++i) {
                Token token = this.initialTokens.get(i);
                if (token.tokenTypeId != 20 || token.tokenId != 3 || token.tokenLevel != n3) continue;
                ++n5;
            }
            return n5 + 1;
        }
        return -1;
    }

    private List<FunctionParameter> getFunctionParameters(int n, List<Token> list) {
        ArrayList<FunctionParameter> arrayList = new ArrayList<FunctionParameter>();
        int n2 = n + 2;
        int n3 = list.get((int)(n + 1)).tokenLevel;
        int n4 = n2;
        boolean bl = false;
        ArrayList<Token> arrayList2 = new ArrayList<Token>();
        String string = "";
        do {
            Token token = list.get(n2);
            boolean bl2 = false;
            boolean bl3 = false;
            if (token.tokenLevel == n3 && token.tokenTypeId == 20) {
                if (token.tokenId == 2) {
                    bl3 = true;
                } else if (token.tokenId == 3) {
                    bl2 = true;
                }
            }
            if (bl3 || bl2) {
                if (n2 > n + 2) {
                    arrayList.add(new FunctionParameter(arrayList2, string, n4, n2 - 1));
                    arrayList2 = new ArrayList();
                    string = "";
                    n4 = n2 + 1;
                }
            } else {
                arrayList2.add(token);
                string = string + token.tokenStr;
            }
            if (bl3) {
                bl = true;
                continue;
            }
            ++n2;
        } while (!bl);
        return arrayList;
    }

    private ArgumentParameter getParamArgument(String string) {
        ArgumentParameter argumentParameter = new ArgumentParameter();
        argumentParameter.index = this.getArgumentIndex(string);
        argumentParameter.argument = this.getArgument(argumentParameter.index);
        argumentParameter.presence = 0;
        if (argumentParameter.argument == null) {
            argumentParameter.argument = new Argument(string, new PrimitiveElement[0]);
            this.argumentsList.add(argumentParameter.argument);
            argumentParameter.index = this.argumentsList.size() - 1;
            argumentParameter.presence = -1;
        } else {
            argumentParameter.initialValue = argumentParameter.argument.argumentValue;
            argumentParameter.initialType = argumentParameter.argument.argumentType;
            argumentParameter.argument.argumentValue = argumentParameter.argument.getArgumentValue();
            argumentParameter.argument.argumentType = 1;
        }
        return argumentParameter;
    }

    private void clearParamArgument(ArgumentParameter argumentParameter) {
        if (argumentParameter.presence == -1) {
            this.argumentsList.remove(argumentParameter.index);
        } else {
            argumentParameter.argument.argumentValue = argumentParameter.initialValue;
            argumentParameter.argument.argumentType = argumentParameter.initialType;
        }
    }

    private void FREE_ARGUMENT(int n) {
        Argument argument = this.argumentsList.get(this.tokensList.get((int)n).tokenId);
        boolean bl = argument.getVerboseMode();
        if (this.verboseMode) {
            argument.setVerboseMode();
        }
        this.setToNumber(n, argument.getArgumentValue());
        if (!bl) {
            argument.setSilentMode();
        }
    }

    private void DEPENDENT_ARGUMENT(int n) {
        Argument argument = this.argumentsList.get(this.tokensList.get((int)n).tokenId);
        boolean bl = argument.getVerboseMode();
        if (this.verboseMode) {
            argument.setVerboseMode();
        }
        int n2 = this.tokensList.size();
        Token token = this.tokensList.get(n);
        double d = argument.getArgumentValue();
        int n3 = this.tokensList.size();
        if (n2 == n3) {
            Token token2 = this.tokensList.get(n);
            if (token.tokenTypeId == token2.tokenTypeId && token.tokenId == token2.tokenId) {
                this.setToNumber(n, d);
            }
        }
        if (!bl) {
            argument.setSilentMode();
        }
    }

    private void USER_FUNCTION(int n) {
        double d;
        int n2;
        Function function;
        Function function2 = this.functionsList.get(this.tokensList.get((int)n).tokenId);
        if (function2.getRecursiveMode()) {
            function = function2.clone();
            function.functionExpression.recursionCallsCounter = this.recursionCallsCounter;
        } else {
            function = function2;
        }
        function.functionExpression.UDFVariadicParamsAtRunTime = this.getNumbers(n);
        int n3 = function.getParametersNumber();
        if (!function.isVariadic) {
            for (n2 = 0; n2 < n3; ++n2) {
                function.setArgumentValue(n2, this.tokensList.get((int)(n + n2 + 1)).tokenValue);
            }
        }
        n2 = function.getVerboseMode();
        if (this.verboseMode) {
            function.setVerboseMode();
        }
        int n4 = this.tokensList.size();
        Token token = this.tokensList.get(n);
        try {
            d = function.calculate();
        }
        catch (StackOverflowError stackOverflowError) {
            d = Double.NaN;
            this.errorMessage = stackOverflowError.getMessage();
        }
        int n5 = this.tokensList.size();
        if (n4 == n5) {
            Token token2 = this.tokensList.get(n);
            if (token.tokenTypeId == token2.tokenTypeId && token.tokenId == token2.tokenId) {
                this.setToNumber(n, d);
                --this.tokensList.get((int)n).tokenLevel;
                for (int i = n3; i > 0; --i) {
                    this.tokensList.remove(n + i);
                }
            }
        }
        if (n2 == 0) {
            function.setSilentMode();
        }
    }

    private void USER_CONSTANT(int n) {
        Constant constant = this.constantsList.get(this.tokensList.get((int)n).tokenId);
        this.setToNumber(n, constant.getConstantValue());
    }

    private void RECURSIVE_ARGUMENT(int n) {
        double d = this.tokensList.get((int)(n + 1)).tokenValue;
        RecursiveArgument recursiveArgument = (RecursiveArgument)this.argumentsList.get(this.tokensList.get((int)n).tokenId);
        boolean bl = recursiveArgument.getVerboseMode();
        if (this.verboseMode) {
            recursiveArgument.setVerboseMode();
        }
        double d2 = recursiveArgument.getArgumentValue(d);
        this.f1SetDecreaseRemove(n, d2);
        if (!bl) {
            recursiveArgument.setSilentMode();
        }
    }

    private void CONSTANT(int n) {
        double d = Double.NaN;
        switch (this.tokensList.get((int)n).tokenId) {
            case 1: {
                d = Math.PI;
                break;
            }
            case 2: {
                d = Math.E;
                break;
            }
            case 3: {
                d = 0.5772156649015329;
                break;
            }
            case 4: {
                d = 1.618033988749895;
                break;
            }
            case 5: {
                d = 1.324717957244746;
                break;
            }
            case 6: {
                d = 0.70258;
                break;
            }
            case 7: {
                d = 4.66920160910299;
                break;
            }
            case 8: {
                d = 2.5029078750958926;
                break;
            }
            case 9: {
                d = 0.6601618158468696;
                break;
            }
            case 10: {
                d = 0.26149721284764277;
                break;
            }
            case 11: {
                d = 1.9021605823;
                break;
            }
            case 12: {
                d = 0.87058838;
                break;
            }
            case 13: {
                d = -2.7E-9;
                break;
            }
            case 14: {
                d = 0.915965594177219;
                break;
            }
            case 15: {
                d = 0.7642236535892206;
                break;
            }
            case 16: {
                d = 1.13198824;
                break;
            }
            case 17: {
                d = 1.0;
                break;
            }
            case 18: {
                d = 1.451369234883381;
                break;
            }
            case 19: {
                d = 1.6066951524152917;
                break;
            }
            case 20: {
                d = 0.2801694990238691;
                break;
            }
            case 21: {
                d = 0.30366300289873266;
                break;
            }
            case 22: {
                d = 0.353236371854996;
                break;
            }
            case 23: {
                d = 0.6243299885435508;
                break;
            }
            case 24: {
                d = 0.6434105463;
                break;
            }
            case 25: {
                d = 0.6627434193491816;
                break;
            }
            case 26: {
                d = 0.8093940205;
                break;
            }
            case 27: {
                d = 1.0986858055;
                break;
            }
            case 28: {
                d = 3.2758229187218113;
                break;
            }
            case 29: {
                d = 1.2020569031595942;
                break;
            }
            case 30: {
                d = 1.3063778838630806;
                break;
            }
            case 31: {
                d = 1.4560749485826896;
                break;
            }
            case 32: {
                d = 1.4670780794;
                break;
            }
            case 33: {
                d = 1.5396007178;
                break;
            }
            case 34: {
                d = 1.7052111401053678;
                break;
            }
            case 35: {
                d = 2.5849817595792532;
                break;
            }
            case 36: {
                d = 2.6854520010653062;
                break;
            }
            case 37: {
                d = 2.8077702420285195;
                break;
            }
            case 38: {
                d = 0.5;
                break;
            }
            case 39: {
                d = 2.295587149392638;
                break;
            }
            case 40: {
                d = 0.5671432904097838;
                break;
            }
            case 41: {
                d = 0.187859;
                break;
            }
            case 42: {
                d = 1.045163780117493;
                break;
            }
            case 43: {
                d = 0.5963473623231941;
                break;
            }
            case 101: {
                d = 2.99792458E8;
                break;
            }
            case 102: {
                d = 6.67408E-11;
                break;
            }
            case 103: {
                d = 9.80665;
                break;
            }
            case 104: {
                d = 6.62607004E-34;
                break;
            }
            case 105: {
                d = 1.0545718001391127E-34;
                break;
            }
            case 106: {
                d = 1.616229E-35;
                break;
            }
            case 107: {
                d = 2.17647E-8;
                break;
            }
            case 108: {
                d = 5.39116E-44;
                break;
            }
            case 201: {
                d = 9.4607304725808E15;
                break;
            }
            case 202: {
                d = 1.495978707E11;
                break;
            }
            case 203: {
                d = 3.085677581491362E16;
                break;
            }
            case 204: {
                d = 3.085677581491362E19;
                break;
            }
            case 205: {
                d = 6378137.0;
                break;
            }
            case 206: {
                d = 6356752.3;
                break;
            }
            case 207: {
                d = 6371008.8;
                break;
            }
            case 208: {
                d = 5.9722E24;
                break;
            }
            case 209: {
                d = 1.495980229906324E11;
                break;
            }
            case 210: {
                d = 1737100.0;
                break;
            }
            case 211: {
                d = 7.34582809714E22;
                break;
            }
            case 212: {
                d = 3.84399E8;
                break;
            }
            case 213: {
                d = 6.957E8;
                break;
            }
            case 214: {
                d = 1.98842039204614E30;
                break;
            }
            case 215: {
                d = 2439700.0;
                break;
            }
            case 216: {
                d = 3.3026266E23;
                break;
            }
            case 217: {
                d = 5.79090365522286E10;
                break;
            }
            case 218: {
                d = 6051800.0;
                break;
            }
            case 219: {
                d = 4.867343E24;
                break;
            }
            case 220: {
                d = 1.082089270091724E11;
                break;
            }
            case 221: {
                d = 3389500.0;
                break;
            }
            case 222: {
                d = 6.390254E23;
                break;
            }
            case 223: {
                d = 2.279391340303053E11;
                break;
            }
            case 224: {
                d = 6.9911E7;
                break;
            }
            case 225: {
                d = 1.8979651600000002E27;
                break;
            }
            case 226: {
                d = 7.782978821038201E11;
                break;
            }
            case 227: {
                d = 5.8232E7;
                break;
            }
            case 228: {
                d = 5.6830857980000005E26;
                break;
            }
            case 229: {
                d = 1.42939269475143E12;
                break;
            }
            case 230: {
                d = 2.5362E7;
                break;
            }
            case 231: {
                d = 8.681189920000001E25;
                break;
            }
            case 232: {
                d = 2.87503171826088E12;
                break;
            }
            case 233: {
                d = 2.4622E7;
                break;
            }
            case 234: {
                d = 1.024053134E26;
                break;
            }
            case 235: {
                d = 4.504449781152961E12;
                break;
            }
            case 301: {
                d = 1.0;
                break;
            }
            case 302: {
                d = 0.0;
                break;
            }
            case 999: {
                d = Double.NaN;
                break;
            }
            case 303: {
                d = this.UDFVariadicParamsAtRunTime.size();
            }
        }
        this.setToNumber(n, d);
    }

    private void UNIT(int n) {
        double d = Double.NaN;
        switch (this.tokensList.get((int)n).tokenId) {
            case 1: {
                d = 0.01;
                break;
            }
            case 2: {
                d = 0.001;
                break;
            }
            case 101: {
                d = 1.0E24;
                break;
            }
            case 102: {
                d = 1.0E21;
                break;
            }
            case 103: {
                d = 1.0E18;
                break;
            }
            case 104: {
                d = 1.0E15;
                break;
            }
            case 105: {
                d = 1.0E12;
                break;
            }
            case 106: {
                d = 1.0E9;
                break;
            }
            case 107: {
                d = 1000000.0;
                break;
            }
            case 108: {
                d = 1000.0;
                break;
            }
            case 109: {
                d = 100.0;
                break;
            }
            case 110: {
                d = 10.0;
                break;
            }
            case 111: {
                d = 0.1;
                break;
            }
            case 112: {
                d = 0.01;
                break;
            }
            case 113: {
                d = 0.001;
                break;
            }
            case 114: {
                d = 1.0E-6;
                break;
            }
            case 115: {
                d = 1.0E-9;
                break;
            }
            case 116: {
                d = 1.0E-12;
                break;
            }
            case 117: {
                d = 1.0E-15;
                break;
            }
            case 118: {
                d = 1.0E-18;
                break;
            }
            case 119: {
                d = 1.0E-21;
                break;
            }
            case 120: {
                d = 1.0E-24;
                break;
            }
            case 201: {
                d = 1.0;
                break;
            }
            case 202: {
                d = 1000.0;
                break;
            }
            case 203: {
                d = 0.01;
                break;
            }
            case 204: {
                d = 0.001;
                break;
            }
            case 205: {
                d = 0.025400000000000002;
                break;
            }
            case 206: {
                d = 0.9144;
                break;
            }
            case 207: {
                d = 0.3048;
                break;
            }
            case 208: {
                d = 1609.344;
                break;
            }
            case 209: {
                d = 1852.0;
                break;
            }
            case 301: {
                d = 1.0;
                break;
            }
            case 302: {
                d = 1.0E-4;
                break;
            }
            case 303: {
                d = 1.0E-6;
                break;
            }
            case 304: {
                d = 100.0;
                break;
            }
            case 305: {
                d = 10000.0;
                break;
            }
            case 306: {
                d = 4046.8564224000006;
                break;
            }
            case 307: {
                d = 1000000.0;
                break;
            }
            case 401: {
                d = 1.0E-9;
                break;
            }
            case 402: {
                d = 1.0000000000000002E-6;
                break;
            }
            case 403: {
                d = 1.0;
                break;
            }
            case 404: {
                d = 1.0E9;
                break;
            }
            case 405: {
                d = 1.0000000000000002E-6;
                break;
            }
            case 406: {
                d = 0.0010000000000000002;
                break;
            }
            case 407: {
                d = 0.003785411780000001;
                break;
            }
            case 408: {
                d = 4.7317647300000007E-4;
                break;
            }
            case 501: {
                d = 1.0;
                break;
            }
            case 502: {
                d = 0.001;
                break;
            }
            case 503: {
                d = 60.0;
                break;
            }
            case 504: {
                d = 3600.0;
                break;
            }
            case 505: {
                d = 86400.0;
                break;
            }
            case 506: {
                d = 604800.0;
                break;
            }
            case 507: {
                d = 3.15576E7;
                break;
            }
            case 508: {
                d = 1.0;
                break;
            }
            case 509: {
                d = 0.001;
                break;
            }
            case 510: {
                d = 1.0E-6;
                break;
            }
            case 511: {
                d = 0.01;
                break;
            }
            case 512: {
                d = 1000.0;
                break;
            }
            case 513: {
                d = 0.0283495231;
                break;
            }
            case 514: {
                d = 0.45359237;
                break;
            }
            case 601: {
                d = 1.0;
                break;
            }
            case 602: {
                d = 1024.0;
                break;
            }
            case 603: {
                d = 1048576.0;
                break;
            }
            case 604: {
                d = 1.073741824E9;
                break;
            }
            case 605: {
                d = 1.099511627776E12;
                break;
            }
            case 606: {
                d = 1.125899906842624E15;
                break;
            }
            case 607: {
                d = 1.152921504606847E18;
                break;
            }
            case 608: {
                d = 1.1805916207174113E21;
                break;
            }
            case 609: {
                d = 1.2089258196146292E24;
                break;
            }
            case 610: {
                d = 8.0;
                break;
            }
            case 611: {
                d = 8192.0;
                break;
            }
            case 612: {
                d = 8388608.0;
                break;
            }
            case 613: {
                d = 8.589934592E9;
                break;
            }
            case 614: {
                d = 8.796093022208E12;
                break;
            }
            case 615: {
                d = 9.007199254740992E15;
                break;
            }
            case 616: {
                d = 9.223372036854776E18;
                break;
            }
            case 617: {
                d = 9.44473296573929E21;
                break;
            }
            case 618: {
                d = 9.671406556917033E24;
                break;
            }
            case 701: {
                d = 1.0;
                break;
            }
            case 702: {
                d = 1.6021766208E-19;
                break;
            }
            case 703: {
                d = 1.6021766208000002E-16;
                break;
            }
            case 704: {
                d = 1.6021766208000001E-13;
                break;
            }
            case 705: {
                d = 1.6021766208000002E-10;
                break;
            }
            case 706: {
                d = 1.6021766208000002E-7;
                break;
            }
            case 801: {
                d = 1.0;
                break;
            }
            case 802: {
                d = 0.2777777777777778;
                break;
            }
            case 803: {
                d = 0.44704;
                break;
            }
            case 804: {
                d = 0.514444444;
                break;
            }
            case 901: {
                d = 1.0;
                break;
            }
            case 902: {
                d = 7.716049382716049E-5;
                break;
            }
            case 903: {
                d = 1.2417777777777778E-4;
                break;
            }
            case 1001: {
                d = 1.0;
                break;
            }
            case 1002: {
                d = Math.PI / 180;
                break;
            }
            case 1003: {
                d = 2.908882086657216E-4;
                break;
            }
            case 1004: {
                d = 4.84813681109536E-6;
            }
        }
        this.setToNumber(n, d);
    }

    private void RANDOM_VARIABLE(int n) {
        double d = Double.NaN;
        switch (this.tokensList.get((int)n).tokenId) {
            case 1: {
                d = ProbabilityDistributions.rndUniformContinuous(ProbabilityDistributions.randomGenerator);
                break;
            }
            case 2: {
                d = ProbabilityDistributions.rndInteger(ProbabilityDistributions.randomGenerator);
                break;
            }
            case 3: {
                d = ProbabilityDistributions.rndInteger(-10, 10, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 4: {
                d = ProbabilityDistributions.rndInteger(-100, 100, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 5: {
                d = ProbabilityDistributions.rndInteger(-1000, 1000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 6: {
                d = ProbabilityDistributions.rndInteger(-10000, 10000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 7: {
                d = ProbabilityDistributions.rndInteger(-100000, 100000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 8: {
                d = ProbabilityDistributions.rndInteger(-1000000, 1000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 9: {
                d = ProbabilityDistributions.rndInteger(-10000000, 10000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 10: {
                d = ProbabilityDistributions.rndInteger(-100000000, 100000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 11: {
                d = ProbabilityDistributions.rndInteger(-1000000000, 1000000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 12: {
                d = ProbabilityDistributions.rndInteger(0, 0x7FFFFFFE, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 13: {
                d = ProbabilityDistributions.rndInteger(0, 10, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 14: {
                d = ProbabilityDistributions.rndInteger(0, 100, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 15: {
                d = ProbabilityDistributions.rndInteger(0, 1000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 16: {
                d = ProbabilityDistributions.rndInteger(0, 10000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 17: {
                d = ProbabilityDistributions.rndInteger(0, 100000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 18: {
                d = ProbabilityDistributions.rndInteger(0, 1000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 19: {
                d = ProbabilityDistributions.rndInteger(0, 10000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 20: {
                d = ProbabilityDistributions.rndInteger(0, 100000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 21: {
                d = ProbabilityDistributions.rndInteger(0, 1000000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 22: {
                d = ProbabilityDistributions.rndInteger(1, 0x7FFFFFFE, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 23: {
                d = ProbabilityDistributions.rndInteger(1, 10, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 24: {
                d = ProbabilityDistributions.rndInteger(1, 100, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 25: {
                d = ProbabilityDistributions.rndInteger(1, 1000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 26: {
                d = ProbabilityDistributions.rndInteger(1, 10000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 27: {
                d = ProbabilityDistributions.rndInteger(1, 100000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 28: {
                d = ProbabilityDistributions.rndInteger(1, 1000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 29: {
                d = ProbabilityDistributions.rndInteger(1, 10000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 30: {
                d = ProbabilityDistributions.rndInteger(1, 100000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 31: {
                d = ProbabilityDistributions.rndInteger(1, 1000000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 32: {
                d = ProbabilityDistributions.rndNormal(0.0, 1.0, ProbabilityDistributions.randomGenerator);
            }
        }
        this.setToNumber(n, d);
    }

    private double getTokenValue(int n) {
        return this.tokensList.get((int)n).tokenValue;
    }

    private void TETRATION(int n) {
        double d = this.getTokenValue(n - 1);
        double d2 = this.getTokenValue(n + 1);
        this.opSetDecreaseRemove(n, MathFunctions.tetration(d, d2), true);
    }

    private void POWER(int n) {
        double d = this.getTokenValue(n - 1);
        double d2 = this.getTokenValue(n + 1);
        this.opSetDecreaseRemove(n, MathFunctions.power(d, d2), true);
    }

    private void MODULO(int n) {
        double d = this.getTokenValue(n - 1);
        double d2 = this.getTokenValue(n + 1);
        this.opSetDecreaseRemove(n, MathFunctions.mod(d, d2));
    }

    private void DIVIDE(int n) {
        double d = this.getTokenValue(n - 1);
        double d2 = this.getTokenValue(n + 1);
        if (this.disableRounding) {
            double d3 = Double.NaN;
            if (d2 != 0.0) {
                d3 = d / d2;
            }
            this.opSetDecreaseRemove(n, d3, true);
        } else {
            this.opSetDecreaseRemove(n, MathFunctions.div(d, d2), true);
        }
    }

    private void MULTIPLY(int n) {
        double d = this.getTokenValue(n - 1);
        double d2 = this.getTokenValue(n + 1);
        if (this.disableRounding) {
            this.opSetDecreaseRemove(n, d * d2, true);
        } else {
            this.opSetDecreaseRemove(n, MathFunctions.multiply(d, d2), true);
        }
    }

    private void PLUS(int n) {
        Token token = this.tokensList.get(n + 1);
        if (n > 0) {
            Token token2 = this.tokensList.get(n - 1);
            if (token2.tokenTypeId == 0 && token.tokenTypeId == 0) {
                if (this.disableRounding) {
                    this.opSetDecreaseRemove(n, token2.tokenValue + token.tokenValue, true);
                } else {
                    this.opSetDecreaseRemove(n, MathFunctions.plus(token2.tokenValue, token.tokenValue), true);
                }
            } else if (token.tokenTypeId == 0) {
                this.setToNumber(n, token.tokenValue);
                this.tokensList.remove(n + 1);
            }
        } else if (token.tokenTypeId == 0) {
            this.setToNumber(n, token.tokenValue);
            this.tokensList.remove(n + 1);
        }
    }

    private void MINUS(int n) {
        Token token = this.tokensList.get(n + 1);
        if (n > 0) {
            Token token2 = this.tokensList.get(n - 1);
            if (token2.tokenTypeId == 0 && token.tokenTypeId == 0) {
                if (this.disableRounding) {
                    this.opSetDecreaseRemove(n, token2.tokenValue - token.tokenValue, true);
                } else {
                    this.opSetDecreaseRemove(n, MathFunctions.minus(token2.tokenValue, token.tokenValue), true);
                }
            } else if (token.tokenTypeId == 0) {
                this.setToNumber(n, -token.tokenValue);
                this.tokensList.remove(n + 1);
            }
        } else if (token.tokenTypeId == 0) {
            this.setToNumber(n, -token.tokenValue);
            this.tokensList.remove(n + 1);
        }
    }

    private void AND(int n) {
        double d = this.getTokenValue(n - 1);
        double d2 = this.getTokenValue(n + 1);
        this.opSetDecreaseRemove(n, BooleanAlgebra.and(d, d2));
    }

    private void OR(int n) {
        double d = this.getTokenValue(n - 1);
        double d2 = this.getTokenValue(n + 1);
        this.opSetDecreaseRemove(n, BooleanAlgebra.or(d, d2));
    }

    private void NAND(int n) {
        double d = this.getTokenValue(n - 1);
        double d2 = this.getTokenValue(n + 1);
        this.opSetDecreaseRemove(n, BooleanAlgebra.nand(d, d2));
    }

    private void NOR(int n) {
        double d = this.getTokenValue(n - 1);
        double d2 = this.getTokenValue(n + 1);
        this.opSetDecreaseRemove(n, BooleanAlgebra.nor(d, d2));
    }

    private void XOR(int n) {
        double d = this.getTokenValue(n - 1);
        double d2 = this.getTokenValue(n + 1);
        this.opSetDecreaseRemove(n, BooleanAlgebra.xor(d, d2));
    }

    private void IMP(int n) {
        double d = this.getTokenValue(n - 1);
        double d2 = this.getTokenValue(n + 1);
        this.opSetDecreaseRemove(n, BooleanAlgebra.imp(d, d2));
    }

    private void CIMP(int n) {
        double d = this.getTokenValue(n - 1);
        double d2 = this.getTokenValue(n + 1);
        this.opSetDecreaseRemove(n, BooleanAlgebra.cimp(d, d2));
    }

    private void NIMP(int n) {
        double d = this.getTokenValue(n - 1);
        double d2 = this.getTokenValue(n + 1);
        this.opSetDecreaseRemove(n, BooleanAlgebra.nimp(d, d2));
    }

    private void CNIMP(int n) {
        double d = this.getTokenValue(n - 1);
        double d2 = this.getTokenValue(n + 1);
        this.opSetDecreaseRemove(n, BooleanAlgebra.cnimp(d, d2));
    }

    private void EQV(int n) {
        double d = this.getTokenValue(n - 1);
        double d2 = this.getTokenValue(n + 1);
        this.opSetDecreaseRemove(n, BooleanAlgebra.eqv(d, d2));
    }

    private void NEG(int n) {
        double d = this.getTokenValue(n + 1);
        this.setToNumber(n, BooleanAlgebra.not(d));
        this.tokensList.remove(n + 1);
    }

    private void EQ(int n) {
        double d = this.getTokenValue(n - 1);
        double d2 = this.getTokenValue(n + 1);
        this.opSetDecreaseRemove(n, BinaryRelations.eq(d, d2));
    }

    private void NEQ(int n) {
        double d = this.getTokenValue(n - 1);
        double d2 = this.getTokenValue(n + 1);
        this.opSetDecreaseRemove(n, BinaryRelations.neq(d, d2));
    }

    private void LT(int n) {
        double d = this.getTokenValue(n - 1);
        double d2 = this.getTokenValue(n + 1);
        this.opSetDecreaseRemove(n, BinaryRelations.lt(d, d2));
    }

    private void GT(int n) {
        double d = this.getTokenValue(n - 1);
        double d2 = this.getTokenValue(n + 1);
        this.opSetDecreaseRemove(n, BinaryRelations.gt(d, d2));
    }

    private void LEQ(int n) {
        double d = this.getTokenValue(n - 1);
        double d2 = this.getTokenValue(n + 1);
        this.opSetDecreaseRemove(n, BinaryRelations.leq(d, d2));
    }

    private void GEQ(int n) {
        double d = this.getTokenValue(n - 1);
        double d2 = this.getTokenValue(n + 1);
        this.opSetDecreaseRemove(n, BinaryRelations.geq(d, d2));
    }

    private void BITWISE_COMPL(int n) {
        long l = (long)this.getTokenValue(n + 1);
        this.setToNumber(n, l ^ 0xFFFFFFFFFFFFFFFFL);
        this.tokensList.remove(n + 1);
    }

    private void BITWISE_AND(int n) {
        long l = (long)this.getTokenValue(n - 1);
        long l2 = (long)this.getTokenValue(n + 1);
        this.opSetDecreaseRemove(n, l & l2);
    }

    private void BITWISE_OR(int n) {
        long l = (long)this.getTokenValue(n - 1);
        long l2 = (long)this.getTokenValue(n + 1);
        this.opSetDecreaseRemove(n, l | l2);
    }

    private void BITWISE_XOR(int n) {
        long l = (long)this.getTokenValue(n - 1);
        long l2 = (long)this.getTokenValue(n + 1);
        this.opSetDecreaseRemove(n, l ^ l2);
    }

    private void BITWISE_LEFT_SHIFT(int n) {
        long l = (long)this.getTokenValue(n - 1);
        int n2 = (int)this.getTokenValue(n + 1);
        this.opSetDecreaseRemove(n, l << n2);
    }

    private void BITWISE_RIGHT_SHIFT(int n) {
        long l = (long)this.getTokenValue(n - 1);
        int n2 = (int)this.getTokenValue(n + 1);
        this.opSetDecreaseRemove(n, l >> n2);
    }

    private void SIN(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.sin(d));
    }

    private void COS(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.cos(d));
    }

    private void TAN(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.tan(d));
    }

    private void CTAN(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.ctan(d));
    }

    private void SEC(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.sec(d));
    }

    private void COSEC(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.cosec(d));
    }

    private void ASIN(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.asin(d));
    }

    private void ACOS(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.acos(d));
    }

    private void ATAN(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.atan(d));
    }

    private void ACTAN(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.actan(d));
    }

    private void LN(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.ln(d));
    }

    private void LOG2(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.log2(d));
    }

    private void LOG10(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.log10(d));
    }

    private void RAD(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.rad(d));
    }

    private void EXP(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.exp(d));
    }

    private void SQRT(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.sqrt(d));
    }

    private void SINH(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.sinh(d));
    }

    private void COSH(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.cosh(d));
    }

    private void TANH(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.tanh(d));
    }

    private void COTH(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.coth(d));
    }

    private void SECH(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.sech(d));
    }

    private void CSCH(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.csch(d));
    }

    private void DEG(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.deg(d));
    }

    private void ABS(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.abs(d));
    }

    private void SGN(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.sgn(d));
    }

    private void FLOOR(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.floor(d));
    }

    private void CEIL(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.ceil(d));
    }

    private void ARSINH(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.arsinh(d));
    }

    private void ARCOSH(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.arcosh(d));
    }

    private void ARTANH(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.artanh(d));
    }

    private void ARCOTH(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.arcoth(d));
    }

    private void ARSECH(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.arsech(d));
    }

    private void ARCSCH(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.arcsch(d));
    }

    private void SA(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.sa(d));
    }

    private void SINC(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.sinc(d));
    }

    private void BELL_NUMBER(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.bellNumber(d));
    }

    private void LUCAS_NUMBER(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.lucasNumber(d));
    }

    private void FIBONACCI_NUMBER(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.fibonacciNumber(d));
    }

    private void HARMONIC_NUMBER(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.harmonicNumber(d));
    }

    private void IS_PRIME(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, NumberTheory.primeTest(d));
    }

    private void PRIME_COUNT(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, NumberTheory.primeCount(d));
    }

    private void EXP_INT(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, SpecialFunctions.exponentialIntegralEi(d));
    }

    private void LOG_INT(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, SpecialFunctions.logarithmicIntegralLi(d));
    }

    private void OFF_LOG_INT(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, SpecialFunctions.offsetLogarithmicIntegralLi(d));
    }

    private void FACT(int n) {
        double d = this.getTokenValue(n - 1);
        this.setToNumber(n, MathFunctions.factorial(d));
        this.tokensList.remove(n - 1);
    }

    private void PERC(int n) {
        double d = this.getTokenValue(n - 1);
        this.setToNumber(n, d * 0.01);
        this.tokensList.remove(n - 1);
    }

    private void NOT(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, BooleanAlgebra.not(d));
    }

    private void GAUSS_ERF(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, SpecialFunctions.erf(d));
    }

    private void GAUSS_ERFC(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, SpecialFunctions.erfc(d));
    }

    private void GAUSS_ERF_INV(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, SpecialFunctions.erfInv(d));
    }

    private void GAUSS_ERFC_INV(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, SpecialFunctions.erfcInv(d));
    }

    private void ULP(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.ulp(d));
    }

    private void ISNAN(int n) {
        double d = this.getTokenValue(n + 1);
        if (Double.isNaN(d)) {
            this.f1SetDecreaseRemove(n, 1.0);
        } else {
            this.f1SetDecreaseRemove(n, 0.0);
        }
    }

    private void NDIG10(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, NumberTheory.numberOfDigits(d));
    }

    private void NFACT(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, NumberTheory.numberOfPrimeFactors(d));
    }

    private void ARCSEC(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.asec(d));
    }

    private void ARCCSC(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, MathFunctions.acosec(d));
    }

    private void GAMMA(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, SpecialFunctions.gamma(d));
    }

    private void LAMBERT_W0(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, SpecialFunctions.lambertW(d, 0.0));
    }

    private void LAMBERT_W1(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, SpecialFunctions.lambertW(d, -1.0));
    }

    private void SGN_GAMMA(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, SpecialFunctions.sgnGamma(d));
    }

    private void LOG_GAMMA(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, SpecialFunctions.logGamma(d));
    }

    private void DI_GAMMA(int n) {
        double d = this.getTokenValue(n + 1);
        this.f1SetDecreaseRemove(n, SpecialFunctions.diGamma(d));
    }

    private void UDF_PARAM(int n) {
        double d = Double.NaN;
        double d2 = this.getTokenValue(n + 1);
        int n2 = this.UDFVariadicParamsAtRunTime.size();
        if (!Double.isNaN(d2) && d2 != Double.POSITIVE_INFINITY && d2 != Double.NEGATIVE_INFINITY) {
            int n3 = (int)MathFunctions.integerPart(d2);
            if (n3 == 0) {
                d = n2;
            } else if (Math.abs(n3) <= n2) {
                if (n3 >= 1) {
                    d = this.UDFVariadicParamsAtRunTime.get(n3 - 1);
                } else if (n3 <= -1) {
                    d = this.UDFVariadicParamsAtRunTime.get(n2 + n3);
                }
            }
        }
        this.f1SetDecreaseRemove(n, d);
    }

    private void LOG(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, MathFunctions.log(d2, d));
    }

    private List<Double> getNumbers(int n) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n2 = n;
        int n3 = this.tokensList.size() - 1;
        boolean bl = false;
        do {
            Token token = this.tokensList.get(++n2);
            boolean bl2 = false;
            if (token.tokenTypeId == 0 && token.tokenId == 1) {
                bl2 = true;
                arrayList.add(token.tokenValue);
            }
            if (n2 != n3 && bl2) continue;
            bl = true;
        } while (!bl);
        return arrayList;
    }

    private void MOD(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, MathFunctions.mod(d, d2));
    }

    private void BINOM_COEFF(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, MathFunctions.binomCoeff(d, d2));
    }

    private void PERMUTATIONS(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, MathFunctions.numberOfPermutations(d, d2));
    }

    private void BETA(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, SpecialFunctions.beta(d, d2));
    }

    private void LOG_BETA(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, SpecialFunctions.logBeta(d, d2));
    }

    private void BERNOULLI_NUMBER(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, MathFunctions.bernoulliNumber(d, d2));
    }

    private void STIRLING1_NUMBER(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, MathFunctions.Stirling1Number(d, d2));
    }

    private void STIRLING2_NUMBER(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, MathFunctions.Stirling2Number(d, d2));
    }

    private void WORPITZKY_NUMBER(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, MathFunctions.worpitzkyNumber(d, d2));
    }

    private void EULER_NUMBER(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, MathFunctions.eulerNumber(d, d2));
    }

    private void KRONECKER_DELTA(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, MathFunctions.kroneckerDelta(d, d2));
    }

    private void EULER_POLYNOMIAL(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, MathFunctions.eulerPolynomial(d, d2));
    }

    private void HARMONIC2_NUMBER(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, MathFunctions.harmonicNumber(d, d2));
    }

    private void ROUND(int n) {
        double d = this.getTokenValue(n + 1);
        int n2 = (int)this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, MathFunctions.round(d, n2));
    }

    private void RND_VAR_UNIFORM_CONT(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, ProbabilityDistributions.rndUniformContinuous(d, d2, ProbabilityDistributions.randomGenerator));
    }

    private void RND_VAR_UNIFORM_DISCR(int n) {
        int n2 = (int)this.getTokenValue(n + 1);
        int n3 = (int)this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, ProbabilityDistributions.rndInteger(n2, n3, ProbabilityDistributions.randomGenerator));
    }

    private void RND_NORMAL(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, ProbabilityDistributions.rndNormal(d, d2, ProbabilityDistributions.randomGenerator));
    }

    private void NDIG(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, NumberTheory.numberOfDigits(d, d2));
    }

    private void DIGIT10(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, NumberTheory.digitAtPosition(d, d2));
    }

    private void FACTVAL(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, NumberTheory.primeFactorValue(d, d2));
    }

    private void FACTEXP(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, NumberTheory.primeFactorExponent(d, d2));
    }

    private void ROOT(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, MathFunctions.root(d, d2));
    }

    private void INC_GAMMA_LOWER(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, SpecialFunctions.incompleteGammaLower(d, d2));
    }

    private void INC_GAMMA_UPPER(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, SpecialFunctions.incompleteGammaUpper(d, d2));
    }

    private void REG_GAMMA_LOWER(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, SpecialFunctions.regularizedGammaLowerP(d, d2));
    }

    private void REG_GAMMA_UPPER(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        this.f2SetDecreaseRemove(n, SpecialFunctions.regularizedGammaUpperQ(d, d2));
    }

    private void IF_CONDITION(int n) {
        List<FunctionParameter> list = this.getFunctionParameters(n, this.tokensList);
        FunctionParameter functionParameter = list.get(0);
        Expression expression = new Expression(functionParameter.paramStr, functionParameter.tokens, this.argumentsList, this.functionsList, this.constantsList, false, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        if (this.verboseMode) {
            expression.setVerboseMode();
        }
        this.ifSetRemove(n, expression.calculate());
    }

    private void IFF(int n) {
        List<FunctionParameter> list = this.getFunctionParameters(n, this.tokensList);
        FunctionParameter functionParameter = list.get(0);
        int n2 = list.size();
        int n3 = 1;
        double d = 0.0;
        boolean bl = true;
        do {
            Expression expression = new Expression(functionParameter.paramStr, functionParameter.tokens, this.argumentsList, this.functionsList, this.constantsList, false, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            if (this.verboseMode) {
                expression.setVerboseMode();
            }
            bl = true;
            d = expression.calculate();
            if (d != 0.0 && !Double.isNaN(d)) continue;
            bl = false;
            if ((n3 += 2) >= n2) continue;
            functionParameter = list.get(n3 - 1);
        } while (!bl && n3 < n2);
        if (bl) {
            int n4;
            int n5 = n3 + 1;
            int n6 = n + 1;
            int n7 = list.get((int)(n2 - 1)).toIndex + 1;
            --this.tokensList.get((int)n6).tokenLevel;
            --this.tokensList.get((int)n7).tokenLevel;
            if (n5 < n2) {
                n7 = list.get((int)(n2 - 1)).toIndex;
                n6 = list.get((int)n5).fromIndex - 1;
                for (n4 = n7; n4 >= n6; --n4) {
                    this.tokensList.remove(n4);
                }
            }
            n6 = list.get((int)(n5 - 1)).fromIndex;
            n7 = list.get((int)(n5 - 1)).toIndex;
            for (n4 = n6; n4 <= n7; ++n4) {
                --this.tokensList.get((int)n4).tokenLevel;
            }
            n7 = n6 - 1;
            n6 = n;
            for (n4 = n7; n4 >= n6; --n4) {
                if (n4 == n + 1) continue;
                this.tokensList.remove(n4);
            }
        } else {
            int n8 = list.get((int)(n2 - 1)).toIndex + 1;
            int n9 = n + 1;
            for (int i = n8; i >= n9; --i) {
                this.tokensList.remove(i);
            }
            this.setToNumber(n, Double.NaN);
            --this.tokensList.get((int)n).tokenLevel;
        }
    }

    private void IF(int n) {
        double d;
        double d2 = this.tokensList.get((int)(n + 1)).tokenValue;
        double d3 = this.tokensList.get((int)(n + 2)).tokenValue;
        double d4 = d = this.tokensList.get((int)(n + 3)).tokenValue;
        if (d2 != 0.0) {
            d4 = d3;
        }
        if (d2 == Double.NaN) {
            d4 = Double.NaN;
        }
        this.f3SetDecreaseRemove(n, d4);
    }

    private void CHI(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        double d3 = this.getTokenValue(n + 3);
        this.f3SetDecreaseRemove(n, MathFunctions.chi(d, d2, d3));
    }

    private void CHI_LR(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        double d3 = this.getTokenValue(n + 3);
        this.f3SetDecreaseRemove(n, MathFunctions.chi_LR(d, d2, d3));
    }

    private void CHI_L(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        double d3 = this.getTokenValue(n + 3);
        this.f3SetDecreaseRemove(n, MathFunctions.chi_L(d, d2, d3));
    }

    private void CHI_R(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        double d3 = this.getTokenValue(n + 3);
        this.f3SetDecreaseRemove(n, MathFunctions.chi_R(d, d2, d3));
    }

    private void PDF_UNIFORM_CONT(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        double d3 = this.getTokenValue(n + 3);
        this.f3SetDecreaseRemove(n, ProbabilityDistributions.pdfUniformContinuous(d, d2, d3));
    }

    private void CDF_UNIFORM_CONT(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        double d3 = this.getTokenValue(n + 3);
        this.f3SetDecreaseRemove(n, ProbabilityDistributions.cdfUniformContinuous(d, d2, d3));
    }

    private void QNT_UNIFORM_CONT(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        double d3 = this.getTokenValue(n + 3);
        this.f3SetDecreaseRemove(n, ProbabilityDistributions.qntUniformContinuous(d, d2, d3));
    }

    private void PDF_NORMAL(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        double d3 = this.getTokenValue(n + 3);
        this.f3SetDecreaseRemove(n, ProbabilityDistributions.pdfNormal(d, d2, d3));
    }

    private void CDF_NORMAL(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        double d3 = this.getTokenValue(n + 3);
        this.f3SetDecreaseRemove(n, ProbabilityDistributions.cdfNormal(d, d2, d3));
    }

    private void QNT_NORMAL(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        double d3 = this.getTokenValue(n + 3);
        this.f3SetDecreaseRemove(n, ProbabilityDistributions.qntNormal(d, d2, d3));
    }

    private void DIGIT(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        double d3 = this.getTokenValue(n + 3);
        this.f3SetDecreaseRemove(n, NumberTheory.digitAtPosition(d, d2, d3));
    }

    private void INC_BETA(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        double d3 = this.getTokenValue(n + 3);
        this.f3SetDecreaseRemove(n, SpecialFunctions.incompleteBeta(d2, d3, d));
    }

    private void REG_BETA(int n) {
        double d = this.getTokenValue(n + 1);
        double d2 = this.getTokenValue(n + 2);
        double d3 = this.getTokenValue(n + 3);
        this.f3SetDecreaseRemove(n, SpecialFunctions.regularizedBeta(d2, d3, d));
    }

    private void updateMissingTokens(List<Token> list, String string, int n, int n2) {
        for (Token token : list) {
            if (token.tokenTypeId != -1 || !token.tokenStr.equals(string)) continue;
            token.keyWord = string;
            token.tokenId = n;
            token.tokenTypeId = n2;
        }
    }

    private void updateMissingTokens(ArgumentParameter argumentParameter, IterativeOperatorParameters iterativeOperatorParameters) {
        if (argumentParameter.presence == -1) {
            this.updateMissingTokens(iterativeOperatorParameters.indexParam.tokens, iterativeOperatorParameters.indexParam.paramStr, argumentParameter.index, 101);
            this.updateMissingTokens(iterativeOperatorParameters.fromParam.tokens, iterativeOperatorParameters.indexParam.paramStr, argumentParameter.index, 101);
            this.updateMissingTokens(iterativeOperatorParameters.toParam.tokens, iterativeOperatorParameters.indexParam.paramStr, argumentParameter.index, 101);
            this.updateMissingTokens(iterativeOperatorParameters.funParam.tokens, iterativeOperatorParameters.indexParam.paramStr, argumentParameter.index, 101);
        }
    }

    private void evalFromToDeltaParameters(ArgumentParameter argumentParameter, IterativeOperatorParameters iterativeOperatorParameters) {
        iterativeOperatorParameters.fromExp = new Expression(iterativeOperatorParameters.fromParam.paramStr, iterativeOperatorParameters.fromParam.tokens, this.argumentsList, this.functionsList, this.constantsList, false, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        iterativeOperatorParameters.toExp = new Expression(iterativeOperatorParameters.toParam.paramStr, iterativeOperatorParameters.toParam.tokens, this.argumentsList, this.functionsList, this.constantsList, false, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        iterativeOperatorParameters.funExp = new Expression(iterativeOperatorParameters.funParam.paramStr, iterativeOperatorParameters.funParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        iterativeOperatorParameters.deltaExp = null;
        if (this.verboseMode) {
            iterativeOperatorParameters.fromExp.setVerboseMode();
            iterativeOperatorParameters.toExp.setVerboseMode();
            iterativeOperatorParameters.funExp.setVerboseMode();
        }
        iterativeOperatorParameters.from = iterativeOperatorParameters.fromExp.calculate();
        iterativeOperatorParameters.to = iterativeOperatorParameters.toExp.calculate();
        iterativeOperatorParameters.delta = 1.0;
        if (iterativeOperatorParameters.to < iterativeOperatorParameters.from) {
            iterativeOperatorParameters.delta = -1.0;
        }
        if (iterativeOperatorParameters.withDelta) {
            iterativeOperatorParameters.deltaExp = new Expression(iterativeOperatorParameters.deltaParam.paramStr, iterativeOperatorParameters.deltaParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            if (argumentParameter.presence == -1) {
                this.updateMissingTokens(iterativeOperatorParameters.deltaParam.tokens, iterativeOperatorParameters.indexParam.paramStr, argumentParameter.index, 101);
            }
            if (this.verboseMode) {
                iterativeOperatorParameters.deltaExp.setVerboseMode();
            }
            iterativeOperatorParameters.delta = iterativeOperatorParameters.deltaExp.calculate();
        }
    }

    private void SUM(int n) {
        IterativeOperatorParameters iterativeOperatorParameters = new IterativeOperatorParameters(this.getFunctionParameters(n, this.tokensList));
        ArgumentParameter argumentParameter = this.getParamArgument(iterativeOperatorParameters.indexParam.paramStr);
        this.updateMissingTokens(argumentParameter, iterativeOperatorParameters);
        this.evalFromToDeltaParameters(argumentParameter, iterativeOperatorParameters);
        double d = NumberTheory.sigmaSummation(iterativeOperatorParameters.funExp, argumentParameter.argument, iterativeOperatorParameters.from, iterativeOperatorParameters.to, iterativeOperatorParameters.delta);
        this.clearParamArgument(argumentParameter);
        this.calcSetDecreaseRemove(n, d, true);
    }

    private void PROD(int n) {
        IterativeOperatorParameters iterativeOperatorParameters = new IterativeOperatorParameters(this.getFunctionParameters(n, this.tokensList));
        ArgumentParameter argumentParameter = this.getParamArgument(iterativeOperatorParameters.indexParam.paramStr);
        this.updateMissingTokens(argumentParameter, iterativeOperatorParameters);
        this.evalFromToDeltaParameters(argumentParameter, iterativeOperatorParameters);
        double d = NumberTheory.piProduct(iterativeOperatorParameters.funExp, argumentParameter.argument, iterativeOperatorParameters.from, iterativeOperatorParameters.to, iterativeOperatorParameters.delta);
        this.clearParamArgument(argumentParameter);
        this.calcSetDecreaseRemove(n, d, true);
    }

    private void MIN(int n) {
        IterativeOperatorParameters iterativeOperatorParameters = new IterativeOperatorParameters(this.getFunctionParameters(n, this.tokensList));
        ArgumentParameter argumentParameter = this.getParamArgument(iterativeOperatorParameters.indexParam.paramStr);
        this.updateMissingTokens(argumentParameter, iterativeOperatorParameters);
        this.evalFromToDeltaParameters(argumentParameter, iterativeOperatorParameters);
        double d = NumberTheory.min(iterativeOperatorParameters.funExp, argumentParameter.argument, iterativeOperatorParameters.from, iterativeOperatorParameters.to, iterativeOperatorParameters.delta);
        this.clearParamArgument(argumentParameter);
        this.calcSetDecreaseRemove(n, d);
    }

    private void MAX(int n) {
        IterativeOperatorParameters iterativeOperatorParameters = new IterativeOperatorParameters(this.getFunctionParameters(n, this.tokensList));
        ArgumentParameter argumentParameter = this.getParamArgument(iterativeOperatorParameters.indexParam.paramStr);
        this.updateMissingTokens(argumentParameter, iterativeOperatorParameters);
        this.evalFromToDeltaParameters(argumentParameter, iterativeOperatorParameters);
        double d = NumberTheory.max(iterativeOperatorParameters.funExp, argumentParameter.argument, iterativeOperatorParameters.from, iterativeOperatorParameters.to, iterativeOperatorParameters.delta);
        this.clearParamArgument(argumentParameter);
        this.calcSetDecreaseRemove(n, d);
    }

    private void AVG(int n) {
        IterativeOperatorParameters iterativeOperatorParameters = new IterativeOperatorParameters(this.getFunctionParameters(n, this.tokensList));
        ArgumentParameter argumentParameter = this.getParamArgument(iterativeOperatorParameters.indexParam.paramStr);
        this.updateMissingTokens(argumentParameter, iterativeOperatorParameters);
        this.evalFromToDeltaParameters(argumentParameter, iterativeOperatorParameters);
        double d = Statistics.avg(iterativeOperatorParameters.funExp, argumentParameter.argument, iterativeOperatorParameters.from, iterativeOperatorParameters.to, iterativeOperatorParameters.delta);
        this.clearParamArgument(argumentParameter);
        this.calcSetDecreaseRemove(n, d, true);
    }

    private void VAR(int n) {
        IterativeOperatorParameters iterativeOperatorParameters = new IterativeOperatorParameters(this.getFunctionParameters(n, this.tokensList));
        ArgumentParameter argumentParameter = this.getParamArgument(iterativeOperatorParameters.indexParam.paramStr);
        this.updateMissingTokens(argumentParameter, iterativeOperatorParameters);
        this.evalFromToDeltaParameters(argumentParameter, iterativeOperatorParameters);
        double d = Statistics.var(iterativeOperatorParameters.funExp, argumentParameter.argument, iterativeOperatorParameters.from, iterativeOperatorParameters.to, iterativeOperatorParameters.delta);
        this.clearParamArgument(argumentParameter);
        this.calcSetDecreaseRemove(n, d, true);
    }

    private void STD(int n) {
        IterativeOperatorParameters iterativeOperatorParameters = new IterativeOperatorParameters(this.getFunctionParameters(n, this.tokensList));
        ArgumentParameter argumentParameter = this.getParamArgument(iterativeOperatorParameters.indexParam.paramStr);
        this.updateMissingTokens(argumentParameter, iterativeOperatorParameters);
        this.evalFromToDeltaParameters(argumentParameter, iterativeOperatorParameters);
        double d = Statistics.std(iterativeOperatorParameters.funExp, argumentParameter.argument, iterativeOperatorParameters.from, iterativeOperatorParameters.to, iterativeOperatorParameters.delta);
        this.clearParamArgument(argumentParameter);
        this.calcSetDecreaseRemove(n, d, true);
    }

    private void DERIVATIVE(int n, int n2) {
        List<FunctionParameter> list = this.getFunctionParameters(n, this.tokensList);
        FunctionParameter functionParameter = list.get(0);
        FunctionParameter functionParameter2 = list.get(1);
        ArgumentParameter argumentParameter = this.getParamArgument(functionParameter2.paramStr);
        if (argumentParameter.presence == -1) {
            this.updateMissingTokens(functionParameter2.tokens, functionParameter2.paramStr, argumentParameter.index, 101);
            this.updateMissingTokens(functionParameter.tokens, functionParameter2.paramStr, argumentParameter.index, 101);
        }
        Expression expression = new Expression(functionParameter.paramStr, functionParameter.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        double d = Double.NaN;
        if (list.size() == 2 || list.size() == 4) {
            d = argumentParameter.argument.getArgumentValue();
        }
        if (list.size() == 3 || list.size() == 5) {
            FunctionParameter functionParameter3 = list.get(2);
            if (argumentParameter.presence == -1) {
                this.updateMissingTokens(functionParameter3.tokens, functionParameter2.paramStr, argumentParameter.index, 101);
            }
            Expression expression2 = new Expression(functionParameter3.paramStr, functionParameter3.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            d = expression2.calculate();
        }
        double d2 = 1.0E-8;
        int n3 = 20;
        if (list.size() == 4 || list.size() == 5) {
            FunctionParameter functionParameter4;
            FunctionParameter functionParameter5;
            if (list.size() == 4) {
                functionParameter5 = list.get(2);
                functionParameter4 = list.get(3);
            } else {
                functionParameter5 = list.get(3);
                functionParameter4 = list.get(4);
            }
            if (argumentParameter.presence == -1) {
                this.updateMissingTokens(functionParameter5.tokens, functionParameter2.paramStr, argumentParameter.index, 101);
                this.updateMissingTokens(functionParameter4.tokens, functionParameter2.paramStr, argumentParameter.index, 101);
            }
            Expression expression3 = new Expression(functionParameter5.paramStr, functionParameter5.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            Expression expression4 = new Expression(functionParameter4.paramStr, functionParameter4.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            d2 = expression3.calculate();
            n3 = (int)Math.round(expression4.calculate());
        }
        if (n2 == 3) {
            double d3 = Calculus.derivative(expression, argumentParameter.argument, d, 3, d2, n3);
            this.calcSetDecreaseRemove(n, d3);
        } else if (n2 == 1) {
            double d4 = Calculus.derivative(expression, argumentParameter.argument, d, 1, d2, n3);
            this.calcSetDecreaseRemove(n, d4);
        } else {
            double d5 = Calculus.derivative(expression, argumentParameter.argument, d, 2, d2, n3);
            this.calcSetDecreaseRemove(n, d5);
        }
        this.clearParamArgument(argumentParameter);
    }

    private void DERIVATIVE_NTH(int n, int n2) {
        List<FunctionParameter> list = this.getFunctionParameters(n, this.tokensList);
        FunctionParameter functionParameter = list.get(0);
        FunctionParameter functionParameter2 = list.get(1);
        FunctionParameter functionParameter3 = list.get(2);
        ArgumentParameter argumentParameter = this.getParamArgument(functionParameter3.paramStr);
        if (argumentParameter.presence == -1) {
            this.updateMissingTokens(functionParameter3.tokens, functionParameter3.paramStr, argumentParameter.index, 101);
            this.updateMissingTokens(functionParameter.tokens, functionParameter3.paramStr, argumentParameter.index, 101);
            this.updateMissingTokens(functionParameter2.tokens, functionParameter3.paramStr, argumentParameter.index, 101);
        }
        Expression expression = new Expression(functionParameter.paramStr, functionParameter.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        Expression expression2 = new Expression(functionParameter2.paramStr, functionParameter2.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        double d = expression2.calculate();
        double d2 = argumentParameter.argument.getArgumentValue();
        double d3 = 1.0E-6;
        int n3 = 20;
        if (list.size() == 5) {
            FunctionParameter functionParameter4 = list.get(3);
            FunctionParameter functionParameter5 = list.get(4);
            if (argumentParameter.presence == -1) {
                this.updateMissingTokens(functionParameter4.tokens, functionParameter3.paramStr, argumentParameter.index, 101);
                this.updateMissingTokens(functionParameter5.tokens, functionParameter3.paramStr, argumentParameter.index, 101);
            }
            Expression expression3 = new Expression(functionParameter4.paramStr, functionParameter4.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            Expression expression4 = new Expression(functionParameter5.paramStr, functionParameter5.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            d3 = expression3.calculate();
            n3 = (int)Math.round(expression4.calculate());
        }
        if (n2 == 3) {
            double d4 = Calculus.derivativeNth(expression, d, argumentParameter.argument, d2, 1, d3, n3);
            double d5 = Calculus.derivativeNth(expression, d, argumentParameter.argument, d2, 2, d3, n3);
            this.calcSetDecreaseRemove(n, (d4 + d5) / 2.0);
        } else if (n2 == 1) {
            double d6 = Calculus.derivativeNth(expression, d, argumentParameter.argument, d2, 1, d3, n3);
            this.calcSetDecreaseRemove(n, d6);
        } else {
            double d7 = Calculus.derivativeNth(expression, d, argumentParameter.argument, d2, 2, d3, n3);
            this.calcSetDecreaseRemove(n, d7);
        }
        this.clearParamArgument(argumentParameter);
    }

    private void INTEGRAL(int n) {
        List<FunctionParameter> list = this.getFunctionParameters(n, this.tokensList);
        FunctionParameter functionParameter = list.get(0);
        FunctionParameter functionParameter2 = list.get(1);
        FunctionParameter functionParameter3 = list.get(2);
        FunctionParameter functionParameter4 = list.get(3);
        ArgumentParameter argumentParameter = this.getParamArgument(functionParameter2.paramStr);
        if (argumentParameter.presence == -1) {
            this.updateMissingTokens(functionParameter2.tokens, functionParameter2.paramStr, argumentParameter.index, 101);
            this.updateMissingTokens(functionParameter.tokens, functionParameter2.paramStr, argumentParameter.index, 101);
            this.updateMissingTokens(functionParameter3.tokens, functionParameter2.paramStr, argumentParameter.index, 101);
            this.updateMissingTokens(functionParameter4.tokens, functionParameter2.paramStr, argumentParameter.index, 101);
        }
        Expression expression = new Expression(functionParameter.paramStr, functionParameter.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        Expression expression2 = new Expression(functionParameter3.paramStr, functionParameter3.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        Expression expression3 = new Expression(functionParameter4.paramStr, functionParameter4.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        double d = 1.0E-6;
        int n2 = 20;
        this.calcSetDecreaseRemove(n, Calculus.integralTrapezoid(expression, argumentParameter.argument, expression2.calculate(), expression3.calculate(), d, n2));
        this.clearParamArgument(argumentParameter);
    }

    private void SOLVE(int n) {
        List<FunctionParameter> list = this.getFunctionParameters(n, this.tokensList);
        FunctionParameter functionParameter = list.get(0);
        FunctionParameter functionParameter2 = list.get(1);
        FunctionParameter functionParameter3 = list.get(2);
        FunctionParameter functionParameter4 = list.get(3);
        ArgumentParameter argumentParameter = this.getParamArgument(functionParameter2.paramStr);
        if (argumentParameter.presence == -1) {
            this.updateMissingTokens(functionParameter2.tokens, functionParameter2.paramStr, argumentParameter.index, 101);
            this.updateMissingTokens(functionParameter.tokens, functionParameter2.paramStr, argumentParameter.index, 101);
            this.updateMissingTokens(functionParameter3.tokens, functionParameter2.paramStr, argumentParameter.index, 101);
            this.updateMissingTokens(functionParameter4.tokens, functionParameter2.paramStr, argumentParameter.index, 101);
        }
        Expression expression = new Expression(functionParameter.paramStr, functionParameter.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        Expression expression2 = new Expression(functionParameter3.paramStr, functionParameter3.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        Expression expression3 = new Expression(functionParameter4.paramStr, functionParameter4.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        double d = 1.0E-9;
        int n2 = 100;
        this.calcSetDecreaseRemove(n, Calculus.solveBrent(expression, argumentParameter.argument, expression2.calculate(), expression3.calculate(), d, n2));
        this.clearParamArgument(argumentParameter);
    }

    private void FORWARD_DIFFERENCE(int n) {
        List<FunctionParameter> list = this.getFunctionParameters(n, this.tokensList);
        FunctionParameter functionParameter = list.get(0);
        FunctionParameter functionParameter2 = list.get(1);
        ArgumentParameter argumentParameter = this.getParamArgument(functionParameter2.paramStr);
        Expression expression = new Expression(functionParameter.paramStr, functionParameter.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        if (this.verboseMode) {
            expression.setVerboseMode();
        }
        double d = 1.0;
        if (list.size() == 3) {
            FunctionParameter functionParameter3 = list.get(2);
            Expression expression2 = new Expression(functionParameter3.paramStr, functionParameter3.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            if (this.verboseMode) {
                expression2.setVerboseMode();
            }
            d = expression2.calculate();
        }
        this.calcSetDecreaseRemove(n, Calculus.forwardDifference(expression, d, argumentParameter.argument));
        this.clearParamArgument(argumentParameter);
    }

    private void BACKWARD_DIFFERENCE(int n) {
        List<FunctionParameter> list = this.getFunctionParameters(n, this.tokensList);
        FunctionParameter functionParameter = list.get(0);
        FunctionParameter functionParameter2 = list.get(1);
        ArgumentParameter argumentParameter = this.getParamArgument(functionParameter2.paramStr);
        Expression expression = new Expression(functionParameter.paramStr, functionParameter.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        if (this.verboseMode) {
            expression.setVerboseMode();
        }
        double d = 1.0;
        if (list.size() == 3) {
            FunctionParameter functionParameter3 = list.get(2);
            Expression expression2 = new Expression(functionParameter3.paramStr, functionParameter3.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            if (this.verboseMode) {
                expression2.setVerboseMode();
            }
            d = expression2.calculate();
        }
        this.calcSetDecreaseRemove(n, Calculus.backwardDifference(expression, d, argumentParameter.argument));
        this.clearParamArgument(argumentParameter);
    }

    private void MIN_VARIADIC(int n) {
        List<Double> list = this.getNumbers(n);
        this.variadicSetDecreaseRemove(n, NumberTheory.min(mXparser.arrayList2double(list)), list.size());
    }

    private void MAX_VARIADIC(int n) {
        List<Double> list = this.getNumbers(n);
        this.variadicSetDecreaseRemove(n, NumberTheory.max(mXparser.arrayList2double(list)), list.size());
    }

    private void SUM_VARIADIC(int n) {
        List<Double> list = this.getNumbers(n);
        this.variadicSetDecreaseRemove(n, NumberTheory.sum(mXparser.arrayList2double(list)), list.size(), true);
    }

    private void PROD_VARIADIC(int n) {
        List<Double> list = this.getNumbers(n);
        this.variadicSetDecreaseRemove(n, NumberTheory.prod(mXparser.arrayList2double(list)), list.size(), true);
    }

    private void AVG_VARIADIC(int n) {
        List<Double> list = this.getNumbers(n);
        this.variadicSetDecreaseRemove(n, Statistics.avg(mXparser.arrayList2double(list)), list.size(), true);
    }

    private void VAR_VARIADIC(int n) {
        List<Double> list = this.getNumbers(n);
        this.variadicSetDecreaseRemove(n, Statistics.var(mXparser.arrayList2double(list)), list.size(), true);
    }

    private void STD_VARIADIC(int n) {
        List<Double> list = this.getNumbers(n);
        this.variadicSetDecreaseRemove(n, Statistics.std(mXparser.arrayList2double(list)), list.size(), true);
    }

    private void CONTINUED_FRACTION(int n) {
        List<Double> list = this.getNumbers(n);
        this.variadicSetDecreaseRemove(n, MathFunctions.continuedFraction(mXparser.arrayList2double(list)), list.size());
    }

    private void CONTINUED_POLYNOMIAL(int n) {
        List<Double> list = this.getNumbers(n);
        this.variadicSetDecreaseRemove(n, MathFunctions.continuedPolynomial(mXparser.arrayList2double(list)), list.size());
    }

    private void GCD(int n) {
        List<Double> list = this.getNumbers(n);
        this.variadicSetDecreaseRemove(n, NumberTheory.gcd(mXparser.arrayList2double(list)), list.size());
    }

    private void LCM(int n) {
        List<Double> list = this.getNumbers(n);
        this.variadicSetDecreaseRemove(n, NumberTheory.lcm(mXparser.arrayList2double(list)), list.size());
    }

    private void RND_LIST(int n) {
        List<Double> list = this.getNumbers(n);
        int n2 = list.size();
        int n3 = ProbabilityDistributions.rndIndex(n2, ProbabilityDistributions.randomGenerator);
        this.variadicSetDecreaseRemove(n, list.get(n3), list.size());
    }

    private void COALESCE(int n) {
        List<Double> list = this.getNumbers(n);
        this.variadicSetDecreaseRemove(n, MathFunctions.coalesce(mXparser.arrayList2double(list)), list.size());
    }

    private void OR_VARIADIC(int n) {
        List<Double> list = this.getNumbers(n);
        this.variadicSetDecreaseRemove(n, BooleanAlgebra.orVariadic(mXparser.arrayList2double(list)), list.size());
    }

    private void AND_VARIADIC(int n) {
        List<Double> list = this.getNumbers(n);
        this.variadicSetDecreaseRemove(n, BooleanAlgebra.andVariadic(mXparser.arrayList2double(list)), list.size());
    }

    private void XOR_VARIADIC(int n) {
        List<Double> list = this.getNumbers(n);
        this.variadicSetDecreaseRemove(n, BooleanAlgebra.xorVariadic(mXparser.arrayList2double(list)), list.size());
    }

    private void ARGMIN_VARIADIC(int n) {
        List<Double> list = this.getNumbers(n);
        this.variadicSetDecreaseRemove(n, NumberTheory.argmin(mXparser.arrayList2double(list)), list.size());
    }

    private void ARGMAX_VARIADIC(int n) {
        List<Double> list = this.getNumbers(n);
        this.variadicSetDecreaseRemove(n, NumberTheory.argmax(mXparser.arrayList2double(list)), list.size());
    }

    private void MEDIAN_VARIADIC(int n) {
        List<Double> list = this.getNumbers(n);
        this.variadicSetDecreaseRemove(n, Statistics.median(mXparser.arrayList2double(list)), list.size());
    }

    private void MODE_VARIADIC(int n) {
        List<Double> list = this.getNumbers(n);
        this.variadicSetDecreaseRemove(n, Statistics.mode(mXparser.arrayList2double(list)), list.size());
    }

    private void BASE_VARIADIC(int n) {
        List<Double> list = this.getNumbers(n);
        this.variadicSetDecreaseRemove(n, NumberTheory.convOthBase2Decimal(mXparser.arrayList2double(list)), list.size());
    }

    private void NDIST_VARIADIC(int n) {
        List<Double> list = this.getNumbers(n);
        this.variadicSetDecreaseRemove(n, NumberTheory.numberOfDistValues(mXparser.arrayList2double(list)), list.size());
    }

    private void COMMA(int n) {
        this.tokensList.remove(n);
    }

    private void PARENTHESES(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            --this.tokensList.get((int)i).tokenLevel;
        }
        this.tokensList.remove(n2);
        this.tokensList.remove(n);
    }

    public boolean checkLexSyntax() {
        boolean bl = true;
        this.recursionCallsCounter = 0;
        if (this.expressionString.length() == 0) {
            bl = false;
            this.errorMessage = "Empty expression string\n";
            return bl;
        }
        SyntaxChecker syntaxChecker = new SyntaxChecker(new ByteArrayInputStream(this.expressionString.getBytes()));
        try {
            syntaxChecker.checkSyntax();
        }
        catch (Exception exception) {
            bl = false;
            this.errorMessage = "lexical error \n\n" + exception.getMessage() + "\n";
        }
        return bl;
    }

    public boolean checkSyntax() {
        boolean bl = this.checkSyntax("[" + this.expressionString + "] ", false);
        return bl;
    }

    private int checkCalculusParameter(String string) {
        int n = 0;
        for (KeyWord keyWord : this.keyWordsList) {
            if (keyWord.wordTypeId == 101 || !string.equals(keyWord.wordString)) continue;
            ++n;
        }
        return n;
    }

    private boolean checkIfKnownArgument(FunctionParameter functionParameter) {
        if (functionParameter.tokens.size() > 1) {
            return false;
        }
        Token token = functionParameter.tokens.get(0);
        return token.tokenTypeId == 101;
    }

    private boolean checkIfUnknownToken(FunctionParameter functionParameter) {
        if (functionParameter.tokens.size() > 1) {
            return false;
        }
        Token token = functionParameter.tokens.get(0);
        return token.tokenTypeId == -1;
    }

    private boolean checkSyntax(String string, boolean bl) {
        if (!this.expressionWasModified && this.syntaxStatus && this.optionsChangesetNumber == mXparser.optionsChangesetNumber) {
            this.errorMessage = string + "already checked - no errors!\n";
            this.recursionCallPending = false;
            return true;
        }
        this.optionsChangesetNumber = mXparser.optionsChangesetNumber;
        if (bl) {
            this.syntaxStatus = true;
            this.recursionCallPending = false;
            this.expressionWasModified = false;
            this.errorMessage = this.errorMessage + string + "function with extended body - assuming no errors.\n";
            return true;
        }
        this.recursionCallPending = true;
        this.errorMessage = string + "checking ...\n";
        boolean bl2 = true;
        if (this.expressionString.length() == 0) {
            bl2 = false;
            this.errorMessage = this.errorMessage + string + "Empty expression string\n";
            this.syntaxStatus = bl2;
            this.recursionCallPending = false;
            return bl2;
        }
        SyntaxChecker syntaxChecker = new SyntaxChecker(new ByteArrayInputStream(this.expressionString.getBytes()));
        try {
            int n;
            syntaxChecker.checkSyntax();
            this.tokenizeExpressionString();
            Collections.sort(this.keyWordsList, new KwStrComparator());
            for (n = 1; n < this.keyWordsList.size(); ++n) {
                String string2 = this.keyWordsList.get((int)(n - 1)).wordString;
                String string3 = this.keyWordsList.get((int)n).wordString;
                if (!string2.equals(string3)) continue;
                bl2 = false;
                this.errorMessage = this.errorMessage + string + "(" + string2 + ") Duplicated <KEYWORD>.\n";
            }
            n = this.initialTokens.size();
            Stack<SyntaxStackElement> stack = new Stack<SyntaxStackElement>();
            for (int i = 0; i < n; ++i) {
                int n2;
                boolean bl3;
                Argument argument;
                Token token = this.initialTokens.get(i);
                String string4 = "(" + token.tokenStr + ", " + i + ") ";
                if (token.tokenTypeId == 101) {
                    argument = this.getArgument(token.tokenId);
                    if (this.getParametersNumber(i) >= 0) {
                        bl2 = false;
                        this.errorMessage = this.errorMessage + string + string4 + "<ARGUMENT> was expected.\n";
                    } else if (argument.getArgumentBodyType() == 1) {
                        if (argument.getArgumentType() == 2 && argument.argumentExpression != this && !argument.argumentExpression.recursionCallPending) {
                            bl3 = argument.argumentExpression.checkSyntax(string + "-> [" + token.tokenStr + "] = [" + argument.argumentExpression.getExpressionString() + "] ", false);
                            bl2 = bl2 && bl3;
                            this.errorMessage = this.errorMessage + string + string4 + "checking dependent argument ...\n" + argument.argumentExpression.getErrorMessage();
                        }
                    } else {
                        this.errorMessage = this.errorMessage + string + string4 + "argument with extended body - assuming no errors.\n";
                    }
                }
                if (token.tokenTypeId == 102) {
                    argument = this.getArgument(token.tokenId);
                    if (this.getParametersNumber(i) != 1) {
                        bl2 = false;
                        this.errorMessage = this.errorMessage + string + string4 + "<RECURSIVE_ARGUMENT> expecting 1 parameter.\n";
                    } else if (argument.argumentExpression != this && !argument.argumentExpression.recursionCallPending) {
                        bl3 = argument.argumentExpression.checkSyntax(string + "-> [" + token.tokenStr + "] = [" + argument.argumentExpression.getExpressionString() + "] ", false);
                        bl2 = bl2 && bl3;
                        this.errorMessage = this.errorMessage + string + string4 + "checking recursive argument ...\n" + argument.argumentExpression.getErrorMessage();
                    }
                }
                if (token.tokenTypeId == -1) {
                    boolean bl4 = false;
                    for (SyntaxStackElement syntaxStackElement : stack) {
                        if (!syntaxStackElement.tokenStr.equals(token.tokenStr)) continue;
                        bl4 = true;
                    }
                    if (!bl4) {
                        bl2 = false;
                        this.errorMessage = this.errorMessage + string + string4 + "invalid <TOKEN>.\n";
                    }
                }
                if (token.tokenTypeId == 103) {
                    Function function = this.getFunction(token.tokenId);
                    function.checkRecursiveMode();
                    int n3 = this.getParametersNumber(i);
                    int n4 = function.getParametersNumber();
                    if (n3 == 0) {
                        bl2 = false;
                        this.errorMessage = this.errorMessage + string + string4 + "<USER_DEFINED_FUNCTION> expecting at least one argument.\n";
                    } else if (!function.isVariadic && n4 != n3) {
                        bl2 = false;
                        this.errorMessage = this.errorMessage + string + string4 + "<USER_DEFINED_FUNCTION> expecting " + n4 + " arguments.\n";
                    } else if (function.functionExpression != this && !function.functionExpression.recursionCallPending) {
                        n2 = function.getFunctionBodyType() == 1 ? function.functionExpression.checkSyntax(string + "-> [" + token.tokenStr + "] = [" + function.functionExpression.getExpressionString() + "] ", false) : function.functionExpression.checkSyntax(string + "-> [" + token.tokenStr + "] = [" + function.functionExpression.getExpressionString() + "] ", true);
                        bl2 = bl2 && n2 != 0;
                        this.errorMessage = function.isVariadic ? this.errorMessage + string + string4 + "checking variadic user defined function ...\n" + function.functionExpression.getErrorMessage() : this.errorMessage + string + string4 + "checking user defined function ...\n" + function.functionExpression.getErrorMessage();
                    }
                }
                if (token.tokenTypeId == 9 && this.getParametersNumber(i) >= 0) {
                    bl2 = false;
                    this.errorMessage = this.errorMessage + string + string4 + "<CONSTANT> was expected.\n";
                }
                if (token.tokenTypeId == 104 && this.getParametersNumber(i) >= 0) {
                    bl2 = false;
                    this.errorMessage = this.errorMessage + string + string4 + "<USER_DEFINED_CONSTANT> was expected.\n";
                }
                if (token.tokenTypeId == 4 && this.getParametersNumber(i) != 1) {
                    bl2 = false;
                    this.errorMessage = this.errorMessage + string + string4 + "<FUNCTION> expecting 1 argument.\n";
                }
                if (token.tokenTypeId == 5 && this.getParametersNumber(i) != 2) {
                    bl2 = false;
                    this.errorMessage = this.errorMessage + string + string4 + "<FUNCTION> expecting 2 arguments.\n";
                }
                if (token.tokenTypeId == 6 && this.getParametersNumber(i) != 3) {
                    bl2 = false;
                    this.errorMessage = this.errorMessage + string + string4 + "<FUNCTION> expecting 3 arguments.\n";
                }
                if (token.tokenTypeId == 8) {
                    SyntaxStackElement syntaxStackElement;
                    int n5 = this.getParametersNumber(i);
                    List<FunctionParameter> list = null;
                    if (n5 > 0) {
                        list = this.getFunctionParameters(i, this.initialTokens);
                    }
                    if (token.tokenId == 6 || token.tokenId == 7 || token.tokenId == 8) {
                        if (n5 < 2 || n5 > 5) {
                            bl2 = false;
                            this.errorMessage = this.errorMessage + string + string4 + "<DERIVATIVE> expecting 2 or 3 or 4 or 5 calculus parameters.\n";
                        } else if (n5 == 2 || n5 == 4) {
                            FunctionParameter functionParameter = list.get(1);
                            if (!this.checkIfKnownArgument(functionParameter)) {
                                bl2 = false;
                                this.errorMessage = this.errorMessage + string + string4 + "<DERIVATIVE> argument was expected.\n";
                            }
                        } else {
                            FunctionParameter functionParameter = list.get(1);
                            syntaxStackElement = new SyntaxStackElement(functionParameter.paramStr, token.tokenLevel + 1);
                            stack.push(syntaxStackElement);
                            n2 = this.checkCalculusParameter(syntaxStackElement.tokenStr);
                            if (n2 > 0) {
                                bl2 = false;
                                this.errorMessage = this.errorMessage + string + string4 + "<DERIVATIVE> Found duplicated key words for calculus parameter (" + syntaxStackElement.tokenStr + ", " + n2 + ").\n";
                            }
                            if (!this.checkIfKnownArgument(functionParameter) && !this.checkIfUnknownToken(functionParameter)) {
                                bl2 = false;
                                this.errorMessage = this.errorMessage + string + string4 + "<DERIVATIVE> One token (argument or unknown) was expected.\n";
                            }
                        }
                    }
                    if (token.tokenId == 9) {
                        if (n5 != 3 && n5 != 5) {
                            bl2 = false;
                            this.errorMessage = this.errorMessage + string + string4 + "<NTH_DERIVATIVE> expecting 3 or 5 calculus arguments.\n";
                        } else {
                            FunctionParameter functionParameter = list.get(2);
                            if (!this.checkIfKnownArgument(functionParameter)) {
                                bl2 = false;
                                this.errorMessage = this.errorMessage + string + string4 + "<DERIVATIVE> argument was expected.\n";
                            }
                        }
                    }
                    if (token.tokenId == 5 || token.tokenId == 17) {
                        if (n5 != 4) {
                            bl2 = false;
                            this.errorMessage = this.errorMessage + string + string4 + "<INTEGRAL/SOLVE> expecting 4 calculus arguments.\n";
                        } else {
                            FunctionParameter functionParameter = list.get(1);
                            syntaxStackElement = new SyntaxStackElement(functionParameter.paramStr, token.tokenLevel + 1);
                            stack.push(syntaxStackElement);
                            n2 = this.checkCalculusParameter(syntaxStackElement.tokenStr);
                            if (n2 > 0) {
                                bl2 = false;
                                this.errorMessage = this.errorMessage + string + string4 + "Found duplicated key words for calculus parameter (" + syntaxStackElement.tokenStr + ", " + n2 + ").\n";
                            }
                            if (!this.checkIfKnownArgument(functionParameter) && !this.checkIfUnknownToken(functionParameter)) {
                                bl2 = false;
                                this.errorMessage = this.errorMessage + string + string4 + "One token (argument or unknown) was expected.\n";
                            }
                        }
                    }
                    if (token.tokenId == 3 || token.tokenId == 1 || token.tokenId == 15 || token.tokenId == 16 || token.tokenId == 12 || token.tokenId == 13 || token.tokenId == 14) {
                        if (n5 != 4 && n5 != 5) {
                            bl2 = false;
                            this.errorMessage = this.errorMessage + string + string4 + "<ITER_OPERATOR> expecting 4 or 5 calculus arguments.\n";
                        } else {
                            FunctionParameter functionParameter = list.get(0);
                            syntaxStackElement = new SyntaxStackElement(functionParameter.paramStr, token.tokenLevel + 1);
                            stack.push(syntaxStackElement);
                            n2 = this.checkCalculusParameter(syntaxStackElement.tokenStr);
                            if (n2 > 0) {
                                bl2 = false;
                                this.errorMessage = this.errorMessage + string + string4 + "Found duplicated key words for calculus parameter (" + syntaxStackElement.tokenStr + ", " + n2 + ").\n";
                            }
                            if (!this.checkIfKnownArgument(functionParameter) && !this.checkIfUnknownToken(functionParameter)) {
                                bl2 = false;
                                this.errorMessage = this.errorMessage + string + string4 + "One token (argument or unknown) was expected.\n";
                            }
                        }
                    }
                    if (token.tokenId == 10 || token.tokenId == 11) {
                        if (n5 != 2 && n5 != 3) {
                            bl2 = false;
                            this.errorMessage = this.errorMessage + string + string4 + "<DIFF> expecting 2 or 3 arguments.\n";
                        } else {
                            FunctionParameter functionParameter = list.get(1);
                            if (!this.checkIfKnownArgument(functionParameter)) {
                                bl2 = false;
                                this.errorMessage = this.errorMessage + string + string4 + "<DIFF> argument was expected.\n";
                            }
                        }
                    }
                }
                if (token.tokenTypeId == 7) {
                    int n6 = this.getParametersNumber(i);
                    if (n6 < 1) {
                        bl2 = false;
                        this.errorMessage = this.errorMessage + string + string4 + "At least one argument was expected.\n";
                    }
                    if (token.tokenId == 1 && (n6 % 2 != 0 || n6 < 2)) {
                        bl2 = false;
                        this.errorMessage = this.errorMessage + string + string4 + "Expecting parity number of arguments.\n";
                    }
                }
                if (token.tokenTypeId != 20 || token.tokenId != 2 || stack.size() <= 0 || token.tokenLevel != ((SyntaxStackElement)stack.lastElement()).tokenLevel) continue;
                stack.pop();
            }
        }
        catch (Exception exception) {
            bl2 = false;
            this.errorMessage = this.errorMessage + string + "lexical error \n\n" + exception.getMessage() + "\n";
        }
        if (bl2) {
            this.errorMessage = this.errorMessage + string + "no errors.\n";
            this.expressionWasModified = false;
        } else {
            this.errorMessage = this.errorMessage + string + "errors were found.\n";
            this.expressionWasModified = true;
        }
        this.syntaxStatus = bl2;
        this.recursionCallPending = false;
        return bl2;
    }

    public double calculate() {
        double d;
        this.computingTime = 0.0;
        long l = System.currentTimeMillis();
        if (this.verboseMode) {
            this.printSystemInfo("\n", false);
            this.printSystemInfo("\n", true);
            this.printSystemInfo("Starting ...\n", true);
            this.showArguments();
        }
        if (this.expressionWasModified || !this.syntaxStatus) {
            this.syntaxStatus = this.checkSyntax();
        }
        if (!this.syntaxStatus) {
            this.errorMessage = this.errorMessage + "Problem with expression syntax\n";
            if (this.verboseMode) {
                this.printSystemInfo("syntaxStatus == SYNTAX_ERROR_OR_STATUS_UNKNOWN, returning Double.NaN\n", false);
            }
            this.recursionCallsCounter = 0;
            return Double.NaN;
        }
        if (this.recursionCallsCounter == 0 || this.internalClone) {
            this.copyInitialTokens();
        }
        if (this.tokensList.size() == 0) {
            this.errorMessage = this.errorMessage + "Empty expression\n";
            if (this.verboseMode) {
                this.printSystemInfo("tokensList.size() == 0, returning Double.NaN\n", false);
            }
            this.recursionCallsCounter = 0;
            return Double.NaN;
        }
        if (this.recursionCallsCounter >= mXparser.MAX_RECURSION_CALLS) {
            this.errorMessage = this.errorMessage + "recursionCallsCounter >= MAX_RECURSION_CALLS\n";
            if (this.verboseMode) {
                this.printSystemInfo("recursionCallsCounter >= mXparser.MAX_RECURSION_CALLS, returning Double.NaN\n", false);
                this.printSystemInfo("recursionCallsCounter = " + this.recursionCallsCounter + "\n", false);
                this.printSystemInfo("mXparser.MAX_RECURSION_CALLS = " + mXparser.MAX_RECURSION_CALLS + "\n", false);
            }
            this.recursionCallsCounter = 0;
            this.errorMessage = this.errorMessage + "\n[" + this.description + "][" + this.expressionString + "] Maximum recursion calls reached.\n";
            return Double.NaN;
        }
        ++this.recursionCallsCounter;
        ArrayList<Integer> arrayList = null;
        int n = 0;
        if (this.verboseMode) {
            this.printSystemInfo("Starting calculation loop\n", true);
        }
        do {
            int n2;
            Token token;
            if (mXparser.isCurrentCalculationCancelled()) {
                this.errorMessage = this.errorMessage + "\nCancel request - finishing";
                return Double.NaN;
            }
            int n3 = this.tokensList.size();
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            int n10 = -1;
            int n11 = -1;
            int n12 = -1;
            int n13 = -1;
            int n14 = -1;
            int n15 = -1;
            int n16 = -1;
            int n17 = -1;
            int n18 = -1;
            int n19 = -1;
            int n20 = -1;
            int n21 = -1;
            int n22 = -1;
            int n23 = -1;
            int n24 = -1;
            int n25 = -1;
            int n26 = 0;
            int n27 = -1;
            int n28 = -1;
            int n29 = -1;
            int n30 = -1;
            int n31 = -1;
            int n32 = -1;
            int n33 = -1;
            int n34 = -1;
            int n35 = -1;
            int n36 = -1;
            int n37 = -1;
            int n38 = -1;
            int n39 = -1;
            int n40 = -1;
            int n41 = -1;
            int n42 = -1;
            int n43 = -1;
            do {
                token = this.tokensList.get(++n43);
                if (token.tokenTypeId == 8) {
                    n7 = n43;
                    continue;
                }
                if (token.tokenTypeId == 6 && token.tokenId == 1) {
                    n8 = n43;
                    continue;
                }
                if (token.tokenTypeId != 7 || token.tokenId != 1) continue;
                n9 = n43;
            } while (n43 < n3 - 1 && n7 < 0 && n8 < 0 && n9 < 0);
            if (n7 < 0 && n8 < 0 && n9 < 0) {
                int n44;
                Argument argument;
                int n45;
                for (n45 = 0; n45 < n3; ++n45) {
                    token = this.tokensList.get(n45);
                    if (token.tokenLevel > n4) {
                        n4 = this.tokensList.get((int)n45).tokenLevel;
                        n5 = n45;
                    }
                    if (token.tokenTypeId == 101) {
                        argument = this.argumentsList.get(this.tokensList.get((int)n45).tokenId);
                        if (argument.argumentType == 1) {
                            this.FREE_ARGUMENT(n45);
                            continue;
                        }
                        n12 = n45;
                        continue;
                    }
                    if (token.tokenTypeId == 9) {
                        this.CONSTANT(n45);
                        continue;
                    }
                    if (token.tokenTypeId == 12) {
                        this.UNIT(n45);
                        continue;
                    }
                    if (token.tokenTypeId == 104) {
                        this.USER_CONSTANT(n45);
                        continue;
                    }
                    if (token.tokenTypeId != 10) continue;
                    this.RANDOM_VARIABLE(n45);
                }
                if (n5 < 0) {
                    this.errorMessage = this.errorMessage + "\nInternal error / strange token level - finishing";
                    return Double.NaN;
                }
                if (n12 >= 0) {
                    block3: do {
                        n2 = 0;
                        n44 = this.tokensList.size();
                        for (n45 = 0; n45 < n44; ++n45) {
                            token = this.tokensList.get(n45);
                            if (token.tokenTypeId != 101) continue;
                            argument = this.argumentsList.get(this.tokensList.get((int)n45).tokenId);
                            if (argument.argumentType != 2) continue;
                            this.DEPENDENT_ARGUMENT(n45);
                            n2 = 1;
                            continue block3;
                        }
                    } while (n2 != 0);
                } else {
                    for (n45 = n5; n45 < n3 && n4 == this.tokensList.get((int)n45).tokenLevel; ++n45) {
                    }
                    n6 = n45 - 1;
                    if (this.verboseMode) {
                        this.printSystemInfo("Parsing (" + n5 + ", " + n6 + ") ", true);
                        this.showParsing(n5, n6);
                    }
                    for (int i = n5; i <= n6; ++i) {
                        n2 = 0;
                        n44 = 0;
                        token = this.tokensList.get(i);
                        if (i - 1 >= 0) {
                            Token token2 = this.tokensList.get(i - 1);
                            if (token2.tokenTypeId == 0) {
                                n2 = 1;
                            }
                        }
                        if (i + 1 < n3) {
                            Token token3 = this.tokensList.get(i + 1);
                            if (token3.tokenTypeId == 0) {
                                n44 = 1;
                            }
                        }
                        if (token.tokenTypeId == 102 && n11 < 0) {
                            n11 = i;
                            continue;
                        }
                        if (token.tokenTypeId == 7 && n10 < 0) {
                            n10 = i;
                            continue;
                        }
                        if (token.tokenTypeId == 6 && n13 < 0) {
                            n13 = i;
                            continue;
                        }
                        if (token.tokenTypeId == 5 && n14 < 0) {
                            n14 = i;
                            continue;
                        }
                        if (token.tokenTypeId == 4 && n15 < 0) {
                            n15 = i;
                            continue;
                        }
                        if (token.tokenTypeId == 103 && n16 < 0) {
                            n16 = i;
                            continue;
                        }
                        if (token.tokenTypeId == 1) {
                            if (token.tokenId == 5 && n2 != 0 && n44 != 0) {
                                n21 = i;
                                ++n26;
                                continue;
                            }
                            if (token.tokenId == 9 && n2 != 0 && n44 != 0) {
                                n22 = i;
                                continue;
                            }
                            if (token.tokenId == 6 && n23 < 0 && n2 != 0) {
                                n23 = i;
                                continue;
                            }
                            if (token.tokenId == 8 && n25 < 0 && n2 != 0) {
                                n25 = i;
                                continue;
                            }
                            if (token.tokenId == 7 && n24 < 0 && n2 != 0 && n44 != 0) {
                                n24 = i;
                                continue;
                            }
                            if (token.tokenId == 1 && n17 < 0 && n44 != 0) {
                                n17 = i;
                                continue;
                            }
                            if (token.tokenId == 2 && n18 < 0 && n44 != 0) {
                                n18 = i;
                                continue;
                            }
                            if (token.tokenId == 3 && n19 < 0 && n2 != 0 && n44 != 0) {
                                n19 = i;
                                continue;
                            }
                            if (token.tokenId != 4 || n20 >= 0 || n2 == 0 || n44 == 0) continue;
                            n20 = i;
                            continue;
                        }
                        if (token.tokenTypeId == 2) {
                            if (token.tokenId == 11 && n27 < 0 && n44 != 0) {
                                n27 = i;
                                continue;
                            }
                            if (n2 == 0 || n44 == 0) continue;
                            if ((token.tokenId == 1 || token.tokenId == 2) && n28 < 0) {
                                n28 = i;
                                continue;
                            }
                            if ((token.tokenId == 3 || token.tokenId == 4 || token.tokenId == 5) && n29 < 0) {
                                n29 = i;
                                continue;
                            }
                            if ((token.tokenId == 6 || token.tokenId == 7 || token.tokenId == 8 || token.tokenId == 9 || token.tokenId == 10) && n30 < 0) {
                                n30 = i;
                                continue;
                            }
                            if (n31 >= 0) continue;
                            n31 = i;
                            continue;
                        }
                        if (token.tokenTypeId == 3) {
                            if (token.tokenId == 1 && n32 < 0 && n2 != 0 && n44 != 0) {
                                n32 = i;
                                continue;
                            }
                            if (token.tokenId == 2 && n33 < 0 && n2 != 0 && n44 != 0) {
                                n33 = i;
                                continue;
                            }
                            if (token.tokenId == 3 && n34 < 0 && n2 != 0 && n44 != 0) {
                                n34 = i;
                                continue;
                            }
                            if (token.tokenId == 4 && n35 < 0 && n2 != 0 && n44 != 0) {
                                n35 = i;
                                continue;
                            }
                            if (token.tokenId == 5 && n36 < 0 && n2 != 0 && n44 != 0) {
                                n36 = i;
                                continue;
                            }
                            if (token.tokenId != 6 || n37 >= 0 || n2 == 0 || n44 == 0) continue;
                            n37 = i;
                            continue;
                        }
                        if (token.tokenTypeId == 11) {
                            if (token.tokenId == 1 && n42 < 0 && n44 != 0) {
                                n42 = i;
                                continue;
                            }
                            if (n41 >= 0 || n2 == 0 || n44 == 0) continue;
                            n41 = i;
                            continue;
                        }
                        if (token.tokenTypeId != 20) continue;
                        if (token.tokenId == 3) {
                            if (n38 < 0) {
                                arrayList = new ArrayList<Integer>();
                            }
                            arrayList.add(i);
                            n38 = i;
                            continue;
                        }
                        if (token.tokenId == 1 && n39 < 0) {
                            n39 = i;
                            continue;
                        }
                        if (token.tokenId != 2 || n40 >= 0) continue;
                        n40 = i;
                    }
                    if (n26 > 1) {
                        n21 = -1;
                        n43 = n6 + 1;
                        do {
                            token = this.tokensList.get(--n43);
                            if (token.tokenTypeId != 1 || token.tokenId != 5) continue;
                            n21 = n43;
                        } while (n43 > n5 && n21 == -1);
                    }
                }
            }
            if (n7 >= 0) {
                this.calculusCalc(n7);
            } else if (n8 >= 0) {
                this.IF_CONDITION(n8);
            } else if (n9 >= 0) {
                this.IFF(n9);
            } else if (n11 >= 0) {
                this.RECURSIVE_ARGUMENT(n11);
            } else if (n10 >= 0) {
                this.variadicFunCalc(n10);
            } else if (n13 >= 0) {
                this.f3ArgCalc(n13);
            } else if (n14 >= 0) {
                this.f2ArgCalc(n14);
            } else if (n15 >= 0) {
                this.f1ArgCalc(n15);
            } else if (n16 >= 0) {
                this.USER_FUNCTION(n16);
            } else if (n22 >= 0) {
                this.TETRATION(n22);
            } else if (n21 >= 0) {
                this.POWER(n21);
            } else if (n23 >= 0) {
                this.FACT(n23);
            } else if (n25 >= 0) {
                this.PERC(n25);
            } else if (n24 >= 0) {
                this.MODULO(n24);
            } else if (n27 >= 0) {
                this.NEG(n27);
            } else if (n42 >= 0) {
                this.BITWISE_COMPL(n42);
            } else if (n19 >= 0 || n20 >= 0) {
                if (n19 >= 0 && n20 >= 0) {
                    if (n19 <= n20) {
                        this.MULTIPLY(n19);
                    } else {
                        this.DIVIDE(n20);
                    }
                } else if (n19 >= 0) {
                    this.MULTIPLY(n19);
                } else {
                    this.DIVIDE(n20);
                }
            } else if (n18 >= 0 || n17 >= 0) {
                if (n18 >= 0 && n17 >= 0) {
                    if (n18 <= n17) {
                        this.MINUS(n18);
                    } else {
                        this.PLUS(n17);
                    }
                } else if (n18 >= 0) {
                    this.MINUS(n18);
                } else {
                    this.PLUS(n17);
                }
            } else if (n33 >= 0) {
                this.NEQ(n33);
            } else if (n32 >= 0) {
                this.EQ(n32);
            } else if (n34 >= 0) {
                this.LT(n34);
            } else if (n35 >= 0) {
                this.GT(n35);
            } else if (n36 >= 0) {
                this.LEQ(n36);
            } else if (n37 >= 0) {
                this.GEQ(n37);
            } else if (n38 >= 0) {
                for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
                    this.COMMA((Integer)arrayList.get(n2));
                }
            } else if (n28 >= 0) {
                this.bolCalc(n28);
            } else if (n29 >= 0) {
                this.bolCalc(n29);
            } else if (n30 >= 0) {
                this.bolCalc(n30);
            } else if (n31 >= 0) {
                this.bolCalc(n31);
            } else if (n41 >= 0) {
                this.bitwiseCalc(n41);
            } else if (n39 >= 0 && n40 > n39) {
                this.PARENTHESES(n39, n40);
            } else if (this.tokensList.size() > 1) {
                this.errorMessage = this.errorMessage + "\n[" + this.description + "][" + this.expressionString + "] Fatal error - not know what to do with tokens while calculate().\n";
            }
            if (this.verboseMode) {
                this.showParsing(0, this.tokensList.size() - 1);
                this.printSystemInfo(" done\n", false);
            }
            n = this.tokensList.size() == n3 ? ++n : 0;
            if (n <= 10) continue;
            this.errorMessage = this.errorMessage + "\nInternal error, do not know what to do with the token, probably mXparser bug, please report - finishing";
            return Double.NaN;
        } while (this.tokensList.size() > 1);
        if (this.verboseMode) {
            this.printSystemInfo("Calculated value: " + this.tokensList.get((int)0).tokenValue + "\n", true);
            this.printSystemInfo("Exiting\n", true);
            this.printSystemInfo("\n", false);
        }
        long l2 = System.currentTimeMillis();
        this.computingTime = (double)(l2 - l) / 1000.0;
        this.recursionCallsCounter = 0;
        double d2 = this.tokensList.get((int)0).tokenValue;
        if (mXparser.almostIntRounding && Math.abs(d2 - (d = (double)Math.round(d2))) <= BinaryRelations.getEpsilon()) {
            d2 = d;
        }
        return d2;
    }

    private void f1ArgCalc(int n) {
        switch (this.tokensList.get((int)n).tokenId) {
            case 1: {
                this.SIN(n);
                break;
            }
            case 2: {
                this.COS(n);
                break;
            }
            case 3: {
                this.TAN(n);
                break;
            }
            case 4: {
                this.CTAN(n);
                break;
            }
            case 5: {
                this.SEC(n);
                break;
            }
            case 6: {
                this.COSEC(n);
                break;
            }
            case 7: {
                this.ASIN(n);
                break;
            }
            case 8: {
                this.ACOS(n);
                break;
            }
            case 9: {
                this.ATAN(n);
                break;
            }
            case 10: {
                this.ACTAN(n);
                break;
            }
            case 11: {
                this.LN(n);
                break;
            }
            case 12: {
                this.LOG2(n);
                break;
            }
            case 13: {
                this.LOG10(n);
                break;
            }
            case 14: {
                this.RAD(n);
                break;
            }
            case 15: {
                this.EXP(n);
                break;
            }
            case 16: {
                this.SQRT(n);
                break;
            }
            case 17: {
                this.SINH(n);
                break;
            }
            case 18: {
                this.COSH(n);
                break;
            }
            case 19: {
                this.TANH(n);
                break;
            }
            case 20: {
                this.COTH(n);
                break;
            }
            case 21: {
                this.SECH(n);
                break;
            }
            case 22: {
                this.CSCH(n);
                break;
            }
            case 23: {
                this.DEG(n);
                break;
            }
            case 24: {
                this.ABS(n);
                break;
            }
            case 25: {
                this.SGN(n);
                break;
            }
            case 26: {
                this.FLOOR(n);
                break;
            }
            case 27: {
                this.CEIL(n);
                break;
            }
            case 29: {
                this.NOT(n);
                break;
            }
            case 30: {
                this.ARSINH(n);
                break;
            }
            case 31: {
                this.ARCOSH(n);
                break;
            }
            case 32: {
                this.ARTANH(n);
                break;
            }
            case 33: {
                this.ARCOTH(n);
                break;
            }
            case 34: {
                this.ARSECH(n);
                break;
            }
            case 35: {
                this.ARCSCH(n);
                break;
            }
            case 36: {
                this.SA(n);
                break;
            }
            case 37: {
                this.SINC(n);
                break;
            }
            case 38: {
                this.BELL_NUMBER(n);
                break;
            }
            case 39: {
                this.LUCAS_NUMBER(n);
                break;
            }
            case 40: {
                this.FIBONACCI_NUMBER(n);
                break;
            }
            case 41: {
                this.HARMONIC_NUMBER(n);
                break;
            }
            case 42: {
                this.IS_PRIME(n);
                break;
            }
            case 43: {
                this.PRIME_COUNT(n);
                break;
            }
            case 44: {
                this.EXP_INT(n);
                break;
            }
            case 45: {
                this.LOG_INT(n);
                break;
            }
            case 46: {
                this.OFF_LOG_INT(n);
                break;
            }
            case 47: {
                this.GAUSS_ERF(n);
                break;
            }
            case 48: {
                this.GAUSS_ERFC(n);
                break;
            }
            case 49: {
                this.GAUSS_ERF_INV(n);
                break;
            }
            case 50: {
                this.GAUSS_ERFC_INV(n);
                break;
            }
            case 51: {
                this.ULP(n);
                break;
            }
            case 52: {
                this.ISNAN(n);
                break;
            }
            case 53: {
                this.NDIG10(n);
                break;
            }
            case 54: {
                this.NFACT(n);
                break;
            }
            case 55: {
                this.ARCSEC(n);
                break;
            }
            case 56: {
                this.ARCCSC(n);
                break;
            }
            case 57: {
                this.GAMMA(n);
                break;
            }
            case 58: {
                this.LAMBERT_W0(n);
                break;
            }
            case 59: {
                this.LAMBERT_W1(n);
                break;
            }
            case 60: {
                this.SGN_GAMMA(n);
                break;
            }
            case 61: {
                this.LOG_GAMMA(n);
                break;
            }
            case 62: {
                this.DI_GAMMA(n);
                break;
            }
            case 63: {
                this.UDF_PARAM(n);
            }
        }
    }

    private void f2ArgCalc(int n) {
        switch (this.tokensList.get((int)n).tokenId) {
            case 1: {
                this.LOG(n);
                break;
            }
            case 2: {
                this.MOD(n);
                break;
            }
            case 3: {
                this.BINOM_COEFF(n);
                break;
            }
            case 4: {
                this.BERNOULLI_NUMBER(n);
                break;
            }
            case 5: {
                this.STIRLING1_NUMBER(n);
                break;
            }
            case 6: {
                this.STIRLING2_NUMBER(n);
                break;
            }
            case 7: {
                this.WORPITZKY_NUMBER(n);
                break;
            }
            case 8: {
                this.EULER_NUMBER(n);
                break;
            }
            case 9: {
                this.KRONECKER_DELTA(n);
                break;
            }
            case 10: {
                this.EULER_POLYNOMIAL(n);
                break;
            }
            case 11: {
                this.HARMONIC2_NUMBER(n);
                break;
            }
            case 12: {
                this.RND_VAR_UNIFORM_CONT(n);
                break;
            }
            case 13: {
                this.RND_VAR_UNIFORM_DISCR(n);
                break;
            }
            case 14: {
                this.ROUND(n);
                break;
            }
            case 15: {
                this.RND_NORMAL(n);
                break;
            }
            case 16: {
                this.NDIG(n);
                break;
            }
            case 17: {
                this.DIGIT10(n);
                break;
            }
            case 18: {
                this.FACTVAL(n);
                break;
            }
            case 19: {
                this.FACTEXP(n);
                break;
            }
            case 20: {
                this.ROOT(n);
                break;
            }
            case 21: {
                this.INC_GAMMA_LOWER(n);
                break;
            }
            case 22: {
                this.INC_GAMMA_UPPER(n);
                break;
            }
            case 23: {
                this.REG_GAMMA_LOWER(n);
                break;
            }
            case 24: {
                this.REG_GAMMA_UPPER(n);
                break;
            }
            case 25: {
                this.PERMUTATIONS(n);
                break;
            }
            case 26: {
                this.BETA(n);
                break;
            }
            case 27: {
                this.LOG_BETA(n);
            }
        }
    }

    private void f3ArgCalc(int n) {
        switch (this.tokensList.get((int)n).tokenId) {
            case 2: {
                this.IF(n);
                break;
            }
            case 3: {
                this.CHI(n);
                break;
            }
            case 4: {
                this.CHI_LR(n);
                break;
            }
            case 5: {
                this.CHI_L(n);
                break;
            }
            case 6: {
                this.CHI_R(n);
                break;
            }
            case 7: {
                this.PDF_UNIFORM_CONT(n);
                break;
            }
            case 8: {
                this.CDF_UNIFORM_CONT(n);
                break;
            }
            case 9: {
                this.QNT_UNIFORM_CONT(n);
                break;
            }
            case 10: {
                this.PDF_NORMAL(n);
                break;
            }
            case 11: {
                this.CDF_NORMAL(n);
                break;
            }
            case 12: {
                this.QNT_NORMAL(n);
                break;
            }
            case 13: {
                this.DIGIT(n);
                break;
            }
            case 14: {
                this.INC_BETA(n);
                break;
            }
            case 15: {
                this.REG_BETA(n);
            }
        }
    }

    private void variadicFunCalc(int n) {
        switch (this.tokensList.get((int)n).tokenId) {
            case 1: {
                this.IFF(n);
                break;
            }
            case 2: {
                this.MIN_VARIADIC(n);
                break;
            }
            case 3: {
                this.MAX_VARIADIC(n);
                break;
            }
            case 8: {
                this.SUM_VARIADIC(n);
                break;
            }
            case 9: {
                this.PROD_VARIADIC(n);
                break;
            }
            case 10: {
                this.AVG_VARIADIC(n);
                break;
            }
            case 11: {
                this.VAR_VARIADIC(n);
                break;
            }
            case 12: {
                this.STD_VARIADIC(n);
                break;
            }
            case 4: {
                this.CONTINUED_FRACTION(n);
                break;
            }
            case 5: {
                this.CONTINUED_POLYNOMIAL(n);
                break;
            }
            case 6: {
                this.GCD(n);
                break;
            }
            case 7: {
                this.LCM(n);
                break;
            }
            case 13: {
                this.RND_LIST(n);
                break;
            }
            case 14: {
                this.COALESCE(n);
                break;
            }
            case 15: {
                this.OR_VARIADIC(n);
                break;
            }
            case 16: {
                this.AND_VARIADIC(n);
                break;
            }
            case 17: {
                this.XOR_VARIADIC(n);
                break;
            }
            case 18: {
                this.ARGMIN_VARIADIC(n);
                break;
            }
            case 19: {
                this.ARGMAX_VARIADIC(n);
                break;
            }
            case 20: {
                this.MEDIAN_VARIADIC(n);
                break;
            }
            case 21: {
                this.MODE_VARIADIC(n);
                break;
            }
            case 22: {
                this.BASE_VARIADIC(n);
                break;
            }
            case 23: {
                this.NDIST_VARIADIC(n);
            }
        }
    }

    private void calculusCalc(int n) {
        switch (this.tokensList.get((int)n).tokenId) {
            case 1: {
                this.SUM(n);
                break;
            }
            case 3: {
                this.PROD(n);
                break;
            }
            case 15: {
                this.MIN(n);
                break;
            }
            case 16: {
                this.MAX(n);
                break;
            }
            case 12: {
                this.AVG(n);
                break;
            }
            case 13: {
                this.VAR(n);
                break;
            }
            case 14: {
                this.STD(n);
                break;
            }
            case 5: {
                this.INTEGRAL(n);
                break;
            }
            case 17: {
                this.SOLVE(n);
                break;
            }
            case 6: {
                this.DERIVATIVE(n, 3);
                break;
            }
            case 7: {
                this.DERIVATIVE(n, 1);
                break;
            }
            case 8: {
                this.DERIVATIVE(n, 2);
                break;
            }
            case 9: {
                this.DERIVATIVE_NTH(n, 3);
                break;
            }
            case 10: {
                this.FORWARD_DIFFERENCE(n);
                break;
            }
            case 11: {
                this.BACKWARD_DIFFERENCE(n);
            }
        }
    }

    private void bolCalc(int n) {
        switch (this.tokensList.get((int)n).tokenId) {
            case 1: {
                this.AND(n);
                break;
            }
            case 7: {
                this.CIMP(n);
                break;
            }
            case 9: {
                this.CNIMP(n);
                break;
            }
            case 10: {
                this.EQV(n);
                break;
            }
            case 6: {
                this.IMP(n);
                break;
            }
            case 2: {
                this.NAND(n);
                break;
            }
            case 8: {
                this.NIMP(n);
                break;
            }
            case 4: {
                this.NOR(n);
                break;
            }
            case 3: {
                this.OR(n);
                break;
            }
            case 5: {
                this.XOR(n);
            }
        }
    }

    private void bitwiseCalc(int n) {
        switch (this.tokensList.get((int)n).tokenId) {
            case 2: {
                this.BITWISE_AND(n);
                break;
            }
            case 4: {
                this.BITWISE_OR(n);
                break;
            }
            case 3: {
                this.BITWISE_XOR(n);
                break;
            }
            case 5: {
                this.BITWISE_LEFT_SHIFT(n);
                break;
            }
            case 6: {
                this.BITWISE_RIGHT_SHIFT(n);
            }
        }
    }

    private void addUDFSpecificParserKeyWords() {
        this.addKeyWord("par", "Automatically generated function for user defined functions, returns function parameter value at index 'i'", 63, "par(i)", "4.2", 4);
        this.addKeyWord("[npar]", "Automatically generated constant for user defined functions, returns number of given function parameters", 303, "[npar]", "4.2", 9);
    }

    private void addParserKeyWords() {
        this.addKeyWord("+", "Addition", 1, "a + b", "1.0", 1);
        this.addKeyWord("-", "Subtraction", 2, "a - b", "1.0", 1);
        this.addKeyWord("*", "Nultiplication", 3, "a * b", "1.0", 1);
        this.addKeyWord("/", "Division", 4, "a / b", "1.0", 1);
        this.addKeyWord("^", "Exponentiation", 5, "a^b", "1.0", 1);
        this.addKeyWord("!", "Factorial", 6, "n!", "1.0", 1);
        this.addKeyWord("#", "Modulo function", 7, "a # b", "1.0", 1);
        this.addKeyWord("%", "Percentage", 8, "n%", "4.1", 1);
        this.addKeyWord("^^", "Tetration (hyper-4, power tower, exponential tower)", 9, "a^^n", "4.2", 1);
        this.addKeyWord("~", "Negation", 11, "~p", "1.0", 2);
        this.addKeyWord("&", "Logical conjunction (AND)", 1, "p & q", "1.0", 2);
        this.addKeyWord("&&", "Logical conjunction (AND)", 1, "p && q", "1.0", 2);
        this.addKeyWord("/\\", "Logical conjunction (AND)", 1, "p /\\ q", "1.0", 2);
        this.addKeyWord("~&", "NAND - Sheffer stroke", 2, "p ~& q", "1.0", 2);
        this.addKeyWord("~&&", "NAND - Sheffer stroke", 2, "p ~&& q", "1.0", 2);
        this.addKeyWord("~/\\", "NAND - Sheffer stroke", 2, "p ~/\\ q", "1.0", 2);
        this.addKeyWord("|", "Logical disjunction (OR)", 3, "p | q", "1.0", 2);
        this.addKeyWord("||", "Logical disjunction (OR)", 3, "p || q", "1.0", 2);
        this.addKeyWord("\\/", "Logical disjunction (OR)", 3, "p \\/ q", "1.0", 2);
        this.addKeyWord("~|", "Logical NOR", 4, "p ~| q", "1.0", 2);
        this.addKeyWord("~||", "Logical NOR", 4, "p ~|| q", "1.0", 2);
        this.addKeyWord("~\\/", "Logical NOR", 4, "p ~\\/ q", "1.0", 2);
        this.addKeyWord("(+)", "Exclusive or (XOR)", 5, "p (+) q", "1.0", 2);
        this.addKeyWord("-->", "Implication (IMP)", 6, "p --> q", "1.0", 2);
        this.addKeyWord("-/>", "Material nonimplication (NIMP)", 8, "p  -/> q", "1.0", 2);
        this.addKeyWord("<--", "Converse implication (CIMP)", 7, "p <-- q", "1.0", 2);
        this.addKeyWord("</-", "Converse nonimplication (CNIMP)", 9, "p </- q", "1.0", 2);
        this.addKeyWord("<->", "Logical biconditional (EQV)", 10, "p <-> q", "1.0", 2);
        this.addKeyWord("=", "Equality", 1, "a = b", "1.0", 3);
        this.addKeyWord("==", "Equality", 1, "a == b", "1.0", 3);
        this.addKeyWord("<>", "Inequation", 2, "a <> b", "1.0", 3);
        this.addKeyWord("~=", "Inequation", 2, "a ~= b", "1.0", 3);
        this.addKeyWord("!=", "Inequation", 2, "a != b", "1.0", 3);
        this.addKeyWord("<", "Lower than", 3, "a < b", "1.0", 3);
        this.addKeyWord(">", "Greater than", 4, "a > b", "1.0", 3);
        this.addKeyWord("<=", "Lower or equal", 5, "a <= b", "1.0", 3);
        this.addKeyWord(">=", "Greater or equal", 6, "a >= b", "1.0", 3);
        if (!this.parserKeyWordsOnly) {
            this.addKeyWord("sin", "Trigonometric sine function", 1, "sin(x)", "1.0", 4);
            this.addKeyWord("cos", "Trigonometric cosine function", 2, "cos(x)", "1.0", 4);
            this.addKeyWord("tan", "Trigonometric tangent function", 3, "tan(x)", "1.0", 4);
            this.addKeyWord("tg", "Trigonometric tangent function", 3, "tg(x)", "1.0", 4);
            this.addKeyWord("ctan", "Trigonometric cotangent function", 4, "ctan(x)", "1.0", 4);
            this.addKeyWord("ctg", "Trigonometric cotangent function", 4, "ctg(x)", "1.0", 4);
            this.addKeyWord("cot", "Trigonometric cotangent function", 4, "cot(x)", "1.0", 4);
            this.addKeyWord("sec", "Trigonometric secant function", 5, "sec(x)", "1.0", 4);
            this.addKeyWord("cosec", "Trigonometric cosecant function", 6, "cosec(x)", "1.0", 4);
            this.addKeyWord("csc", "Trigonometric cosecant function", 6, "csc(x)", "1.0", 4);
            this.addKeyWord("asin", "Inverse trigonometric sine function", 7, "asin(x)", "1.0", 4);
            this.addKeyWord("arsin", "Inverse trigonometric sine function", 7, "arsin(x)", "1.0", 4);
            this.addKeyWord("arcsin", "Inverse trigonometric sine function", 7, "arcsin(x)", "1.0", 4);
            this.addKeyWord("acos", "Inverse trigonometric cosine function", 8, "acos(x)", "1.0", 4);
            this.addKeyWord("arcos", "Inverse trigonometric cosine function", 8, "arcos(x)", "1.0", 4);
            this.addKeyWord("arccos", "Inverse trigonometric cosine function", 8, "arccos(x)", "1.0", 4);
            this.addKeyWord("atan", "Inverse trigonometric tangent function", 9, "atan(x)", "1.0", 4);
            this.addKeyWord("arctan", "Inverse trigonometric tangent function", 9, "arctan(x)", "1.0", 4);
            this.addKeyWord("atg", "Inverse trigonometric tangent function", 9, "atg(x)", "1.0", 4);
            this.addKeyWord("arctg", "Inverse trigonometric tangent function", 9, "arctg(x)", "1.0", 4);
            this.addKeyWord("actan", "Inverse trigonometric cotangent function", 10, "actan(x)", "1.0", 4);
            this.addKeyWord("arcctan", "Inverse trigonometric cotangent function", 10, "arcctan(x)", "1.0", 4);
            this.addKeyWord("actg", "Inverse trigonometric cotangent function", 10, "actg(x)", "1.0", 4);
            this.addKeyWord("arcctg", "Inverse trigonometric cotangent function", 10, "arcctg(x)", "1.0", 4);
            this.addKeyWord("acot", "Inverse trigonometric cotangent function", 10, "acot(x)", "1.0", 4);
            this.addKeyWord("arccot", "Inverse trigonometric cotangent function", 10, "arccot(x)", "1.0", 4);
            this.addKeyWord("ln", "Natural logarithm function (base e)", 11, "ln(x)", "1.0", 4);
            this.addKeyWord("log2", "Binary logarithm function (base 2)", 12, "log2(x)", "1.0", 4);
            this.addKeyWord("log10", "Common logarithm function (base 10)", 13, "log10(x)", "1.0", 4);
            this.addKeyWord("rad", "Degrees to radians function", 14, "rad(x)", "1.0", 4);
            this.addKeyWord("exp", "Exponential function", 15, "exp(x)", "1.0", 4);
            this.addKeyWord("sqrt", "Squre root function", 16, "sqrt(x)", "1.0", 4);
            this.addKeyWord("sinh", "Hyperbolic sine function", 17, "sinh(x)", "1.0", 4);
            this.addKeyWord("cosh", "Hyperbolic cosine function", 18, "cosh(x)", "1.0", 4);
            this.addKeyWord("tanh", "Hyperbolic tangent function", 19, "tanh(x)", "1.0", 4);
            this.addKeyWord("tgh", "Hyperbolic tangent function", 19, "tgh(x)", "1.0", 4);
            this.addKeyWord("ctanh", "Hyperbolic cotangent function", 20, "ctanh(x)", "1.0", 4);
            this.addKeyWord("coth", "Hyperbolic cotangent function", 20, "coth(x)", "1.0", 4);
            this.addKeyWord("ctgh", "Hyperbolic cotangent function", 20, "ctgh(x)", "1.0", 4);
            this.addKeyWord("sech", "Hyperbolic secant function", 21, "sech(x)", "1.0", 4);
            this.addKeyWord("csch", "Hyperbolic cosecant function", 22, "csch(x)", "1.0", 4);
            this.addKeyWord("cosech", "Hyperbolic cosecant function", 22, "cosech(x)", "1.0", 4);
            this.addKeyWord("deg", "Radians to degrees function", 23, "deg(x)", "1.0", 4);
            this.addKeyWord("abs", "Absolut value function", 24, "abs(x)", "1.0", 4);
            this.addKeyWord("sgn", "Signum function", 25, "sgn(x)", "1.0", 4);
            this.addKeyWord("floor", "Floor function", 26, "floor(x)", "1.0", 4);
            this.addKeyWord("ceil", "Ceiling function", 27, "ceil(x)", "1.0", 4);
            this.addKeyWord("not", "Negation function", 29, "not(x)", "1.0", 4);
            this.addKeyWord("asinh", "Inverse hyperbolic sine function", 30, "asinh(x)", "1.0", 4);
            this.addKeyWord("arsinh", "Inverse hyperbolic sine function", 30, "arsinh(x)", "1.0", 4);
            this.addKeyWord("arcsinh", "Inverse hyperbolic sine function", 30, "arcsinh(x)", "1.0", 4);
            this.addKeyWord("acosh", "Inverse hyperbolic cosine function", 31, "acosh(x)", "1.0", 4);
            this.addKeyWord("arcosh", "Inverse hyperbolic cosine function", 31, "arcosh(x)", "1.0", 4);
            this.addKeyWord("arccosh", "Inverse hyperbolic cosine function", 31, "arccosh(x)", "1.0", 4);
            this.addKeyWord("atanh", "Inverse hyperbolic tangent function", 32, "atanh(x)", "1.0", 4);
            this.addKeyWord("arctanh", "Inverse hyperbolic tangent function", 32, "arctanh(x)", "1.0", 4);
            this.addKeyWord("atgh", "Inverse hyperbolic tangent function", 32, "atgh(x)", "1.0", 4);
            this.addKeyWord("arctgh", "Inverse hyperbolic tangent function", 32, "arctgh(x)", "1.0", 4);
            this.addKeyWord("actanh", "Inverse hyperbolic cotangent function", 33, "actanh(x)", "1.0", 4);
            this.addKeyWord("arcctanh", "Inverse hyperbolic cotangent function", 33, "arcctanh(x)", "1.0", 4);
            this.addKeyWord("acoth", "Inverse hyperbolic cotangent function", 33, "acoth(x)", "1.0", 4);
            this.addKeyWord("arcoth", "Inverse hyperbolic cotangent function", 33, "arcoth(x)", "1.0", 4);
            this.addKeyWord("arccoth", "Inverse hyperbolic cotangent function", 33, "arccoth(x)", "1.0", 4);
            this.addKeyWord("actgh", "Inverse hyperbolic cotangent function", 33, "actgh(x)", "1.0", 4);
            this.addKeyWord("arcctgh", "Inverse hyperbolic cotangent function", 33, "arcctgh(x)", "1.0", 4);
            this.addKeyWord("asech", "Inverse hyperbolic secant function", 34, "asech(x)", "1.0", 4);
            this.addKeyWord("arsech", "Inverse hyperbolic secant function", 34, "arsech(x)", "1.0", 4);
            this.addKeyWord("arcsech", "Inverse hyperbolic secant function", 34, "arcsech(x)", "1.0", 4);
            this.addKeyWord("acsch", "Inverse hyperbolic cosecant function", 35, "acsch(x)", "1.0", 4);
            this.addKeyWord("arcsch", "Inverse hyperbolic cosecant function", 35, "arcsch(x)", "1.0", 4);
            this.addKeyWord("arccsch", "Inverse hyperbolic cosecant function", 35, "arccsch(x)", "1.0", 4);
            this.addKeyWord("acosech", "Inverse hyperbolic cosecant function", 35, "acosech(x)", "1.0", 4);
            this.addKeyWord("arcosech", "Inverse hyperbolic cosecant function", 35, "arcosech(x)", "1.0", 4);
            this.addKeyWord("arccosech", "Inverse hyperbolic cosecant function", 35, "arccosech(x)", "1.0", 4);
            this.addKeyWord("sinc", "Sinc function (normalized)", 36, "sinc(x)", "1.0", 4);
            this.addKeyWord("Sa", "Sinc function (normalized)", 36, "Sa(x)", "1.0", 4);
            this.addKeyWord("Sinc", "Sinc function (unnormalized)", 37, "Sinc(x)", "1.0", 4);
            this.addKeyWord("Bell", "Bell number", 38, "Bell(n)", "1.0", 4);
            this.addKeyWord("Fib", "Fibonacci number", 40, "Fib(n)", "1.0", 4);
            this.addKeyWord("Luc", "Lucas number", 39, "Luc(n)", "1.0", 4);
            this.addKeyWord("harm", "Harmonic number", 41, "harm(n)", "1.0", 4);
            this.addKeyWord("ispr", "Prime number test (is number a prime?)", 42, "ispr(n)", "2.3", 4);
            this.addKeyWord("Pi", "Prime-counting function - Pi(x)", 43, "Pi(n)", "2.3", 4);
            this.addKeyWord("Ei", "Exponential integral function (non-elementary special function) - usage example: Ei(x)", 44, "Ei(x)", "2.3", 4);
            this.addKeyWord("li", "Logarithmic integral function (non-elementary special function) - usage example: li(x)", 45, "li(x)", "2.3", 4);
            this.addKeyWord("Li", "Offset logarithmic integral function (non-elementary special function) - usage example: Li(x)", 46, "Li(x)", "2.3", 4);
            this.addKeyWord("erf", "Gauss error function (non-elementary special function) - usage example: 2 + erf(x)", 47, "erf(x)", "3.0", 4);
            this.addKeyWord("erfc", "Gauss complementary error function (non-elementary special function) - usage example: 1 - erfc(x)", 48, "erfc(x)", "3.0", 4);
            this.addKeyWord("erfInv", "Inverse Gauss error function (non-elementary special function) - usage example: erfInv(x)", 49, "erfInv(x)", "3.0", 4);
            this.addKeyWord("erfcInv", "Inverse Gauss complementary error function (non-elementary special function) - usage example: erfcInv(x)", 50, "erfcInv(x)", "3.0", 4);
            this.addKeyWord("ulp", "Unit in The Last Place - ulp(0.1)", 51, "ulp(x)", "3.0", 4);
            this.addKeyWord("isNaN", "Returns true = 1 if value is a Not-a-Number (NaN), false = 0 otherwise - usage example: isNaN(x)", 52, "isNaN(x)", "4.1", 4);
            this.addKeyWord("ndig10", "Number of digits in numeral system with base 10", 53, "ndig10(x)", "4.1", 4);
            this.addKeyWord("nfact", "Prime decomposition - number of distinct prime factors", 54, "nfact(x)", "4.1", 4);
            this.addKeyWord("arcsec", "Inverse trigonometric secant", 55, "arcsec(x)", "4.1", 4);
            this.addKeyWord("arccsc", "Inverse trigonometric cosecant", 56, "arccsc(x)", "4.1", 4);
            this.addKeyWord("Gamma", "Gamma special function \u0393(s)", 57, "Gamma(x)", "4.2", 4);
            this.addKeyWord("LambW0", "Lambert-W special function, principal branch 0, also called the omega function or product logarithm", 58, "LambW0(x)", "4.2", 4);
            this.addKeyWord("LambW1", "Lambert-W special function, branch -1, also called the omega function or product logarithm", 59, "LambW1(x)", "4.2", 4);
            this.addKeyWord("sgnGamma", "Signum of Gamma special function, \u0393(s)", 60, "sgnGamma(x)", "4.2", 4);
            this.addKeyWord("logGamma", "Log Gamma special function, ln\u0393(s)", 61, "logGamma(x)", "4.2", 4);
            this.addKeyWord("diGamma", "Digamma function as the logarithmic derivative of the Gamma special function, \u03c8(x)", 62, "diGamma(x)", "4.2", 4);
            this.addKeyWord("log", "Logarithm function", 1, "log(a, b)", "1.0", 5);
            this.addKeyWord("mod", "Modulo function", 2, "mod(a, b)", "1.0", 5);
            this.addKeyWord("C", "Binomial coefficient function, number of k-combinations that can be drawn from n-elements set", 3, "C(n, k)", "1.0", 5);
            this.addKeyWord("nCk", "Binomial coefficient function, number of k-combinations that can be drawn from n-elements set", 3, "nCk(n,k)", "4.2", 5);
            this.addKeyWord("Bern", "Bernoulli numbers", 4, "Bern(m, n)", "1.0", 5);
            this.addKeyWord("Stirl1", "Stirling numbers of the first kind", 5, "Stirl1(n, k)", "1.0", 5);
            this.addKeyWord("Stirl2", "Stirling numbers of the second kind", 6, "Stirl2(n, k)", "1.0", 5);
            this.addKeyWord("Worp", "Worpitzky number", 7, "Worp(n, k)", "1.0", 5);
            this.addKeyWord("Euler", "Euler number", 8, "Euler(n, k)", "1.0", 5);
            this.addKeyWord("KDelta", "Kronecker delta", 9, "KDelta(i, j)", "1.0", 5);
            this.addKeyWord("EulerPol", "EulerPol", 10, "EulerPol", "1.0", 5);
            this.addKeyWord("Harm", "Harmonic number", 11, "Harm(x, n)", "1.0", 5);
            this.addKeyWord("rUni", "Random variable - Uniform continuous distribution U(a,b), usage example: 2*rUni(2,10)", 12, "rUni(a, b)", "3.0", 5);
            this.addKeyWord("rUnid", "Random variable - Uniform discrete distribution U{a,b}, usage example: 2*rUnid(2,100)", 13, "rUnid(a, b)", "3.0", 5);
            this.addKeyWord("round", "Half-up rounding, usage examples: round(2.2, 0) = 2, round(2.6, 0) = 3, round(2.66,1) = 2.7", 14, "round(x, n)", "3.0", 5);
            this.addKeyWord("rNor", "Random variable - Normal distribution N(m,s) m - mean, s - stddev, usage example: 3*rNor(0,1)", 15, "rNor(mean, stdv)", "3.0", 5);
            this.addKeyWord("ndig", "Number of digits representing the number in numeral system with given base", 16, "ndig(number, base)", "4.1", 5);
            this.addKeyWord("dig10", "Digit at position 1 ... n (left -> right) or 0 ... -(n-1) (right -> left) - base 10 numeral system", 17, "dig10(num, pos)", "4.1", 5);
            this.addKeyWord("factval", "Prime decomposition - factor value at position between 1 ... nfact(n) - ascending order by factor value", 18, "factval(number, factorid)", "4.1", 5);
            this.addKeyWord("factexp", "Prime decomposition - factor exponent / multiplicity at position between 1 ... nfact(n) - ascending order by factor value", 19, "factexp(number, factorid)", "4.1", 5);
            this.addKeyWord("root", "N-th order root of a number", 20, "root(rootorder, number)", "4.1", 5);
            this.addKeyWord("GammaL", "Lower incomplete gamma special function, \u03b3(s,x)", 21, "GammaL(s,x)", "4.2", 5);
            this.addKeyWord("GammaU", "Upper incomplete Gamma special function, \u0393(s,x)", 22, "GammaU(s,x)", "4.2", 5);
            this.addKeyWord("GammaRegL", "Lower regularized P gamma special function, P(s,x)", 23, "GammaRegL(s,x)", "4.2", 5);
            this.addKeyWord("GammaRegU", "Upper regularized Q Gamma special function, Q(s,x)", 24, "GammaRegU(s,x)", "4.2", 5);
            this.addKeyWord("GammaP", "Lower regularized P gamma special function, P(s,x)", 23, "GammaP(s,x)", "4.2", 5);
            this.addKeyWord("GammaQ", "Upper regularized Q Gamma special function, Q(s,x)", 24, "GammaQ(s,x)", "4.2", 5);
            this.addKeyWord("nPk", "Number of k-permutations that can be drawn from n-elements set", 25, "nPk(n,k)", "4.2", 5);
            this.addKeyWord("Beta", "The Beta special function B(x,y), also called the Euler integral of the first kind", 26, "Beta(x,y)", "4.2", 5);
            this.addKeyWord("logBeta", "The Log Beta special function ln B(x,y), also called the Log Euler integral of the first kind, ln B(x,y)", 27, "logBeta(x,y)", "4.2", 5);
            this.addKeyWord("if", "If function", 1, "if( cond, expr-if-true, expr-if-false )", "1.0", 6);
            this.addKeyWord("chi", "Characteristic function for x in (a,b)", 3, "chi(x, a, b)", "1.0", 6);
            this.addKeyWord("CHi", "Characteristic function for x in [a,b]", 4, "CHi(x, a, b)", "1.0", 6);
            this.addKeyWord("Chi", "Characteristic function for x in [a,b)", 5, "Chi(x, a, b)", "1.0", 6);
            this.addKeyWord("cHi", "Characteristic function for x in (a,b]", 6, "cHi(x, a, b)", "1.0", 6);
            this.addKeyWord("pUni", "Probability distribution function - Uniform continuous distribution U(a,b)", 7, "pUni(x, a, b)", "3.0", 6);
            this.addKeyWord("cUni", "Cumulative distribution function - Uniform continuous distribution U(a,b)", 8, "cUni(x, a, b)", "3.0", 6);
            this.addKeyWord("qUni", "Quantile function (inverse cumulative distribution function) - Uniform continuous distribution U(a,b)", 9, "qUni(q, a, b)", "3.0", 6);
            this.addKeyWord("pNor", "Probability distribution function - Normal distribution N(m,s)", 10, "pNor(x, mean, stdv)", "3.0", 6);
            this.addKeyWord("cNor", "Cumulative distribution function - Normal distribution N(m,s)", 11, "cNor(x, mean, stdv)", "3.0", 6);
            this.addKeyWord("qNor", "Quantile function (inverse cumulative distribution function)", 12, "qNor(q, mean, stdv)", "3.0", 6);
            this.addKeyWord("dig", "Digit at position 1 ... n (left -> right) or 0 ... -(n-1) (right -> left) - numeral system with given base", 13, "dig(num, pos, base)", "4.1", 6);
            this.addKeyWord("BetaInc", "The incomplete beta special function B(x; a, b), also called the incomplete Euler integral of the first kind", 14, "BetaInc(x,a,b)", "4.2", 6);
            this.addKeyWord("BetaReg", "The regularized incomplete beta (or regularized beta) special function I(x; a, b), also called the regularized incomplete Euler integral of the first kind", 15, "BetaReg(x,a,b)", "4.2", 6);
            this.addKeyWord("BetaI", "The regularized incomplete beta (or regularized beta) special function I(x; a, b), also called the regularized incomplete Euler integral of the first kind", 15, "BetaI(x,a,b)", "4.2", 6);
            this.addKeyWord("iff", "If function", 1, "iff( cond-1, expr-1; ... ; cond-n, expr-n )", "1.0", 7);
            this.addKeyWord("min", "Minimum function", 2, "min(a1, ..., an)", "1.0", 7);
            this.addKeyWord("max", "Maximum function", 3, "max(a1, ..., an)", "1.0", 7);
            this.addKeyWord("ConFrac", "Continued fraction", 4, "ConFrac(a1, ..., an)", "1.0", 7);
            this.addKeyWord("ConPol", "Continued polynomial", 5, "ConPol(a1, ..., an)", "1.0", 7);
            this.addKeyWord("gcd", "Greatest common divisor", 6, "gcd(a1, ..., an)", "1.0", 7);
            this.addKeyWord("lcm", "Least common multiple", 7, "lcm(a1, ..., an)", "1.0", 7);
            this.addKeyWord("add", "Summation operator", 8, "add(a1, ..., an)", "2.4", 7);
            this.addKeyWord("multi", "Multiplication", 9, "multi(a1, ..., an)", "2.4", 7);
            this.addKeyWord("mean", "Mean / average value", 10, "mean(a1, ..., an)", "2.4", 7);
            this.addKeyWord("var", "Bias-corrected sample variance", 11, "var(a1, ..., an)", "2.4", 7);
            this.addKeyWord("std", "Bias-corrected sample standard deviation", 12, "std(a1, ..., an)", "2.4", 7);
            this.addKeyWord("rList", "Random number from given list of numbers", 13, "rList(a1, ..., an)", "3.0", 7);
            this.addKeyWord("coalesce", "Returns the first non-NaN value", 14, "coalesce(a1, ..., an)", "4.1", 7);
            this.addKeyWord("or", "Logical disjunction (OR) - variadic", 15, "or(a1, ..., an)", "4.1", 7);
            this.addKeyWord("and", "Logical conjunction (AND) - variadic", 16, "and(a1, ..., an)", "4.1", 7);
            this.addKeyWord("xor", "Exclusive or (XOR) - variadic", 17, "xor(a1, ..., an)", "4.1", 7);
            this.addKeyWord("argmin", "Arguments / indices of the minima", 18, "argmin(a1, ..., an)", "4.1", 7);
            this.addKeyWord("argmax", "Arguments / indices of the maxima", 19, "argmax(a1, ..., an)", "4.1", 7);
            this.addKeyWord("med", "The sample median", 20, "med(a1, ..., an)", "4.1", 7);
            this.addKeyWord("mode", "Mode - the value that appears most often", 21, "mode(a1, ..., an)", "4.1", 7);
            this.addKeyWord("base", "Returns number in given numeral system base represented by list of digits", 22, "base(b, d1, ..., dn)", "4.1", 7);
            this.addKeyWord("ndist", "Number of distinct values", 23, "ndist(v1, ..., vn)", "4.1", 7);
            this.addKeyWord("sum", "Summation operator - SIGMA", 1, "sum( i, from, to, expr , <by> )", "1.0", 8);
            this.addKeyWord("prod", "Product operator - PI", 3, "prod( i, from, to, expr , <by> )", "1.0", 8);
            this.addKeyWord("int", "Definite integral operator", 5, "int( expr, arg, from, to )", "1.0", 8);
            this.addKeyWord("der", "Derivative operator", 6, "der( expr, arg, <point> )", "1.0", 8);
            this.addKeyWord("der-", "Left derivative operator", 7, "der-( expr, arg, <point> )", "1.0", 8);
            this.addKeyWord("der+", "Right derivative operator", 8, "der+( expr, arg, <point> )", "1.0", 8);
            this.addKeyWord("dern", "n-th derivative operator", 9, "dern( expr, n, arg )", "1.0", 8);
            this.addKeyWord("diff", "Forward difference operator", 10, "diff( expr, arg, <delta> )", "1.0", 8);
            this.addKeyWord("difb", "Backward difference operator", 11, "difb( expr, arg, <delta> )", "1.0", 8);
            this.addKeyWord("avg", "Average operator", 12, "avg( i, from, to, expr , <by> )", "2.4", 8);
            this.addKeyWord("vari", "Bias-corrected sample variance operator", 13, "vari( i, from, to, expr , <by> )", "2.4", 8);
            this.addKeyWord("stdi", "Bias-corrected sample standard deviation operator", 14, "stdi( i, from, to, expr , <by> )", "2.4", 8);
            this.addKeyWord("mini", "Minimum value", 15, "mini( i, from, to, expr , <by> )", "2.4", 8);
            this.addKeyWord("maxi", "Maximum value", 16, "maxi( i, from, to, expr , <by> )", "2.4", 8);
            this.addKeyWord("solve", "f(x) = 0 equation solving, function root finding", 17, "solve( expr, arg, from, to )", "4.0", 8);
            this.addKeyWord("pi", "Pi, Archimedes' constant or Ludolph's number", 1, "pi", "1.0", 9);
            this.addKeyWord("e", "Napier's constant, or Euler's number, base of Natural logarithm", 2, "e", "1.0", 9);
            this.addKeyWord("[gam]", "Euler-Mascheroni constant", 3, "[gam]", "1.0", 9);
            this.addKeyWord("[phi]", "Golden ratio", 4, "[phi]", "1.0", 9);
            this.addKeyWord("[PN]", "Plastic constant", 5, "[PN]", "1.0", 9);
            this.addKeyWord("[B*]", "Embree-Trefethen constant", 6, "[B*]", "1.0", 9);
            this.addKeyWord("[F'd]", "Feigenbaum constant alfa", 7, "[F'd]", "1.0", 9);
            this.addKeyWord("[F'a]", "Feigenbaum constant delta", 8, "[F'a]", "1.0", 9);
            this.addKeyWord("[C2]", "Twin prime constant", 9, "[C2]", "1.0", 9);
            this.addKeyWord("[M1]", "Meissel-Mertens constant", 10, "[M1]", "1.0", 9);
            this.addKeyWord("[B2]", "Brun's constant for twin primes", 11, "[B2]", "1.0", 9);
            this.addKeyWord("[B4]", "Brun's constant for prime quadruplets", 12, "[B4]", "1.0", 9);
            this.addKeyWord("[BN'L]", "de Bruijn-Newman constant", 13, "[BN'L]", "1.0", 9);
            this.addKeyWord("[Kat]", "Catalan's constant", 14, "[Kat]", "1.0", 9);
            this.addKeyWord("[K*]", "Landau-Ramanujan constant", 15, "[K*]", "1.0", 9);
            this.addKeyWord("[K.]", "Viswanath's constant", 16, "[K.]", "1.0", 9);
            this.addKeyWord("[B'L]", "Legendre's constant", 17, "[B'L]", "1.0", 9);
            this.addKeyWord("[RS'm]", "Ramanujan-Soldner constant", 18, "[RS'm]", "1.0", 9);
            this.addKeyWord("[EB'e]", "Erdos-Borwein constant", 19, "[EB'e]", "1.0", 9);
            this.addKeyWord("[Bern]", "Bernstein's constant", 20, "[Bern]", "1.0", 9);
            this.addKeyWord("[GKW'l]", "Gauss-Kuzmin-Wirsing constant", 21, "[GKW'l]", "1.0", 9);
            this.addKeyWord("[HSM's]", "Hafner-Sarnak-McCurley constant", 22, "[HSM's]", "1.0", 9);
            this.addKeyWord("[lm]", "Golomb-Dickman constant", 23, "[lm]", "1.0", 9);
            this.addKeyWord("[Cah]", "Cahen's constant", 24, "[Cah]", "1.0", 9);
            this.addKeyWord("[Ll]", "Laplace limit", 25, "[Ll]", "1.0", 9);
            this.addKeyWord("[AG]", "Alladi-Grinstead constant", 26, "[AG]", "1.0", 9);
            this.addKeyWord("[L*]", "Lengyel's constant", 27, "[L*]", "1.0", 9);
            this.addKeyWord("[L.]", "Levy's constant", 28, "[L.]", "1.0", 9);
            this.addKeyWord("[Dz3]", "Apery's constant", 29, "[Dz3]", "1.0", 9);
            this.addKeyWord("[A3n]", "Mills' constant", 30, "[A3n]", "1.0", 9);
            this.addKeyWord("[Bh]", "Backhouse's constant", 31, "[Bh]", "1.0", 9);
            this.addKeyWord("[Pt]", "Porter's constant", 32, "[Pt]", "1.0", 9);
            this.addKeyWord("[L2]", "Lieb's square ice constant", 33, "[L2]", "1.0", 9);
            this.addKeyWord("[Nv]", "Niven's constant", 34, "[Nv]", "1.0", 9);
            this.addKeyWord("[Ks]", "Sierpinski's constant", 35, "[Ks]", "1.0", 9);
            this.addKeyWord("[Kh]", "Khinchin's constant", 36, "[Kh]", "1.0", 9);
            this.addKeyWord("[FR]", "Fransen-Robinson constant", 37, "[FR]", "1.0", 9);
            this.addKeyWord("[La]", "Landau's constant", 38, "[La]", "1.0", 9);
            this.addKeyWord("[P2]", "Parabolic constant", 39, "[P2]", "1.0", 9);
            this.addKeyWord("[Om]", "Omega constant", 40, "[Om]", "1.0", 9);
            this.addKeyWord("[MRB]", "MRB constant", 41, "[MRB]", "1.0", 9);
            this.addKeyWord("[li2]", "li(2) - Logarithmic integral function at x=2", 42, "[li2]", "2.3", 9);
            this.addKeyWord("[EG]", "Gompertz constant", 43, "[EG]", "2.3", 9);
            this.addKeyWord("[c]", "<Physical Constant> Light speed in vacuum [m/s] (m=1, s=1)", 101, "[c]", "4.0", 9);
            this.addKeyWord("[G.]", "<Physical Constant> Gravitational constant (m=1, kg=1, s=1)]", 102, "[G.]", "4.0", 9);
            this.addKeyWord("[g]", "<Physical Constant> Gravitational acceleration on Earth [m/s^2] (m=1, s=1)", 103, "[g]", "4.0", 9);
            this.addKeyWord("[hP]", "<Physical Constant> Planck constant (m=1, kg=1, s=1)", 104, "[hP]", "4.0", 9);
            this.addKeyWord("[h-]", "<Physical Constant> Reduced Planck constant / Dirac constant (m=1, kg=1, s=1)]", 105, "[h-]", "4.0", 9);
            this.addKeyWord("[lP]", "<Physical Constant> Planck length [m] (m=1)", 106, "[lP]", "4.0", 9);
            this.addKeyWord("[mP]", "<Physical Constant> Planck mass [kg] (kg=1)", 107, "[mP]", "4.0", 9);
            this.addKeyWord("[tP]", "<Physical Constant> Planck time [s] (s=1)", 108, "[tP]", "4.0", 9);
            this.addKeyWord("[ly]", "<Astronomical Constant> Light year [m] (m=1)", 201, "[ly]", "4.0", 9);
            this.addKeyWord("[au]", "<Astronomical Constant> Astronomical unit [m] (m=1)", 202, "[au]", "4.0", 9);
            this.addKeyWord("[pc]", "<Astronomical Constant> Parsec [m] (m=1)", 203, "[pc]", "4.0", 9);
            this.addKeyWord("[kpc]", "<Astronomical Constant> Kiloparsec [m] (m=1)", 204, "[kpc]", "4.0", 9);
            this.addKeyWord("[Earth-R-eq]", "<Astronomical Constant> Earth equatorial radius [m] (m=1)", 205, "[Earth-R-eq]", "4.0", 9);
            this.addKeyWord("[Earth-R-po]", "<Astronomical Constant> Earth polar radius [m] (m=1)", 206, "[Earth-R-po]", "4.0", 9);
            this.addKeyWord("[Earth-R]", "<Astronomical Constant> Earth mean radius (m=1)", 207, "[Earth-R]", "4.0", 9);
            this.addKeyWord("[Earth-M]", "<Astronomical Constant> Earth mass [kg] (kg=1)", 208, "[Earth-M]", "4.0", 9);
            this.addKeyWord("[Earth-D]", "<Astronomical Constant> Earth-Sun distance - semi major axis [m] (m=1)", 209, "[Earth-D]", "4.0", 9);
            this.addKeyWord("[Moon-R]", "<Astronomical Constant> Moon mean radius [m] (m=1)", 210, "[Moon-R]", "4.0", 9);
            this.addKeyWord("[Moon-M]", "<Astronomical Constant> Moon mass [kg] (kg=1)", 211, "[Moon-M]", "4.0", 9);
            this.addKeyWord("[Moon-D]", "<Astronomical Constant> Moon-Earth distance - semi major axis [m] (m=1)", 212, "[Moon-D]", "4.0", 9);
            this.addKeyWord("[Solar-R]", "<Astronomical Constant> Solar mean radius [m] (m=1)", 213, "[Solar-R]", "4.0", 9);
            this.addKeyWord("[Solar-M]", "<Astronomical Constant> Solar mass [kg] (kg=1)", 214, "[Solar-M]", "4.0", 9);
            this.addKeyWord("[Mercury-R]", "<Astronomical Constant> Mercury mean radius [m] (m=1)", 215, "[Mercury-R]", "4.0", 9);
            this.addKeyWord("[Mercury-M]", "<Astronomical Constant> Mercury mass [kg] (kg=1)", 216, "[Mercury-M]", "4.0", 9);
            this.addKeyWord("[Mercury-D]", "<Astronomical Constant> Mercury-Sun distance - semi major axis [m] (m=1)", 217, "[Mercury-D]", "4.0", 9);
            this.addKeyWord("[Venus-R]", "<Astronomical Constant> Venus mean radius [m] (m=1)", 218, "[Venus-R]", "4.0", 9);
            this.addKeyWord("[Venus-M]", "<Astronomical Constant> Venus mass [kg] (kg=1)", 219, "[Venus-M]", "4.0", 9);
            this.addKeyWord("[Venus-D]", "<Astronomical Constant> Venus-Sun distance - semi major axis [m] (m=1)", 220, "[Venus-D]", "4.0", 9);
            this.addKeyWord("[Mars-R]", "<Astronomical Constant> Mars mean radius [m] (m=1)", 221, "[Mars-R]", "4.0", 9);
            this.addKeyWord("[Mars-M]", "<Astronomical Constant> Mars mass [kg] (kg=1)", 222, "[Mars-M]", "4.0", 9);
            this.addKeyWord("[Mars-D]", "<Astronomical Constant> Mars-Sun distance - semi major axis [m] (m=1)", 223, "[Mars-D]", "4.0", 9);
            this.addKeyWord("[Jupiter-R]", "<Astronomical Constant> Jupiter mean radius [m] (m=1)", 224, "[Jupiter-R]", "4.0", 9);
            this.addKeyWord("[Jupiter-M]", "<Astronomical Constant> Jupiter mass [kg] (kg=1)", 225, "[Jupiter-M]", "4.0", 9);
            this.addKeyWord("[Jupiter-D]", "<Astronomical Constant> Jupiter-Sun distance - semi major axis [m] (m=1)", 226, "[Jupiter-D]", "4.0", 9);
            this.addKeyWord("[Saturn-R]", "<Astronomical Constant> Saturn mean radius [m] (m=1)", 227, "[Saturn-R]", "4.0", 9);
            this.addKeyWord("[Saturn-M]", "<Astronomical Constant> Saturn mass [kg] (kg=1)", 228, "[Saturn-M]", "4.0", 9);
            this.addKeyWord("[Saturn-D]", "<Astronomical Constant> Saturn-Sun distance - semi major axis [m] (m=1)", 229, "[Saturn-D]", "4.0", 9);
            this.addKeyWord("[Uranus-R]", "<Astronomical Constant> Uranus mean radius [m] (m=1)", 230, "[Uranus-R]", "4.0", 9);
            this.addKeyWord("[Uranus-M]", "<Astronomical Constant> Uranus mass [kg] (kg=1)", 231, "[Uranus-M]", "4.0", 9);
            this.addKeyWord("[Uranus-D]", "<Astronomical Constant> Uranus-Sun distance - semi major axis [m] (m=1)", 232, "[Uranus-D]", "4.0", 9);
            this.addKeyWord("[Neptune-R]", "<Astronomical Constant> Neptune mean radius [m] (m=1)", 233, "[Neptune-R]", "4.0", 9);
            this.addKeyWord("[Neptune-M]", "<Astronomical Constant> Neptune mass [kg] (kg=1)", 234, "[Neptune-M]", "4.0", 9);
            this.addKeyWord("[Neptune-D]", "<Astronomical Constant> Neptune-Sun distance - semi major axis [m] (m=1)", 235, "[Neptune-D]", "4.0", 9);
            this.addKeyWord("[true]", "Boolean True represented as double, [true] = 1", 301, "[true]", "4.1", 9);
            this.addKeyWord("[false]", "Boolean False represented as double, [false] = 0", 302, "[false]", "4.1", 9);
            this.addKeyWord("[NaN]", "Not-a-Number", 999, "[NaN]", "4.1", 9);
            this.addKeyWord("[Uni]", "Random variable - Uniform continuous distribution U(0,1)", 1, "[Uni]", "3.0", 10);
            this.addKeyWord("[Int]", "Random variable - random integer", 2, "[Int]", "3.0", 10);
            this.addKeyWord("[Int1]", "Random variable - random integer - Uniform discrete distribution U{-10^1, 10^1}", 3, "[Int1]", "3.0", 10);
            this.addKeyWord("[Int2]", "Random variable - random integer - Uniform discrete distribution U{-10^2, 10^2}", 4, "[Int2]", "3.0", 10);
            this.addKeyWord("[Int3]", "Random variable - random integer - Uniform discrete distribution U{-10^3, 10^3}", 5, "[Int3]", "3.0", 10);
            this.addKeyWord("[Int4]", "Random variable - random integer - Uniform discrete distribution U{-10^4, 10^4}", 6, "[Int4]", "3.0", 10);
            this.addKeyWord("[Int5]", "Random variable - random integer - Uniform discrete distribution U{-10^5, 10^5}", 7, "[Int5]", "3.0", 10);
            this.addKeyWord("[Int6]", "Random variable - random integer - Uniform discrete distribution U{-10^6, 10^6}", 8, "[Int6]", "3.0", 10);
            this.addKeyWord("[Int7]", "Random variable - random integer - Uniform discrete distribution U{-10^7, 10^7}", 9, "[Int7]", "3.0", 10);
            this.addKeyWord("[Int8]", "Random variable - random integer - Uniform discrete distribution U{-10^8, 10^8}", 10, "[Int8]", "3.0", 10);
            this.addKeyWord("[Int9]", "Random variable - random integer - Uniform discrete distribution U{-10^9, 10^9}", 11, "[Int9]", "3.0", 10);
            this.addKeyWord("[nat]", "Random variable - random natural number including 0", 12, "[nat]", "3.0", 10);
            this.addKeyWord("[nat1]", "Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^1}", 13, "[nat1]", "3.0", 10);
            this.addKeyWord("[nat2]", "Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^2}", 14, "[nat2]", "3.0", 10);
            this.addKeyWord("[nat3]", "Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^3}", 15, "[nat3]", "3.0", 10);
            this.addKeyWord("[nat4]", "Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^4}", 16, "[nat4]", "3.0", 10);
            this.addKeyWord("[nat5]", "Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^5}", 17, "[nat5]", "3.0", 10);
            this.addKeyWord("[nat6]", "Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^6}", 18, "[nat6]", "3.0", 10);
            this.addKeyWord("[nat7]", "Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^7}", 19, "[nat7]", "3.0", 10);
            this.addKeyWord("[nat8]", "Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^8}", 20, "[nat8]", "3.0", 10);
            this.addKeyWord("[nat9]", "Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^9}", 21, "[nat9]", "3.0", 10);
            this.addKeyWord("[Nat]", "Random variable - random natural number", 22, "[Nat]", "3.0", 10);
            this.addKeyWord("[Nat1]", "Random variable - random natural number - Uniform discrete distribution U{1, 10^1}", 23, "[Nat1]", "3.0", 10);
            this.addKeyWord("[Nat2]", "Random variable - random natural number - Uniform discrete distribution U{1, 10^2}", 24, "[Nat2]", "3.0", 10);
            this.addKeyWord("[Nat3]", "Random variable - random natural number - Uniform discrete distribution U{1, 10^3}", 25, "[Nat3]", "3.0", 10);
            this.addKeyWord("[Nat4]", "Random variable - random natural number - Uniform discrete distribution U{1, 10^4}", 26, "[Nat4]", "3.0", 10);
            this.addKeyWord("[Nat5]", "Random variable - random natural number - Uniform discrete distribution U{1, 10^5}", 27, "[Nat5]", "3.0", 10);
            this.addKeyWord("[Nat6]", "Random variable - random natural number - Uniform discrete distribution U{1, 10^6}", 28, "[Nat6]", "3.0", 10);
            this.addKeyWord("[Nat7]", "Random variable - random natural number - Uniform discrete distribution U{1, 10^7}", 29, "[Nat7]", "3.0", 10);
            this.addKeyWord("[Nat8]", "Random variable - random natural number - Uniform discrete distribution U{1, 10^8}", 30, "[Nat8]", "3.0", 10);
            this.addKeyWord("[Nat9]", "Random variable - random natural number - Uniform discrete distribution U{1, 10^9}", 31, "[Nat9]", "3.0", 10);
            this.addKeyWord("[Nor]", "Random variable - Normal distribution N(0,1)", 32, "[Nor]", "3.0", 10);
            this.addKeyWord("@~", "Bitwise unary complement", 1, "@~a", "4.0", 11);
            this.addKeyWord("@&", "Bitwise AND", 2, "a @& b", "4.0", 11);
            this.addKeyWord("@^", "Bitwise exclusive OR", 3, "a @^ b", "4.0", 11);
            this.addKeyWord("@|", "Bitwise inclusive OR", 4, "a @| b", "4.0", 11);
            this.addKeyWord("@<<", "Signed left shift", 5, "a @<< b", "4.0", 11);
            this.addKeyWord("@>>", "Signed right shift", 6, "a @>> b", "4.0", 11);
            this.addKeyWord("[%]", "<Ratio, Fraction> Percentage = 0.01", 1, "[%]", "4.0", 12);
            this.addKeyWord("[%%]", "<Ratio, Fraction> Promil, Per mille = 0.001", 2, "[%%]", "4.0", 12);
            this.addKeyWord("[Y]", "<Metric prefix> Septillion / Yotta = 10^24", 101, "[Y]", "4.0", 12);
            this.addKeyWord("[sept]", "<Metric prefix> Septillion / Yotta = 10^24", 101, "[sept]", "4.0", 12);
            this.addKeyWord("[Z]", "<Metric prefix> Sextillion / Zetta = 10^21", 102, "[Z]", "4.0", 12);
            this.addKeyWord("[sext]", "<Metric prefix> Sextillion / Zetta = 10^21", 102, "[sext]", "4.0", 12);
            this.addKeyWord("[E]", "<Metric prefix> Quintillion / Exa = 10^18", 103, "[E]", "4.0", 12);
            this.addKeyWord("[quint]", "<Metric prefix> Quintillion / Exa = 10^18", 103, "[quint]", "4.0", 12);
            this.addKeyWord("[P]", "<Metric prefix> Quadrillion / Peta = 10^15", 104, "[P]", "4.0", 12);
            this.addKeyWord("[quad]", "<Metric prefix> Quadrillion / Peta = 10^15", 104, "[quad]", "4.0", 12);
            this.addKeyWord("[T]", "<Metric prefix> Trillion / Tera = 10^12", 105, "[T]", "4.0", 12);
            this.addKeyWord("[tril]", "<Metric prefix> Trillion / Tera = 10^12", 105, "[tril]", "4.0", 12);
            this.addKeyWord("[G]", "<Metric prefix> Billion / Giga = 10^9", 106, "[G]", "4.0", 12);
            this.addKeyWord("[bil]", "<Metric prefix> Billion / Giga = 10^9", 106, "[bil]", "4.0", 12);
            this.addKeyWord("[M]", "<Metric prefix> Million / Mega = 10^6", 107, "[M]", "4.0", 12);
            this.addKeyWord("[mil]", "<Metric prefix> Million / Mega = 10^6", 107, "[mil]", "4.0", 12);
            this.addKeyWord("[k]", "<Metric prefix> Thousand / Kilo = 10^3", 108, "[k]", "4.0", 12);
            this.addKeyWord("[th]", "<Metric prefix> Thousand / Kilo = 10^3", 108, "[th]", "4.0", 12);
            this.addKeyWord("[hecto]", "<Metric prefix> Hundred / Hecto = 10^2", 109, "[hecto]", "4.0", 12);
            this.addKeyWord("[hund]", "<Metric prefix> Hundred / Hecto = 10^2", 109, "[hund]", "4.0", 12);
            this.addKeyWord("[deca]", "<Metric prefix> Ten / Deca = 10", 110, "[deca]", "4.0", 12);
            this.addKeyWord("[ten]", "<Metric prefix> Ten / Deca = 10", 110, "[ten]", "4.0", 12);
            this.addKeyWord("[deci]", "<Metric prefix> Tenth / Deci = 0.1", 111, "[deci]", "4.0", 12);
            this.addKeyWord("[centi]", "<Metric prefix> Hundredth / Centi = 0.01", 112, "[centi]", "4.0", 12);
            this.addKeyWord("[milli]", "<Metric prefix> Thousandth / Milli = 0.001", 113, "[milli]", "4.0", 12);
            this.addKeyWord("[mic]", "<Metric prefix> Millionth / Micro = 10^-6", 114, "[mic]", "4.0", 12);
            this.addKeyWord("[n]", "<Metric prefix> Billionth / Nano = 10^-9", 115, "[n]", "4.0", 12);
            this.addKeyWord("[p]", "<Metric prefix> Trillionth / Pico = 10^-12", 116, "[p]", "4.0", 12);
            this.addKeyWord("[f]", "<Metric prefix> Quadrillionth / Femto = 10^-15", 117, "[f]", "4.0", 12);
            this.addKeyWord("[a]", "<Metric prefix> Quintillionth / Atoo = 10^-18", 118, "[a]", "4.0", 12);
            this.addKeyWord("[z]", "<Metric prefix> Sextillionth / Zepto = 10^-21", 119, "[z]", "4.0", 12);
            this.addKeyWord("[y]", "<Metric prefix> Septillionth / Yocto = 10^-24", 120, "[y]", "4.0", 12);
            this.addKeyWord("[m]", "<Unit of length> Metre / Meter (m=1)", 201, "[m]", "4.0", 12);
            this.addKeyWord("[km]", "<Unit of length> Kilometre / Kilometer (m=1)", 202, "[km]", "4.0", 12);
            this.addKeyWord("[cm]", "<Unit of length> Centimetre / Centimeter (m=1)", 203, "[cm]", "4.0", 12);
            this.addKeyWord("[mm]", "<Unit of length> Millimetre / Millimeter (m=1)", 204, "[mm]", "4.0", 12);
            this.addKeyWord("[inch]", "<Unit of length> Inch (m=1)", 205, "[inch]", "4.0", 12);
            this.addKeyWord("[yd]", "<Unit of length> Yard (m=1)", 206, "[yd]", "4.0", 12);
            this.addKeyWord("[ft]", "<Unit of length> Feet (m=1)", 207, "[ft]", "4.0", 12);
            this.addKeyWord("[mile]", "<Unit of length> Mile (m=1)", 208, "[mile]", "4.0", 12);
            this.addKeyWord("[nmi]", "<Unit of length> Nautical mile (m=1)", 209, "[nmi]", "4.0", 12);
            this.addKeyWord("[m2]", "<Unit of area> Square metre / Square meter (m=1)", 301, "[m2]", "4.0", 12);
            this.addKeyWord("[cm2]", "<Unit of area> Square centimetre / Square centimeter (m=1)", 302, "[cm2]", "4.0", 12);
            this.addKeyWord("[mm2]", "<Unit of area> Square millimetre / Square millimeter (m=1)", 303, "[mm2]", "4.0", 12);
            this.addKeyWord("[are]", "<Unit of area> Are (m=1)", 304, "[are]", "4.0", 12);
            this.addKeyWord("[ha]", "<Unit of area> Hectare (m=1)", 305, "[ha]", "4.0", 12);
            this.addKeyWord("[acre]", "<Unit of area> Acre (m=1)", 306, "[acre]", "4.0", 12);
            this.addKeyWord("[km2]", "<Unit of area> Square kilometre / Square kilometer (m=1)", 307, "[km2]", "4.0", 12);
            this.addKeyWord("[mm3]", "<Unit of volume> Cubic millimetre / Cubic millimeter (m=1)", 401, "[mm3]", "4.0", 12);
            this.addKeyWord("[cm3]", "<Unit of volume> Cubic centimetre / Cubic centimeter (m=1)", 402, "[cm3]", "4.0", 12);
            this.addKeyWord("[m3]", "<Unit of volume> Cubic metre / Cubic meter (m=1)", 403, "[m3]", "4.0", 12);
            this.addKeyWord("[km3]", "<Unit of volume> Cubic kilometre / Cubic kilometer (m=1)", 404, "[km3]", "4.0", 12);
            this.addKeyWord("[ml]", "<Unit of volume> Millilitre / Milliliter (m=1)", 405, "[ml]", "4.0", 12);
            this.addKeyWord("[l]", "<Unit of volume> Litre / Liter (m=1)", 406, "[l]", "4.0", 12);
            this.addKeyWord("[gall]", "<Unit of volume> Gallon (m=1)", 407, "[gall]", "4.0", 12);
            this.addKeyWord("[pint]", "<Unit of volume> Pint (m=1)", 408, "[pint]", "4.0", 12);
            this.addKeyWord("[s]", "<Unit of time> Second (s=1)", 501, "[s]", "4.0", 12);
            this.addKeyWord("[ms]", "<Unit of time> Millisecond (s=1)", 502, "[ms]", "4.0", 12);
            this.addKeyWord("[min]", "<Unit of time> Minute (s=1)", 503, "[min]", "4.0", 12);
            this.addKeyWord("[h]", "<Unit of time> Hour (s=1)", 504, "[h]", "4.0", 12);
            this.addKeyWord("[day]", "<Unit of time> Day (s=1)", 505, "[day]", "4.0", 12);
            this.addKeyWord("[week]", "<Unit of time> Week (s=1)", 506, "[week]", "4.0", 12);
            this.addKeyWord("[yearj]", "<Unit of time> Julian year = 365.25 days (s=1)", 507, "[yearj]", "4.0", 12);
            this.addKeyWord("[kg]", "<Unit of mass> Kilogram (kg=1)", 508, "[kg]", "4.0", 12);
            this.addKeyWord("[gr]", "<Unit of mass> Gram (kg=1)", 509, "[gr]", "4.0", 12);
            this.addKeyWord("[mg]", "<Unit of mass> Milligram (kg=1)", 510, "[mg]", "4.0", 12);
            this.addKeyWord("[dag]", "<Unit of mass> Decagram (kg=1)", 511, "[dag]", "4.0", 12);
            this.addKeyWord("[t]", "<Unit of mass> Tonne (kg=1)", 512, "[t]", "4.0", 12);
            this.addKeyWord("[oz]", "<Unit of mass> Ounce (kg=1)", 513, "[oz]", "4.0", 12);
            this.addKeyWord("[lb]", "<Unit of mass> Pound (kg=1)", 514, "[lb]", "4.0", 12);
            this.addKeyWord("[b]", "<Unit of information> Bit (bit=1)", 601, "[b]", "4.0", 12);
            this.addKeyWord("[kb]", "<Unit of information> Kilobit (bit=1)", 602, "[kb]", "4.0", 12);
            this.addKeyWord("[Mb]", "<Unit of information> Megabit (bit=1)", 603, "[Mb]", "4.0", 12);
            this.addKeyWord("[Gb]", "<Unit of information> Gigabit (bit=1)", 604, "[Gb]", "4.0", 12);
            this.addKeyWord("[Tb]", "<Unit of information> Terabit (bit=1)", 605, "[Tb]", "4.0", 12);
            this.addKeyWord("[Pb]", "<Unit of information> Petabit (bit=1)", 606, "[Pb]", "4.0", 12);
            this.addKeyWord("[Eb]", "<Unit of information> Exabit (bit=1)", 607, "[Eb]", "4.0", 12);
            this.addKeyWord("[Zb]", "<Unit of information> Zettabit (bit=1)", 608, "[Zb]", "4.0", 12);
            this.addKeyWord("[Yb]", "<Unit of information> Yottabit (bit=1)", 609, "[Yb]", "4.0", 12);
            this.addKeyWord("[B]", "<Unit of information> Byte (bit=1)", 610, "[B]", "4.0", 12);
            this.addKeyWord("[kB]", "<Unit of information> Kilobyte (bit=1)", 611, "[kB]", "4.0", 12);
            this.addKeyWord("[MB]", "<Unit of information> Megabyte (bit=1)", 612, "[MB]", "4.0", 12);
            this.addKeyWord("[GB]", "<Unit of information> Gigabyte (bit=1)", 613, "[GB]", "4.0", 12);
            this.addKeyWord("[TB]", "<Unit of information> Terabyte (bit=1)", 614, "[TB]", "4.0", 12);
            this.addKeyWord("[PB]", "<Unit of information> Petabyte (bit=1)", 615, "[PB]", "4.0", 12);
            this.addKeyWord("[EB]", "<Unit of information> Exabyte (bit=1)", 616, "[EB]", "4.0", 12);
            this.addKeyWord("[ZB]", "<Unit of information> Zettabyte (bit=1)", 617, "[ZB]", "4.0", 12);
            this.addKeyWord("[YB]", "<Unit of information> Yottabyte (bit=1)", 618, "[YB]", "4.0", 12);
            this.addKeyWord("[J]", "<Unit of energy> Joule (m=1, kg=1, s=1)", 701, "[J]", "4.0", 12);
            this.addKeyWord("[eV]", "<Unit of energy> Electronovolt (m=1, kg=1, s=1)", 702, "[eV]", "4.0", 12);
            this.addKeyWord("[keV]", "<Unit of energy> Kiloelectronovolt (m=1, kg=1, s=1)", 703, "[keV]", "4.0", 12);
            this.addKeyWord("[MeV]", "<Unit of energy> Megaelectronovolt (m=1, kg=1, s=1)", 704, "[MeV]", "4.0", 12);
            this.addKeyWord("[GeV]", "<Unit of energy> Gigaelectronovolt (m=1, kg=1, s=1)", 705, "[GeV]", "4.0", 12);
            this.addKeyWord("[TeV]", "<Unit of energy> Teraelectronovolt (m=1, kg=1, s=1)", 706, "[TeV]", "4.0", 12);
            this.addKeyWord("[m/s]", "<Unit of speed> Metre / Meter per second (m=1, s=1)", 801, "[m/s]", "4.0", 12);
            this.addKeyWord("[km/h]", "<Unit of speed> Kilometre / Kilometer per hour (m=1, s=1)", 802, "[km/h]", "4.0", 12);
            this.addKeyWord("[mi/h]", "<Unit of speed> Mile per hour (m=1, s=1)", 803, "[mi/h]", "4.0", 12);
            this.addKeyWord("[knot]", "<Unit of speed> Knot (m=1, s=1)", 804, "[knot]", "4.0", 12);
            this.addKeyWord("[m/s2]", "<Unit of acceleration> Metre / Meter per square second (m=1, s=1)", 901, "[m/s2]", "4.0", 12);
            this.addKeyWord("[km/h2]", "<Unit of acceleration> Kilometre / Kilometer per square hour (m=1, s=1)", 902, "[km/h2]", "4.0", 12);
            this.addKeyWord("[mi/h2]", "<Unit of acceleration> Mile per square hour (m=1, s=1)", 903, "[mi/h2]", "4.0", 12);
            this.addKeyWord("[rad]", "<Unit of angle> Radian (rad=1)", 1001, "[rad]", "4.0", 12);
            this.addKeyWord("[deg]", "<Unit of angle> Degree of arc (rad=1)", 1002, "[deg]", "4.0", 12);
            this.addKeyWord("[']", "<Unit of angle> Minute of arc (rad=1)", 1003, "[']", "4.0", 12);
            this.addKeyWord("['']", "<Unit of angle> Second of arc (rad=1)", 1004, "['']", "4.0", 12);
            if (this.UDFExpression) {
                this.addUDFSpecificParserKeyWords();
            }
        }
        this.addKeyWord("(", "Left parentheses", 1, "( ... )", "1.0", 20);
        this.addKeyWord(")", "Right parentheses", 2, "( ... )", "1.0", 20);
        this.addKeyWord(",", "Comma (function parameters)", 3, "(a1, ... ,an)", "1.0", 20);
        this.addKeyWord(";", "Semicolon (function parameters)", 3, "(a1; ... ;an)", "1.0", 20);
        this.addKeyWord("[+-]?(([0-9]([0-9])*)?\\.[0-9]([0-9])*|[0-9]([0-9])*)([eE][+-]?[0-9]([0-9])*)?", "Regullar expression for decimal numbers", 1, "Integer (since v.1.0): 1, -2; Decimal (since v.1.0): 0.2, -0.3, 1.2; Leading zero (since v.4.1): 001, -002.1; Scientific notation (since v.4.2): 1.2e-10, 1.2e+10, 2.3e10; No leading zero (since v.4.2): .2, -.212; Fractions (since v.4.2): 1_2, 2_1_3, 14_3; Other systems (since v.4.1): b1.111, b2.1001, b3.12021, b16.af12, h.af1, b.1001, o.0127", "1.0", 0);
        this.addKeyWord(" ", "Blank (whitespace) character", 4, " ", "4.2", 20);
    }

    private void addArgumentsKeyWords() {
        int n = this.argumentsList.size();
        for (int i = 0; i < n; ++i) {
            Argument argument = this.argumentsList.get(i);
            if (argument.getArgumentType() != 3) {
                this.addKeyWord(argument.getArgumentName(), argument.getDescription(), i, argument.getArgumentName(), "", 101);
                continue;
            }
            this.addKeyWord(argument.getArgumentName(), argument.getDescription(), i, argument.getArgumentName() + "(n)", "", 102);
        }
    }

    private void addFunctionsKeyWords() {
        int n = this.functionsList.size();
        for (int i = 0; i < n; ++i) {
            Function function = this.functionsList.get(i);
            String string = function.getFunctionName() + "(";
            int n2 = function.getParametersNumber();
            for (int j = 0; j < n2; ++j) {
                string = string + function.getParameterName(j);
                if (n2 <= 1 || j >= n2 - 1) continue;
                string = string + ",";
            }
            string = string + ")";
            this.addKeyWord(function.getFunctionName(), function.getDescription(), i, string, "", 103);
        }
    }

    private void addConstantsKeyWords() {
        int n = this.constantsList.size();
        for (int i = 0; i < n; ++i) {
            Constant constant = this.constantsList.get(i);
            this.addKeyWord(constant.getConstantName(), constant.getDescription(), i, constant.getConstantName(), "", 104);
        }
    }

    private void validateParserKeyWords() {
        if (mXparser.overrideBuiltinTokens) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Argument iterator2 : this.argumentsList) {
                arrayList.add(iterator2.getArgumentName());
            }
            for (Function function : this.functionsList) {
                arrayList.add(function.getFunctionName());
            }
            for (Constant constant : this.constantsList) {
                arrayList.add(constant.getConstantName());
            }
            if (arrayList.isEmpty()) {
                return;
            }
            ArrayList arrayList2 = new ArrayList();
            for (KeyWord keyWord : this.keyWordsList) {
                if (!arrayList.contains(keyWord.wordString)) continue;
                arrayList2.add(keyWord);
            }
            if (arrayList2.isEmpty()) {
                return;
            }
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                KeyWord keyWord;
                keyWord = (KeyWord)iterator.next();
                this.keyWordsList.remove(keyWord);
            }
        }
    }

    private void addKeyWord(String string, String string2, int n, String string3, String string4, int n2) {
        if (!(mXparser.tokensToRemove.size() <= 0 && mXparser.tokensToModify.size() <= 0 || n2 != 4 && n2 != 5 && n2 != 6 && n2 != 7 && n2 != 8 && n2 != 9 && n2 != 10 && n2 != 12)) {
            if (mXparser.tokensToRemove.size() > 0 && mXparser.tokensToRemove.contains(string)) {
                return;
            }
            if (mXparser.tokensToModify.size() > 0) {
                for (TokenModification tokenModification : mXparser.tokensToModify) {
                    if (!tokenModification.currentToken.equals(string)) continue;
                    string = tokenModification.newToken;
                    if (tokenModification.newTokenDescription != null) {
                        string2 = tokenModification.newTokenDescription;
                    }
                    string3 = string3.replace(tokenModification.currentToken, tokenModification.newToken);
                }
            }
        }
        this.keyWordsList.add(new KeyWord(string, string2, n, string3, string4, n2));
    }

    private void checkOtherNumberBases(Token token) {
        int n = 0;
        int n2 = token.tokenStr.length();
        if (n2 >= 2 && token.tokenStr.charAt(1) == '.') {
            n = 1;
        }
        if (n == 0 && n2 >= 3 && token.tokenStr.charAt(2) == '.') {
            n = 2;
        }
        if (n == 0 && n2 >= 4 && token.tokenStr.charAt(3) == '.') {
            n = 3;
        }
        if (n == 0) {
            return;
        }
        String string = token.tokenStr.substring(0, n).toLowerCase();
        String string2 = "";
        if (n2 > n + 1) {
            string2 = token.tokenStr.substring(n + 1);
        }
        int n3 = 0;
        if (string.equals("b")) {
            n3 = 2;
        } else if (string.equals("o")) {
            n3 = 8;
        } else if (string.equals("h")) {
            n3 = 16;
        } else if (string.equals("b1")) {
            n3 = 1;
        } else if (string.equals("b2")) {
            n3 = 2;
        } else if (string.equals("b3")) {
            n3 = 3;
        } else if (string.equals("b4")) {
            n3 = 4;
        } else if (string.equals("b5")) {
            n3 = 5;
        } else if (string.equals("b6")) {
            n3 = 6;
        } else if (string.equals("b7")) {
            n3 = 7;
        } else if (string.equals("b8")) {
            n3 = 8;
        } else if (string.equals("b9")) {
            n3 = 9;
        } else if (string.equals("b10")) {
            n3 = 10;
        } else if (string.equals("b11")) {
            n3 = 11;
        } else if (string.equals("b12")) {
            n3 = 12;
        } else if (string.equals("b13")) {
            n3 = 13;
        } else if (string.equals("b14")) {
            n3 = 14;
        } else if (string.equals("b15")) {
            n3 = 15;
        } else if (string.equals("b16")) {
            n3 = 16;
        } else if (string.equals("b17")) {
            n3 = 17;
        } else if (string.equals("b18")) {
            n3 = 18;
        } else if (string.equals("b19")) {
            n3 = 19;
        } else if (string.equals("b20")) {
            n3 = 20;
        } else if (string.equals("b21")) {
            n3 = 21;
        } else if (string.equals("b22")) {
            n3 = 22;
        } else if (string.equals("b23")) {
            n3 = 23;
        } else if (string.equals("b24")) {
            n3 = 24;
        } else if (string.equals("b25")) {
            n3 = 25;
        } else if (string.equals("b26")) {
            n3 = 26;
        } else if (string.equals("b27")) {
            n3 = 27;
        } else if (string.equals("b28")) {
            n3 = 28;
        } else if (string.equals("b29")) {
            n3 = 29;
        } else if (string.equals("b30")) {
            n3 = 30;
        } else if (string.equals("b31")) {
            n3 = 31;
        } else if (string.equals("b32")) {
            n3 = 32;
        } else if (string.equals("b33")) {
            n3 = 33;
        } else if (string.equals("b34")) {
            n3 = 34;
        } else if (string.equals("b35")) {
            n3 = 35;
        } else if (string.equals("b36")) {
            n3 = 36;
        }
        if (n3 > 0 && n3 <= 36) {
            token.tokenTypeId = 0;
            token.tokenId = 1;
            token.tokenValue = NumberTheory.convOthBase2Decimal(string2, n3);
        }
    }

    private void checkFraction(Token token) {
        double d;
        int n = token.tokenStr.length();
        if (n < 3) {
            return;
        }
        if (!mXparser.regexMatch(token.tokenStr, "([0-9]([0-9])*\\_)?[0-9]([0-9])*\\_[0-9]([0-9])*")) {
            return;
        }
        int n2 = token.tokenStr.indexOf(95);
        int n3 = token.tokenStr.indexOf(95, n2 + 1);
        boolean bl = false;
        if (n3 > 0) {
            bl = true;
        }
        if (bl) {
            String string = token.tokenStr.substring(0, n2);
            String string2 = token.tokenStr.substring(n2 + 1, n3);
            String string3 = token.tokenStr.substring(n3 + 1);
            double d2 = Double.parseDouble(string);
            double d3 = Double.parseDouble(string2);
            double d4 = Double.parseDouble(string3);
            d = d4 == 0.0 ? Double.NaN : d2 + d3 / d4;
        } else {
            String string = token.tokenStr.substring(0, n2);
            String string4 = token.tokenStr.substring(n2 + 1);
            double d5 = Double.parseDouble(string);
            double d6 = Double.parseDouble(string4);
            d = d6 == 0.0 ? Double.NaN : d5 / d6;
        }
        token.tokenTypeId = 0;
        token.tokenId = 1;
        token.tokenValue = d;
    }

    private void addToken(String string, KeyWord keyWord) {
        Token token = new Token();
        this.initialTokens.add(token);
        token.tokenStr = string;
        token.keyWord = keyWord.wordString;
        token.tokenTypeId = keyWord.wordTypeId;
        token.tokenId = keyWord.wordId;
        if (token.tokenTypeId == 101) {
            token.tokenValue = this.argumentsList.get((int)token.tokenId).argumentValue;
        } else if (token.tokenTypeId == 0) {
            token.tokenValue = Double.valueOf(token.tokenStr);
            token.keyWord = "_num_";
        } else if (token.tokenTypeId == -1) {
            this.checkOtherNumberBases(token);
            if (token.tokenTypeId == -1) {
                this.checkFraction(token);
            }
        }
    }

    private boolean isNotSpecialChar(char c) {
        if (c == '+') {
            return false;
        }
        if (c == '-') {
            return false;
        }
        if (c == '+') {
            return false;
        }
        if (c == '*') {
            return false;
        }
        if (c == '/') {
            return false;
        }
        if (c == '^') {
            return false;
        }
        if (c == ',') {
            return false;
        }
        if (c == ';') {
            return false;
        }
        if (c == '(') {
            return false;
        }
        if (c == ')') {
            return false;
        }
        if (c == '|') {
            return false;
        }
        if (c == '&') {
            return false;
        }
        if (c == '=') {
            return false;
        }
        if (c == '>') {
            return false;
        }
        if (c == '<') {
            return false;
        }
        if (c == '~') {
            return false;
        }
        if (c == '\\') {
            return false;
        }
        if (c == '#') {
            return false;
        }
        return c != '@';
    }

    private void tokenizeExpressionString() {
        char c;
        int n;
        int n2;
        this.keyWordsList = new ArrayList<KeyWord>();
        this.addParserKeyWords();
        this.validateParserKeyWords();
        if (!this.parserKeyWordsOnly) {
            this.addArgumentsKeyWords();
            this.addFunctionsKeyWords();
            this.addConstantsKeyWords();
        }
        Collections.sort(this.keyWordsList, new DescKwLenComparator());
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        for (n2 = 0; n2 < this.keyWordsList.size(); ++n2) {
            if (this.keyWordsList.get((int)n2).wordTypeId == 0) {
                n3 = n2;
            }
            if (this.keyWordsList.get((int)n2).wordTypeId != 1) continue;
            if (this.keyWordsList.get((int)n2).wordId == 1) {
                n4 = n2;
            }
            if (this.keyWordsList.get((int)n2).wordId != 2) continue;
            n5 = n2;
        }
        this.initialTokens = new ArrayList<Token>();
        n2 = this.expressionString.length();
        if (n2 == 0) {
            return;
        }
        String string = "";
        char c2 = 'a';
        int n6 = 0;
        int n7 = 0;
        for (n = 0; n < n2; ++n) {
            c = this.expressionString.charAt(n);
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t' || c == '\f') {
                ++n6;
            } else if (n6 > 0) {
                if (n7 > 0 && this.isNotSpecialChar(c2)) {
                    string = string + " ";
                }
                n6 = 0;
            }
            if (n6 != 0) continue;
            string = string + c;
            c2 = c;
            ++n7;
        }
        if (string.length() == 0) {
            return;
        }
        n = 0;
        int n8 = 0;
        String string2 = "";
        int n9 = -1;
        int n10 = -1;
        KeyWord keyWord = null;
        String string3 = "";
        String string4 = "";
        do {
            char c3;
            char c4;
            Object object;
            int n11;
            int n12 = -1;
            char c5 = string.charAt(n8);
            if (c5 == '+' || c5 == '-' || c5 == '.' || c5 == '0' || c5 == '1' || c5 == '2' || c5 == '3' || c5 == '4' || c5 == '5' || c5 == '6' || c5 == '7' || c5 == '8' || c5 == '9') {
                for (n11 = n8; n11 < string.length() && (n11 <= n8 || (c = string.charAt(n11)) == '+' || c == '-' || c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9' || c == '.' || c == 'e' || c == 'E'); ++n11) {
                    object = string.substring(n8, n11 + 1);
                    if (!mXparser.regexMatch((String)object, "[+-]?(([0-9]([0-9])*)?\\.[0-9]([0-9])*|[0-9]([0-9])*)([eE][+-]?[0-9]([0-9])*)?")) continue;
                    n12 = n11;
                }
            }
            if (n12 >= 0 && n8 > 0 && (c4 = string.charAt(n8 - 1)) != ' ' && c4 != ',' && c4 != ';' && c4 != '|' && c4 != '&' && c4 != '+' && c4 != '-' && c4 != '*' && c4 != '\\' && c4 != '/' && c4 != '(' && c4 != ')' && c4 != '=' && c4 != '>' && c4 != '<' && c4 != '~' && c4 != '^' && c4 != '#' && c4 != '%' && c4 != '@' && c4 != '!') {
                n12 = -1;
            }
            if (n12 >= 0 && n12 < string.length() - 1 && (c3 = string.charAt(n12 + 1)) != ' ' && c3 != ',' && c3 != ';' && c3 != '|' && c3 != '&' && c3 != '+' && c3 != '-' && c3 != '*' && c3 != '\\' && c3 != '/' && c3 != '(' && c3 != ')' && c3 != '=' && c3 != '>' && c3 != '<' && c3 != '~' && c3 != '^' && c3 != '#' && c3 != '%' && c3 != '@' && c3 != '!') {
                n12 = -1;
            }
            if (n12 >= 0) {
                if (n9 == -1 && n8 > 0) {
                    string2 = string.substring(n, n8);
                    this.addToken(string2, new KeyWord());
                }
                c5 = string.charAt(n8);
                n11 = 1;
                if (c5 == '-' || c5 == '+') {
                    if (this.initialTokens.size() > 0) {
                        object = this.initialTokens.get(this.initialTokens.size() - 1);
                        n11 = ((Token)object).tokenTypeId == 1 && ((Token)object).tokenId != 6 && ((Token)object).tokenId != 8 || ((Token)object).tokenTypeId == 3 || ((Token)object).tokenTypeId == 2 || ((Token)object).tokenTypeId == 11 || ((Token)object).tokenTypeId == 20 && ((Token)object).tokenId == 1 ? 0 : 1;
                    } else {
                        n11 = 0;
                    }
                } else {
                    n11 = 0;
                }
                if (n11 == 1) {
                    if (c5 == '-') {
                        this.addToken("-", this.keyWordsList.get(n5));
                    }
                    if (c5 == '+') {
                        this.addToken("+", this.keyWordsList.get(n4));
                    }
                    ++n8;
                }
                string2 = string.substring(n8, n12 + 1);
                this.addToken(string2, this.keyWordsList.get(n3));
                n = n8 = n12 + 1;
                n10 = 0;
                n9 = 0;
                continue;
            }
            n11 = -1;
            n10 = -1;
            do {
                keyWord = this.keyWordsList.get(++n11);
                string4 = keyWord.wordString;
                if (n8 + string4.length() > string.length()) continue;
                string3 = string.substring(n8, n8 + string4.length());
                if (string3.equals(string4)) {
                    n10 = 0;
                }
                if (n10 != 0 || keyWord.wordTypeId != 101 && keyWord.wordTypeId != 102 && keyWord.wordTypeId != 4 && keyWord.wordTypeId != 5 && keyWord.wordTypeId != 6 && keyWord.wordTypeId != 7 && keyWord.wordTypeId != 9 && keyWord.wordTypeId != 104 && keyWord.wordTypeId != 10 && keyWord.wordTypeId != 12 && keyWord.wordTypeId != 103 && keyWord.wordTypeId != 8) continue;
                if (n8 > 0 && (c4 = string.charAt(n8 - 1)) != ' ' && c4 != ',' && c4 != ';' && c4 != '|' && c4 != '&' && c4 != '+' && c4 != '-' && c4 != '*' && c4 != '\\' && c4 != '/' && c4 != '(' && c4 != ')' && c4 != '=' && c4 != '>' && c4 != '<' && c4 != '~' && c4 != '^' && c4 != '#' && c4 != '%' && c4 != '@' && c4 != '!') {
                    n10 = -1;
                }
                if (n10 != 0 || n8 + string4.length() >= string.length() || (c3 = string.charAt(n8 + string4.length())) == ' ' || c3 == ',' || c3 == ';' || c3 == '|' || c3 == '&' || c3 == '+' || c3 == '-' || c3 == '*' || c3 == '\\' || c3 == '/' || c3 == '(' || c3 == ')' || c3 == '=' || c3 == '>' || c3 == '<' || c3 == '~' || c3 == '^' || c3 == '#' || c3 == '%' || c3 == '@' || c3 == '!') continue;
                n10 = -1;
            } while (n11 < this.keyWordsList.size() - 1 && n10 == -1);
            if (n10 == 0) {
                if (n9 == -1 && n8 > 0) {
                    string2 = string.substring(n, n8);
                    this.addToken(string2, new KeyWord());
                }
                n9 = 0;
                string2 = string.substring(n8, n8 + string4.length());
                if (keyWord.wordTypeId != 20 || keyWord.wordId != 4) {
                    this.addToken(string2, keyWord);
                }
                n = n8 + string4.length();
                n8 += string4.length();
                continue;
            }
            n9 = -1;
            if (n8 >= string.length()) continue;
            ++n8;
        } while (n8 < string.length());
        if (n10 == -1) {
            string2 = string.substring(n, n8);
            this.addToken(string2, new KeyWord());
        }
        this.evaluateTokensLevels();
    }

    private void evaluateTokensLevels() {
        int n = 0;
        Stack<TokenStackElement> stack = new Stack<TokenStackElement>();
        boolean bl = false;
        if (this.initialTokens.size() > 0) {
            for (int i = 0; i < this.initialTokens.size(); ++i) {
                TokenStackElement tokenStackElement;
                Token token = this.initialTokens.get(i);
                if (token.tokenTypeId == 4 || token.tokenTypeId == 5 || token.tokenTypeId == 6 || token.tokenTypeId == 103 || token.tokenTypeId == 8 || token.tokenTypeId == 102 || token.tokenTypeId == 7) {
                    bl = true;
                } else if (token.tokenTypeId == 20 && token.tokenId == 1) {
                    tokenStackElement = new TokenStackElement();
                    tokenStackElement.tokenId = token.tokenId;
                    tokenStackElement.tokenIndex = i;
                    tokenStackElement.tokenLevel = ++n;
                    tokenStackElement.tokenTypeId = token.tokenTypeId;
                    tokenStackElement.precedingFunction = bl;
                    stack.push(tokenStackElement);
                    bl = false;
                } else {
                    bl = false;
                }
                token.tokenLevel = ++n;
                if (token.tokenTypeId != 20 || token.tokenId != 2) continue;
                --n;
                if (stack.isEmpty()) continue;
                tokenStackElement = (TokenStackElement)stack.pop();
                if (!tokenStackElement.precedingFunction) continue;
                --n;
            }
        }
    }

    private void copyInitialTokens() {
        this.tokensList = new ArrayList<Token>();
        for (Token token : this.initialTokens) {
            this.tokensList.add(token.clone());
        }
    }

    public List<Token> getCopyOfInitialTokens() {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        if (this.expressionString.length() == 0) {
            return arrayList;
        }
        this.tokenizeExpressionString();
        if (this.initialTokens.size() == 0) {
            return arrayList;
        }
        for (int i = 0; i < this.initialTokens.size(); ++i) {
            Token token = this.initialTokens.get(i);
            if (token.tokenTypeId == -1) {
                if (mXparser.regexMatch(token.tokenStr, "\\[([a-zA-Z_])+([a-zA-Z0-9_])*\\]")) {
                    token.looksLike = "unit/const";
                } else if (mXparser.regexMatch(token.tokenStr, "([a-zA-Z_])+([a-zA-Z0-9_])*")) {
                    token.looksLike = "argument";
                    if (i < this.initialTokens.size() - 1) {
                        Token token2 = this.initialTokens.get(i + 1);
                        if (token2.tokenTypeId == 20 && token2.tokenId == 1) {
                            token.looksLike = "function";
                        }
                    }
                } else {
                    token.looksLike = "error";
                }
            }
            arrayList.add(token.clone());
        }
        return arrayList;
    }

    public String[] getMissingUserDefinedArguments() {
        List<Token> list = this.getCopyOfInitialTokens();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Token stringArray2 : list) {
            if (!stringArray2.looksLike.equals("argument") || arrayList.contains(stringArray2.tokenStr)) continue;
            arrayList.add(stringArray2.tokenStr);
        }
        int n = arrayList.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public String[] getMissingUserDefinedUnits() {
        List<Token> list = this.getCopyOfInitialTokens();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Token stringArray2 : list) {
            if (!stringArray2.looksLike.equals("unit/const") || arrayList.contains(stringArray2.tokenStr)) continue;
            arrayList.add(stringArray2.tokenStr);
        }
        int n = arrayList.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public String[] getMissingUserDefinedFunctions() {
        List<Token> list = this.getCopyOfInitialTokens();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Token stringArray2 : list) {
            if (!stringArray2.looksLike.equals("function") || arrayList.contains(stringArray2.tokenStr)) continue;
            arrayList.add(stringArray2.tokenStr);
        }
        int n = arrayList.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    List<Token> getInitialTokens() {
        return this.initialTokens;
    }

    private static final String getLeftSpaces(String string, String string2) {
        String string3 = "";
        for (int i = 0; i < string.length() - string2.length(); ++i) {
            string3 = string3 + " ";
        }
        return string3 + string2;
    }

    private static final String getRightSpaces(String string, String string2) {
        String string3 = "";
        for (int i = 0; i < string.length() - string2.length(); ++i) {
            string3 = " " + string3;
        }
        return string2 + string3;
    }

    private void showParsing(int n, int n2) {
        mXparser.consolePrint(" ---> ");
        for (int i = n; i <= n2; ++i) {
            Token token = this.tokensList.get(i);
            if (token.tokenTypeId == 0) {
                mXparser.consolePrint(token.tokenValue + " ");
                continue;
            }
            mXparser.consolePrint(token.tokenStr + " ");
        }
        mXparser.consolePrint(" ... ");
    }

    void showKeyWords() {
        int n = this.keyWordsList.size();
        String string = "KEY_WORD";
        mXparser.consolePrintln("KEY WORDS:");
        mXparser.consolePrintln(" -------------------------------------------");
        mXparser.consolePrintln("|      IDX | KEY_WORD |       ID |  TYPE_ID |");
        mXparser.consolePrintln(" -------------------------------------------");
        for (int i = 0; i < n; ++i) {
            KeyWord keyWord = this.keyWordsList.get(i);
            String string2 = Expression.getLeftSpaces(string, Integer.toString(i));
            String string3 = Expression.getLeftSpaces(string, keyWord.wordString);
            String string4 = Expression.getLeftSpaces(string, Integer.toString(keyWord.wordId));
            String string5 = Expression.getLeftSpaces(string, Integer.toString(keyWord.wordTypeId));
            mXparser.consolePrintln("| " + string2 + " | " + string3 + " | " + string4 + " | " + string5 + " |");
        }
        mXparser.consolePrintln(" -------------------------------------------");
    }

    public String getHelp() {
        return this.getHelp("");
    }

    public String getHelp(String string) {
        this.keyWordsList = new ArrayList<KeyWord>();
        String string2 = "Help content: \n\n";
        this.addParserKeyWords();
        this.validateParserKeyWords();
        if (!this.parserKeyWordsOnly) {
            this.addArgumentsKeyWords();
            this.addFunctionsKeyWords();
            this.addConstantsKeyWords();
        }
        string2 = string2 + Expression.getLeftSpaces("12345", "#") + "  " + Expression.getRightSpaces("01234567890123456789", "key word") + Expression.getRightSpaces("                        ", "type") + Expression.getRightSpaces("0123456789012345678901234567890123456789012345", "syntax") + Expression.getRightSpaces("012345", "since") + "description\n";
        string2 = string2 + Expression.getLeftSpaces("12345", "-") + "  " + Expression.getRightSpaces("01234567890123456789", "--------") + Expression.getRightSpaces("                        ", "----") + Expression.getRightSpaces("0123456789012345678901234567890123456789012345", "------") + Expression.getRightSpaces("012345", "-----") + "-----------\n";
        Collections.sort(this.keyWordsList, new KwTypeComparator());
        int n = this.keyWordsList.size();
        for (int i = 0; i < n; ++i) {
            KeyWord keyWord = this.keyWordsList.get(i);
            String string3 = "";
            String string4 = keyWord.wordString;
            switch (keyWord.wordTypeId) {
                case 20: {
                    string3 = "Parser Symbol";
                    break;
                }
                case 0: {
                    string3 = "number";
                    string4 = "_number_";
                    break;
                }
                case 1: {
                    string3 = "Operator";
                    break;
                }
                case 2: {
                    string3 = "Boolean Operator";
                    break;
                }
                case 3: {
                    string3 = "Binary Relation";
                    break;
                }
                case 4: {
                    string3 = "Unary Function";
                    break;
                }
                case 5: {
                    string3 = "Binary Function";
                    break;
                }
                case 6: {
                    string3 = "3-args Function";
                    break;
                }
                case 7: {
                    string3 = "Variadic Function";
                    break;
                }
                case 8: {
                    string3 = "Calculus Operator";
                    break;
                }
                case 10: {
                    string3 = "Random Variable";
                    break;
                }
                case 9: {
                    string3 = "Constant Value";
                    break;
                }
                case 101: {
                    string3 = "User defined argument";
                    break;
                }
                case 102: {
                    string3 = "User defined recursive argument";
                    break;
                }
                case 103: {
                    string3 = "User defined function";
                    break;
                }
                case 104: {
                    string3 = "User defined constant";
                    break;
                }
                case 12: {
                    string3 = "Unit";
                    break;
                }
                case 11: {
                    string3 = "Bitwise Operator";
                }
            }
            String string5 = Expression.getLeftSpaces("12345", Integer.toString(i + 1)) + ". " + Expression.getRightSpaces("01234567890123456789", string4) + Expression.getRightSpaces("                        ", "<" + string3 + ">") + Expression.getRightSpaces("0123456789012345678901234567890123456789012345", keyWord.syntax) + Expression.getRightSpaces("012345", keyWord.since) + keyWord.description + "\n";
            if (string5.toLowerCase().indexOf(string.toLowerCase()) < 0) continue;
            string2 = string2 + string5;
        }
        return string2;
    }

    public List<KeyWord> getKeyWords() {
        return this.getKeyWords("");
    }

    public List<KeyWord> getKeyWords(String string) {
        this.keyWordsList = new ArrayList<KeyWord>();
        ArrayList<KeyWord> arrayList = new ArrayList<KeyWord>();
        this.addParserKeyWords();
        this.validateParserKeyWords();
        if (!this.parserKeyWordsOnly) {
            this.addArgumentsKeyWords();
            this.addFunctionsKeyWords();
            this.addConstantsKeyWords();
        }
        Collections.sort(this.keyWordsList, new KwTypeComparator());
        for (KeyWord keyWord : this.keyWordsList) {
            String string2 = "str=" + keyWord.wordString + " desc=" + keyWord.description + " syn=" + keyWord.syntax + " sin=" + keyWord.since + " wid=" + keyWord.wordId + " tid=" + keyWord.wordTypeId;
            if (string2.toLowerCase().indexOf(string.toLowerCase()) < 0) continue;
            arrayList.add(keyWord);
        }
        return arrayList;
    }

    void showTokens() {
        Expression.showTokens(this.tokensList);
    }

    static final void showTokens(List<Token> list) {
        String string = "TokenTypeId";
        mXparser.consolePrintln(" --------------------");
        mXparser.consolePrintln("| Expression tokens: |");
        mXparser.consolePrintln(" ---------------------------------------------------------------------------------------------------------------");
        mXparser.consolePrintln("|    TokenIdx |       Token |        KeyW |     TokenId | TokenTypeId |  TokenLevel |  TokenValue |   LooksLike |");
        mXparser.consolePrintln(" ---------------------------------------------------------------------------------------------------------------");
        if (list == null) {
            mXparser.consolePrintln("NULL tokens list");
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string2 = Expression.getLeftSpaces(string, Integer.toString(i));
            String string3 = Expression.getLeftSpaces(string, list.get((int)i).tokenStr);
            String string4 = Expression.getLeftSpaces(string, list.get((int)i).keyWord);
            String string5 = Expression.getLeftSpaces(string, Integer.toString(list.get((int)i).tokenId));
            String string6 = Expression.getLeftSpaces(string, Integer.toString(list.get((int)i).tokenTypeId));
            String string7 = Expression.getLeftSpaces(string, Integer.toString(list.get((int)i).tokenLevel));
            String string8 = Expression.getLeftSpaces(string, Double.toString(list.get((int)i).tokenValue));
            String string9 = Expression.getLeftSpaces(string, list.get((int)i).looksLike);
            mXparser.consolePrintln("| " + string2 + " | " + string3 + " | " + string4 + " | " + string5 + " | " + string6 + " | " + string7 + " | " + string8 + " | " + string9 + " |");
        }
        mXparser.consolePrintln(" ---------------------------------------------------------------------------------------------------------------");
    }

    void showInitialTokens() {
        Expression.showTokens(this.initialTokens);
    }

    private void showArguments() {
        for (Argument argument : this.argumentsList) {
            boolean bl = argument.getVerboseMode();
            argument.setSilentMode();
            this.printSystemInfo(argument.getArgumentName() + " = " + argument.getArgumentValue() + "\n", true);
            if (!bl) continue;
            argument.setVerboseMode();
        }
    }

    private void printSystemInfo(String string, boolean bl) {
        if (bl) {
            mXparser.consolePrint("[" + this.description + "][" + this.expressionString + "] " + string);
        } else {
            mXparser.consolePrint(string);
        }
    }

    protected Expression clone() {
        Expression expression = new Expression(this);
        if (this.initialTokens != null && this.initialTokens.size() > 0) {
            expression.initialTokens = this.createInitialTokens(0, this.initialTokens.size() - 1, this.initialTokens);
        }
        return expression;
    }
}

