/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import java.util.List;
import org.mariuszgromada.math.mxparser.ArgumentExtension;
import org.mariuszgromada.math.mxparser.Constant;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.Function;
import org.mariuszgromada.math.mxparser.HeadEqBody;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import org.mariuszgromada.math.mxparser.mXparser;

public class Argument
extends PrimitiveElement {
    public static final boolean NO_SYNTAX_ERRORS = true;
    public static final boolean SYNTAX_ERROR_OR_STATUS_UNKNOWN = false;
    public static final double ARGUMENT_INITIAL_VALUE = Double.NaN;
    public static final int NOT_FOUND = -1;
    public static final int FREE_ARGUMENT = 1;
    public static final int DEPENDENT_ARGUMENT = 2;
    public static final int RECURSIVE_ARGUMENT = 3;
    public static final int TYPE_ID = 101;
    public static final String TYPE_DESC = "User defined argument";
    public static final int BODY_RUNTIME = 1;
    public static final int BODY_EXTENDED = 2;
    private int argumentBodyType;
    private ArgumentExtension argumentExtension;
    private String description;
    Expression argumentExpression;
    private String argumentName;
    int argumentType;
    double argumentValue;
    protected Argument n;

    public Argument(String string, PrimitiveElement ... primitiveElementArray) {
        super(101);
        if (mXparser.regexMatch(string, "([a-zA-Z_])+([a-zA-Z0-9_])*")) {
            this.argumentName = string;
            this.argumentValue = Double.NaN;
            this.argumentType = 1;
            this.argumentExpression = new Expression(primitiveElementArray);
        } else if (mXparser.regexMatch(string, "(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*=(\\s)*(.)+(\\s)*")) {
            HeadEqBody headEqBody = new HeadEqBody(string);
            this.argumentName = headEqBody.headTokens.get((int)0).tokenStr;
            Expression expression = new Expression(headEqBody.bodyStr, new PrimitiveElement[0]);
            double d = expression.calculate();
            if (expression.getSyntaxStatus() && d != Double.NaN) {
                this.argumentExpression = new Expression(new PrimitiveElement[0]);
                this.argumentValue = d;
                this.argumentType = 1;
            } else {
                this.argumentExpression = expression;
                this.addDefinitions(primitiveElementArray);
                this.argumentType = 2;
            }
        } else if (mXparser.regexMatch(string, "(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*(\\s)*\\(((\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*,(\\s)*)*(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*\\)(\\s)*=(\\s)*(.)+(\\s)*")) {
            HeadEqBody headEqBody = new HeadEqBody(string);
            this.argumentName = headEqBody.headTokens.get((int)0).tokenStr;
            this.argumentExpression = new Expression(headEqBody.bodyStr, primitiveElementArray);
            this.argumentExpression.setDescription(headEqBody.headStr);
            this.argumentValue = Double.NaN;
            this.argumentType = 2;
            this.n = new Argument(headEqBody.headTokens.get((int)2).tokenStr, new PrimitiveElement[0]);
        } else {
            this.argumentValue = Double.NaN;
            this.argumentType = 1;
            this.argumentExpression = new Expression(new PrimitiveElement[0]);
            this.argumentExpression.setSyntaxStatus(false, "[" + string + "] Invalid argument definition (patterns: 'x', 'x=5', 'x=5+3/2', 'x=2*y').");
        }
        this.argumentBodyType = 1;
        this.setSilentMode();
        this.description = "";
    }

    public Argument(String string, boolean bl, PrimitiveElement ... primitiveElementArray) {
        super(101);
        if (mXparser.regexMatch(string, "([a-zA-Z_])+([a-zA-Z0-9_])*")) {
            this.argumentName = string;
            this.argumentValue = Double.NaN;
            this.argumentType = 1;
            this.argumentExpression = new Expression(primitiveElementArray);
        } else if (mXparser.regexMatch(string, "(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*=(\\s)*(.)+(\\s)*")) {
            HeadEqBody headEqBody = new HeadEqBody(string);
            this.argumentName = headEqBody.headTokens.get((int)0).tokenStr;
            Expression expression = new Expression(headEqBody.bodyStr, new PrimitiveElement[0]);
            if (bl) {
                this.argumentExpression = expression;
                this.addDefinitions(primitiveElementArray);
                this.argumentType = 2;
            } else {
                double d = expression.calculate();
                if (expression.getSyntaxStatus() && d != Double.NaN) {
                    this.argumentExpression = new Expression(new PrimitiveElement[0]);
                    this.argumentValue = d;
                    this.argumentType = 1;
                } else {
                    this.argumentExpression = expression;
                    this.addDefinitions(primitiveElementArray);
                    this.argumentType = 2;
                }
            }
        } else if (mXparser.regexMatch(string, "(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*(\\s)*\\(((\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*,(\\s)*)*(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*\\)(\\s)*=(\\s)*(.)+(\\s)*")) {
            HeadEqBody headEqBody = new HeadEqBody(string);
            this.argumentName = headEqBody.headTokens.get((int)0).tokenStr;
            this.argumentExpression = new Expression(headEqBody.bodyStr, primitiveElementArray);
            this.argumentExpression.setDescription(headEqBody.headStr);
            this.argumentValue = Double.NaN;
            this.argumentType = 2;
            this.n = new Argument(headEqBody.headTokens.get((int)2).tokenStr, new PrimitiveElement[0]);
        } else {
            this.argumentValue = Double.NaN;
            this.argumentType = 1;
            this.argumentExpression = new Expression(new PrimitiveElement[0]);
            this.argumentExpression.setSyntaxStatus(false, "[" + string + "] Invalid argument definition (patterns: 'x', 'x=5', 'x=5+3/2', 'x=2*y').");
        }
        this.argumentBodyType = 1;
        this.setSilentMode();
        this.description = "";
    }

    public Argument(String string, double d) {
        super(101);
        this.argumentExpression = new Expression(new PrimitiveElement[0]);
        if (mXparser.regexMatch(string, "([a-zA-Z_])+([a-zA-Z0-9_])*")) {
            this.argumentName = new String(string);
            this.argumentValue = d;
            this.argumentType = 1;
        } else {
            this.argumentValue = Double.NaN;
            this.argumentExpression.setSyntaxStatus(false, "[" + string + "] Invalid argument name, pattern not match: " + "([a-zA-Z_])+([a-zA-Z0-9_])*");
        }
        this.argumentBodyType = 1;
        this.setSilentMode();
        this.description = "";
    }

    public Argument(String string, ArgumentExtension argumentExtension) {
        super(101);
        this.argumentExpression = new Expression(new PrimitiveElement[0]);
        if (mXparser.regexMatch(string, "([a-zA-Z_])+([a-zA-Z0-9_])*")) {
            this.argumentName = new String(string);
            this.argumentExtension = argumentExtension;
            this.argumentType = 1;
            this.argumentBodyType = 2;
        } else {
            this.argumentValue = Double.NaN;
            this.argumentExpression.setSyntaxStatus(false, "[" + string + "] Invalid argument name, pattern not match: " + "([a-zA-Z_])+([a-zA-Z0-9_])*");
            this.argumentBodyType = 1;
        }
        this.setSilentMode();
        this.description = "";
    }

    public Argument(String string, String string2, PrimitiveElement ... primitiveElementArray) {
        super(101);
        if (mXparser.regexMatch(string, "([a-zA-Z_])+([a-zA-Z0-9_])*")) {
            this.argumentName = new String(string);
            this.argumentValue = Double.NaN;
            this.argumentExpression = new Expression(string2, primitiveElementArray);
            this.argumentExpression.setDescription(string);
            this.argumentType = 2;
        } else {
            this.argumentValue = Double.NaN;
            this.argumentExpression = new Expression(new PrimitiveElement[0]);
            this.argumentExpression.setSyntaxStatus(false, "[" + string + "] Invalid argument name, pattern not match: " + "([a-zA-Z_])+([a-zA-Z0-9_])*");
        }
        this.argumentBodyType = 1;
        this.setSilentMode();
        this.description = "";
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setVerboseMode() {
        this.argumentExpression.setVerboseMode();
    }

    public void setSilentMode() {
        this.argumentExpression.setSilentMode();
    }

    public boolean getVerboseMode() {
        return this.argumentExpression.getVerboseMode();
    }

    public boolean getRecursiveMode() {
        return this.argumentExpression.getRecursiveMode();
    }

    public double getComputingTime() {
        return this.argumentExpression.getComputingTime();
    }

    public void setArgumentName(String string) {
        if (mXparser.regexMatch(string, "([a-zA-Z_])+([a-zA-Z0-9_])*")) {
            this.argumentName = string;
            this.setExpressionModifiedFlags();
        } else if (this.argumentExpression != null) {
            this.argumentExpression.setSyntaxStatus(false, "[" + string + "] Invalid argument name, pattern not match: " + "([a-zA-Z_])+([a-zA-Z0-9_])*");
        }
    }

    public void setArgumentExpressionString(String string) {
        this.argumentExpression.setExpressionString(string);
        if (this.argumentType == 1) {
            this.argumentType = 2;
        }
        this.argumentBodyType = 1;
    }

    public String getArgumentName() {
        return this.argumentName;
    }

    public String getArgumentExpressionString() {
        return this.argumentExpression.getExpressionString();
    }

    public int getArgumentType() {
        return this.argumentType;
    }

    public void setArgumentValue(double d) {
        if (this.argumentType == 2) {
            this.argumentType = 1;
            this.argumentExpression.setExpressionString("");
        }
        this.argumentBodyType = 1;
        this.argumentValue = d;
    }

    public int getArgumentBodyType() {
        return this.argumentBodyType;
    }

    public boolean checkSyntax() {
        if (this.argumentBodyType == 2) {
            return true;
        }
        if (this.argumentType == 1) {
            return true;
        }
        return this.argumentExpression.checkSyntax();
    }

    public String getErrorMessage() {
        return this.argumentExpression.getErrorMessage();
    }

    public double getArgumentValue() {
        if (this.argumentBodyType == 2) {
            return this.argumentExtension.getArgumentValue();
        }
        if (this.argumentType == 1) {
            return this.argumentValue;
        }
        return this.argumentExpression.calculate();
    }

    public void addDefinitions(PrimitiveElement ... primitiveElementArray) {
        this.argumentExpression.addDefinitions(primitiveElementArray);
    }

    public void removeDefinitions(PrimitiveElement ... primitiveElementArray) {
        this.argumentExpression.removeDefinitions(primitiveElementArray);
    }

    public void addArguments(Argument ... argumentArray) {
        this.argumentExpression.addArguments(argumentArray);
    }

    public void defineArguments(String ... stringArray) {
        this.argumentExpression.defineArguments(stringArray);
    }

    public void defineArgument(String string, double d) {
        this.argumentExpression.defineArgument(string, d);
    }

    public int getArgumentIndex(String string) {
        return this.argumentExpression.getArgumentIndex(string);
    }

    public Argument getArgument(String string) {
        return this.argumentExpression.getArgument(string);
    }

    public Argument getArgument(int n) {
        return this.argumentExpression.getArgument(n);
    }

    public int getArgumentsNumber() {
        return this.argumentExpression.getArgumentsNumber();
    }

    public void removeArguments(String ... stringArray) {
        this.argumentExpression.removeArguments(stringArray);
    }

    public void removeArguments(Argument ... argumentArray) {
        this.argumentExpression.removeArguments(argumentArray);
    }

    public void removeAllArguments() {
        this.argumentExpression.removeAllArguments();
    }

    public void addConstants(Constant ... constantArray) {
        this.argumentExpression.addConstants(constantArray);
    }

    public void addConstants(List<Constant> list) {
        this.argumentExpression.addConstants(list);
    }

    public void defineConstant(String string, double d) {
        this.argumentExpression.defineConstant(string, d);
    }

    public int getConstantIndex(String string) {
        return this.argumentExpression.getConstantIndex(string);
    }

    public Constant getConstant(String string) {
        return this.argumentExpression.getConstant(string);
    }

    public Constant getConstant(int n) {
        return this.argumentExpression.getConstant(n);
    }

    public int getConstantsNumber() {
        return this.argumentExpression.getConstantsNumber();
    }

    public void removeConstants(String ... stringArray) {
        this.argumentExpression.removeConstants(stringArray);
    }

    public void removeConstants(Constant ... constantArray) {
        this.argumentExpression.removeConstants(constantArray);
    }

    public void removeAllConstants() {
        this.argumentExpression.removeAllConstants();
    }

    public void addFunctions(Function ... functionArray) {
        this.argumentExpression.addFunctions(functionArray);
    }

    public void defineFunction(String string, String string2, String ... stringArray) {
        this.argumentExpression.defineFunction(string, string2, stringArray);
    }

    public int getFunctionIndex(String string) {
        return this.argumentExpression.getFunctionIndex(string);
    }

    public Function getFunction(String string) {
        return this.argumentExpression.getFunction(string);
    }

    public Function getFunction(int n) {
        return this.argumentExpression.getFunction(n);
    }

    public int getFunctionsNumber() {
        return this.argumentExpression.getFunctionsNumber();
    }

    public void removeFunctions(String ... stringArray) {
        this.argumentExpression.removeFunctions(stringArray);
    }

    public void removeFunctions(Function ... functionArray) {
        this.argumentExpression.removeFunctions(functionArray);
    }

    public void removeAllFunctions() {
        this.argumentExpression.removeAllFunctions();
    }

    void addRelatedExpression(Expression expression) {
        this.argumentExpression.addRelatedExpression(expression);
    }

    void removeRelatedExpression(Expression expression) {
        this.argumentExpression.removeRelatedExpression(expression);
    }

    void setExpressionModifiedFlags() {
        this.argumentExpression.setExpressionModifiedFlag();
    }

    public Argument clone() {
        Argument argument = new Argument(this.argumentName, new PrimitiveElement[0]);
        argument.argumentExpression = this.argumentExpression;
        argument.argumentType = this.argumentType;
        argument.argumentBodyType = this.argumentBodyType;
        argument.argumentValue = this.argumentValue;
        argument.description = this.description;
        argument.n = this.n;
        argument.argumentExtension = this.argumentExtension != null ? this.argumentExtension.clone() : null;
        return argument;
    }
}

