import tkinter as tk

from TooltipableMenu import TooltipableMenu
from Model import Model
from menu_help_texts import menu_help


class ModelsMenu(TooltipableMenu):
    def __init__(self, parent, thoughttree, label):
        super().__init__(parent, label, menu_help=menu_help)
        self.ui = thoughttree

        self.fixed_model_menu_items = -1

        self.selected_model = tk.StringVar()
        def on_model_selected(name, index, mode):
            self.ui.set_model(self.selected_model.get())
        self.selected_model.trace_add("write", on_model_selected)


    def load_available_models(self, event=None):
        Model.set_api_key()

        models = self.ui.model.get_available_models()
        models = [model for model in models if "instruct" not in model]
        for i, name in enumerate(models):
            key = None
            if name == "gpt-4":
                key = "<Control-Key-4>"
            elif name == "gpt-3.5-turbo":
                key = "<Control-Key-3>"
            if name.find("gpt-3.5") != -1:
                name = "ChatGPT " + name
            command = lambda e=None, model=name: self.selected_model.set(model)
            self.item(name, key, command)#, variable=self.selected_model, to=self.ui.root)
        self.separator()
        self.item("Reload Available Models", None, self.load_available_models)
        return len(models)
