const defaultTheme = {
  // COLORS
  colors: {
    black: '#14141A',
    white: '#FFFFFF',
    background: '#39393F',
    infoSuccess: '#17CE55',
    infoInformation: '#1930E5',
    infoWarning: '#F09E00',
    infoError: '#E52222',
    transparent: 'transparent',
    blue: {
      300: '#D1DBF4',
      400: '#3E44FE',
      600: '#3D74f4',
    },
    purple: {
      25: '#FDFAFF',
      50: '#F4E5FF',
      100: '#EACCFF',
      200: '#D599FF',
      300: '#BF66FF',
      400: '#AA33FF',
      500: '#8829CC',
      600: '#6E21A6',
      700: '#551980',
      800: '#3B1259',
      900: '#220A33',
    },
    primary: {
      25: '#FDFAFF',
      50: '#F4E5FF',
      100: '#EACCFF',
      200: '#D599FF',
      300: '#BF66FF',
      400: '#AA33FF',
      500: '#8829CC',
      600: '#6E21A6',
      700: '#551980',
      800: '#3B1259',
      900: '#220A33',
    },
    secondary: {
      100: '#FCFDFF',
      200: '#F3F6FC',
      300: '#D1DBF4',
      400: '#93B0F4',
      500: '#628EF4',
      600: '#3D74F4',
      700: '#185AF4',
      800: '#003DCC',
      900: '#002E99',
    },
    red: {
      400: '#E65050',
      500: '#D92626',
      600: '#B31212',
    },
    grey: {
      25: '#FCFCFF',
      50: '#F0F0F2',
      100: '#E0E0E5',
      200: '#BBBBBF',
      300: '#959599',
      400: '#7C7C80',
      500: '#6A6A6D',
      600: '#535359',
      700: '#404047',
      800: '#292930',
      900: '#14141A',
    },
    success: {
      25: '#FAFFFB',
      50: '#EDFAF0',
      100: '#D0F5D8',
      200: '#A6EDB6',
      300: '#7EE595',
      400: '#57D974',
      500: '#29CC4D',
      600: '#179934',
      700: '#0A661E',
      800: '#044D14',
      900: '#00330B',
    },
  },
  avatars: [
    '#737D99',
    '#B373FF',
    '#628EF4',
    '#47D8B5',
    '#F3A052',
    '#E470CB',
    '#FAC819',
    '#E65858',
    '#9ADA32',
    '#4DE3E3',
    '#48AAE1',
    '#E05B83',
  ],
  // SHADOWS
  shadowColor: '#616161', // mobile only
  shadowOffsetWidth: 0, // mobile only
  shadowOffsetHeight: 4, // mobile only
  shadowOpacity: 0.18, // mobile only
  shadowRadius: 8, // mobile only
  shadowElevation: 3, // mobile only
  // FONTS
  fontFamily: 'Roboto',
  // BORDERS
  borderRadius: 6,
  // SPACES
  spaces: {
    xxxs: 2,
    xxs: 4,
    xs: 8,
    s: 16,
    m: 24,
    l: 32,
    xl: 40,
    xxl: 48,
    xxxl: 56,
    xxxxl: 64,
  },
};

export default defaultTheme;
