import type { CustomThemes } from './types';

const customThemes: CustomThemes = {
  'Dark Graphite': {
    // COLORS
    colors: {
      black: '#14141A',
      white: '#FFFFFF',
      background: '#1D1F26',
      infoSuccess: '#15D840',
      infoInformation: '#1930E5',
      infoWarning: '#FCB91A',
      infoError: '#E52222',
      purple: {
        25: '#FDFAFF',
        50: '#F4E5FF',
        100: '#EACCFF',
        200: '#D599FF',
        300: '#BF66FF',
        400: '#AA33FF',
        500: '#8829CC',
        600: '#6E21A6',
        700: '#551980',
        800: '#3B1259',
        900: '#220A33',
      },
      primary: {
        25: '#FDFAFF',
        50: '#F4E5FF',
        100: '#EACCFF',
        200: '#D599FF',
        300: '#BF66FF',
        400: '#AA33FF',
        500: '#8829CC',
        600: '#6E21A6',
        700: '#551980',
        800: '#3B1259',
        900: '#220A33',
      },
      secondary: {
        100: '#FCFDFF',
        200: '#F3F6FC',
        300: '#D1DBF4',
        400: '#93B0F5',
        500: '#628EF4',
        600: '#3D74F4',
        700: '#185AF4',
        800: '#003DCC',
        900: '#002E99',
      },
      red: {
        400: '#E65050',
        500: '#D92626',
      },
      grey: {
        25: '#FCFCFF',
        50: '#F0F0F2',
        100: '#E0E0E5',
        200: '#BBBBBF',
        300: '#959599',
        400: '#7C7C80',
        500: '#6A6A6D',
        600: '#535359',
        700: '#404047',
        800: '#292930',
        900: '#14141A',
      },
    },
    // SHADOWS
    shadowColor: '#616161', // mobile only
    shadowOffsetWidth: 0, // mobile only
    shadowOffsetHeight: 4, // mobile only
    shadowOpacity: 0.18, // mobile only
    shadowRadius: 8, // mobile only
    shadowElevation: 3, // mobile only
    // FONTS
    fontFamily: 'Roboto',
    // BORDERS
    borderRadius: 6,
  },
  'Cobalt Blue': {
    // COLORS
    colors: {
      black: '#000000',
      white: '#FFFFFF',
      background: '#0047AB',
      infoSuccess: '#17CE55',
      infoInformation: '#1930E5',
      infoWarning: '#F09E00',
      infoError: '#E31A1A',
      primary: {
        100: '#F1E6FF',
        200: '#DCBFFF',
        300: '#C799FF',
        400: '#123BBB',
        500: '#9E4DFF',
        600: '#8926FF',
        700: '#7400FF',
        800: '#5D00CC',
        900: '#460099',
      },
      secondary: {
        100: '#FCFDFF',
        200: '#F3F6FC',
        300: '#D1DBF4',
        400: '#939911',
        500: '#628EF4',
        600: '#3D74F4',
        700: '#185AF4',
        800: '#003DCC',
        900: '#002E99',
      },
      red: {
        400: '#E65050',
        500: '#D92626',
      },
      grey: {
        100: '#E6E9F2',
        200: '#CFD5E6',
        300: '#ADB6CC',
        400: '#8F99B3',
        500: '#737D99',
        600: '#606980',
        700: '#4D5466',
        800: '#393F4D',
        900: '#262A33',
      },
    },
    // SHADOWS
    shadowColor: '#616161', // mobile only
    shadowOffsetWidth: 0, // mobile only
    shadowOffsetHeight: 4, // mobile only
    shadowOpacity: 0.18, // mobile only
    shadowRadius: 8, // mobile only
    shadowElevation: 3, // mobile only
    // FONTS
    fontFamily: 'Roboto',
    // BORDERS
    borderRadius: 6,
  },
  'Deep Purple': {
    // COLORS
    colors: {
      black: '#000000',
      white: '#FFFFFF',
      background: '#570861',
      infoSuccess: '#17CE55',
      infoInformation: '#1930E5',
      infoWarning: '#F09E00',
      infoError: '#E31A1A',
      primary: {
        100: '#F1E6FF',
        200: '#DCBFFF',
        300: '#C799FF',
        400: '#B373FF',
        500: '#9E4DFF',
        600: '#8926FF',
        700: '#7400FF',
        800: '#5D00CC',
        900: '#460099',
      },
      secondary: {
        100: '#FCFDFF',
        200: '#F3F6FC',
        300: '#D1DBF4',
        400: '#93B0F4',
        500: '#628EF4',
        600: '#3D74F4',
        700: '#185AF4',
        800: '#003DCC',
        900: '#002E99',
      },
      red: {
        400: '#E65050',
        500: '#D92626',
      },
      grey: {
        100: '#E6E9F2',
        200: '#CFD5E6',
        300: '#ADB6CC',
        400: '#8F99B3',
        500: '#737D99',
        600: '#606980',
        700: '#4D5466',
        800: '#393F4D',
        900: '#262A33',
      },
    },
    // SHADOWS
    shadowColor: '#616161', // mobile only
    shadowOffsetWidth: 0, // mobile only
    shadowOffsetHeight: 4, // mobile only
    shadowOpacity: 0.18, // mobile only
    shadowRadius: 8, // mobile only
    shadowElevation: 3, // mobile only
    // FONTS
    fontFamily: 'Roboto',
    // BORDERS
    borderRadius: 6,
  },
};

export default customThemes;
