# Welcome to PytorchAutoDrive Contributor Guide

We welcome **Pull Requests** to fix bugs, update docs or implement new features etc. We also welcome **Issues** to report problems and needs, or ask questions (since your question might be more common and helpful to the community than you presume). The maintainers will respond to all PR or Issues within 24 hours.

## Where Should I Pick Up Works?

Search for issues with [help wanted](https://github.com/voldemortX/pytorch-auto-drive/issues?q=is%3Aissue+label%3A%22help+wanted%22+) or [good first issue](https://github.com/voldemortX/pytorch-auto-drive/issues?q=is%3Aissue+label%3A%22good+first+issue%22) marks, or improve the code/doc based on your user experience. Contact Zhengyang Feng (zyfeng97@outlook.com) for in-depth collaborations.

## Micro Plans

See our **RoadMap** #4 for quarterly iteration plans.

## Macro Plans

This repository implements (or plan to implement) the following interesting papers in a unified PyTorch framework:

[Fully Convolutional Networks for Semantic Segmentation](https://arxiv.org/abs/1605.06211) CVPR 2015

[DeepLab: Semantic Image Segmentation with Deep Convolutional Nets, Atrous Convolution, and Fully Connected CRFs](https://arxiv.org/abs/1606.00915) TPAMI 2017

[Rethinking Atrous Convolution for Semantic Image Segmentation](https://arxiv.org/abs/1706.05587) ArXiv preprint 2017

[ENet: A Deep Neural Network Architecture for Real-Time Semantic Segmentation](https://arxiv.org/abs/1606.02147) ArXiv preprint 2016 

[ERFNet: Efficient Residual Factorized ConvNet for Real-Time Semantic Segmentation](https://ieeexplore.ieee.org/abstract/document/8063438/) ITS 2017

[Spatial As Deep: Spatial CNN for Traffic Scene Understanding](https://arxiv.org/abs/1712.06080) AAAI 2018

[RESA: Recurrent Feature-Shift Aggregator for Lane Detection](https://arxiv.org/abs/2008.13719) AAAI 2021

[Polynomial Regression Network for Variable-Number Lane Detection](http://www.ecva.net/papers/eccv_2020/papers_ECCV/papers/123630698.pdf) ECCV 2020

[End-to-end Lane Shape Prediction with Transformers](https://arxiv.org/abs/2011.04233) WACV 2021

[Keep Your Eyes on The Lane: Real-Time Attention-Guided Lane Detection](https://arxiv.org/abs/2010.12035) CVPR 2021

[Rethinking Efficient Lane Detection via Curve Modeling](https://arxiv.org/abs/2203.02431) CVPR 2022

You are also welcomed to make additions on this paper list, or open-source your related works here.
