#!/usr/bin/env bash
# Copyright 2019-2024 VMware, Inc.
# SPDX-License-Identifier: Apache-2.0

##############################################################################################################
# Extract key results from the reports generated by ...
#   "INSIDER Static Application Security Testing" (SAST) - https://github.com/insidersec/insider & https://insidersec.io/
##############################################################################################################

# ----- Please adjust

# ------ Do not modify
VERSION=${INSIDER_VERSION}
STEP=$(get_step)
SEPARATOR=","
APP_DIR_OUT="${REPORTS_DIR}/${STEP}__INSIDER"
RESULT_FILE="${APP_DIR_OUT}/_results_extracted.csv"
export LOG_FILE="${APP_DIR_OUT}.log"
APP_LIST="${REPORTS_DIR}/00__Weave/list__all_apps.txt"

function generate_csv() {
	echo "Applications${SEPARATOR}Insider SAST vulns" >"${RESULT_FILE}"
	while read -r FILE; do
		APP="$(basename "${FILE}")"
		log_extract_message "app '${APP}'"
		JSON_IN="${APP_DIR_OUT}/${APP}_report.json"
		INSIDER_OUTPUT_STATS="${APP_DIR_OUT}/${APP}_insider.stats"
		VULNS="n/a"
		if [ -f "${JSON_IN}" ]; then
			VULNS="0"
			set +e
			local COUNT_VULNS=$(jq ".total" "${JSON_IN}")
			[ -n "${COUNT_VULNS}" ] && VULNS=${COUNT_VULNS}
			if [[ "${OWASP_ACTIVE}" == "true" ||
				"${SCANCODE_ACTIVE}" == "true" ||
				"${FSB_ACTIVE}" == "true" ||
				"${SLSCAN_ACTIVE}" == "true" ||
				"${TRIVY_ACTIVE}" == "true" ||
				"${GRYPE_ACTIVE}" == "true" ||
				"${OSV_ACTIVE}" == "true" ||
				"${BEARER_ACTIVE}" == "true" ]]; then
				HAS_ANOTHER_SECURITY_REPORT='TRUE'
			else
				HAS_ANOTHER_SECURITY_REPORT=''
			fi
			{
				echo "INSIDER__VULNS_ALL=${VULNS}"
				echo "INSIDER__VULNS_LOW=$(jq '.low' ${JSON_IN})"
				echo "INSIDER__VULNS_MEDIUM=$(jq '.medium' ${JSON_IN})"
				echo "INSIDER__VULNS_HIGH=$(jq '.high' ${JSON_IN})"
				echo "INSIDER__VULNS_CRITICAL=$(jq '.critical' ${JSON_IN})"
				echo "HAS_ANOTHER_SECURITY_REPORT=${HAS_ANOTHER_SECURITY_REPORT}"
			} >"${INSIDER_OUTPUT_STATS}"
			set -e
		fi
		echo "${APP}${SEPARATOR}${VULNS}" >>"${RESULT_FILE}"
	done <"${APP_LIST}"
	log_console_success "Results: ${RESULT_FILE}"
}

function main() {
	if [[ -d "${APP_DIR_OUT}" ]]; then
		generate_csv
	else
		LOG_FILE=/dev/null
		log_console_error "INSIDER result directory does not exist: ${APP_DIR_OUT}"
	fi
}

main
