#!/usr/bin/env bash
# Copyright 2019-2024 VMware, Inc.
# SPDX-License-Identifier: Apache-2.0

##############################################################################################################
# Extract key results from the report files generated by ...
#   "ScanCode toolkit" - https://github.com/nexB/scancode-toolkit
##############################################################################################################

# ----- Please adjust

# ------ Do not modify
SEPARATOR=","
VERSION=${SCANCODE_VERSION}
STEP=$(get_step)
export APP_DIR_OUT="${REPORTS_DIR}/${STEP}__SCANCODE"
export LOG_FILE=${APP_DIR_OUT}.log
RESULT_FILE="${APP_DIR_OUT}/_results_extracted.csv"

function extract() {
	echo "Applications${SEPARATOR}ScanCode licenses${SEPARATOR}ScanCode copyrights" >"${RESULT_FILE}"
	while read -r APP; do
		APP_NAME=$(basename "${APP}")
		log_extract_message "app '${APP_NAME}'"

		declare COUNT_LICENSES COUNT_COPYRIGHTS
		COUNT_LICENSES='n/a'
		COUNT_COPYRIGHTS='n/a'

		OUTPUT_DATA_JS="${APP_DIR_OUT}/${APP_NAME}/index_files/data.js"
		if [[ -f "${OUTPUT_DATA_JS}" ]]; then
			# Heavy couting the found licences and ...
			COUNT_LICENSES=$(tail -c +6 "${OUTPUT_DATA_JS}" | jq '.[] | .license_detections | length ' | awk '{s+=$1} END {print s}')
			COUNT_COPYRIGHTS=$(tail -c +6 "${OUTPUT_DATA_JS}" | jq '.[] | .copyrights | length ' | awk '{s+=$1} END {print s}')
		fi
		echo "${APP_NAME}${SEPARATOR}${COUNT_LICENSES}${SEPARATOR}${COUNT_COPYRIGHTS}" >>"${RESULT_FILE}"
	done <"${REPORTS_DIR}/00__Weave/list__all_apps.txt"
}

function main() {
	if [[ -d "${APP_DIR_OUT}" ]]; then
		extract
	else
		LOG_FILE=/dev/null
		log_console_error "Scancode result directory does not exist: ${APP_DIR_OUT}"
	fi
}

main
