#!/usr/bin/env bash
# Copyright 2019-2024 VMware, Inc.
# SPDX-License-Identifier: Apache-2.0

##############################################################################################################
# Extract key results from the database file generated by ...
#	"Cloud Suitability Analyzer" - https://github.com/vmware-tanzu/cloud-suitability-analyzer
##############################################################################################################

STEP=$(get_step)
SEPARATOR=","
S="${SEPARATOR}"
APP_DIR_OUT="${REPORTS_DIR}/${STEP}__CSA"
DB_LOCATION="${APP_DIR_OUT}/db/csa.db"
MISSING_FILE="${APP_DIR_OUT}/results_missing.csv"
RESULT_BAGGER_FILE_NAME=results_extracted_bagger.csv
RESULT_BAGGER_FILE="${APP_DIR_OUT}/${RESULT_BAGGER_FILE_NAME}"
RESULT_FILE="${APP_DIR_OUT}/_results_extracted.csv"

export LOG_FILE=/dev/null

function check_missing_apps() {
	while read -r FILE; do
		APP="$(basename "${FILE}")"
		if [[ -f "${RESULT_BAGGER_FILE}" ]]; then
			if ! grep -q "${APP_GROUP}${S}${APP}${S}" "${RESULT_BAGGER_FILE}"; then
				echo "${APP_GROUP}${S}${APP}${S}${APP}${S}n/a${S}${S}${S}${S}${S}${S}${S}${S}${S}${S}${S}${S}${S}${S}${S}${S}${S}" >>"${MISSING_FILE}"
			fi
		else
			echo "${APP_GROUP}${S}${APP}${S}${APP}${S}n/a${S}${S}${S}${S}${S}${S}${S}${S}${S}${S}${S}${S}${S}${S}${S}${S}${S}" >>"${MISSING_FILE}"
		fi
	done <"${REPORTS_DIR}/00__Weave/list__all_apps.txt"
}

function main() {
	if [[ -n $(${CONTAINER_ENGINE} images -q "${CONTAINER_IMAGE_NAME_CSA_BAGGER}") ]]; then
		# Extract results using bagger
		rm -f "${RESULT_BAGGER_FILE}"
		if [[ -f "${DB_LOCATION}" ]]; then
			set +e
			${CONTAINER_ENGINE} run --rm -v "${APP_DIR_OUT}:/output" "${CONTAINER_IMAGE_NAME_CSA_BAGGER}" "/output/db/csa.db" "/output/${RESULT_BAGGER_FILE_NAME}" "${S}" 2> >(grep -v "^SLF4J")
			set -e
		else
			log_console_error "CSA database file does not exist: ${DB_LOCATION}"
			exit
		fi
	else
		log_console_error "CSA result extraction canceled. Container image unavailable: '${CONTAINER_IMAGE_NAME_CSA_BAGGER}'"
	fi

	# Check missing entries
	rm -f "${MISSING_FILE}"
	check_missing_apps

	# Add missing entries
	touch "${RESULT_BAGGER_FILE}" "${MISSING_FILE}"
	cat "${RESULT_BAGGER_FILE}" "${MISSING_FILE}" | sort -f | uniq >"${RESULT_FILE}"
}

main
