# Awesome Hacking Tools

**A collection of awesome lists for hackers, pentesters & security researchers.**

A curated list of awesome Hacking Tools. Your contributions are always welcome !

### Awesome Repositories
Repository | Description
---- | ----
[Awesome Malware Analysis](https://github.com/rshipp/awesome-malware-analysis) | A curated list of awesome malware analysis tools and resources
[Awesome-Hacking](https://github.com/Hack-with-Github/Awesome-Hacking) | A collection of various awesome lists for hackers, pentesters and security researchers
[Awesome-osint](https://github.com/jivoi/awesome-osint) | A curated list of amazingly awesome OSINT
[Code examples for Penetration Testing](https://github.com/dreddsa5dies/goHackTools) | this is The CODE, but very simple and light. No VIDEO/AUDIO/TEXT lectures
[fuzzdb](https://github.com/fuzzdb-project/fuzzdb) | Dictionary of attack patterns and primitives for black-box application fault injection and resource discovery.
[HUNT Proxy Extension](https://github.com/bugcrowd/HUNT) | Identify common parameters vulnerable to certain vulnerability classes (HUNT Scanner, availible for Burp Suite PRO and ZAProxy). Organize testing methodologies (currently avalible only inside of Burp Suite).
[List of Sec talks/videos](https://github.com/PaulSec/awesome-sec-talks) | A curated list of awesome Security talks
[Scanners-Box](https://github.com/We5ter/Scanners-Box)  | The toolbox of open source scanners
[SecLists](https://github.com/danielmiessler/SecLists) | It is a collection of multiple types of lists used during security assessments
[Xerosploit](https://github.com/LionSec/xerosploit)   |     Efficient and advanced man in the middle framework
[ctf-tools](https://github.com/zardus/ctf-tools) | Some setup scripts for security research tools. 
[PENTEST-WIKI](https://github.com/nixawk/pentest-wiki) | PENTEST-WIKI is a free online security knowledge library for pentesters / researchers. If you have a good idea, please share it with others.


### Awesome custom projects / Scripts
Name | Description
---- | ----
[mimikatz](https://github.com/gentilkiwi/mimikatz) | A useful tool to play with Windows security including extracting plaintext passwords, kerberos tickets, etc.
[LAZY script v2.1.3](https://github.com/arismelachroinos/lscript) |  The LAZY script will make your life easier, and of course faster.
[XSStrike](https://github.com/UltimateHackers/XSStrike)  | XSStrike is a program which can fuzz and bruteforce parameters for XSS. It can also detect and bypass WAFs.
[SubFinder](https://github.com/subfinder/subfinder) | Subdomain discovery tool for use on web application engagements. SubFinder is a subdomain discovery tool that discovers valid subdomains for any target using passive online sources.
[VHostScan](https://github.com/codingo/VHostScan) | A virtual host scanner that performs reverse lookups, can be used with pivot tools, detect catch-all scenarios, aliases and dynamic default pages.
[PhpSploit](https://github.com/nil0x42/phpsploit) | Full-featured C2 framework which silently persists on webserver via evil PHP oneliner, with a complete asrenal of post-exploitation & privesc features.



### Exploitation tools
Name | Description
---- | ----
[BeEF](http://beefproject.com/) | Browser Exploitation Framework (Beef)
[Core Impact](https://www.coresecurity.com/core-impact) | Core Impact provides vulnerability assessment and penetration security testing throughout your organization.
[Metasploit](https://www.metasploit.com/) | The world’s most used penetration testing framework

### Linux Security Tools
Name | Description
---- | ----
[DefenseMatrix](https://github.com/K4YT3X/DefenseMatrix) | Full security solution for Linux Servers 
[Kernelpop](https://github.com/spencerdodd/kernelpop) | kernel privilege escalation enumeration and exploitation framework 
[Lynis](https://github.com/CISOfy/lynis) | Security auditing tool for Linux, macOS, and UNIX-based systems.
[linux-explorer](https://github.com/intezer/linux-explorer) | Easy-to-use live forensics toolbox for Linux endpoints
[Katoolin](https://github.com/LionSec/katoolin) | Automatically install all Kali linux tools in distros like Ubuntu 


### Exploit Databases
Name | Description
---- | ----
[0day](http://0day.today/) | Inj3ct0r is the ultimate database of exploits and vulnerabilities and a great resource for vulnerability researchers and security professionals. 
[cxsecurity](http://cxsecurity.com/exploit) | Exploit Database
[exploit-db](https://www.exploit-db.com/) | Exploits Database by Offensive Security
[iedb](http://iedb.ir/) | Iranian Exploit DataBase
[rapid7](https://rapid7.com/db) | Vulnerability & Exploit Database - Rapid7

### Malware Analysis
Name    |    Description
----    |    ----
[malice.io](https://github.com/maliceio/malice) | Open source version of VirusTotal that anyone can use at any scale from an independent researcher to a fortune 500 company.

### MITM tools
Name | Description
---- | ----
[BetterCAP](https://www.bettercap.org/) | MITM attacks against a network, manipulate HTTP, HTTPS and TCP traffic in realtime, sniff for credentials and much more.
[Burp Suite](https://portswigger.net/burp) | GUI based tool for testing Web application security.
[Ettercap](https://ettercap.github.io/ettercap/) | Ettercap is a comprehensive suite for man in the middle attacks
[Evilginx](https://github.com/kgretzky/evilginx) | Man-in-the-middle attack framework used for phishing credentials and session cookies of any web service. 
[MITMf](https://github.com/byt3bl33d3r/MITMf) | Framework for Man-In-The-Middle attacks
[mitmproxy](https://mitmproxy.org/) | An interactive console program that allows traffic flows to be intercepted, inspected, modified and replayed

### SQL Injection
Name | Description
---- | ----
[SQLmap](http://sqlmap.org/) | Automatic SQL injection and database takeover tool
[SQLninja](http://sqlninja.sourceforge.net/) | SQL Server injection & takeover tool
[SQLiv](https://github.com/Hadesy2k/sqliv) | Massive SQL injection scanner

### Post explotation
Name | Description
---- | ----
[Portia](https://github.com/SpiderLabs/portia) | Portia aims to automate a number of techniques commonly performed on internal network penetration tests after a low privileged account has been compromised.
[RSPET](https://github.com/panagiks/RSPET) | RSPET (Reverse Shell and Post Exploitation Tool) is a Python based reverse shell equipped with functionalities that assist in a post exploitation scenario.


### Search Engine for Penetration Tester
Name | Description
---- | ----
[Spyse](https://spyse.com/) | Spyse collects valuable data from all open source internet and stores it in its own database to provide instant access to the data. 
[Censys](https://www.censys.io/) | Censys continually monitors every reachable server and device on the Internet, so you can search for and analyze them in real time
[Shodan](http://shodan.io/) | Shodan is the world's first search engine for Internet-connected devices.
[WiGLE](https://wigle.net/index) | Maps and database of 802.11 wireless networks, with statistics, submitted by wardrivers, netstumblers, and net huggers.
[Zoomeye](https://www.zoomeye.org/) | search engine for cyberspace that lets the user find specific network components(ip, services, etc.)
### Security Information and Event Management (SIEM)
Name | Description
---- | ----
[OSSIM](https://www.alienvault.com/products/ossim) | AlienVault’s Open Source Security Information and Event Management (SIEM) product

### Network Scanning Tools
Name | Description
---- | ----
[NMAP](https://nmap.org/) | The industry standard in network/port scanning.  Widely used.
[Wireshark](https://www.wireshark.org/) | A versatile and feature-packed packet sniffing/analysis tool.  

### Source Code Analysis Tools
Name | Description
---- | ----
[pyup](https://pyup.io/) | Automated Security and Dependency Updates
[RIPS](https://www.ripstech.com/) | PHP Security Analysis
[Retire.js](http://retirejs.github.io/retire.js/) | detecting the use of JavaScript libraries with known vulnerabilities
[Snyk](https://snyk.io/) | find & fix vulnerabilities in dependencies, supports various languages

### Binary Analysis Tools
Name | Description
---- | ----
[BinNavi](https://github.com/google/binnavi) | BinNavi is a binary analysis IDE that allows to inspect, navigate, edit and annotate control flow graphs and call graphs of disassembled code
[Radare2](https://github.com/radare/radare2) | Radare2 is a reverse engineering suite which includes a complete toolkit for reverse enigneering needs. 

### Privilege Escalation
Name | Description
---- | ----
[LinEnum](https://github.com/rebootuser/LinEnum) | Scripted Local Linux Enumeration & Privilege Escalation Checks
[PEASS](https://github.com/carlospolop/privilege-escalation-awesome-scripts-suite) | Privilege Escalation tools for Windows and Linux/Unix
[CVE-2017-5123](https://github.com/nongiach/CVE/blob/master/CVE-2017-5123/README.md) | Linux Kernel 4.14.0-rc4+ - 'waitid()' Local Privilege Escalation
[Oracle Privilege Escalation via Deserialization](http://obtruse.syfrtext.com/2018/07/oracle-privilege-escalation-via.html) | CVE-2018-3004 Oracle Privilege Escalation via Deserialization
[linux-exploit-suggester](https://github.com/mzet-/linux-exploit-suggester) | The tool is meant to assist the security analyst in his testing for privilege escalation opportunities on Linux machine
[BeRoot Project](https://github.com/AlessandroZ/BeRoot) | BeRoot Project is a post exploitation tool to check common misconfigurations to find a way to escalate our privilege.
[yodo: Local Privilege Escalation](https://securityonline.info/yodo-local-privilege-escalation/) | yodo proves how easy it is to become root via limited sudo permissions, via dirty COW or using Pa(th)zuzu.

### Collaboration tools
Name | Description
---- | ----
[Dradis](https://dradisframework.com/ce/) | Open-source reporting and collaboration tool for InfoSec professionals
