if(TRANSLATIONS_ONLY)
    return()
endif()

# Look for some dependencies using CMake scripts
find_package(ZLIB REQUIRED)

set(OpenGL_GL_PREFERENCE GLVND)

if(CMAKE_SYSTEM_NAME STREQUAL FreeBSD)
    set(OpenGL_GL_PREFERENCE LEGACY)
endif()

find_package(OpenGL REQUIRED)
find_package(SDL2   REQUIRED)

# Add libsamplerate to SDL2 with vcpkg
unset(SDL2_LIBRARY_TEMP)
if(CMAKE_TOOLCHAIN_FILE MATCHES "vcpkg")
    if(WIN32)
        unset(arch_suffix)
        unset(path_prefix)
        if(VCPKG_TARGET_TRIPLET MATCHES -static)
            set(arch_suffix  -static)
        endif()
        if(CMAKE_BUILD_TYPE STREQUAL "Debug")
            set(path_prefix debug)
        endif()
        set(installed_prefix ${_VCPKG_INSTALLED_DIR}/${WINARCH}-windows${arch_suffix}/${path_prefix})

        SET(SDL2_LIBRARY_TEMP ${SDL2_LIBRARY_TEMP} ${installed_prefix}/lib/samplerate.lib)
    else()
        SET(SDL2_LIBRARY_TEMP ${SDL2_LIBRARY_TEMP} -lsamplerate)
    endif()
endif()

if(VBAM_STATIC)
    set(VBAM_SDL2_LIBS SDL2::SDL2-static ${SDL2_LIBRARY_TEMP})
else()
    set(VBAM_SDL2_LIBS SDL2::SDL2        ${SDL2_LIBRARY_TEMP})
endif()

if(ENABLE_FFMPEG)
    if(NOT FFMPEG_LIBRARIES)
        message(FATAL_ERROR "ENABLE_FFMPEG was specified, but required versions of ffmpeg libraries cannot be found!")
    endif()

    if(APPLE)
        list(APPEND FFMPEG_LDFLAGS "SHELL:-framework CoreText" "SHELL:-framework ApplicationServices")

        if(UPSTREAM_RELEASE)
            list(APPEND FFMPEG_LDFLAGS -lbz2 -ltiff "SHELL:-framework DiskArbitration" -lfreetype -lfontconfig -llzma -lxml2 -lharfbuzz)
        endif()
    elseif(WIN32)
        set(WIN32_MEDIA_FOUNDATION_LIBS dxva2 evr mf mfplat mfplay mfreadwrite mfuuid amstrmid)
        list(APPEND FFMPEG_LIBRARIES secur32 bcrypt ${WIN32_MEDIA_FOUNDATION_LIBS})

        if(MSYS AND VBAM_STATIC)
            foreach(lib tiff jbig lzma)
                cygpath(lib "$ENV{MSYSTEM_PREFIX}/lib/lib${lib}.a")

                list(APPEND FFMPEG_LIBRARIES "${lib}")
            endforeach()
        endif()
    endif()
else()
    add_compile_definitions(NO_FFMPEG)
endif()

if(ENABLE_LINK)
    # IPC linking code needs sem_timedwait which can be either in librt or pthreads
    if(NOT WIN32)
        find_library(RT_LIB rt)
        if(RT_LIB)
           set(CMAKE_REQUIRED_LIBRARIES ${CMAKE_REQUIRED_LIBRARIES} ${RT_LIB})
           set(VBAMCORE_LIBS ${VBAMCORE_LIBS} ${RT_LIB})
        endif()
    endif()

    include(CheckFunctionExists)
    check_function_exists(sem_timedwait SEM_TIMEDWAIT)
    if(SEM_TIMEDWAIT)
        add_compile_definitions(HAVE_SEM_TIMEDWAIT)
    endif()
else()
    add_compile_definitions(NO_LINK)
endif()

# for now, only GBALink.cpp uses gettext() directly
if(APPLE)
    # use Homebrew gettext if available
    if(EXISTS "/usr/local/opt/gettext")
        set(CMAKE_INCLUDE_PATH "${CMAKE_INCLUDE_PATH};/usr/local/opt/gettext/include")
        set(CMAKE_LIBRARY_PATH "${CMAKE_LIBRARY_PATH};/usr/local/opt/gettext/lib")
        set(CMAKE_PROGRAM_PATH "${CMAKE_PROGRAM_PATH};/usr/local/opt/gettext/bin")
    endif()
endif()

if(ENABLE_LINK OR ENABLE_WX)
    find_path(LIBINTL_INC libintl.h)
    find_library(LIBINTL_LIB    NAMES libintl    intl)
    find_library(LIBICONV_LIB   NAMES libiconv   iconv)
    find_library(LIBCHARSET_LIB NAMES libcharset charset)
    if(LIBINTL_LIB)
        list(APPEND CMAKE_REQUIRED_LIBRARIES ${LIBINTL_LIB})
        list(APPEND NLS_LIBS                 ${LIBINTL_LIB})
    endif()
    if(LIBICONV_LIB)
        list(APPEND CMAKE_REQUIRED_LIBRARIES ${LIBICONV_LIB})
        list(APPEND NLS_LIBS                 ${LIBICONV_LIB})
    endif()
    if(LIBCHARSET_LIB)
        list(APPEND CMAKE_REQUIRED_LIBRARIES ${LIBCHARSET_LIB})
        list(APPEND NLS_LIBS                 ${LIBCHARSET_LIB})
    endif()
    include(CheckFunctionExists)
    check_function_exists(gettext GETTEXT_FN)
    if(NOT (LIBINTL_INC OR GETTEXT_FN))
        message(FATAL_ERROR "NLS requires libintl/gettext")
    endif()
endif()

